/* matrixtastatur.c

Beispielcode um Matrixtastatur abzufragen

 */

#define ATMEGA2560

#ifdef ATMEGA644
#define F_CPU 20000000
#else
#define F_CPU 16000000
#endif
#ifdef LCD_SIMULATOR
#define PIN_SIMULATION
#define TASTEN_SIMULATION
#include "lcdsim.cc"
#else
#include <avr/io.h>
#endif
#include "lcd_treiber.c"

#define PORT_MATRIXOUT PORTE //Mit Spalten verbundener Port
#define DDR_MATRIXOUT  DDRE

#define PORT_MATRIXIN  PORTF //Mit Reihen verbundener Port
#define PIN_MATRIXIN   PINF
#define DDR_MATRIXIN   DDRF
#define NREIHEN 5
#define NSPALTEN 6

#ifdef LCD_SIMULATOR
#include "matrixsim.cc"
#endif

void init_matrix()
{
 PORT_MATRIXOUT=0xFF; //Pullup-Widerstaende setzen
 PORT_MATRIXIN=0xFF;  //Pullup-Widerstaende setzen
 DDR_MATRIXOUT=0; //Ausgabe-Leitungen vorlaeufig auf Eingang setzen
 DDR_MATRIXIN=0;  //Eingabe-Leitungen auf Eingang setzen
#ifdef LCD_SIMULATOR
 matrix_init();
#endif
}

uint8_t matrix_einlesen()
{
 uint8_t spalte,reihe,nr=0,reihe_mal_n;
 for(spalte=0; spalte<NSPALTEN; spalte++)
  {
   DDR_MATRIXOUT = (1<<spalte);   //nur aktuelle Spalte DDR auf Ausgang
   PORT_MATRIXOUT = ~(1<<spalte); //nur aktuelle Spalte PORT auf 0 setzen
   MILLIWAIT(1);
   for(reihe=0,reihe_mal_n=0; reihe<NREIHEN; reihe++,reihe_mal_n+=NSPALTEN)
    {
     if((PIN_MATRIXIN&(1<<reihe))==0)
       {nr=reihe_mal_n+spalte+1;}
    }
  }
 DDR_MATRIXOUT = 0;
 PORT_MATRIXOUT = 0xFF;
 return nr;
}

uint8_t check_matrix()
{
 uint8_t nr;
 nr=matrix_einlesen();
 if(nr==matrix_einlesen()) //gleicher Wert bei erneutem Einlesen?
  return nr; //ja: entprellte Taste
 return 0; //nein: noch nicht entprellt
}

int main (void)
{
 uint8_t x=0;
 char text[40];
 glcd_init();				// init des LCD
 glcd_clear();				// LCD loeschen
 glcd_licht(true);			// beleuchtung einschalten
 init_matrix();

 while (true)
  {
   x=check_matrix();
   if(x!=0)
    {
     sprintf(text,"Taste %d gedrueckt.   ",x);
     glcd_moveto(0,16);
     glcd_print(text);
     //matrixtasten[2]=1;//test
     while(check_matrix()!=0) ;//warte bis Taste wieder losgelassen
    }
   else
    {
     glcd_moveto(0,16);
     glcd_print("keine Taste gedrueckt");
     //matrixtasten[2]=0;//test
    }
   MILLIWAIT(500); //0.5 Sek lang warten
  }
 return 0;
}
