// mk3_tastenmatrix.c
// zum einfuegen in tarech2.cc
// Am MK3-Board: Tastenmatrix an F2-F7 und E0-E4

// Die Kommentare "Spalten" und "Reihen" beziehen sich auf eine Querformat-Tastatur.
// Nicht umkommentieren, denn im Hauptprogramm ist waehlbar ob Quer- oder Hochformat gewuenscht ist.

#define PORT_MATRIXOUT PORTF //Mit Spalten verbundener Port
#define DDR_MATRIXOUT  DDRF
#define MATRIXOUT_MASKE 0xFC
#define SHIFT2 2 //muss um soviele Bits geschoben werden weil nicht bei Bit 0 beginnend

#define PORT_MATRIXIN  PORTE //Mit Reihen verbundener Port
#define PIN_MATRIXIN   PINE
#define DDR_MATRIXIN   DDRE
#define MATRIXIN_MASKE 0x1F
#define NREIHEN 5
#define NSPALTEN 6

void init_matrix()
{
 DDR_MATRIXOUT &= ~MATRIXOUT_MASKE; //Ausgabe-Leitungen vorlaeufig auf Eingang setzen
 DDR_MATRIXIN &= ~MATRIXIN_MASKE;  //Eingabe-Leitungen auf Eingang setzen
 PORT_MATRIXOUT |= MATRIXOUT_MASKE; //Pullup-Widerstaende setzen
 PORT_MATRIXIN |= MATRIXIN_MASKE;  //Pullup-Widerstaende setzen
}

void matrixwait() //so in etwa 100us warten
{
 volatile int8 i;
 for(i=0;i<100;i++) {}
}

uint8_t matrix_einlesen()
{
 uint8_t spalte,reihe,nr=0,reihe_mal_n;
 DDR_MATRIXOUT |= MATRIXOUT_MASKE;   //Ausgabeport auf Ausgang
 PORT_MATRIXOUT |= MATRIXOUT_MASKE;  //alle Ausgaenge auf 1 setzen
 for(spalte=0; spalte<NSPALTEN; spalte++)
  {
   PORT_MATRIXOUT &= ~(1<<(spalte+SHIFT2)); //nur aktuelle Spalte PORT auf 0 setzen
   matrixwait();
   for(reihe=0,reihe_mal_n=0; reihe<NREIHEN; reihe++,reihe_mal_n+=NSPALTEN)
    {
     if((PIN_MATRIXIN&(1<<reihe))==0)
      {nr=reihe_mal_n+spalte+1; break;}
    }
   PORT_MATRIXOUT |= MATRIXOUT_MASKE; //alle Ausgaenge wieder auf 1 setzen
  }
 DDR_MATRIXOUT &= ~MATRIXOUT_MASKE; //Ausgabeport wieder auf Eingang
 return nr;
}
