//*************************************************************
//*** FUNCTIONS FOR EEPROM READ/WRITE ON I2C COMMUNICATION  ***
//*************************************************************
//Controller:	ATmega128 (16Mhz Crystal)
//Compiler:		ICCAVR 
//Author:		CC Dharmani, Chennai (INDIA)
//			www.dharmanitech.com
//Date:			Aug 2008

//Rolf Pfister: getestet auf ATmega8 (3.6864 MHz) und ATmega644 (16MHz)
//Offensichtliche Fehler korrigiert: 31.10.2010
//Vereinfachte Variante und schoener formatiert: 1.11.2010
//13.11.2010  zusaetzlicher Parameter in rtc_write() und rtc_read()
//            imax = Anzahl zu lesende/schreibende Bytes

//*************************************************************
#include "rtc.h"
#include "i2c.h"

unsigned char rtc_i2c_start()
{
 unsigned char error;
 error = i2c_start();                       if(error) {return error;}
 error = i2c_sendAddress(DS1307_W);         if(error) {return error;}
 return  i2c_sendData(0x00);
}

//***************************************************************************
//Function to set initial address of the RTC for subsequent reading / writing
//***************************************************************************

unsigned char rtc_write(char *rtc_register,unsigned char imax)
{
 unsigned char error, i;

 error = rtc_i2c_start();                   if(error) {i2c_stop(); return error;}

 for(i=0;i<imax;i++)
   {
    error = i2c_sendData(rtc_register[i]);  if(error) {i2c_stop(); return error;}
   }

 i2c_stop();
 return RTC_NO_ERROR;
}

//***********************************************************************
//Function to read RTC registers and store them in buffer rtc_register[]
//***********************************************************************    
unsigned char rtc_read(char *rtc_register,unsigned char imax)
{
 unsigned char error, i, data;

 error = rtc_i2c_start();                   if(error) {i2c_stop(); return error;}
 error = i2c_repeatStart();                 if(error) {i2c_stop(); return error;}
 error = i2c_sendAddress(DS1307_R);         if(error) {i2c_stop(); return error;}

 for(i=0;i<imax;i++)
   {
    if(i == imax-1) data = i2c_receiveData_NACK();
    else            data = i2c_receiveData_ACK();

    if(data == ERROR_CODE)                       {i2c_stop(); return(RTC_ERROR);}

    rtc_register[i] = data;
   }
	
 i2c_stop();
 return (RTC_NO_ERROR);
}

//****************************************************************************
//Function to read only second from RTC
//****************************************************************************
char rtc_readsecond()
{
 unsigned char error; char data;
 error = rtc_i2c_start();            if(error) {i2c_stop(); return ERROR_CODE;}
 error = i2c_repeatStart();          if(error) {i2c_stop(); return ERROR_CODE;}
 error = i2c_sendAddress(DS1307_R);  if(error) {i2c_stop(); return ERROR_CODE;}
 data = i2c_receiveData_NACK();
 i2c_stop();
 return data;
}
