/* vorsch.cc			letzte nderung: 28.12.2005 */
#define VERSION "Version 0.0"
/* Kurzbeschreibung: erzeugen von HTML-Datei fuer Bildervorschau
Uebersetzen:
;> c++ Vorsch.cc h:amigalib.a -o Vorsch

27.12.2005	Erstellung, Rolf Pfister
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

static char *pfad="CostaRica";

/************************* Kleinkram ***************************/
int index(char *s1,char *s2) /* Sucht den String s2 innerhalb von s1 und  */
{			     /* gibt Position zurueck (nicht gefunden: -1)*/
 int i,c;
 char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

char *namelesen(FILE *fp)
{
 static char name[200];
 *name=0;
 do {fscanf(fp,"%s",name);
     if(*name==0) return NULL;
    }
 while(index(name,".")<1);
 return name;
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 4
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80],titel[80];
 FILE *fp1,*fp2,*fp3=NULL;
 int i,j,c,breite=0,tmpflag=0;
 quellname[0]=zielname[0]=titel[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
		 else if(j==3) sscanf(argv[i],"%d",&breite);
		 else if(j==4) strcpy(titel,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("vorsch  %s\n",VERSION);
	 printf("Anwendung: vorsch reihenfolge.txt ziel.html [Bildbreite] [Titel]\n");
	 exit(0);
	}
 if(*quellname==0)
   {printf("reihenfolge-Datei (erzeugt mit ls -tr >datei.txt):");
    scanf("%s",quellname);
   }
 else if(strcmp(quellname,"ls")==0)
   {system("ls -tr *.jpg >tmp.dat");
    strcpy(quellname,"tmp.dat");
    tmpflag=1;
   }
 if(*zielname==0)  {printf("Zielname:"); scanf("%s",zielname);}
 if(fp1=fopen(quellname,"r")) ;
 else {printf("Datei '%s' nicht vorhanden\n",quellname); return 0;}
 if(fp2=fopen(zielname,"r"))
   {printf("Datei '%s' schon vorhanden - nichts gespeichert.\n",zielname);
    fclose(fp1);
    return 0;
   }
 if(fp2=fopen(zielname,"w")) ;
 else {printf("kann Datei '%s' nicht erstellen\n",zielname); fclose(fp1); return 0;}

 char *name,vname[80];
 if(breite>0)
 {
 int nbilder=1200/breite;
 if(*titel==0) strcpy(titel,"Titel");
 fprintf(fp2,"<HTML>\n<HEAD><TITLE>%s</TITLE></HEAD>\n<BODY>\n",titel);
 fprintf(fp2,"<H1>%s</H1>\n<P>\n",titel);
 for(i=1;(name=namelesen(fp1))!=NULL;i++)
   {fprintf(fp2,"<a href=\"%s\"><img src=\"%s\" width=%d> </a>",
	    name,name,breite);
    if(i%nbilder==0) fprintf(fp2,"<br>\n"); else fprintf(fp2,"\n");
   }
 fprintf(fp2,"<HR>\n</BODY>\n</HTML>\n");
 }
 else
 {
 fprintf(fp2,"<HTML>\n<HEAD><TITLE>Vorschau</TITLE></HEAD>\n<BODY>\n");
 for(i=0;(name=namelesen(fp1))!=NULL;i++)
  {if(i%10==0)
      {if(i>0)
         {fprintf(fp2,"</a>\n");
	  if(fp3)
	   {fprintf(fp3,"<tr>\n</table>\n</body>\n</html>\n"); fclose(fp3);}
	 }
       fprintf(fp2,"\n<p>\n<a href=\"vorschau%d.html\">\n",i/10);
       sprintf(vname,"vorschau%d.html",i/10);
       if((fp3=fopen(vname,"r"))!=NULL)
         {fclose(fp3); fp3=NULL;
	  printf("%s schon vorhanden - nicht ueberschrieben.\n",vname);}
       else
         {fp3=fopen(vname,"w");
	  fprintf(fp3,"<html>\n<head><TITLE>%s</TITLE></HEAD>\n",vname);
	  fprintf(fp3,"<body>\n<p>\n<table border=0>\n");
	 }
      }
   if(index(name,"IMG")<0)
       fprintf(fp2,"<img src=\"klein/t%s\" height=60>\n",name);
   else fprintf(fp2,"<img src=\"klein/t%s\">\n",name);
   if(fp3) fprintf(fp3,"<td><a href=\"%s/%s\"><img src=\"klein/t%s\"></a>\n",
		   pfad,name,name);
  }
 fprintf(fp2,"</a>\n</BODY>\n</HTML>\n");
 if(fp3) {fprintf(fp3,"<tr>\n</table>\n</body>\n</html>\n"); fclose(fp3);}
 }

 fclose(fp1); fclose(fp2);
 if(tmpflag) system("rm tmp.dat");
 return 0;
}/* ende von main */
