/* kleinkram.cc			letzte nderung: 30.1.2000 */
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>

/*************************** kleinkram ***************************/

/*********************** Zufallszahlen ***************************/
inline double random11()	// Zufallszahl zwischen -1. und 1.
{
 return (1. - rand()/1073741824.);//Variante fuer VAX/ALPHA
}
inline double random01()        // Zufallszahl zwischen 0. und 1.
{
 return (1. - rand()/(double)RAND_MAX);//Variante fuer VAX/ALPHA
}

double zufall(double y=0.);
double zufall(double y)  /* liefert Zufallszahl zwischen 0.0 und 1.0      */
{			 /* ergibt aber Streifen im Flchentest in rndcheck */
 static double x=1.3757;
 if(y!=0.) x=y;
 x=(100.+x)/(100.*(x-(long)(x))+0.7);
 y=10.*x;
 return (y-(long)(y));
}

double zufall3()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* ergibt aber Unregelmssigkeiten im Zombitest */
 static double x=1.7;
 double y;
 if(x==0.) x=1.7;
 if(x>100.) x=x/1163.;
 else x*=773.;
 y=10.*(x-(long)(x));
 return (y-(long)(y));
}

double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

/************************* Stringfunktionen *************************/

void getzeile(FILE *fp,char *s)
{		/* liest Zeile samt Zeilentrenner und schliesst mit 0 ab */
 while ((*s++ = getc(fp)) != '\n')
	;
 *s=0;
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void putline(FILE *fp,char *s)	/* wie fprintf(fp,"%s\n",s)		*/
{				/* aber ohne ein Nullbyte zu schreiben	*/
 char c;
 while(c= *s++)  putc(c,fp);
 putc('\n',fp);
}

int ascitodigit(int c)
{		/* wandelt ein ASCI-Zeichen in eine 1-stellige Hex-Zahl */
 if(!isxdigit(c)) return 0;
 if(islower(c)) c=toupper(c)-'0';
 else c-='0';
 if(c>9) c += '0'-'A'+10;
 return c;
}

char *ohnepunkt(char *name)  /* in Filename die Erweiterung .xxx loeschen */
{
 char c,*s=name;
 while((c= *s)!='.' && c!=0) s++;
 if(c=='.') *s='\0';
 return name;
}

int hatpunkt(char *name,int c='.')
{
 int c2;
 while(c2= *name++) if(c2==c) return 1;
 return 0;
}

void stradd(const char *s,const char *t,char *z)	/*  s + t --> z */
{
 char c;
 while (c = *s++) *z++ = c;
 while (*z++ = *t++)	;
}

void spri(char *s,char *cstr,long x=0L,long y=0L,long z=0L)
{			/* wie sprintf(s,cstr,x,y,z) aber ohne Nullbyte */
 char c,*p;
 char *hstr=new char[80];
 sprintf(hstr,cstr,x,y,z);
 for(p=hstr; c= *p++;)  *s++ = c;
 delete hstr;
}

int linput(FILE *fp,char *str,int lim,int c,char *zeigerfeld[])
{		/* Liest eine Zeile ein und erzeugt     */
		/* einen Zeiger auf jedes Element, das  */
		/* jeweils mit '\0' abgeschlossen wird. */
		/* lim=Laenge von str  c=Trennzeichen (z.B.',') */
		/* das Zeigerfeld muss genug lang sein */
 char *p;
 int anf=0,i;
 if(!getline(fp,str,lim)) return EOF;
 for(p=str,i=0; *p!=0; i++)
   {zeigerfeld[i]=p;
    while(*p==' ' || *p=='\t')	p++;
    if(*p=='"' || *p=='\'')
	{anf= *p++; zeigerfeld[i]=p;}
    while(*p!=0 && *p!=c)
	{if(*p==anf) *p=0;
	 p++;
	}
    if(*p==c) *p++=0;
   }
 zeigerfeld[i]=NULL;
 return i;
}

int strcmpg(char *s,char *t)
{       /* Stringvergleich ohne Gross-Klein Unterscheidung */
 int c1,c2;
 do     {c1= *s++; c2= *t++;
         if(c1==0 && c2==0) return 0;/* Strings gleich */
         if(c1!=c2)
           {if(isupper(c1)) c1=tolower(c1);
            if(isupper(c2)) c2=tolower(c2);
        }  }
 while(c1==c2);
 return c1-c2;/* ungleich */
}

char *machgross(char *s)
{
 char *t;
 int c;
 t=s;
 while(c= *t)  *t++ = toupper(c);
 return s;
}

int index(char *s1,char *s2) /* Sucht den String s2 innerhalb von s1 und  */
{			     /* gibt Position zurueck (nicht gefunden: -1)*/
 int i,c;
 char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

char *strkopie(char *s1)
{
 char *s=new char[strlen(s1)+1], *t;
 for(t=s;*t++ = *s1++;)  ;
 return s;
}

/************************* Grafikfunktionen *************************/
const PENUP=3;
const PENDOWN=2;
extern void plot(double,double,int);
static double	cosalfa=0.994521895368273,
		sinalfa=0.104528463267653;
static int	n_ecken=60;
void initkreis(int n)	/* initialisiert schnellen Kreisalgorythmus */
{			/* mit Verwendung eines n-Ecks		    */
 double alfa;
 alfa=6.283185307/(n_ecken=n);
 cosalfa=cos(alfa); sinalfa=sin(alfa);
}
void kreis(double x,double y,double r)	/* zeichnet Kreis */
{
 double dx,dx2,dy;
 int m;
 dx=0.; dy=r;
 plot(x+dx,y+dy,PENUP);
 for (m=n_ecken;m>0;--m)
	{dx2=dx*cosalfa+dy*sinalfa;
	 dy= dy*cosalfa-dx*sinalfa;
	 dx=dx2;
	 plot(x+dx,y+dy,PENDOWN);
	}
}

/************************* Astronomie *************************/
static int montab[]={31,28,31,30,31,30,31,31,30,31,30,31};

int jahrestag(int tag,int monat,int jahr)  /* bestimmt n-ten Tag im Jahr */
{
 int jtag,i;
 if(jahr%4==0 && jahr%100!=0 || jahr%400==0)	montab[1]=29;
 else						montab[1]=28;
 for(i=monat-2,jtag=tag; i>=0; i--)
	{jtag += montab[i];}
 return jtag;
}

void datum(int tag,int jahr,int *pmtag,int *pmonat)
{			/* bestimmt Datum des n-ten Tags im Jahr */
 int i=0;
 if(jahr%4==0 && jahr%100!=0 || jahr%400==0)	montab[1]=29;
 else						montab[1]=28;
 while(tag>montab[i]) tag -= montab[i++];
 *pmonat=i+1; *pmtag=tag;
}

/************************* Einzeiler *************************/
inline double sq(double x) {return x*x;}	/* Quadrieren */
inline long idfix(double x) {return (x>=0.) ? x+0.5 : x-0.5;} /* Runden */
inline double abs(double x) {return (x<0.) ? -x : x;}	/* Betrag */

/************************* Konstanten *************************/
const double Pi =	3.14159265358979;
const double ZWEIPI =	6.28318530717959;
const double PI = 4*atan(1.0), ZWEIPI=2*PI;
const double E	=	2.71828182845905;
#define WURZ10  3.16227766016838

/************************ Zahlen jonglieren ************************/

double rundezahl(double x,double y)  /* eine Runde Zahl zwischen x und y */
{
 static double rund[]={5.,8.,6.,4.,2.,9.,7.,3.,1.};
 double z1,z2,z3;
 int i;
 if(x<0.) return -rundezahl(-x,-y);
 if(y<0.) return 0.;
 if(x<y) {z1=x; x=y; y=z1;}
 if(x>=1.) /* 1 10 100 1000 ... */
  {for(z1=1.;z1<=x; z1*=10.)  if(z1>=y) return z1;
   z1/=10.;
  }
 else      /* 0.1 0.01 0.001 .... */
  {for(z1=0.1;z1>=y; z1*=0.1)  if(z1<=x) return z1;
  }
 for(i=0;i<8;i++) /* Test auf Gleichheit der ersten Ziffer */
        if((z2=z1*rund[i])<=x && z2>=y) return z2;
 for(z2=z1+z1;z2<x;z2+=z1)
        ;
 z2-=z1; /* z2 = erste Ziffer */
 while(z1>0.)
  {z1/=10.;
   for(i=0;i<9;i++)
        if((z3=rund[i]*z1+z2)<=x && z3>=y) return z3;
   for(z3=z1;z2+z3<x;z3+=z1)
                ;
   z2+=z3-z1;
  }
 return y; /* Fehler: x==y, keine runde Zahl */
}

double dmod(double x,double y)	/* Rest einer Fliesszahldivision */
{
 int n;
 n=x=x/y;
 return (x-n)*y;
}

double xhochn(double x,int n)	/* Potenzieren mit Ganzzahligem Exponenten */
{
 double z=1.0;
 if(n>=0)
   while(n>0)
        {if(n&1) {z*=x; n--;}
         else    {x*=x; n=(n>>1);}
        }
 else
        z=1.0/xhochn(x,-n);
 return z;
}

int fastgleich(double x,double y,double diff)
{		/* Teste ob x==y innerhalb der Genauigkeit diff */
 double d;
 if(diff<0.) diff= -diff;
 if(x>y) d=x-y; else d=y-x;
 return (d<diff);
}

/********************** Fouriertransformation ****************************/
void bitschuettler(double *rfeld,double *ifeld,int n)
{
 register int m,k,j; double hr,hi;
 for(j=1;j<n-1;j++)
    {k=0; m=j+n;
     do	{k += k + (m&1);	/* unterstes Bit von m links ins k schieben */
	 m >>= 1;		/* m 1 Bit nach rechts schieben */
	}
     while (m>1);	/* k= Bitreverse(j) */
      if (k<j)	{hr= rfeld[j]; hi= ifeld[j];
		 rfeld[j]= rfeld[k]; ifeld[j]= ifeld[k];
		 rfeld[k]= hr; ifeld[k]= hi;
    }		}
}
void fft(double *rfeld,double *ifeld,int *pn,int *pinv)
{
 int n= *pn, inv= *pinv, k,zweik,m;
 register int i,j;
 double a,treal,timag,wreal,wimag;
/* if(n>=4) j=n; else j=3;
/* while (j%2==0) j/= 2;	/* n auf die Form 2^k testen */
/* if(j!=1)  { printf("Error: ungueltiges n:%d",n); exit();} */
 bitschuettler(rfeld,ifeld,n);
 for(k=1; k<n; k=zweik)
  {zweik=k+k;
   for (m=0; m<k; m++)
       {wreal= cos(a=m*PI/k);
	wimag= (inv==1) ? sin(a) : -sin(a);
	for (i=m; i<n; i+= zweik)
	  {j=i+k;
	   treal= wreal*rfeld[j] - wimag*ifeld[j];
	   timag= wreal*ifeld[j] + wimag*rfeld[j];
	   rfeld[j]= rfeld[i]-treal; ifeld[j]= ifeld[i]-timag;
	   rfeld[i] += treal; ifeld[i] += timag;
  }    }  }
 if(inv==1)
	for(i=0;i<n;i++) {rfeld[i] /= n; ifeld[i] /= n;}
}

void dft(int nn,int inv,double *a,double *b,double *ya,double *yb)
{
 double m2pi,z,sinz,cosz,*pa,*pb;
 int m,n,Nhalbe=nn/2;
 for(m=0;m<nn;m++)
  {if(inv) m2pi= m*PI/Nhalbe;
   else m2pi= -m*PI/Nhalbe;
   *ya = *a;
   *yb = *b;
   for(pa=a,pb=b,n=0;++n<nn;)
	{z=n*m2pi;
	 *ya += *++pa*(cosz=cos(z)) - *++pb*(sinz=sin(z));
	 *yb += *pa*sinz + *pb*cosz;
	}
   if(inv) {*ya++ /= nn;  *yb++ /= nn;}
   else    {ya++; yb++;}
  }
}

/************************** Ein/Ausgaben *********************************/
void inputd(char *s,int *x) {printf("(%d) %s",*x,s); scanf("%d",x);}
void inputf(char *s,double *x) {printf("(%lf) %s",*x,s); scanf("%lf",x);}
