/* vorschau.cc			letzte nderung: 25.7.2003 */
#define VERSION "Version 0.0"

/*
Kurzbeschreibung: html-Datei erstellen zur Vorschau von verkleinerten Bildern.
Voraussetzungen: Die Bilder wurden schon verkleinert und in klein/tname
und klein/mname gespeichert. (mit dem Script 'verkleinern').

History:
25.7.2003	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/************************* Vordeklarationen ***************************/

/*************************** kleinkram ***************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char zeile[120],zielname[80];
 FILE *fp1,*fp2;
 int i,j,c;
 zielname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("vorschau  %s\n",VERSION);
	 printf("Anwendung: vorschau [Ziel]\n");
	 printf("   Flags: k=klein/k* verwenden\n");
	 printf("          p=php-Script als Links einsetzen\n");
	 exit(0);
	}
 if(*zielname==0)  {strcpy(zielname,"vorschau.html");}
 if(fp2=fopen(zielname,"r"))
   {printf("Datei '%s' schon vorhanden - Ueberschreiben ?",zielname);
    scanf("%s",zeile); c=zeile[0];
    fclose(fp2);
    if(c=='n' || c=='N') exit(0);
   }
 fp2=fopen(zielname,"w");
 if(fp2==NULL) {printf("kann '%s' nicht erstellen\n",zielname); exit(0);}
 fprintf(fp2,"<HTML>\n<HEAD><TITLE>vorschau</TITLE></HEAD>\n<BODY>\n");
 char grossordner[80]; *grossordner=0;
 if(argflag['K'])
   {system("ls -1 klein/k* >tmp.dat");
     printf("Ordner mit grossen Bilddateien:"); scanf("%s",grossordner);
   }
 else
   system("ls >tmp.dat klein/t*");
 fp1=fopen("tmp.dat","r");
 if(fp1==NULL)
   {printf("kann 'tmp.dat' nicht wiederfinden\n"); fclose(fp2); exit(0);}
 for(j=0;getline(fp1,zeile,120);j++)
   {if(j%10==0) fprintf(fp2,"<BR>%s<BR>\n",&zeile[7]);
    if(*grossordner==0)
      fprintf(fp2,"<A HREF=\"%s\"><IMG SRC=\"%s\"></A>\n",&zeile[7],zeile);
    else if(argflag['P'])
      fprintf(fp2,"<A HREF=\"bildschau.php?ort=%s&nr=%4.4s\"><IMG SRC=\"%s\"></A>\n",
	      grossordner,&zeile[7],zeile);
    else
      fprintf(fp2,"<A HREF=\"%s/%s\"><IMG SRC=\"%s\"></A>\n",
	      grossordner,&zeile[7],zeile);
   }
 fclose(fp1);
 fprintf(fp2,"</BODY>\n</HTML>\n");
 fclose(fp2);
 return 0;
}/* ende von main */
