/* slicer.cc			letzte Aenderung: 20.10.2013 */
#define VERSION "Version 0.0"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: auspropieren eines eigenen 3D-Slicer-Programms

History:
17.10.2013       Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <xtekplot1.h>
//#include <vektor3dklasse.cc>
// Bei Fehler wegen fehlendem <math3.h> sollte "vektor3dklasse.cc" in xtekplot aktualisiert werden.
#include "vektor3dshort.cc"

//typedef unsigned int uint;
typedef unsigned char uchar;

#define XMAX 1024
#define YMAX  820
#define TIEFE 24
//#define TIEFE 8

/************************* Vordeklarationen ***************************/
void slicer(FILE *fp,const char *name);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/****************************** kleinkram *****************************/
bool little_endian=true;

bool check_endianess() //true if little endian
{
 char *a;
 float f = 3.14159;  // number to start with
 a = (char *)&f;    // point a to f's location
 if(argflag['V'])
  {
   printf("float: %f  ", f); // print float & byte array as hex
   printf("byte array: %hhX:%hhX:%hhX:%hhX\n", a[0], a[1], a[2], a[3]);
  }
 return ((a[0]&0xFF)==0xD0);
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

int index(const char *s1,const char *s2)
{	             /* Sucht den String s2 innerhalb von s1           */
 int i,c;	     /* und gibt Position zurueck (nicht gefunden: -1) */
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

/************** Klassen und Routinen fuer Hauptarbeit *****************/
const double mm=1/0.1; //Umrechnungsfaktor von mm in Druckeraufloesung (hier 0.1 mm)

class Dreieck
{
public:
 Vektor3dshort p1,p2,p3;
 void init(Vektor3dshort a1,Vektor3dshort a2,Vektor3dshort a3) {p1=a1; p2=a2; p3=a3;}
 int schnittpunkte(int_16 z); //Schnittpunkte zur Ebene z suchen
 Vektor3dshort schnittpunkt(int_16 z,Vektor3dshort& p1,Vektor3dshort& p2); //Schnittpunkt ausrechnen
 void schnittpunkte_bestimmen_fall1(int_16 z,Vektor3dshort& q1,Vektor3dshort& q2);
 void schnittpunkte_bestimmen_fall2(int_16 z,Vektor3dshort& q1,Vektor3dshort& q2);
};

Vektor3dshort Dreieck::schnittpunkt(int_16 z,Vektor3dshort& p1,Vektor3dshort& p2)
{
 Vektor3dshort v;
 double A;
 //printf("Testpunkt: Dreieck::schnittpunkt(z=%d,p1=[%d %d %d],p2=[%d %d %d])\n",z, p1.x,p1.y,p1.z, p2.x,p2.y,p2.z);//test
 v = p2-p1;
 A=(z-p1.z)/(double)(v.z);
 //printf("  A=%f\n",A);//test
 v *= A;
 //printf(" return (p1+v);\n");//test
 return (p1+v);
}

int Dreieck::schnittpunkte(int_16 z)
{
 //suche Schnittpunkte zur Ebene z
 if(p1.z==z && p2.z==z && p3.z==z) return 3; //alle 3 Eckpunkte liegen auf der Ebene
 if(p1.z < z)
  {
   if(p2.z > z || p3.z > z)
    {
     if(p2.z >= z && p3.z >= z) return 1; //Fall1: nur 1 Eckpunkt unterhalb der Ebene, mindestens einer darueber
     else if(p2.z < z || p3.z < z) return 2; //Fall2: 2 Eckpunkte unterhalb, einer darueber
    }
   else if(p2.z==z && p3.z==z) return 4; //Fall4: 2 Punkte auf der Ebene, einer darunter
   else return 0; //Alle Punkte unterhalb oder hoechstens einer auf der Ebene
  }
 else if(p2.z < z)
  {
   if(p1.z > z || p3.z > z)
    {
     if(p3.z >= z) return 1; //Fall1: nur 1 Eckpunkt unterhalb der Ebene, mindestens einer darueber
     else return 2; //Fall2: 2 Eckpunkte unterhalb, einer darueber
    }
   else if(p1.z==z && p3.z==z) return 4; //Fall4: 2 Punkte auf der Ebene, einer darunter
   else return 0; //Alle Punkte unterhalb oder hoechstens einer auf der Ebene
  }
 else if(p3.z < z)
  {
   if(p1.z > z || p2.z > z) return 1; //Fall1: nur 1 Eckpunkt unterhalb der Ebene, mindestens einer darueber
   else return 4; //Fall4: 2 Punkte auf der Ebene, einer darunter
  }
 else if(p1.z==z && p2.z==z) return 5; //Fall5: 2 punkte auf der Ebene, einer darueber
 else if(p1.z==z && p3.z==z) return 5; //Fall5: 2 punkte auf der Ebene, einer darueber
 else if(p2.z==z && p3.z==z) return 5; //Fall5: 2 punkte auf der Ebene, einer darueber
 return 0; //sonst: alle Punkte ueber der Ebene, oder hoechstens einer auf der Ebene
}

void Dreieck::schnittpunkte_bestimmen_fall1(int_16 z,Vektor3dshort& q1,Vektor3dshort& q2)
{
 //Fall1: p1 unterhalb der Ebene, q1 soll Schnittpunkt zwischen p1 und p2 sein, q2 zwischen p1 und p3
 //printf("Testpunkt: schnittpunkte_bestimmen_fall1()\n");//test
 if(p2.z==z) q1=p2;             //p2 auf der Ebene
 else q1=schnittpunkt(z,p1,p2); //oder p2 darueber
 if(p3.z==z) q2=p3;             //p3 auf der Ebene
 else q2=schnittpunkt(z,p1,p3); //oder p3 darueber
 //printf("  schnittpunkte_bestimmen_fall1 return\n");//test
}

void Dreieck::schnittpunkte_bestimmen_fall2(int_16 z,Vektor3dshort& q1,Vektor3dshort& q2)
{
 //Fall2: p1 liegt oberhalb der Ebene, p2 und p3 auf oder unterhalb der Ebene
 if(p2.z==z) q1=p2;             //p2 auf der Ebene
 else q1=schnittpunkt(z,p2,p1); //oder p2 unterhalb
 if(p3.z==z) q2=p3;             //p3 auf der Ebene
 else q2=schnittpunkt(z,p3,p1); //oder p3 unterhalb
}

static Dreieck *dreieck=NULL; //Liste aller Dreiecke
uint anzahldreiecke=0; //von STL-Datei eingelesene Dreiecke

class Strecke
{
public:
 Vektor3dshort q1,q2;
 void init(Vektor3dshort& a,Vektor3dshort& b) {q1=a; q2=b;}
};
static Strecke *strecke=NULL;
static uint j_strecke=0;

static uint *dreieck_liste, ndreiecke=0; //Zuordnungs-Liste fuer Dreiecke auf der aktuellen Ebene
static uint *strecken_liste, nstrecken=0; //Zuordnungs-Liste fuer Strecken auf der Ebene
static uchar pixelebene[2000][2000]; //maximal 200 * 200 mm mit 0.1mm Aufloesung

void dreiecks_liste_anfuegen(uint j)
{
 dreieck_liste[ndreiecke++]=j;
}

void strecken_liste_anfuegen(Vektor3dshort& q1,Vektor3dshort& q2)
{
 strecke[j_strecke].init(q1,q2);
 strecken_liste[nstrecken++] = j_strecke++;
}

void minmax_werte_bestimmen(int_16* xmin,int_16* ymin,int_16* xmax,int_16* ymax,int_16* zmin,int_16* zmax)
{
 *xmin = *ymin =  *zmin = 32767;
 *xmax = *ymax =  *zmax = -32767;
 for(int j=0;j<anzahldreiecke;j++)
  {
   if(dreieck[j].p1.x < *xmin) *xmin=dreieck[j].p1.x;
   if(dreieck[j].p2.x < *xmin) *xmin=dreieck[j].p2.x;
   if(dreieck[j].p3.x < *xmin) *xmin=dreieck[j].p3.x;
   if(dreieck[j].p1.y < *ymin) *ymin=dreieck[j].p1.y;
   if(dreieck[j].p2.y < *ymin) *ymin=dreieck[j].p2.y;
   if(dreieck[j].p3.y < *ymin) *ymin=dreieck[j].p3.y;
   if(dreieck[j].p1.z < *zmin) *zmin=dreieck[j].p1.z;
   if(dreieck[j].p2.z < *zmin) *zmin=dreieck[j].p2.z;
   if(dreieck[j].p3.z < *zmin) *zmin=dreieck[j].p3.z;
   if(dreieck[j].p1.x > *xmax) *xmax=dreieck[j].p1.x;
   if(dreieck[j].p2.x > *xmax) *xmax=dreieck[j].p2.x;
   if(dreieck[j].p3.x > *xmax) *xmax=dreieck[j].p3.x;
   if(dreieck[j].p1.y > *ymax) *ymax=dreieck[j].p1.y;
   if(dreieck[j].p2.y > *ymax) *ymax=dreieck[j].p2.y;
   if(dreieck[j].p3.y > *ymax) *ymax=dreieck[j].p3.y;
   if(dreieck[j].p1.z > *zmax) *zmax=dreieck[j].p1.z;
   if(dreieck[j].p2.z > *zmax) *zmax=dreieck[j].p2.z;
   if(dreieck[j].p3.z > *zmax) *zmax=dreieck[j].p3.z;
  }
}

void float_einlesen(FILE *fp,float *p)
{
 union
   {float f;
    char  c[4];
   } u;
 if(little_endian)
   for(int i=0;i<4;i++) u.c[i]=getc(fp);
 else
   for(int i=3;i>=0;--i) u.c[i]=getc(fp);
 *p = u.f;
}

void stldatei_einlesen(FILE *fp,const char *name)
{
 char zeile[81];
 uchar c1,c2,c3,c4;
 double x,y,z;
 Vektor3dshort p1,p2,p3;
 int fehler=0, k,n;
 uint j;
 if(getline(fp,zeile,81))
  {
   if(strncmp(zeile,"solid",5)==0) //STL-Datei im ASCII-Format?
    {
     if(argflag['V']) printf("STL-Datei im ASCII-Format\n");
     for(k=0;k<2;k++) //Datei 2 mal einlesen, erstes Mal nur Dreiecke zaehlen
      {
       if(k==1)
	{
	 if(dreieck!=NULL) {printf("Programm-Fehler1: dreieck!=NULL)\n");}
	 dreieck=new Dreieck[anzahldreiecke];
	}
       j=0;
       while(getline(fp,zeile,80))
	{
	 if(index(zeile,"outer loop")>=0)
	  {
	   //jeweils 3 float einlesen, in Druckeraufloesung umrechnen und als Vektor speichern
	   if(getline(fp,zeile,80) && (n=index(zeile,"vertex"))>=0 && sscanf(&zeile[n+6],"%lf %lf %lf",&x,&y,&z)==3) p1=Vektor3dshort(idfix16(x*mm),idfix16(y*mm),idfix16(z*mm));
	   else {fehler++; printf("%s\n",zeile);}
	   if(getline(fp,zeile,80) && (n=index(zeile,"vertex"))>=0 && sscanf(&zeile[n+6],"%lf %lf %lf",&x,&y,&z)==3) p2=Vektor3dshort(idfix16(x*mm),idfix16(y*mm),idfix16(z*mm));
	   else {fehler++; printf("%s\n",zeile);}
	   if(getline(fp,zeile,80) && (n=index(zeile,"vertex"))>=0 && sscanf(&zeile[n+6],"%lf %lf %lf",&x,&y,&z)==3) p3=Vektor3dshort(idfix16(x*mm),idfix16(y*mm),idfix16(z*mm));
	   else {fehler++; printf("%s\n",zeile);}
	   if(fehler) {printf("Syntaxfehler in STL-Datei\n"); break;}//provi.
	   if(k==0) anzahldreiecke++;
	   else dreieck[j++].init(p1,p2,p3);
	  }
	 //else if(index(zeile,"endsolid")>=0) //nicht wirklich noetig
	 // {break;} //Ende der Datei erfolgreich erreicht
	 //else {}//hier koennte man noch weiter die Syntax ueberpruefen
	} //Ende der while-Schlaufe
       if(k==0)
	{
	 fclose(fp); fp=fopen(name,"r"); if(fp==NULL) printf("kann '%s' nicht wiederoeffnen\n",name);
	}
      } //Ende der for-Schlaufe
    }
   else //sonst binaeres STL-Format
    {
     if(argflag['V']) printf("STL-Datei im Binaeren Format\n");
     c1=getc(fp); c2=getc(fp); c3=getc(fp); c4=getc(fp);
     anzahldreiecke = c1+(c2<<8)+(c3<<16)+(c4<<24);
     if(dreieck!=NULL) {printf("Programm-Fehler2: dreieck!=NULL)\n");}
     dreieck=new Dreieck[anzahldreiecke];
     for(j=0;j<anzahldreiecke;j++)
      {
       float fx,fy,fz;
       float_einlesen(fp,&fx); float_einlesen(fp,&fy); float_einlesen(fp,&fz); //Normalenvektor ueberlesen
       float_einlesen(fp,&fx); float_einlesen(fp,&fy); float_einlesen(fp,&fz); p1=Vektor3dshort(idfix16(fx*mm),idfix16(fy*mm),idfix16(fz*mm));
       float_einlesen(fp,&fx); float_einlesen(fp,&fy); float_einlesen(fp,&fz); p2=Vektor3dshort(idfix16(fx*mm),idfix16(fy*mm),idfix16(fz*mm));
       float_einlesen(fp,&fx); float_einlesen(fp,&fy); float_einlesen(fp,&fz); p3=Vektor3dshort(idfix16(fx*mm),idfix16(fy*mm),idfix16(fz*mm));
       getc(fp); getc(fp); //Attribute byte count ueberlesen
       dreieck[j].init(p1,p2,p3);
      }
    }
   if(argflag['V'])
    {
     printf("%d Dreiecke eingelesen.\n",anzahldreiecke);
     j=anzahldreiecke-1;
     printf("erstes  Dreieck: [%d %d %d]", dreieck[0].p1.x, dreieck[0].p1.y, dreieck[0].p1.z);
     printf(" [%d %d %d]",   dreieck[0].p2.x, dreieck[0].p2.y, dreieck[0].p2.z);
     printf(" [%d %d %d]\n", dreieck[0].p3.x, dreieck[0].p3.y, dreieck[0].p3.z);
     printf("letztes Dreieck: [%d %d %d]", dreieck[j].p1.x, dreieck[j].p1.y, dreieck[j].p1.z);
     printf(" [%d %d %d]",   dreieck[j].p2.x, dreieck[j].p2.y, dreieck[j].p2.z);
     printf(" [%d %d %d]\n", dreieck[j].p3.x, dreieck[j].p3.y, dreieck[j].p3.z);
    }
  }
 else printf("Fehler in stl-Datei: fehlender Dateikopf\n");
 fclose(fp);
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 FILE *fp1,*fp2;
 int i,j,c,col=0,maxcol;
 int breite,hoehe,tiefe,visklasse;
 double xmin= -120.0,ymin= -100.0, xmax=120.0, ymax=100.0; //Bereich +- 100 mm als maximale Druckebene
 if(argc<=0)
   ;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG || j<1)
	{printf("slicer  %s\n",VERSION);
	 printf("Anwendung: slicer Quelle [Ziel] [-Flags]\n");
	 printf("  Flags: v=Verbose, Kommentare anzeigen\n");
	 exit(0);
	}
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 maxcol=(1<<TIEFE);
 setsize(breite,hoehe,tiefe);
 setmenu(1,"File");
 setmenu(1,"Exit",&menu_exit);

 /* erst in slicer() machen:
 inital(xmin,ymin,xmax,ymax); // Grafikfenster oeffnen
 //fuer schwarz auf weiss (default ist weiss auf schwarz):
 if(TIEFE==24)
  {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else
  {screenclear(1); color(0);}
 */

 fp1=fopen(quellname,"r");
 if(fp1==NULL) {printf("kann Datei '%s' nicht oeffnen.\n",quellname); exit(1);}
 slicer(fp1,quellname);
 
 while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten

 term_exit();
 if(dreieck!=NULL) delete[] dreieck;
 return 0;
}/* ende von main */

void slicer(FILE *fp,const char *name)
{
 int n;
 uint j;
 int_16 z, xmin,ymin,xmax,ymax,zmin,zmax; //Werte in 0.1 mm
 double xmin1,ymin1,xmax1,ymax1,d1; //Werte fuer inital
 Vektor3dshort q1,q2;
 Dreieck hd; //Hilfsdreieck
 little_endian=check_endianess();
 //plot(0.,0.,PENUP); plot(99.,99.,PENDOWN); //test: eine Linie zeichnen
 //drawbox(-100.0,-100.0,100.0,100.0); //test: ein Quadrat zeichnen
 stldatei_einlesen(fp,name); //Daten einlesen und File schliessen

 minmax_werte_bestimmen(&xmin,&ymin,&xmax,&ymax,&zmin,&zmax);
 xmin1=xmin-10; ymin1=ymin-10; xmax1=xmax+10; ymax1=ymax+10; //Etwas mehr fuer groesseren Zeichenbereich
 if(xmax1-xmin1 > (ymax1-ymin1)*1.25) {d1=((xmax1-xmin1)/1.25-(ymax1-ymin1))*0.5; ymax1+=d1; ymin1-=d1;}
 else {d1=((ymax1-ymin1)*1.25-(xmax1-xmin1))*0.5; xmax1+=d1; xmin1-=d1;}
 if(argflag['V']) printf("minmax_werte: %d %d  %d %d  %d %d\n",xmin,xmax, ymin,ymax, zmin,zmax);
 inital(xmin1/mm,ymin1/mm,xmax1/mm,ymax1/mm); // Grafikfenster oeffnen
 if(TIEFE==24) {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
 else  {screenclear(1); color(0);}
 dreieck_liste=new uint[anzahldreiecke];
 strecken_liste=new uint[anzahldreiecke];
 strecke=new Strecke[anzahldreiecke];
 for(z=zmin;z<=zmax;z+=1) //Schichten in 0.1 mm Schritten
  {
   if(TIEFE==24) {screenclear(0xFFFFFF); rgbcolor(0x00,0x00,0x00);}
   else  {screenclear(1); color(0);}
   ndreiecke=0; //Zuordnungs-Liste der in der Ebene liegenden Dreiecke leeren
   nstrecken=0; //Zuordnungs-Liste der Schnittstrecken auf der Eben leeren
   j_strecke=0; //und die Strecken-Liste selbst ebenfalls leeren
   for(j=0;j<anzahldreiecke;j++)
    {
     if((n=dreieck[j].schnittpunkte(z))!=0)
      {
       if(n==3) //liegen alle 3 Ecken auf der Ebene?
	{dreiecks_liste_anfuegen(j);} //ja: in die Liste der Dreiecke auf der Ebene anfuegen
       else if(n==1) //liegt genau 1 Eckpunkt unterhalb der Ebene?
	{
	 if(dreieck[j].p1.z < z)
	  {dreieck[j].schnittpunkte_bestimmen_fall1(z,q1,q2);}
	 else if(dreieck[j].p2.z < z)
	  {
	   hd.p1=dreieck[j].p2; hd.p2=dreieck[j].p3; hd.p3=dreieck[j].p1;
	   hd.schnittpunkte_bestimmen_fall1(z,q1,q2);
	  }
	 else //if(dreieck[j].p3.z < z)
	  {
	   hd.p1=dreieck[j].p3; hd.p2=dreieck[j].p1; hd.p3=dreieck[j].p2;
	   hd.schnittpunkte_bestimmen_fall1(z,q1,q2);
	  }
	 strecken_liste_anfuegen(q1,q2); //in die Liste aller Strecken auf der Ebene anfuegen
	}
       else if(n==2) //genau 2 Eckpunkte liegen unterhalb der Ebene, und mindestens einer liegt oberhalb
	{
	 if(dreieck[j].p1.z > z)
	  {dreieck[j].schnittpunkte_bestimmen_fall2(z,q1,q2);}
	 else if(dreieck[j].p2.z > z)
	  {
	   hd.p1=dreieck[j].p2; hd.p2=dreieck[j].p3; hd.p3=dreieck[j].p1;
	   hd.schnittpunkte_bestimmen_fall2(z,q1,q2);
	  }
	 else //if(dreieck[j].p3.z > z)
	  {
	   hd.p1=dreieck[j].p3; hd.p2=dreieck[j].p1; hd.p3=dreieck[j].p2;
	   hd.schnittpunkte_bestimmen_fall2(z,q1,q2);
	  }
	 strecken_liste_anfuegen(q2,q1); //in die Liste aller Strecken auf der Ebene anfuegen
	}
       else if(n==4) //Fall4: 2 Punkte auf der Ebene, einer darunter
	{
	 if(dreieck[j].p1.z < z)      {q1=dreieck[j].p2; q2=dreieck[j].p3;}
	 else if(dreieck[j].p2.z < z) {q1=dreieck[j].p3; q2=dreieck[j].p1;}
	 else                         {q1=dreieck[j].p1; q2=dreieck[j].p2;}
	 strecken_liste_anfuegen(q1,q2); //in die Liste aller Strecken auf der Ebene anfuegen
	}
       else if(n==5) //Fall5: 2 punkte auf der Ebene, einer darueber
	{
	 if(dreieck[j].p1.z > z)      {q1=dreieck[j].p2; q2=dreieck[j].p3;}
	 else if(dreieck[j].p2.z > z) {q1=dreieck[j].p3; q2=dreieck[j].p1;}
	 else                         {q1=dreieck[j].p1; q2=dreieck[j].p2;}
	 strecken_liste_anfuegen(q2,q1); //in die Liste aller Strecken auf der Ebene anfuegen
	}
       else printf("Programm-Fehler3: falscher Schnittpunkt-Fall n=%d\n",n); //test
      }
     else //keine Schnittpunkte --> Dreieck fuer diese Ebene ignorieren
      {
       //if(j==2036)  printf("keine Schnittpunkte: n=%d\n",n);//test
      }
    } //Ende for j

   //static int test=0; //test
   //if(++test<10) //test
   // printf("jetzt muessten also %d Strecken und %d Dreiecke fuer die Ebene z=%d (%.1f mm) gezeichnet werden.\n", nstrecken,ndreiecke,z,z/mm);//test

   printf("z=%d  %d Dreiecke  %d Strecken\n",z,ndreiecke,nstrecken);//test
   //strecken_sortieren();
   //dreiecke_sortieren();
   double x1,y1,x2,y2;
   for(j=0;j<ndreiecke;j++)
    {
     x1=dreieck[dreieck_liste[j]].p1.x/mm;
     y1=dreieck[dreieck_liste[j]].p1.y/mm;
     x2=dreieck[dreieck_liste[j]].p2.x/mm;
     y2=dreieck[dreieck_liste[j]].p2.y/mm;
     plot(x1,y1,PENUP); plot(x2,y2,PENDOWN); //eine Linie zeichnen
     x2=dreieck[dreieck_liste[j]].p3.x/mm;
     y2=dreieck[dreieck_liste[j]].p3.y/mm;
     plot(x2,y2,PENDOWN); //2. Linie zeichnen
     plot(x1,y1,PENDOWN); //3. Linie des Dreiecks zeichnen
     waitTOF(); //test
    }
   for(j=0;j<nstrecken;j++)
    {
     x1=strecke[strecken_liste[j]].q1.x/mm;
     y1=strecke[strecken_liste[j]].q1.y/mm;
     x2=strecke[strecken_liste[j]].q2.x/mm;
     y2=strecke[strecken_liste[j]].q2.y/mm;
     plot(x1,y1,PENUP); plot(x2,y2,PENDOWN); //eine Linie zeichnen
     //waitTOF(); //test
    }
   term_refresh(); inital_new();
   //Delay(10); //eine halbe Sekunde warten
   Delay(4); //0.2 Sek warten

  } //Ende for z

 delete[] strecke;
 delete[] strecken_liste;
 delete[] dreieck_liste;
 term_refresh();
}
