/* vektor3dshort.cc

 Platzsparende 3D Vektoren mit kurzen Integern
Anwendung: einfuegen in C++ Programmen
*/

#ifndef VEKTOR3DSHORT_CC
#define VEKTOR3DSHORT_CC

#include <ulong.h>   //falls int_16 nicht schon definiert
typedef WORD int_16; //16 Bit grosse Integer

int_16 idfix16(double x) {return (int_16)((x>=0) ? x+0.5 : x-0.5);}

class Vektor3dshort
{
public:
 int_16 x,y,z;
 Vektor3dshort() {x=y=z=0;}
 Vektor3dshort(int_16 a,int_16 b=0,int_16 c=0) {x=a; y=b; z=c;}
 int get(int i) {if(i==0) return x; if(i==1) return y; if(i==2) return z;
                    return (int)(sqrt(x*x+y*y+z*z)+0.5); //Betrag
		   }
 Vektor3dshort operator=(int_16 a) {x=a; y=z=0; return *this;}
 //Vektor3dshort operator=(vektor v) {x=v.x; y=v.y; z=0; return *this;}
 Vektor3dshort operator=(Vektor3dshort v) {x=v.x; y=v.y; z=v.z; return *this;}
 Vektor3dshort operator+=(Vektor3dshort v) {x+=v.x; y+=v.y; z+=v.z; return *this;}
 Vektor3dshort operator-=(Vektor3dshort v) {x-=v.x; y-=v.y; z-=v.z; return *this;}
 Vektor3dshort operator*=(int_16 a) {x*=a; y*=a; z*=a; return *this;}
 Vektor3dshort operator*=(double a)
  {
   x=(idfix16)(a*x);
   y=(idfix16)(a*y);
   z=(idfix16)(a*z);
   return *this;
  }
 Vektor3dshort operator/=(int_16 a) {x/=a; y/=a; z/=a; return *this;}
 int_16& operator[](int i) {return i==0?x:(i==1?y:z);}
 friend Vektor3dshort operator+(Vektor3dshort,Vektor3dshort);
 friend Vektor3dshort operator-(Vektor3dshort,Vektor3dshort);
 friend Vektor3dshort operator*(Vektor3dshort,int_16);
 friend Vektor3dshort operator*(int_16,Vektor3dshort);
 friend Vektor3dshort operator*(Vektor3dshort,Vektor3dshort);
 friend Vektor3dshort operator/(Vektor3dshort,int_16);
 friend Vektor3dshort operator/(Vektor3dshort,Vektor3dshort);//provi.
 friend Vektor3dshort operator-(Vektor3dshort);
};

Vektor3dshort operator+(Vektor3dshort v1,Vektor3dshort v2)
{
 Vektor3dshort v; v.x=v1.x+v2.x; v.y=v1.y+v2.y; v.z=v1.z+v2.z;
 return v;
}
Vektor3dshort operator-(Vektor3dshort v1,Vektor3dshort v2)
{
 Vektor3dshort v; v.x=v1.x-v2.x; v.y=v1.y-v2.y; v.z=v1.z-v2.z;
 return v;
}
Vektor3dshort operator*(Vektor3dshort v1,int_16 c)
{
 Vektor3dshort v; v.x=v1.x*c; v.y=v1.y*c; v.z=v1.z*c;
 return v;
}
Vektor3dshort operator*(int_16 c,Vektor3dshort v1)
{
 Vektor3dshort v; v.x=v1.x*c; v.y=v1.y*c; v.z=v1.z*c;
 return v;
}
Vektor3dshort operator/(Vektor3dshort v1,int_16 c)
{
 Vektor3dshort v; v.x=v1.x/c; v.y=v1.y/c; v.z=v1.z/c;
 return v;
}
Vektor3dshort operator-(Vektor3dshort v1)
{
 Vektor3dshort v; v.x= -v1.x; v.y= -v1.y; v.z= -v1.z;
 return v;
}

int abs(Vektor3dshort v)				//Betrag eines Vektors
{
 return (int)(sqrt(v.x*v.x+v.y*v.y+v.z*v.z)+0.5);
}

Vektor3dshort operator*(Vektor3dshort v1,Vektor3dshort v2)
{
 Vektor3dshort v; v.x=v1.x*v2.x; v.y=v1.y*v2.y; v.z=v1.z*v2.z;
 return v;
}
Vektor3dshort operator/(Vektor3dshort v1,Vektor3dshort v2) //provi.
{
 Vektor3dshort v; v.x=v1.x/v2.x; v.y=v1.y/v2.y; v.z=v1.z/v2.z;
 return v;
}

#endif
