/* vektorklasse.cc

 Rechnen mit Vektoren
Anwendung: einfgen in C++ Programmen
*/

#ifndef VEKTORKLASSE_CC
#define VEKTORKLASSE_CC
#include <math.h>
#ifndef PI
#define PI 3.14159265358979323846
#endif
#define ZWEIPI (2.*PI)
#define PIHALBE (0.5*PI)
#ifndef GRAD
#define GRAD (PI/180.)
#endif

class vektor
{
public:
 double x,y;
 vektor(double a=0,double b=0) {x=a; y=b;}
 vektor(int n,double w,double a=1.) {x=a*cos(w); y=a*sin(w); if(n<0) y= -y;}
 vektor operator=(vektor v) {x=v.x; y=v.y; return *this;}
 vektor operator+=(vektor v) {x+=v.x; y+=v.y; return *this;}
 vektor operator-=(vektor v) {x-=v.x; y-=v.y; return *this;}
 vektor operator*=(double z) {x*=z; y*=z; return *this;}
 vektor operator/=(double z) {x/=z; y/=z; return *this;}
 friend vektor operator+(vektor,vektor);
 friend vektor operator-(vektor,vektor);
 friend vektor operator*(vektor,double);
 friend vektor operator*(double,vektor);
 friend vektor operator/(vektor,double);
 friend vektor operator-(vektor);
};
vektor operator+(vektor v1,vektor v2)
{
 vektor z; z.x=v1.x+v2.x; z.y=v1.y+v2.y;
 return z;
}
vektor operator-(vektor v1,vektor v2)
{
 vektor z; z.x=v1.x-v2.x; z.y=v1.y-v2.y;
 return z;
}
vektor operator*(vektor v1,double c)
{
 vektor z; z.x=v1.x*c; z.y=v1.y*c;
 return z;
}
vektor operator*(double c,vektor v1)
{
 vektor z; z.x=v1.x*c; z.y=v1.y*c;
 return z;
}
vektor operator/(vektor v1,double c)
{
 vektor z; z.x=v1.x/c; z.y=v1.y/c;
 return z;
}
vektor operator-(vektor v1)
{
 vektor z; z.x= -v1.x; z.y= -v1.y;
 return z;
}

double abs(vektor v)				//Betrag eines Vektors
{
 return sqrt(v.x*v.x+v.y*v.y);
}
double vektorprodukt(vektor v1,vektor v2)	// v1*v2
{
 return v1.x*v2.x+v1.y*v2.y;
}
/* vektor3d vektorkreuzprodukt(vektor v1,vektor v2)	//Kreuzprodukt
*/
double vektorwinkel(vektor v1,vektor v2)	//Winkel zwischen 2 Vektoren
{
 return acos(vektorprodukt(v1,v2)/(abs(v1)*abs(v2)));
}
double vektorwinkelv(vektor v1,vektor v2)	//Winkel zwischen 2 Vektoren
{						//mit Vorzeichen
 double w1=atan2(v1.y,v1.x), w2=atan2(v2.y,v2.x);
 double w=w2-w1;
 if(w>PI) w-=ZWEIPI;
 else if(w< -PI) w+=ZWEIPI;
 return w;
}
vektor vektordrehen(vektor v,double w)		//Vektor um Winkel w drehen
{						//im gegenuhrzeigersinn
 vektor z;
 double sina=sin(w),cosa=cos(w);
 z.x=v.x*cosa-v.y*sina;
 z.y=v.x*sina+v.y*cosa;
 return z;
}
double atan2(vektor v)			//Winkel zwischen Vektor und x-Achse
{return atan2(v.y,v.x);}		//kommt im Bereich +-PI heraus

void vektorsplit(vektor a,double gamma,double beta,vektor *c,vektor *b)
{				//Vektor in Teilvektoren aufspalten
				//gamma im gegen-, beta im uhrzeigersinn
 double aa=abs(a),bb,cc,w1=atan2(a),w;
 cc=aa*sin(beta)/sin(gamma+beta);
 c->x=cc*cos(w=w1+gamma);
 c->y=cc*sin(w);
// bb=
// b->x=bb*cos(w=w1-beta);
// b->y=bb*sin(w);
 *b = a - *c;
}
#endif
