// diasort.cc			letzte Aenderung: 4.1.2009 */
#define VERSION "Version 1.04"
#define COPYRIGHT "Freeware"
#define AUTHOR "Rolf Pfister"
/*
Bilder sortieren fuer Diashow mit Gwenview
neu seit Version 0.5: Diashow direkt mit diasort

History:
Datum  Version  Bemerkungen
31.1.2007	Erstellung aus bilbo.cc (RP)
                Klasse Bild fast unveraendert: zusaetzlich noch sortiernummer
6.2.07  0.2     Bild::zeichnen() optimiert, umbenennen vereinfacht
7.2.07  0.3     Mehr Optionen (c, s, f), Bilder drehen (rotnr)
18.2.07         Menu fuer groessere Vorschaubildchen (m_gross)
4.3.07          Anpassung an 24-Bit-Farbtiefe
7.3.07  0.4     provisorischer Vollbildmodus
                Bilder loeschen (loeschflag in class Bild)
9.3.07  0.5	gepufferter Bildwechsel im Vollbildmodus
                kleine Fehler korrigiert (z.B. loeschflag ruecksetzen)
11.3.07         in *bild_laden() Farbtiefe auf 1 Byte pro Farbe beschraenkt
15.3.07 0.6     flexiblere Anpassung an Bildschirmgroesse/Beameraufloesung.
                Vereinfachungen beim Programmstart im Vollbildmodus.
		Selektiertes Bild (selektbildnr!=0) auch beim Neuzeichnen
		mit rotem Rahmen versehen (Bild::zeichnen(int ramenflag)).
20.3.07 0.7     Fehler beim Bild rotieren und gleichzeitig verschieben:
		es wurde beim Speichern falsches Bild rotiert.
		Behebung: in Bild::init() und in umbenennen() rotnr
		zurueckgesetzt und schon vorhandenes -rot%d- ersetzt.
20.5.07  0.8    Start von Grafischer Benutzeroberflaeche fuer Demo-DVD
                Menupunkt "Ordner..." zum wechseln in anderes Verzeichnis
8.6.07   0.9    Menu Info eingefuehrt. +provisorische Untertitel
11.6.07  1.0    Untertitel jetzt richtig: class Textliste, Menu "Kommentar.."
26.6.07  1.01   Textliste haeufiger speichern
6.12.08  1.02   Taste i fuer m_info, neues Flag a um gewisse Anzahl Bilder
                automatisch zu laden.
20.12.08        Versuch eines Fehlerabfangs bei tmpppm und tmptxt
21.12.08        Probleme bei m_info provisorisch geloest. Anzahl geloeschte
                Bilder beim Umschalten auf Vollbild beruecksichtigt.
23.12.08 1.03   Direkter Aufruf von Bilbo (Bildbearbeitung) aus Diasort
                heraus. (Spezieller Menupunkt in Bilbo auch angepasst)
25.-28.12.08	Neues Menu "Auswahl..." fuer schnelle Bildauswahl:
		Beim ersten Benutzen mit Auswahl des Einsortiermodus.
		Bei Start mit -v werden im Auswahlordner vorhandene
		Bilder im Vollbildmodus mit A markiert.
28.12.08        Versuch das Problem bei tmptxt zu umgehen: lokalen
                tmp-Ordner erstellen und erst bei Programmende wieder
		loeschen. --> Problem trotzdem noch ab und zu.
		(gleiches Problem bei tmpppm auch noch nicht behoben).
3.1.2009 1.04	selektbildnr beim Ausschalten vom Vollbildmodus
		aktualisieren. Allfaellige Fehler abfangen: system(),
		symlink(), scanf(), fscanf()
		Neu: Automodus: Durchlaufen lassen im Vollbildmodus.
4.1.09		Schlimmer Fehler korrigiert: wenn es doppelte Nummern
		gab und nicht alle Bilder geladen wurden, gerieten die
		Bilder durcheinander. Mit tmptxtaktualisieren() provisorisch
		behoben.
		Bessere Loesung waere system(ls -1 >tmp.txt) zu vermeiden,
		und vielleicht opendir() verwenden (wie in xtekplot1.cc).
		(das wuerde auch das tmptxt-Problem entschaerfen)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <xtekplot1.h>
#include "vektorklasse.cc"

//test:
#define VORSCHAUBILDERBEHALTEN

/* fuer fixe aktuelle Aufloesung des Beamers:
#define MAXBR 1024
#define MAXHO 768
*/
#define MAXBR 2600
#define MAXHO 2000
static int XMAX=MAXBR,YMAX=MAXHO,TIEFE=24;//ersetzbar: gbreite,ghoehe,gtiefe
const int TIEFE2=12;
static int BB=95,DB=5; //Bildbreite und Abstand der Vorschaubildchen

/************************* Vordeklarationen ***************************/
void grafikfenster_oeffnen();
void neuzeichnen(int a0=0);
void scrollen(int richtung,int step=0);
void bildertauschen(int i,int j);
void mauspre();
void mausrel();
void mausmot();
void bilder_laden();
void bild_loeschen();
bool istordner(char *dateiname);
void mycolor(int r,int g,int b);
char *untertitel(char *name);
char *komextrahieren(FILE *fp);
char *namelesen(FILE *fp);
bool vorhandeninauswahl(const char *kernname);
void fehlermeldung(int err);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
static int test=0; //Testausdrucke (0=ohne 1=mit 2=noch mehr)
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='V') test++;
  }
}

class Aktuellerpfad
{
 char *pfad;
public:
 Aktuellerpfad() {pfad=NULL;}
 ~Aktuellerpfad() {if(pfad!=NULL) delete[] pfad;}
 void set(const char *arg0)
	{char *s; int n=strlen(arg0);
	 pfad=new char[n+1];
	 strcpy(pfad,arg0);
	 for(s= &pfad[n];*--s!='/';) ;
	 *s=0;
	 setenv("PWD",pfad,1);
	}
 void cd(const char* ordner);
 FILE *fopen2(const char *name,const char *rw);
 const char *vollpfad(const char *name);
 char *getpfad() {if(pfad) return pfad; else return getenv("PWD");}
};
static Aktuellerpfad pwd;

void Aktuellerpfad::cd(const char* ordner)
{
 const char *s,*altpfad=pfad;
 if(ordner[0]=='/') s="";
 else if(altpfad==NULL) s=getenv("PWD");
 else s=altpfad;
 int n=strlen(s)+strlen(ordner)+2;
 pfad=new char[n];
 if(*s==0) strcpy(pfad,ordner);
 else sprintf(pfad,"%s/%s",s,ordner);
 while(!istordner(pfad) && (n=strlen(pfad))>1)
   {while(--n>1 && pfad[n]!='/') ;
    pfad[n]=0;
   }
 if(altpfad) delete[] altpfad;
}

FILE *Aktuellerpfad::fopen2(const char *name,const char *rw)
{
 FILE *fp;
 if(pfad!=NULL && *name!='/')
  {char str[strlen(pfad)+strlen(name)+2];
   sprintf(str,"%s/%s",pfad,name);
   fp=fopen(str,rw);
  }
 else fp=fopen(name,rw);
 return fp;
}
const char *Aktuellerpfad::vollpfad(const char *name)
{
 if(name==NULL || *name=='/' || pfad==NULL) return name;
 char *vollname=new char[strlen(pfad)+strlen(name)+2];
 sprintf(vollname,"%s/%s",pfad,name);
 return vollname;
}
inline FILE *fopen2(const char *na,const char *rw) {return pwd.fopen2(na,rw);}
inline const char *vollpfad(const char *s) {return pwd.vollpfad(s);}

/************************ Globale Variablen ***************************/
#define N80 200
const int MAXB=2000; //Maximale Anzahl Bilder, die geladen werden koennen
static int nbilder=0; //Anzahl geladene Bilder
static int anzahl=1; //Anzahl Bilder die automatisch geladen werden sollen
static int jreihenfolge[MAXB+1]; //Bilder-Reihenfolge
inline int jr(int i) {return (i==nbilder)?nbilder:jreihenfolge[i];}

static int ansicht_modus=0,alter_modus=0,startflag=1;
const int NORMAL=0,GROSS=1,VOLLBILD=2; //Werte fuer ansicht_modus
static int vollbildnr=1; //aktuelles Bild im Vollbildmodus
static int maxvollbilder=2;
static int automodus=0; //automatisches Durchlaufen lassen im Vollbildmodus
static int autopause= -1;

/* nur in bilbo benoetigt
static int ramenx=0,rameny=0,ramenbreite=XMAX,ramenhoehe=YMAX; //Zielbildrahmen
*/

static int sichtx=0,sichty=0; //Position des Sicht-Fensters
static int maxsichty=0,altes_sichty=0;
static int sichtstep=5*(BB+DB);
static int zoomfaktor=100; //Groesse in Prozent

static int gbreite,ghoehe,gtiefe;
static int nochnichtgespeichert=0;
static int gedruecktemaustaste=0;
static char reihenfolgedatei[N80];

//static const char *tmptxt="/tmp/tmp.txt",*tmpppm="/tmp/tmp.ppm";
static const char *tmpppm="/tmp/tmp.ppm";
static char tmpord[8]="tmp1",tmptxt[16]="/tmp/tmp.txt",tmptxt2[16];
static int tmptxtistaktuell=0;

static const char *listetxt="textliste.txt",*listetxtbak="textliste.txt.bak";
static int selektbildnr=0; //aktuell selektiertes Bild (0 = keins selektiert)
static int hintergrundgrau=0x808080;

static int untertitelflag=1;

/*************************** kleinkram ***************************/
inline bool istselekt(int nr)
   {return (selektbildnr>0 && nr==jreihenfolge[selektbildnr-1]);}

int index(const char *s1,const char *s2) /* Sucht den String s2 innerhalb von */
{			 /* s1 und  gibt Position zurueck (nicht gefunden: -1)*/
 int i,c;
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

char *ohnepunkt(char *name)  /* in Filename die Erweiterung .xxx loeschen */
{
 char c,*s=name;
 while((c= *s)!='.' && c!=0) s++;
 if(c=='.') *s='\0';
 return name;
}
void ohnepfad(char *ziel,const char *name,int max)
{
 char c,*z;
 const char *s;
 int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='/' && c!=':' && c!='\\')
	{--i; --s;}
 for(i=1,z=ziel;i<max && (c= *s++)!=0;i++)
	*z++ = c;
 *z=0;
}
const char *ohnevornummer(const char *name)
{
 int c;
 const char *s;
 for(s=name;(c= *s++)!=0 && isdigit(c);) ;
 if(c!='-' && s!=name) --s;
 return s;
}
char *anhaengen(char *name,const char *t)
{
 char *s;
 for(s=name;*s!=0;s++) ;
 for(;*s++ = *t++;) ;
 return name;
}
char *endungersetzen(char *neu,const char *name,const char *endung)
{
 strcpy(neu,name); ohnepunkt(neu); anhaengen(neu,endung);
 return neu;
}

void system1(const char *s,int k=1)
{
 if(test>=2) printf("system%d> %s\n",k,s);
 int n=system(s);
 if(n!=0)
   {if(n==127) printf("Fehler %d in system(): fehlendes /bin/sh\n",n);
    else if(n<0) {printf("Fehler %d in system(%s)\n",n,s); fehlermeldung(n);}
    else if(test>=2) printf("Rueckgabewert von system() = %d\n",n);
   }
}
void system2(const char *s,const char *p1,const char *p2=NULL)
{
 char str[3*N80];
 sprintf(str,s,vollpfad(p1),vollpfad(p2));
 system1(str,2);
}
void system3(const char *s,int p1,const char *p2,const char *p3)
{
 char str[3*N80];
 sprintf(str,s,p1,vollpfad(p2),vollpfad(p3));
 system1(str,3);
}
bool istspace(int c)
{
 return (c=='\n' || c==' ');
}

vektor drehenl(vektor& v,double sina,double cosa) //Vektor nach links drehen
{
 return vektor(v.x*cosa-v.y*sina, v.x*sina+v.y*cosa);
}

vektor drehenr(vektor& v,double sina,double cosa) //Vektor nach rechts drehen
{
 return vektor(v.x*cosa+v.y*sina, v.y*cosa-v.x*sina);
}

bool vorhanden(const char *dateiname)
{
 struct stat buf;
 return (lstat(dateiname,&buf)>=0);
}
bool istordner(char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 //if(buf.st_mode & S_IFDIR) return true;
 if((buf.st_mode & S_IFMT)==S_IFDIR) return true;
 return false;
}
bool istregulaer(char *dateiname) //Regulaere Datei ohne Softlink ohne Ordner
{
 struct stat buf; //siehe man lstat
 //(Fehler in man lstat: S_IFMT ist nicht 0017000 sondern 0170000)
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFREG) return true;
 return false;
}
bool istsoftlink(char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFLNK) return true;
 return false;
}

void machklein(char *s)
{
 int c;
 while(c= *s++)
     if(c>='A' && c<='Z')
	 {c += 'a'-'A';
	  *--s = c;
	  s++;
	 }
}

bool isttext(int c)
{
 // return (isprint(c));
 // return ((c>='a' && c<'Z') || (c>='A' && c<='Z') || (c>='0' && c<='9')
 //    || c=='.' || c==':' || c==' ' || c==',' || c=='-' || c=='+' || c=='_');
 return (c>=' ' && c<='z');
}

bool istunsinn(char *s)
{
 int c,n1=0,n2=0;
 while(c= *s++) if(isttext(c)) n1++; else n2++;
 return (2*n2>=n1);
}

bool istbilddatei(const char *name)
{
 int n=strlen(name);
 if(n<5) return false;
 if(name[n-4]=='.')
   return (strcmp(&name[n-3],"jpg")==0 || strcmp(&name[n-3],"gif")==0 ||
	   strcmp(&name[n-3],"JPG")==0 || strcmp(&name[n-3],"GIF")==0 ||
	   strcmp(&name[n-3],"png")==0 || strcmp(&name[n-3],"PNG")==0);
 else if(n>5 && name[n-5]=='.')
   return (strcmp(&name[n-4],"jpeg")==0 || strcmp(&name[n-4],"jpeg")==0);
 return false;
}

/*************************** Haupt-Klassen ****************************/
class Intvector2
{
public:
 int x,y;
};

class Fvector
{
public:
 double r,g,b;
 Fvector(double r0,double g0,double b0) {r=r0; g=g0; b=b0;}
 Fvector operator+(Fvector p) {return Fvector(r+p.r,g+p.g,b+p.b);}
 Fvector operator*(double z) {return Fvector(z*r,z*g,z*b);}
};

class Farbvector
{
public:
 UWORD r,g,b;
 Farbvector() {}
 Farbvector(int n) {r=g=b=n;}
 Farbvector(Fvector f) {r=int(f.r); g=int(f.g); b=int(f.b);}
 void operator+=(Farbvector& y) {r+=y.r; g+=y.g; b+=y.b;}
 void operator*=(int n) {r*=n; g*=n; b*=n;}
 void operator*=(double z) {r=int(r*z+0.5); g=int(g*z+0.5); b=int(b*z+0.5);}
 void operator/=(int n) {r/=n; g/=n; b/=n;}
 void operator^=(int p2) {r=p2-r; g=p2-g; b=p2-b;}
 Fvector operator*(double z) {return Fvector(z*r,z*g,z*b);}
 //void setrgb(int r1,int g1,int b1) {r=r1; g=g1; b=b1;}//test
};
class Bild
{
 Farbvector *p;
 int nsum;
public:
 int imax,jmax;
 int offsetx,offsety,sortiernummer,rotnr,loeschflag;
 char bildname[N80];
 Bild() {imax=jmax=0; offsetx=offsety=sortiernummer=rotnr=loeschflag=0; nsum=1; *bildname=0;}
 ~Bild() {clear();}
 void clear()
	{if(imax!=0) {imax=jmax=0; delete[] p;}
	 offsetx=offsety=0;
	}
 int init(int i,int j,int offx=0,int offy=0)
	{imax=i; jmax=j; int n=imax*jmax; offsetx=offx; offsety=offy;
	 rotnr=loeschflag=0;
	 p=new Farbvector[n];
	 if(p==NULL) {printf("zu wenig RAM in init\n"); return -1;}
	 return 0;
	}
 void setrgb(int i,int j,int r,int g,int b);
 void zeichnen(int ramenflag=0);
 int save(const char*);
 Bild& operator=(Bild& y);
 void operator+=(Bild& y); //y dazuaddieren ohne Bildgroesse zu aendern
 void operator|=(Bild& y); //y dazuaddieren und Bildgroesse anpassen
 void operator&=(Bild& y); //mit y ueberschreiben und Bildgroesse anpassen
 void operator/=(int);
 void operator*=(int);
 void operator*=(double);
// void setoffset(int x,int y) {offsetx=x; offsety=y;}
 int cut(int br,int ho,int ox,int oy,Bild& y);
 Farbvector getpixel(int i,int j)
	{return (i>=0 && i<imax && j>=0 && j<jmax)?p[j*imax+i]:Farbvector(0);}
 void getminmaxpixel(int* pmin,int* pmax);
 void getminmaxpixel(int* rmin,int* rmax,int* gmin,int* gmax,int* bmin,int* bmax);
 void addpix(int r,int g,int b,bool ug,bool og);
 void mulpix(double r,double g,double b,bool ug,bool og);
 void negativ();
 void vergroessern(bool zwi,Bild& b1,double v);
 void drehen(bool zwi,Bild& b1,double sina,double cosa,double v=1.0);
 void einfachesdrehen(int grad);
 void umbenennen();
};
Bild& Bild::operator=(Bild& y)
{
 int er=init(y.imax,y.jmax,y.offsetx,y.offsety);
 int i,n=imax*jmax;
 if(er==0)
  for(i=0;i<n;i++)
     {p[i] = y.p[i];}
 strcpy(bildname,y.bildname);
 sortiernummer=y.sortiernummer;
 rotnr=y.rotnr;
 loeschflag=y.loeschflag;
 return *this;
}
void Bild::operator+=(Bild& y)
{
 int i,j,iy,jy,n=0,ny;
 for(j=0,jy=offsety-y.offsety;j<jmax;j++,jy++)
 for(i=0,iy=offsetx-y.offsetx;i<imax;i++,iy++,n++)
    if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
     {ny=jy*y.imax+iy;
      p[n] += y.p[ny];
     }
}
int Bild::cut(int br,int ho,int ox,int oy,Bild& y)
{
 int er=init(br,ho,ox,oy);
 int i,j,iy,jy,n=0,ny;
 if(er==0)
 for(j=0,jy=offsety-y.offsety;j<jmax;j++,jy++)
 for(i=0,iy=offsetx-y.offsetx;i<imax;i++,iy++,n++)
    if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
     {ny=jy*y.imax+iy;
      p[n] = y.p[ny];
     }
 return er;
}
void Bild::operator|=(Bild& y)
{
 if(offsetx==y.offsetx && offsety==y.offsety && imax==y.imax && jmax==y.jmax)
    {operator+=(y); return;}
 int n,im,jm,ox,oy,i,j,iy,jy,ny,iz,jz,nz;
 UWORD u1,u2;
 Farbvector *np;
 if(offsetx>=y.offsetx)
   {ox=y.offsetx; im=offsetx-ox+imax; if(y.imax>im) im=y.imax;}
 else
   {ox=offsetx; im=y.offsetx-ox+y.imax; if(imax>im) im=imax;}
 if(offsety>=y.offsety)
   {oy=y.offsety; jm=offsety-oy+jmax; if(y.jmax>jm) jm=y.jmax;}
 else
   {oy=offsety; jm=y.offsety-oy+y.jmax; if(jmax>jm) jm=jmax;}
 n=im*jm;
 np=new Farbvector[n];
 if(np==NULL) {printf("zu wenig RAM in operator|=\n"); return;}
 for(j=0,n=0;j<jm;j++)
 for(i=0;i<im;i++,n++)
    {iz=i+ox-offsetx; jz=j+oy-offsety;
     iy=i+ox-y.offsetx; jy=j+oy-y.offsety;
     if(iz>=0 && iz<imax && jz>=0 && jz<jmax) {nz=jz*imax+iz; u1=p[nz].r;}
     else {nz= -1; u1=0;}
     if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
	  {ny=jy*y.imax+iy; u2=y.p[ny].r;}
     else {ny= -1;  u2=0;}
     if(nz>=0 && ny<0) u2=u1/nsum; else if(nz<0 && ny>=0) u1=u2;
     np[n].r=u1+u2;
     if(nz>=0) u1=p[nz].g; else u1=0;
     if(ny>=0) u2=y.p[ny].g; else u2=0;
     if(nz>=0 && ny<0) u2=u1/nsum; else if(nz<0 && ny>=0) u1=u2;
     np[n].g=u1+u2;
     if(nz>=0) u1=p[nz].b; else u1=0;
     if(ny>=0) u2=y.p[ny].b; else u2=0;
     if(nz>=0 && ny<0) u2=u1/nsum; else if(nz<0 && ny>=0) u1=u2;
     np[n].b=u1+u2;
    }
 delete[] p;
 p=np;
 imax=im; jmax=jm; offsetx=ox; offsety=oy;
 nsum++;
}
void Bild::operator&=(Bild& y)
{
 if(offsetx==y.offsetx && offsety==y.offsety && imax==y.imax && jmax==y.jmax)
    {operator+=(y); return;}
 int n,im,jm,ox,oy,i,j,iy,jy,ny,iz,jz,nz,higrund=0x80;
 UWORD u1,u2;
 Farbvector *np;
 if(offsetx>=y.offsetx)
   {ox=y.offsetx; im=offsetx-ox+imax; if(y.imax>im) im=y.imax;}
 else
   {ox=offsetx; im=y.offsetx-ox+y.imax; if(imax>im) im=imax;}
 if(offsety>=y.offsety)
   {oy=y.offsety; jm=offsety-oy+jmax; if(y.jmax>jm) jm=y.jmax;}
 else
   {oy=offsety; jm=y.offsety-oy+y.jmax; if(jmax>jm) jm=jmax;}
 n=im*jm;
 np=new Farbvector[n];
 if(np==NULL) {printf("zu wenig RAM in operator&=\n"); return;}
 for(j=0,n=0;j<jm;j++)
 for(i=0;i<im;i++,n++)
    {iz=i+ox-offsetx; jz=j+oy-offsety;
     iy=i+ox-y.offsetx; jy=j+oy-y.offsety;
     if(iz>=0 && iz<imax && jz>=0 && jz<jmax) {nz=jz*imax+iz; u1=p[nz].r;}
     else {nz= -1; u1=higrund;} //grauer Hintergrund
     if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
	  {ny=jy*y.imax+iy; u2=y.p[ny].r;}
     else {ny= -1;  u2=u1;}
     np[n].r=u2;
     if(nz>=0) u1=p[nz].g; else u1=higrund;
     if(ny>=0) u2=y.p[ny].g; else u2=u1;
     np[n].g=u2;
     if(nz>=0) u1=p[nz].b; else u1=higrund;
     if(ny>=0) u2=y.p[ny].b; else u2=u1;
     np[n].b=u2;
    }
 delete[] p;
 p=np;
 imax=im; jmax=jm; offsetx=ox; offsety=oy;
}
void Bild::operator/=(int m)
{
 int i,n=imax*jmax;
 if(m==0) m=nsum;
 for(i=0;i<n;i++)
     {p[i] /= m;}
 nsum=1;
}
void Bild::operator*=(int m)
{
 int i,n=imax*jmax;
 for(i=0;i<n;i++)
     {p[i] *= m;}
}
void Bild::operator*=(double z)
{
 int i,n=imax*jmax;
 for(i=0;i<n;i++)
     {p[i] *= z;}
}
void Bild::setrgb(int i,int j,int r,int g,int b)
{
 int n=i+j*imax; p[n].r=r; p[n].g=g; p[n].b=b;
}

int farbnummer(int r,int g,int b)
{
 if(TIEFE>=24)
   return (r<<16)+(g<<8)+b;
 if(TIEFE==16)
 {while(r<8 && g<8 && b<8 && (r>1 || g>1 || b>1)) {r<<=1; g<<=1; b<<=1;}
  return ((r&0xF8)<<8)+((g&0xF8)<<3)+((b&0xF8)>>2);
 }
 if(TIEFE==12)
   return ((r&0xF0)<<4)+(g&0xF0)+((b&0xF0)>>4);
 //if(TIEFE==8)
 return (r&0xE0)+((g>>3)&0x1C)+((b>>6)&0x03);
}
void farben_init()
{
 int r,g,b;
 if(TIEFE==8)
 {for(r=0;r<=0xE0;r+=0x20)
  for(g=0;g<=0xE0;g+=0x20)
  for(b=0;b<=0xC0;b+=0x40)
    setcolor(farbnummer(r,g,b),r,g,b);
 }
 else if(TIEFE==12)
 {for(r=0;r<=0xF0;r+=0x10)
  for(g=0;g<=0xF0;g+=0x10)
  for(b=0;b<=0xF0;b+=0x10)
    setcolor(farbnummer(r,g,b),r,g,b);
 }
 else if(TIEFE==16)
 {for(r=0;r<0x08;r++)
  for(g=0;g<0x08;g++)
  for(b=0;b<0x08;b++)
    setcolor(farbnummer(r,g,b),r,g,b);
  for(r=0;r<=0xF8;r+=0x08)
  for(g=0;g<=0xF8;g+=0x08)
  for(b=0;b<=0xF8;b+=0x08)
    setcolor(farbnummer(r,g,b),r,g,b);
 }
}

void Bild::zeichnen(int ramenflag)
{
/* ramenx,y  Skizze aus bilbo.cc
     +------------Zielbild-------------+  ramenbreite,ramenhoehe
     |  offsetx,y                      |
     |   +------------Bild-------------+----+  imax,jmax  i,j
     |   |  sichtx,y                   |    |
     |   |    +--Sichtfenster--+       |    |  XMAX,YMAX  ix,iy
     |   |    |                |       |    |
     |   |    |                |       |    |
     |   |    |                |       |    |
     |   |    +----------------+       |    |
     +---+-----------------------------+    |
         |                                  |
         +----------------------------------+

  Neue Skizze fuer diasort.cc:
  +-----------Gesamtbild-------------+
  |                                  |
  |                                  |
  +----------Sichtfenster------------+ --sichty  ix,iy
  |                                  |
  |   +-Bild-+ i,j                   |
  |   |      |                       |
  |   +------+                       |
  |                                  |
  |                                  |
  |                                  |
  +----------------------------------+
  |                                  |
  |                                  |
  +----------------------------------+
*/
 int ix,iy,ix0,iy0; //Koordinaten im Sichtfenster
 int i,j,i1,i2,j1,j2; //Koordinaten im Bild
 int nr,n,nj;
 /** nur in bilbo benoetigt
 if(ramenbreite==0 || ramenhoehe==0)
   {ramenbreite=imax; ramenhoehe=jmax;
    if(sichtx==0 && sichty==0)
	{sichtx=(ramenbreite-XMAX)/2; if(sichtx<0) sichtx=0;
	 sichty=(ramenhoehe-YMAX)/2; if(sichty<0) sichty=0;
	}
   }
 **/
 i1=sichtx-offsetx; j1=sichty-offsety;
 i2=i1+XMAX; j2=j1+YMAX;
 koorduser2pix(0.0,YMAX,&ix0,&iy0);
 // if(zoomfaktor==100)
  {if(imax>=XMAX) //fuer grosse Bilder bilbo-Variante
    {for(j=j1,nj=j1*imax,iy=iy0;j<j2;j++,nj+=imax,iy++)
     for(i=i1,ix=ix0;i<i2;i++,ix++)
      {if(j>=0 && j<jmax && i>=0 && i<imax)
	  {n=i+nj; nr=farbnummer(p[n].r,p[n].g,p[n].b);}
       else {nr=hintergrundgrau;} //Ausserhalb Bilddaten: Grau
       ipunkt(ix,iy,nr);
      }
    }
   else //fuer kleine Bilder diasort-Variante
    {for(iy=iy0+offsety-sichty,nj=j=0;j<jmax;j++,nj+=imax,iy++)
     for(ix=ix0+offsetx,i=0;i<imax;i++,ix++)
	 {if(iy>=iy0 && iy<YMAX && ix>=ix0 && ix<XMAX)
	    {n=i+nj; ipunkt(ix,iy,farbnummer(p[n].r,p[n].g,p[n].b));}
	 }
    }
  }
 /* else
  {double fa=zoomfaktor*0.01;
   int ii,jj;
   for(j=0,iy=iy0;j<YMAX;j++,iy++)
   for(i=0,ix=ix0;i<XMAX;i++,ix++)
    {jj=j1+int(j/fa+0.5);
     ii=i1+int(i/fa+0.5);
     if(jj>=0 && jj<jmax && ii>=0 && ii<imax)
	  {n=jj*imax+ii; nr=farbnummer(p[n].r,p[n].g,p[n].b);}
     else {nr=hintergrundgrau;} //Ausserhalb Bilddaten: Grau
     ipunkt(ix,iy,nr);
    }
  }
 */
 if(loeschflag) //wenn als geloescht markiert, rot durchstreichen
  {int ix=ix0+offsetx, iy=iy0+offsety-sichty;
   color(farbnummer(255,0,0));
   moveto(ix,iy); lineto(ix+imax,iy+jmax);
   moveto(ix+imax,iy); lineto(ix,iy+jmax);
  }
 if(ramenflag) //wenn selektiert, Rahmen zeichnen
  {int ix=ix0+offsetx, iy=iy0+offsety-sichty, d=(imax>jmax)?imax:jmax;
   color(farbnummer(255,0,0));
   idrawbox(ix,iy,ix+d,iy+d);
  }
}
int Bild::save(const char *filename)
{
 int i,j,n,ti=255,c;
 for(j=n=0;j<jmax && ti==255;j++)
 for(i=0;i<imax;i++,n++)
    if(p[n].r>255 || p[n].g>255 || p[n].b>255) {ti=65535; break;}
 FILE *fp=fopen2(filename,"wb");
 if(fp==NULL) return -1;
 fprintf(fp,"P6\n%d %d %d\n",imax,jmax,ti);
 if(ti==255)
  {for(j=n=0;j<jmax;j++)
   for(i=0;i<imax;i++,n++)
    {putc(p[n].r,fp); putc(p[n].g,fp); putc(p[n].b,fp);
    }
  }
 else
  {for(j=n=0;j<jmax;j++)
   for(i=0;i<imax;i++,n++)
    {c=p[n].r; putc(c>>8,fp); putc(c&0xFF,fp);
     c=p[n].g; putc(c>>8,fp); putc(c&0xFF,fp);
     c=p[n].b; putc(c>>8,fp); putc(c&0xFF,fp);
    }
  }
 fclose(fp);
 return 0;
}
void Bild::getminmaxpixel(int* pmin,int* pmax)
{
 int i,n=imax*jmax;
 *pmin=0xFFFF; *pmax=0;
 for(i=0;i<n;i++)
   {if(*pmin>p[i].r) *pmin=p[i].r;
    if(*pmin>p[i].g) *pmin=p[i].g;
    if(*pmin>p[i].b) *pmin=p[i].b;
    if(*pmax<p[i].r) *pmax=p[i].r;
    if(*pmax<p[i].g) *pmax=p[i].g;
    if(*pmax<p[i].b) *pmax=p[i].b;
   }
}
void Bild::getminmaxpixel(int* rmin,int* rmax,int* gmin,int* gmax,int* bmin,int* bmax)
{
 int i,n=imax*jmax;
 *rmin= *gmin= *bmin=0xFFFF;  *rmax= *gmax= *bmax=0;
 for(i=0;i<n;i++)
   {if(*rmin>p[i].r) *rmin=p[i].r;
    if(*gmin>p[i].g) *gmin=p[i].g;
    if(*bmin>p[i].b) *bmin=p[i].b;
    if(*rmax<p[i].r) *rmax=p[i].r;
    if(*gmax<p[i].g) *gmax=p[i].g;
    if(*bmax<p[i].b) *bmax=p[i].b;
   }
}
void Bild::addpix(int r,int g,int b,bool ug,bool og)
{
 int i,n=imax*jmax,rn,gn,bn;
 for(i=0;i<n;i++)
   {rn=p[i].r+r;
    gn=p[i].g+g;
    bn=p[i].b+b;
    if(ug) {if(rn<0) rn=0; if(gn<0) gn=0; if(bn<0) bn=0;}
    if(og) {if(rn>255) rn=255; if(gn>255) gn=255; if(bn>255) bn=255;}
    p[i].r=rn;
    p[i].g=gn;
    p[i].b=bn;
   }
}
void Bild::mulpix(double r,double g,double b,bool ug,bool og)
{
 int i,n=imax*jmax,rn,gn,bn;
 for(i=0;i<n;i++)
   {rn=int(p[i].r*r+0.5);
    gn=int(p[i].g*g+0.5);
    bn=int(p[i].b*b+0.5);
    if(ug) {if(rn<0) rn=0; if(gn<0) gn=0; if(bn<0) bn=0;}
    if(og) {if(rn>255) rn=255; if(gn>255) gn=255; if(bn>255) bn=255;}
    p[i].r=rn;
    p[i].g=gn;
    p[i].b=bn;
   }
}
void Bild::negativ()
{
 int i,n=imax*jmax,pmin,pmax,p2;
 getminmaxpixel(&pmin,&pmax);
 p2=pmax+2*pmin;
 for(i=0;i<n;i++)
   {p[i] ^= p2; //p[i].r=pmax-(p[i].r-pmin)+pmin;
   }
}
void Bild::vergroessern(bool zwi,Bild& b1,double v)
{
 int i,j,k; //Laufvariablen neues Bild
 int i1,j1,i2,j2; //Indexe auf altes Bild
 double x,y;
 double w1,w2,wj1,wj2; //Gewichtungsfaktoren
 if(zwi) //Zwischenwerte berechnen
  for(j=0,k=0;j<jmax;j++)
   {y=(j+0.5)/v-0.5;
    j1=int(y); j2=j1+1; //j1 ist abgerundeter, j2 aufgerundeter Wert
    wj1=j2-y; wj2=y-j1; //Gewicht ist Abstand zwischen gerundet und exakt
    if(j2>=b1.jmax) j2=j1;
    for(i=0;i<imax;i++,k++)
     {x=(i+0.5)/v-0.5;
      i1=int(x); i2=i1+1; w1=i2-x; w2=x-i1;
      if(i2>=b1.imax) i2=i1;
      p[k] = (b1.getpixel(i1,j1)*w1+b1.getpixel(i2,j1)*w2)*wj1
	    +(b1.getpixel(i1,j2)*w1+b1.getpixel(i2,j2)*w2)*wj2;
     }
   }
 else //ohne Zwischenwerte
  for(j=0,k=0;j<jmax;j++)
   {j1=int((j+0.5)/v); //entspricht idfix((j+0.5)/v-0.5)
    for(i=0;i<imax;i++,k++)
     {i1=int((i+0.5)/v);
      p[k] = b1.getpixel(i1,j1);
     }
   }
}
void Bild::drehen(bool zwi,Bild& b1,double sina,double cosa,double v)
{
 int i,j,k; //Laufvariablen neues Bild
 int i1,j1,i2,j2; //Indexe auf altes Bild
 vektor q0,q;
 double w1,w2,wj1,wj2; //Gewichtungsfaktoren
 vektor mb(b1.imax*0.5,b1.jmax*0.5); //Mitte altes Bild
 vektor ma(imax*0.5,jmax*0.5); //Mitte neues Bild
 if(zwi) //Zwischenwerte berechnen
  for(j=0,k=0;j<jmax;j++)
   {q0.y=(j-ma.y)/v;
    for(i=0;i<imax;i++,k++)
     {q0.x=(i-ma.x)/v;
      q=drehenr(q0,sina,cosa)+mb;
      j1=int(q.y); j2=j1+1; //j1 ist abgerundeter, j2 aufgerundeter Wert
      wj1=j2-q.y; wj2=q.y-j1; //Gewicht ist Abstand zwischen gerundet und exakt
      if(j2>=b1.jmax) j2=j1;
      i1=int(q.x); i2=i1+1; w1=i2-q.x; w2=q.x-i1;
      if(i2>=b1.imax) i2=i1;
      if(j1<0 || j1>=b1.jmax || i1<0 || i1>=b1.imax)
	  p[k]=0; //Hintergrund schwarz
      else
	  p[k] = (b1.getpixel(i1,j1)*w1+b1.getpixel(i2,j1)*w2)*wj1
	        +(b1.getpixel(i1,j2)*w1+b1.getpixel(i2,j2)*w2)*wj2;
     }
   }
 else //ohne Zwischenwerte
  for(j=0,k=0;j<jmax;j++)
   {q0.y=(j-ma.y)/v;
    for(i=0;i<imax;i++,k++)
     {q0.x=(i-ma.x)/v;
      q=drehenr(q0,sina,cosa)+mb;
      i1=int(q.x+0.5);
      j1=int(q.y+0.5);
      if(j1<0 || j1>=b1.jmax || i1<0 || i1>=b1.imax)
	  p[k]=0; //Hintergrund schwarz
      else
	  p[k] = b1.getpixel(i1,j1);
     }
   }
}
void Bild::einfachesdrehen(int grad) //einfache 90-Grad-Drehungen
{
 int i,j,i2,j2,n;
 Bild tmp;
 tmp= *this;
 tmp.init(jmax,imax,offsetx,offsety);
 tmp.rotnr=rotnr; //erst ruecksetzen wenn auch das gespeicherte Bild gedreht
 if(grad==90)
   {for(n=j=0;j<jmax;j++)
     for(i=0;i<imax;i++)
       {i2=jmax-j-1; j2=i;
        tmp.p[j2*jmax+i2]=p[n++];
       }
   }
 else if(grad==270)
   {for(n=j=0;j<jmax;j++)
     for(i=0;i<imax;i++)
       {i2=j; j2=imax-i-1;
        tmp.p[j2*jmax+i2]=p[n++];
       }
   }
 else
   {printf("Fehler: einfachesdrehen(%d) nur 90 oder 270 Grad erlaubt.\n",grad);
    return;
   }
 *this=tmp;
}

#include <errno.h>
void fehlermeldung(int err)
{
 if(err== -1) err=errno;
#ifdef EEXIST
 if(err==EEXIST) printf("EEXIST - Datei schon vorhanden.\n");
 else if(err==EROFS) printf("EROFS - nur lesbar\n");
 else if(err==ENOMEM) printf("ENOMEM - nicht genug Kernelspeicher\n");
 else if(err==EACCES) printf("EACCES - kein Schreibrecht\n");
 else
#endif
    printf("Fehlercode %d: siehe 'more /usr/include/asm*/errno*.h'\n",err);
 automodus=0;
}
void fehlerscanf(int soll,int n)
{
 printf("Fehler in scanf() oder fscanf() n=%d (statt %d)\n",n,soll);
}

void Bild::umbenennen()
{
 char neuername[N80],*z=bildname;
 int nr,err;
 if(rotnr!=0)
   {while(rotnr<0) rotnr+=4;
    rotnr=rotnr%4;
   }
 if(isdigit(z[0]) && isdigit(z[1])
    && isdigit(z[2]) && isdigit(z[3]) && z[4]=='-')
   {sscanf(bildname,"%d",&nr);
    if(nr==sortiernummer && rotnr==0 && loeschflag==0) return;//kein Umbenennen noetig
    z= &bildname[5];
   }
 else if(loeschflag) return;//kein Umbenennen noetig
 if(rotnr==0)
   {if(loeschflag) sprintf(neuername,"%s",z);
    else sprintf(neuername,"%04d-%s",sortiernummer,z);
    err=rename(vollpfad(bildname),vollpfad(neuername));
    if(err) printf("Error %d: rename(%s,%s)\n",err,bildname,neuername);
   }
 else
   {int n;
    if(strncmp(z,"rot",3)==0 && isdigit(z[3]) && z[4]=='-')
      {n=(rotnr+z[3]-'0')%4; z= &z[5];} //neue rotnr berechnen, altes weglassen
    else n=rotnr;
    if(n==0)
      {if(loeschflag) sprintf(neuername,"%s",z);
       else sprintf(neuername,"%04d-%s",sortiernummer,z);
      }
    else
      {if(loeschflag) sprintf(neuername,"rot%d-%s",n,z);
       else sprintf(neuername,"%04d-rot%d-%s",sortiernummer,n,z);
      }
    system3("convert -rotate %d %s %s",rotnr*90,bildname,neuername);
    if(vorhanden(vollpfad(neuername))) {err=0; unlink(vollpfad(bildname));}
    else {printf("Bild '%s' rotieren fehlgeschlagen.\n",bildname); err= -1;}
    rotnr=0;
   }
 if(err==0) strcpy(bildname,neuername);
 else if(err>0) fehlermeldung(err);
}

static Bild bilder[MAXB+1],vollbild;
static char scratch[400];

int bild_laden(const char *name,int bildnr)
{
 char cstr[80];
 const char *tmpvor=tmpppm;
 FILE *fp;
 int c,i,j,br,ho,ti,r,g,b;
 static int xoffs=DB,yoffs=DB;
 if(bildnr==1) {xoffs=yoffs=DB;}
 if(bildnr>nbilder)
 {
#ifdef VORSCHAUBILDERBEHALTEN
 c=(ansicht_modus==GROSS)?'g':'k';
 sprintf(scratch,"tmpvor/%c%s",c,ohnevornummer(name));
 ohnepunkt(scratch);
 anhaengen(scratch,".ppm");
 tmpvor=scratch;
 if(!vorhanden(tmpvor)) {
   if(!vorhanden("tmpvor")) system1("mkdir tmpvor");
#endif
   sprintf(cstr,"convert -size %dx%d %%s -resize %dx%d %%s",BB,BB,BB,BB);
   system2(cstr,name,tmpvor);
#ifdef VORSCHAUBILDERBEHALTEN
 }
#endif
 fp=fopen(tmpvor,"r");
 if(fp==NULL)
   {printf("Fehler in bild_laden(%s,%d): kann '%s' nicht oeffnen - versuche nochmals\n",name,bildnr,tmpvor);
    for(int i=2;i<10 && fp==NULL;i++)
      {Delay(1); unlink(tmpvor);
       Delay(1); system2(cstr,name,tmpvor);
       Delay(1); fp=fopen(tmpvor,"r");
       if(fp==NULL) printf("auch beim %d. Versuch nicht\n",i);
      }
    if(fp==NULL) return -1;
    printf("ok.\n");
   }
 if(getc(fp)!='P' || getc(fp)!='6')
  {printf("%s fileformat: '%s' is not PPM\n",name,tmpvor);fclose(fp);return -1;}
 while(istspace(c=getc(fp))) ;
 while(c=='#') {while(getc(fp)!='\n') ;  c=getc(fp);}
 ungetc(c,fp);
 c=fscanf(fp,"%d %d %d",&br,&ho,&ti); if(c!=3) fehlerscanf(3,c);
 if((c=getc(fp))!='\n' && c!=' ')
   {printf("%s Error: missing whitespace in PPM\n",name); return -1;}
 if(br>MAXBR || ho>MAXHO)
   {printf("Bild zu Gross: %dx%d (auf %dx%d beschraenkt)\n",br,ho,MAXBR,MAXHO); fclose(fp); return 0;}
 //if(test) printf("Loading '%s' br=%d ho=%d ti=%d\n",tmpvor,br,ho,ti);//test
 if(ti!=255 && ti!=65535)
     printf("Warnung: Ungewoehnliche Farbtiefe, Bild wird moeglicherweise nicht korrekt dargestellt\n");//test
 int er=bilder[nbilder].init(br,ho,xoffs,yoffs);
 if(er!=0) {fclose(fp); printf("%s Speicherprobleme",name); return 0;}
 ohnepfad(bilder[nbilder].bildname,name,N80);
 if(ti<=255)
     {for(j=0;j<ho;j++)
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; g=getc(fp)&0xFF; b=getc(fp)&0xFF;
	bilder[nbilder].setrgb(i,j,r,g,b);
       }
     }
 else //if(ti==65535)
     {for(j=0;j<ho;j++)
      /* fuer volle Farbtiefe:
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; r=(r<<8)+(getc(fp)&0xFF);
        g=getc(fp)&0xFF; g=(g<<8)+(getc(fp)&0xFF);
	b=getc(fp)&0xFF; b=(b<<8)+(getc(fp)&0xFF);
	bilder[nbilder].setrgb(i,j,r,g,b);
       }
      /* Farbtiefe auf 1 Byte beschraenkt: */
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; getc(fp);
        g=getc(fp)&0xFF; getc(fp);
	b=getc(fp)&0xFF; getc(fp);
	bilder[nbilder].setrgb(i,j,r,g,b);
       }
      /* */
     }
 fclose(fp);
#ifndef VORSCHAUBILDERBEHALTEN
 unlink(tmpppm);
#endif
 bilder[nbilder].sortiernummer=nbilder+1;
 jreihenfolge[nbilder]=nbilder;
 if(!isdigit(bilder[nbilder].bildname[0])) nochnichtgespeichert=1;
 bilder[nbilder].zeichnen(istselekt(nbilder));
 nbilder++;
 }
 else if(yoffs>=sichty) bilder[bildnr-1].zeichnen(istselekt(bildnr-1));
 xoffs+=BB+DB;
 if(xoffs>gbreite-BB-DB)
   {yoffs+=BB+DB; xoffs=DB;
    if(yoffs-sichty>ghoehe-BB) return 0;
   }
 return 1;
}

int aktbildnr_ausrechnen(const char *name)
{
 int nr,n,resultat=0;
 for(nr=1;nr<=nbilder;nr++)
   {n=jreihenfolge[nr-1];
    if(strcmp(name,bilder[n].bildname)==0)
      {resultat=nr; break;}
   }
 return resultat;
}

static int vollbildaktnr=0;//provi.

int vollbild_laden(char *name,int bildnr)
{
 char cstr[80];
 FILE *fp;
 int c,i,j,br,ho,ti,r,g,b;
 if(bildnr!=vollbildnr)
    return 1;//immer 1 zurueckgeben weil Bilder gezaehlt werden sollen
 vollbildaktnr=aktbildnr_ausrechnen(name);
 sprintf(cstr,"convert -size %dx%d %%s -resize %dx%d %%s",
	   gbreite,ghoehe,gbreite,ghoehe);
 system2(cstr,name,tmpppm);
 fp=fopen(tmpppm,"r");
 if(fp==NULL)
   {printf("Error in vollbild_laden: %s cant open '%s' - Trying again: ",
	   name,tmpppm);
    Delay(10); fp=fopen(tmpppm,"r");
    if(fp==NULL) {printf("no success.\n"); return -1;}
    printf("ok.\n");
   }
 if(getc(fp)!='P' || getc(fp)!='6')
  {printf("%s fileformat: '%s' is not PPM\n",name,tmpppm);fclose(fp);return -1;}
 while(istspace(c=getc(fp))) ;
 while(c=='#') {while(getc(fp)!='\n') ;  c=getc(fp);}
 ungetc(c,fp);
 c=fscanf(fp,"%d %d %d",&br,&ho,&ti); if(c!=3) fehlerscanf(3,c);
 if((c=getc(fp))!='\n' && c!=' ')
   {printf("%s Error: missing whitespace in PPM\n",name); return -1;}
 if(br>MAXBR || ho>MAXHO)
   {printf("Bild zu Gross: %dx%d (auf %dx%d beschraenkt)\n",br,ho,MAXBR,MAXHO); fclose(fp); return 0;}
 //if(test) printf("Loading '%s' br=%d ho=%d ti=%d\n",tmpppm,br,ho,ti);//test
 if(ti!=255 && ti!=65535)
     printf("Warnung: Ungewoehnliche Farbtiefe, Bild wird moeglicherweise nicht korrekt dargestellt\n");//test
 int er, dx=(gbreite-br)/2, dy=(ghoehe-ho)/2;
 er=vollbild.init(br,ho,dx,dy);
 if(er!=0) {fclose(fp); printf("%s Speicherprobleme",name); return 0;}
 ohnepfad(vollbild.bildname,name,N80);
 if(ti<=255)
     {for(j=0;j<ho;j++)
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; g=getc(fp)&0xFF; b=getc(fp)&0xFF;
	vollbild.setrgb(i,j,r,g,b);
       }
     }
    else
     {for(j=0;j<ho;j++)
      /* Farbtiefe auf 1 Byte beschraenkt: */
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; getc(fp);
        g=getc(fp)&0xFF; getc(fp);
	b=getc(fp)&0xFF; getc(fp);
	vollbild.setrgb(i,j,r,g,b);
       }
     }
 fclose(fp);
 unlink(tmpppm);
 vollbild.zeichnen();
 if(untertitelflag) untertitel(name);
 changebuffer(0,1);
 return 1;
}

/********************** Untertitel, Textanzeigen ***********************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

class Textliste
{
 Textliste *next;
 char bildname[80]; //Name ohne Pfad und ohne fuehrende Nummer
 char textzeile[160]; //Text fuer maximal eine Zeile
 int textfarbe,bfarbe;
 char *kern(char *s);
public:
 int gespeichert;
 Textliste()
	{next=NULL; *bildname = *textzeile = 0;
	 textfarbe=0xFFFFFF; bfarbe= -1; gespeichert=1;
	}
 ~Textliste() {if(next!=NULL) delete next;}
 bool put(char *name,char *text,int farbe=0xFFFFFF,int bpen= -1);
 char *get(char *name,int *farbe,int *bpen);
 void set(char *name,char *text,int farbe,int bpen);
 void laden();
 void speichern();
};
static Textliste textliste;

void Textliste::laden()
{
 FILE *fp=fopen(listetxt,"r");
 if(fp==NULL) return;
 Textliste *p,*p0;
 char zeile[200],*s;
 for(p0=p=this;getline(fp,zeile,200);)
   if(strncmp(zeile,"<text ",6)==0)
    {if(strncmp(&zeile[6],"name=\"",6)==0)
      {for(s= &zeile[12];*s!=0 && *s!='"';s++) ;
       *s=0;
       strncpy(p->bildname,&zeile[12],80);
       getline(fp,p->textzeile,160);
       for(;getline(fp,zeile,200) && *zeile!='<';)
	{if(strncmp(zeile,"farbe=",6)==0) sscanf(&zeile[6],"%d",&p->textfarbe);
	 else if(strncmp(zeile,"bpen=",5)==0) sscanf(&zeile[5],"%d",&p->bfarbe);
	}
       if(strncmp(zeile,"</text>",7)!=0)
	 printf("Syntaxfehler in textliste.txt: fehlendes </text>\n");
       p0=p;
       p=p0->next=new Textliste;
       if(p==NULL) printf("Fehler: zu wenig Speicher?\n");//test
      }
     else
      printf("Syntaxfehler in textliste.txt: <text name=\"..\"> erwartet.\n");
    }
 fclose(fp);
 if(p!=this) {delete p; p0->next=NULL;}
}

void Textliste::speichern()
{
 static int firstflag=1;
 if(firstflag)
   {if(vorhanden(listetxt)) rename(listetxt,listetxtbak);
    firstflag=0;
   }
 FILE *fp=fopen(listetxt,"w");
 if(fp==NULL)
   {printf("Fehler: kann %s nicht erstellen.\n",listetxt); return;}
 Textliste *p;
 for(p=this;p!=NULL;p=p->next)
  if(p->bildname[0]!=0 && p->textzeile[0]!=0)
   {fprintf(fp,"<text name=\"%s\">\n",p->bildname);
    fprintf(fp,"%s\n",p->textzeile);
    fprintf(fp,"farbe=%d\nbpen=%d\n",p->textfarbe,p->bfarbe);
    fprintf(fp,"</text>\n");
   }
 fclose(fp);
 gespeichert=1;
}

char* Textliste::kern(char *s)
{
 char *z=s;
 int c,numflag=1;
 while(c= *s++)
   {if(c=='/') {z=s; numflag=1;}
    else if(numflag && c=='-') {z=s; numflag=0;}
    else if(!isdigit(c)) numflag=0;
   }
 return z;
}
char* Textliste::get(char *name,int *farbe,int *bpen)
{
 char *s=kern(name);
 Textliste *p;
 if(strlen(s)>=80) {printf("Fehler: Dateiname zu lang.\n"); return NULL;}
 for(p=this;p!=NULL;p=p->next)
   if(strcmp(s,p->bildname)==0)
       {*farbe=p->textfarbe; *bpen=p->bfarbe;
	if(test>0 && vorhandeninauswahl(s))
	  {static char text[200];
	   sprintf(text,"A - %s",(p->textzeile==NULL) ? name : p->textzeile);
	   return text;
	  }
	return p->textzeile;
       }
 return NULL;
}
bool Textliste::put(char *name,char *text,int farbe,int bpen)
{
 char *s=kern(name);
 Textliste *p;
 if(strlen(s)>=80) {printf("Fehler: Dateiname zu lang.\n"); return 0;}
 if(*bildname==0)
   {strcpy(bildname,s); strncpy(textzeile,text,160);}
 else
   {for(p=this;p->next!=NULL;p=p->next) ;
    p->next=new Textliste;
    p=p->next;
    strcpy(p->bildname,s); strncpy(p->textzeile,text,160);
    p->textfarbe=farbe; p->bfarbe=bpen;
   }
 gespeichert=0;
 return 1;
}
void Textliste::set(char *name,char *text,int farbe,int bpen)
{
 char *s=kern(name);
 Textliste *p;
 if(strlen(s)>=80) {printf("Fehler: Dateiname zu lang.\n"); return;}
 for(p=this;p!=NULL;p=p->next)
   if(strcmp(s,p->bildname)==0)
     {p->textfarbe=farbe; p->bfarbe=bpen;
      strcpy(p->textzeile,text);
      gespeichert=0;
      return;
     }
 put(name,text,farbe,bpen);
}

void mycolor2(int farbe) {mycolor(farbe>>16,(farbe&0xFF00)>>8,farbe&0xFF);}
void mybpencolor(int farbe)
{
 if(farbe<0) bpencolor(farbe);
 else bpencolor(farbnummer(farbe>>16,(farbe&0xFF00)>>8,farbe&0xFF));
}

char *untertitel(char *name)
{
 int farbe=0xFFFFFF,bpen= -1;
 char *text=textliste.get(name,&farbe,&bpen);
 if(text==NULL)
   {FILE *fp=fopen2(name,"r");
    if(fp) {text=komextrahieren(fp); fclose(fp);}
    if(text==NULL && test>0)
      {if(vorhandeninauswahl(ohnevornummer(name)))
	  {static char text2[200];
	   sprintf(text=text2,"A - %s",name);
	  }
       else text=name;//test
      }
    if(text==NULL) return NULL;
   }
 mycolor2(farbe);
 mybpencolor(bpen);
 double h=ghoehe/25,b=h/2,ho,x,y=ghoehe/100;
 ho=textsize(b,h);
 x=(gbreite-strlen(text)*b)/2;
 //printf("schrift(x=%lf,y=%lf,'%s')\n",x,y,text);//test
 schrift(x,y,text);
 return text;
}
/************************* Menue Behandlung ****************************/
static int exitflag=0;
void m_exit() {exitflag=1;}
void m_about()
{
 int ok;
 char str[80];
 sprintf(str,"Diasort.cc   %s\nCopyright: %s\nAuthor: %s\n",
	 VERSION,COPYRIGHT,AUTHOR);
 janeinrequester(str);
}
void m_pwd()
{
 char pfad[N80+1];
 int ok;
 strcpy(pfad,pwd.getpfad());
 ok=nachfilenamefragen("Lade aktuellen Ordner",pfad,N80);
 if(ok)
   {//printf("pfad='%s'\n",pfad);//test
    pwd.cd(pfad);
    tmptxtistaktuell=0;
    nbilder=0; sichty=maxsichty=0; bilder_laden();
   }
}
void m_save()
{
 int i;
 if(!textliste.gespeichert) textliste.speichern();
 if(test) printf("%d Bilder auf aktuelle Nummern umbenennen\n",nbilder);
 for(i=0;i<nbilder;i++)
    bilder[i].umbenennen();
 if(test) printf("fertig umbenannt.\n");
 nochnichtgespeichert=0;
}
void m_savexit() {m_save(); exitflag=1;}
void m_refresh()
{
 if(ansicht_modus==VOLLBILD) bilder_laden();
 else neuzeichnen();
}

void mycolor(int r,int g,int b)
{
 if(TIEFE==24) rgbcolor(r,g,b); else color(farbnummer(r,g,b));
}

void neuzeichnen(int a0)
{
 int i;
 inital_new();
 color(hintergrundgrau); ifillbox(0,0,XMAX,YMAX);//grauer Hintergrund
 for(i=a0;i<nbilder;i++)  bilder[jr(i)].zeichnen(istselekt(jr(i)));
 if(untertitelflag && selektbildnr>0 && test>0) //test
     {int nr=jreihenfolge[selektbildnr-1];
      untertitel(bilder[nr].bildname);
     }
 term_refresh();
}
void neuzeichnen_nur1bild(int nr)
{
 int ix0,iy0,x1,y1,x2,y2;
 inital_new();
 koorduser2pix(0.0,YMAX,&ix0,&iy0);
 x1=ix0+bilder[nr].offsetx;
 y1=iy0+bilder[nr].offsety-sichty;
 x2=x1+BB-1; y2=y1+BB-1;
 color(hintergrundgrau); ifillbox(x1,y1,x2,y2);//grauer Hintergrund
 bilder[nr].zeichnen(istselekt(nr));
 term_refresh();
}

//Menu Ansicht
void event_speichern()
{
 if(!textliste.gespeichert) textliste.speichern();
 if(nochnichtgespeichert)
   {int ok=janeinrequester("Aktuelle Reihenfolge speichern?","Ja","Nein");
    if(ok) m_save();
   }
}
void m_normal()
{
 if(ansicht_modus!=NORMAL)
   {ansicht_modus=NORMAL;
    event_speichern();
    BB=95; DB=5; sichtstep=5*(BB+DB);
    tmptxtistaktuell=0;
    nbilder=0; sichty=maxsichty=0; bilder_laden();
   }
 else
   neuzeichnen();
}
void m_gross()
{
 if(ansicht_modus!=GROSS)
   {ansicht_modus=GROSS;
    event_speichern();
    BB=195; DB=5; sichtstep=2*(BB+DB);
    tmptxtistaktuell=0;
    nbilder=0; sichty=maxsichty=0; bilder_laden();
   }
 else
   neuzeichnen();
}

void m_aufraeum()
{
 if(ansicht_modus!=VOLLBILD)
   {if(anzahl<nbilder) anzahl=nbilder;
    event_speichern();
    tmptxtistaktuell=0;
    nbilder=0; sichty=maxsichty=0; bilder_laden();
   }
}

void vollbild_ein()
{
 int tiefe,visklasse;
 double xmin=0,ymin=0,xmax,ymax;
 if(startflag==0) term_exit();
 fullscreen_modus(1);
 getmaxsize(&gbreite,&ghoehe,&tiefe,&visklasse);
 setsize(XMAX=gbreite,YMAX=ghoehe,gtiefe);
 xmax=gbreite; ymax=ghoehe;
 inital(xmin,ymin,xmax,ymax);
 hintergrundgrau=farbnummer(0,0,0);//schwarzer statt grauer Hintergrund
}
int anzahlgeloeschte(int nr)
{
 int n,z=0;
 for(n=0;n<nr;n++)
   if(bilder[jr(n)].loeschflag) z++;
 return z;
}
void m_vollb()
{
 if(ansicht_modus!=VOLLBILD)
   {alter_modus=ansicht_modus;
    ansicht_modus=VOLLBILD;
    event_speichern(); vollbild_ein();
    vollbildnr=(selektbildnr>0)?selektbildnr:1;
    vollbildnr -= anzahlgeloeschte(selektbildnr);//test
    altes_sichty=sichty; sichty=0;
    tmptxtistaktuell=0;
    bilder_laden();
   }
}
void vollbild_aus()
{
 term_exit();
 fullscreen_modus(0);
 grafikfenster_oeffnen();
 if(vollbildnr>1) selektbildnr=vollbildnr;
 ansicht_modus=alter_modus;
 sichty=altes_sichty;
 if(nbilder==0) bilder_laden();
 waitTOF();
 m_refresh();
}
/* void zoom(double z)
{
 zoomfaktor=int(zoomfaktor*z); if(zoomfaktor<=0) zoomfaktor=1;
 neuzeichnen();
} */
void bilder_reihenfolge(int nr[])
{
 int i,j;
 for(i=0;i<nbilder;i++)
     {j=nr[i];
      if(j>=0 && j<nbilder) {jreihenfolge[i]=j;}
     }
 neuzeichnen();
}
void m_reihe()
{
 int ok,i,j,nr[MAXB];
 char str[MAXB*4],*s;
 printf("Liste der geladenen Bilder:\n");
 for(i=0,s=str;i<nbilder;i++)
   {j=jr(i);
    printf(" %d\t%s\n",j,bilder[j].bildname);
    sprintf(s,"%d ",j); if(j>99) s+=4; else if(j>9) s+=3; else s+=2;
   }
 *s=0;
 ok=requester_input(1,"Reihenfolge der Bilder (siehe auch Shell-Fenster)",
		    "%s","%s",str);
 if(ok)
  {for(i=0;i<nbilder;i++)  nr[i] = -1;
   for(i=0,s=str;i<nbilder;i++)
     {sscanf(s,"%d",&nr[i]);
      if(nr[i]>99) s+=4; else if(nr[i]>9) s+=3; else s+=2;
     }
   bilder_reihenfolge(nr);
  }
}

void m_hilfe()
{
 char text[]=
"  Hilfe zu Diasort\n\
  ================\n\
Einschraenkungen:\n\
----------------\n\
- Es koennen maximal 2000 Bilder geladen werden\n\
  (fuer mehr: Quellprogi editieren und MAXB erhoehen)\n\
\n\
Tastenbelegung:\n\
---------------\n\
Taste  Funktion\n\
Home   Auf erste Seite zurueck (oder Taste <)\n\
End    Auf bisher letzte Seite gehen (oder Taste >)\n\
PgUp   Vorherige Seite (oder Pfeiltaste rauf)\n\
PgDn   Naechste Seite (oder Pfeiltaste runter)\n\
y      neu zeichnen (wie Menu refresh)\n\
Del    Bild als geloescht markieren\n\
v      Vollbildmodus (Praesentation) ein/aus\n\
p      Vollbildmodus (Praesentation) ein/aus\n\
Ctrl   Vollbildmodus wieder verlassen (oder 2*Esc)\n\
i      Wie Menu Info\n\
k      Wie Menu Kommentar...\n\
d      Wie Menu Display (Vergroesserte Anzeige)\n\
b      Wie Menu Bilbo...\n\
a      Wie Menu Auswahl (aktuelles Bild in Auswahlordner kopieren)\n\
u      Untertitel ein/aus\n\
q      Programm Verlassen (falls es nichts zu speichern gibt)\n\
\nenglish: see 'Help...'\n";
 janeinrequester(text);
}
void m_help()
{
 char text[]=
"  Help for Diasort\n\
  ================\n\
Limitations:\n\
------------\n\
- Maximum loaded pictures is 2000\n\
  (if you need more: change MAXB in the source)\n\
\n\
keyboard functions:\n\
------------------\n\
Key        Function\n\
Home or <  Go to first page\n\
End  or >  Go to last page yet loaded\n\
PgUp       Previous page (or arrow up)\n\
PgDn       Next page (or arrow down)\n\
y          Refresh (same as menu refresh)\n\
Del        Mark picture as deleted\n\
v or p     fullscreen mode (same as menu Vollbild)\n\
Ctr or Esc Escape from fullscreen mode\n\
i          Like Menu Info\n\
k          Like Menu Kommentar...\n\
d          Like Menu Display\n\
b          Like Menu Bilbo...\n\
a          Like Menu Auswahl (copy actual picture to selection folder)\n\
u          Subtitels on/off\n\
q          Quit programm (if no needs to save)\n\
\ndeutsch: siehe 'Hilfe...'\n";
 janeinrequester(text);
}

void infoextrahieren(FILE *fp,char *text,int max)
{
 int b0,b1,b2,b3,c,i,j,laenge,textstart=0,nzeilen=0,maxzeil=20;
 char *z,*start;
 //printf("infoextrahieren()\n");//test
 b0=(getc(fp)&0xFF);
 b1=(getc(fp)&0xFF);
 for(z=text,j=0;j<max && nzeilen<maxzeil;)
   {if(j==0)
      {j=1;
       if(b0=='G' && b1=='I') //GIF
          {*z++ = b0; if(++j<max) *z++ = b1;
	   while((c=getc(fp))!=EOF && isttext(c) && ++j<max) *z++ = c;
	   *z=0; return;
	  }
      }
    else
      {while((b0=getc(fp))!=EOF && (b0&0xFF)!=0xFF) ;
       b1=getc(fp); if(b1==EOF) break;
      }
    if(b1==0) continue;
    b1&=0xFF;
    if(b1==0xD9) break;//EOI
    if(b1!=0xD8)
      {b2=(getc(fp)&0xFF); b3=(getc(fp)&0xFF);
       laenge=(b2<<8)+b3;
       //printf("Kennung 0x%02X laenge=%d\n",b1,laenge);//test
       if(b1==0xE1 || b1==0xFE) //Exif erkannt, oder in JFIF Creator-Eintrag
	 {for(i=2;i<laenge && j<max && nzeilen<maxzeil;i++)
	   {c=getc(fp);
	    if(isttext(c))
	      {if(textstart==0) {textstart=1; start=z;}
	       *z++ = c; j++;
	      }
	    else if(textstart>0 && c==0)
	      {if(z>start+3)
	         {*z=0;
		  if(strcmp("PrintIM",start)==0) {*start=0; nzeilen=maxzeil;}
		  else {*z++ = '\n'; j++; nzeilen++;}
		 }
	       else z=start;
	       textstart=0;
	      }
	   }
	 }
       else
	 {for(i=2;i<laenge;i++) getc(fp);}//Eintrag ueberlesen
      }
   }
 *z=0;
 return;
}

char *komextrahieren(FILE *fp) //Kommentar extrahieren aus jpg-Datei
{
 const int max=160;
 static char text[max];
 int b0,b1,b2,b3,c,i,k,j,jmax=4*max,laenge;
 char *z;
 *text=0;
 b0=(getc(fp)&0xFF);
 b1=(getc(fp)&0xFF);
 for(j=0;j<jmax;)
   {if(j==0)
       {if(b0=='G' && b1=='I') return NULL;//GIF enthaelt kein Kommentar
        ++j;
       }
    else
       {while((b0=getc(fp))!=EOF && (b0&0xFF)!=0xFF && ++j<jmax) ;
        b1=getc(fp); if(b1==EOF) return NULL;//kein Kommentar gefunden
       }
    if(b1==0) continue;
    b1&=0xFF;
    if(b1==0xD9) return NULL;//EOI
    if(b1!=0xD8)
      {b2=(getc(fp)&0xFF); b3=(getc(fp)&0xFF);
       laenge=(b2<<8)+b3;
       //printf("Kennung 0x%02X laenge=%d\n",b1,laenge);//test
       if(b1==0xFE) //Kommentar-Kennung
	 {for(z=text,i=2,k=0;i<laenge;i++)
	     {c=getc(fp);
	      if(c>0 && ++k<max) *z++ = c;
	     }
	  *z=0;
	  if(strncmp(text,"CREA",4)==0 || istunsinn(text)) *text=0;
	  else break;
	 }
       else
	 {for(i=2;i<laenge;i++) getc(fp);}//Eintrag ueberlesen
      }
   }
 if(*text==0) return NULL;
 return text;
}

int nummeranpassen(int aktnr)
{
 int nr;
 if(ansicht_modus==VOLLBILD)
      {
       //nr=aktnr-1; //Variante1
       //nr=jreihenfolge[aktnr-1]; //Variante2
       //hier gibts einen unerklaerlichen Fehler:
       //Variante1: wenn Reihenfolge veraendert wurde, stimmt Nummer nicht.
       //Variante2: wenn es geloeschte Bilder hat, stimmt Nummer nicht.
       //komplizierte provisorische Loesung:
       nr=jreihenfolge[vollbildaktnr-1];//provi.
      }
 else nr=jreihenfolge[aktnr-1];
 return nr;
}

void m_info()
{
 char text[400], *name;
 int n,nr,aktnr;
 FILE *fp;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {nr=nummeranpassen(aktnr);
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
	sprintf(text,"Bild %d: Bildname unbekannt.",aktnr);
    else if((fp=fopen2(name,"r"))==NULL)
	sprintf(text,"Kann '%s' nicht oeffnen.",name);
    else
      {//printf("name='%s'\n",name);//test
       sprintf(text,"%s\n",name); n=strlen(text);
       infoextrahieren(fp,&text[n],400-n); fclose(fp);
      }
   }
 else strcpy(text,"Fuer Info zuerst ein Bild selektieren.");
 janeinrequester(text);
}

void m_kom() //Bildkommentar
{
 char *s,text[160],cstr1[80], *name;
 int nr,aktnr,ok,fehler=0,farbe=0xFFFFFF,bpen= -1;
 FILE *fp;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {nr=nummeranpassen(aktnr);
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
      {sprintf(text,"Bild %d: Bildname unbekannt.",nr); fehler=1;}
    else if((s=textliste.get(name,&farbe,&bpen))!=NULL)
      {strcpy(text,s);
      }
    else if((fp=fopen2(name,"r"))==NULL)
      {sprintf(text,"Kann '%s' nicht oeffnen.",name); fehler=1;}
    else
      {s=komextrahieren(fp); fclose(fp);
       if(s!=NULL) strcpy(text,s); else text[0]=0;
      }
    if(fehler) janeinrequester(text);
    else
      {sprintf(cstr1,"Bildkommentar fuer %s",name);
       ok=requester_input(3,cstr1,"%s","%s\n",text,
			  "Textfarbe (FFFFFF=weiss)","%X","%X",&farbe,
			  "Hintergrundfarbe (-1=ohne)","%X","%X",&bpen);
       if(ok)
         {textliste.set(name,text,farbe,bpen);
	 }
      }
   }
 else
   {janeinrequester("Fuer Bildkommentar zuerst ein Bild selektieren.");}
 m_refresh();
}

bool bildnameanalyse(const char *name,char *stamm,int *reinr,int *fotonr)
{
 /* Beispiele:
    0123-imgp4567.ppm
    0123-rot1-imgp4567.ppm --> stamm="imgp" *reinr=123 *fotonr=4567
 */
 int n=4,i,imax=40,c;
 if(name[n++]!='-') return false;
 sscanf(name,"%d",reinr);
 if(strncmp(&name[n],"rot",3)==0 && isdigit(name[n+3]))
   {if(name[n+4]=='-') n+=5;
    else if(isdigit(name[n+4]) && name[n+5]=='-') n+=6;
   }
 for(i=1;i<imax && (c=name[n])!=0 && !isdigit(c);n++,i++)
   *stamm++ = c;
 *stamm = 0;
 if(!isdigit(name[n])) return false;
 sscanf(&name[n],"%d",fotonr);
 return true;
}

void m_bilbo() //Bildbearbeitung
{
 char altername[N80],neuername[N80],text[N80],stamm[40];
 char *name;
 int nr,aktnr,ok,fehler=0,reinr,fotonr;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {nr=nummeranpassen(aktnr);
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
      {sprintf(text,"Bild %d: Bildname unbekannt.",nr); fehler=1;}
    else
      {if(strlen(name)>=N80)
	  {printf("Fehler: Dateiname zu lang '%s'\n",name);
	   sprintf(text,"Fehler: Dateiname zu lang"); fehler=1;
	  }
       else if(bildnameanalyse(name,stamm,&reinr,&fotonr)==false)
	  {sprintf(text,"Fehler: Bildname '%s' in unerwartetem Format",name);
	   fehler=1;
	  }
       else
	  system2("bilbo %s",name);
      }
    if(fehler) janeinrequester(text);
    else
      {strcpy(altername,name);
       unlink(endungersetzen(neuername,name,".ppm"));
       sprintf(neuername,"%04d-%s%04da.jpg",reinr,stamm,fotonr);
       ok=requester_input(2,"Alter Bildname","%s","%s\n",altername,
			     "Neuer Bildname","%s","%s",neuername);
       if(ok)
	 {if(vorhanden(neuername))
	     {strcpy(bilder[nr].bildname,neuername);
	      system2("mv %s %s",altername,ohnevornummer(altername));
	     }
	  else janeinrequester("Neue Bilddatei nicht gefunden.");
	 }
      }
   }
 else
   {janeinrequester("Fuer Bilbo zuerst ein Bild selektieren.");}
 m_refresh();
}

static char auswahlordner[80]="auswahl";

bool vorhandeninauswahl(const char *kernname)
{
 char *name;
 FILE *fp;
 if(!vorhanden(auswahlordner)) return false;
 system2("ls -1 %s/ >%s",auswahlordner,tmptxt2);
 fp=fopen(tmptxt2,"r"); if(fp==NULL) return false;
 for(;(name=namelesen(fp))!=NULL;)
   if(strcmp(ohnevornummer(name),kernname)==0)
       {fclose(fp); return true;}
 fclose(fp);
 return false;
}

int nachfotonreinordnen(const char *name,const char *ordner)
{
 int nr,k,reinr,fotonr,reinr2,fotonr2;
 char stamm[40],stamm2[40],*name2;
 FILE *fp;
 if(bildnameanalyse(name,stamm,&reinr,&fotonr)==false) return -1;
 system2("ls -1 %s/ >%s",ordner,tmptxt2);
 fp=fopen(tmptxt2,"r"); if(fp==NULL) return -1;
 for(nr=k=0;(name2=namelesen(fp))!=NULL;)
   {if(!isdigit(name2[0])) continue;
    if(bildnameanalyse(name2,stamm2,&reinr2,&fotonr2)==false) continue;
    if(fotonr2<fotonr)
      {if(k<3) {nr=reinr2; k=0;}//wenn noch nicht 3 groessere Nummern
      }                         //hintereinander, dann hier einordnen.
    else if(fotonr2==fotonr && strcmp(stamm,stamm2)==0)
      {nr= -2; break;}//Bild schon vorhanden
    else if(fotonr2>fotonr) k++;
   }
 fclose(fp);
 return nr;
}

void m_auswahl2(int flag) //Aktuelles Bild in Auswahlordner kopieren
{
 static int nachfrageflag=1,sortmode=0,sortposition=0;
 char *name,text[N80];
 int nr,aktnr,ok,fehler=0;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {nr=nummeranpassen(aktnr);
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
      {sprintf(text,"Bild %d: Bildname unbekannt.",nr); fehler=1;}
    else
      {int c=0,c2=sortmode,c3=sortposition;
       if(nachfrageflag || flag)
	{ok=requester_input(4,
			    "Auswahlordner, in den Bild kopiert werden soll:","%s","%s\n",auswahlordner,
			    "Bei Aufruf ueber A-Taste auch nachfragen? (1=ja, 0=nein)","%d","%d\n",&c,
			    "Sortiermethode (0=Sortiernummer, 1=Fotonummer, 2=bestimmte Position):","%d","%d\n",&c2,
			    "Bei Sortiermethode 2 an folgender Position einsortieren:","%d","%d",&c3);
	 if(!ok) return;
	 nachfrageflag=c;
	 sortmode=c2; sortposition=c3;
	 c=strlen(auswahlordner);
	 if(c<2 || auswahlordner[0]=='.' || auswahlordner[0]=='/')
	   {sprintf(text,"Ungueltiger Ordnername '%s'",auswahlordner);
	    strcpy(auswahlordner,"auswahl"); fehler=1;
	    nachfrageflag=1;
	   }
	 else
	   {if(auswahlordner[c-1]=='/') auswahlordner[c-1]=0;
	    if(!vorhanden(auswahlordner)) system2("mkdir %s",auswahlordner);
	   }
	}
       if(fehler==0 && !vorhanden(auswahlordner))
	 {sprintf(text,"Ordner %s nicht gefunden.",auswahlordner); fehler=1;}
      }
    if(fehler) janeinrequester(text);
    else
      {int ok=1;
       char *ordner=auswahlordner;
       if(sortmode==2)
	 sprintf(scratch,"%s/%04d-%s",ordner,sortposition,ohnevornummer(name));
       else if(sortmode==1)
	 {int nr=nachfotonreinordnen(name,auswahlordner);
	  if(nr>=0)
	    sprintf(scratch,"%s/%04d-%s",ordner,nr,ohnevornummer(name));
	  else if(nr== -2) ok=0;//schon vorhanden, nicht nochmals kopieren
	  else sprintf(scratch,"%s/%s",ordner,ohnevornummer(name));
	 }
       else //(sortmode==0)
	 sprintf(scratch,"%s/",ordner);
       if(ok) system2("cp -d %s %s",name,scratch);
       else if(test) printf("%s Bild mit dieser Fotonummer schon vorhanden\n",
			    name);
      }
   }
 else
   {janeinrequester("Fuer Auswahl zuerst ein Bild selektieren.");}
 m_refresh();
}
void m_auswahl() {m_auswahl2(1);}

void m_display() //Vergroessertes Anzeigen
{
 char text[80],*name;
 int nr,aktnr,ok,fehler=0;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {if(ansicht_modus==VOLLBILD)
      {
       //gleiches Problem wie in m_info.
       nr=jreihenfolge[vollbildaktnr-1];//provi.
      }
    else nr=jreihenfolge[aktnr-1];
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
      {sprintf(text,"Bild %d: Bildname unbekannt.",nr); fehler=1;}
    else
      {system2("display %s",name);
      }
    if(fehler) janeinrequester(text);
   }
 else
   {janeinrequester("Fuer Vergroesserte Ansicht zuerst ein Bild selektieren.");}
 m_refresh();
}

/************************ neue Funktionen *****************************/
static char nummernliste[10000];

bool keinedoppeltenummern(FILE *fp)
{
 char z[200];
 int i,nr,anzahldoppelte=0;
 for(i=1;i<10000;i++) nummernliste[i]=0;
 nummernliste[0]=1;//Nummer 0000 wird zu 0001 was dann eine doppelte Nr gibt.
 for(;getline(fp,z,200);)
   {if(isdigit(z[0]) && isdigit(z[1])
       && isdigit(z[2]) && isdigit(z[3]) && z[4]=='-')
       {sscanf(z,"%d",&nr);
	if(nummernliste[nr]++) anzahldoppelte++;
       }
   }
 return (anzahldoppelte==0);
}
void bildnummernkorrigieren(FILE *fp)
{
 char z[200],neuername[200];
 int nr,aktnr,err;
 for(aktnr=1;getline(fp,z,200);aktnr++)
   if(isdigit(z[0]) && isdigit(z[1])
      && isdigit(z[2]) && isdigit(z[3]) && z[4]=='-')
       {sscanf(z,"%d",&nr);
	if(aktnr==1 && nr>aktnr) aktnr=nr;//erste Nummer kann groesser 1 sein
	if(nr!=aktnr)
	  {sprintf(neuername,"%04d-%s",aktnr,&z[5]);
	   err=rename(vollpfad(z),vollpfad(neuername));
	   if(err)
	     {printf("Fehler %d: rename(%s,%s)\n",err,z,neuername);
	      fehlermeldung(err);
	      exit(0);
	     }
	  }
       }
}

void tmptxtaktualisieren()
{
 FILE *fp;
 system2("ls -1 >%s",tmptxt);
 fp=fopen(tmptxt,"r");
 if(fp==NULL) {printf("Fehler: kann %s nicht oeffnen\n",tmptxt); exit(0);}
 bool ok=keinedoppeltenummern(fp);
 fclose(fp); 
 if(!ok)
   {ok=janeinrequester("Es gibt doppelte Nummern.\nAlle Dateien auf eindeutige Nummern umbenennen?",
		       "ja - umbenennen","nein - abbrechen");
    if(!ok) {printf("Nichts umbenennen - Programm abgebrochen um zu verhindern dass Bilder durcheinander geraten!\n"); exit(0);}
    fp=fopen(tmptxt,"r");
    if(fp==NULL)
      {printf("Fehler: kann %s nicht wieder oeffnen\n",tmptxt); exit(0);}
    bildnummernkorrigieren(fp);
    fclose(fp);
    system2("ls -1 >%s",tmptxt);
   }
 tmptxtistaktuell=1;
}

void bilder_laden() //Bilder einlesen und als Vorschaubildchen zeichnen
{
 char name[N80];
 FILE *fp;
 if(argflag['F'])
   {if(reihenfolgedatei[0]==0)
       {printf("Fehler: keine Reihenfolgedatei.\n"); exit(0);}
    fp=fopen(reihenfolgedatei,"r");
    if(fp==NULL)
      {printf("Fehler: kann '%s' nicht oeffnen.\n",reihenfolgedatei); exit(0);}
   }
 else
   {if(!tmptxtistaktuell) tmptxtaktualisieren();
    fp=fopen(tmptxt,"r");
    if(fp==NULL)
      {printf("konnte %s nicht oeffnen - versuche nochmals\n",tmptxt);
       for(int i=2;i<=10 && fp==NULL;i++)//test
	 {Delay(10); fp=fopen(tmptxt,"r");
	  if(fp==NULL) printf("auch beim %d.Versuch gescheitert\n",i);
	  else printf("%d.Versuch --> ok.\n",i);
	 }
       if(fp==NULL) exit(0);
      }
    tmptxtistaktuell=1;
   }
 inital_new();
 color(hintergrundgrau); ifillbox(0,0,XMAX,YMAX);//grauer Hintergrund
 int nr=1,ok=1;
 while(ok && fscanf(fp,"%s",name)==1)
    if(index(name,".jpg")>0 || index(name,".JPG")>0
       || index(name,".png")>0 || index(name,".gif")>0
       || index(name,".PNG")>0 || index(name,".GIF")>0)
       {
	if(ansicht_modus==VOLLBILD) ok=vollbild_laden(name,nr++);
	else ok=bild_laden(name,nr++);
       }
 if(ansicht_modus==VOLLBILD) maxvollbilder=nr-1;
 term_refresh();
 fclose(fp);
}

char *namelesen(FILE *fp)
{
 static char name[200];
 int c;
 *name=0;
 do {if((c=getc(fp))==EOF) return NULL;
     ungetc(c,fp);
     c=fscanf(fp,"%s",name);
     if(c!=1 || *name==0 || *name=='\n') return NULL;
    }
 while(index(name,".")<1);
 return name;
}

void sode(char *reihenfolge,char *ordner)
{ //macht Vorbereitungen: Reihenfolgedatei lesen, Bilder kopieren
  int ok,nummer,err,n;
 char *name,sname[N80],neuername[N80],antw[40];
 FILE *fp=fopen(reihenfolge,"r");
 if(!fp) {printf("%s nicht gefunden.\n",reihenfolge); return;}
 if(istordner(ordner))
   {printf("Ordner '%s' schon vorhanden, Dateien werden vielleicht ueberschrieben.\n",ordner);
    printf("trotzdem diesen Ordner verwenden? ");
    n=scanf("%s",antw); if(n!=1) {fehlerscanf(1,n); *antw=0;}
    if(*antw!='j' && *antw!='J' && *antw!='Y' && *antw!='y')
      {fclose(fp); return;}
   }
 else if(vorhanden(ordner))
   {printf("'%s' ist kein Ordner.\n",ordner); fclose(fp); return;}
 else
   {printf("erstelle Ordner '%s'\n",ordner);
    system2("mkdir %s",ordner);
   }
 if(argflag['S']) printf("Links werden angelegt:\n");
 else printf("Dateien werden kopiert:\n");
 for(nummer=1;(name=namelesen(fp))!=NULL;)
   {ok=vorhanden(name);
    if(!ok) {machklein(name); ok=vorhanden(name);}
    if(ok)
       {if(isdigit(name[0]) && isdigit(name[1]) && isdigit(name[2])
	   && isdigit(name[3]) && name[4]=='-')
	     sprintf(neuername,"%s/%04d-%s",ordner,nummer,&name[5]);
        else sprintf(neuername,"%s/%04d-%s",ordner,nummer,name);
        //if(vorhanden(neuername)) unlink(neuername);
        printf("%s --> %s\n",name,neuername);
        if(argflag['S'])
	  {sprintf(sname,"../%s",name); err=symlink(sname,neuername);
	   if(err) fehlermeldung(err);
	  }
	else system2("cp %s %s",name,neuername);
	nummer++;
       }
    else
	printf("Datei %s nicht gefunden.\n",name);
   }
 fclose(fp);
}

/************************* Hauptprogramm ******************************/
void grafikfenster_oeffnen()
{
 double xmin=0,ymin=0,xmax=XMAX,ymax=YMAX;
 setmenu(4,"File",     "Ansicht","Bearbeitung", "Help");
 setmenu(4,"About ...","Normal", "Info",        "Hilfe ...",m_about,m_normal,m_info,m_hilfe);
 setmenu(4,"Ordner...","Gross",  "Kommentar...","Help ...", m_pwd, m_gross, m_kom, m_help);
 setmenu(3,"Save",     "Vollbild","Display", m_save, m_vollb, m_display);
 setmenu(3,"Save & Exit","Aufraeumen","Bilbo ...", m_savexit,m_aufraeum,m_bilbo);
 setmenu(3,"Exit",     "Refresh",  "Auswahl...", m_exit,m_refresh,m_auswahl);
 set_funktions(mauspre,mausrel,NULL,mausmot);
 inital(xmin,ymin,xmax,ymax);
 char titel[80];
 sprintf(titel,"diasort %s",VERSION);
 set_tektitel(titel);
 if(gtiefe<24) farben_init();
 hintergrundgrau=farbnummer(128,128,128);
 term_refresh();
 waitTOF();
 startflag=0;
}

//ab xtekplot1-Version 2.87 sollte direkter Aufruf von waitmenu() auch gehen
inline int mywaitmenu(int n) {return (startflag==0 ? waitmenu(n) : 0);}

main(int argc,char *argv[])
{
 int c,i,j,visklasse,tmpvorbehalten=0;
 char ordnername[N80]; reihenfolgedatei[0]=0; ordnername[0]=0;
 if(argc<=0 || (argc==1 && *argv[0]=='/'))//Start von Grafischer Oberflaeche
   {j=0;/* von WorkBench (Amiga) oder von z.B. KDE (Linux) gestartet */
    //if(argc==1) pwd.set(argv[0]);//test
    pwd.set("/cdrom/fotos/diashow/");
    //pwd.set("/musik/knxmaster/fotos/diashow/");//test
   }
 else
  for(j=0,i=1;i<argc;i++)
        {if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else if(isdigit(c)) sscanf(argv[i],"%d",&anzahl);
         else   {if(++j==1) strcpy(reihenfolgedatei,argv[i]);
	         else if(j==2) strcpy(ordnername,argv[i]);
        }       }
 if(argflag['?'] || argflag['H'] || j>MAXARG)
	{printf("diasort  %s\n",VERSION);
	 printf("Anwendung: diasort [-Flags] [reihenfolge.txt] [ordner]\n");
	 printf("  Flags: v=Verbose (also mit Testausdrucken)\n");
	 printf("         t=andere Farbtiefe (%d statt %dBit)\n",
		TIEFE2,TIEFE);
	 printf("         c=Kopiere die Bilddateien in neuen Ordner\n");
	 printf("         s=Softlinks der Bilddateien in neuem Ordner erstellen\n");
	 printf("         f=Reihenfolgedatei lesen und nur diese Bilder verwenden\n");
	 printf("         p=Praesentation im Vollbildmodus\n");
	 printf("         a=Automatisch eine Anzahl Bilder einlesen\n");
	 printf("         b=Behalte Temporaere Vorschaubilder\n");
	 printf("         L=alle Dateien in Soft-Links umwandeln\n");
	 printf("         U=Automodus\n");
	 printf("Beispiele:\n");
	 printf(">diasort -s diashow   #typischer erster Aufruf\n");
	 printf(">cd diashow           #in neuen Ordner wechseln\n");
         printf(">diasort -p           #starten im Vollbildmodus\n");
	 printf("etwas speziellere Beispiele:\n");
	 printf(">diasort -sf reihenfolge.txt diashow\n");
	 printf(">diasort -va 200   #mit Testausdrucken, erste 200 Bilder einlesen\n");
	 printf(">diasort -vv       #mit noch mehr Testausdrucken\n");
	 exit(0);
	}
 if(argflag['L'])
  {printf(
"Alle Bild-Dateien in Soft-Links auf uebergeordneten Ordner umwandeln.\n\
Die urspruenglichen Dateien werden in name.old umbenannt.\n\
Soll das wirklich gemacht werden?");
    c=scanf("%s",scratch); if(c!=1) {fehlerscanf(1,c); scratch[0]=0;}
    if((c=scratch[0])=='j' || c=='J' || c=='y' || c=='Y')
      {system2("ls -1 >%s",tmptxt);
       char *name,ueberdatei[N80+4];
       FILE *fp=fopen(tmptxt,"r");
       if(!fp) {printf("Fehler: kann %s nicht oeffnen.\n",tmptxt); exit(0);}
       for(;(name=namelesen(fp))!=NULL;)
	 {//printf("name='%s'\n",name);//test
	  if(strlen(name)>=N80) {printf("Name zu lang: '%s'\n",name); continue;}
	  sprintf(ueberdatei,"../%s",ohnevornummer(name));
	  if(istbilddatei(name) && istregulaer(name) && vorhanden(ueberdatei))
	    {system2("mv %s %s.old",name,name);
	     if(vorhanden(name))
		printf("Fehler: umbenennen von '%s' misslungen\n",name);
	     else
	       {system2("ln -s ../%s %s",ohnevornummer(name),name);
		if(!vorhanden(name))
		  printf("Fehler: Link '%s' erstellen misslungen\n",name);
		else printf("Link '%s' erstellt\n",name);
	       }
	    }
	  else if(test>0) printf("Datei '%s' unveraendert\n",name);//test
	 }
       fclose(fp);
      }
    else printf("nein - nichts veraendert.\n");
    exit(0);
   }
 if(argflag['T']) TIEFE=TIEFE2;
 if(argflag['F'] && reihenfolgedatei[0]==0)
   {printf("Reihenfolgedatei: "); c=scanf("%s",reihenfolgedatei);}
 if(argflag['C'] || argflag['S'])
   {if(!argflag['F'])
      {strcpy(ordnername,reihenfolgedatei);
       system2("ls -1 >%s",tmptxt); strcpy(reihenfolgedatei,tmptxt);
      }
    if(ordnername[0]==0)
      {printf("neuer Ordner: "); c=scanf("%s",ordnername);}
    sode(reihenfolgedatei,ordnername);
    if(!argflag['F']) unlink(tmptxt);
    exit(0);
   }
 //if(argflag['V'] && test>=2) tek_setdebug(test-1);//test
 if(argflag['A'] && anzahl<2)
   {printf("Minimale Anzahl zu ladende Bilder:"); c=scanf("%d",&anzahl);}
 if(argflag['B'] || vorhanden("tmpvor")) tmpvorbehalten=1;
 if(!argflag['F'] && j==1)
   {strcpy(ordnername,reihenfolgedatei); reihenfolgedatei[0]=0;
    pwd.cd(ordnername);
   }
 if(argflag['U'] && autopause<0)
   {printf("Wartezeit im Automodus:"); c=scanf("%d",&autopause);
    if(autopause>2) autopause-=2; //Ladezeit subtrahieren
    autopause *= 60; //Anzahl Bilddurchlaeufe pro Sekunde
    printf("Anzahl Durchlaufen lassen aller Bilder:"); c=scanf("%d",&automodus);
    if(automodus<1) automodus=1;
   }
 //Ordner fuer temporaere Dateien anlegen:
 for(i=1;i<10;i++)
   {sprintf(tmpord,"tmp%d",i);
    if(!vorhanden(tmpord))
      {system2("mkdir %s",tmpord);
       sprintf(tmptxt,"tmp%d/tmp.txt",i);
       sprintf(tmptxt2,"tmp%d/tmp2.txt",i);
       if(test) printf("Ordner %s angelegt tmptxt='%s'\n",tmpord,tmptxt);
       break;
      }
   }
 if(i==10 || !vorhanden(tmpord))
   {printf("Fehler: kann Verzeichnis %s nicht anlegen\n",tmpord); exit(0);}
 getmaxsize(&gbreite,&ghoehe,&gtiefe,&visklasse);
 if(argflag['V']) printf("gbreite=%d ghoehe=%d gtiefe=%d visklasse=%d\n",
			 gbreite,ghoehe,gtiefe,visklasse);
 if(gtiefe>TIEFE) gtiefe=TIEFE;
 else if(gtiefe<TIEFE)
   {printf("Warnung: Farbtiefe kleiner als %d: gtiefe=%d\n",TIEFE,gtiefe);}
 setsize(XMAX=gbreite,YMAX=ghoehe,TIEFE=gtiefe);
 //XMAX,YMAX,TIEFE koennten noch wegoptimiert werden.
 if(gtiefe<24) setmaxfarben(1<<gtiefe);
 int vollbildstartflag = (argflag['P']) ? 1 : 0;//ev. Start im Vollbildmodus
 grafikfenster_oeffnen(); bilder_laden();//erst mal normaler Start
 textliste.laden();
 if(nbilder>0) selektbildnr=1;
 int taste,asci,vorher= -1,ipause=0; ULONG rawcode;
 while(exitflag==0 && mywaitmenu(0)==0)
  {waitTOF(); //auf Beginn des Bildaufbaus warten
   if(nbilder<anzahl && nbilder>vorher) //mindestens "anzahl" Bilder einlesen
     {vorher=nbilder; scrollen(4);}
   else if(vollbildstartflag) {m_vollb(); vollbildstartflag=0;}
   else if(keyget(&taste,&asci,&rawcode)!=0)
     {switch(rawcode)
	{case 0xFF51: case 0xFF52: case 0xFF53: case 0xFF54://Pfeiltasten
			scrollen(rawcode-0xFF50);
	 CASE 0xFF1B: case 0xFFE3: //Esc oder Ctrl
			if(ansicht_modus==VOLLBILD) vollbild_aus();
	 CASE 0xFFFF: case 0xFF60: case 0xFF08://Delete oder Backspace
		if(ansicht_modus!=VOLLBILD && selektbildnr>0) bild_loeschen();
	 CASE 0xFFE1: case 0xFFE2://Shifttaste
			//noch auswerten zum mehrere Bilder verschieben
	 CASE 0xFF55: scrollen(2); //Page Up
	 CASE 0xFF56: scrollen(4); //Page Down
	 CASE 0xFF50: case '<'://Home
		if(ansicht_modus==VOLLBILD) scrollen(2,1);
		else if(sichty>0) scrollen(2,sichty);
	 CASE 0xFF57: case '>'://End
		if(ansicht_modus==VOLLBILD) scrollen(4,1);
		else if(sichty<maxsichty) scrollen(4,maxsichty-sichty);
	 CASE 'y': case 'Y': m_refresh();
	 CASE 'v': case 'V': case 'p': case 'P':
		if(ansicht_modus==VOLLBILD) vollbild_aus(); else m_vollb();
	 CASE 'u': case 'U': untertitelflag^=1; m_refresh();
	 CASE 'q': case 'Q':
		     if(nochnichtgespeichert==0 && textliste.gespeichert)
		        exitflag=1;
		     else if(ansicht_modus==VOLLBILD) vollbild_aus();
	 CASE 'i': case 'I': m_info();
	 CASE 'k': case 'K': m_kom();
	 CASE 'd': case 'D': m_display();
	 CASE 'b': case 'B': m_bilbo();
	 CASE 'a': case 'A': m_auswahl2(0);
	 DEFAULT:
	   if(test) printf("taste=%d=%02X asci=0x%02X='%c' rawcode=0x%04lX\n",
			    taste,taste,asci,asci,rawcode);
	}
     }
   else if(automodus && ansicht_modus==VOLLBILD)
     {if(++ipause>=autopause)
	 {if(vollbildnr<nbilder) scrollen(4); //Page Down
	  else {if(--automodus>0) vollbildnr=0;}
	  ipause=0;
	 }
     }
  }
 if(!textliste.gespeichert)
   textliste.speichern();//ohne Rueckfrage
 if(nochnichtgespeichert)
   {int ok=janeinrequester("Aktuelle Reihenfolge speichern?","Ja","Nein");
    if(ok) m_save();
   }
 term_exit();
 //temporaere Dateien loeschen:
 if(vorhanden(tmpppm)) {unlink(tmpppm); if(test) printf("unlink(%s)\n",tmpppm);}
 if(vorhanden(tmptxt)) {unlink(tmptxt); if(test) printf("unlink(%s)\n",tmptxt);}
 unlink(tmptxt2);
 if(vorhanden(tmpord)) {rmdir(tmpord); if(test) printf("rmdir(%s)\n",tmpord);}
 if(tmpvorbehalten==0) system1("rm -r tmpvor");
 return 0;
}/* ende von main */

void scrollen(int richtung,int step)
{
 //printf("scrollen(%d,%d)\n",richtung,step);//test
 if(ansicht_modus==VOLLBILD)
   {if(richtung==2 && vollbildnr>1)
        {vollbildnr--; if(step>0) vollbildnr=1;}
    else if(richtung==4 && vollbildnr<maxvollbilder)
        {vollbildnr++; if(step>0) vollbildnr=maxvollbilder;}
    bilder_laden();
    return;
   }
 if(richtung==1 || richtung==3)
    {
     if(selektbildnr>0) //Bild drehen
        {int nr=jreihenfolge[selektbildnr-1];
	 bilder[nr].einfachesdrehen((4-richtung)*90);
	 bilder[nr].rotnr += (richtung==1)?-1:1;
	 nochnichtgespeichert=1;
	 neuzeichnen_nur1bild(nr);
	}
     return;
    }
 if(step==0) step = (zoomfaktor>100) ? sichtstep*100/zoomfaktor : sichtstep;
 switch(richtung)
   {case 1: sichtx -= step;  break;
    case 2: sichty -= step;  break;
    case 3: sichtx += step;  break;
    case 4: sichty += step;  break;
   }
 if(sichty>maxsichty) {bilder_laden(); maxsichty=sichty;}
 else neuzeichnen();
}
void bild_loeschen()
{
 int nr=jreihenfolge[selektbildnr-1];
 bilder[nr].loeschflag ^= 1;
 nochnichtgespeichert=1;
 neuzeichnen_nur1bild(nr);
}
void bildertauschen(int i,int j)
{
 if(nbilder>1 && j!=i && j>=0 && j<nbilder && i>=0 && i<nbilder)
   {int h=jreihenfolge[i];
    jreihenfolge[i]=jreihenfolge[j];
    jreihenfolge[j]=h;
    int j1=jreihenfolge[i],j2=jreihenfolge[j];
    h=bilder[j1].sortiernummer;
    bilder[j1].sortiernummer=bilder[j2].sortiernummer;
    bilder[j2].sortiernummer=h;
    h=bilder[j1].offsetx;
    bilder[j1].offsetx=bilder[j2].offsetx;
    bilder[j2].offsetx=h;
    h=bilder[j1].offsety;
    bilder[j1].offsety=bilder[j2].offsety;
    bilder[j2].offsety=h;
    nochnichtgespeichert=1;
   }
}

int bildnummerausposition(int ix,int iy,int& x1,int& y1,int& x2,int& y2)
{
 int nr,xo,yo;
 for(nr=1,xo=yo=DB;;nr++)
     {x1=xo; y1=yo-sichty; x2=x1+BB; y2=y1+BB;
      if(ix>x1 && ix<x2 && iy>y1 && iy<y2) break;
      if((xo+=BB+DB)>gbreite-BB-DB)
	{yo+=BB+DB; xo=DB;
	 if(yo-sichty>ghoehe-BB) {nr=0; break;}
	}
     }
 if(nr>nbilder+1) nr=0;
 return nr;
}
int bildnummerausposition(int ix,int iy)
{
 int x1,y1,x2,y2;
 return bildnummerausposition(ix,iy,x1,y1,x2,y2);
}

void mausbewegung(int flag)
{
 int ix,iy,tasten;
 static int x1,y1,x2,y2,x10,y10,x20,y20,nr=0;//aktuelle Selektion
 static int xa,ya,xb,yb,nr2=0;//Zielposition
 static int dy=0,ix0,iy0;
 if(ansicht_modus==VOLLBILD) {gedruecktemaustaste=selektbildnr=nr=0; return;}
 tasten=imausposition(&ix,&iy);
 iy-=dy;
 if(flag==1 && nr2>0)
   {flag=2;//verlorenes Maustaste-Loslassen-Event nachholen
   }
 if(flag==1) //Maustaste gedrueckt
  {if(selektbildnr>0)
     {color(hintergrundgrau); idrawbox(x10,y10,x20,y20);//grau
      selektbildnr=0;
     }
   if(test>=2) printf("Mousepress %d x=%d y=%d\n",tasten,ix,iy);
   gedruecktemaustaste=1;
   if(dy==0) {dy=get_menuleistenhoehe(); iy-=dy;}
   nr=bildnummerausposition(ix,iy,x1,y1,x2,y2);
   if(nr>0)
     {mycolor(255,0,0); //roter Rahmen um selektiertes Bild
      idrawbox(x10=x1,y10=y1+dy,x20=x2,y20=y2+dy);
      drawmode(COMPLEMENT);
      idrawbox(x1,y1+dy,x2,y2+dy);
      ix0=ix; iy0=iy;
     }
  }
 else if(flag==2) //Maustaste losgelassen
  {if(test>=2) printf("Mouserelease %d x=%d y=%d\n",tasten,ix,iy);
   gedruecktemaustaste=0;
   if(nr>0)
     {
      drawmode(COMPLEMENT);
      idrawbox(x1,y1+dy,x2,y2+dy);
      drawmode(JAM1);
      if(nr2==0 && bildnummerausposition(ix,iy)==nr && nr<=nbilder)
	selektbildnr=nr;
      else
	{color(hintergrundgrau);idrawbox(x10,y10,x20,y20);}//grauer Rahmen
      if(nr2>0)
	{
	 idrawbox(xa-DB+1,ya+dy,xa-1,yb+dy);
	 if(nr2<nr)
	   {for(;nr>nr2;--nr)
	     {bildertauschen(nr-1,nr-2);//-1 weil jreihenfolge mit 0 beginnt!
	      //printf("vertausche %d mit %d\n",nr,nr-1);//test
	     }
	   }
	 else if(nr2>nr+1)
	   {for(;nr+1<nr2;nr++)
	     {bildertauschen(nr-1,nr);
	      //printf("vertausche %d mit %d\n",nr,nr+1);//test
	     }
	   }
	 else printf("Fehler: nr==nr2 (%d==%d)\n",nr,nr2);//test
	 nr2=0;
	 neuzeichnen();
	}
      nr=0;
     }
  }
 else if(flag==3) //Mausbewegung
   {//if(test>=2) printf("Mousemove %d x=%d y=%d\n",tasten,ix,iy);
    if(nr>0)
      {drawmode(COMPLEMENT);
       idrawbox(x1,y1+dy,x2,y2+dy);
       x1+=ix-ix0; y1+=iy-iy0;
       x2+=ix-ix0; y2+=iy-iy0;
       ix0=ix; iy0=iy;
       idrawbox(x1,y1+dy,x2,y2+dy);
       drawmode(JAM1);
       if(nr2>0)
	 {mycolor(128,128,128);
	  idrawbox(xa-DB+1,ya+dy,xa-1,yb+dy);
	 }
       nr2=bildnummerausposition(ix+BB/2,iy,xa,ya,xb,yb);
       if(nr2==nr || nr2==nr+1) nr2=0;
       if(nr2>0)
	 {mycolor(255,0,0);
	  idrawbox(xa-DB+1,ya+dy,xa-1,yb+dy);
	 }

      }
  }
}
void mauspre() {mausbewegung(1);}
void mausrel() {mausbewegung(2);}
void mausmot() {if(gedruecktemaustaste) mausbewegung(3);}
