/* exifsort.cc			letzte Aenderung: 12.2.2009 */
#define VERSION "Version 0.01"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Musterprogramm um Dateien zu listen

History:
10.2.2009	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

/************************* Vordeklarationen ***************************/
const int N80=80; //maximale Laenge der Dateinamen
void exifsort(const char *ordner);
void exifsortmitsortierung(const char *ordner);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
static int test=0;
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='V') test++;
  }
}

/*********************** Exif extrahieren *****************************/
const int MAXTAG=200,MAXPU=20000;
static char puffer[MAXPU];//provi.

class Exif
{
 unsigned char head1[16];
 bool bigendian;
 long nb;//Anzahl gelesene Bytes
 long offset,zeit1,zeit2,zeit3;
 int ntags;
 int tag[MAXTAG],tagtyp[MAXTAG];
 long tagwert[MAXTAG],taganz[MAXTAG];
 int pufferlesen2(char *p0=NULL);
 long pufferlesen4(char *p0=NULL);
public:
 Exif() {bigendian=false; ntags=0; nb=0;}
 int headerlesen(FILE *fp);
 int wordlesen(FILE *fp);
 long longlesen(FILE *fp);
 void tagslesen(FILE *fp,int n=0);
 const char *tagauswerten(int t);
 const char *einentagauswerten(int i);
 void alletagsauswerten();
};
static Exif exif;

int Exif::headerlesen(FILE *fp) //Rueckgabe im Fehlerfall=0
{
 int c,i,j;
 for(i=0;i<16 && (c=getc(fp))!=EOF;i++)
    head1[i]=c;
 if((head1[0]&0xFF)!=0xFF || (head1[1]&0xFF)!=0xD8)
   {fprintf(stderr,"SOI fehlt\n"); return 0;}
 if((head1[2]&0xFF)!=0xFF || (head1[3]&0xFF)!=0xE1)
   {for(j=0;j<100 && ((head1[2]&0xFF)!=0xFF || (head1[3]&0xFF)!=0xE1);j++)
       {for(int k=2;k<14;k++)
	   {head1[k]=head1[k+2]; head1[k+1]=head1[k+3];}
	head1[14]=getc(fp); head1[15]=getc(fp);
       }
     if(j==100) {fprintf(stderr,"APP1 fehlt\n"); return 0;}
   }
 const char *head2=(char*)&head1[6];
 if(strcmp(head2,"Exif")!=0) {fprintf(stderr,"Exif fehlt\n"); return 0;}
 nb=16;
 if(test) fprintf(stderr,"Exif ");
 bigendian=(head2[6]=='M');
 if(test) fprintf(stderr,"%s\n",(bigendian)?"Big-Endian":"Little-Endian");
 if(head2[7]!=head2[6])
    fprintf(stderr,"Fehler im TIFF-Header: Exif %s\n",&head2[6]);
 if(bigendian) c=head2[9]+(head2[8]<<8);
 else c=head2[8]+(head2[9]<<8);
 if(c!=0x2A) fprintf(stderr,"Fehler im TIFF-Header: %s 0x%04X\n",&head2[6],c);
 long n1=longlesen(fp);
 for(long j=8;j<n1;j++) getc(fp);//Offset nach dem TIFF-Header ueberlesen
 return i;
}
long Exif::longlesen(FILE *fp)
{
 long n;
 unsigned char c1,c2,c3,c4;
 c1=getc(fp); c2=getc(fp); c3=getc(fp); c4=getc(fp);
 nb+=4;
 if(bigendian)
      n=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 else n=(c4<<24)+(c3<<16)+(c2<<8)+c1;
 return n;
}
int Exif::wordlesen(FILE *fp)
{
 int n;
 unsigned char c1,c2;
 c1=getc(fp); c2=getc(fp);
 nb+=2;
 if(bigendian)
      n=(c1<<8)+c2;
 else n=(c2<<8)+c1;
 return n;
}
int Exif::pufferlesen2(char *p0)
{
 static unsigned char *p=NULL;
 int n;
 unsigned char c1,c2;
 if(p0!=NULL) p=(unsigned char*)p0;
 c1= *p++; c2= *p++;
 if(bigendian)
      n=(c1<<8)+c2;
 else n=(c2<<8)+c1;
 return n;
}
long Exif::pufferlesen4(char *p0)
{
 static unsigned char *p=NULL;
 long n;
 unsigned char c1,c2,c3,c4;
 if(p0!=NULL) p=(unsigned char*)p0;
 c1= *p++; c2= *p++;
 c3= *p++; c4= *p++;
 if(bigendian)
      n=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 else n=(c4<<24)+(c3<<16)+(c2<<8)+c1;
 return n;
}

const int TYP_BYTE=1,TYP_ASCII=2,TYP_SHORT=3,TYP_LONG=4,TYP_RATIONAL=5;
const int TYP_UNDEFINED=7,TYP_SLONG=9,TYP_SRATIONAL=10;

//LONG-Tags:
const int TAG_ExifIFD=0x8769,TAG_GPSIFD=0x8825,TAG_Interop=0xA005,
  TAG_ExifWidth=0xA002,TAG_ExifHeight=0xA003,
//ASCII-Tags:
  TAG_DateTime=0x132, //Datum und Zeit in der Form "2008:11:30 08:15:00"
  TAG_DateOrig=0x9003,//Aufnahme-Datum+Zeit
  TAG_DateDigi=0x9004,//Digitalisierungs-Datum+Zeit
  TAG_Make=0x10F, //Kamera-Hersteller
  TAG_Model=0x110,//Kamera-Modell
  TAG_ImageDesc=0x10E,TAG_Software=0x131,TAG_Artist=0x13B,TAG_Copyr=0x8298;

void Exif::tagslesen(FILE *fp,int n)
{
 int i;
 bool nullterifd;
 if(test) fprintf(stderr,"tagslesen() nb=0x%X\n",nb);//test
 if(n==0)
   {n=wordlesen(fp);
    if(test) fprintf(stderr,"Anzahl Exif-Tags n=%d nb=%d=0x%X\n",n,nb,nb);//test
    nb+=offset;
    nullterifd=false;
   }
 else
   nullterifd=true;
 offset=0;
 ntags=0;
 for(i=0;i<n;i++)
   {tag[ntags]=wordlesen(fp);
    tagtyp[ntags]=wordlesen(fp);
    taganz[ntags]=longlesen(fp);
    tagwert[ntags]=longlesen(fp);
    if(test) printf("tag=0x%X typ=%d anzahl=%d wert=0x%04X\n",
		    tag[ntags],tagtyp[ntags],taganz[ntags],tagwert[ntags]);//test
    if(nullterifd==false && tagtyp[ntags]==TYP_ASCII && taganz[ntags]>4)
      {long m=tagwert[ntags]+taganz[ntags];
       if(m>offset) offset=m; //provi. andere tagtypen auch beruecksichtigen
      }
    switch(tag[ntags])
      {case TAG_ExifIFD:
	  offset=tagwert[ntags];
	  if(test) fprintf(stderr," ExifID-Pointer Offset=0x%X\n",offset);
	  break;
       case TAG_DateTime: zeit1=tagwert[ntags]; break;
       case TAG_DateOrig: zeit2=tagwert[ntags];	break;
       case TAG_DateDigi: zeit3=tagwert[ntags]; break;
       case TAG_Make: case TAG_Model:
	  break;
       case TAG_ImageDesc: case TAG_Software: case TAG_Artist: case TAG_Copyr:
	  break;
       default:
	 if(test>=2) fprintf(stderr,"Unbekannter Tag: 0x%X Typ=%d\n",
			    tag[ntags],tagtyp[ntags]);
	 //--ntags; //unbekannte Tags verwerfen
      }
    if(ntags>=MAXTAG-1) fprintf(stderr,"zu wenig Platz fuer %d Tags\n",ntags);
    else ntags++;
   }
 if(nullterifd)
   {if(offset==0) {fprintf(stderr,"fehlender ExifID-Pointer\n"); offset=2000;}
    offset -= nb-12;
   }
 else
   {if(offset==0) {fprintf(stderr,"Fehler: offset==0\n"); offset=2000;}
    else offset+=100;//provi.
   }
 char *s;
 if(offset<=0) {fprintf(stderr,"Fehler: offset zu klein\n"); offset=0;}
 if(test) printf("%d Bytes einlesen\n",offset);
 if(offset>MAXPU)
   {fprintf(stderr,"Offset=0x%X zu gross\n",offset); offset=MAXPU;}
 for(i=0,s=puffer;i<offset;i++)
   *s++ = getc(fp);
 if(test>=2) for(i=0;i<32;i++) //test
   {printf("%02X",puffer[i]); if(i&1) printf(" "); if(i%16==15) printf("\n");}
}
const char* Exif::tagauswerten(int t)
{
 //if(test) fprintf(stderr,"Exif::tagauswerten(0x%X)  nb=0x%X\n",t,nb);//test
 int i;
 for(i=0;i<ntags && tag[i]!=t;i++) ;
 if(i==ntags) return NULL;
 return einentagauswerten(i);
}
const char* Exif::einentagauswerten(int i)
{
 static char str[80];
 long uk=nb-12;
 if(tagtyp[i]==TYP_ASCII)
   {if(taganz[i]<=4) return (char*)tagwert[i];
    return &puffer[tagwert[i]-uk];
   }
 if(tagtyp[i]==TYP_SHORT)
   {unsigned short a,b,c;
    if(taganz[i]==1) {a=tagwert[i]>>16; sprintf(str,"%d",a);}
    else if(taganz[i]==2) {a=tagwert[i]>>16; b=tagwert[i]&0xFFFF;
                           sprintf(str,"%d",a);}
    else
       {a=pufferlesen2(&puffer[tagwert[i]-uk]);
	b=pufferlesen2(); c=pufferlesen2();
	if(taganz[i]==3) sprintf(str,"0x%04X 0x%04X 0x%04X",a,b,c);
	else sprintf(str,"0x%04X 0x%04X 0x%04X ...",a,b,c);
       }
    return str;
   }
 if(tagtyp[i]==TYP_LONG)
   {if(taganz[i]==1) sprintf(str,"%ld",tagwert[i]);
    else {unsigned long a=pufferlesen4(&puffer[tagwert[i]-uk]),
	                b=pufferlesen4();
          if(taganz[i]==2) sprintf(str,"0x%08X 0x%08X",a,b);
          else sprintf(str,"0x%08X 0x%08X ...",a,b);
         }
    return str;
   }
 if(tagtyp[i]==TYP_SLONG)
   {if(taganz[i]==1) sprintf(str,"%ld",tagwert[i]);
     else {long a=pufferlesen4(&puffer[tagwert[i]-uk]),b=pufferlesen4();
          if(taganz[i]==2) sprintf(str,"0x%08X 0x%08X",a,b);
          else sprintf(str,"0x%08X 0x%08X ...",a,b);
         }
    return str;
   }
 if(tagtyp[i]==TYP_RATIONAL)
   {unsigned long a=pufferlesen4(&puffer[tagwert[i]-uk]), b=pufferlesen4();
     sprintf(str,"%ld/%ld=%lf",a,b,a/double(b)); return str;
   }
 if(tagtyp[i]==TYP_SRATIONAL)
   {long a=pufferlesen4(&puffer[tagwert[i]-uk]), b=pufferlesen4();
    sprintf(str,"%ld/%ld=%lf",a,b,a/double(b)); return str;
   }
 if(tagtyp[i]==TYP_UNDEFINED)
   {unsigned char *a;
    if(taganz[i]<=4) sprintf(str,"0x%08X",tagwert[i]);
    else
     {a=(unsigned char*)&puffer[tagwert[i]-uk];
      if(taganz[i]==5)
	sprintf(str,"%02X %02X %02X %02X %02X",a[0],a[1],a[2],a[3],a[4],a[5]);
      else sprintf(str,"%02X %02X %02X %02X %02X...",a[0],a[1],a[2],a[3],a[4],a[5]);
     }
    return str;}
 fprintf(stderr,"unbekannter tagtyp=%d\n",tagtyp[i]);
 return NULL;
}
void Exif::alletagsauswerten()
{
 const char *s;
 for(int i=0;i<ntags;i++)
   {s=einentagauswerten(i);
    printf("Tag=0x%04X Typ=%d '%s'\n",tag[i],tagtyp[i],s);
   }
}

void exiflist(const char *name)
{
 int i,k1;
 const char *s;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {printf("'%s' nicht gefunden.\n",name); return;}
 exif.headerlesen(fp);
 k1=exif.wordlesen(fp); //Anzahl Tags im 0.IFD
 if(test) fprintf(stderr,"Anzahl Tags im 0.IFD = %d\n",k1);
 exif.tagslesen(fp,k1);
 s=exif.tagauswerten(TAG_DateTime); //identisch mit Aufnahmezeit?
 if(s!=NULL) printf("Zeitstempel: '%s'\n",s);
 s=exif.tagauswerten(TAG_Make);
 if(s!=NULL) printf("Kameraherst: '%s'\n",s);
 s=exif.tagauswerten(TAG_Model);
 if(s!=NULL) printf("  Kameratyp: '%s'\n",s);
 printf("Alle 0.IFD-Tags auswerten:\n");
 exif.alletagsauswerten();
 exif.tagslesen(fp); //jetzt die Tags im Exif-IFD lesen
 s=exif.tagauswerten(TAG_DateOrig); //Das muesste die Aufnahmezeit sein
 if(s!=NULL) printf("Zeitstempel2: '%s'\n",s);
 s=exif.tagauswerten(TAG_DateDigi); //identisch oder kurz danach (1 Sek)
 if(s!=NULL) printf("Zeitstempel3: '%s'\n",s);
 s=exif.tagauswerten(TAG_ExifWidth);
 if(s!=NULL)
   {char s1[strlen(s)+1]; strcpy(s1,s);
    s=exif.tagauswerten(TAG_ExifHeight);
    printf("Exif-Aufloesung: %sx%s\n",s1,s);
   }
 fclose(fp);
 printf("Alle Exif-IFD-Tags auswerten:\n");
 exif.alletagsauswerten();
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char name[N80];
 int i,j,c;
 name[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(name,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'])
	{printf("exifsort  %s\n",VERSION);
	 printf("Anwendung: exifsort [-flags] [*.jpg]\n");
	 printf("  Flags:  L=nur auflisten der Exif-Eintraege\n");
	 printf("          i=interaktiv nachfragen\n");
	 printf("          v=mit Testausdrucken\n");
	 exit(0);
	}
 if(argflag['L'])
   {if(*name==0)
       {printf("Dateiname:"); scanf("%s",name);}
    exiflist(name);
   }
 else
   {
     fprintf(stderr,"stderr: noch nicht fertig programmiert.\n");//test
     printf("noch nicht fertig programmiert.\n");//test
     //exifsort(argc,argv);
   }
 return 0;
}/* ende von main */

/* Mit alfabetischer Sortierung der Dateiname etwas aufwaendiger: */
const int NORM=1,VERZ=2,SPEZ=3,LINK=4;//Dateitypen

class Dateiliste
{
 char name[N80];
public:
 int typ;
 Dateiliste *next;
 Dateiliste() {name[0]=0; typ=0; next=NULL;}
 ~Dateiliste() {if(next!=NULL) delete[] next;}
 char& operator[](int i) {return name[i];}
 bool operator<=(Dateiliste& y);
 Dateiliste* einsortieren(const char *neuername,int t);
 Dateiliste* einsortieren(Dateiliste *neu);
};
bool Dateiliste::operator<=(Dateiliste& y)
{
 int i,c1,c2;
 for(i=0;(c1=name[i])!=0 && (c2=y[i])!=0;i++)
   {c1 &= 0xFF; c2 &= 0xFF;
    if(c1<c2) return true;
    else if(c1>c2) return false;
   }
 if(name[i]==0) return true;
 if(y[i]==0) return false;
 return true;
}
Dateiliste* Dateiliste::einsortieren(const char *neuername,int t)
{
 if(name[0]==0 && next==NULL)
   {//erster Eintrag in leere Liste
    strncpy(name,neuername,N80); name[79]=0;
    typ=t;
    return this;
   }
 Dateiliste *neu=new Dateiliste[1];
 if(neu==NULL) {printf("Fehler: new fehlgeschlagen.\n"); return this;}
 strncpy(neu->name,neuername,N80); neu->name[79]=0;
 neu->typ=t;
 return einsortieren(neu);
}
Dateiliste* Dateiliste::einsortieren(Dateiliste *neu)
{
 if((*neu) <= (*this)) {neu->next=this; return neu;}
 if(next==NULL) next=neu;
 else next=next->einsortieren(neu);
 return this;
}

const char *typ2str(int typ)
{
 const char *styp;
 char str[40];
 switch(typ)
      {case NORM: styp="     "; break;
       case VERZ: styp="(dir)"; break;
       case LINK: styp="(lnk)"; break;
       default: sprintf(str,"(%03lX)",typ); styp=str;
      }
 return styp;
}

void exifsort(const char *ordner) //provi.
{
 char *pfadname=NULL;
 DIR *dp;
 struct dirent *dirp;
 struct stat statbuf;
 int j,typ;
 Dateiliste *liste=new Dateiliste[1];
 if(ordner==NULL || *ordner==0) ordner=".";
 pfadname=new char[strlen(ordner)+N80+2];
 dp=opendir(ordner);
 if(dp==NULL) {printf("kann Ordner '%s' nicht oeffnen.\n",ordner); return;}
 for(j=0;(dirp=readdir(dp))!=NULL;j++)
   {if(strcmp(dirp->d_name,".")==0 || strcmp(dirp->d_name,"..")==0) continue;
    sprintf(pfadname,"%s/%s",ordner,dirp->d_name);
    typ=NORM;
    if(lstat(pfadname,&statbuf) < 0) typ=SPEZ;
    else
      switch(statbuf.st_mode & S_IFMT)
	{case S_IFREG: typ=NORM; break;
	 case S_IFDIR: typ=VERZ; break;
	 case S_IFLNK: typ=LINK; break;
	 case S_IFBLK: case S_IFCHR: case S_IFIFO: case S_IFSOCK:
	 default: typ=SPEZ;
	}
    if(strcmp(ordner,".")==0) liste=liste->einsortieren(dirp->d_name,typ);
    else liste=liste->einsortieren(pfadname,typ);
    if(argflag['R'] && typ==VERZ)
      {char *neupfad=new char[strlen(ordner)+strlen(dirp->d_name)+2];
       sprintf(neupfad,"%s/%s",ordner,dirp->d_name);
       exifsort(neupfad);
       delete[] neupfad;
      }
   }
 closedir(dp);
 delete[] pfadname;
 Dateiliste *p;
 for(p=liste;p!=NULL;p=p->next)
   if(p->typ==NORM) printf("%s\n",&p[0]);
   else printf("%s  \t%s\n",&p[0],typ2str(p->typ));
 printf("%d Dateien.\n",j);
 delete[] liste;
}
