/* mini.cc		Minimales HauptProgramm zur Verwendung von showit */
/*
 Uebersetzen und Linken:
;ALPHA> cx mini
;ALPHA> blink mini,[pfister.obj]showit,xmenu
;VAX> GX2 mini
;VAX> BLINK mini,[PFISTER.obj]SHOWIT,xmenu

Dieses Programm kann als Vorlage fr ein neues Programm verwendet werden.
Dazu sollte berall wo 'mini' steht dieses durch den eignen Programmnamen
ersetzt werden. Nach dem Aufruf von showit() wird nie mehr zurckgekehrt,
alle Programmfunktionen mssen in den entsprechenden Unterprogrammen
realisiert werden.
Dieses Musterprogramm ist so geschrieben dass es auch unter C laufen sollte.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <showit.h>
#ifdef unix
#define random randoms
#endif

extern char *showit_voreinst;
#define MAXFELD 1000

void daten_einlesen(char *,float *,float *);
static int testflag=0;

main(int argc,char *argv[])
{
 float xmin= -1.,ymin=0.,xmax=100.,ymax=1.,y0,faktor=1.;
 float feld[MAXFELD],hilfsfeld[MAXFELD];
 int npoints=MAXFELD,modus=2,i;
 char antwort[20],dateiname[80];
 if(argc>=2) {strcpy(dateiname,argv[1]);} else {strcpy(dateiname,"test.dat");}
 printf("mit Testausdrucken ?"); scanf("%s",antwort);
 testflag=(toupper(*antwort)!='N');
 showit_voreinst="mini.voreinst";
 daten_einlesen(dateiname,feld,hilfsfeld);
 yskalierung(&faktor); /* alle y-Werte werden durch faktor geteilt */
 for(i=0;i<MAXFELD;i++)
	{if(feld[i]<ymin) ymin=feld[i];
	 if(hilfsfeld[i]<ymin) ymin=hilfsfeld[i];
	 if(feld[i]>ymax) ymax=feld[i];
	 if(hilfsfeld[i]>ymax) ymax=hilfsfeld[i];
	}
 y0=ymax/30.; if(-y0<ymin) ymin= -y0;
 ymax+=y0;
 showit(&xmin,&ymin,&xmax,&ymax,&npoints,&modus,feld,hilfsfeld);
}/* ende von main */

void file_exit() {exit(0);}
void file_load()
{
 printf("file_load() noch vervollstndigen!\n");
}
void file_save()
{
 printf("file_save() noch vervollstndigen!\n");
}

/************************ Vordeklarationen *******************************/
void int_save1(float *z,float *xspitz,float *yspitz,float *grenz);
void int_save2(float *z,float *xspitz,float *yspitz,float *grenz);
void get_punkt1(float *x,float *y);
void get_punkt2(float *x,float *y);
void texte_laden(char **titel,char **xachse,char **yachse);
void get_delta(float *z,float *grenz);

/*************************************************************************/

void user_prog(int *fun,POINTER p1,POINTER p2,POINTER p3,POINTER p4)
{
 if(testflag) printf("user_prog() Funktionsnummer=%d\n",*fun);
 switch(*fun)
  {case 1: /*int_save1((float*)p1,(float*)p2,(float*)p3,(float*)p4); break;*/
   case 2: int_save2((float*)p1,(float*)p2,(float*)p3,(float*)p4); break;
   case 3: /*get_punkt1((float*)p1,(float*)p2); break;*/
   case 4: get_punkt2((float*)p1,(float*)p2); break;
   case 5: texte_laden((char**)p1,(char**)p2,(char**)p3); break;
   case 6: get_delta((float*)p1,(float*)p2); break;
   default: printf("user_prog(fun=%d...) not yet defined\n",*fun);
  }
}
/* Die Unterprogramme von user_prog mssen nicht alle definiert sein,	*/
/* sondern knnen bei Nichtgebrauch auskommentiert werden		*/

void int_save2(float *z,float *xspitz,float *yspitz,float *grenz)
{
 printf("int_save2()  z=%lf  xspitz=%lf  yspitz=%lf\n",*z,*xspitz,*yspitz);
 printf("  grenz[4]={%lf %lf %lf %lf}\n",grenz[0],grenz[1],grenz[2],grenz[3]);
}
void get_punkt2(float *x,float *y)
{
 printf("get_punkt2()  x=%lf  y=%lf\n",*x,*y);
}
void texte_laden(char **titel,char **xachse,char **yachse)
{
 static char meintitel[80];
 if(testflag) printf("texte_laden()\n");
 strcpy(meintitel,"Titel oder Substanzname\nkann auch mehrere Zeilen haben");
 *titel=meintitel;
 *xachse="x-Achse";
 *yachse="y-Achse";
}
void get_delta(float *z,float *grenz)
{
 printf("get_delta()  z=%lf  x1=%lf y1=%lf x2=%lf y2=%lf}\n",
	*z,grenz[0],grenz[1],grenz[2],grenz[3]);
}

/********************** Benutzerfunktionen *******************************/
double random() /* Zufallszahl zwischen -1. und 1. */
{
 return (1. - rand()/1073741824.);
}

void daten_einlesen(char *dateiname,float *feld,float *hilfsfeld)
{
 int i;
 for(i=0;i<MAXFELD;i++) {feld[i]=hilfsfeld[i]=random()+1.;}
}
