/* PScheck.cc			letzte nderung: 13.11.1997 */
#define VERSION "Version 1.0"
/*
Uebersetzen:
;AVAX> cx PScheck
;AVAX> blink PScheck
;AVAX> pur PScheck.exe

 PostScript-Dateien berprfen.

History:
6.7.1995	Erstellung (RPf)
13.11.97 V1.0	auf korrektes save-restore geprft.
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define ZL 200
#define ZL2 512

static int epsflag=0;

/************************* Vordeklarationen ***************************/
void pscheck(FILE *fp);
void save_restore_check(FILE *fp);
int getline(FILE *fp,char *s,int lim);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

char *stradd(char *s1,char *s2)
{
 char *s0=s1;
 while(*s1) s1++;
 while(*s1++ = *s2++) ;
 return s0;
}

/************************* Hauptprogramm ******************************/
static char quellname[80];

main(int argc,char *argv[])
{
 FILE *fp1;
 int i,j,c;
 quellname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("PScheck  %s\n",VERSION);
	 printf("Anwendung: PScheck Datei.ps\n");
	 exit(0);
	}
 if(*quellname==0) {printf("PS-Datei:"); scanf("%s",quellname);}
 if(!(fp1=fopen(quellname,"r")) && !(fp1=fopen(stradd(quellname,".ps"),"r")))
	printf("Datei '%s' nicht gefunden\n",quellname);
 else	pscheck(fp1);
 fclose(fp1);
 if(!(fp1=fopen(quellname,"r")))
	printf("kann '%s' nicht wieder finden\n",quellname);
 else	save_restore_check(fp1);
 fclose(fp1);
 return 0;
}/* ende von main */

void pscheck(FILE *fp)
{
 char zeile[ZL];
 int nzeil=0,n,nobj=0,zwizeil=0;
 // int epsflag=0;
 int proflag=0,objflag=0;
 while(getline(fp,zeile,ZL)
       && (*zeile=='%' && (zeile[1]=='%' || zeile[1]=='!'))
       && (strncmp(zeile,"%%BeginProlog",13)!=0)
      )
	{printf("%s\n",zeile);
	 if(strncmp(zeile,"%%BoundingBox:",14)==0) epsflag=1;
	 nzeil++;
	}
 do
  {if(strncmp(zeile,"%%BeginProlog",13)==0)
	{if(proflag) printf("FEHLER: '%%BeginProlog' doppelt\n");
	 proflag=1; n=nzeil;
	}
   else if(strncmp(zeile,"%%EndProlog",11)==0)
	{if(!proflag) printf("fehlendes '%%BeginProlog'\n");
	 proflag=0;
	 printf("%d Zeilen Prolog\n",nzeil-n+1);
	}
   else if(strncmp(zeile,"%Objektbox",10)==0)
	{if(objflag) printf("FEHLER: '%Objektbox' doppelt (Zeile %d)\n",nzeil);
	 objflag=1;
	}
   else if(strncmp(zeile,"%Objektende",11)==0)
	{if(!objflag)
		printf("FEHLER: fehlendes '%Objektbox' (Zeile %d)\n",nzeil);
	 objflag=0; nobj++;
	}
   else if(!objflag && !proflag) zwizeil++;
   nzeil++;
  }
 while(getline(fp,zeile,ZL));
 if(epsflag) printf("EPSF-Datei ");
 else printf("PS-Datei ");
 printf("'%s' ist %d Zeilen lang",quellname,nzeil);
 if(nobj>0) printf(" und enthlt %d Vectmal-Objekte\n",nobj);
 else printf("\n");
 if(nobj>0 && zwizeil>0)
	printf("und zwischen den Objekten total %d Zeilen\n",zwizeil);
}

/************************ Test auf save und restore *********************/
bool istersterbuchstabe(int c)
{
 return (isalnum(c) || c=='/' || c=='_');
}
bool istbuchstabe(int c)
{
 return (isalnum(c) || c=='_');
}

char *next_wort(char *s)
{
 int c;
 while((c= *s++) && c!='%')
   if(istersterbuchstabe(c)) return --s;
 return NULL;
}
char *ende_wort(char *s)
{
 int c;
 if(istersterbuchstabe(*s)) ++s;
 while((c= *s++) && c!='%')
   if(!istbuchstabe(c)) return --s;
 return NULL;
}
int vergl_wort(char *s,char *wort)
{
 int c,c2= -1;
 do {c= *s++; c2= *wort++;
     if(c2==0 && !istbuchstabe(c)) return 0;//Uebereinstimmung
    }
 while(c==c2 && c!=0);
 return c-c2;//keine Uebereinstimmung (negativ: s ist kleiner als wort)
}

/*
 Beispielzeile:
/save-punkt {save gsave ... grestore restore}def
*/

void iwarn(int imax)
{
 static int flag=0;
 if(flag) return;
 printf("zu grosse save-gsave-Verschachtelung in pscheck: imax=%d\n",imax);
 flag=1;
}

static int klammerebene=0;

void ohne_klamm(char *s)
{
 int c;
 while((c= *s) && c!='%')
   {if(c=='{') klammerebene++;
    else if(c=='}') klammerebene--;
    if(klammerebene>0) *s++ = ' ';
    else s++;
   }
}

void save_restore_check(FILE *fp)
{
 char zeile[ZL2],*s1,*s2;
 const int SAVE=1,GSAVE=2;
 int sblock=0,gblock=0,znr=0,showpageproblem=0;
 int block[1000],i=0,imax=1000;
 while(getline(fp,zeile,ZL2))
  {++znr;
   ohne_klamm(zeile);
   for(s1=zeile;s1!=NULL;)
     {s1=next_wort(s1); if(s1==NULL) break;
      if(vergl_wort(s1,"save")==0)
	{sblock++; block[i++]=SAVE; if(i==imax) {--i;iwarn(imax);}}
      else if(vergl_wort(s1,"restore")==0)
	{if(sblock==0)
	  printf("Fehler: fehlendes 'save' vor 'restore' in Zeile %d\n",znr);
	 else {sblock--; if(i>0) i--;}
	 if(i<imax-1 && block[i]!=SAVE)
	   printf("Fehler: 'restore' statt 'grestore' in Zeile %d\n",znr);
	}
      else if(vergl_wort(s1,"gsave")==0)
	{gblock++; block[i++]=GSAVE; if(i==imax) {--i;iwarn(imax);}}
      else if(vergl_wort(s1,"grestore")==0)
	{if(gblock==0)
	  printf("Fehler: fehlendes 'gsave' vor 'grestore' in Zeile %d\n",znr);
	 else {gblock--; if(i>0) i--;}
	 if(i<imax-1 && block[i]!=GSAVE)
	   printf("Fehler: 'grestore' statt 'restore' in Zeile %d\n",znr);
	}
      else if(vergl_wort(s1,"showpage")==0)
	{showpageproblem++;}
      s1=ende_wort(s1);
     }
  }
 if(sblock!=0)
   {if(sblock==1) printf("Fehler: fehlendes 'restore'\n");
    else printf("Fehler: %d fehlende 'restore'\n",sblock);
   }
 if(gblock!=0)
   {if(gblock==1) printf("Fehler: fehlendes 'grestore'\n");
    else printf("Fehler: %d fehlende 'grestore'\n",gblock);
   }
 if(showpageproblem && epsflag)
   printf("Warnung: %d 'showpage' koennten Probleme geben\n",showpageproblem);
 if(klammerebene!=0)
   printf("Fehler: %d fehlende Klammern '%c'\n",
	  klammerebene,(klammerebene<0)?'{':'}');
 if(sblock==0 && gblock==0)
   printf("ok.\n");
}

/*************************** kleinkram ***************************/
int getline(FILE *fp,char *s,int lim)
{               /* liest eine Textzeile oder maximal lim Zeichen */
                /* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
        *s++ = c;
 *s='\0';
 return (c!=EOF);       /* TRUE wenn erfolgreich, FALSE wenn Fileende */
}
