/* VectMal.cc				letzte Aenderung: 31.3.2000

Uebersetzen an VAX:
cc  VectMal
Uebersetzen an ALPHA:
cxx vectmal.cc
@ blink VectMal,vmal1,vmal2,vectmal_hard,vectmal_fonts,[pfister.obj]xmenu
oder mit GNU-Compiler:
;> gcc/nocase_hack vectmal
Uebersetzen unter UNIX:
siehe makefile

History:
ca.1990 - 20.10.94	Erstellung (RPf)
3.7.95	V0.63	Prologdatei um doppelte Definitionen von LaShow, Symfont und
		machufont zu vermeiden
17.7.95  0.64	Falsche Grsse nach Ausschneiden korrigiert: deltatransform()
		in ausschneiden().
29.11.95	Start der Anpassung an UNIX
7.2.96	 0.65	Cursor-Darstellung verbessert, Auswahlleiste skaliert (YDPIC)
8.5.96	 0.66	Verwechslungen von ULONG mit ulong korrigiert
25.2.97	 0.67	Flchen schraffieren (fuellmethode)
11.6.97  0.68	neue Ellipse-Funktion, BoundingBox eleganter setzen
12.1.99	 0.69	Anpassen der Groesse an aktuellen Bildschirm in format_setzen()
		($h/xtekplot.screens wird indirekt ueber xtekplot1 verwendet)
24.2.2000	Neues Symbol um Objekte zu Editieren (voed)
23.3.00  0.71	voed.cc eingebaut in vectmal_hard.cc

*/

#define VERSION VECTMAL_VERSION
char *VERSION="Version 0.71";
char *REVISION="0.71";

#define VECTMAL_CC
#include "vectmal.h"
double sq(double x) {return x*x;}
#include "vtimeb.h"
#include <X11/Xlib.h>
#ifdef VAXORALPHA
#include <xmenu.h>
#else
#include "xmenu_vmal.h"
#endif

void system2(char *s,char *t)
{
 char str[200];
 sprintf(str,s,t);
 system(str);
}

#ifdef VAXORALPHA
void Delete2(char *s)
{
 char str[200];
 sprintf(str,"if f$search(\"%s\").nes.\"\" then del %s;*",s,s);
 system(str);
}
#else
#define Delete2(s) Delete(s)
#endif

#ifdef unix
char *machgross(char *s) {for(char* t=s;*t;) *t++ = toupper(*t); return s;}

FILE *fopen1(char *name,char *modus)
{
 char str[512],envnam[80],*s,*t;
 int i,c;
 for(i=1,s=name,t=envnam; i<80 && (c= *s++); i++)
   {if(c==':')
	{*t=0;
	 t=getenv(envnam); if(t==NULL || *t==0) t=getenv(machgross(envnam));
	 if(t==NULL || *t==0) sprintf(str,"%s_%s",envnam,s);
	 else sprintf(str,"%s/%s",t,s);
	 return fopen(str,modus);
        }
    *t++ =c;
   }
 return fopen(name,modus);
}
#endif

/***************** Vordeklarationen **********************/
/* Vordeklarationen von C2CPP erzeugt: */
int ctm_multiplikation(double* x,double* y);
int ctm_invert(double* x);
double *getpfad(struct pfad* z,int maxi);
int pfad_kopieren(struct pfad* alt,struct pfad* neu);
void gscopy(struct graphicstate* x,struct graphicstate* y);
int fatalerror(int n);
int bbox_ende(int bboxflag);
int err(char* s,int errnr);
int move(double x,double y);
int draw(double x,double y);
int ctmcopy(double* v,double* n);
int mathpop1(char* str,int* ix,double* x);
int make_cvs_string(char* str,int maxstr,WORD att,long a,long b);
int set_attr_flags(int setflags,int clrflags);
int tst_attr_flags(int mask,int flags);
int and_or_xor(struct stackeintrag** pp,long* b);
int eqvergleich(char* str,int flag);
int vergleich(char* str,int flag);
void setdictname(struct dictionary* dicy,char* name);
int bitlesen(int flag);
int linetoxy(double x,double y);
int movetoxy(double x,double y);
int pushmatrix(double* matrix,struct stackeintrag* p0);
double zwischenwinkel(double x1,double y1,double x2,double y2);
void dictcopy(Dictionary* dic1,Dictionary* dic2);
void execname(char* str);
void loadname(char* str);
int entpackread(int* wert);
int entpack2read(int* wert);
int entpack3read(int* wert);
int getpointfrompath(double** z,double* x0,double* y0,
		double* x1,double* y1,double* x2,double* y2);
int aufteilen(struct pfad* pat,struct pfad* pat1,
		struct pfad* pat2,double a,double b,double x1,double x2);
int uebernemen(double** z,int objekt,double x,double y);
int schnittpunkt(double xa,double ya,double xb,double yb,
		double* xs,double* ys,double a,double b,double x1,double x2);
int istinnerhalb(struct pfad* clip,double x,double y);
int pfadanfuegen(struct pfad* path,struct pfad* ziel);
int ausschneiden(XPoint* feld,int imax);
int objektboxlesen(FILE* fp,char* str,
		double* x1,double* y1,double* x2,double* y2);
int objektuebernemen(FILE* fpvon,FILE* fp,FILE* fp2,char* zeile);
int innenoderausserhalb(struct pfad* spat,
		double x1,double y1,double x2,double y2);
char *liesbis(char* str,int von,int bis,FILE* fp);
int parser(FILE* fp,int (**proc)());
int stringpush(char* s);
int getkey(UBYTE* name);
char *reverse(char* str);
char *getkeyname(ULONG key,char* str);
int newgetkey(UBYTE* name,int* error);
void linienzug(XPoint* feld,int imax);
void doppelzug2(int ix1,int iy1,int ix2,int iy2);
void pfeilzug2(int ix1,int iy1,int ix2,int iy2);
void linienzug2(XPoint* feld,int imax);
void linienzug_closepath(XPoint* feld,int imax);
void linienzug_closefill(XPoint* feld,int imax);
void linienzug_bezier(XPoint* feld,int jmax);
int FPL(char* str);
int FPL2(char* str);
int FPL3(char* str);
int FPL4(char* str);
int FPL5(char* str);
int moveto_bkoord(int x1,int y1);
int lineto_bkoord(int x1,int y1);
/* Ende der Vordeklarationen von C2CPP */

void rgb2cmyk(int *,int *,int *,int *);
void lineattribute_ruecksetzen();
void zeichnepic(BYTE *p,int x0,int y0);
void aktuelle_farbnummer_anzeigen(int farbnr);
void schalter_ein(int x,int symbolnr);
void schalter_aus(int);
void schalter_um(int nr,int symbolnr);
void grauschalter_um(int);
void setflags(char *s);
void postscript_firstinit();
void postscript_init();
void format_setzen(int br,int ho,int flag);
void machps(char *s);
void file_load(int frageflag);
void file_save(int frageflag);
void file_load2(char *name);
void file_save2(char *name);
void einstellungen_nachladen(char *);
void einstellungen_sprache_nachladen(char *);
void einstellungen_speichern();
void einstellungen_zeigen();
void einstellungen_reset();
void menu_start(char *version);
void menu_loop();
int s_index(char *s1,int n1,char *s2,int n2);
void fadenkreuz_ein(),fadenkreuz_aus();
void symbolauswahl(int symbolnr,int knopfnr);
void klick_help(int knopf,int x,int y,int knopfnr);
void klick(int knopf,int x,int y,int knopfnr);
void rgb2hsb(int r,int g,int b,double *hu,double *sa,double *br);
void nextpalette();
void rarund(int x,int y,int n,int *zx,int *zy);
void rarund_d(int x,int y,int n,int *zx,int *zy);
void bru_ecke3(int *ddx,int *ddy);
void dings_start(),dings_term();
void postscript(char *fname,int flag,int bboxflag);
void putipfeld(int x,int y);
void setdashx(int symbolnr,int len,int on1,int off2,int on3,int off4);
void showtext();
void ecke3(int* ddx,int* ddy,int winkel,int dx,int dy);
void ecke4(int* ddx,int* ddy,int winkel,int dx,int dy);
void clear_bild();
void lupe(int fadenx,int fadeny,int lupedx,int lupedy);
void pixelbild_einschalten();
void resetgadgets();
void setbru_dxdy(int x,int y);
void setlinewidthx(int x,int symbolnr);
void lupe_zoomout();
void lupe_reset();
void undo();
void file_loadbrush(int nr);
void file_savebrush();
void brush_start();
void bildsichern(int knopfnr);
void raster(int n,int symbolnr);
int einschraenk(int x0,int y0,int x1,int y1,int *zx,int *zy);
void help_print(int nr,int knopfnr);
void machbrushbild(char *brushfilename,int methode);
int hexbytelesen(FILE *fp);
#ifndef VAXORALPHA
#ifdef __cplusplus
extern "C" {
#endif
void screenclear(int farbnr= -1); //neu in xtekplot1
void getmaxsize(int*,int*,int*,int*);
#else
void screenclear();
#endif
void qterm_exit();
#ifndef VAXORALPHA
#ifdef __cplusplus
}
#endif
#endif
void neuer_schalter_status();
void grauschalter_markieren(int y,int farbe);
void farben_init();
void cursor_bilddat_init();
void fadenkreuz_init();
void getxyborder(int *xborder,int *yborder);
void check_defL(char *);
int zeile_suchen(FILE *fp,char *such);
void putline(FILE *fp,char *s);
void prolog_einfuegen(FILE *fp);
void wo_sind_wir();//test
void setfuellmethode(int n,int symbolnr);
void newbbox(int fadenx,int fadeny,int lupedx,int lupedy);
void start_voed(char *dateiname);

#define JAYES (sprache==DEUTSCH)?"ja":"yes"
#define NEINNO (sprache==DEUTSCH)?"nein":" no "


/***************** Grafik **********************/
#define plot q2plot
#ifdef VAXORALPHA
#define term qterm
#endif

extern Display *tekplot_dpy;
extern Window tekplot_win;
extern GC tekplot_gc,fadenkreuz_gc;
extern Window auswahl_win;
extern GC auswahl_gc;
extern int auswahl_higrund,auswahl_fogrund;

int debug=0;
extern int fenstername1_len,refreshflag,tekplot_breite,tekplot_hoehe;
#ifdef VAXORALPHA
extern double xmi,ymi,xma,yma,xs,ys,dx,dy;
#else
extern double xmin,ymin,xmax,ymax,xs,ys,dx,dy;
#endif
extern char fenstername[];

static BYTE  /* Pictogramme als kleine Vektorgrafiken */
 pic0[]={ 1,	/* Anzahl Linienzuege */
	  5,	/* Anzahl Linien in diesem Linienzug */
	  10,4,	/* erstes x,y-Paar */
	  8,4, 6,6, 6,14, 8,16, 10,16 }, /* Clear */
 pic1[]={ 1, 5, 6,4, 6,14, 8,16, 12,16, 14,14, 14,4}, /* Undo */
 pic2[]={ 1, 8, 6,18, 6,8, 9,8, 8,4, 12,4, 11,8, 14,8, 14,18, 6,18}, /* Leim */
 pic3[]={3, 1,10,2,10,18, 2,6,18, 10,12, 14,18, 2,8,18, 10,12, 12,18},/*Brush*/
 pic4[]={ 2, 6, 6,10, 4,8, 2,10, 4,12, 6,10, 10,10, 14,2, 6,
	 10,14, 12,16, 10,18, 8,16, 10,14, 10,10, 18,6}, /* Schere */
 pic5[]={ 2, 4, 2,18, 2,2, 17,2, 17,18, 2,18, 2, 12,18, 12,6, 2,6}, /* Streck */
 pic6[]={ 6, 1, 2,4,8,4, 1, 5,16,5,4, 1, 8,16,12,10, 1, 8,10,12,16,
	  1, 14,8,18,8, 1,16,16,16,4}, /* Txt */
 pic7[]={ 3, 6, 3,18, 8,18, 2,12, 10,4, 16,10, 8,18, 18,18, 3, 17,18, 17,16,
	 16,14, 14,12, 2, 14,14, 14,12, 16,12}, /* Rotation */
 pic8[]={ 5, 1,2,16,6,16, 1,4,14,4,18,
	  1,4,16,16,6, 1,16,4,16,8, 1,14,6,18,6}, /* Linien */
 pic9[]={ 5, 1,2,16,6,16, 1,4,14,4,18,
	  7,4,16, 5,12, 6,10, 7,8, 8,7, 10,6, 12,6, 16,8,
	  1,16,6,16,10, 1,14,8,18,8},	/* Kurve */
 pic10[]={1, 8,8,16, 12,16, 16,12, 16,8,
	  12,4, 8,4, 4,8, 4,12, 8,16},	/* Kreis */
 pic11[]={1, 4,4,16, 16,16, 16,6, 4,6, 4,16}, /* Viereck */
 pic12[]={1,9,6,16, 8,18, 12,18, 14,16, 14,12, 6,8, 6,4, 8,2, 12,2,14,4},/* S */
 pic13[]={1, 2,6,18, 14,10, 6,2},	/* > direktes Kommando */
 pic14[]={1, 1,2,10, 16,10},	/* duennste Linie */
 pic15[]={1, 1,2,10, 16,10},	/* duenne Linie = Dicke 1 */
 pic16[]={2, 1,2,10, 16,10, 1,2,9, 16,9},	/* Dicke 2 */
 pic17[]={3, 1,2,10, 16,10, 1,2,9, 16,9, 1,2,11, 16,11},	/* Dicke 3 */
 pic18[]={1, 7,2,8, 16,8, 16,9, 2,9, 2,10, 16,10, 16,11, 2,11},	/* Dicke 4 */
 pic19[]={1, 9,2,8, 16,8, 16,9, 2,9,
	  2,10, 16,10, 16,11, 2,11, 2,12, 16,12},	/* Dicke 5 */
 pic20[]={1, 11,16,7, 2,7, 2,8, 16,8, 16,9, 2,9,
	  2,10, 16,10, 16,11, 2,11, 2,12, 16,12},	/* Dicke 6 */
 pic21[]={1, 15,2,6, 16,6, 16,7, 2,7, 2,8, 16,8, 16,9, 2,9,
	  2,10, 16,10, 16,11, 2,11, 2,12, 16,12, 16,13, 2,13},	/* Dicke 8 */
 pic22[]={4, 1,2,10,3,10, 1,6,10,7,10,
	  1,10,10,11,10, 1,14,10,15,10},	/* Punktiert */
 pic23[]={3, 1,2,10,5,10, 1,8,10,11,10, 1,14,10,17,10},	/* Kurz gestrichelt */
 pic24[]={2, 1,2,10,8,10, 1,11,10,17,10},	/* Lang gestrichelt */
 pic25[]={3, 1,2,10,6,10, 1,9,10,10,10, 1,13,10,17,10},	/* Punkt Strich */
 pic26[]={3, 1,2,10,7,10, 1,10,10,12,10, 1,15,10,17,10}, /* Lang Kurz */
 pic27[]={1, 1,2,10,17,10},			/* Durchgezogen */
 pic28[]={6, 1,2,4,2,16, 1,6,4,6,16, 1,2,10,6,10, 5, 8,13, 12,13, 12,10,
	  8,10, 8,16, 12,16, 1,14,16,14,4, 4, 16,19, 16,10, 19,10,
	  19,16, 16,16},					  /* Help */
 pic29[]={8, 3,6,4,2,4,2,16,6,16, 1,2,10,6,10, 1,8,10,12,16, 1,12,10,8,16,
	  1,14,16,14,10, 1,14,5,14,4, 1,17,16,17,6, 1,15,8,19,8}, /* Exit */
 pic30[]={2, 1,2,18,8,12, 8,6,10, 10,14, 14,14, 18,10, 18,6, 14,2,
	  10,2, 6,6, 6,10},			/* Lupe */
 pic31[]={3, 2, 2,14, 6,10, 2,6,
	  1,6,10,14,10, 2, 18,14, 14,10, 18,6},		/* Zentrieren */
 pic32[]={2, 1,4,16,16,4, 1,18,6,6,18},			/* Doppelbindung */
 pic33[]={2, 1,4,16,16,4, 2, 12,4, 16,4, 16,8},		/* Pfeil */
 pic34[]={8, 1,4,19,4,1, 1,8,19,8,1, 1,12,19,12,1, 1,16,19,16,1,
	  1,1,4,19,4, 1,1,8,19,8, 1,1,12,19,12, 1,1,16,19,16},	/* Raster */
 pic35[]={5, 4, 2,16, 2,4, 6,4, 6,10, 2,10, 1,4,10,6,16,
	  5, 8,13, 12,13, 12,10, 8,10, 8,16, 12,16,
	  3, 15,19, 15,5, 16,4, 17,5, 1,14,10,16,10},	/* Refresh */
 pic36[]={1, 13, 4,4,4,16, 6,16,6,4, 8,4,8,16, 10,16,10,4,
		12,4,12,16, 14,16,14,4, 16,4,16,16}, /* Fllmethode */
 pic37[]={2, 5,16,6, 4,16, 16,16, 16,6, 4,6, 4,16, 1,16,16, 4,6}, /* B.Box */
 pic38[]={1, 8,
	  4,10, 8,8, 10,4, 12,8, 16,10, 12,12, 10,16, 8,12, 4,10},/* ObjEdit */
 picziff0[]={1,4, 1,4,1,16,5,16,5,4,1,4},
 picziff1[]={1,1, 5,4,5,16},
 picziff2[]={1,5, 1,4,5,4,5,10,1,10,1,16,5,16},
 picziff3[]={1,6, 1,4,5,4,5,10,1,10,5,10,5,16,1,16},
 picziff4[]={2, 2, 1,4,1,10,5,10, 1, 5,4,5,16},
 picziff5[]={1,5, 5,4,1,4,1,10,5,10,5,16,1,16},
 picziff6[]={1,5, 5,4,1,4,1,16,5,16,5,10,1,10},
 picziff7[]={1,2, 1,4,5,4,5,16},
 picziff8[]={2, 4, 1,4,1,16,5,16,5,4,1,4, 1,1,10,5,10},
 picziff9[]={1,5, 1,16,5,16,5,4,1,4,1,10,5,10},
 picfue1[]={3, 1,4,16,16,4, 1,8,16,16,8, 1,4,12,12,4},
 picfue2[]={3, 1,4,4,16,16, 1,8,4,16,12, 1,4,8,12,16},
 picfue3[]={6, 1,4,16,16,4, 1,8,16,16,8, 1,4,12,12,4,
		1,4,4,16,16, 1,8,4,16,12, 1,4,8,12,16},
 picfue4[]={7, 1,4,16,6,14, 1,9,11,11,9, 1,14,6,16,4,
		1,9,16,11,14, 1,14,11,16,9, 1,4,12,6,10, 1,9,6,11,4};

//#define MAXPIC 37 /*test*/
static BYTE *pic[]=
	{pic0,pic1,pic2,pic3,pic4,pic5,pic6,pic7,pic8,pic9,pic10,pic11,pic12,
	 pic13,pic14,pic15,pic16,pic17,pic18,pic19,pic20,pic21,pic22,pic23,
	 pic24,pic25,pic26,pic27,pic28,pic29,pic30,pic31,pic32,pic33,pic34,
	 pic35,pic36,pic37,pic38,NULL},
	*picziff[]={picziff0,picziff1,picziff2,picziff3,picziff4,
		    picziff5,picziff6,picziff7,picziff8,picziff9},
	*picfuell[]={pic36,picfue1,picfue2,picfue3,picfue4};

#define XSCHALTER 8
static int grauschalter_y0=0, /* 1 Schalter fuer Grauwert (Farbwahlschalter) */
	   schalter_status[XSCHALTER]={0,0,15,27,0,0,0,0};
		/* XSCHALTER Schalter in Symbolbereich
		/* [0] = Verformung
		/* [1] = Werkzeug
		/* [2] = Liniendicke
		/* [3] = Strichelung
		/* [4] = Zentrierung
		/* [5] = Raster
		/* [6] = Help
		/* [7] = Schraffierung	*/
static int paletnr=0;
static int aktuelle_farbnr=1;/* Index fuer Farbpalette farbstifte[MAXXFARB] */
int prolog_flag=0; /* gesetzt wenn Prologdatei vorhanden */
struct graphicstate gs;

void initgraphics()
{
 gs.flatness=1.0; gs.linewidth=1.0;
 gs.miterlimit=10.; gs.linecap=gs.linejoin=gs.dashlen=gs.dashoffset=0;
 gs.farbnummer=1;
}

#define WEISS 1		/* Vordergrundfarbnummer  (bei weiss auf	*/
#define SCHWARZ 0	/* Hintergrundfarbnummer   schwarz Darstellung) */

static int YDPIC=20;//entsprechendes #define in vectmal_const.h auskommentiert

void symbolezeichnen(Window win,GC gc)
{
 int i,y;
 y=(tekplot_hoehe+8)/31; //Aufrundung bei Schwelle von etwa 0.75
 if(YDPIC>y) YDPIC=y;
 auswahl_color(WEISS);
 for(i=0,y=YDPIC;i<31;i++,y+=YDPIC)
	XDrawLine(tekplot_dpy,win, gc,0,y,RAND-1,y);
 XDrawLine(tekplot_dpy,win,gc,X1PIC,0,X1PIC,31*YDPIC);
 XDrawLine(tekplot_dpy,win,gc,X0PIC,0,X0PIC,(31-9)*YDPIC);
 XDrawLine(tekplot_dpy,win,gc,
		X1PIC/3,(31-9)*YDPIC,RAND/3,(31-8)*YDPIC);
 XDrawLine(tekplot_dpy,win,gc,
		X1PIC*2/3,(31-9)*YDPIC,RAND*2/3,(31-8)*YDPIC);
 for(i=0;pic[i];i++) zeichnepic(pic[i], (i&1) ? X0PIC+1 : 0, i/2*YDPIC);
// if(i!=MAXPIC+1)
//	printf("Fehler in symbolezeichnen i=%d statt %d\n",i,MAXPIC+1);//test
 if(grauschalter_y0==0) grauschalter_y0=YDPIC+YFARB0;
 for(y=(31-8)*YDPIC+1,i=0; i<8; y+=YDPIC,i++)
	auswahl_rechteckfill(1,y,2*XDPIC-1,y+YDPIC-2,i+paletnr);/*i=Farbnummer*/
 grauschalter_markieren(grauschalter_y0,WEISS);
 aktuelle_farbnummer_anzeigen(aktuelle_farbnr);
 for(i=0;i<XSCHALTER;i++)
	if(schalter_status[i]) schalter_ein(i,schalter_status[i]);
 return;
}

void zeichnepic(BYTE *p,int x0,int y0)
{
 int j,k,x1,y1,x2,y2;
 if(YDPIC<20) y0--;//Bei verndertem YDPIC Symbole etwas stauchen
 if(long(p)<256) {printf("Fehler in zeichnepic() p=%06X\n",p); return;}//test
 for(j= *p++; j>0; j--)
  for(k= *p++, x1=x0+ *p++, y1=y0+ *p++; k>0; k--)
	{x2=x0+ *p++; y2=y0+ *p++;
	 XDrawLine(tekplot_dpy,auswahl_win,auswahl_gc,x1,y1,x2,y2);
	 x1=x2; y1=y2;
	}
 return;
}

short	darflag=0,	/* Attribut bei Darstellung noch zu aendern */
	darflag_line=0,
	darflag_dash=0,
	darflag_farbe=0,
	rueckflag=0;	/* 1=soll ruecksetzen */

double deltatrans(double z)
{
 double x,y;
 deltatransform(&x,&y,z,z);
/* return sqrt((x*x+y*y)/2.); */
 return fabs(x);
}

double ideltatrans(double z)
{
 double x,y;
 ideltatransform(&x,&y,z,z);
/* return sqrt(x*x+y*y)/WURZEL2; */
 return fabs(x);
}

char *errfun="ERRFUN";

double transfer(double grau)
{
 int n,(*proc)();
 double x;
 if(!gs.transferfunc.attr) return grau;
/* proc=gs.transferfunc; zahlpush(grau); n=(*proc)(); */
 zahlpush(grau);
 push(gs.transferfunc.attr,gs.transferfunc.a,gs.transferfunc.b);
 n=exec();
 if(n==0) n=zahlpop(&x);
 if(n) {errfun="transfer"; fehlermeldung(n); return grau;}
 return x;
}

extern int linestyle,fillstyle,linecolor;

void lineattribute_setzen()  /* Stellt Linieneigenschaften so ein */
{			     /* wie es die gs-Struktur verlangt.  */
 int dicke,cap,join,i;
 if(darflag)
  {if(gs.dashlen)
     {if(darflag_dash)
	{XSetDashes(tekplot_dpy,tekplot_gc,gs.dashoffset,gs.dashfeld,gs.dashlen);
	 XSetDashes(tekplot_dpy,fadenkreuz_gc,gs.dashoffset,gs.dashfeld,gs.dashlen);
	}
      linestyle=LineOnOffDash;
     }
   else linestyle=LineSolid;
   switch(gs.linecap)  {case 1: cap=CapRound;
			CASE 2: cap=CapProjecting;
			DEFAULT: cap=CapButt;
		       }
   switch(gs.linejoin) {case 1: join=JoinRound;
			CASE 2: join=JoinBevel;
			DEFAULT: join=JoinMiter;
		       }
   dicke=(int)deltatrans(gs.linewidth);
   XSetLineAttributes(tekplot_dpy,tekplot_gc,dicke,linestyle,cap,join);
   XSetLineAttributes(tekplot_dpy,fadenkreuz_gc,dicke,linestyle,cap,join);
   if(darflag_farbe)	farbe_setzen(gs.farbnummer);
   darflag=darflag_line=darflag_dash=darflag_farbe=0;
   rueckflag=(gs.linecap!=0 || gs.linejoin!=0 || gs.linewidth!=0.0 ||
	      gs.dashlen!=0 || gs.farbnummer!=1);
  }
 return;
}

void lineattribute_ruecksetzen()  /* Stellt Linieneigenschaften auf die Werte */
{				  /* ein die ein Postscriptprogramm erwartet */
 XSetLineAttributes(tekplot_dpy,tekplot_gc,0,
			linestyle=LineSolid,CapButt,JoinMiter);
 XSetLineAttributes(tekplot_dpy,fadenkreuz_gc,0,
			linestyle=LineSolid,CapButt,JoinMiter);
 XSetFillStyle(tekplot_dpy,tekplot_gc,fillstyle=FillSolid);
 XSetFillStyle(tekplot_dpy,fadenkreuz_gc,fillstyle=FillSolid);
 farbe_setzen(1);
 darflag_line=(gs.linecap!=0 || gs.linejoin!=0 || gs.linewidth!=0.0);
 darflag_dash=(gs.dashlen!=0);
 darflag_farbe=(gs.farbnummer!=1);
 darflag=(darflag_dash||darflag_line||darflag_farbe);
 rueckflag=0;
 return;
}

void bezier(double ax,double ay,double bx,double by,
	double cx,double cy,double dx,double dy)  /* Bezier-Kurve zeichnen */
{				 /* Stuetzpunkte A B C D, Pen steht auf A. */
 double abx,aby,bcx,bcy,cdx,cdy,abcx,abcy,bcdx,bcdy,abcdx,abcdy,adx,ady;
 double x2,y2;
 adx=(ax+dx)/2.; ady=(ay+dy)/2.;
 abx=(ax+bx)/2.; aby=(ay+by)/2.;
 bcx=(bx+cx)/2.; bcy=(by+cy)/2.;
 cdx=(cx+dx)/2.; cdy=(cy+dy)/2.;
 abcx=(abx+bcx)/2.; abcy=(aby+bcy)/2.;
 bcdx=(bcx+cdx)/2.; bcdy=(bcy+cdy)/2.;
 abcdx=(abcx+bcdx)/2.; abcdy=(abcy+bcdy)/2.;
 x2=abcdx-adx; y2=abcdy-ady;
 if(x2*x2+y2*y2<=gs.flatness*gs.flatness) return;/* durch Gerade approximieren */
 bezier(ax,ay,abx,aby,abcx,abcy,abcdx,abcdy);
 plot(abcdx,abcdy,2);
 bezier(abcdx,abcdy,bcdx,bcdy,cdx,cdy,dx,dy);
 return;
}

void fillbezier(double ax,double ay,double bx,double by,
	   double cx,double cy,double dx,double dy) /* Bezier-Kurve als Fuellpfad */
{				  /* Stuetzpunkte A B C D, Pen steht auf A. */
 double abx,aby,bcx,bcy,cdx,cdy,abcx,abcy,bcdx,bcdy,abcdx,abcdy,adx,ady;
 double x2,y2;
 adx=(ax+dx)/2.; ady=(ay+dy)/2.;
 abx=(ax+bx)/2.; aby=(ay+by)/2.;
 bcx=(bx+cx)/2.; bcy=(by+cy)/2.;
 cdx=(cx+dx)/2.; cdy=(cy+dy)/2.;
 abcx=(abx+bcx)/2.; abcy=(aby+bcy)/2.;
 bcdx=(bcx+cdx)/2.; bcdy=(bcy+cdy)/2.;
 abcdx=(abcx+bcdx)/2.; abcdy=(abcy+bcdy)/2.;
 x2=abcdx-adx; y2=abcdy-ady;
 if(x2*x2+y2*y2<=gs.flatness*gs.flatness) return;
 fillbezier(ax,ay,abx,aby,abcx,abcy,abcdx,abcdy);
 fillplot(abcdx,abcdy,2);
 fillbezier(abcdx,abcdy,bcdx,bcdy,cdx,cdy,dx,dy);
 return;
}


/*************************** HAUPTPROGRAMM ******************************/
#define ZL 120
/*typedef char *NAMEN; schon in vectmal.h gemacht */
NAMEN	UNDONAME="vectmalbildundo.tmp",
	UNDONAME2="vectmalbildundo2.tmp",
	BILDNAME="vectmalbild.tmp",
	HILFSNAME="vectmalbildhilf.tmp",
	ERRNAME="vectmalerror.tmp",
	TEMPBRUSHNAME="vectmalbrush.tmp",
	REFRESHNAME="vectmalrefresh.tmp",
	SICHERNAME="vectmalbild.bak",
#ifdef VAXORALPHA
	EINSTNAME="sys$login:vectmal_einst.dat",
#else
	EINSTNAME="HOME:vectmal_einst.dat",
#endif
	PROLOGNAME="vectmalprolog.tmp",
	VOEDTMPNAME="voed_tmp.ps";
double x1fenster=0,y1fenster=0,x2fenster,y2fenster,x0fenster;
short hochformat;
char argflag['Z'+1];
double xul,yul,xor,yor; /* Parameter fuer bbox_start */
char filename[ZL],brushfilename[ZL],vectmalfont[ZL],uvectmalfont[ZL];
int
	brush_dx=0,brush_dy=0,	/* Groesse des Teilbildes */
	brush_winkel=0,		/* Lage des Teilbildes (bez. Devicekoord.) */
	leim_dx=0,leim_dy=0,leim_winkel=0,/* Leimbrush */
	buchst_dx=20,buchst_dy=30,	/* Groesse der Buchstaben */
	buchst_winkel=0,
	viereck_dx=40,viereck_dy=40,	/* Groesse des Vierecks */
	viereck_winkel=0,
	kreis_radius=40,		/* Radius des Kreises */
	kreis_flag=0,
	kreis_x,kreis_y,		/* Kreismitte */
	kreis_dx=0,kreis_dy=0,		/* Kreistragepunkt */
	bru_dx,bru_dy,		/* Groesse des Objekts(Teilb.,Buchst.,Viereck)*/
	bru_winkel=0,		/* Lage des Objekts (bez. Devicekoord.) */
	bru_x1,bru_y1,		/* Position des Objekts */
	lupe_dx=150,lupe_dy=210;/* Groesse der Lupe */
				/* alles Bildschirmkoordinaten */

int
	rotation_modus=1,	/* 1=normal 2=fein 3=fein, aber gerundet */
	rotation_step=5,	/* Winkelschrittweite bei Modus 3 */
	linien_step=0,		/* Winkelschrittweite fuer Linien */
	vergroessern_modus=1,	/* 1=normal 2=fein 3=fein, aber gerundet */
	vergroessern_step=5,	/* Schrittweite bei Modus 3 */
	rasterpunkt=0,		/* Rasterschrittweite */
	raster1=5,raster2=20;
int
	bru_winkel_neu=0,	/* 1=bru_winkel wurde neu gesetzt */
	savedflag=1,		/* 1=Bild gespeichert */
	zentrieren_flag=0,	/* Objekt zentrieren */
	zentriermitte_flag=0,	/* Wenn naechstes Mausloslassen in Malbereich */
	pfeil_fill=1,		/* Pfeilspitze fuellen */
	ellipseflag=0,		/* statt Kreis eine Ellipse zeichnen */
	viereck_knopfnr,	/* Knopfnr beim Viereck Starten */
	kreis_knopfnr,		/* Knopfnr beim Kreis starten */
	fuellmethode=FILL;	/* Methode zum Flchen fllen, FILL, SCHRAFFn */
short	help_flag=0,		/* Hilfe-Symbol aktiv */
	newbboxflag=0;

double	zentriermitte=PSA4Bd/2.,/* dann Zentriermitte setzen. */
	doppel_a2=0.75,		/* Halber Abstand der Doppelbindung */
	pfeil_a2=1.5,		/* Halbe Breite der Pfeilspitze */
	pfeil_a3=2.5,		/* Halbe Laenge der Pfeilspitze */
	pfeil_amplitude=0.0,	/* fuer Pfeil mit Wellenlinie   */
	pfeil_periode=20.0,	/* fuer Pfeil mit Wellenlinie   */
	ellipsefakt=1.,		/* Verhaeltnis r/R in Ellipse */
//	newbboxx1,newbboxy1,newbboxx2,newbboxy2; /* fr BoundingBox */
	newbboxx1=0,newbboxy1=0,newbboxx2=598,newbboxy2=845;//test
static int brush_propflag=0;
static long brush_propx,brush_propy;
#define MAXLUP 10
int lupe_i=0;
double lupe_faktor[MAXLUP];
static int pixelbild_oldlupefaktor=1000;
extern int	bildschirm_breite,bildschirm_hoehe,bildschirm_tiefe,
		bildschirm_visualklasse;

/*void test_init(); /* test */

void main_init()
{
/* test_init();/* test */
 lupe_faktor[0]=1.0;
}

main(int argc,char *argv[])
{
 double x0;
 int arg0=argc-1,xborder,yborder;
 main_init();
 if(argc>3 || (argc>=2 && (*argv[1]=='?' || argv[1][1]=='?')))
	{printf("VectMal  %s\n",VERSION);
	 printf("Anwendung: Vectmal [-Flags] [Name.ps]\n");
	 printf("  Flags: Q=Querformat  Q1=Quer 1:1\n");
	 printf("         K=Kleines Format  S=Scalierung\n");
	 printf("         B=BoundingBox ignorieren   V=ohne Vordefinitionen\
   D1=Debug\n");
	 printf("         P=Pause bei showpage     C=Cachedevice verwenden\n");
	 printf("         W=Weisser Hintergrund\n");
	 exit(0);
	}
 if(argc==1) printf("VectMal  %s  -  kurze Hilfe: 'vectmal -?'\n",VERSION);
 if((argc>=2 && *argv[1]=='-')) {setflags(argv[1]); argc--;}
 else if(argc>=3)  {setflags(argv[2]); argc--; arg0--;}
 if(debug) wo_sind_wir();//test
 cursor_bilddat_init();
 screenausmasse_ermitteln();
 postscript_firstinit();
 einstellungen_sprache_nachladen(EINSTNAME);
 menu_start(VERSION);
 getxyborder(&xborder,&yborder); /* Breite der Fensterraender ermitteln */
 if(argflag['Q'])
	{if(argflag['1']) format_setzen(A4Q11B,A4Q11H,0);
	 else if(!argflag['K'])
		{int breite=bildschirm_breite-RAND-xborder,hoehe;
		 int hmax=bildschirm_hoehe-get_menuleistenhoehe()-yborder;
		 hoehe=idfix(breite/A4PROP);
		 if(hoehe>hmax) {hoehe=hmax; breite=(int)(hoehe*A4PROP);}
		 format_setzen(breite,hoehe,0);
		}
	 else format_setzen(A4QB,A4QH,0);
	}
 else	{if(!argflag['K'])
		{int breite,hoehe,bmax=bildschirm_breite-RAND-xborder;
		 hoehe=bildschirm_hoehe-get_menuleistenhoehe()-yborder;
		 breite=idfix(hoehe/A4PROP);
		 if(breite>bmax) {breite=bmax; hoehe=(int)(breite*A4PROP);}
		 format_setzen(breite,hoehe,0);
		}
	 else format_setzen(A4HB,A4HH,0);
	}
 if(argc>=2) {strcpy(filename,argv[arg0]); machps(filename); file_load(0);}
 einstellungen_nachladen(EINSTNAME);
 Fenstertitel(VECTMAL_READY);
 menu_loop();/* Dieses UnterProgramm wird nie verlassen,
		aber durch Maustastendrcke wird klick() erreicht.
		Das Anwhlen der Menupunkte erreicht ber
		activate_proc() die folgenden Unterprogramme:
		file_load(1)  file_save(1)  file_savebrush()
		einstellungen_zeigen()  einstellungen_nachladen()
		einstellungen_reset()  farbsystem_setzen()
		sprache_setzen()  format_setzen() file_plot() . */
}/* ende von main */

void machps(char *s) {if(INDEX(s,".")<0) strcat(s,".ps");}

void setflags(char *s)
{
 int c;
 while(c= *s++)
   if((c=toupper(c))<='Z')
     {argflag[c]=1; if(c=='D') debug = (*s<'0'||*s>'9') ? 1 : *s-'0';}
 return;
}

void file_exit()
{
 extern FILE *fptemp;
 int c;
 if(savedflag==0)
	{lower_window();
	 if(sprache==DEUTSCH)
		printf("Bild noch nicht gespeichert! Speichern ?");
	 else	printf("picture not yet saved! save it ?");
	 scanf("%s",filename);
	 if((c=toupper(*filename))=='J' || c=='Y') file_save(1);
	 else if(c!='N') file_save(0);
	}
 fclose(fptemp);
 Delete(BILDNAME); Delete(UNDONAME); Delete2(UNDONAME2); Delete2(HILFSNAME);
 Delete(ERRNAME); Delete(TEMPBRUSHNAME);
 Delete(EINSTNAME);
 Delete(PROLOGNAME);
 einstellungen_speichern();
 exit(0);
}

/*********** Programmteile die von astprog aufgerufen werden ********/
int		faden_x = -1,
		faden_y = -1,      /* aktuelle Position des Fadenkreuzes */
		fadenkreuz_flag=0, /* 1=eingeschaltet  >1=Funktion startet */
		fadenkreuz_typ=0,  /* Art des Fadenkreuzes */
		fadenkreuz_alt=0;  /* alter Typ */
#define BRUSH	1
#define STRECK	2
#define ROTAT	3
#define TEXT	4
#define LINIE	5
#define BEZIER	6
#define KREIS	7
#define VIERECK	8
#define SCHERE	9
#define LEIM	10
#define STRECKTXT	11
#define ROTATTXT	12
#define PFEIL	13
#define DOPPEL	14
#define LUPE	15
#define BOBOX	16
#define EDIT	17

char texttext[120];

#define IPMAX 50
static XPoint ipfeld[IPMAX];	/* Feld fuer 'Linien zeichnen' */
static int ipimax;

static int  linientyp=LINNORMAL;
int	werkzeug=0,	/* letztes ausgewaehltes WerkzeugSymbol */
	werknr,		/* knopfnr des letzten WerkzeugSymbols */
	schneidmethode=CUTNORMAL,
	schneidmodus=CUTNORMAL;

void streckrotatauswahl(int n,int knopfnr)
{
 fadenkreuz_ein(); symbolauswahl(n,knopfnr);/* 5=STRECK 7=ROTAT */
 fadenkreuz_alt=fadenkreuz_typ;
 fadenkreuz_typ=fadenkreuz_flag;
}

void klick(int knopf,int x,int y,int knopfnr) /* knopf: 1=gedrueckt 0=losgelassen */
{					/* knopfnr: 1=links 2=mitte 3=rechts */
 int ddx,ddy,ddx2,ddy2,symbolnr,n,hx,hy;
 int r,g,b,k;
 double grau,hue,sat,bre;
 char str[80];
 if(y<MBH) return; /* Klicks unter dem Menubalken ignorieren */
 if(help_flag) {klick_help(knopf,x,y,knopfnr); return;}
 if(x<RAND) /* im Symbolbereich Mausknopf gedrueckt */
   {if(GEDRUEKT)
	{if(y<(31-9)*YDPIC+MBH)		/** Auswahl eines Symbols **/
		symbolauswahl(symbolnr=((y-MBH)/YDPIC)*2+x/XDPIC,knopfnr);
	 else if(y>(31-8)*YDPIC+MBH && y<31*YDPIC+MBH)
		{gs.farbnummer=7-(31*YDPIC-(y-MBH))/YDPIC+paletnr;
		 if(n=fadenkreuz_flag) fadenkreuz_aus();
		 aktuelle_farbnummer_anzeigen(gs.farbnummer);
		 farbe_setzen(gs.farbnummer);
		 if(n) fadenkreuz_ein();
		}
	 else if(y<=(31-8)*YDPIC+MBH)
		{if(n=fadenkreuz_flag) fadenkreuz_aus();
		 switch(knopfnr)
		  {case 1:switch(farbsystem)
			   {case FARBGRAY:
				sprintf(str,"Grauwert=%lf\n",GSGETGRAY);
			    CASE RGB:
				get_color(gs.farbnummer,&r,&g,&b);
				sprintf(str,"Farbe %d\n R,G,B = %d,%d,%d\n",
						gs.farbnummer,r,g,b);
			    CASE HSB:
				get_color(gs.farbnummer,&r,&g,&b);
				rgb2hsb(r,g,b,&hue,&sat,&bre);
				sprintf(str,"Farbe %d\n H,S,B=%lf,%lf,%lf\n",
						gs.farbnummer,hue,sat,bre);
			    CASE CMYK:
				get_color(gs.farbnummer,&r,&g,&b);
				rgb2cmyk(&r,&g,&b,&k);
				sprintf(str,"Farbe %d\n C,M,Y,K= %d,%d,%d,%d\n",
						gs.farbnummer,r,g,b,k);
			   }
			  meldung(str);
		   CASE 2:lower_window();
			  switch(farbsystem)
			   {case FARBGRAY:
				printf("Grauwert:(%lf):",GSGETGRAY);
				scanf("%lf",&grau);
				if(grau<0.) grau=0.; else if(grau>1.) grau=1.;
				r=g=b=idfix(grau*255.);
				set_color(gs.farbnummer,RGB,r,g,b,0,&r,&g,&b);
			    CASE RGB:
				get_color(gs.farbnummer,&r,&g,&b);
				printf("(%d,%d,%d) R,G,B:",r,g,b);
				scanf("%d,%d,%d",&r,&g,&b);
				set_color(gs.farbnummer,RGB,r,g,b,0,&r,&g,&b);
			    CASE HSB:
				get_color(gs.farbnummer,&r,&g,&b);
				rgb2hsb(r,g,b,&hue,&sat,&bre);
				printf("(%lf,%lf,%lf) H,S,B:",hue,sat,bre);
				scanf("%lf,%lf,%lf",&hue,&sat,&bre);
				set_color(gs.farbnummer,HSB,(int)(255.*hue),
				    (int)(255.*sat),(int)(255.*bre),0,&r,&g,&b);
			    CASE CMYK:
				get_color(gs.farbnummer,&r,&g,&b);
				rgb2cmyk(&r,&g,&b,&k);
				printf("(%d,%d,%d,%d) C,M,Y,K:",r,g,b,k);
				scanf("%d,%d,%d,%d",&r,&g,&b,&k);
				set_color(gs.farbnummer,CMYK,r,g,b,k,&r,&g,&b);
			   }
			  raise_window();
			  aktuelle_farbnummer_anzeigen(gs.farbnummer);
			  farbe_setzen(gs.farbnummer);
		   CASE 3:nextpalette();
		  }
		 if(n) fadenkreuz_ein();
		}
	 else	{DEBUG(1,printf("nicht aktiver Fensterbereich angeklickt\n"));}
	}
    else /* Mausknopf im Symbolbereich losgelassen */
	{if(zentriermitte_flag)
		{zentriermitte_flag=0; zentriermitte=PSA4Bd/2.;}
	}
   }
 else if(GEDRUEKT && fadenkreuz_flag==1)	/** Start einer MausFunktion **/
	{if(rasterpunkt!=0) rarund(x,y,rasterpunkt,&x,&y);
	 fadenkreuz_aus();
	 switch(fadenkreuz_typ)   /* mit aktivem Fadenkreuz Knopf gedrueckt */
	  {case BRUSH:	switch(knopfnr)
			{case 1:bru_ecke3(&ddx,&ddy);
				brush_dx=bru_dx; brush_dy=bru_dy;
				brush_winkel=bru_winkel;
				Fenstertitel(VECTMAL_WORKING);
				dings_start();
			/*	postscript(brushfilename,0,1); */
				postscript(brushfilename,1,1); /* test1 */
				dings_term();
				Fenstertitel(VECTMAL_READY);
				savedflag=0;
			 CASE 2:STRECKAUSWAHL();
			 CASE 3:ROTATAUSWAHL();
			}
	   CASE LEIM:	switch(knopfnr)
			{case 1:bru_ecke3(&ddx,&ddy);
				leim_dx=bru_dx; leim_dy=bru_dy;
				leim_winkel=bru_winkel;
				dings_start();
				postscript(TEMPBRUSHNAME,1,1);
				dings_term();
				savedflag=0;
			 CASE 2:STRECKAUSWAHL();
			 CASE 3:ROTATAUSWAHL();
			}
	   CASE LINIE: case PFEIL: case DOPPEL:
			savedflag=0;
			switch(knopfnr)
			 {case 1:putipfeld(x,y); if(ipimax<IPMAX-1) ipimax++;
				 fadenkreuz_ein();
			  CASE 2:putipfeld(faden_x,faden_y);
				 if(ipimax<IPMAX-1) ipimax++;
				 fadenkreuz_ein();
			  CASE 3:linientyp=LINCLOSEFILL; fadenkreuz_ein();
			 }
	   CASE SCHERE:	savedflag=0;
			switch(knopfnr)
			 {case 1:putipfeld(x,y); if(ipimax<IPMAX-1) ipimax++;
				 schneidmodus=CUTNORMAL;
			  CASE 3:schneidmodus=CUTCOPY;
			  case 2:linientyp=LINCLOSEPATH;
				 putipfeld(faden_x,faden_y);
				 if(ipimax<IPMAX-1) ipimax++;
			 }
			fadenkreuz_ein();
	   CASE BEZIER:	if(knopfnr<=2 && ipimax<3)
				{if(knopfnr==1) putipfeld(x,y);
				 else putipfeld(faden_x,faden_y);
				 ipimax++;
				 savedflag=0;
				}
			fadenkreuz_ein();
	   CASE TEXT:	switch(knopfnr)
			{case 1:bru_ecke3(&ddx,&ddy);
				buchst_dx=bru_dx; buchst_dy=bru_dy;
				buchst_winkel=bru_winkel;
				showtext();
				savedflag=0;
			 CASE 2:STRECKAUSWAHL();
			 CASE 3:ROTATAUSWAHL();
			}
	   CASE VIERECK:switch(knopfnr)
			{case 1:if(lupe_i==0)	{hx=bru_dx/2; hy= -bru_dy/2;}
				else
				  {hx=(int)(lupe_faktor[lupe_i]*bru_dx/2.);
				   hy=(int)(-lupe_faktor[lupe_i]*bru_dy/2.);
				  }
				ecke3(&ddx,&ddy,bru_winkel,hx,hy);
				ecke4(&ddx2,&ddy2,bru_winkel,hx,hy);
				bru_x1=faden_x-ddx; bru_y1=faden_y-ddy;
				viereck_dx=bru_dx; viereck_dy=bru_dy;
				viereck_winkel=bru_winkel;
				x=bru_x1+ddx; y=bru_y1+ddy;
				showviereck(bru_x1,bru_y1,x-ddx2,y-ddy2,
						x+ddx,y+ddy,x+ddx2,y+ddy2);
				savedflag=0;
			 CASE 2:STRECKAUSWAHL();
			 CASE 3:ROTATAUSWAHL();
			}
	   CASE LUPE:switch(knopfnr)
			{case 1:lupe_dx=bru_dx; lupe_dy=bru_dy;
				lupe(faden_x,faden_y,lupe_dx,lupe_dy);
			 CASE 2:STRECKAUSWAHL();
			}
	   CASE KREIS:	kreis_flag=knopfnr;
			fadenkreuz_ein();
	   CASE BOBOX:switch(knopfnr)
			{case 1:lupe_dx=bru_dx; lupe_dy=bru_dy;
				newbbox(faden_x,faden_y,bru_dx,bru_dy);
			 CASE 2:STRECKAUSWAHL();
			}
	  }
	}
 else if(GEDRUEKT && fadenkreuz_flag>1)
	{fadenkreuz_alt=fadenkreuz_typ; fadenkreuz_typ=fadenkreuz_flag;}
 else if(LOSGELAS)
  {if(zentriermitte_flag)
	{double ywert;
	 zentriermitte_flag=0;
	 invtransformru(&zentriermitte,&ywert,XWERT(x),YWERT(y));
	}
   if(fadenkreuz_flag>1)
	{fadenkreuz_flag=1; fadenkreuz_typ=fadenkreuz_alt; fadenkreuz_alt=0;
	 if(fadenkreuz_typ==BRUSH || fadenkreuz_typ==LEIM)
			pixelbild_einschalten();
	 schalter_aus(0);
	}
   else if(fadenkreuz_flag==1) /* mit aktivem Fadenkreuz Knopf losgelassen */
	{if(rasterpunkt!=0) rarund(x,y,rasterpunkt,&x,&y);
	 switch(fadenkreuz_typ)		/** Mausfunktion abschliessen **/
	  {case BRUSH: case LEIM: case TEXT: case VIERECK: case LUPE:
	   case BOBOX:
	   CASE LINIE: case PFEIL: case DOPPEL:
			fadenkreuz_aus();
			switch(knopfnr)
			 {case 1:putipfeld(faden_x,faden_y); ipimax++;
				 if(linientyp==LINNORMAL)
					linienzug(ipfeld,ipimax);
				 else if(linientyp==LINCLOSEPATH)
					linienzug_closepath(ipfeld,ipimax);
				 else if(linientyp==LINCLOSEFILL)
					{linienzug_closefill(ipfeld,ipimax);
					 return;
					}
			  CASE 2:fadenkreuz_ein();
			  CASE 3:linientyp=LINCLOSEPATH; fadenkreuz_ein();
			 }
	   CASE SCHERE:	fadenkreuz_aus();
			switch(knopfnr)
			 {case 1:putipfeld(faden_x,faden_y); ipimax++;
				 ausschneiden(ipfeld,ipimax);
			  CASE 2:
			  case 3:linientyp=LINCLOSEPATH; fadenkreuz_ein();
			 }
	   CASE BEZIER:	fadenkreuz_aus();
			switch(knopfnr)
			 {case 1:putipfeld(faden_x,faden_y);
				 linienzug_bezier(ipfeld,ipimax);
				 savedflag=0;
			  CASE 2: case 3: fadenkreuz_ein();
			 }
	   CASE KREIS:	fadenkreuz_aus();
			switch(knopfnr)
			{case 1: showkreis(kreis_x,kreis_y,
				    idfix(kreis_radius*lupe_faktor[lupe_i]));
				 savedflag=0;
			 CASE 2: kreis_flag=1; fadenkreuz_ein();
			 CASE 3: kreis_dx=kreis_dy=0; kreis_flag=1;
				 fadenkreuz_ein();
			}
	  }
	 if(fadenkreuz_flag==0 && werkzeug!=0) symbolauswahl(werkzeug,werknr);
	}
   else if(fadenkreuz_flag==0)
	{if(werkzeug!=0) symbolauswahl(werkzeug,werknr);
	}
  }/* ende if(LOSGELAS) */
 return;
}

void schalter_um1(int snr,int knr) {werknr=knr; schalter_um(1,werkzeug=snr);}

void symbolauswahl(int symbolnr,int knopfnr)
{
 static char str[ZL];
 int n,ok;
 static int commandeing=1;
 double fa;
 switch(symbolnr)
       {case 0: if(knopfnr==3) resetgadgets();
		if(n=fadenkreuz_flag) fadenkreuz_aus();
		clear_bild();
		lineattribute_uebernemen();
		if(n) fadenkreuz_ein();
	CASE 1: undo();
	CASE 2: if(leim_dx!=0) leim_start();
		else requester((sprache==DEUTSCH)?
			"Leimpuffer leer (noch nichts ausgeschnitten)"
			:"pastebuffer empty (nothing cutted)","ok",NULL);
	CASE 3: if(brush_dx==0 || knopfnr>=2 || *brushfilename==0)
			file_loadbrush(knopfnr);
		else brush_start();
	CASE 4: if(knopfnr==3) schere_setzen();
		else
		 {if(knopfnr) schneidmethode=knopfnr;
		  schalter_um1(symbolnr,knopfnr);
		  fadenkreuz_typ=SCHERE; ipimax=0;
		  linientyp=LINNORMAL; linien_step=0;
		  fadenkreuz_ein();
		 }
	CASE 5: if(knopfnr) vergroessern_modus=knopfnr;
		if(fadenkreuz_flag)
		  {if(fadenkreuz_flag==BRUSH || fadenkreuz_flag==LEIM)
				pixelbild_ausschalten();
		   if(fadenkreuz_flag==STRECK || fadenkreuz_flag==STRECKTXT)
			{fadenkreuz_flag=1; schalter_aus(0);}
		   else if(fadenkreuz_typ==TEXT || fadenkreuz_typ==VIERECK ||
			   fadenkreuz_typ==BRUSH || fadenkreuz_typ==LEIM ||
			   fadenkreuz_typ==LUPE || fadenkreuz_typ==BOBOX)
			 {if(fadenkreuz_typ==TEXT) fadenkreuz_flag=STRECKTXT;
			  else fadenkreuz_flag=STRECK;
			  schalter_um(0,symbolnr);
		  }	 }
	CASE 6: if(knopfnr==1)
		 {schalter_um1(symbolnr,knopfnr);
		  setbru_dxdy(buchst_dx,buchst_dy);
		  bru_winkel=buchst_winkel; bru_winkel_neu=1;
		  input2("Text:",texttext,120);
		  if(texttext[0]) {fadenkreuz_typ=TEXT; fadenkreuz_ein();}
		  else fadenkreuz_typ=0;
		 }
		else if(knopfnr==2)
		 { input("Fontname:","%s",(long)vectmalfont);
		   sprintf(uvectmalfont,"u%s",vectmalfont); }
	CASE 7: if(knopfnr) rotation_modus=knopfnr;
		if(fadenkreuz_flag)
		  {if(fadenkreuz_flag==BRUSH || fadenkreuz_typ==LEIM)
				 pixelbild_ausschalten();
		   if(fadenkreuz_flag==ROTAT || fadenkreuz_flag==ROTATTXT)
			{fadenkreuz_flag=1; schalter_aus(0);}
		   else if(fadenkreuz_typ==TEXT || fadenkreuz_typ==VIERECK ||
			   fadenkreuz_typ==BRUSH || fadenkreuz_typ==LEIM)
			{ if(fadenkreuz_typ==TEXT) fadenkreuz_flag=ROTATTXT;
			  else fadenkreuz_flag=ROTAT;
			  schalter_um(0,symbolnr);	}
		  }
	CASE 8: switch(knopfnr) { case 3: linien_step=45;
				  CASE 2:linien_step=5;DEFAULT:linien_step=0; }
		schalter_um1(symbolnr,knopfnr);
		fadenkreuz_typ=LINIE; ipimax=0; linientyp=LINNORMAL;
		fadenkreuz_ein();
	CASE 9: switch(knopfnr) { case 3: linien_step=45;
				  CASE 2:linien_step=5;DEFAULT:linien_step=0; }
		schalter_um1(symbolnr,knopfnr);
		fadenkreuz_typ=BEZIER; ipimax=0; linientyp=LINNORMAL;
		fadenkreuz_ein();
	CASE 10:schalter_um1(symbolnr,knopfnr);
		fadenkreuz_typ=KREIS; kreis_flag=1; kreis_knopfnr=knopfnr;
		if(knopfnr==3 && ellipseflag==0)
			{if(fadenkreuz_flag) fadenkreuz_aus();
			 lower_window();
			 printf("Ellipse Stauchfaktor in y-Richtung:(%lf):",
				ellipsefakt);
			 scanf("%lf",&ellipsefakt); ellipseflag=1;
			 raise_window();
			}
		else if(knopfnr==1) ellipseflag=0;
		fadenkreuz_ein();
	CASE 11:schalter_um1(symbolnr,knopfnr);
		setbru_dxdy(viereck_dx,viereck_dy);
		bru_winkel=viereck_winkel; bru_winkel_neu=1;
		fadenkreuz_typ=VIERECK; viereck_knopfnr=knopfnr;
		fadenkreuz_ein();
	CASE 12:bildsichern(knopfnr);
	CASE 13:if(n=fadenkreuz_flag) fadenkreuz_aus();
		if(commandeing)
		 {input2("Command:",str,ZL);
		  requester((sprache==DEUTSCH)?
			"Fuer Ausfuehrung Symbol '>' nochmals anklicken"
			:"to do it press '>' again","ok",NULL); /* provi. */
		  commandeing=0;
		 }
		else
		 {qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
		  exec_str(str);
		  term();
		  commandeing=1;
		 }
		if(n) fadenkreuz_ein();
	CASE 14:setlinewidthx(0,symbolnr);
	CASE 15:setlinewidthx(1,symbolnr);
	CASE 16:setlinewidthx(2,symbolnr);
	CASE 17:setlinewidthx(3,symbolnr);
	CASE 18:setlinewidthx(4,symbolnr);
	CASE 19:setlinewidthx(5,symbolnr);
	CASE 20:setlinewidthx(6,symbolnr);
	CASE 21:setlinewidthx(8,symbolnr);
	CASE 22:setdashx(symbolnr,2,1,3,0,0); /* punktiert */
	CASE 23:setdashx(symbolnr,2,3,3,0,0); /* kurz gestr. */
	CASE 24:setdashx(symbolnr,2,6,3,0,0); /* lang gestr. */
	CASE 25:setdashx(symbolnr,4,4,3,1,3); /* StrichPunkt */
	CASE 26:setdashx(symbolnr,4,6,3,2,3); /* LangKurz */
	CASE 27:setdashx(symbolnr,0,0,0,0,0); /* ausgezogen */
	CASE 28:if(help_flag)
		  {schalter_aus(6); help_flag=0;}
		else
		  {schalter_ein(6,symbolnr);
		   if(knopfnr==1) help_flag=1; else help_flag= -1;
		  }
	CASE 29:file_exit();
	CASE 30:switch(knopfnr)
		 {case 3: lupe_reset();
		  CASE 2: lupe_zoomout();
		  DEFAULT:schalter_um1(symbolnr,knopfnr);
			  setbru_dxdy(lupe_dx,lupe_dy);
			  bru_winkel=0; bru_winkel_neu=1;
			  fadenkreuz_typ=LUPE;
			  fadenkreuz_ein();
		 }
	CASE 31:if(zentrieren_flag)
			{zentrieren_flag=0;
			 schalter_aus(4);
			}
		else switch(knopfnr)
		 {case 3:  zentrieren_flag=1;   /* alle Objekte zentrieren */
			   zentriermitte_flag=1;/* naechstes Mausloslassen */
						/* kann Zentriermitte setzen */
			   schalter_ein(4,symbolnr);
		  CASE 2:  zentrieren_flag= -1; /* nur naechstes Objekt */
			   meldung("naechstes Objekt Zentrieren\n");
		  DEFAULT: letztes_zentrieren();
		 }
	CASE 32:/* Doppelbindung */
		if(knopfnr==3)
		 {if(n=fadenkreuz_flag) fadenkreuz_aus();
		  lower_window();
		  printf("Abstand zwischen den Linien:(%.2lf):",doppel_a2);
		  scanf("%lf",&doppel_a2);
		  raise_window();
		  if(n) fadenkreuz_ein();
		 }
		else
		 {switch(knopfnr) { case 3: linien_step=45;
				  CASE 2:linien_step=5;DEFAULT:linien_step=0; }
		  schalter_um1(symbolnr,knopfnr);
		  fadenkreuz_typ=DOPPEL; ipimax=0; linientyp=LINNORMAL;
		  fadenkreuz_ein();
		 }
	CASE 33:/* Pfeil */
		if(knopfnr==3)
		 {if(n=fadenkreuz_flag) fadenkreuz_aus();
		  lower_window();
		  printf("Laenge der Pfeilspitze:(%.2lf):",pfeil_a3);
		  scanf("%lf",&pfeil_a3);
		  printf("Breite der Pfeilspitze:(%.2lf):",pfeil_a2);
		  scanf("%lf",&pfeil_a2);
		  printf("Spitze Gefuellt(1) oder Leer(0) ?");
		  scanf("%d",&pfeil_fill);
		  printf("Angaben fuer Wellenlinie\n");
		  printf("Amplitude:(%.2lf):",pfeil_amplitude);
		  scanf("%lf",&pfeil_amplitude);
		  if(pfeil_amplitude!=0.)
			{printf("Periode:(%.2lf):",pfeil_periode);
			 scanf("%lf",&pfeil_periode);
			}
		  raise_window();
		  if(n) fadenkreuz_ein();
		 }
		else
		 {switch(knopfnr) {case 2:linien_step=5;DEFAULT:linien_step=0;}
		  schalter_um1(symbolnr,knopfnr);
		  fadenkreuz_typ=PFEIL; ipimax=0; linientyp=LINNORMAL;
		  fadenkreuz_ein();
		 }
	CASE 34:{if(n=fadenkreuz_flag) fadenkreuz_aus();
		 switch(knopfnr)	/* Raster */
		  {case 3: lower_window();
			   printf("Setze Rasterdichte\n Raster1:(%d):",raster1);
			   scanf("%d",&raster1);
			   printf("Raster2:(%d):",raster2);
			   scanf("%d",&raster2);
			   raise_window();
		   CASE 2: raster(raster2,symbolnr);
		   DEFAULT:raster(raster1,symbolnr);
		  }
		 if(n) fadenkreuz_ein();
		}
	CASE 35:bildrefresh();
	CASE 36:/* Fuellmethode (Schraffierung) */
		if(n=fadenkreuz_flag) fadenkreuz_aus();
		switch(fuellmethode)
		 {case SCHRAFF1:setfuellmethode(SCHRAFF2,symbolnr); //Schraffur:\\\ 
		  CASE SCHRAFF2:setfuellmethode(SCHRAFF3,symbolnr); //Gitter
		  CASE SCHRAFF3:setfuellmethode(SCHRAFF4,symbolnr); //punktiert
		  CASE SCHRAFF4:setfuellmethode(FUELL_GRAU,symbolnr);//grauwert
		  CASE FUELL_GRAU:setfuellmethode(FILL,symbolnr); //normal
		  DEFAULT:setfuellmethode(SCHRAFF1,symbolnr); //Schraffur:///
		 }
		 if(n) fadenkreuz_ein();
	CASE 37:/* BoundingBox setzen (hnlich Viereck zeichnen, oder LUPE) */
		switch(knopfnr)
		 {case 3: ok=requester("BoundingBox auf A4-Format setzen",
					"  ok  ","cancel");
			  if(ok) newbboxflag=0;
		  DEFAULT:schalter_um1(symbolnr,knopfnr);
			  setbru_dxdy(lupe_dx,lupe_dy);
			  bru_winkel=0; bru_winkel_neu=1;
			  fadenkreuz_typ=BOBOX;
			  fadenkreuz_ein();
		 }
	CASE 38:/* Objekt editieren */
		switch(knopfnr)
		 {case 1:
		   schalter_um1(symbolnr,knopfnr);
		   fadenkreuz_typ=EDIT; ipimax=0; linientyp=LINNORMAL;
		   fadenkreuz_ein();
		   file_save2(VOEDTMPNAME);
		   start_voed(VOEDTMPNAME);
		   fadenkreuz_aus(); fadenkreuz_typ=0; fadenkreuz_ein();
		   file_load2(VOEDTMPNAME);
		   savedflag=0;
		 }
       }
 return;
}

void setlinewidthx(int x,int symbolnr)
{
 int n;
 if(n=fadenkreuz_flag) fadenkreuz_aus();
 schalter_um(2,symbolnr);
 gs.linewidth=x;
 darflag=darflag_line=1;
 if(n) fadenkreuz_ein();
}

void setdashx(int symbolnr,int len,int on1,int off2,int on3,int off4)
{
 int i,n;
 if(n=fadenkreuz_flag) fadenkreuz_aus();
 schalter_um(3,symbolnr);
 for(i=0;i<len;i++)
	{gs.dashfeld[i]=on1; on1=off2;off2=on3;on3=off4;}
 gs.dashlen=len; gs.dashoffset=0;
 darflag=darflag_dash=1;
 lineattribute_setzen();
 if(n) fadenkreuz_ein();
 return;
}

void brush_start()
{
 char c1,c2,boxstr[80];
 FILE *fp;
 int n;
 if(fadenkreuz_flag) fadenkreuz_aus();
 if(!(fp=fopen2(brushfilename,"r"))) return;
 schalter_um1(3,1);
 if((n=bbox_suchen(fp,"%%BoundingBox:",boxstr,80))>=1)
	{sscanf(boxstr,"%lf %lf %lf %lf",&xul,&yul,&xor,&yor);}
 else	{xul=yul=0; xor=PSA4B; yor=PSA4H;}
 if(xor==xul || yor==yul)
   {xul=0; yul=0; xor=PSA4B; yor=PSA4H;}
 fclose(fp);
 setbru_dxdy(brush_dx,brush_dy); bru_winkel=brush_winkel;
 bru_winkel_neu=1;
 fadenkreuz_typ=BRUSH; fadenkreuz_ein();
}

void leim_start(int flg)
{
 char c1,c2,boxstr[80];
 FILE *fp;
 int n;
 if(fadenkreuz_flag) fadenkreuz_aus();
 if(!(fp=fopen2(TEMPBRUSHNAME,"r"))) return;
 schalter_um1(2,1);
 DEBUG(1,printf("leim_start(%d) ",flg));/* test */
 if((n=bbox_suchen(fp,"%%BoundingBox:",boxstr,80))>=1)
	{sscanf(boxstr,"%lf %lf %lf %lf",&xul,&yul,&xor,&yor);}
 else	{xul=yul=0; xor=PSA4B; yor=PSA4H;}
 if(xor==xul || yor==yul)
   {xul=0; yul=0; xor=PSA4B; yor=PSA4H;}
 fclose(fp);
 setbru_dxdy(leim_dx,leim_dy); bru_winkel=leim_winkel;
 bru_winkel_neu=1;
 DEBUG(1,printf("bru_dx=%d bru_dy=%d\n",bru_dx,bru_dy));/* testleim */
 if(brushpreview>0 && flg) brush2pixelbild(TEMPBRUSHNAME);
 fadenkreuz_typ=LEIM; fadenkreuz_ein();
}

/********************** Lupe ************************/
double ctminit[6],ctminit0[6],ctminit_tab[6][MAXLUP];
double lup_xul[MAXLUP],lup_yul[MAXLUP],lup_xor[MAXLUP],lup_yor[MAXLUP];

void lupe(int fadenx,int fadeny,int lupedx,int lupedy)
{
 int i;
 double faktor,cx,cy;
 double sx,sy,dex,dey,breite,hoehe;
 DEBUG(1,printf("lupe: fadenx=%d fadeny=%d lupedx=%d lupedy=%d\n",
			fadenx,fadeny,lupedx,lupedy));
 if(lupe_i>=MAXLUP-1)
	{printf("zu grosse Verschachtelung in lupe()\n"); return;}
 for(i=0;i<6;i++) ctminit_tab[i][lupe_i]=ctminit[i];
 if((i=lupe_i++)==0)
	{lup_xul[0]=lup_yul[0]=0.; lup_xor[0]=PSA4Bd; lup_yor[0]=PSA4Hd;
	 lupe_faktor[0]=1.0;
	}
 if(hochformat)	{dex=x2fenster-x1fenster; dey=y2fenster-y1fenster;}
 else		{dey=x2fenster-x1fenster; dex=y2fenster-y1fenster;}
 breite=lup_xor[i]-lup_xul[i]; hoehe=lup_yor[i]-lup_yul[i];
 dex=lupedx/dex*breite; sx=breite/dex;
 dey=lupedy/dey*hoehe; sy=hoehe/dey;
 if(sy<sx) {faktor=sy; lupedx=(int)(lupedx*sx/sy);}
 else	{faktor=sx; lupedy=(int)(lupedy*sy/sx);}
 if(hochformat) {cx=XWERT(fadenx-lupedx/2); cy=YWERT(fadeny+lupedy/2);}
 else	{cx=XWERT(fadenx+lupedy/2); cy=YWERT(fadeny+lupedx/2);}
 zahlpush2(cx,cy); itransform();
 zahlpop(&cy); zahlpop(&cx);
 lup_xul[lupe_i]=cx; lup_yul[lupe_i]=cy;
 lup_xor[lupe_i]=lup_xul[lupe_i]+breite/faktor;
 lup_yor[lupe_i]=lup_yul[lupe_i]+hoehe/faktor;
 lupe_faktor[lupe_i]=faktor*lupe_faktor[i];
 zahlpush2(lup_xul[i],lup_yul[i]); translate();
 zahlpush2(faktor,faktor); scale();
 zahlpush2(-cx,-cy); translate();
 ctminit[0]=PP; ctminit[1]=QQ; ctminit[2]=RR; ctminit[3]=SS;
 ctminit[4]=TT; ctminit[5]=UU;
 bildrefresh();
}
void lupe_zoomout()
{
 int i;
 if(--lupe_i<0) {lupe_i=0; return;}
 for(i=0;i<6;i++) ctminit[i]=ctminit_tab[i][lupe_i];
 bildrefresh();
}
void lupe_reset()
{
 int i;
 if(lupe_i==0) return;
 lupe_i=0;
 for(i=0;i<6;i++) ctminit[i]=ctminit0[i];
 bildrefresh();
}

/********************* NewBBox **********************/
void newbbox(int fadenx,int fadeny,int dx,int dy)
{
 int hx,hy;
 if(lupe_i==0)
   {hx=dx/2; hy= -dy/2;}
 else
   {hx=idfix(lupe_faktor[lupe_i]*dx/2.); hy=idfix(-lupe_faktor[lupe_i]*dy/2.);}
 if(argflag['Q']) {int h=hx; hx= -hy; hy= -h;}
 bkoord2user(fadenx-hx,fadeny-hy,&newbboxx1,&newbboxy1);
 bkoord2user(fadenx+hx,fadeny+hy,&newbboxx2,&newbboxy2);
// printf("newbbox() --> %lf %lf %lf %lf\n",
//	newbboxx1,newbboxy1,newbboxx2,newbboxy2);//test
 if(newbboxy2>1000. || newbboxy2 < -1000.) newbboxy2=843.;//provi. korrigiert
 newbboxflag=1;
 savedflag=0;
}

/********************** Schalter ************************/
void schalter_ein(int x,int symbolnr)	/* Schaltet Schalter x ein */
{
 schalter_markieren(schalter_status[x]=symbolnr,WEISS);
}

void schalter_aus(int x)	/* Schaltet Schalter x aus */
{
 int nr;
 nr=schalter_status[x];
 if(nr!=0) {schalter_markieren(nr,SCHWARZ); schalter_status[x]=0;}
}

void schalter_markierung(int x,int y,int dx,int dy,int farbe)
{
 auswahl_color(farbe);
 XDrawRectangle(tekplot_dpy,auswahl_win,auswahl_gc,x,y,dx,dy);
}
void schalter_markieren(int i,int farbe)	/* Markiert Symbol x */
{
 int x,y,dx=XDPIC-2,dy=YDPIC-2;
 x=((i&1) ? X0PIC+1 : 0);
 y=i/2*YDPIC+1;
 schalter_markierung(x,y,dx,dy,farbe);
}

void schalter_um(int nr,int symbolnr)
		/* Schaltet Schalter in Symbolbereich um */
		/* 1=Werkzeug  0=Verformung  2=Liniendicke  3=Strichelung */
{
 int x,n=0;
 if(nr==1) {if(fadenkreuz_flag) fadenkreuz_aus();}
 else if(nr!=0 && (n=fadenkreuz_flag)) fadenkreuz_aus();
 x=schalter_status[nr];
 if(x!=0) schalter_markieren(x,SCHWARZ);
 if(schalter_status[nr]=symbolnr)
	schalter_markieren(symbolnr,WEISS);
 if(n) fadenkreuz_ein();
}

void grauschalter_markieren(int y,int farbe)
{
 int x=0,dx=XDPIC*2-2,dy=YDPIC-2;
 schalter_markierung(x,y+1,dx,dy,farbe);
}
void grauschalter_um(int y)
{
 grauschalter_markieren(grauschalter_y0,SCHWARZ);
 grauschalter_markieren(grauschalter_y0=y,WEISS);
}

void aktuelle_farbnummer_anzeigen(int farbnr)
{
 int n,k,n1,n2;
 grauschalter_um((farbnr&0x7)*YDPIC+YFARB0);
 auswahl_rechteckfill(X1PIC/3+1,(31-9)*YDPIC+1,X1PIC*2/3,(31-8)*YDPIC,farbnr);
 auswahl_rechteckfill(1,YFARB0-YDPIC+1,XDPIC*2/3-1,YFARB0-1,SCHWARZ);
 aktuelle_farbnr=farbnr;
 n1=farbnr/10; n2=farbnr%10;
 if(n1>0) {zeichnepic(picziff[n1], 0, 44/2*YDPIC); k=6;}
 else k=3;
 zeichnepic(picziff[n2], k, 44/2*YDPIC);
}

/************************ Fadenkreuz ************************/
void ecke3(int *ddx,int *ddy,int winkel,int dx,int dy)
{			/* berechnet Abstand der rechten oberen Ecke */
 double sinw,cosw,w; /*dx,dy,*/
 if(!hochformat) winkel+=90;
 w=winkel*GRAD;
 sinw=sin(w); cosw=cos(w);
 *ddx=idfix(dx*cosw+dy*sinw);
 *ddy=idfix(dy*cosw-dx*sinw);
}

void ecke4(int *ddx,int *ddy,int winkel,int dx,int dy)
{			/* berechnet Abstand der linken oberen Ecke */
 double sinw,cosw,w;
 if(!hochformat) winkel+=90;
 w=winkel*GRAD;
 sinw=sin(w); cosw=cos(w);
 *ddx=idfix(dy*sinw-dx*cosw);
 *ddy=idfix(dx*sinw+dy*cosw);
}

void bru_ecke3(int *ddx,int *ddy)
{
 int hx,hy;
 if(lupe_i==0)	{hx=(int)(bru_dx/2); hy=(int)(-bru_dy/2);}
 else	{hx=(int)(lupe_faktor[lupe_i]*bru_dx/2.);
	 hy=(int)(-lupe_faktor[lupe_i]*bru_dy/2.);
	}
 ecke3(ddx,ddy,bru_winkel,hx,hy);
 bru_x1 = faden_x - *ddx;  bru_y1 = faden_y - *ddy;
}

static char fenst_info[ZL];

void bewegung(int x,int y)
{
 double xwert,ywert;
 if(rasterpunkt!=0) rarund(x,y,rasterpunkt,&x,&y);
 if(fadenkreuz_flag)
	{neuesfadenkreuz(x,y); x=faden_x; y=faden_y;}
 else	{faden_x=x; faden_y=y;}
 invtransformru(&xwert,&ywert,XWERT(x),YWERT(y));
 sprintf(&fenstername[fenstername1_len]," x=%lg  y=%lg   %s",
					xwert,ywert,fenst_info);
 Fenstertitel(fenstername);
}

/* in Verzeichnis [pfister.bitmap] mit BITMAP Name.DAT gezeichnet: */
static char	lupe_bilddat[] = {
   0x00, 0x1f, 0x80, 0x20, 0x40, 0x40, 0x20, 0x80, 0x20, 0x80, 0x20, 0x80,
   0x20, 0x80, 0x20, 0x80, 0x40, 0x40, 0xe0, 0x20, 0x30, 0x1f, 0x18, 0x00,
   0x0c, 0x00, 0x06, 0x00, 0x03, 0x00, 0x01, 0x00
  };
static char	lupe_bilddatm[] = {
   0x00, 0x1f, 0x80, 0x3f, 0xc0, 0x60, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0,
   0x60, 0xc0, 0x60, 0xc0, 0xc0, 0x60, 0xc0, 0x3f, 0x60, 0x1f, 0x30, 0x00,
   0x18, 0x00, 0x0c, 0x00, 0x06, 0x00, 0x03, 0x00
  };

static char	schere_bilddat[] = {
   0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, 0x88, 0x00, 0x44, 0x00, 0x24,
   0x00, 0x1a, 0xee, 0x07, 0x11, 0x02, 0x11, 0x02, 0x11, 0x02, 0xce, 0x01,
   0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0xc0, 0x01
  };
static char	schere_bilddatm[] = {
   0x00, 0x00, 0x00, 0x30, 0x00, 0x18, 0x00, 0x8c, 0x00, 0xc6, 0x00, 0x66,
   0x00, 0x3a, 0xee, 0x1f, 0xff, 0x03, 0x1b, 0x03, 0x1f, 0x03, 0xce, 0x01,
   0xe0, 0x03, 0x60, 0x03, 0xe0, 0x03, 0xc0, 0x01
  };

static char	edit_bilddat[] = {
   0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x40, 0x02, 0x40, 0x02, 0x20, 0x04,
   0x18, 0x18, 0x06, 0x60, 0x06, 0x60, 0x18, 0x18, 0x20, 0x04, 0x40, 0x02,
   0x40, 0x02, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00
  };
static char	edit_bilddatm[] = {
   0x00, 0x01, 0xC0, 0x03, 0xC0, 0x03, 0x60, 0x06, 0x60, 0x06, 0x30, 0x0C,
   0x1C, 0x38, 0x07, 0xE0, 0x07, 0xE0, 0x1C, 0x38, 0x30, 0x0C, 0x60, 0x06,
   0x60, 0x06, 0xC0, 0x03, 0xC0, 0x03, 0x80, 0x00
  };

static char	kruz_bilddat[] = {
   0x00, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
   0x80, 0x00, 0x00, 0x00, 0x3f, 0x7e, 0x00, 0x00, 0x80, 0x00, 0x80, 0x00,
   0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00
  };
static char	kruz_bilddatm[] = {
   0x00, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
   0x80, 0x00, 0x7f, 0xfc, 0x3f, 0x7e, 0x00, 0x01, 0x80, 0x01, 0x80, 0x01,
   0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x00
  };

void bilddat_umkehr(char *dat)
{
 int i;
 for(i=0;i<sizeof(lupe_bilddat);i++) *dat++ ^= 0xFF;
}
void cursor_bilddat_init()
{
 static int umkflag=0;
 char **p,*pf[]={lupe_bilddat,lupe_bilddatm,schere_bilddat,schere_bilddatm,
		kruz_bilddat,kruz_bilddatm,edit_bilddat,edit_bilddatm,NULL};
 if(argflag['W'] && umkflag==0)
	{for(p=pf;*p!=NULL;p++) bilddat_umkehr(*p);
	 umkflag=1;
	}
}

void fadenkreuz_ein()
{
 refreshflag=0; fadenkreuz_flag=1;
 if(fadenkreuz_typ==BRUSH || fadenkreuz_typ==LEIM)
	 pixelbild_ein();
 fadenkreuz(faden_x,faden_y);
 switch(fadenkreuz_typ)
  {case LUPE:	cursor_setzen(lupe_bilddat,lupe_bilddatm,
				16,16,10,5);/* Breite,Hoehe,Hotx,Hoty */
   CASE SCHERE:	cursor_setzen(schere_bilddat,schere_bilddatm,
				16,16,8,8);
   CASE EDIT:	cursor_setzen(edit_bilddat,edit_bilddatm,
				16,16,8,8);
   CASE STRECK: case ROTAT:
   DEFAULT:	//cursor_reset();
		cursor_setzen(kruz_bilddat,kruz_bilddatm,16,16,7,8);
  }
}

void fadenkreuz_aus()
{
 fadenkreuz(faden_x,faden_y);
/* XSetFunction(tekplot_dpy,tekplot_gc,GXcopy); */
/* XSetFillStyle(tekplot_dpy,tekplot_gc,fillstyle); */
 refreshflag=1; fadenkreuz_flag=0;
}

void neuesfadenkreuz(int x,int y)
{
 int x2,y2,flag,dex,dey,e;
 static int y0= -1,dexi=0,deyi=0;
 static double wi;
 fadenkreuz(faden_x,faden_y);
 switch(fadenkreuz_typ)
  {case STRECK: case STRECKTXT:
    if(vergroessern_modus>=2)
     {dex=dey=0;
      DEBUG(1,printf("vergroessern_modus=%d\n",vergroessern_modus));/* test */
      if(vergroessern_modus==3)
	{e=vergroessern_step;
	 if(dexi==0 && deyi==0)
			{setbru_dxdy(intrund(bru_dx,e),intrund(bru_dy,e));}
	}
      else e=1;
      dexi+=x-faden_x; deyi+=faden_y-y;
      if(dexi>=10) {dex=e;dexi-=10;} else if(dexi<= -10) {dex= -e; dexi+=10;}
      if(deyi>=10) {dey=e;deyi-=10;} else if(deyi<= -10) {dey= -e; deyi+=10;}
     }
    else
     {if(brush_propflag && fadenkreuz_alt==BRUSH)
		{dex=x-faden_x; dey=faden_y-y;}
      else	{dex=2*(x-faden_x); dey=2*(faden_y-y);}
      dexi=deyi=0;
     }
    if(hochformat) flag=1; else flag=0;
    if((bru_winkel>45 && bru_winkel<135)
	|| (bru_winkel>225 && bru_winkel<315))  flag ^= 1;
    if(flag)	{setbru_dxdy(bru_dx+dex,bru_dy+dey);}
    else	{setbru_dxdy(bru_dx+dey,bru_dy+dex);}
   CASE ROTAT: case ROTATTXT:
    if(bru_winkel_neu)
	{ y0= -1; bru_winkel_neu=0;
	  wi = rotation_modus!=3 ? bru_winkel
		: idfix((double)bru_winkel/rotation_step)*rotation_step; }
    switch(rotation_modus)
	{case 3: if(y0== -1) y0=faden_y;
		 else if(faden_y>=y0+10) {wi -= rotation_step; y0=y;}
		 else if(faden_y<=y0-10) {wi += rotation_step; y0=y;}
	 CASE 2: wi += (faden_y-y)/10.;
	 CASE 1: default: wi += faden_y-y;
	}
    while(wi<0.) wi+=360.;
    while(wi>=360.) wi-=360.;
    bru_winkel = (int)(wi+0.5);
   CASE LINIE: case BEZIER: case SCHERE: case PFEIL: case DOPPEL:
    if(linien_step>0 && ipimax>=1)
	{einschraenk(ipfeld[ipimax-1].x,ipfeld[ipimax-1].y,x,y,&x2,&y2);
	 x=x2; y=y2;
	}
  }
 fadenkreuz(x,y);
}

double linienlaenge(int x1,int y1,int x2,int y2)
{
 double x,y;
 ideltatransform(&x,&y,(double)(x1-x2),(double)(y1-y2));
 return sqrt(x*x+y*y);
}

#define IDETRA(x) ideltatrans((double)(x+x))

void fadenkreuz(int x,int y)
{
 int ddx,ddy,ddx2,ddy2,r,rw2,ry,ryw2,i,wy0;
 int ddx3,ddy3,ddx4,ddy4;
 double winkel,lupfakt;
 int wx,wy,x1,y1,brudx,brudy;
 if(x<0 || y<0) return;
 faden_x=x; faden_y=y;
 if(darflag) lineattribute_setzen();
 switch(fadenkreuz_typ)
  {case BRUSH: case LEIM:
	if(brushpreview>0 && pixelbild_ok())
		{double f;
		 int t=idfix(1000.*(f=lupe_faktor[lupe_i]));
		 if(t!=pixelbild_oldlupefaktor)
			{pixelbild_zerren(idfix(bru_dx*f),
					idfix(bru_dy*f),bru_winkel);
			 pixelbild_oldlupefaktor=t;
			}
		 zeigpixelbild(x,y); break;
		}
   case VIERECK: case LUPE: case STRECK: case ROTAT: case BOBOX:
	if(lupe_i==0 || fadenkreuz_typ==LUPE || fadenkreuz_alt==LUPE)
		{wx=bru_dx/2; wy= -bru_dy/2;}
	else	{double f=lupe_faktor[lupe_i]/2.;
		 wx=idfix(bru_dx*f); wy= -idfix(bru_dy*f);
		}
	ecke3(&ddx,&ddy,bru_winkel,wx,wy);
	ecke4(&ddx2,&ddy2,bru_winkel,wx,wy);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x-ddx,y-ddy,x-ddx2,y-ddy2);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x-ddx2,y-ddy2,x+ddx,y+ddy);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x+ddx,y+ddy,x+ddx2,y+ddy2);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x+ddx2,y+ddy2,x-ddx,y-ddy);
	sprintf(fenst_info,"dx=%.1lf dy=%.1lf w=%.1lfGrad",
		IDETRA(ddx),IDETRA(ddy),(double)bru_winkel);
   CASE TEXT: case STRECKTXT: case ROTATTXT:
/**
  Nummerierung der Ecken:
      1 +--------+ 2
	|	 |	Ecke 1 und 2 erhaelt man mit 'ecke3()' und 'ecke4()'
	|	 |	und Spiegelung der Resultate (= negative ddx,ddy-Werte)
	|	 |
	|	 |
	|-----o--|   bei 'o' ist der Drehpunkt = Fadenkreuz
	|	 |   ddx und ddy sind die Abstaende vom Drehpunkt
      4 +--------+ 3
**/
	if(lupe_i==0) {brudx=bru_dx; brudy=bru_dy;}
	else
	  {brudx=bru_dx*(int)lupe_faktor[lupe_i];
	   brudy=bru_dy*(int)lupe_faktor[lupe_i];
	  }
	wx=brudx/2; wy0= -brudy*3/2;
	ecke3(&ddx,&ddy,bru_winkel,wx,y1=wy0/2);
	ecke4(&ddx2,&ddy2,bru_winkel,x1=wx/2,y1);
	ecke3(&ddx3,&ddy3,bru_winkel,x1,wy=wy0/6);
	ecke4(&ddx4,&ddy4,bru_winkel,wx,wy);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x-ddx,y-ddy,x-ddx2,y-ddy2);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x-ddx2,y-ddy2,x+ddx3,y+ddy3);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x+ddx3,y+ddy3,x+ddx4,y+ddy4);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x+ddx4,y+ddy4,x-ddx,y-ddy);
	ecke3(&ddx,&ddy,bru_winkel,wx,wy0/=3);
	ecke4(&ddx2,&ddy2,bru_winkel,x1,wy0);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x-ddx,y-ddy,x-ddx2,y-ddy2);
	sprintf(fenst_info,"dx=%.2lf dy=%.2lf w=%.1lfGrad",
		IDETRA(ddx),IDETRA(ddy),(double)bru_winkel);
   CASE LINIE: case BEZIER: case SCHERE: case PFEIL: case DOPPEL:
	if(ipimax>=1)
	  {for(i=1;i<ipimax;i++)  /*!!! XDrawLines() geht hier nicht !!!*/
		XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,ipfeld[i-1].x,
			  ipfeld[i-1].y,ipfeld[i].x,ipfeld[i].y);
	   x1=ipfeld[ipimax-1].x; y1=ipfeld[ipimax-1].y;
	   wx=abs(x-x1); wy=abs(y-y1);
	   if(wx==0) winkel=90.0;
	   else winkel=atan((double)wy/wx)*(180./PI);
	   XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x1,y1,x,y);
	   sprintf(fenst_info,"L=%.1lf w=%.1lf Grad",
		   linienlaenge(ipfeld[ipimax-1].x,ipfeld[ipimax-1].y,x,y),
		   winkel);
	  }
	if(linientyp & LINCLOSEPATH)
	     XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,
			x,y,ipfeld[0].x,ipfeld[0].y);
   CASE KREIS:
	lupfakt=lupe_faktor[lupe_i];
	if(kreis_flag==2)
	   {kreis_dx=idfix((x-kreis_x)/lupfakt);
	    kreis_dy=idfix((y-kreis_y)/lupfakt);
	    kreis_radius=
		idfix(sqrt((double)(kreis_dx*kreis_dx+kreis_dy*kreis_dy)));
	   }
	else
	   {kreis_x=x-idfix(kreis_dx*lupfakt);
	    kreis_y=y-idfix(kreis_dy*lupfakt);
	   }
	sprintf(fenst_info,"r=%.1lf",ideltatransru(XWERTD(kreis_radius)));
	r=idfix(kreis_radius*lupfakt); rw2=r*707/1000;
	if(ellipseflag) {ry=idfix(r*ellipsefakt); ryw2=ry*707/1000;}
	else	{ry=r; ryw2=rw2;}
	x=kreis_x; y=kreis_y;
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x-r,y,x-rw2,y-ryw2);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x-rw2,y-ryw2,x,y-ry);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x,y-ry,x+rw2,y-ryw2);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x+rw2,y-ryw2,x+r,y);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x+r,y,x+rw2,y+ryw2);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x+rw2,y+ryw2,x,y+ry);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x,y+ry,x-rw2,y+ryw2);
	XDrawLine(tekplot_dpy,tekplot_win,fadenkreuz_gc,x-rw2,y+ryw2,x-r,y);
  }
 return;
}

void putipfeld(int x,int y)
{
 ipfeld[ipimax].x=x; ipfeld[ipimax].y=y;
}

int einschraenk(int x0,int y0,int x1,int y1,int *zx,int *zy)
{
 int dx,dy,wink;
 double winkel,r;
/* winkel auf linien_step Grad runden und die x y Werte korrigieren */
 dx=x1-x0; dy=y1-y0;
 if(dx==0) {*zx=x1; *zy=y1; if(dy>=0) return 90; else return 270;}
 if(dy==0) {*zx=x1; *zy=y1; if(dx>=0) return 0;  else return 180;}
 winkel = atan2((double)dy,(double)dx); /* im Bereich -PI/2 bis PI/2 */
 if(winkel>0.) wink=idfix((winkel/GRAD+linien_step/2.)/linien_step);
 else wink=idfix((winkel/GRAD-linien_step/2.)/linien_step);
 if((wink*=linien_step)<0) wink+=360;
 r=sqrt((double)(dx*dx+dy*dy));
 *zx = idfix(x0+r*cos(winkel=wink*GRAD));
 *zy = idfix(y0+r*sin(winkel));
 return wink;
}

void raster(int n,int symbolnr)
{
 if(schalter_status[5]==0)	{schalter_ein(5,symbolnr); rasterpunkt=n;}
 else				{schalter_aus(5); rasterpunkt=0;}
}

void setbru_dxdy(int x,int y)
{
 if(brush_propflag && (fadenkreuz_typ==BRUSH || fadenkreuz_alt==BRUSH))
	{y=x*brush_propy/brush_propx;}
 if(rasterpunkt!=0) rarund_d(x,y,rasterpunkt<<1,&bru_dx,&bru_dy);
 else	{bru_dx=x; bru_dy=y;}
}

void rarund(int x,int y,int n,int *zx,int *zy)
{
 double xwert,ywert;
 invtransform(&xwert,&ywert,XWERT(x),YWERT(y));
 if(xwert>=0.0) xwert=((int)((xwert+(n>>1))/n))*n;
 else xwert=((int)((xwert-(n>>1))/n))*n;
 if(ywert>=0.0) ywert=((int)((ywert+(n>>1))/n))*n;
 else ywert=((int)((ywert-(n>>1))/n))*n;
 normtransform(&xwert,&ywert,xwert,ywert);
 *zx=idfix(INVXWERT(xwert));
 *zy=idfix(INVYWERT(ywert));
 return;
}

void rarund_d(int x,int y,int n,int *zx,int *zy)
{
 double xwert,ywert,hx,hy;
 if(hochformat) {ywert=y; xwert=x;}
 else {ywert=x; xwert=x2fenster-y;}
 invtransform(&xwert,&ywert,xwert,ywert);
 if(xwert>=0.0) xwert=((int)(xwert+(n>>1))/n)*n;
 else xwert=((int)(xwert-(n>>1))/n)*n;
 if(ywert>=0.0) ywert=((int)(ywert+(n>>1))/n)*n;
 else ywert=((int)(ywert-(n>>1))/n)*n;
 normtransform(&xwert,&ywert,xwert,ywert);
 if(hochformat) {*zx=idfix(xwert); *zy=idfix(ywert);}
 else {*zx=idfix(ywert); *zy=idfix(x2fenster-xwert);}
 return;
}

void klick_help(int knopf,int x,int y,int knopfnr)
				/* knopf: 1=gedrueckt 0=losgelassen  */
				/* knopfnr: 1=links 2=mitte 3=rechts */
{
 int ddx,ddy,ddx2,ddy2,symbolnr=0,n;
 char antw[8];
 if(x<RAND && GEDRUEKT) /* im Symbolbereich Mausknopf gedrueckt */
	{if(y<(31-9)*YDPIC+MBH)
		{symbolnr=((y-MBH)/YDPIC)*2+x/XDPIC,knopfnr;
		 if(symbolnr==28 && knopfnr>=2)
			{symbolauswahl(symbolnr,knopfnr); return;}
		}
	 if(n=fadenkreuz_flag) fadenkreuz_aus();
	 lower_window();
	 if(y<(31-9)*YDPIC+MBH)
		{symbolnr=((y-MBH)/YDPIC)*2+x/XDPIC,knopfnr;
		 help_print(symbolnr,knopfnr);
		}
	 else if(y>(31-8)*YDPIC+MBH && y<31*YDPIC+MBH)
		{/* Grauwerte */
		 help_print(50,knopfnr);
		}
	 else if(y<=(31-8)*YDPIC+MBH)
		{/* akt.Farbe (Grauwert) */
		 help_print(60,knopfnr);
		}
	 else	{/* inaktiver Bereich */
		 help_print(70,knopfnr);
		}
/*	 printf("weiter mit RETURN");
/*	 for(deltazeit(1);deltazeit(0)<500;) /* mindestens 1/2 sek warten */
/*		getline(stdin,antw,8);       /* bevor Antwort akzeptieren */
	 if(sprache==DEUTSCH) requester("Hilfetext auf DECterm","weiter",NULL);
	 else requester("Helptext on DECterm window"," ok ",NULL);
	 printf("\n");
	 raise_window();
	 if(n) fadenkreuz_ein();
/*       if(help_flag==1) /* geht hier nicht wegen noetigem Refresh	*/
/* X11PROBLEM		     dies ist ein XWindows-Problem		*/
/*		{millipause(500); symbolauswahl(28,knopfnr);}		*/
	}
 return;
}

char *vhelpname1="VECTMALHELP:vectmal_deu.help";
char *vhelpname2="VECTMALHELP:vectmal_eng.help";

void help_print(int nr,int knopfnr)
{
 FILE *fp;
 int c=0,n;
 char str[80],*vh;
 if(sprache==DEUTSCH) vh=vhelpname1; else vh=vhelpname2;
 if((fp=fopen1(vh,"r"))==NULL)
	{ printf("'%s' not found\n",vh);
	  if((fp=fopen1(vhelpname1,"r"))==NULL) return; }
 while(c!=EOF)
  {while((c=getc(fp))!=EOF && c!='\n')  ;/* naechster Zeilentrenner */
   while((c=getc(fp))=='\n')  ;/* naechstes Zeichen, das kein Zeilentrenner */
   if(isdigit(c)) {ungetc(c,fp); fscanf(fp,"%d",&n);} else n= -1;
   if(n==nr)
	{while((c=getc(fp))=='\n')  ;/* Leerzeilen ueberlesen */
	 while(isdigit(c)) {getline(fp,str,80); c=getc(fp);}
	 ungetc(c,fp);
	 printf("\n\n");
	 while(getline(fp,str,80) && *str!=0) printf("%s\n",str);
	 break;
	}
  }
 fclose(fp);
}

/*********** Programmteile die durch Menuauswahl erreicht werden ***********/
FILE *fptemp=NULL;
int	fptemp_nlines=0,	/* Zaehler fuer Anzahl Zeilen in fptemp */
	undo_nline=0;

FILE *fopen2(char *name,char *modus)
{
 FILE *fp;
 if(!(fp=fopen1(name,modus)))
	{if(*modus=='r') printf("'%s' not found\n",name);
	 else  printf("Error opening '%s'\n",name);
	}
 return fp;
}

void file_save2(char *name)
{
 char oldname[ZL];
 strcpy(oldname,filename);
 strcpy(filename,name);
 file_save(-1);
 strcpy(filename,oldname);
}

void file_load2(char *name)
{
 char oldname[ZL];
 strcpy(oldname,filename);
 strcpy(filename,name);
 file_load(0);
 strcpy(filename,oldname);
}

void file_load(int rueckfrageflag)
{
 int n,bboxflag;
 FILE *fp;
 char erstezeile[ZL],boxstr[80];
 if(rueckfrageflag)
  {if(fadenkreuz_flag) fadenkreuz_aus();
   lower_window();
   if(fptemp && fptemp_nlines)
	if(requester((sprache==DEUTSCH)?"Aktuelles Bild wird gelscht."
			:"current picture will be cleared.",
			"OK","CANCEL")==0)
		{raise_window(); return;}
   printf((sprache==DEUTSCH)?"Datei laden.  Name:":"load file:");
   scanf("%s",filename); machps(filename);
  }
 savedflag=1;
 qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
 clear_bild();
 Fenstertitel(VECTMAL_WORKING);
 bboxflag=2; /*flag=0;*/
 if((fp=fopen1(filename,"r"))!=NULL)   /* BoundingBox suchen */
	{getline(fp,erstezeile,ZL);
	 if(argflag['B']==0 &&
	    (n=bbox_suchen(fp,"%%BoundingBox:",boxstr,80))>=1)
		{sscanf(boxstr,"%lf %lf %lf %lf",&xul,&yul,&xor,&yor);
		 if(xul==0. && yul==0. && xor==PSA4B && yor==PSA4H)
				{bboxflag=3; /*flag=1;*/}
		}
	 else	{xul=yul=0.; xor=PSA4B; yor=PSA4H;}
	 fclose(fp);
	}
 Delete(PROLOGNAME);
 if((fp=fopen1(filename,"r"))!=NULL)   /* Prolog suchen */
	{getline(fp,erstezeile,ZL);
	 getline(fp,erstezeile,ZL);
	 if(zeile_suchen(fp,"%%BeginProlog")>=1
	    && strncmp(erstezeile,"%%Creator: VectMal",18)==0)
	   {FILE *fp2;
	    fp2=fopen2(PROLOGNAME,"w");
	    while(getline(fp,erstezeile,ZL))
		{if(strncmp(erstezeile,"%%EndProlog",11)==0) break;
		 putline(fp2,erstezeile); prolog_flag=1;
		 check_defL(erstezeile);
		}
	    fclose(fp2);
	   }
	 fclose(fp);
	}
 /* postscript(filename,flag,bboxflag); */
 postscript(filename,1,bboxflag); /* test1 */
 term();
 lineattribute_uebernemen();
 Fenstertitel(VECTMAL_READY);
 return;
}

void file_loadbrush(int nr)
{
 char c1,c2,antw[8],boxstr[80];
 FILE *fp;
 int n;
 double zx,zy;
 if(fadenkreuz_flag) fadenkreuz_aus();
 lower_window();
 printf((sprache==DEUTSCH)?"Teilbild laden.  Name:":"Brush load.  name:");
 scanf("%s",brushfilename); machps(brushfilename);
 if(!(fp=fopen2(brushfilename,"r")))
   {printf("'%s' not found\n",brushfilename); raise_window(); return;}
 c1=getc(fp); c2=getc(fp);
 if(c1=='%' && c2=='!') printf("... lade EPS-Datei\n");
 if((n=bbox_suchen(fp,"%%BoundingBox:",boxstr,80))>=1)
	{sscanf(boxstr,"%lf %lf %lf %lf",&xul,&yul,&xor,&yor);
	 DEBUG(1,printf("BoundingBox:%lf %lf %lf %lf  Knopfnr=%d\n",
			xul,yul,xor,yor,nr));/* test */
	 if(nr==3) { deltatransform(&zx,&zy,xor-xul,yor-yul);
		     DEBUG(1,printf("zx=%lf zy=%lf\n",zx,zy));/* test */
		     brush_dx=idfix(zx);  brush_dy=idfix(zy); }
	}
 else	{xul=yul=0; xor=PSA4B; yor=PSA4H;}
 if(xor==xul || yor==yul)
   {printf("unmoegliche BoundingBox:%lf %lf %lf %lf\n",xul,yul,xor,yor);
    printf("Voreinstellungen verwendet:%lf %lf %lf %lf\n",
		xul=0,yul=0, xor=PSA4B, yor=PSA4H);
   }
 fclose(fp);
 if(requester((sprache==DEUTSCH)?"Proportionen beibehalten ?"
		:"keep proportions ?",JAYES,NEINNO))
	{brush_propx=idfix(xor-xul); brush_propy=idfix(yor-yul);
	 brush_propflag=(brush_propx>0 && brush_propy>0);
	}
 else brush_propflag=0;
 raise_window();
 if(brush_dx==0)
	{brush_winkel=0; brush_dx=200;
	 brush_dy=(int)(brush_dx*(yor-yul)/(xor-xul)+0.5);
	}
 setbru_dxdy(brush_dx,brush_dy); bru_winkel=brush_winkel;
 bru_winkel_neu=1;
 if(brushpreview>0) machbrushbild(brushfilename,brushpreview);
 fadenkreuz_typ=BRUSH; fadenkreuz_ein();
}
void machbrushbild(char *brushfilename,int methode)
{
 FILE *fp;
 char str[80];
 int n,breite,breite8,hoehe,tiefe,nlines;
 entfernepixelbild();
 switch(methode)
  {case 1: case 3:
	  fp=fopen2(brushfilename,"r");
	  if((n=preview_suchen(fp,"%%BeginPreview:"))>=1)
		{UBYTE *data,*s;
		 int i,j;
		 fscanf(fp,"%d %d %d %d",&breite,&hoehe,&tiefe,&nlines);
		 breite8=(breite+7)/8;
		// if((data=(UBYTE *)calloc(breite8*hoehe*tiefe,1))==NULL)
		 if((data=new UBYTE[breite8*hoehe*tiefe])==NULL)
			{printf("zu wenig Speicher\n"); fclose(fp); return;}
		 for(s=data,j=hoehe; --j>=0;)
		  for(i=0,s= &data[j*breite8]; i<breite8; i++)
			*s++ = hexbytelesen(fp);
		 machpixelbild(data,breite,hoehe,tiefe);
		 pixelbild_oldlupefaktor=1000;
		 delete data;
		}
	  else if(methode==3)
		{fclose(fp); fp=NULL; brush2pixelbild(brushfilename);}
	  else printf("kein %%%%BeginPreview vorhanden\n");
	  if(fp) fclose(fp);
   CASE 2:brush2pixelbild(brushfilename);
   DEFAULT: printf("unbekannte Methode %d in machbrushbild()\n",methode);
  }
}

int hexbytelesen(FILE *fp)
{
 int c,c2,n;
 while((c=getc(fp))!=EOF && !isxdigit(c))  ;
 while((c2=getc(fp))!=EOF && !isxdigit(c2))  ;
 n = (ascitodigit(c)<<4) + ascitodigit(c2);
 return n;
}

FILE *fopen2w(char *filename,int flag)
{
 FILE *fp;
 do
  {if(flag) scanf("%s",filename); else flag=1;
   machps(filename);
   if((fp=fopen1(filename,"r"))!=NULL)
	{printf((sprache==DEUTSCH)?"'%s' schon vorhanden":"'%s' already exists",
		filename); fclose(fp); fp=NULL;}
   else if((fp=fopen1(filename,"w"))==NULL)
	{printf((sprache==DEUTSCH)?"kann '%s' nicht oeffnen":"cant find '%s'",
		filename);}
   if(fp==NULL) printf((sprache==DEUTSCH)?"!  anderer Name:\n":"!  new name:");
  }
 while(fp==NULL);
 return fp;
}

extern uint pix_breite,pix_hoehe,pixtiefe;
extern UBYTE *pixelbild_data,*pixdata;
//extern UBYTE invers[];

void file_savebrush()
{
 FILE *fp,*fp1;
 char zeile[ZL];
 double x1,y1,x2,y2;
 int n;
 if(n=fadenkreuz_flag) fadenkreuz_aus();
 if((fp1=fopen1(TEMPBRUSHNAME,"r"))==NULL &&
    *brushfilename!=0 && (fp1=fopen1(brushfilename,"r"))==NULL)
	{requester((sprache==DEUTSCH)?"Bitte zuerst etwas AUSSCHNEIDEN !"
			:"first cutting something","ok",NULL); return;}
 lower_window();
 printf((sprache==DEUTSCH)?"TeilBild speichern.  Name:":"saving brush.  name:");
 fp=fopen2w(brushfilename,1);
 if(pixelbild_ok() &&
    requester((sprache==DEUTSCH)?"PreviewBild mit abspeichern ?"
		:"save with included previewpicture ?",JAYES,NEINNO))
  {int i,j;
   UBYTE *data=pixelbild_data;
   while(getline(fp1,zeile,ZL))
	{if(*zeile!='%' || strncmp(zeile,"%Objektbox",10)==0) break;
	 fprintf(fp,"%s\n",zeile);
	}
   fprintf(fp,"%%%%BeginPreview: %d %d %d %d\n",
		pix_breite,pix_hoehe,pixtiefe,pix_hoehe);
   for(i=0;i<pix_hoehe;i++)
	{fprintf(fp,"%%");
	 for(j=0;j<pix_breite;j+=8)
//#ifdef VAX  Problem nach vectmal_hard.cc verlagert
//		fprintf(fp,"%02X",invers[*data++]);
//#else
//		fprintf(fp,"%02X",*data++);
//#endif
		fprintf(fp,"%02X",event_invers(*data++));
	 fprintf(fp,"\n");
	}
   fprintf(fp,"%%%%EndPreview\n");
   if(zeile[0]=='#') einfuegen(fp,&zeile[1]);
   else fprintf(fp,"%s\n",zeile);
  }
 while(getline(fp1,zeile,ZL))
	{if(zeile[0]=='#') einfuegen(fp,&zeile[1]);
	 else fprintf(fp,"%s\n",zeile);
	}
 fclose(fp); fclose(fp1);
 raise_window();
 if(n) fadenkreuz_ein();
}

void file_save(int frageflag)
{
 FILE *fp,*fp2;
 char zeile1[ZL],zeile[ZL];
 int proflag=prolog_flag?2:0,proflag2;
 if(frageflag>=0) lower_window();
 if(fptemp) fclose(fptemp);
 fptemp=fopen1(BILDNAME,"r");
 if(fptemp==NULL) {printf("'%s' not found!\n",BILDNAME); return;}
 if(frageflag>0) {printf((sprache==DEUTSCH)?"Bild speichern.  Name:"
			 :"saving picture.  name:");
		  fp=fopen2w(filename,1);
		 }
 else if(frageflag<0) fp=fopen2(filename,"w");
 else fp=fopen2w(filename,0);
 getline(fptemp,zeile1,ZL);
 getline(fptemp,zeile,ZL);
 fprintf(fp,"%%!PS-Adobe-2.0 EPSF-1.2\n");
 fprintf(fp,"%%%%Creator: VectMal %s\n",REVISION);
 if(newbboxflag) fprintf(fp,"%%%%BoundingBox: %lg %lg %lg %lg\n",
				newbboxx1,newbboxy1,newbboxx2,newbboxy2);
 else fprintf(fp,"%%%%BoundingBox: 0 0 %d %d\n",PSA4B,PSA4H);
 if(proflag) {prolog_einfuegen(fp); proflag=1;}
 if((proflag2=strncmp(zeile1,"%%BeginProlog",13))!=0)
	fprintf(fp,"%s\n",zeile1);
 do
	{if(proflag && (*zeile!='%' || strncmp(zeile,"%%BeginProlog",13)==0))
		{if(proflag>1) prolog_einfuegen(fp);
		 if(*zeile=='%' || proflag2==0)
			{while(getline(fptemp,zeile,ZL)
			      && strncmp(zeile,"%%EndProlog",11)!=0) ;
			 getline(fptemp,zeile,ZL);
			}
		 proflag=0;
		}
	 if(*zeile=='#') einfuegen(fp,&zeile[1]);
	 else fprintf(fp,"%s\n",zeile);
	}
 while(getline(fptemp,zeile,ZL));
 fclose(fp);
 savedflag=1;
 fclose(fptemp); fptemp=fopen1(BILDNAME,"a");
 if(frageflag>=0) raise_window();
 return;
}

void einfuegen(FILE *fp,char *name)
{
 FILE *fp2;
 int c;
 char str[120];
 if((fp2=fopen2(name,"r"))==NULL) return;
 while(getline(fp2,str,120))
	{if(*str!='%') fprintf(fp,"%s\n",str);}
 fclose(fp2);
}

void einfuegen_fptemp(char *name,int bboxflag)
{
 FILE *fp2;
 int c;
 char str[120];
 if((fp2=fopen2(name,"r"))==NULL) return;
 if(bboxflag==3)
   while(getline(fp2,str,120))
	{if(*str!='%' || strncmp(&str[1],"Objekt",6)==0
		|| strncmp(&str[1],"%BeginProlog",12)==0 /* um Prolog nicht */
		|| strncmp(&str[1],"%EndProlog",10)==0   /* zu berlesen    */
	   )
		{fprintf(fptemp,"%s\n",str); fptemp_nlines++;}
	}
 else if(bboxflag==1)
   while(getline(fp2,str,120))
	{if(*str!='%')  {fprintf(fptemp,"%s\n",str); fptemp_nlines++;}
	}
 else
   while((c=getc(fp2))!=EOF) {putc(c,fptemp); if(c=='\n') fptemp_nlines++;}
 fclose(fp2);
}

void format_setzen(int br,int ho,int flag)
{
 double x0;
 double e=1.0;
 int i,n=0;
 FILE *fp1,*fp2;
 static int firstflag=1; //beim ersten Durchlauf A4HB...A4QH anpassen.
 if(br==A4Q11B) firstflag=0;
 if(firstflag)
   {int qbr,qho,qti,qvk;
    firstflag=0;
    getmaxsize(&qbr,&qho,&qti,&qvk);
    if(br<ho)
      //{br=br*qho/ho; ho=qho; A4HB=br; A4HH=ho;}
      {br=qho*1000/1414+1; ho=qho; A4HB=br; A4HH=ho;}
    else
      {br=qho*1414/1000; ho=qho;
       if(br+RAND>qbr)	{br=qbr-RAND; ho=br*1000/1414;}
       A4QB=br; A4QH=ho;
      }
   } //A4HB...A4QH angepasst.
 if(flag)
	{if(n=fadenkreuz_flag) fadenkreuz_aus();
	 clear_bild();
	}
 if(tekplot_gc)
	{qinital(1,x0fenster,y1fenster,x2fenster,y2fenster); qterm_exit();}
 x2fenster=x1fenster+br; y2fenster=y1fenster+ho;
 if(argflag['W']) setsize(br+RAND,ho,32000+debug*1000+8);
 else setsize(br+RAND,ho,debug*1000+8);
 x0fenster=x1fenster-RAND;
 qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
 term();
 farben_init();
 create_auswahlfenster();
 fadenkreuz_init();
 screenclear();
 for(i=0;i<6;i++) ctminit[i]=0.;
 if(ho>=br)	{e=(br/PSA4Bd+ho/PSA4Hd)/2.0;
		 ctminit[0]=e;  ctminit[3]=e;
		 hochformat=1;
		}
 else		{e=(ho/PSA4Bd+br/PSA4Hd)/2.0;
		 ctminit[1]=e; ctminit[2]= -e; ctminit[4]=x2fenster-1;
		 hochformat=0;
		}
 for(i=0;i<6;i++) ctminit0[i]=ctminit[i];
 postscript_init();
 if(flag) undo();
 if(n) fadenkreuz_ein();
 return;
}

void undo()
{
 FILE *fp1,*fp2,*fp3;
 int i,n;
 if(n=fadenkreuz_flag) fadenkreuz_aus();
 if(undo_nline==fptemp_nlines) printf("UNDO Buffer empty\n");
 else if(undo_nline== -1)  /* UNDONAME2 nachladen */
  {clear_bild();
   qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
   undo_nline=fptemp_nlines;
   postscript(UNDONAME2,1,0);
   term();
   Delete(UNDONAME2);
  }
 else if(undo_nline<fptemp_nlines)
  {DEBUG(1,printf("undo - letzter Befehl zurueck undo_n=%d fptemp_n=%d\n",
				undo_nline,fptemp_nlines));
   if(fptemp) {fclose(fptemp); fptemp=NULL;}
   if(debug) {printf("Inhalt von BILDNAME:\n"); ausdrucken(BILDNAME);}
   if((fp1=fopen2(BILDNAME,"r"))==NULL) return;
   if((fp2=fopen2(HILFSNAME,"w"))==NULL) {fclose(fp1); return;}
   Delete(UNDONAME);
   if((fp3=fopen2(UNDONAME,"w"))==NULL) {fclose(fp1); fclose(fp2); return;}
   /* Inhalt von BILDNAME in HILFSNAME und UNDONAME umkopieren */
   for(i=0;i<undo_nline;i++)  zeilekopieren(fp1,fp2);
   fclose(fp2);
   for(;i<fptemp_nlines;i++)  zeilekopieren(fp1,fp3);
   fclose(fp3); fclose(fp1);
   if(debug) {printf("Inhalt von HILFSNAME:\n"); ausdrucken(HILFSNAME);
   	      printf("Inhalt von UNDONAME:\n"); ausdrucken(UNDONAME);}
   screenclear();
   qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
   postscript_init();
   postscript(HILFSNAME,1,0);
   term();
   undo_nline=fptemp_nlines+1;
   Delete(HILFSNAME);
  }
 else /* UNDONAME nachladen */
  {qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
   undo_nline=fptemp_nlines;
   postscript(UNDONAME,1,0);
   term();
   Delete(UNDONAME);
  }
 lineattribute_uebernemen();
 if(n) fadenkreuz_ein();
}

/**** dies waere die optimale Variante, geht aber auf der VAX nicht ****
filecopy(char *von,char *nach)
{
 int fd1,fd2,n,n2;
 static char s[1024];
 fd1=open(von,O_RDONLY,0);
 if(fd1<=0) {printf("open:'%s' not found\n",von); return 1;}
 fd2=open(nach,O_CREAT,0); /* oder O_WRONLY O_CREAT O_TRUNC *
 if(fd2<=0)
	{printf("kann '%s' nicht oeffnen\n",nach); close(fd1); return 1;}
 while((n=read(fd1,s,1024))>0)
	{if((n2=write(fd2,s,n))!=n) break;}
 if(n!=0) {printf("Fehler in filecopy n=%d n2=%d\n",n,n2);}
 close(fd1); close(fd2);
 return n;
}
**** dies waere die optimale Variante, geht aber auf der VAX nicht ****/

int filecopy(char *von,char *nach)
{
 FILE *fp1,*fp2;
 int c,n,k=0;
 if((fp1=fopen1(von,"r"))==NULL) {printf("'%s' not found\n",von); return 1;}
 if((fp2=fopen1(nach,"w"))==NULL)
	{printf("kann '%s' nicht oeffnen\n",nach); fclose(fp1); return 1;}
 while((c=getc(fp1))!=EOF)
	if((n=putc(c,fp2))!=c)
		{printf("Fehler beim Speichern n=%d\n",n); k=1; break;}
 fclose(fp2); fclose(fp1);
 return k;
}

void zeilekopieren(FILE *fp1,FILE *fp2)
{
 char str[120];
 getzeile(fp1,str); fprintf(fp2,"%s",str);
}

void clear_bild()
{
 int n;
 if(n=fadenkreuz_flag) fadenkreuz_aus();
 restoreall();
 clearclipmask(gs.clipmask);
 screenclear();
 if(fptemp)
  {fclose(fptemp); fptemp=NULL;
   Delete(UNDONAME);
   rename(BILDNAME,UNDONAME);
   undo_nline=fptemp_nlines+1;
   postscript_init();
  }
 if(n) fadenkreuz_ein();
}

void resetgadgets()
{
 int i;
 if(fadenkreuz_flag) fadenkreuz_aus();
 schalter_aus(0); werkzeug=0;
 schalter_aus(1);
 symbolauswahl(schalter_status[2]=15,0); /* Liniendicke */
 symbolauswahl(schalter_status[3]=27,0); /* Strichelung */
 for(i=4;i<6;i++) if(schalter_status[i]) symbolauswahl(schalter_status[i],0);
 aktuelle_farbnummer_anzeigen(gs.farbnummer=1);
 farbe_setzen(gs.farbnummer);
}

void lineattribute_uebernemen()
{
 symbolauswahl(schalter_status[2],0); /* Liniendicke */
 symbolauswahl(schalter_status[3],0); /* Strichelung */
 gs.farbnummer=(grauschalter_y0-YFARB0)/YDPIC+paletnr;
 aktuelle_farbnummer_anzeigen(gs.farbnummer);
}

void bildrefresh()
{
 int n;
 if(!fptemp) return;
 if(n=fadenkreuz_flag) fadenkreuz_aus();
 if(RUECKFLAG) lineattribute_ruecksetzen();
 restoreall();
 clearclipmask(gs.clipmask);
 screenclear();
 fclose(fptemp); fptemp=NULL;
 rename(BILDNAME,REFRESHNAME);
 postscript_init();
 qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
 postscript(REFRESHNAME,1,0);
 term();
 Delete(REFRESHNAME);
 lineattribute_uebernemen();
 if(n) fadenkreuz_ein();
}

void bildsichern(int knopfnr)
{
 int n,fe;
 if(n=fadenkreuz_flag) fadenkreuz_aus();
 if(knopfnr==3)
	{clear_bild();
	 rename(UNDONAME,UNDONAME2);
	 qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
	 postscript(SICHERNAME,1,0);
	 term();
	 lineattribute_uebernemen();
	 undo_nline= -1;
	}
 else if(fptemp)
	{fclose(fptemp); fe=filecopy(BILDNAME,SICHERNAME);
	 if(fe!=0) printf("Fehler beim kopieren von '%s' nach '%s' f=%d\n",
					BILDNAME,SICHERNAME,fe);
	 fptemp=fopen1(BILDNAME,"a");
	 lower_window();
	 printf((sprache==DEUTSCH)?"Bild gesichert: '%s'\n":
		"picture saved: '%s'\n",SICHERNAME);
	 raise_window();
	}
 if(n) fadenkreuz_ein();
}

double ideltatransru(double z)
{
 double x,y;
 ideltatransform(&x,&y,z,z);
/* x=sqrt(x*x+y*y)/WURZEL2; */
 x=fabs(x);
 if(rasterpunkt!=0) x=doubrund(x,(double)rasterpunkt);
 return x;
}


/********************** Voreinstellungen ************************/
#define PF printf
#define FPF fprintf
#define FSF fscanf
static int schalter_status_neu[XSCHALTER];
static int rasterpunkt_neu;

void einstellungen_zeigen()
{
 int i;
 PF("rasterpunkt=%d  raster1=%d  raster2=%d\n",rasterpunkt,raster1,raster2);
 PF("  vorhandene Schalter:\n");
 PF("  {Verformung Werkzeug Liniendicke Strichelung Zentrierung Raster Help}\n");
 PF("schalter_status[]={%d",schalter_status[0]);
 for(i=1;i<XSCHALTER;i++) PF(",%d",schalter_status[i]);
 PF("}\n");
 PF("\n  Variablen in Bildschirmkoordinaten:\n");
 PF("brush_dx=%d  brush_dy=%d  brush_winkel=%d\n",
		brush_dx,brush_dy,brush_winkel);
 PF("leim_dx=%d  leim_dy=%d  leim_winkel=%d\n",leim_dx,leim_dy,leim_winkel);
 PF("buchst_dx=%d  buchst_dy=%d  buchst_winkel=%d\n",
		buchst_dx,buchst_dy,buchst_winkel);
 PF("viereck_dx=%d  viereck_dy=%d  viereck_winkel=%d\n",
		viereck_dx,viereck_dy,viereck_winkel);
 PF("kreis_radius=%d  ellipseflag=%d  ellipsefakt=%lf\n",
		kreis_radius,ellipseflag,ellipsefakt);
 PF("  weitere Variablen:\n");
 PF("rotation_modus=%d  rotation_step=%d\n",rotation_modus,rotation_step);
 PF("linien_step=%d\n",linien_step);
 PF("vergroessern_modus=%d  vergroessern_step=%d\n",
		vergroessern_modus,vergroessern_step);
 PF("zentrieren_flag=%d  zentriermitte=%lf\n",
		zentrieren_flag,zentriermitte);
 PF("pfeil_fill=%d  pfeil_a2=%lf  pfeil_a3=%lf\n",
		pfeil_fill,pfeil_a2,pfeil_a3);
 PF("pfeil_periode=%d  pfeil_amplitude=%lf\n",pfeil_periode,pfeil_amplitude);
 PF("doppel_a2=%lf\n",doppel_a2);
 PF("lupe_dx=%d  lupe_dy=%d\n",lupe_dx,lupe_dy);
 PF("menu_brushdar=%d\n",brushpreview);
 PF("sprache=%d\n",sprache);
}

void einstellungen_speichern()
{
 int i,tmp;
 FILE *fp;
 fp=fopen1(EINSTNAME,"w"); if(fp==NULL) return;
 FPF(fp,"rasterpunkt= %d raster1= %d raster2= %d\n",rasterpunkt,raster1,raster2);
 FPF(fp,"schalter_status[]= {%d",schalter_status[0]);
 tmp=schalter_status[1];
 if(tmp==3 || tmp==6 || tmp==2)	/* Wenn Txt,Brush oder Leim als Werkzeug */
	schalter_status[1]=8;	/* dann ersetzen durch Linie	    */
 for(i=1;i<XSCHALTER;i++) FPF(fp,",%d",schalter_status[i]);
 schalter_status[1]=tmp;
 FPF(fp,"}\n");
 FPF(fp,"brush_dx= %d  brush_dy= %d  brush_winkel= %d\n",
		brush_dx,brush_dy,brush_winkel);
 FPF(fp,"leim_dx= %d  leim_dy= %d  leim_winkel= %d\n",leim_dx,leim_dy,leim_winkel);
 FPF(fp,"buchst_dx= %d  buchst_dy= %d  buchst_winkel= %d\n",
		buchst_dx,buchst_dy,buchst_winkel);
 FPF(fp,"viereck_dx= %d  viereck_dy= %d  viereck_winkel= %d\n",
		viereck_dx,viereck_dy,viereck_winkel);
 FPF(fp,"kreis_radius= %d  ellipseflag= %d  ellipsefakt= %lf\n",
		kreis_radius,ellipseflag,ellipsefakt);
 FPF(fp,"rotation_modus= %d  rotation_step= %d\n",rotation_modus,rotation_step);
 FPF(fp,"linien_step= %d\n",linien_step);
 FPF(fp,"vergroessern_modus= %d  vergroessern_step= %d\n",
		vergroessern_modus,vergroessern_step);
 FPF(fp,"zentrieren_flag= %d  zentriermitte= %lf\n",
		zentrieren_flag,zentriermitte);
 FPF(fp,"pfeil_fill= %d  pfeil_a2= %lf  pfeil_a3= %lf\n",
		pfeil_fill,pfeil_a2,pfeil_a3);
 FPF(fp,"doppel_a2= %lf\n",doppel_a2);
 FPF(fp,"lupe_dx= %d  lupe_dy= %d\n",lupe_dx,lupe_dy);
 FPF(fp,"menu_brushdar= %d\n",brushpreview);
 FPF(fp,"sprache= %d\n",sprache);
 fclose(fp);
 return;
}

int getc_alpha(FILE *fp)
{
 int c;
 while((c=getc(fp))!=EOF && c<'A')  ;
 return c;
}

void einstellungen_nachladen(char *einstname)
{
 int i,c;
 FILE *fp;
 char kw[80];
 fp=fopen1(einstname,"r"); if(fp==NULL) return;
 while((c=getc_alpha(fp))!=EOF)
  {ungetc(c,fp);
   FSF(fp,"%s",kw); if((c=INDEX(kw,"="))>=0) kw[c]=0;
   if(strcmp(kw,"brush_dx")==0) FSF(fp,"%d",&brush_dx);
   else if(strcmp(kw,"brush_dy")==0) FSF(fp,"%d",&brush_dy);
   else if(strcmp(kw,"brush_winkel")==0) FSF(fp,"%d",&brush_winkel);
   else if(strcmp(kw,"leim_dx")==0) FSF(fp,"%d",&leim_dx);
   else if(strcmp(kw,"leim_dy")==0) FSF(fp,"%d",&leim_dy);
   else if(strcmp(kw,"leim_winkel")==0) FSF(fp,"%d",&leim_winkel);
   else if(strcmp(kw,"buchst_dx")==0) FSF(fp,"%d",&buchst_dx);
   else if(strcmp(kw,"buchst_dy")==0) FSF(fp,"%d",&buchst_dy);
   else if(strcmp(kw,"buchst_winkel")==0) FSF(fp,"%d",&buchst_winkel);
   else if(strcmp(kw,"viereck_dx")==0) FSF(fp,"%d",&viereck_dx);
   else if(strcmp(kw,"viereck_dy")==0) FSF(fp,"%d",&viereck_dy);
   else if(strcmp(kw,"viereck_winkel")==0) FSF(fp,"%d",&viereck_winkel);
   else if(strcmp(kw,"kreis_radius")==0) FSF(fp,"%d",&kreis_radius);
   else if(strcmp(kw,"ellipseflag")==0) FSF(fp,"%d",&ellipseflag);
   else if(strcmp(kw,"ellipsefakt")==0) FSF(fp,"%lf",&ellipsefakt);
   else if(strcmp(kw,"rotation_modus")==0) FSF(fp,"%d",&rotation_modus);
   else if(strcmp(kw,"rotation_step")==0) FSF(fp,"%d",&rotation_step);
   else if(strcmp(kw,"linien_step")==0) FSF(fp,"%d",&linien_step);
   else if(strcmp(kw,"vergroessern_modus")==0) FSF(fp,"%d",&vergroessern_modus);
   else if(strcmp(kw,"vergroessern_step")==0) FSF(fp,"%d",&vergroessern_step);
   else if(strcmp(kw,"rasterpunkt")==0) FSF(fp,"%d",&rasterpunkt_neu);
   else if(strcmp(kw,"raster1")==0) FSF(fp,"%d",&raster1);
   else if(strcmp(kw,"raster2")==0) FSF(fp,"%d",&raster2);
   else if(strcmp(kw,"zentrieren_flag")==0) FSF(fp,"%d",&zentrieren_flag);
   else if(strcmp(kw,"zentriermitte")==0) FSF(fp,"%lf",&zentriermitte);
   else if(strcmp(kw,"pfeil_fill")==0) FSF(fp,"%d",&pfeil_fill);
   else if(strcmp(kw,"pfeil_a2")==0) FSF(fp,"%lf",&pfeil_a2);
   else if(strcmp(kw,"pfeil_a3")==0) FSF(fp,"%lf",&pfeil_a3);
   else if(strcmp(kw,"pfeil_amplitude")==0) FSF(fp,"%lf",&pfeil_amplitude);
   else if(strcmp(kw,"pfeil_periode")==0) FSF(fp,"%lf",&pfeil_periode);
   else if(strcmp(kw,"doppel_a2")==0) FSF(fp,"%lf",&doppel_a2);
   else if(strcmp(kw,"lupe_dx")==0) FSF(fp,"%d",&lupe_dx);
   else if(strcmp(kw,"lupe_dy")==0) FSF(fp,"%d",&lupe_dy);
   else if(strcmp(kw,"schalter_status[]")==0)
	{while((c=getc(fp))!=EOF && c!='{')  ;/* { berlesen */
	 for(i=0; (c=getc(fp))!=EOF && c!='}' && i<XSCHALTER; i++)
		{if(c!=',') ungetc(c,fp);
		 FSF(fp,"%d",&schalter_status_neu[i]);
		}
	 neuer_schalter_status();
	}
   else if(strcmp(kw,"menu_brushdar")==0)
	 {FSF(fp,"%d",&brushpreview); brushdar_umschalten(0,brushpreview);}
   else if(strcmp(kw,"sprache")==0) FSF(fp,"%d",&sprache);
   else printf("'%s' enthlt unbekanntes Schlsselwort:'%s'\n",EINSTNAME,kw);
  }
 fclose(fp);
 return;
}

void einstellungen_sprache_nachladen(char *einstname)
{
 int c;
 FILE *fp;
 char kw[80];
 fp=fopen1(einstname,"r"); if(fp==NULL) return;
 while((c=getc_alpha(fp))!=EOF)
  {ungetc(c,fp);
   FSF(fp,"%s",kw); if((c=INDEX(kw,"="))>=0) kw[c]=0;
   if(strcmp(kw,"sprache")==0) FSF(fp,"%d",&sprache);
  }
 fclose(fp);
 return;
}

void neuer_schalter_status()
{
 int i;
 for(i=0;i<XSCHALTER;i++)
  if(schalter_status[i] != schalter_status_neu[i])
	switch(i)
	 {case 0: case 1: case 2: case 3:
		symbolauswahl(schalter_status_neu[i],1);
	  CASE 4:symbolauswahl(31,1);/* Zentrieren */
	  CASE 5:symbolauswahl(34,rasterpunkt_neu==raster2?2:1);/* Zentrieren */
/*	  CASE 6:/* Help nicht verstellen */
	 }
}

void einstellungen_reset()
{
 int i;
 rasterpunkt=0; raster1=5; raster2=20;
 for(i=0;i<XSCHALTER;i++) schalter_status_neu[i]=0;
 schalter_status_neu[1]=8;
 schalter_status_neu[2]=15;
 schalter_status_neu[3]=27;
 neuer_schalter_status();
 brush_dx=0; brush_dy=0; brush_winkel=0;
 leim_dx=0; leim_dy=0; leim_winkel=0;
 buchst_dx=20; buchst_dy=30; buchst_winkel=0;
 viereck_dx=40; viereck_dy=40; viereck_winkel=0;
 kreis_radius=40; ellipseflag=0; ellipsefakt=1.0;
 rotation_modus=1; rotation_step=5;
 linien_step=0;
 vergroessern_modus=1; vergroessern_step=5;
 zentrieren_flag=0; zentriermitte=PSA4Bd/2.;
 pfeil_fill=1; pfeil_a2=1.5; pfeil_a3=2.5;
 pfeil_amplitude=0.; pfeil_periode=20.;
 doppel_a2=0.75;
 lupe_dx=150; lupe_dy=410;
}


/********************** Farben ************************/
void nextpalette()
{
 int i,y;
 gs.farbnummer+=8;
 if((paletnr+=8)>=MAXXFARB) {paletnr=0; gs.farbnummer &= 0x7;}
 aktuelle_farbnummer_anzeigen(gs.farbnummer);
 for(y=(31-8)*YDPIC+1,i=0; i<8; y+=YDPIC,i++)
	auswahl_rechteckfill(1,y,2*XDPIC-1,y+YDPIC-2,i+paletnr);/*i=Farbnummer*/
}

void rgb2cmyk(int *r,int *g,int *b,int *k)
{
 int ro,gr,bl;
 ro= *r; gr= *g; bl= *b;
 *r=255-ro; *g=255-gr; *b=255-bl;
 if(*r < *g) *k= *r; else *k= *g;
 if(*b < *k) *k= *b;
 *r -= *k; *g -= *k; *b -= *k;
 return;
}


/********************** Prolog-Unterprogs ************************/
void check_defL(char *str)
{
 if(!defLasymflag && index(str,"/Symfont")>=0) defLasymflag=1;
 else if(!defLaflag && index(str,"/Lashow")>=0) defLaflag=1;
 else if(!defLUmlautflag && index(str,"/machufont")>=0) defLUmlautflag=1;
 else if(!defSchraffierenflag && index(str,"/schraffieren")>=0)
		defSchraffierenflag=1;
 else if(!defEllipseflag && index(str,"/ellipse")>=0) defEllipseflag=1;
}

int zeile_suchen(FILE *fp,char *such)
{
 char zeile[ZL];
 int n,nz=strlen(such);
 for(n=1;getline(fp,zeile,ZL);n++)
	if(strncmp(zeile,such,nz)==0) return n;
 return 0;
}

void putline(FILE *fp,char *s)
{
 fprintf(fp,"%s\n",s);
}

void prolog_einfuegen(FILE *fp)
{
 char zeile[ZL];
 FILE *fp2=fopen2(PROLOGNAME,"r");
 fprintf(fp,"%%%%BeginProlog\n");
 while(getline(fp2,zeile,ZL)) putline(fp,zeile);
 fprintf(fp,"%%%%EndProlog\n");
 fclose(fp2);
}

/**************** Fuellmethode (Schraffierung) *******************/
void setfuellmethode(int n,int symbolnr)
{
 if(n!=0)	{schalter_ein(7,symbolnr);}
 else		{schalter_aus(7);}
 fuellmethode=n;
 auswahl_rechteckfill(2,36/2*YDPIC+2,XDPIC-2,(36/2+1)*YDPIC-2,SCHWARZ);
 if(n==FUELL_GRAU) n=0;
 else if(n>=FUELL_PUNKTIERT) n=4;
 zeichnepic(pic[36]=picfuell[n], 0, 36/2*YDPIC);
}


/********************** test ************************/
/**
void test_init()
{
 int i,j;
 for(i=0;i<6;i++) ctminit0[i]=ctminit[i]=0.;
 for(j=0;j<MAXLUP;j++)
  {lupe_faktor[j]=lup_xul[j]=lup_yul[j]=lup_xor[j]=lup_yor[j]=0.;
   for(i=0;i<6;i++) ctminit_tab[i][j]=0.;
  }
 for(i=0;i<6;i++) gs.ctm[i]=0.;
 gs.aktx=gs.akty=gs.flatness=gs.linewidth=gs.miterlimit=0.;
}
/**/
