/* vectmal.h		letzte Aenderung: 20.3.2005 */

/* Definition der Maschine sollte in makefile gemacht werden: */
//#define VAX
//#define unix
//#define AMIGA
//#define MACOSX

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <ulong.h>

#ifdef MACOSX
#define unix
#endif
#ifdef VAX
#define VAXORALPHA
#endif
#ifdef ALPHA
#define VAXORALPHA
#endif

#ifdef __cplusplus
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#include <X11/Xlib.h>

#include "vectmal_const.h"

/********************* Postscript-Interpreter ************************/
struct dictionary;
struct font
	{struct dictionary
		*dict;		/* Fontdictionary */
	 int	typ;		/* FontTyp */
	 double ctm[6];		/* Matrix fuer scalefont und makefont */
	};
struct pfad
	{double *anfang,	/* Zeiger auf erster Eintrag */
		*ende,		/* Zeiger auf naechsten freien Platz */
		*max;		/* Zeiger hinter letzten moeglichen Platz */
	};
struct stackeintrag
	{UWORD attr;	/* Attribute und Typ */
	 long a,b;	/* Wert oder Zeiger (je nach Typ) */
	};
struct graphicstate
	{struct graphicstate *next; /* Zeiger auf naechsten Eintrag */
	 short  aktflag,	/* aktueller Punkt */
		savemark;	/* Markierung fuer save  */
	 double aktx,akty,	/* aktueller Grafikpunkt */
		ctm[6],		/* Current Transformation Matrix */
		flatness,	/* Anpassungsgenauigkeit von Kurven */
		linewidth,	/* Liniendicke */
		miterlimit;	/* Spitzenmaximum bei Lininenverbindung */
	 UBYTE	r,g,b,pad;	/* Farbanteile: 255,255,255=weiss=Papierfarbe */
	 short	linecap,	/* Linienabschluss */
		linejoin,	/* Linienverbindung */
		farbnummer;	/* Farbe: 7=Schwarz=Stift 0=weiss=Papier */
				/*	  1...6  = Grauwerte		 */
				/*	  8...31 = Farben		 */
	 short	dashlen,	/* Anzahl gueltige Zahlen in dashfeld */
		dashoffset;	/* Offset fuer gestrichelte Linien */
#define MAXDASH 32
	 char	dashfeld[MAXDASH]; /* on/off Feld fuer gestrichelte Linien */
	 struct font *font;	   /* Aktueller Font */
	 struct stackeintrag
		transferfunc;	    /* Funktion fuer GrauwertUmsetzung */
	 Pixmap	clipmask;	    /* Identifier fuer Clip-Maske */
	 int	clipflag;	    /* Wenn gesetzt: clipmask neu seit gsave */
	 struct pfad path,	    /* Pfad */
		clippath;	    /* Clip-Pfad */
/* gscopy erwartet path,clippath als letzte Eintraege in der gs-Struktur */
	};

struct dicteintrag
	{ULONG key; struct stackeintrag wert;};

struct dictionary
	{struct dicteintrag *e;    /* Zeiger auf ersten Eintrag */
	 int	leng,		   /* Laenge des Dictionarys */
		i;		   /* Index des naechsten freien Eintrags */
	 short	flags,		   /* DICT_OPEN  DICT_SYSTEM */
		savemark;	   /* fuer save und restore */
	 char	*name;		   /* Dictionary-Name */
	 struct font *font;	   /* gueltig wenn Dictionary ein Font ist */
	};
typedef struct dictionary Dictionary;

struct Dictstackeintrag
	{struct Dictstackeintrag *next; /* Zeiger auf naechstes */
	 struct dictionary *dict;
	};
#define DICT_OPEN 1
#define DICT_SYSTEMDICT 2

struct vmeintrag
	{struct vmeintrag *next;
	 char	*mem;	  /* Zeiger auf benutzbaren Speicher */
	 int	savemark; /* Marke von 'save' fuer 'restore' */
	};
#define VMLENG sizeof(struct vmeintrag)
 
/* Fehlerflags: */
#define ERR_EOF		(-1)
#define STACKUNDER	(-2)
#define STACKOVER	(-3)
#define NOAKTPOINT	(-4)
#define WRONGTYPE	(-5)
#define MEMFULL		(-6)
#define SYNTAXERR	(-7)
#define MISSINGMARK	(-8)
#define DICTFULL	(-9)
#define TYPECHECK_MAX   (-10)
#define TYPECHECK_NOINT (-10)
#define TYPECHECK_NONAM (-11)
#define TYPECHECK_NOSTR	(-12)
#define TYPECHECK_NOFONT (-13)
#define TYPECHECK_NOARRAY (-14)
#define TYPECHECK_NOPROC (-15)
#define TYPECHECK_NONUM (-16)
#define TYPECHECK_NOBOOL (-17)
#define TYPECHECK_NOBOOLINT (-18)
#define TYPECHECK_NODICT (-19)
#define TYPECHECK_NOFILE (-20)
#define TYPECHECK_MIN   (-20)
#define KEYERROR	(-21)
#define UNDEFINED	(-22)
#define EXESTACKOVER	(-23)
#define STRZULANG	(-24)
#define LIMITCHECK	(-25)
#define NOPATH		(-26)
#define PATH_CORRUPT	(-27)
#define INVALIDEXIT	(-28)
#define FALSCHERWERT	(-29)
#define INVALIDFONT	(-30)
#define INVALIDRESTORE	(-31)
#define MIXEDBOOLINT	(-32)
#define RANGECHECK	(-33)
#define UNDEFINEDRESULT	(-34)
#define UNDEFINEDFILE	(-35)
#define INVALIDFONTTYPE	(-36)

/* Tokenwerte des Parsers: */
#define NUMBER		1
#define BEF_SYSPROC	2
#define BEF_USERPROC	3
#define BEF_EXIT	4
#define BEF_RET		5

/* Datentypen: (.attr)		/*	.a	.b	*/
#define TYP_NULL	15	/*	0	0	*/
#define TYP_INTEGER	1	/*	-	Zahl	*/
#define TYP_REAL	2	/*    doublezahl  High=.a Low=.b !! */
#define TYP_BOOLEAN	3	/*	-	1|0	*/
#define TYP_STRING	4	/* Z	laenge	Zeiger	*/
/* laenge=Anzahl gueltige Zeichen ohne abschliessendes Null */
/* ein Hexstring kann auch Null-Zeichen enthalten !!	    */
#define TYP_ARRAY	5	/* Z	laenge	Zeiger	*/
#define TYP_PROC	6	/* Z		Funktion */
#define TYP_SPROC	0x806	/* Z		Funktion */
#define TYP_NAME	7	/* Z	key	Name	*/
#define TYP_DICT	8	/* Z	max	Dictionary */
#define TYP_FONT	0x88	/* Z	max	Dictionary */
#define TYP_SAVE	10	/*	iopst	-	*/
#define TYP_FILE	11	/*	-	fp	*/
#define TYP_MARK	12	/*	-	-	*/
#define TYP_FONTID	13	/*	-	id	*/
#define TYP_OPERATOR	14	/* bisher nicht verwendet */
#define TYP_INT  TYP_INTEGER
#define TYP_STR  TYP_STRING
#define TYP_BOOL TYP_BOOLEAN

/* Attribute: */
#define TYPEMASK	0x007F
#define TYPEMASK2	0x00FF	/* Unterscheidung DICT-FONT */
#define TYPEMASK3	0x087F	/* Unterscheidung PROC-SPROC */
#define PROTECTMASK	0x0300
#define FONT		0x0080
#define READONLY	0x0100
#define EXECUTEONLY	0x0200
#define EXECUTABLE	0x0400
#define SYSPROC		0x0800
#define ZUSAMMENGESETZT	0x1000
#define ZUS		0x1000
#define RESERVED	0xE000
/* #define TYP_SYSPROC	TYP_PROC+ZUS+READONLY+EXECUTABLE+SYSPROC */
#define TYP_SYSPROC	0x1D06

#define EINFACH(x) ((x->attr & ZUSAMMENGESETZT)==0)
#define ISINT(x)   ((x->attr & TYPEMASK)==TYP_INTEGER)
#define ISREAL(x)  ((x->attr & TYPEMASK)==TYP_REAL)
#define ISBOOL(x)  ((x->attr & TYPEMASK)==TYP_BOOLEAN)
#define ISBOOLINT(x)  (ISBOOL(x) || ISINT(x))
#define ISSTRING(x) ((x->attr & TYPEMASK)==TYP_STRING)
#define ISNAME(x) (((x)->attr & TYPEMASK)==TYP_NAME)
#define IS_INT(att) ((att & TYPEMASK)==TYP_INTEGER)
#define IS_REAL(att) ((att & TYPEMASK)==TYP_REAL)
#define IS_BOOL(att) ((att & TYPEMASK)==TYP_BOOLEAN)
#define IS_STR(att) ((att & TYPEMASK)==TYP_STRING)
#define IS_BOOLINT(att)  (IS_BOOL(att) || IS_INT(att))
#define IS_ARRAY(att) ((att & TYPEMASK)==TYP_ARRAY)
#define IS_PROC(att) ((att & TYPEMASK)==TYP_PROC)
#define IS_NAME(att) ((att & TYPEMASK)==TYP_NAME)
#define IS_DICT(att) ((att & TYPEMASK)==TYP_DICT)
#define IS_FONT(att) ((att & TYPEMASK2)==TYP_FONT)
#define IS_FILE(att) ((att & TYPEMASK)==TYP_FILE)

#define intpush(n) push(TYP_INTEGER,0,n)
#define boolpush(n) push(TYP_BOOL,0,n)
#define VERTAUSCHE(a,b) {int h; h=a; a=b; b=h;}

typedef union {long n[2]; double d;} REAL;

/*** Stackdefinitionen: ***/
#define IOPSTMAX 500
#define IEXEMAX  500
#define SYSMAX 300
#define USERMAX 200
#define STATUSMAX 8
/*#define FONTDIRMAX 20*/
#define FONTDIRMAX 40
#define MAXPATH 1200
#define MAXPATH3 3600  /* ein Path-Element braucht durchschnittlich 3 Zahlen */

extern struct graphicstate gs;
/* Graphicstack wird ueber verkettete Listen realisiert. Start bei gs.next */
/* Die Matrixmultiplik. von [x y 1] mit der CTM ergibt die Geraetekoordinaten:
            [P  Q]
  [x y 1] * |R  S| = [x' y']
            [T  U]
*/
#define PP gs.ctm[0]
#define QQ gs.ctm[1]
#define RR gs.ctm[2]
#define SS gs.ctm[3]
#define TT gs.ctm[4]
#define UU gs.ctm[5]

#define MOVETO 1	/* Pfadelemente				 */
#define LINETO 2	/* es gibt nur diese vier		 */
#define CURVETO 4	/* Befehle wie z.B. 'rlineto' oder 'arc' */
#define CLOSEPATH 8	/* muessen umgerechnet werden.		 */

extern uint menubalkenhoehe;
#define MBH menubalkenhoehe
#ifdef VAXORALPHA
#define XWERT(x) (xmi+dx*(x))
#define YWERT(y) (yma-dy*((y)-menubalkenhoehe))
#define XWERTD(x) (dx*(x))
#define INVXWERT(x) (((x)-xmi)/dx)
#define INVYWERT(y) ((yma-(y))/dy+menubalkenhoehe)
#else
#define XWERT(x) (xmin+dx*(x))
#define YWERT(y) (ymax-dy*((y)-menubalkenhoehe))
#define XWERTD(x) (dx*(x))
#define INVXWERT(x) (((x)-xmin)/dx)
#define INVYWERT(y) ((ymax-(y))/dy+menubalkenhoehe)
#endif
#define INVXWERTD(x) ((x)/dx)
#define GEDRUEKT knopf==1
#define LOSGELAS knopf==0
#define STRECKAUSWAHL() streckrotatauswahl(5,0)
#define ROTATAUSWAHL() streckrotatauswahl(7,0)

#define NRETURN(s) if(n) errfun=s; return n
#define TRANSFORM(x0,y0) x=PP*x0+RR*y0+TT; y=QQ*x0+SS*y0+UU
extern int debug;
#define DEBUG(n,x) if(debug>=(n)) x

extern int farbsystem,brushpreview,sprache;
extern int prolog_flag;
extern int defLaflag,defLasymflag,defLUmlautflag,defSchraffierenflag,
	   defEllipseflag;

#define MAXXFARB 32
#define GSGETGRAY get_gray(gs.farbnummer)
#define NFARB 8
#define BBUF 120
#define ZL 120

#define LINNORMAL    0
#define LINCLOSEPATH 2
#define LINCLOSEFILL 3
#define CUTNORMAL 1
#define CUTNURGANZE 2
#define CUTCOPY 4

#define BRUSH	1
#define STRECK	2
#define ROTAT	3
#define TEXT	4
#define LINIE	5
#define BEZIER	6
#define KREIS	7
#define VIERECK	8
#define SCHERE	9
#define LEIM	10
#define STRECKTXT	11
#define ROTATTXT	12
#define PFEIL	13
#define DOPPEL	14
#define LUPE	15
#define BOBOX	16
#define EDIT	17

#define VECTMAL_READY "VectMal READY  "
#define VECTMAL_WORKING "vectmal WORKING  "

#define RUECKFLAG (rueckflag||gs.linecap!=0||gs.linejoin!=0||gs.linewidth!=0.0\
||gs.dashlen!=0 || gs.farbnummer!=1)

typedef char *NAMEN;
typedef int (*ZFUNK)();

/***************** Vordeklarationen **********************/
int s_index(char *s1,int n1,char *s2,int n2);
#define INDEX(s1,s2) s_index(s1,strlen(s1),s2,1)
int s_strcmp(char *s1,char *s2,int n);
double rgb2gray(double,double,double);
double RGB2grau(int,int,int);
int set_color(int,int,int,int,int,int,int *,int *,int *);
double get_color(int,int *,int *,int *);
double get_gray(int);
void farbe_setzen(int);
void cursor_reset(void);
void cursor_setzen(char *,char *,uint,uint,uint hotx,uint hoty);
int idfix(double);
int grauwert2farbnummer(double);
char *sysprocname(long x);
double doubrund(double,double);
double deltatrans(double z);
double ideltatrans(double z);
double ideltatransru(double);
void auswahl_rechteckfill(int x1,int y1,int x2,int y2,int farbe);
#ifndef VAXORALPHA
#define qterm term_refresh
#define qterm_exit term_exit
#ifdef __cplusplus
extern "C" {
#endif
#endif
void q2plot(double x,double y,int pen);
void qinital(int mod,double xmin,double ymin,double xmax,double ymax);
void setsize(int width,int height,int deb);
void qterm();
void umrech(double x,double y,int *i,int *j);
#ifndef VAXORALPHA
#ifdef __cplusplus
}
#endif
#endif
void fillplot(double x,double y,int pen);
void lower_window(),raise_window();
void meldung(char *);
void Fenstertitel(char *str);
int bbox_suchen(FILE *fp,char *str,char *retstring,int retmax);
void meldungrequester(char *text);
#ifdef __cplusplus
inline void term() {qterm();}
#else
#define term() qterm()
#endif
void window2pixelbild(int x0,int y0,int breite,int hoehe);
void pixelbild_einschalten();
void pixelbild_ausschalten();
int pixelbild_ok();
int filecopy(char *von,char *nach);
void lineattribute_uebernemen();
void lineattribute_setzen();
void lineattribute_ruecksetzen();
void bildrefresh();
void showkreis(int x,int y,int r);
int deltatransform(double *zx,double *zy,double x,double y);
int ideltatransform(double *zx,double *zy,double x,double y);
void invtransform(double *zx,double *zy,double x,double y);
void invtransformru(double *zx,double *zy,double x,double y);
void normtransform(double *zx,double *zy,double x,double y);
int itransform();
int translate();
int scale();
void input(char *s1,char *s2,long p);
void input2(char *s1,char *str,int lim);
void input3(int npri,int nsca,char *s1,...);
int requester(char *text,char *jatext,char *neintext);
inline int requester(const char *t,const char *j,const char *n)
	{return requester((char*)t,(char*)j,(char*)n);}
void leim_start(int flg=0);
void schere_setzen();
int exec_str(char *str);
void letztes_zentrieren();
#ifndef fopen1
FILE *fopen1(char *name,char *zugr);
#endif
FILE *fopen2(char *name,char *zugr);
FILE *fopen2w(char *filename,int flag);
void user2bkoord(double x,double y,int *zi,int *zj);
void bkoord2user(int xb,int yb,double* xu,double* yu);
void bkoord2user_push(int xb,int yb);
void bkoord2user_push1(int xb);
void showviereck(int x1,int y1,int x2,int y2,int x3,int y3,int x4,int y4);
int zahlpush(double);
int zahlpush2(double,double);
int push(WORD attri,long awert,long bwert);
WORD pop(long *awert,long *bwert);
int intzahlpop(int *zi);
int intzahlpop2(int *zx,int *zy);
int zahlpop(double *zx);
int zahlpop2(double *zx,double *zy);
int izahlpop(int *zi,double *zx);
void schalter_markieren(int i,int farbe);
void bewegung(int x,int y);
void pixelbild_ein();
void neuesfadenkreuz(int x,int y);
void fadenkreuz_ein();
void fadenkreuz_aus();
void fadenkreuz(int x,int y);
int intrund(int x,int y);
double doubrund(double x,double y);
int ascitodigit(int c);
int getline(FILE* fp,char* s,int lim);
int getline2(FILE* fp,char* s,int lim);
int getlineb(FILE* fp,char* s);
void ungetlineb(FILE* fp,char* s);
void getzeile(FILE* fp,char* s);
void millipause(int millisec);
void screen_save();
void screen_restore();
void dings_start();
void dings_term();
void stradd(char* s,char* t,char* ziel);
int istdrin2(char* str,int a,int b);
void pixelbild_zerren(int breite,int hoehe,int winkel);
void zeigpixelbild(int bx,int by);
void entfernepixelbild();
void brush2pixelbild(char *name);
int preview_suchen(FILE *fp,char *str);
void einfuegen(FILE *fp,char *name);
void einfuegen_fptemp(char *name,int bboxflag);
void machpixelbild(UBYTE *data,int breite,int hoehe,int tiefe);
int ausdrucken(char* name);
void zeilekopieren(FILE *fp1,FILE *fp2);
void restoreall();
void clearclipmask(Pixmap clipmask);
int getclipmask();
void fillpoly(int methode);
int gleichgleich(),pstack();
void loadname(char*);
void namepush(char*);
void initgraphics();
void fehlermeldung(int n);
#ifdef __cplusplus
void fprintfl(FILE *,char *,long p1=0,long p2=0,long p3=0,long p4=0);
void fprintfld(FILE *,char *,double p1=0,double p2=0,double p3=0,double p4=0);
#endif
void linienzug_bezier(XPoint* feld,int jmax);
void bezier(double ax,double ay,double bx,double by,
		double cx,double cy,double dx,double dy);
void fillbezier(double ax,double ay,double bx,double by,
		double cx,double cy,double dx,double dy);
void qstroke();
int mathpop1(char* str,int* ix,double* x);
int mathpop2(char *str,int *ix,int *iy,double *x,double *y);
void draw_in_clip(Pixmap clipmask);
void draw_in_window(Pixmap clipmask);
int font1maschine();
int printpfad(char* str,struct pfad* pat);
int basiszahl(char* str);
int Latexfilter(char* str);
void undo();
void printdictstack(struct Dictstackeintrag *dictstack);
#ifdef __cplusplus
extern "C" {
#endif
int Delete(const char*);
#ifdef __cplusplus
}
#endif
void ncolor(int farbnr);
void screenausmasse_ermitteln();
void create_auswahlfenster();
void auswahl_color(int farbnr);
/*void doub2long(double,long*,long*);/* test */
void brushdar_umschalten(long id,int nr);
int index(char*,char*);
int event_invers(int);

/* Postscriptfunktionen: */
int moveto(),lineto(),curveto(),closepath(),get(),fill(),stroke(),def();
int save(),restore(),gsave(),grestore(),newpath(),exec(),currentpoint();
int findfont(),pspop(),rotate();
int bind(),psdup();
int /*exch*/ exch(), /*copy*/ pscopy(), /*index*/ psindex();
int /*roll*/ roll(), /*rmoveto*/ rmoveto(), /*rlineto*/ rlineto();
int /*sub*/ sub(), /*add*/ add(), /*mul*/ mul();
int /*div*/ psdiv(), /*idiv*/ idiv(), /*neg*/ neg();
int /*abs*/ psabs(), /*not*/ psnot(), /*and*/ psand();
int /*or*/ psor(), /*xor*/ psxor(), /*sin*/ pssin();
int /*cos*/ pscos(), /*atan*/ psatan(), /*log*/ pslog();
int /*ln*/ psln(), /*sqrt*/ pssqrt(), /*round*/ round();
int /*truncate*/ truncate(), /*ceiling*/ ceiling(), /*floor*/ psfloor();
int /*exp*/ psexp(), /*mod*/ mod(), /*eq*/ eq(), /*ne*/ ne();
int /*lt*/ lt(), /*le*/ le(), /*gt*/ gt(), /*ge*/ ge();
int /*if*/ psif(), /*ifelse*/ psifelse(), /*bitshift*/ bitshift();
int /*put*/ put(), /*store*/ store(), /*get*/ get();
int /*show*/ show(), /*ashow*/ ashow(), /*getinterval*/ getinterval();
int /*putinterval*/ putinterval(), /*astore*/ astore();
int /*currentfile*/ currentfile(), /*readstring*/ readstring();
int /*read*/ psread(), /*readhexstring*/ readhexstring();
int /*readline*/ readline();
int /*maxlength*/ maxlength(), /*length*/ length();
int /*currentfont*/ currentfont();
int /*currentgray*/ currentgray(), /*currentlinewidth*/ currentlinewidth();
int /*currentlinecap*/ currentlinecap();
int /*currentlinejoin*/ currentlinejoin();
int /*currentmiterlimit*/ currentmiterlimit();
int /*currentdash*/ currentdash(), /*currentflat*/ currentflat();
int /*dict*/ dict(), /*currentdict*/ currentdict(), /*known*/ known();
int /*where*/ where(), /*array*/ array(), /*packedarray*/ packedarray();
int /*mark*/ mark(), /*aload*/ aload();
int /*true*/ pstrue(), /*false*/ psfalse(), /*string*/ string();
int /*cvi*/ cvi(), /*cvr*/ cvr(), /*cvs*/ cvs(), /*cvn*/ cvn();
int /*cvx*/ cvx(), /*cvlit*/ cvlit(),/*cvrs*/ cvrs(), /*type*/ type();
int /*scale*/ scale(), /*translate*/ translate();
int /*arc*/ arc(), /*arcn*/ arcn(), /*setarcdelta*/ setarcdelta();
int /*fill*/ fill(), /*eofill*/ eofill(), /*arcto*/ arcto();
int /*rcurveto*/ rcurveto(), /*setflat*/ setflat();
int /*rand*/ psrand(), /*srand*/ pssrand(), /*rrand*/ psrrand();
int /*scalefont*/ scalefont(),/*definefont*/ definefont();
int /*makefont*/ makefont(), /*setfont*/ setfont(), /*selectfont*/ selectfont();
int /*stringwidth*/ stringwidth();
int /*save*/ save(), /*restore*/ restore();
int /*gsave*/ gsave(), /*grestore*/ grestore();
int /*transform*/ transform(), /*dtransform*/ dtransform();
int /*itransform*/ itransform(), /*idtransform*/ idtransform();
int /*setgray*/ setgray(), /*setlinewidth*/ setlinewidth();
int /*setlinecap*/ setlinecap(), /*setlinejoin*/ setlinejoin();
int /*setmiterlimit*/ setmiterlimit(),/*setdash*/ setdash();
int /*repeat*/ repeat(), /*loop*/ loop(), /*for*/ psfor();
int /*forall*/ forall(), /*exit*/ psexit(), /*stop*/ psstop();
int /*stopped*/ stopped();
int /*readonly*/ psreadonly(), /*executeonly*/ executeonly();
int /*xcheck*/ xcheck(), /*wcheck*/ wcheck(), /*rcheck*/ rcheck();
int /*clear*/ psclear(), /*cleartomark*/ cleartomark();
int /*count*/ count(), /*counttomark*/ counttomark();
int /*search*/ search(), /*anchorsearch*/ anchorsearch();
int /*begin*/ begin(), /*end*/ end();
int /*rectfill*/ rectfill(), /*rectstroke*/ rectstroke();
int /*xshow*/ xshow(), /*yshow*/ yshow(), /*xyshow*/ xyshow();
int /*setcacheparams*/ setcacheparams(), /*currentcacheparams*/ currentcacheparams();
int /*setcachelimit*/ setcachelimit(), /*cachestatus*/ cachestatus();
int /*widthshow*/ widthshow(), /*awidthshow*/ awidthshow(), /*kshow*/ kshow();
int /*countdictstack*/ countdictstack(), /*dictstack*/ psdictstack();
int /*clip*/ clip(), /*eoclip*/ eoclip();
int /*clippath*/ clippath(), /*pathbbox*/ pathbbox();
int /*image*/ image(), /*imagemask*/ imagemask();
int /*setrgbcolor*/ setrgbcolor(), /*sethsbcolor*/ sethsbcolor();
int currentrgbcolor();
int /*setcmykcolor*/ setcmykcolor(), /*setcmybcolor*/ setcmykcolor();
int /*invertmatrix*/ invertmatrix(), /*identmatrix*/ identmatrix();
int /*matrix*/ matrix(), /*currentmatrix*/ currentmatrix();
int /*setmatrix*/ setmatrix(), /*concat*/ concat(), /*concatmatrix*/ concatmatrix();
int /*settransfer*/ settransfer(), /*currenttransfer*/ currenttransfer();
int /*xlzug*/ xlzug(), /*lzug*/ lzug(), /*xlzug2*/ xlzug2();
int /*lzug2*/ lzug2(), /*xlzug3*/ xlzug3(), /*lzug3*/ lzug3();
int /*file*/ file(), /*closefile*/ closefile(),/*run*/ run();
int /*print*/ psprint(), /*flush*/ flush();
int /*==*/ gleichgleich(), /*=*/ gleich();
int /*stack*/ stack(), /*pstack*/ pstack();
int /*version*/ version(), /*noaccess*/ noaccess(), /*usertime*/ usertime();
int /*pathforall*/ pathforall();
int /*showpage*/ showpage(), /*eexec*/ eexec(), /*token*/ token();
int /*setcachedevice*/ setcachedevice(), /*setcharwidth*/ setcharwidth();
int /*setpacking*/ setpacking(), /*currentpacking*/ currentpacking();
int /*initmatrix*/ initmatrix(), /*defaultmatrix*/ defaultmatrix();
int /*null*/ psnull();
