/* VectMal_fonts.cc				letzte Aenderung: 5.6.1996

;> blink VectMal,vmal1,vmal2,vectmal_hard,vectmal_fonts
Hist:
5.6.1996	leichte Optimierung (inline-Definitionen),
*/

#include <stdlib.h>
#include "vectmal.h"
/* Vordeklarationen von C2CPP erzeugt: */
int typ1buildchar(char* str,long a);
void show_char(int c);
char *strvergl(char* s1,char* s2);
int Latexfilter(char* str);
/* Ende der Vordeklarationen von C2CPP */

inline void _hstem(),_vstem();
inline void _vmoveto(),_rlineto(),_hlineto(),_vlineto();
inline void _vstem3(),_hstem3();
inline void _dotsection();
inline void _closepath();
inline void _hmoveto();
inline void _div();

void _rrcurveto();
void _callsubr();
void _seac();
inline void _sbw();
void _callothersubr();
void _pop();
inline void _setcurrentpoint();
inline void _hsbw();
void _endchar();
void _rmoveto();
void _vhcurveto(),_hvcurveto();


char *font1feld;
WORD font1feld2[]=	/* von Fortran uebernommen */
 {10283,10082,10023,10002,0,
  8283,8162,16283,16162,0,
  18163,162,83,18082,12243,4002,0,
  43,16042,20082,20122,162,202,4242,20242,10283,10002,0,
  8203,4202,4242,8242,8202,12083,12042,16042,16082,12082,43,20242,0,
  20123,8002,4002,42,82,14202,14242,10282,4282,242,202,20002,0,
  12283,12162,0,
  12283,8262,4212,4072,8022,12002,0,
  8283,12262,16212,16072,12022,8002,0,
  4083,20202,12073,12212,4203,20082,0,
  1163,19162,10243,10082,0,
  12083,12042,8002,0,
  1163,19162,0,
  9023,11022,11002,9002,9022,0,
  4043,20242,0,
  4003,42,242,4282,12282,16242,16042,12002,4002,0,
  7213,12282,12002,9002,15002,0,
  243,4282,12282,16242,16162,62,2,16002,0,
  253,4282,12282,16242,16172,12142,4142,12142,16112,16042,12002,4002,32,0,
  20123,122,16282,16002,0,
  33,4002,12002,16042,16122,12162,162,282,16282,0,
  143,12142,16102,16042,12002,4002,42,202,4282,12282,16262,0,
  283,16282,16242,4002,0,
  4143,182,242,4282,12282,16242,16182,12142,4142,102,42,
    4002,12002,16042,16102,12142,0,
  4003,12002,16082,16242,12282,4282,242,182,4142,16142,0,
  9183,9162,11162,11182,9182,9063,9042,11042,11062,9062,0,
  12203,12162,12083,12042,8002,0,
  16243,122,16002,0,
  19163,1162,1083,19082,0,
  243,16122,2,0,
  243,4282,14282,18242,18162,10122,10082,10023,10002,0,
  12183,8122,16122,8123,18172,18242,12282,4282,242,42,4002,16002,0,
  3,202,8282,12282,20202,20002,123,20122,0, /* A */
  3,282,16282,20242,20172,12142,142,3,16002,20042,20112,12142,0,
  20033,16002,4002,42,242,4282,16282,20252,0,
  3,12002,20082,20202,12282,282,2283,2002,0,
  20003,2,142,16142,143,282,20282,0,
  3,142,16142,143,282,20282,0,
  12083,12122,20122,20042,16002,4002,42,242,4282,16282,20252,0,
  3,282,143,20142,20282,20163,20002,0,
  7283,13282,10282,10002,7002,13002,0,
  3073,4042,8002,12042,12282,9282,15282,0,
  3,282,20283,142,20002,0,
  283,2,20002,0,
  3,282,10162,20282,20002,0,
  3,282,20002,20282,0,
  16003,4002,42,242,4282,16282,20242,20042,16002,0,
  3,282,16282,20242,20182,14142,142,0,
  16003,4002,42,242,4282,16282,20242,20042,16002,12082,0,
  3,282,16282,20242,20182,14142,142,5142,16002,0,
  33,4002,16002,20042,20082,16122,4162,202,242,4282,16282,20252,0,
  10003,10282,283,20282,0,
  283,42,4002,16002,20042,20003,20282,0,
  283,10002,20282,0,
  283,2,10202,20002,20282,0,
  3,20282,283,20002,0,
  283,10162,10002,7003,13002,10163,20282,0,
  283,20282,2,20002,0,
  8283,282,2,8002,0,
  243,16042,0,
  8283,16282,16002,8002,0,
  163,8202,16162,0,
  3,20002,0,
  8363,12282,0,
  233,4262,16262,20222,20082,20122,16082,4082,132,4182,20182,0,
  363,82,16082,20122,20202,16242,242,0,
  20213,16242,4242,202,122,4082,16082,20112,0,
  20363,20082,20123,16082,4082,122,202,4242,20242,0,
  163,16162,20202,16242,4242,202,122,4082,16082,19102,0,
  16323,12362,8322,8042,4203,14202,0,
  3023,4002,16002,20042,20242,20203,16242,4242,202,122,4082,16082,20122,0,
  363,82,203,4242,16242,20202,20082,0,
  9083,15082,12083,12242,9243,15242,13343,13322,11322,11342,13342,0,
  4043,8002,12082,12242,9243,15242,13343,13322,11322,11342,13342,0,
  363,82,13083,162,14242,0,
  8363,8082,11102,0,
  83,242,203,5242,10202,10082,10203,13242,17242,20202,20082,0,
  83,242,203,4242,12242,16202,16082,0,
  16243,4242,202,122,4082,16082,20122,20202,16242,0,
  3,242,203,4242,16242,20202,20122,16082,82,0,
  20003,20242,20203,16242,4242,202,122,4082,20082,0,
  4083,4242,4203,8242,16242,0,
  103,4082,16082,20122,16162,4162,202,4242,16242,20222,0,
  11103,8082,8362,4283,16282,0,
  243,122,4082,12082,16122,16083,16242,0,
  243,8082,16242,0,
  243,5082,10202,15082,20242,0,
  243,20082,83,20242,0,
  243,10122,8003,10042,10122,20242,0,
  243,20242,82,20082,0,
  12363,8322,8262,4222,8182,8122,12082,0,
  10363,10082,0,
  8363,12322,12262,16222,12182,12122,8082,0,
  203,4242,8242,12202,16202,20242,0,
  0,
  0
 };

void font1_erstellen()
{
 int i,j,n,x;
 char *s;
 WORD *t;
 extern char *font1dat[];
 font1feld=(char *)malloc(60*256);
 for(i=0;i<256;i++) font1dat[i]= &font1feld[i*60];
 for(i=0;i<256*60;i++) font1feld[i]=0;
 for(i=0x21,t=font1feld2; i<'a'; i++) /* Grossbuchstaben */
	{s= &font1feld[i*60];
	 while(n = *t++)
		{*s++ = n-(n/10)*10;	/* pen */
		 *s++ =x=n/1000;	/* x */
		 *s++ = n/10-100*x;	/* y */
		}
	}
 for(; i<='z'; i++) /* Kleinbuchstaben */
	{s= &font1feld[i*60];
	 while(n = *t++)
		{*s++ = n-(n/10)*10;	/* pen */
		 *s++ =x=n/1000;	/* x */
		 *s++ = n/10-100*x-8;	/* y  (-8 wegen Unterlaengen) */
		}
	}
 for(; i<128; i++) /* restliche Zeichen */
	{s= &font1feld[i*60];
	 while(n = *t++)
		{*s++ = n-(n/10)*10;	/* pen */
		 *s++ =x=n/1000;	/* x */
		 *s++ = n/10-100*x;	/* y */
		}
	}
}


/***************** Adobe Typ1 Fonts ****************/
/* Lit: Adobe Type 1 Font Format  (EDV 7832)	   */
/*	Postscript Language Referenz Manual	   */

/*#define R0 55665 /* fuer eexec-Verschluesselung */
#define R0 4330 /* fuer CharStrings-Verschluesselung */
/* UWORD r=R0; static UWORD c1=52845,c2=22719; */
/* int c0,c; char *str; */
#define DECRY(c) r=(((c)&0xFF)+r)*c1+c2
#define DECRYPT(c) c^(r>>8); r=(c+r)*c1+c2
#define NEXTC(c) c0= *str++ & 0xFF; a--; c=DECRYPT(c0)

static long op1stack[24]; /* Type 1 BuildChar operand stack */
static int  op1z=0;
#define charpush(z) op1stack[op1z++]=(z)
#define charpop() (op1stack[--op1z])
#define clearop1stack() op1z=0

extern long len4;

int font1maschine()
{
 int n;
 WORD att; long a; char *str;
 att=pop(&a,(long*)&str);
 if(!IS_STR(att)) {printf("Font1-ERROR: kein STRING ");
		   push(att,a,(long)str); gleichgleich();
		   printf("Stack: "); pstack();
		   return 1;}
 if(n=typ1buildchar(str,a)) printf("Font1-Error %d\n",n);
 return 0;
}

int typ1buildchar(char* str,long a)
{
 int c0,c,w;
 UWORD r=R0; static UWORD c1=52845,c2=22719;
 long i,zahl;
 for(i=0;i<len4;i++) DECRY(*str++);
 for(a-=len4;a>0;)
  {NEXTC(c);
   switch(c)
	{case 1: _hstem();
	 CASE 3: _vstem();
	 CASE 4: _vmoveto();
	 CASE 5: _rlineto();
	 CASE 6: _hlineto();
	 CASE 7: _vlineto();
	 CASE 8: _rrcurveto();
	 CASE 9: _closepath();
	 CASE 10:_callsubr();
	 CASE 11:return 0;
	 CASE 12:NEXTC(w); switch(w)
			{case 0: _dotsection();
			 CASE 1: _vstem3();
			 CASE 2: _hstem3();
			 CASE 6: _seac();
			 CASE 7: _sbw();
			 CASE 12:_div();
			 CASE 16:_callothersubr();
			 CASE 17:_pop();
			 CASE 33:_setcurrentpoint();
			 DEFAULT:printf("Font1-ERROR: escape 0x%02x ",w);
				 return 1;
			}
	 CASE 13:_hsbw();
	 CASE 14:_endchar();
	 CASE 21:_rmoveto();
	 CASE 22:_hmoveto();
	 CASE 30:_vhcurveto();
	 CASE 31:_hvcurveto();
	 DEFAULT:
		if(c<32) {printf("c=%d ",c); return 2;}
		else if(c<=246) zahl=c-139;
		else if(c<=250) {NEXTC(w); zahl=((c-247)<<8)+w+108;}
		else if(c<=254) {NEXTC(w); zahl= -((c-251)<<8)-w-108;}
		else /*c==255*/ {NEXTC(w);zahl=(w<<24); NEXTC(w);zahl+=(w<<16);
				 NEXTC(w); zahl+=(w<<8); NEXTC(w); zahl+=w;
				}
/*		DEBUG(1,printf("%ld ",zahl));/* test */
		charpush(zahl);
	}
  }
 return 0;
}

/*** Charstring Commands ***/
static int p_sbx,p_sby,p_currentpointx,p_currentpointy; 
extern int p_wx,p_wy;

inline void _hstem()	/* hint */
{
 clearop1stack();
}

inline void _vstem()	/* hint */
{
 clearop1stack();
}

inline void _vmoveto()
{
 op1stack[1]=op1stack[0];
 op1stack[0]=0;
 _rmoveto();
}

inline void _rlineto()
{
 intpush(p_currentpointx+=op1stack[0]); intpush(p_currentpointy+=op1stack[1]);
 lineto();
 clearop1stack();
}

inline void _hlineto()
{
 charpush(0);
 _rlineto();
}

inline void _vlineto()
{
 op1stack[1]=op1stack[0];
 op1stack[0]=0;
 _rlineto();
}

inline void _closepath()
{
 closepath();
 clearop1stack();
}

inline void _hmoveto()
{
 charpush(0);
 _rmoveto();
}

void _rrcurveto()
{
 intpush(p_currentpointx+=op1stack[0]); intpush(p_currentpointy+=op1stack[1]);
 intpush(p_currentpointx+=op1stack[2]); intpush(p_currentpointy+=op1stack[3]);
 intpush(p_currentpointx+=op1stack[4]); intpush(p_currentpointy+=op1stack[5]);
 curveto();
 clearop1stack();
}

void _callsubr()
{
 WORD att; long a; char *str;
 int subrnr;
 subrnr=charpop();
 loadname("Private"); namepush("Subrs"); get();
 intpush(subrnr); get(); att=pop(&a,(long*)&str);
 if(!IS_STR(att)) printf("Font1-Error: _callsubr kein STRING\n");
 typ1buildchar(str,a);
}

inline void _hsbw()
{
 p_sbx=op1stack[0]; p_sby=0; p_wx=op1stack[1]; p_wy=0;
 p_currentpointx=p_sbx; p_currentpointy=p_sby; 
 clearop1stack();
}

void _endchar()
{
 extern int painttype; /* sollte in show() gesetzt werden */
 if(painttype==0) fill();
 else stroke();
 clearop1stack();
}

void _rmoveto()
{
 intpush(p_currentpointx+=op1stack[0]); intpush(p_currentpointy+=op1stack[1]);
 moveto();
 clearop1stack();
}

void _vhcurveto()
{
 op1stack[5]=0; op1stack[4]=op1stack[3]; 
 op1stack[3]=op1stack[2]; op1stack[2]=op1stack[1];
 op1stack[1]=op1stack[0]; op1stack[0]=0;
 _rrcurveto();
}

void _hvcurveto()
{
 op1stack[5]=op1stack[3]; op1stack[4]=0; 
 op1stack[3]=op1stack[2]; op1stack[2]=op1stack[1];
 op1stack[1]=0;
 _rrcurveto();
}

/*** _escape ***/
inline void _dotsection()	/* hint */
{
 clearop1stack();
}

inline void _vstem3()	/* hint */
{
 clearop1stack();
}

inline void _hstem3()	/* hint */
{
 clearop1stack();
}

void _seac()
{
 int asb,adx,ady,bchar,achar;
 asb=op1stack[0]; adx=op1stack[1]; ady=op1stack[2];
 bchar=op1stack[3]; achar=op1stack[4];
/* printf("_seac asb=%d,adx=%d,ady=%d,bchar=%d,achar=%d",
		asb,adx,ady,bchar,achar);/* test */
 gsave();
 intpush(adx); intpush(ady); translate();
 show_char(achar);
 grestore();
 show_char(bchar);
 clearop1stack();
}
void show_char(int c)
{
 newpath();
 loadname("CharStrings"); loadname("StandardEncoding");
 intpush(c); get(); get(); font1maschine();
}

inline void _sbw()
{
 p_sbx=op1stack[0]; p_sby=op1stack[1]; p_wx=op1stack[2]; p_wy=op1stack[3];
 p_currentpointx=p_sbx; p_currentpointy=p_sby; 
 clearop1stack();
}

inline void _div()
{
 int y;
 y=charpop();
 op1stack[op1z]/=y;
}

void _callothersubr()
{
 int subrnr,n;
 subrnr=charpop();
 n=charpop();
 while(n--) intpush(charpop());
/* systemdict begin fontdict begin   schon in show() gemacht */
 loadname("Private"); namepush("OtherSubrs"); get();
 intpush(subrnr); get(); exec();
/* end end   wird auch in show() gemacht */
}

void _pop()
{
 WORD att; long a,b;
 REAL z;
 att=pop(&a,&b);
 if(IS_REAL(att)) {z.n[1]=b; z.n[0]=a; b=(long)z.d;}
 else if(!IS_INT(att)) {printf("Font1-Error: _pop keine Zahl\n"); b=0;}
 charpush(b);
}

inline void _setcurrentpoint()
{
 p_currentpointx=op1stack[0]; p_currentpointy=op1stack[1]; 
 clearop1stack();
}


/***************** LatexFormeln anpassen ****************/
#include <stdio.h>
#include <ctype.h>

static char *Latextabelle[]=
 {"alpha","a",	"beta","b",	"gamma","g",	"delta","d",	"epsilon","e",
  "zeta","z",	"eta","h",	"theta","q",	"vartheta","J",	"iota","i",
  "kappa","k",	"lambda","l",	"mu","m",	"nu","n",	"xi","x",
  "pi","p",	"varpi","v",	"rho","r",	"sigma","s",	"tau","t",
  "varsigma","V","upsilon","u",	"phi","f",	"chi","c",	"psi","y",
  "varphi","j",	"omega","w",
  "Gamma","G",	"Delta","D",	"Theta","Q",	"Lambda","L",	"Xi","X",
  "Pi","P",	"Sigma","S",	"Phi","F",	"Psi","Y",	"Omega","W",
  "ast","*",	"cong","@",	"perp","^",	"forall","\"",	"exists","$",
  "ni","'",
  "Upsilon","\241",  "le","\243", "leq","\243", "infty","\245",
  "clubsuit","\247", "diamondsuit","\250", "heartsuit","\251",
  "spadesuit","\252", "leftrightarrow","\253", "leftarrow","\254",
  "uparrow","\255", "rightarrow","\256", "longrightarrow","\276\256",
  "gets","\254", "to","\256",
  "downarrow","\257", "circ","\260", "pm","\261", "ge","\263", "times","\264",
  "propto","\265", "partial","\266", "bullet","\267", "div","\270",
  "not=","\271", "equiv","\272", "approx","\273", "hdots","\274",
  "aleph","\300", "Im","\301", "Re","\302", "wp","\303", "otimes","\304",
  "oplus","\305", "oslash","\306", "Oslash","\306", "cap","\307", "cup","\310",
  "supset","\311", "supseteq","\312", "not\\subset","\313", "notsubset","\313",
  "subset","\314", "subseteq","\315", "in","\316", "notin","\317",
  "not\\in","\317", "angle","\320", "nabla","\321",
  "warenzeichen","\322", "TM","\324", /* diese zwei nicht LaTeX-Standard */
  "copyright","\323", "prod","\325", "surd","\326", "cdot","\327",
  "neg","\330", "wedge","\331", "vee","\332", "Leftrightarrow","\333",
  "Leftarrow","\334", "Uparrow","\335", "Rightarrow","\336",
  "Downarrow","\337", "diamond","\340", "langle","\341", "sum","\345",
  "lceil","\351", "lfloor","\353", "rceil","\371", "rfloor","\373",
  "rangle","\361", "int","\362",
  "# ","#", "% ","%", "& ","&", "+ ","+", "- ","-", "= ","=",
  "Fanta","\\", /* 3 Punkte , nicht LaTeX-Standard */
  NULL,NULL},
*Umlauttabelle[]=
 {"\"a","\201",	"\"o","\202",	"\"u","\203",	"\"A","\204",	"\"O","\205",
  "\"U","\206",	"Ae","\204",	"AA","\207",
  NULL,NULL},
*Standardsondertabelle[]=
 {"promille","\275",  "o ","\371", "O ","\351", "backslash","\\\\",
  /* jetzt kommen alle NichtASCI-Zeichen von StandardEncoding: */
  /* Bei Konflikt mit LaTeX eine 2 angehaengt (z.B. "bullet2") */
  "exclamdown","\241",	"cent","\242",	"sterling","\243", "fraction","\244",
  "yen","\245",	"florin","\246", "section","\247", "currency","\250",
  "quotesingle","\251", "quotedblleft","\252", "guillemotleft","\253",
  "guilsinglleft","\254", "guilsinglright","\255", "fi","\256", "fl","\257",
  "endash","\261", "dagger","\262", "daggerdbl","\263", "periodcentered","\264",
  "paragraph","\266", "bullet2","\267", "quotesinglbase","\270",
  "quotedblbase","\271", "quotedblright","\272", "guillemotright","\273",
  "ellipsis","\274", "perthousand","\275", "questiondown","\277",
  "grave","\301", "acute","\202", "circumflex","\303", "tilde","\304",
  "macron","\305", "breve","\306", "dotaccent","\307", "dieresis","\310",
  "ring","\312", "cedilla","\313", "hungarumlaut","\315", "ogonek","\316",
  "caron","\317", "emdash","\320", "AE","\341", "ordfeminine","\343",
  "Lslash","\350", "Oslash2","\351", "OE","\352", "ordmasculine","\353",
  "ae","\361", "dotlessi","\365", "lslash","\370", "oslash2","\371", 
  "oe","\372", "germandbls","\373",
  /* jetzt dieselben NichtASCI-Zeichen in LaTeX-Syntax: */
  "ss","\373",	"pounds","\243",  "S","\247",  "ll","\253", "dag","\262",
  "ddag","\263", "P","\266", "gg","\273",
  NULL,NULL};

#define UMSCH '`' /* Zeichen fuer Umschaltung auf Symbol-Font */

char *strvergl(char* s1,char* s2)
{
 int c,c1;
 c1= *s1;
 while(c= *s1++) if(*s2++!=c) return NULL;
 if(c1=='\"') return s2;
 if(*s2==' ') s2++;
 else if(isalnum(*s2)) return NULL;
 return s2;
}

int Latexfilter(char* str) /* Rueckgabewert: 1=Zeichen aus Symbol, 2=Umlaut */
{
 int flag=0,c;
 char *str2=str,*s,**p1,*s1,*s2;
 while(c= *str)
  {if(c=='\\')
	{str++;
	 DEBUG(1,printf("Latexfilter() str='%s'\n",str));/* test */
	 for(p1=Latextabelle; (s1= *p1)!=NULL; p1+=2)
		{DEBUG(1,printf("strvergl('%s',str)\n",s1));/* test */
		 if(s=strvergl(s1,str)) {s2= *++p1; break;}
		}
	 if(s)	{*str2++ = UMSCH; while(*s2) *str2++ = *s2++;
		 *str2++ = UMSCH; str=s; flag|=1;
		}
	 else {for(p1=Umlauttabelle; (s1= *p1)!=NULL; p1+=2)
			if(s=strvergl(s1,str)) {s2= *++p1; break;}
	       if(s) {*str2++ = *s2; str=s; flag|=2;}
	       else {for(p1=Standardsondertabelle; (s1= *p1)!=NULL; p1+=2)
			if(s=strvergl(s1,str)) {s2= *++p1; break;}
		     if(s) {while(*s2) *str2++ = *s2++;  str=s;}
	}     }     }
   else *str2++ = *str++;
  }
 *str2=0;
 return flag;
}


/************************ CacheDevice ***********************/
#include <X11/Xlib.h>

extern GC tekplot_gc;
extern Display *tekplot_dpy;
extern Window tekplot_win;
extern int bildschirm_tiefe;

#define VERTAUSCHE(a,b) {int h; h=a; a=b; b=h;}
//#define PLANEMASKE 1L
#define PLANEMASKE 0xFFFFFFFF /* test */
void user2bkoord(double x,double y,int *zi,int *zj);

struct cache_eintrag
 {double dx,dy;
/*  Drawable pix; test*/
  XImage *image;
  unsigned int br,ho;
  int grux,gruy;
 };
struct cache_font
 {struct cache_font *next;
  Dictionary *fdic;
  struct cache_eintrag *p[256];
 };

static struct cache_font *cache=NULL,*xcache=NULL;

int cache_check(int c,Dictionary *fdic)
{
 for(xcache=cache;xcache!=NULL;xcache=xcache->next)
	if(xcache->fdic==fdic) return (xcache->p[c]!=NULL);
 return 0;
}
void cache_print(int c,Dictionary *fdic,double *dicktex,double *dicktey)
{
 struct cache_eintrag *e;
 double x1,y1;
 int bx,by;
 e=xcache->p[c];
 *dicktex=e->dx; *dicktey=e->dy;
 currentpoint(); zahlpop2(&x1,&y1); user2bkoord(x1,y1,&bx,&by);/* optimierbar */
 by += e->gruy - e->ho;
 bx += e->grux - e->br;
/*XCopyArea(tekplot_dpy,e->pix,tekplot_win,tekplot_gc,0,0,e->br,e->ho,bx,by);test*/
 XPutImage(tekplot_dpy,tekplot_win,tekplot_gc,e->image,0,0,bx,by,e->br,e->ho);
}
void cache_put(int c,Dictionary *fdic,double dx,double dy,
	  double xul,double yul,double xor,double yor)
{
 struct cache_eintrag *e;
 double x1,y1;
 int bx,by,bxul,byul,bxor,byor;
 if(xcache==NULL)
  {int i;
   if(!(xcache=(struct cache_font *)malloc(sizeof(struct cache_font)))) return;
   xcache->fdic=fdic; xcache->next=cache;
   cache=xcache;
   for(i=0;i<256;i++) xcache->p[i]=NULL;
  }
 if(!(e=(struct cache_eintrag *)malloc(sizeof(struct cache_eintrag)))) return;
 xcache->p[c]=e;
 e->dx=dx; e->dy=dy;
 currentpoint(); zahlpop2(&x1,&y1); user2bkoord(x1,y1,&bx,&by);/* optimierbar */
 user2bkoord(xul,yul,&bxul,&byul);
 user2bkoord(xor,yor,&bxor,&byor);
 if(bxul>bxor) VERTAUSCHE(bxul,bxor);
 if(byul>byor) VERTAUSCHE(byul,byor);
 e->br=(++bxor)-bxul;
 e->ho=(++byor)-byul;
 e->gruy=byor-by;/* Grundlinienverschiebung z.B. bei Unterlaengen */
 e->grux=bxor-bx;
/* e->pix=XCreatePixmap(tekplot_dpy,tekplot_win,e->br=bxor-bxul+1,
			e->ho=byor-byul+1,bildschirm_tiefe);
/* if(e->pix==0) {printf("Fehler in XCreatePixmap\n"); return;}
/* XCopyArea(tekplot_dpy,tekplot_win,e->pix,tekplot_gc,bxul,byul,
		e->br,e->ho,0,0); test*/
 e->image=XGetImage(tekplot_dpy,tekplot_win,
			bxul,byul,e->br,e->ho,PLANEMASKE,XYPixmap);
 if(e->image==NULL) printf("Fehler in XGetImage()\n");
}

void user2bkoord(double x,double y,int *zi,int *zj)
{
 double zx,zy;
 normtransform(&zx,&zy,x,y);
 umrech(zx,zy,zi,zj);
}

/* test: *
void quicktext(int c,double *dicktex,double *dicktey,double dx,double dy)
{
 Font font;
 double x,y;
 int x1,y1;
 char str[2];
 str[0]=c; str[1]=0;
 font=XLoadFont(tekplot_dpy,"vrb-25");
 if(font==0) printf("Fehler bei XLoadFont()\n");
 else XSetFont(tekplot_dpy,tekplot_gc,font);
 currentpoint(); zahlpop2(&x,&y); user2bkoord(x,y,&x1,&y1);
 XDrawString(tekplot_dpy,tekplot_win,tekplot_gc,x1,y1,str,1);
 *dicktex=5.; *dicktey=0.;
}
/* Ende von vectmal_fonts.c */
