/* VectMal_hard.cc			letzte Aenderung: 30.3.2000
/* Dieser Teil ist sehr stark Hardwareabhaengig

Uebersetzen an ALPHA:
cxx vectmal.cc
@ blink VectMal,vmal1,vmal2,vectmal_hard,vectmal_fonts,[pfister.obj]xmenu

Die globalen Variablen die hier definiert sind, sollten in 'vectmal.h'
deklariert werden.
'vectmal.h' darf in allen Teile ausser 'Vectmal_hard.c' verwendet werden.

Teile die mit XWindows noetig sind, sonst aber voellig ueberfluessig zu sein
scheinen, sind mit X11PROBLEM gekennzeichnet.

History:
ca. 1992	Erstellung (Rolf Pfister)
29.11.1995
26.1.96		fadenkreuzfarbesetzen() verbessert
6.2.96	V 0.65	Cursor-Darstellung verbessert (ist_weiss_null() eingefhrt)
		pixbru_gc eingefhrt
23.5.96		Probleme mit UNO und ONU geloest
28.5.96		"extern int hintergrundflag;"  ("static int" war falsch)
5.6.96	V 0.66	in raise_window() XRaiseWindow() durch XMapRaised() ersetzt.
25.2.97		neues screenclear in xtekplot1
		Probleme mit uint und ulong: #define in ulong.h  #undef danach
11.6.97		idfix() von vmal2.cc hierher verlagert (nur mit OLDXTEKPLOT)
23.11.98	uint und ulong machen wieder Probleme unter Linux
		<stdlib.h> jetzt immer eingefuegt
22.3.2000	voed eingefuegt
*/

#define VOED_MENUS
void m_exit(),m_about(),m_load(),m_save(),m_saveas();
void m_oundo(),m_oname(),m_osize(),m_oscale(),m_oedit(),m_gost();

// Bei Verwendung auf ALPHA/VAX:
#define VAX
// Wenn alte xtekplot-Version (xtekplot.cc statt xtekplot1.cc)
// verwendet werden soll:
#define OLDXTEKPLOT

#ifdef __cplusplus
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#define c_class class
#endif

#include "vectmal_const.h"
#undef uint
#undef ulong
/*#define A4HH 797
/*#define A4HB 566  /* 799, 565 in vectmal_const.h definiert */
/*#define A4Q11H 645
/*#define A4Q11B 912  /* 644, 911 in vectmal_const.h definiert */

#ifdef unix
#undef VAX
#undef OLDXTEKPLOT
#endif

/** Maschninenabhaengige define's: **/
#ifdef VAX
#define M_LSBFIRST
#define M_SHIFTLEFT
#endif
#ifdef unix
#define M_LSBFIRST
#define M_SHIFTLEFT
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#ifdef VAX
#include <file.h>
#ifndef __STDC__
/*#include <stdlib.h>*/
#include <unixio.h>
#endif
#endif /*VAX*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#ifdef unix
#define uint unsigned int
#define ulong ULONG
#else /*VAX_OR_ALPHA*/
#define uint unsigned int
typedef unsigned long ulong;
#endif

/*
#ifdef __cplusplus
extern "C"
{
#endif
int     lib$get_ef(long*),lib$signal(long),
	sys$setimr(long,long*,void*,long,long),
	sys$clref(long), sys$waitfr(long),
	lib$free_ef(long *);
#ifdef __cplusplus
}
#endif
*/

/* Vordeklarationen: */
int set_color(int farbnr,int farbsys,
		int rhc,int gsm,int bby,int k,int* r,int* g,int* b);
double get_color(int farbnr,int* r,int* g,int* b);
void file_load(int frageflag);
void file_save(int frageflag);
void file_loadbrush(int nr);
void file_savebrush();
void file_plot();
void file_plot2();
void einstellungen_nachladen(char *einstname);
void einstellungen_speichern();
void einstellungen_zeigen();
void einstellungen_reset();
void farbsystem_setzen(int n);
void bruprev_setzen(int n);
void sprache_setzen(int n);
void format_setzen(int br,int ho,int flag);
void hintergrundfarbe_setzen(int farbe);
void bildrefresh();
#ifdef VAX
void fensterposition();
#endif
void pixelbild_zerren(int breite,int hoehe,int winkel);
void entfernepixelbild();
void file_exit();
void klick(int knopf,int x,int y,int knopfnr);
void bewegung(int x,int y);
void meldungen_refresh();
void fadenkreuz_ein();
void fadenkreuz_aus();
void fadenkreuz(int x,int y);
void symbolauswahl(int,int);
void hsb2rgb(double h,double s,double b,int *R,int *G,int *B);
void millipause(int);
UBYTE *bilddrehen(int winkel,uint *pbreite,uint *phoehe);
void vergroessern(UBYTE *abild,int abreite,int ahoehe,
		  UBYTE *bild,int breite,int hoehe);
int idfix(double);
void machpixelbild_ausimag(XImage *imag,int breite,int hoehe,int tiefe);
static char *fragefile();
void lower_window();
void raise_window();
void symbolezeichnen(Window win,GC gc);
void screenausmasse_ermitteln();
int ist_weiss_null();


/***************** externe Variablen vom Hauptprogramm **********************/
extern char argflag[];
extern int debug;
extern short help_flag;

/************************* globale Variablen ********************************/
int	bildschirm_breite,bildschirm_hoehe,bildschirm_tiefe,
	bildschirm_visualklasse;

int	farbsystem=RGB,
	brushpreview=0,
	sprache=DEUTSCH;

/************************** neue Menue-Erzeugung **************************/
#define VECTMAL 1
static Drawable fillpwin=0;
static GC gc_clipmask=0;
#ifdef OLDXTEKPLOT
#include "[pfister.x]xtekplot.cc"
int idfix(double x) {return (int)((x>=0.)?x+0.5:x-0.5);}
/* ein Teil von xtekplot.h */
#define inital(x1,y1,x2,y2) qinital(1,x1,y1,x2,y2)
#define plot q2plot
#define term qterm
/* #include "h:xmenu.h" schon in xtekplot.cc gemacht */
#else /*OLDXTEKPLOT*/
#include <xtekplot1.h>
extern Window tekplot_win;
extern Display *tekplot_dpy;
extern GC tekplot_gc;
//extern Screen *tekplot_screen;
void farbtabelle_erstellen();
#define DEBUG(n,x) if(debug>=(n)) x
#define dpy tekplot_dpy
#define win1 tekplot_win
#ifdef OLDXTEKPLOT
#define winhoehe (tekplot_hoehe+1+menubalkenhoehe)
#define winbreite (tekplot_breite+1)
#else
#define winhoehe (tekplot_hoehe+1+menubalkenhoehe)
#define winbreite (tekplot_breite+2)
#endif
#define gc tekplot_gc
static Window win_meldungen=0;
//provisorisch:
#define MAXXFARB 32
extern int vordergrundfarbe,hintergrundfarbe;
extern int tekplot_xborder,tekplot_yborder,tekplot_borderflag;
extern unsigned int menubalkenhoehe;
extern int tek_farbe;
extern XColor *colortabelle;
extern UBYTE rgbtabelle[][3];
#endif /*OLDXTEKPLOT else*/

static long menu_ids[60];
static long farbsys_ids[4],brushdar_ids[4],sprache_ids[2];
static char	text_RGB[]="%O RGB",
		text_HSB[]="%o HSB",
		text_CMYK[]="%o CMYK  ",
		text_grau[]="%o grau",
		text_viereck[]="%O Viereck (=schnell)",
		text_hexprev[]="%o Hexprev",
		text_exakt[]="%o Exakt (=langsam)",
		text_autoprev[]="%o Auto",
		text_deutsch[]="%o deutsch ",
		text_english[]="%o english ";
void eng_text_copy()
{
 strcpy(text_grau,"%o gray");
 strcpy(text_viereck,"%O Box (=quick)");
 strcpy(text_exakt,"%o Exact (=slowly)");
}

void farbsys_umschalten(long id,int nr)
{
 farbsystem_setzen(nr);
 text_RGB[1]=text_HSB[1]=text_CMYK[1]=text_grau[1]='o';
 switch(nr)
  {case RGB: text_RGB[1]='O';
   CASE HSB: text_HSB[1]='O';
   CASE CMYK: text_CMYK[1]='O';
   CASE FARBGRAY: text_grau[1]='O';
  }
 if(farbsys_ids[0]==0)
        {if(id==0) return;
         getmenuids(id,farbsys_ids);
        }
 changemenu(farbsys_ids[0],text_RGB);
 changemenu(farbsys_ids[1],text_HSB);
 changemenu(farbsys_ids[2],text_CMYK);
 changemenu(farbsys_ids[3],text_grau);
}

void brushdar_umschalten(long id,int nr)
{
 bruprev_setzen(nr);
 text_viereck[1]=text_hexprev[1]=text_exakt[1]=text_autoprev[1]='o';
 switch(nr)
  {case 0: text_viereck[1]='O';
   CASE 1: text_hexprev[1]='O';
   CASE 2: text_exakt[1]='O';
   CASE 3: text_autoprev[1]='O';
  }
 if(brushdar_ids[0]==0)
	{if(debug)
	  {printf("brushdar_ids[0]==0 id=%ld\n",id);/* Testausdruck */
	   if(id==0) return;
	  }
#ifdef VOED_MENUS
	 if(id==0) id=22;/* mit Testausdruck ermittelt			*/
#else
	 if(id==0) id=17;/* mit Testausdruck ermittelt			*/
#endif
			 /* dazu Option -D1 angegeben und dann		*/
			 /* Menupunkt 'Brushdar->Viereck' angewhlt	*/
	 getmenuids(id,brushdar_ids);
	}
 changemenu(brushdar_ids[0],text_viereck);
 changemenu(brushdar_ids[1],text_hexprev);
 changemenu(brushdar_ids[2],text_exakt);
 changemenu(brushdar_ids[3],text_autoprev);
}

void sprache_umschalten(long id,int nr)
{
 sprache_setzen(nr);
 text_deutsch[1]=text_english[1]='o';
 switch(nr)
  {case 0: text_deutsch[1]='O';
   CASE 1: text_english[1]='O';
  }
 if(sprache_ids[0]==0)
        {if(id==0) return;
         getmenuids(id,sprache_ids);
        }
 changemenu(sprache_ids[0],text_deutsch);
 changemenu(sprache_ids[1],text_english);
}

#ifdef VOED_MENUS
char *deutsches_menu[]=
{"File",      "Einstellungen",   "Format",	"Edit",
 "About ...", "alle zeigen",     "A4 hoch",	"undo",
 "Load ...",  "nachladen",	 "A4 quer",	"Name ...",
 "Save ...",  "reset",		 "A4 quer 1:1",	"Size & Position ...",
 "Plot (sw-Laser)",
	  "Farbsystem        ->", "Hintergrund weiss", "Scale & Shift ...",
 NULL,		text_RGB,			NULL,  NULL,
 NULL,		text_HSB,			NULL,  NULL,
 NULL,		text_CMYK,			NULL,  NULL,
 NULL,		text_grau,			NULL,  NULL,
 "Plot (farbig)",
	  "BrushDarstellung  ->", "Hintergrund schwarz", "text editor",
 NULL,		text_viereck,		NULL,  NULL,
 NULL,		text_hexprev,		NULL,  NULL,
 NULL,		text_exakt,		NULL,  NULL,
 NULL,		text_autoprev,		NULL,  NULL,
 "LoadBrush",	"Language          ->",	"Refresh",  "ghostview",
 NULL,		text_deutsch,		NULL,  NULL,
 NULL,		text_english,		NULL,  NULL,
 "SaveBrush",	NULL,			NULL,	    "quit voed", //provi.
 "HELP",	NULL,			NULL,  NULL,
 "Exit",	NULL,			NULL,  NULL
};

char *english_menu[]=
{"File",      "Settings",        "Format",	"Edit",
 "About ...", "alle zeigen",     "A4 high",	"undo",
 "Load ...",  "nachladen",	 "A4 wide",	"Name ...",
 "Save ...",  "reset",		 "A4 wide 1:1",	"Size & Position ...",
 "Plot (sw-Laser)",
	  "Colorsystem     ->", "Background white", "Scale & Shift ...",
 NULL,		text_RGB,			NULL,  NULL,
 NULL,		text_HSB,			NULL,  NULL,
 NULL,		text_CMYK,			NULL,  NULL,
 NULL,		text_grau,			NULL,  NULL,
 "Plot (color)",
	  "BrushPreview    ->", "Background black", "text editor",
 NULL,		text_viereck,		NULL,  NULL,
 NULL,		text_hexprev,		NULL,  NULL,
 NULL,		text_exakt,		NULL,  NULL,
 NULL,		text_autoprev,		NULL,  NULL,
 "LoadBrush",
	  "Language        ->",	"Refresh",  "ghostview",
 NULL,		text_deutsch,		NULL,  NULL,
 NULL,		text_english,		NULL,  NULL,
 "SaveBrush",	NULL,			NULL,	    "quit voed", //provi.
 "HELP",	NULL,			NULL,  NULL,
 "Exit",	NULL,			NULL,  NULL
};
#else
char *deutsches_menu[]=
{"File",	"Einstellungen",	"Format",
 "Load",	"alle zeigen",		"A4 hoch",
 "Save",	"nachladen",		"A4 quer",
 "Plot (IBM Laser)", "reset",		"A4 quer 1:1",
 "Plot (HP DeskJet)",
		"Farbsystem        ->",	"Hintergrund weiss",
 NULL,		text_RGB,			NULL,
 NULL,		text_HSB,			NULL,
 NULL,		text_CMYK,			NULL,
 NULL,		text_grau,			NULL,
 "LoadBrush",	"BrushDarstellung  ->",	"Hintergrund schwarz",
 NULL,		text_viereck,		NULL,
 NULL,		text_hexprev,		NULL,
 NULL,		text_exakt,		NULL,
 NULL,		text_autoprev,		NULL,
 "SaveBrush",	"Language          ->",	"Refresh",
 NULL,		text_deutsch,		NULL,
 NULL,		text_english,		NULL,
 "HELP",	NULL,			NULL,
 "Exit",	NULL,			NULL
};

char *english_menu[]=
{"File",	"Settings",		"Format",
 "Load",	"show all",		"A4 high",
 "Save",	"load",			"A4 wide",
 "Plot (IBM Laser)", "reset",		"A4 wide 1:1",
 "Plot (HP DeskJet)",
		"Colorsystem       ->",	"background White",
 NULL,		text_RGB,			NULL,
 NULL,		text_HSB,			NULL,
 NULL,		text_CMYK,			NULL,
 NULL,		text_grau,			NULL,
 "LoadBrush",	"BrushPreview  ->",	"background Black",
 NULL,		text_viereck,		NULL,
 NULL,		text_hexprev,		NULL,
 NULL,		text_exakt,		NULL,
 NULL,		text_autoprev,		NULL,
 "SaveBrush",	"Language          ->",	"Refresh",
 NULL,		text_deutsch,		NULL,
 NULL,		text_english,		NULL,
 "HELP",	NULL,			NULL,
 "Exit",	NULL,			NULL
};
#endif

void k_about()
{
 char str[80];
 sprintf(str,"vectmal  %s\nAutor: Rolf Pfister",VECTMAL_VERSION);
 janeinrequester(str);
}
void k_load(long n) {file_load(1);}
void k_save()	{file_save(1);}
void k_plot(long n) {file_plot();}
void k_plot2(long n) {file_plot2();}
void k_loadbrush(long n) {file_loadbrush(2);}
void k_savebrush(long n) {file_savebrush();}
void k_help(long n)
		{lower_window();
		 system("Multiview VECTMALHELP:vectmal_help.iff");
		 raise_window();
		}
void k_einst_zeigen(long n) {einstellungen_zeigen();}
void k_einst_nachlad(long n) {einstellungen_nachladen(fragefile());}
void k_einst_reset(long n) {einstellungen_reset();}
void k_rgb(long n) {farbsys_umschalten(n,RGB);}
void k_hsb(long n) {farbsys_umschalten(n,HSB);}
void k_cmyk(long n) {farbsys_umschalten(n,CMYK);}
void k_gray(long n) {farbsys_umschalten(n,FARBGRAY);}
void k_bruprev0(long n) {brushdar_umschalten(n,0);}
void k_bruprev1(long n) {brushdar_umschalten(n,1);}
void k_bruprev2(long n) {brushdar_umschalten(n,2);}
void k_bruprev3(long n) {brushdar_umschalten(n,3);}
void k_deutsch(long n) {sprache_umschalten(n,0);}
void k_english(long n) {sprache_umschalten(n,1);}
void k_a4hoch(long n) {format_setzen(A4HB,A4HH,1);}
void k_a4quer(long n) {format_setzen(A4QB,A4QH,1);}
void k_a4quer1zu1(long n) {format_setzen(A4Q11B,A4Q11H,1);}
void k_higrundw(long n) {hintergrundfarbe_setzen(1);}
void k_higrunds(long n) {hintergrundfarbe_setzen(0);}
void k_refresh(long n) {bildrefresh();}
void k_exit() {file_exit();}

void menu_start(char *version)
{
 char **text;
 if(sprache==DEUTSCH)
	{text=deutsches_menu; text_deutsch[1]='O';}
 else	{text=english_menu; text_english[1]='O'; eng_text_copy();}
#ifdef VOED_MENUS
 int i=0,n=4;
 setmenu(n,text[i],text[i+1],text[i+2],text[i+3]); i+=n;
 setmenu(n,text[i],text[i+1],text[i+2],text[i+3],
	 k_about,k_einst_zeigen,k_a4hoch, m_oundo); i+=n;
 setmenu(4,text[i],text[i+1],text[i+2],text[i+3],
	 k_load,k_einst_nachlad,k_a4quer, m_oname); i+=n;
 setmenu(4,text[i],text[i+1],text[i+2],text[i+3],
	 k_save,k_einst_reset,k_a4quer1zu1, m_osize); i+=n;
 setmenu(4,text[i],text[i+1],text[i+2],text[i+3],
	 k_plot,NULL,k_higrundw, m_oscale); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_rgb); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_hsb); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_cmyk); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_gray); i+=n;
 setmenu(4,text[i],text[i+1],text[i+2],text[i+3],
	 k_plot2,NULL,k_higrunds, m_oedit); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_bruprev0); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_bruprev1); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_bruprev2); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_bruprev3); i+=n;
 setmenu(4,text[i],text[i+1],text[i+2],text[i+3],
	 k_loadbrush,NULL,k_refresh, m_gost); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_deutsch); i+=n;
 setsubmenu(2,text[i],text[i+1],	NULL,k_english); i+=n;
 setmenu(4,text[i],text[i+1],text[i+2],text[i+3],
	 k_savebrush, NULL, NULL, m_exit); i+=n;
 setmenu(1,text[i],			k_help); i+=n;
 setmenu(1,text[i],			k_exit); i+=n;
#else
 setmenu(3,text[0],text[1],text[2]);
 setmenu(3,text[3],text[4],text[5],   k_load,k_einst_zeigen,k_a4hoch);
 setmenu(3,text[6],text[7],text[8],   k_save,k_einst_nachlad,k_a4quer);
 setmenu(3,text[9],text[10],text[11], k_plot,k_einst_reset,k_a4quer1zu1);
 setmenu(3,text[12],text[13],text[14],k_plot2,NULL,k_higrundw);
 setsubmenu(2,text[15],text[16],	NULL,k_rgb);
 setsubmenu(2,text[18],text[19],	NULL,k_hsb);
 setsubmenu(2,text[21],text[22],	NULL,k_cmyk);
 setsubmenu(2,text[24],text[25],	NULL,k_gray);
 setmenu(3,text[27],text[28],text[29], k_loadbrush,NULL,k_higrunds);
 setsubmenu(2,text[30],text[31],	NULL,k_bruprev0);
 setsubmenu(2,text[33],text[34],	NULL,k_bruprev1);
 setsubmenu(2,text[36],text[37],	NULL,k_bruprev2);
 setsubmenu(2,text[39],text[40],	NULL,k_bruprev3);
 setmenu(3,text[42],text[43],text[44], k_savebrush,NULL,k_refresh);
 setsubmenu(2,text[45],text[46],	NULL,k_deutsch);
 setsubmenu(2,text[48],text[49],	NULL,k_english);
 setmenu(1,text[51],			k_help);
 setmenu(1,text[54],			k_exit);
#endif
}

/********************** fadenkreuz_init ************************/
GC fadenkreuz_gc=0,pixbru_gc=0;

int xor(int a,int b) {return ((a && !b)||(!a && b));}

void fadenkreuzfarbesetzen(int farbe,int higrund= -1)
{
 static int akt_farbe= -1,akt_higrund= -1,akt_vogrund;
 if(higrund!= -1)
  {XSetBackground(tekplot_dpy,fadenkreuz_gc,akt_higrund=hintergrundfarbe);
   akt_vogrund=farbe;
   akt_farbe= -1;
  }
 if(farbe!=akt_farbe)
  {// Geht auf dem MAC perfekt (eXodus),
   // auf Zuse mit weissem Hintergrund werden alle Farben als
   // schwarz dargestellt (Grund unbekannt).
   akt_farbe=farbe;
   if(farbe==akt_higrund) farbe = akt_vogrund;
   XSetForeground(dpy,fadenkreuz_gc,farbe);
/* test: *
   static int antwflag=0;//test
   if(debug && antwflag<2) //test
    {char antw[20];
     printf("akt_higrund=%d  GXequiv:GXxor vertauschen ?");
     scanf("%s",antw);
     if(*antw=='j' || *antw=='J')
	 XSetFunction(tekplot_dpy,fadenkreuz_gc,(akt_higrund!=0)?GXxor:GXequiv);
     else
	 XSetFunction(tekplot_dpy,fadenkreuz_gc,(akt_higrund!=0)?GXequiv:GXxor);
     antwflag++;
    }
   else
* :test */
   XSetFunction(tekplot_dpy,fadenkreuz_gc,(akt_higrund!=0)?GXequiv:GXxor);
  }
}

void fadenkreuz_init()
{
 if(fadenkreuz_gc!=0) return;
 DEBUG(1,printf("fadenkreuz_init()\n"));
 fadenkreuz_gc=XCreateGC(tekplot_dpy,tekplot_win,0,NULL);
 fadenkreuzfarbesetzen(vordergrundfarbe,hintergrundfarbe);
 pixbru_gc=XCreateGC(tekplot_dpy,tekplot_win,0,NULL);
 XSetBackground(dpy,pixbru_gc,hintergrundfarbe);
 XSetForeground(dpy,pixbru_gc,vordergrundfarbe);
 XSetFunction(tekplot_dpy,pixbru_gc,GXxor);
}

/************************ Fenster ***********************/
/* void screenclear() // ausgelagert in xtekplot.cc */

/*** benutzte XWindow Funktionen:
XDrawLine(dpy,win1,gc,x1,y1,x2,y2)
  Display *dpy; Window win1; GC gc; int x1,y1,x2,y2;
XSetDashes(dpy,gc,dashoffset,dashfeld,dashlen)
XSetLineAttributes(dpy,gc,0,LineSolid,CapButt,JoinMiter)
XDrawLine(dpy,win1,gc,x,y,x+dx,y)
XSetFunction(dpy,gc,GXxor)
		    GXequiv
		    GXcopy
XSetClipMask(dpy,gc,pixmap)
pixmap=XCreatePixmap(dpy,drawable,Breite,Hoehe,Tiefe)
			 drawable=win1 oder XRootWindowOfScreen(screen)
XFreePixmap(dpy,pixmap)
***/

#ifdef unix
#define XSYNC2 XSync(dpy,0); millipause(200)
#else
#define XSYNC2 XSync(dpy,0)
#endif
void lower_window() {if(dpy!=NULL) {XLowerWindow(dpy,win1); XSYNC2;}}
void raise_window() {if(dpy!=NULL) {XMapRaised(dpy,win1); XSYNC2;}}

static char *fragefile()
{
 static char name[120];
#ifdef VAX
 printf("('sys$login:vectmal_einst.dat') Filename:"); scanf("%s",name);
#else
#ifdef unix
 printf("('$VECTMALDIR/sys/vectmal_einst.dat') Filename:"); scanf("%s",name);
#else
 printf("('postsys:vectmal_einst.dat') Filename:"); scanf("%s",name);
#endif
#endif
 return name;
}

#ifdef OLDXTEKPLOT
void fensterposition()
{
 int flag;
 if(rambildflag && !initalflag)
	{if(!(flag=refreshflag)) fadenkreuz_aus();
	 XCopyArea(dpy,rambild,win1,gc,0,0,winbreite+1,winhoehe+1,0,0);
	 if(!flag) fadenkreuz_ein();
	 if(help_flag==1) /* X11PROBLEM: Help-Schalter wieder ausschalten */
		{XSync(dpy,0); symbolauswahl(28,2);}
	}
}
#endif

void Fenstertitel(char *str)
{
 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (UBYTE *)str, strlen(str));
}

#ifdef OLDXTEKPLOT
qstroke() {if(plo_i>1) q2plot(0.,0.,4);}
#else
void qstroke() {tek_flush();}
#endif

void getxyborder(int *xborder,int *yborder)
{
 /* es gibt keine XFunktion die diese Werte ermittelt! */
 screenausmasse_ermitteln();
 *xborder=tekplot_xborder; *yborder=tekplot_yborder;
}

/********************** Requester *********************/
GC gc_meldungen=0;

#define PIXPROBUCHST_X 6
#define PIXPROBUCHST_Y 8
#define ZEILENABSTAND 12

int requester(char *text,char *jatext,char *neintext)
{
 int hoehe,breite,ho,br,n1,n2,n3,x,y,x1,y1,x2,y2,x3,y3;
 int x2ul,x2or,y2ul,y2or,x3ul,x3or,y3ul,y3or;/* Grenzen der ja/nein-Boxen */
 int x0,y0,randbreite=5,fogrund,higrund;
 int i,done,antwort;
 char *name="Requester";
 Window win;
 XEvent event;
 KeySym key;
 char txt[10];
 GC gc2;
/* extern Display *dpy; */
 if(winhoehe>winbreite)
	{x0=winbreite+2; y0=20;/*provi*/}
 else	{x0=200; y0=20;}
 n1=strlen(text); n2=strlen(jatext);
 if(neintext) n3=strlen(neintext); else n3=0;
 br=(n2>n3)?n2:n3;
 i=br+br+6;/* je 2 Buchstaben fuer Rand in Box plus 2 fuer Abstand */
 if(n1>i) i=n1;
 breite=(i+2)*PIXPROBUCHST_X+randbreite+randbreite;
 hoehe=breite*3/4;
 br=(br+2)*PIXPROBUCHST_X;
 ho=2*PIXPROBUCHST_Y;
 x1=(breite-n1*PIXPROBUCHST_X)/2; y1=hoehe/3;
 x2ul=breite/4-br/2; x2or=x2ul+br;
 x3ul=breite*3/4-br/2; x3or=x3ul+br;
 y2ul=y3ul=hoehe*2/3-ho/2; y2or=y3or=hoehe*2/3+ho/2;
 if(!neintext) /* bei nur einer Antwort Box in Mitte */
	{x2ul += breite/4; x2or += breite/4;}
 x2=x2ul+PIXPROBUCHST_X; y2=y3=y2or-PIXPROBUCHST_Y/2;
 x3=x3ul+PIXPROBUCHST_X;
 higrund=WhitePixel(dpy,DefaultScreen(dpy));
 fogrund=BlackPixel(dpy,DefaultScreen(dpy));
 win=XCreateSimpleWindow(dpy,DefaultRootWindow(dpy),
		x0, y0, breite, hoehe, randbreite, fogrund, higrund);
 gc2=XCreateGC(dpy,win,0,NULL);
 XSetBackground(dpy,gc2,higrund);
 XSetForeground(dpy,gc2,fogrund);
 XSelectInput(dpy,win, ButtonPressMask|KeyPressMask|ExposureMask);
 XChangeProperty(dpy, win, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (UBYTE *)name, strlen((char *)name));
 XMapRaised(dpy,win);
 for(done=0;done==0;)
  {XNextEvent(dpy,&event);
   if(event.xexpose.window==win) switch(event.type)
   /*XWindowEvent(dpy,win,ButtonPressMask|KeyPressMask|ExposureMask,&event);
   /*switch(event.type)*/
    {case Expose:
	if(event.xexpose.count==0)
	 {XDrawImageString(dpy, win, gc2,x1,y1,text,strlen(text));
	  XDrawImageString(dpy, win, gc2,x2,y2,jatext,strlen(jatext));
	  XDrawRectangle(dpy,win,gc2,x2ul,y2ul,br,ho);
	  if(neintext)
	    {XDrawImageString(dpy,win,gc2,x3,y3,neintext,strlen(neintext));
	     XDrawRectangle(dpy,win,gc2,x3ul,y3ul,br,ho);
	 }  }
     CASE ButtonPress:
	x=event.xbutton.x; y=event.xbutton.y;
	if(x>x2ul && x<x2or && y>y2ul && y<y2or) {antwort=1; done=1;}
	else if(x>x3ul && x<x3or && y>y3ul && y<y3or) {antwort=0; done=1;}
     CASE MappingNotify: XRefreshKeyboardMapping(&event.xmapping);
     CASE KeyPress:
	i=XLookupString(&event.xkey,txt,10,&key,0);
	if(i==1 && *txt== *jatext) {antwort=1; done=1;}
	else if(neintext && i==1 && *txt== *neintext) {antwort=0; done=1;}
    }/* end switch */
  }/* Ende der Eventschlaufe */
 XFreeGC(dpy,gc2);
 XDestroyWindow(dpy,win);
 return antwort;
}

static char *meldungzeile[10];
static int anzahl_meldungzeilen=0;
static int meld_x1,meld_y1;

void meldungrequester(char *text)
{
 int hoehe,breite,ho,br,n1,x,y;
 int x0,y0,breite0,hoehe0,randbreite=5,fogrund,higrund;
 int i,c;
 char *s;
 char *name="VectMal Infos";
 KeySym key;
 char txt[10];
/* extern Display *dpy;
/* extern GC gc_meldungen;
/* extern Window win_meldungen; */
 x0=winbreite+2; y0=0;/* Info-Fenster neben Hauptfenster setzen */
 if(bildschirm_tiefe==1) x0+=3; /* provi. fuer VAXstation 3100 */
 else	x0+=32; /* provi. fuer VAXALPHA */
 breite0=60; hoehe0=winhoehe/ZEILENABSTAND;
 if(s=(char *)calloc(strlen(text)+1,1)) strcpy(s,text);
 else s="zu wenig Speicher";
 if(anzahl_meldungzeilen>0) cfree(meldungzeile[0]);
 for(anzahl_meldungzeilen=c=0; *s && anzahl_meldungzeilen<10; s++)
	{if(c==0) meldungzeile[anzahl_meldungzeilen++]=s;
	 if(*s=='\n') *s=c=0;
	 else c=1;
	}
 n1=breite0; /*strlen(text);*/
 breite=(n1+2)*PIXPROBUCHST_X+randbreite+randbreite;
 hoehe=hoehe0*ZEILENABSTAND;
 meld_x1=(breite-n1*PIXPROBUCHST_X)/2;
 meld_y1=2*ZEILENABSTAND; /* meld_y1=hoehe/3;*/
 higrund=BlackPixel(dpy,DefaultScreen(dpy));
 fogrund=WhitePixel(dpy,DefaultScreen(dpy));
 if(win_meldungen==0)
  {if(x0+breite>bildschirm_breite) x0=bildschirm_breite-breite;
   win_meldungen=XCreateSimpleWindow(dpy,DefaultRootWindow(dpy),
		x0, y0, breite, hoehe, randbreite, fogrund, higrund);
   gc_meldungen=XCreateGC(dpy,win_meldungen,0,NULL);
   XSetBackground(dpy,gc_meldungen,higrund);
   XSetForeground(dpy,gc_meldungen,fogrund);
   XSelectInput(dpy,win_meldungen, ButtonPressMask|ExposureMask);
   XChangeProperty(dpy, win_meldungen, XA_WM_NAME, XA_STRING, 8,
		PropModeReplace, (UBYTE *)name, strlen((char *)name));
   XMapRaised(dpy,win_meldungen);
  }
 else
  {XRaiseWindow(dpy,win_meldungen);
   meldungen_refresh();
  }
 if(anzahl_meldungzeilen==0)
	{XFreeGC(dpy,gc_meldungen);
	 XDestroyWindow(dpy,win_meldungen); win_meldungen=0;
	}
}

void meldungen_refresh()
{
 int i;
 XClearWindow(dpy,win_meldungen);
 for(i=0;i<anzahl_meldungzeilen;i++)
   XDrawImageString(dpy,win_meldungen,gc_meldungen,
		meld_x1,meld_y1+i*ZEILENABSTAND,
		meldungzeile[i],strlen(meldungzeile[i]));
}

/*************** Flaechen fuellen ********************/
#define FILLMAXPOINTS 8000
static XPoint fillpoints[FILLMAXPOINTS];
int fillstyle=FillSolid, linestyle=LineSolid, linecolor;

static int fillnum=0;

void fillpoly(int methode)
{
 int fillrule;
 if(methode==1) fillrule=WindingRule; else fillrule=EvenOddRule;
 if(fillpwin==win1)
   {XSetFillRule(dpy,gc,fillrule);
    XFillPolygon(dpy,fillpwin,gc,fillpoints,fillnum,Complex,CoordModeOrigin);
   }
 else
   {XSetForeground(dpy,gc_clipmask,tek_farbe==0?0:1);
    XSetFillRule(dpy,gc_clipmask,fillrule);
    XFillPolygon(dpy,fillpwin,gc_clipmask,
		 fillpoints,fillnum,Complex,CoordModeOrigin);
   }
/* XSync(dpy,0);*/
 fillnum=0;
}

void fillplot(double x,double y,int pen)
{
 int x2,y2;
 umrech(x,y,&x2,&y2);
 fillpoints[fillnum].x=x2; fillpoints[fillnum].y=y2;
 if(fillnum<FILLMAXPOINTS-1) fillnum++;
 else {printf("Fehler in fill: zu viele Punkte\n");}
}

#define FUELLBR 32	/* Breite */
#define FUELLHO 4	/* Hoehe */
#define FUELLTI 1	/* Tiefe */
#define NFARB 8
static Pixmap fuellmuster[NFARB];
static int fuellmuster_flag=0;
#ifndef OLDXTEKPLOT
extern int hintergrundflag;
#endif
static ulong
	fuelldata0[]={0,0,0,0},
	fuelldata1[]={0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF},
	fuelldata2[]={0xBBBBBBBB, 0xEEEEEEEE, 0x77777777, 0xDDDDDDDD},
	fuelldata3[]={0xDDDDDDDD, 0xAAAAAAAA, 0x77777777, 0xAAAAAAAA},
	fuelldata4[]={0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA},
	fuelldata5[]={0x44444444, 0x20202020, 0x88888888, 0x02020202},
	fuelldata6[]={0x11111111, 0x00000000, 0x44444444, 0x00000000},
	fuelldata7[]={0x01010101, 0x00000000, 0x10101010, 0x00000000},
	*fuelldata[]={fuelldata0,fuelldata1,fuelldata2,fuelldata3,
			fuelldata4,fuelldata5,fuelldata6,fuelldata7};

#define dept tekplot_tiefe

void fuellmuster_setzen()
{
 int i;
 if(dept==1)
  for(i=0;i<NFARB;i++)
    fuellmuster[i]=XCreatePixmapFromBitmapData(dpy,win1,(char *)(fuelldata[i]),
		    FUELLBR,FUELLHO,vordergrundfarbe,hintergrundfarbe,FUELLTI);
 fuellmuster_flag=1;
}

Pixmap getfuellmuster(int nr)
{
 if(fuellmuster_flag==0) fuellmuster_setzen();
 if(hintergrundflag==0) {if(nr>1) nr=NFARB+1-nr; else nr=1-nr;}
 return fuellmuster[nr];
}

int grauwert2farbnummer(double grauwert)
{
 int i;
 i=NFARB-(int)(grauwert*NFARB)-1;
 if(i>=NFARB) i=NFARB-1;
 else if(i<0) i=0;
 if(i>0) i=NFARB-i;
 return i;
}

/*************************** Farben ****************************/
void farben_init()
{
 int i;
 DEBUG(1,printf("farben_init() hintergrundflag=%d\n",hintergrundflag));
 if(hintergrundflag==0)
   for(i=0;i<8;i++)
	{rgbtabelle[i][0]=255-rgbtabelle[i][0];
	 rgbtabelle[i][1]=255-rgbtabelle[i][1];
	 rgbtabelle[i][2]=255-rgbtabelle[i][2];
	}
 farbtabelle_erstellen();
}

double RGB2grau(int r,int g,int b)
{
 double grau;
 grau=(2*r+2.5*g+b)/(5.5*255.);
 if(grau>1.) grau=1.; else if(grau<0.) grau=0.;
 return grau;
}

void farbe_setzen(int farbnr)
{
 DEBUG(2,printf("farbe_setzen(%d)\n",farbnr));
 if(dept>1)
  {color(linecolor=farbnr);
   fadenkreuzfarbesetzen(colortabelle[linecolor].pixel);
  }
 else
  {int nr,r,g,b;
   r=rgbtabelle[farbnr][0]; g=rgbtabelle[farbnr][1]; b=rgbtabelle[farbnr][2];
   nr=grauwert2farbnummer(RGB2grau(r,g,b));
   if(nr<=1)
	{fillstyle=FillSolid;
/*	 if((hintergrundflag==0 && nr==1) || (hintergrundflag==1 && nr==0)) */
	 if(hintergrundflag+nr==1)
		linecolor=0;
	 else	linecolor=1;
	}
   else	{Pixmap pix;
	 linecolor=1; fillstyle=FillTiled;
	 XSetTile(dpy,gc,pix=getfuellmuster(nr));
	 XSetTile(dpy,fadenkreuz_gc,pix);
	}
   color(linecolor);
   fadenkreuzfarbesetzen(colortabelle[1].pixel);
   XSetFillStyle(dpy,gc,fillstyle);
   XSetFillStyle(dpy,fadenkreuz_gc,fillstyle);
  }
}

int set_color(int farbnr,int farbsys,
		int rhc,int gsm,int bby,int k,int* r,int* g,int* b)
{
 int rot,gruen,blau;
 DEBUG(2,printf("set_color(%d,r=%d,g=%d,b=%d)\n",farbnr,rhc,gsm,bby));
 if(farbnr<=1)
   {printf("Veraendern der Farben 0 und 1 nicht erlaubt !\n"); return farbnr;}
 switch(farbsys)
   {case RGB:	rot=rhc; gruen=gsm; blau=bby;
    CASE HSB:	hsb2rgb(rhc/255.,gsm/255.,bby/255.,&rot,&gruen,&blau);
    CASE CMYK:	rot=(255-rhc-k); gruen=(255-gsm-k); blau=(255-bby-k);
    DEFAULT:	printf("Fehler in set_color: unbekanntes farbsys:%d\n",farbsys);
   }
 DEBUG(2,printf("rot=%d gruen=%d blau=%d\n",rot,gruen,blau));
 if(r!=NULL) {*r=rot; *g=gruen; *b=blau;}
 if(hintergrundflag==0 &&
    (farbnr<8 || (farbnr==MAXXFARB-1 && rot==gruen && rot==blau)))
	rot=gruen=blau=255-rot;/*wenn Hintergrund schwarz: Grauwerte umkehren*/
 rgbtabelle[farbnr][0]=rot; rgbtabelle[farbnr][1]=gruen;
 rgbtabelle[farbnr][2]=blau;
 if(dept>1) setcolor(farbnr,rot,gruen,blau);
 return farbnr;
}

double get_color(int farbnr,int* r,int* g,int* b) /* Rueckgabewert=Grauwert */
{
 if(hintergrundflag==0 && farbnr<8)
 {*r=255-rgbtabelle[farbnr][0];
  *g=255-rgbtabelle[farbnr][1]; *b=255-rgbtabelle[farbnr][2];
 }
 else
 {*r=rgbtabelle[farbnr][0]; *g=rgbtabelle[farbnr][1]; *b=rgbtabelle[farbnr][2];}
 DEBUG(2,printf("get_color(%d,r=%d,g=%d,b=%d)\n",farbnr,*r,*g,*b));
 return RGB2grau(*r,*g,*b);
}
double get_gray(int farbnr)
{
 int r,g,b;
 return get_color(farbnr,&r,&g,&b);
}

void hsb2rgb(double h,double s,double b,int *R,int *G,int *B)
{
 int y0,y1;
 double h6,dy;
/* if(testflag) s=s*s; */
 y0=(int)((1.-s)*b*256.);
 y1=(int)(b*256.);
 dy=(double)(y1-y0);
 h6=h*6.;
 switch((int)h6)
	{case 0: *R=y1; *B=y0; *G=y0+(int)(dy*sin(PIHALBE*h6));
	 CASE 1: *G=y1; *B=y0; *R=y0+(int)(dy*sin(PIHALBE*(2.-h6)));
	 CASE 2: *G=y1; *R=y0; *B=y0+(int)(dy*sin(PIHALBE*(h6-2.)));
	 CASE 3: *B=y1; *R=y0; *G=y0+(int)(dy*sin(PIHALBE*(4.-h6)));
	 CASE 4: *B=y1; *G=y0; *R=y0+(int)(dy*sin(PIHALBE*(h6-4.)));
	 CASE 5:
	 default: *R=y1; *G=y0; *B=y0+(int)(dy*sin(PIHALBE*(6.-h6)));
	}
 if(*R<0) *R=0; else if(*R>255) *R=255;
 if(*G<0) *G=0; else if(*G>255) *G=255;
 if(*B<0) *B=0; else if(*B>255) *B=255;
}

/*************** Clipping ********************/
int getclipmask()
{
 Pixmap clipmask;
 clipmask=XCreatePixmap(dpy,win1,winbreite+1,winhoehe+1,1);
/* Die Tiefe muss 1 sein! (auch wenn die Zeichentiefe groesser ist) */
/* DEBUG(1,printf("getclipmask()=%d\n",clipmask));/*test*/
 if(gc_clipmask==0)
	{gc_clipmask=XCreateGC(dpy,clipmask,0,NULL);
	}
 return clipmask;
}
void freeclipmask(Pixmap clipmask)
{
/* DEBUG(1,printf("freeclipmask(%d)\n",clipmask));/* test */
 XFreePixmap(dpy,clipmask);
}

/* #define None 0L  /*sollte schon in xlib.h gemacht sein */

void draw_in_clip(Pixmap clipmask)
{
 XSetClipMask(dpy,gc,None);
 fillpwin=clipmask;
}
void draw_in_window(Pixmap clipmask)
{
 fillpwin=win1;
 XSetClipMask(dpy,gc,clipmask);
}

void clearclipmask(Pixmap clipmask)
{
/* Pixmap clipmask=(Pixmap)iclipmask; */
// DEBUG(1,printf("clearclipmask(%d)\n",clipmask));
 XSetClipMask(dpy,gc,None);
 XSetForeground(dpy,gc_clipmask,0);
 XFillRectangle(dpy,clipmask,gc_clipmask,0,0,winbreite+1,winhoehe+1);
}

void hintergrundfarbe_setzen(int farbe)
{
/* DEBUG(1,printf("hintergrundfarbe_setzen(%d)\n",farbe));/* test */
 if(farbe==0)
	{XSetForeground(dpy,gc,vordergrundfarbe=1);
	 XSetBackground(dpy,gc,hintergrundfarbe=0);
	}
 else	{XSetForeground(dpy,gc,vordergrundfarbe=0);
	 XSetBackground(dpy,gc,hintergrundfarbe=1);
	}
 fadenkreuzfarbesetzen(vordergrundfarbe,hintergrundfarbe);
}

/*************** Linienstil ********************/
/**
static XGCValues gcval;

setlinestyle(int stil)
{
 int alterstil;
 alterstil=gcval.line_style;
 gcval.line_style=stil;
 XChangeGC(dpy,gc,GCLineStyle,&gcval);
 return alterstil;
}
**/

/****************** toggle-Menus auswerten *****************/
void farbsystem_setzen(int n)
{
 farbsystem=n;
}

void bruprev_setzen(int n)
{
 brushpreview=n;
 if(n==0) entfernepixelbild();
}

void sprache_setzen(int n)
{
 sprache=n;
 lower_window();
 if(n==DEUTSCH)
	{printf("deutsches Men beim nchsten Starten aktiv\n");
	}
   else	{printf("english version of menu will be active at next start.\n");
 	}
 millipause(3000); /* 3 Sekunden (= 1 Augenblick)  warten */
 raise_window();
}

/************************** Mauszeiger *************************/
static Pixmap cursorpix,cursormaskpix;
static Cursor cursor=0;
static long cursor_num=0; //Nummer zur eindeutigen Identifizierung eines Cursors

void cursor_reset()
{
 if(cursor==0) return;
 XUndefineCursor(dpy,win1); XFreeCursor(dpy,cursor);
 XFreePixmap(dpy,cursorpix); XFreePixmap(dpy,cursormaskpix);
 cursor=0; cursor_num=0;
}
void cursor_setzen(char *dat1,char *dat2,uint breite,uint hoehe,
			uint hotx,uint hoty)
{
 int br,ho,erfolg, vo,hi;
 long num=long(dat1)+long(dat2)+breite+hoehe+(hotx<<4)+(hoty<<8);
 if(cursor_num==num) return;//dieser Cursor wird schon dargestellt
 if(cursor!=0) cursor_reset();
 erfolg=XQueryBestCursor(dpy,win1,breite,hoehe,(uint*)&br,(uint*)&ho);
 if(br<breite || ho<hoehe)
	{printf("XQueryBestCursor(%d,%d) --> %d,%d  erfolg=%d\n",
			breite,hoehe,br,ho,erfolg);
	}
 if(ist_weiss_null())	{vo=hintergrundfarbe; hi=vordergrundfarbe;}
 else			{vo=vordergrundfarbe; hi=hintergrundfarbe;}
 cursorpix=XCreatePixmapFromBitmapData(dpy,win1,dat1,breite,hoehe,vo,hi,1);
 cursormaskpix=XCreatePixmapFromBitmapData(dpy,win1,dat2,breite,hoehe,vo,hi,1);
 cursor=XCreatePixmapCursor(dpy,cursorpix,cursormaskpix,
				&colortabelle[1],colortabelle,hotx,hoty);
 XDefineCursor(dpy,win1,cursor);
 cursor_num=num;
}

/******************** Pixelbilder fuer Brushdarstellung *******************/
extern int faden_x,faden_y,bru_dx,bru_dy,bru_winkel;
extern int leim_dx,leim_dy,leim_winkel,fadenkreuz_typ;
extern int lupe_i;
extern double lupe_faktor[];
#define LEIM    10

#define PLANEMASKE 1L

Pixmap pixbru=0;
uint	pix_breite,pix_hoehe,/* Orginale Breite und Hoehe */
	pixbreite,pixhoehe, /* aktuelle Breite und Hoehe */
	pixtiefe=1;
UBYTE	*pixelbild_data,   /* Pixelbild in Orginalgroesse */
	*pixdata=NULL;	  /* Pixelbild in aktueller Groesse */
int	pixaktiv=1,
	pixwinkel=0;	/* Drehwinkel */

UBYTE invers[256]=
 {0x00,0x80,0x40,0xC0,0x20,0xA0,0x60,0xE0,0x10,0x90,0x50,0xD0,0x30,0xB0,0x70,
  0xF0,0x08,0x88,0x48,0xC8,0x28,0xA8,0x68,0xE8,0x18,0x98,0x58,0xD8,0x38,0xB8,
  0x78,0xF8,0x04,0x84,0x44,0xC4,0x24,0xA4,0x64,0xE4,0x14,0x94,0x54,0xD4,0x34,
  0xB4,0x74,0xF4,0x0C,0x8C,0x4C,0xCC,0x2C,0xAC,0x6C,0xEC,0x1C,0x9C,0x5C,0xDC,
  0x3C,0xBC,0x7C,0xFC,0x02,0x82,0x42,0xC2,0x22,0xA2,0x62,0xE2,0x12,0x92,0x52,
  0xD2,0x32,0xB2,0x72,0xF2,0x0A,0x8A,0x4A,0xCA,0x2A,0xAA,0x6A,0xEA,0x1A,0x9A,
  0x5A,0xDA,0x3A,0xBA,0x7A,0xFA,0x06,0x86,0x46,0xC6,0x26,0xA6,0x66,0xE6,0x16,
  0x96,0x56,0xD6,0x36,0xB6,0x76,0xF6,0x0E,0x8E,0x4E,0xCE,0x2E,0xAE,0x6E,0xEE,
  0x1E,0x9E,0x5E,0xDE,0x3E,0xBE,0x7E,0xFE,0x01,0x81,0x41,0xC1,0x21,0xA1,0x61,
  0xE1,0x11,0x91,0x51,0xD1,0x31,0xB1,0x71,0xF1,0x09,0x89,0x49,0xC9,0x29,0xA9,
  0x69,0xE9,0x19,0x99,0x59,0xD9,0x39,0xB9,0x79,0xF9,0x05,0x85,0x45,0xC5,0x25,
  0xA5,0x65,0xE5,0x15,0x95,0x55,0xD5,0x35,0xB5,0x75,0xF5,0x0D,0x8D,0x4D,0xCD,
  0x2D,0xAD,0x6D,0xED,0x1D,0x9D,0x5D,0xDD,0x3D,0xBD,0x7D,0xFD,0x03,0x83,0x43,
  0xC3,0x23,0xA3,0x63,0xE3,0x13,0x93,0x53,0xD3,0x33,0xB3,0x73,0xF3,0x0B,0x8B,
  0x4B,0xCB,0x2B,0xAB,0x6B,0xEB,0x1B,0x9B,0x5B,0xDB,0x3B,0xBB,0x7B,0xFB,0x07,
  0x87,0x47,0xC7,0x27,0xA7,0x67,0xE7,0x17,0x97,0x57,0xD7,0x37,0xB7,0x77,0xF7,
  0x0F,0x8F,0x4F,0xCF,0x2F,0xAF,0x6F,0xEF,0x1F,0x9F,0x5F,0xDF,0x3F,0xBF,0x7F,
  0xFF
 };

#define ONU 1 /* von Oben Nach Unten */
#define UNO 2 /* von Unten Nach Oben */

void umsortieren(UBYTE *data,UBYTE *pixdata,int breite,int bytesprozeile,
		 int nzeilen,int byteorder,int lineorder,int iscomplement)
{
 int i,j,breite8,gump;
#ifdef M_LSBFIRST
 int neworder=LSBFirst;
#else
 int neworder=MSBFirst;
#endif
 int newlineorder=UNO;
 breite8=(breite+7)/8;
 gump=bytesprozeile-breite8;
 if(debug)
  {printf("Testpunkte in umsortieren()\n");
   printf("byteorder=%d neworder=%d gump=%d  (LSBFirst=%d MSBFirst=%d)\n",
		byteorder,neworder,gump, LSBFirst,MSBFirst);
   printf("lineorder=%d newlineorder=%d  (1=ONU, 2=UNO)  iscomplement=%d\n",
		lineorder,newlineorder,iscomplement);
  }
 if(newlineorder!=lineorder)
	{gump -= (bytesprozeile<<1);
	 data = &data[(nzeilen-1)*bytesprozeile];
//	 printf("oben-unten-Umkehr\n");//test
	}
 if(iscomplement)
 {if(neworder!=byteorder)
   {for(j=0;j<nzeilen;j++,data+=gump)
      for(i=0;i<breite8;i++)  *pixdata++ = (invers[*data++] ^ 0xFF);
   }
  else	// nur kopieren
   {for(j=0;j<nzeilen;j++,data+=gump)
     for(i=0;i<breite8;i++)  *pixdata++ = (*data++ ^ 0xFF);
   }
 }
 else
 {if(neworder!=byteorder)
   {for(j=0;j<nzeilen;j++,data+=gump)
      for(i=0;i<breite8;i++)  *pixdata++ = invers[*data++];
   }
  else	// nur kopieren
   {for(j=0;j<nzeilen;j++,data+=gump)
     for(i=0;i<breite8;i++)  *pixdata++ = *data++;
   }
 }
}

void entfernepixelbild()
{
 if(pixbru!=0)
	{XFreePixmap(dpy,pixbru); pixbru=0;
	 if(pixdata!=pixelbild_data) cfree(pixdata);
	 cfree(pixelbild_data);
	}
}

void machpixelbild(UBYTE *data,int breite,int hoehe,int tiefe)
{
 int i,j,jmax,breite8;
 char *s1,*s2,h1;
// DEBUG(1,printf("machpixelbild(tief=%d)\n",tiefe));/* test */
 if(tiefe!=1) {printf("machpixelbild(tiefe=%d) geht bisher nur mit tiefe=1\n",
			tiefe);/* provi. */
	       tiefe=1;
	      }
 pix_breite=breite; pix_hoehe=hoehe; pixtiefe=tiefe;
 breite8=(breite+7)/8; jmax=breite8*hoehe*tiefe;
 entfernepixelbild();
 if(!(pixelbild_data=(UBYTE *)calloc(jmax,1))) return;
 umsortieren(data,pixelbild_data,breite,breite8,hoehe,MSBFirst,ONU,
		hintergrundfarbe!=0);
 pixelbild_zerren(bru_dx,bru_dy,bru_winkel);
}

void pixelbild_zerren(int breite,int hoehe,int winkel)
{
 int jmax;
// DEBUG(1,printf("pixelbild_zerren(%d,%d,%d)\n",breite,hoehe,winkel));
 if(pixbru!=0) {XFreePixmap(dpy,pixbru); pixbru=0;}
 if(pixdata) cfree(pixdata);
 pixbreite=breite; pixhoehe=hoehe;
 if((pixwinkel=winkel)!=0)
	{pixdata=bilddrehen(winkel,&pixbreite,&pixhoehe);
	 if(pixdata==NULL) return;
	}
 else	{jmax=((breite+7)>>3)*hoehe*pixtiefe;
	 if(!(pixdata=(UBYTE *)calloc(jmax,1))) return;
	 vergroessern(pixelbild_data,pix_breite,pix_hoehe,
				pixdata,pixbreite,pixhoehe);
	}
/* if(pixtiefe==1) */
 pixbru=XCreatePixmapFromBitmapData(dpy,win1,(char*)pixdata,pixbreite,pixhoehe,
				vordergrundfarbe,hintergrundfarbe,dept);
/* else printf("pixtiefe geht bisher nur mit 1\n"); */
 if(pixbru==0) printf("Fehler in XCreatePixmapFromBitmapData()\n");
}

void zeigpixelbild(int bx,int by)
{
 int xoffset,yoffset;
 xoffset=pixbreite/2; yoffset=pixhoehe/2;/* provi */
 if(pixbru) XCopyArea(dpy,pixbru,win1,pixbru_gc,0,0,pixbreite,pixhoehe,
			bx-xoffset,by-yoffset);
 else printf("kein pixelbild vorhanden\n");/* test */
}

void pixelbild_ausschalten()
{
 if(pixbru==0) return;
 fadenkreuz(faden_x,faden_y);
 pixaktiv=0;
 fadenkreuz(faden_x,faden_y);
}
void pixelbild_ein()
{
 if(pixbru==0) return;
 int dx,dy;
 if(argflag['Q']) {dx=bru_dy; dy=bru_dx;} else {dx=bru_dx; dy=bru_dy;}
 if(dx!=pixbreite || dy!=pixhoehe || bru_winkel!=pixwinkel)
  {if(lupe_i==0) pixelbild_zerren(dx,dy,bru_winkel);
   else	{double f=lupe_faktor[lupe_i];
	 pixelbild_zerren(idfix(dx*f),idfix(dy*f),bru_winkel);
  }	}
 pixaktiv=1;
}
void pixelbild_einschalten()
{
 if(pixbru==0) return;
 fadenkreuz(faden_x,faden_y);
 pixelbild_ein();
 fadenkreuz(faden_x,faden_y);
}

int pixelbild_ok()
{
 return (pixbru!=0 && pixaktiv);
}

#ifdef M_SHIFTLEFT
#define SHIFT <<
#define SHIFTGLEICH <<=
#define STARTMASK 0x01
#else
#define SHIFT >>
#define SHIFTGLEICH >>=
#define STARTMASK 0x80
#endif

void vergroessern(UBYTE *abild,int abreite,int ahoehe,
		  UBYTE *bild,int breite,int hoehe)
{
 int jy2,jx,ix,abreit8,breite2,hoehe2,abreite2,abreite2breite;
 UBYTE *p,*ip,jmask;
 DEBUG(1,printf("vergroessern(abild,abreite=%d,ahoehe=%d, bild,%d,%d)\n",
		abreite,ahoehe,breite,hoehe));/* test */
 abreit8=(abreite+7)>>3;
 hoehe2=hoehe+hoehe; breite2=breite+breite;
 abreite2=abreite+abreite;
 abreite2breite=abreite2*breite;
 for(jy2=0,p=bild;jy2<hoehe2;jy2+=2)
  {ip = &abild[((jy2+1)*ahoehe)/hoehe2*abreit8];
   for(jx=abreite,jmask=STARTMASK,*p=0;;)
	{ix=jx/breite2;
	 if(ip[ix>>3]&(STARTMASK SHIFT(ix&7)))  *p |= jmask;
	 if((jx+=abreite2)>abreite2breite) break;
	 if((jmask SHIFTGLEICH 1)==0) {jmask=STARTMASK; *++p=0;}
	}
   p++;
  }
}

#ifdef M_SHIFTLEFT
#define RICHTUNG (-1)
#else
#define RICHTUNG 1
#endif

UBYTE *bilddrehen(int winkel,uint *pbreite,uint *phoehe)
{
 int x,y,x1,y1,bytesprozeile,br8;
 uint breite,hoehe;
 UBYTE *data,*p,*ip,jmask;
 double mx,my,sina,cosa,alfa,xdreh,ydreh,mxhalbe,myhalbe,nxdurchmx,nydurchmy;
 double breite_xdreh,hoehe_ydreh;/* Variablen fuer optimierte Variante */
 mx= *pbreite; my= *phoehe; mxhalbe=mx/2.; myhalbe=my/2.;
 sina=sin(alfa=RICHTUNG*winkel*GRAD); cosa=cos(alfa);
 breite=(uint)(fabs(mx*cosa)+fabs(my*sina)+1.0); xdreh=breite/2.;
 hoehe=(uint)(fabs(mx*sina)+fabs(my*cosa)+1.0);  ydreh=hoehe/2.;
 nxdurchmx=pix_breite/mx;
 nydurchmy=pix_hoehe/my;
 *pbreite=breite; *phoehe=hoehe;
 bytesprozeile=(breite+7)>>3;
 if(!(data=(UBYTE *)calloc(hoehe*bytesprozeile,1))) return NULL;
 ip=pixelbild_data; br8=(pix_breite+7)>>3;
/* DEBUG(1,printf("pix_breite=%d _hoehe=%d  breite=%d hoehe=%d\n",
		pix_breite,pix_hoehe,breite,hoehe));/* test */
/** uebersichtliche Schlaufen: **/
 for(y=0,p=data;y<hoehe;y++)
  for(x=0,jmask=STARTMASK,*p=0;;)
	{x1=(int)(((x-xdreh)*cosa+(y-ydreh)*sina+mxhalbe)*nxdurchmx);
	 y1=(int)(((y-ydreh)*cosa-(x-xdreh)*sina+myhalbe)*nydurchmy);
	 if(x1>=0 && x1<pix_breite && y1>=0 && y1<pix_hoehe)
		if(ip[(x1>>3)+y1*br8]&(STARTMASK SHIFT(x1&7)))  *p |= jmask;
	 if(++x==breite) {p++; break;}
	 if((jmask SHIFTGLEICH 1)==0) {jmask=STARTMASK; *++p=0;}
	} /**/
/** optimierte Schlaufen: **
 breite_xdreh=breite-xdreh;
 hoehe_ydreh=hoehe-ydreh;
 for(y= -ydreh,p=data;y<hoehe_ydreh;y++)
  for(x= -xdreh,jmask=STARTMASK,*p=0;;)
	{x1=(int)((x*cosa+y*sina+mxhalbe)*nxdurchmx);
	 y1=(int)((y*cosa-x*sina+myhalbe)*nydurchmy);
	 if(x1>=0 && x1<pix_breite && y1>=0 && y1<pix_hoehe)
		if(ip[(x1>>3)+y1*br8]&(STARTMASK SHIFT(x1&7)))  *p |= jmask;
	 if(++x==breite_xdreh) {p++; break;}
	 if((jmask SHIFTGLEICH 1)==0) {jmask=STARTMASK; *++p=0;}
	} /**/
 return data;
}

void window2pixelbild(int x0,int y0,int breite,int hoehe)
{
 int tiefe;
 XImage *ximag;
/* DEBUG(1,printf("window2pixelbild(x0=%d, y0=%d, breite=%d, hoehe=%d)\n",
	x0,y0,breite,hoehe));/* test */
 if(breite<0) breite= -breite;
 if(hoehe<0) hoehe= -hoehe;
 ximag=XGetImage(dpy,win1,x0,y0,breite,hoehe,PLANEMASKE,XYPixmap);
 if(ximag==NULL) printf("FEHLER in window2pixelbild() ximag ist leer\n");
/* Test: */
 if(debug)
 {printf("ximag->data=%06X  ximag->width=%d  ximag->height=%d  ximag->depth=%d\n",
		ximag->data,ximag->width,ximag->height,ximag->depth);
  printf("XYPixmap=%d XYBitmap=%d ZPixmap=%d  LSBFirst=%d MSBFirst=%d\n",
	XYPixmap,XYBitmap,ZPixmap,LSBFirst,MSBFirst);
  printf("ximag->xoffset=%d,ximag->format=%d,ximag->byte_order=%d\n",
	ximag->xoffset,ximag->format,ximag->byte_order);
  printf("ximag->bitmap_unit=%d _bit_order=%d _pad=%d  bytes_per_line=%d bits_per_pixel=%d\n",
	ximag->bitmap_unit,ximag->bitmap_bit_order,ximag->bitmap_pad,
	ximag->bytes_per_line,ximag->bits_per_pixel);
 }
/* :test */
 machpixelbild_ausimag(ximag,ximag->width,ximag->height,1);
}

void machpixelbild_ausimag(XImage *imag,int breite,int hoehe,int tiefe)
{
 int i,j,jmax,breite8;
 char *s1,*s2,h1;
 pix_breite=breite; pix_hoehe=hoehe; pixtiefe=tiefe;
 breite8=(breite+7)/8; jmax=breite8*hoehe*tiefe;
 entfernepixelbild();
 if(!(pixelbild_data=(UBYTE *)calloc(jmax,1))) return;
// DEBUG(1,printf("machpixelbild_ausimag(tief=%d)\n",tiefe));//test
 umsortieren((UBYTE*)imag->data,pixelbild_data,breite,imag->bytes_per_line,
		hoehe,imag->bitmap_bit_order,UNO,0);
 pixelbild_zerren(bru_dx,bru_dy,bru_winkel);
}

void screenausmasse_ermitteln()
{
 if(tekplot_borderflag==0)
   getmaxsize(&bildschirm_breite,&bildschirm_hoehe,
		&bildschirm_tiefe,&bildschirm_visualklasse);
}

/************************** Auswahlfenster **************************/
Window auswahl_win=0;
GC auswahl_gc;
int auswahl_higrund,auswahl_fogrund;
static long auswahl_emask=ExposureMask|ButtonPressMask|ButtonReleaseMask;

void create_auswahlfenster()
{
 if(auswahl_win!=0) return;
 DEBUG(1,printf("create_auswahlfenster()\n"));
 auswahl_higrund=hintergrundfarbe;
 auswahl_fogrund=vordergrundfarbe;
 auswahl_win=XCreateSimpleWindow(tekplot_dpy,tekplot_win,0,menubalkenhoehe,
			RAND,tekplot_hoehe,0,auswahl_fogrund,auswahl_higrund);
 auswahl_gc=XCreateGC(tekplot_dpy,auswahl_win,0,NULL);
 XSetBackground(tekplot_dpy,auswahl_gc,auswahl_higrund);
 XSetForeground(tekplot_dpy,auswahl_gc,auswahl_fogrund);
 XSelectInput(tekplot_dpy,auswahl_win,auswahl_emask);
 XMapRaised(tekplot_dpy,auswahl_win);
 XLowerWindow(tekplot_dpy,auswahl_win);
 symbolezeichnen(auswahl_win,auswahl_gc);
 XSync(tekplot_dpy,0);
}

void auswahl_color(int farbe)
{
 XSetForeground(tekplot_dpy,auswahl_gc,colortabelle[farbe].pixel);
}

void auswahl_rechteckfill(int x1,int y1,int x2,int y2,int farbe)
{
 int h;
 if(x2<x1) {h=x2; x2=x1; x1=h;}
 if(y2<y1) {h=y2; y2=y1; y1=h;}
 if(dept==1)
  {auswahl_color(1);
   h=grauwert2farbnummer(RGB2grau(rgbtabelle[farbe][0],
				rgbtabelle[farbe][1],rgbtabelle[farbe][2]));
   XSetTile(dpy,auswahl_gc,getfuellmuster(h));
   XSetFillStyle(dpy,auswahl_gc,FillTiled);
  }
 else
  {auswahl_color(farbe);
  }
 XFillRectangle(dpy,auswahl_win,auswahl_gc,x1,y1,x2-x1,y2-y1);
 if(dept==1) XSetFillStyle(dpy,auswahl_gc,FillSolid);
 XSetForeground(tekplot_dpy,auswahl_gc,auswahl_fogrund);
}

/*************************** Hauptwarteschlaufe *************************/
#ifndef OLDXTEKPLOT
typedef int (*prediczeiger)(Display *display,XEvent *event,char* args);
static int predicate(Display* display,XEvent* event,long args)
{
 return (event->xexpose.window==args && event->type==MotionNotify);
}
//static predicate2(Display* display,XEvent* event,long args)
//{return (event->xexpose.window==args && event->type==Expose);}

void astprog()
{
 int x,y;
 static XEvent event;
 static long emask=ExposureMask|ButtonPressMask|ButtonReleaseMask|
		   PointerMotionMask;
 if(XCheckWindowEvent(dpy,win1,emask,&event))
    {x=event.xbutton.x; y=event.xbutton.y;
     switch(event.type)
	{case ButtonPress:      klick(1,x,y,event.xbutton.button); break;
	 case ButtonRelease:    klick(0,x,y,event.xbutton.button); break;
	 case Expose:		//while(XCheckIfEvent(dpy,&event,
				//		    (prediczeiger)predicate2,
				//		    (char *)win1))  ;
				//fensterposition();
				break;
	 case MotionNotify:	while(XCheckIfEvent(dpy,&event,
						(prediczeiger)predicate,
						(char *)win1))  ;
				bewegung(event.xbutton.x,event.xbutton.y);
				break;
	 case GraphicsExpose:	DEBUG(1,printf("win1 GraphicsExpose\n")); break;
	 case NoExpose:		DEBUG(2,printf("win1 NoExpose\n")); break;
	 default:		printf("event.type=%d\n",event.type);
	}
    }
 else if(XCheckWindowEvent(dpy,win_meldungen,emask,&event))
    {meldungen_refresh();
    }
// if(plo_i==plo_i_alt && plo_i>1) q2plot(0.,0.,4);
// else {plo_i_alt=plo_i_a; plo_i_a=plo_i;}
}
#endif

void menu_loop()
{
 XEvent event;
 int x,y;
 for(;;)
  {
#ifndef OLDXTEKPLOT
   astprog();
#endif
   waitmenu(0);
   while(XCheckWindowEvent(tekplot_dpy,auswahl_win,auswahl_emask,&event))
     switch(event.type)
	{case Expose:
		if(event.xexpose.count==0)
			symbolezeichnen(auswahl_win,auswahl_gc);
	 CASE ButtonPress:
		klick(1,event.xbutton.x,
			event.xbutton.y+menubalkenhoehe,event.xbutton.button);
	 CASE ButtonRelease:
		klick(0,event.xbutton.x,
			event.xbutton.y+menubalkenhoehe,event.xbutton.button);
	}
   Delay(2);
  }
}

/******************** ab Version 0.65 *******************/
int ist_weiss_null()  //ok wenn Weisse Farbe der Nummer 0 entspricht
{
 if(argflag['W']) return (hintergrundfarbe==0);
 return (vordergrundfarbe==0);
}

int event_invers(int n) //Byte umkehren (erstes Bit wird letztes Bit)
{
#ifdef VAX
 return invers[n];
#else
 return n;
#endif
}

void wo_sind_wir() //test
{
 int n1,flg=0;
 printf("wo_sind_wir()  versuche Rechner und Terminaltyp zu ermitteln\n");
 printf(" ist_weiss_null() --> %d\n",n1=ist_weiss_null());
#ifdef VAX
 printf("Rechner ist VAX oder ALPHA\n");
#else
#ifdef unix
 printf("Rechner ist eine UNIX-Maschine ...");
 if(sizeof(long)==8) printf("vermutlich OSF1-Alpha (pcihenri)\n");
 else printf("vielleicht IBM AIX 6000 (rzuaix)\n");
#endif
#endif
 if(!dpy) {dpy=XOpenDisplay(""); flg=1;}
 printf("Terminal ist ");
 if((n1=BlackPixel(dpy,DefaultScreen(dpy)))==1) printf("vermutlich HENRI\n");
 else if(n1==255) printf("vermutlich MAC oder ZUSE oder VAX\n");
 else printf("??  BlackPixel()=%d\n",n1);
 printf("WhitePixel()=%d\n",WhitePixel(dpy,DefaultScreen(dpy)));
 if(flg) {XCloseDisplay(dpy); dpy=0;}
 printf("ende wo_sind_wir()\n");
}

/************************* Vectmal-Objekt-EDitor ************************/
static Drawable voedrambild=0;
extern Screen *tekplot_screen;

void make_voedrambild()
{
 uint br=winbreite,ho=winhoehe;
 int dept=XDefaultDepthOfScreen(tekplot_screen);
 // printf("voed_makerambild()  br=%d ho=%d dept=%d\n",br,ho,dept);//test
 if(voedrambild==0)
   voedrambild=XCreatePixmap(dpy,win1,br,ho,dept);
 XCopyArea(dpy,win1,voedrambild,gc,0,0,br,ho,0,0);
 XSync(dpy,0);
}

void screenclearweiss()
{
 XCopyArea(dpy,voedrambild,win1,gc,0,0,(uint)winbreite,(uint)winhoehe,0,0);
}

#define INCLUDED_FROM_VECTMAL_HARD
#ifdef VERSION
#undef VERSION
#endif
#include "voed.cc"

void start_voed(char *name)
{
 make_voedrambild();
 voed(name);
}

void auswahl_check() //dies prft ob in Auswahlleiste geklickt wird
{
 XEvent event;
 if(XCheckWindowEvent(tekplot_dpy,auswahl_win,ButtonPressMask,&event))
   {exitflag=1;				//Klick soll erst verarbeitet werden
    XPutBackEvent(tekplot_dpy,&event);	//wenn voed zurckgekehrt ist.
   }
}
