/* vmal1.c	zweiter Teil von VectMal	letzte Aenderung: 22.10.2002

@ link VectMal,vmal1,vmal2,vectmal_hard,vectmal_fonts,SYS$INPUT/OPT
sys$share:decw$dwtlibshr/share

Hist:
5.6.1996	Typ von len4 von int auf long gendert
19.6.96		Postscriptfunktionen zugefgt: currentrgbcolor, currentscreen,
		setscreen, errordict, setjobtimeout.
27.1.97		Bei Pfeilspitze getestet ob sie wiklich gezeichnet werden soll
25.2.97		neue Font-Voreinstellung: "Helvetica"
		Schraffieren von Flchen, neue globale Variable fuellmethode
10.6.97		Ellipse neu als Prolog-Funktion
22.10.2002	Anpassungen an neuen Compiler:
		not() and() or() --> psnot() psand() psor()
*/

#include "vectmal.h"
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "vtimeb.h"
#include <X11/Xlib.h>

#define plot q2plot
#ifdef VAXORALPHA
#define term qterm
#endif
extern Display *tekplot_dpy;
extern Window tekplot_win;
extern GC tekplot_gc,fadenkreuz_gc;
#ifdef VAXORALPHA
extern double xmi,ymi,xma,yma,xs,ys,dx,dy;
#else
extern double xmin,ymin,xmax,ymax,xs,ys,dx,dy;
#endif

/* Vordeklarationen von C2CPP erzeugt: */
void ctm_multiplikation(double* x,double* y);
int ctm_invert(double* x);
double *getpfad(struct pfad* z,int maxi);
void pfad_kopieren(struct pfad* alt,struct pfad* neu);
void gscopy(struct graphicstate* x,struct graphicstate* y);
int err(char* s,int errnr);
void ctmcopy(double* v,double* n);
int make_cvs_string(char* str,int maxstr,WORD att,long a,long b);
int set_attr_flags(int setflags,int clrflags);
int tst_attr_flags(int mask,int flags);
int and_or_xor(struct stackeintrag** pp,long* b);
int eqvergleich(char* str,int flag);
int vergleich(char* str,int flag);
void setdictname(struct dictionary* dicy,char* name);
int bitlesen(int flag);
int linetoxy(double x,double y);
int movetoxy(double x,double y);
int pushmatrix(double* matrix,struct stackeintrag* p0);
double zwischenwinkel(double x1,double y1,double x2,double y2);
void dictcopy(Dictionary* dic1,Dictionary* dic2);
void execname(char* str);
void loadname(char* str);
int entpackread(int* wert);
int entpack2read(int* wert);
int entpack3read(int* wert);
int getpointfrompath(double** z,double* x0,double* y0,double* x1,double* y1,double* x2,double* y2);
void clipping(struct pfad* clip,struct pfad* path,struct pfad* ziel);
int aufteilen(struct pfad* pat,struct pfad* pat1,struct pfad* pat2,double a,double b,double x1,double x2);
void uebernemen(double** z,int objekt,double x,double y);
void schnittpunkt(double xa,double ya,double xb,double yb,double* xs,double* ys,double a,double b,double x1,double x2);
int istinnerhalb(struct pfad* clip,double x,double y);
void pfadanfuegen(struct pfad* path,struct pfad* ziel);
int ausschneiden(XPoint* feld,int imax);
int objektboxlesen(FILE* fp,char* str,double* x1,double* y1,double* x2,double* y2);
int objektuebernemen(FILE* fpvon,FILE* fp,FILE* fp2,char* zeile);
int innenoderausserhalb(struct pfad* spat,double x1,double y1,double x2,double y2);
char *liesbis(char* str,int von,int bis,FILE* fp);
int parser(FILE* fp,int (**proc)());
void stringpush(char* s);
int getkey(UBYTE* name);
char *reverse(char* str);
char *getkeyname(ULONG key,char* str);
int newgetkey(UBYTE* name,int* error);
void linienzug(XPoint* feld,int imax);
void doppelzug2(int ix1,int iy1,int ix2,int iy2);
void pfeilzug2(int ix1,int iy1,int ix2,int iy2);
void linienzug2(XPoint* feld,int imax);
void linienzug_closepath(XPoint* feld,int imax);
void linienzug_closefill(XPoint* feld,int imax);
void linienzug_bezier(XPoint* feld,int jmax);
int FPL(char* str);
int FPL2(char* str);
int FPL3(char* str);
int FPL4(char* str);
int FPL5(char* str);
void moveto_bkoord(int x1,int y1);
void lineto_bkoord(int x1,int y1);
void bkoord2user(int xb,int yb,double* xu,double* yu);
void bkoord2user_push(int xb,int yb);
void bkoord2user_push1(int xb);
void showviereck(int x1,int y1,int x2,int y2,int x3,int y3,int x4,int y4);
/* Ende der Vordeklarationen von C2CPP */
void cache_print(int c,Dictionary *fdic,double *dicktex,double *dicktey);
void cache_put(int c,Dictionary *fdic,double dx,double dy,
		double xul,double yul,double xor,double yor);
int cache_check(int c,Dictionary *fdic);
void font1_erstellen();
int initclip();
void bbox_start(int bboxflag);
void bbox_ende(int bboxflag);
int getclipmask();
void freeclipmask(Pixmap clipmask);
void clearclipmask(Pixmap clipmask);
int getmatrixwinkel(WORD att,long a,long b,double matrix[],double *wi,int *flg);
int liesnummer(char *s);
int fill2(int methode,struct pfad *path);
void absturz();
int sektor(double w,double r);
int clip2();
int setclip();
int flattenpath();
void setgrau(int bitmuster);
int fileread(FILE *fp);
int bitslesen(int bpp,int flag);
void drehen(double w,double *x,double *y);
int nachladen(char *filename);
void setgraphics();
void defLashow(),defLasym(),defLUmlaut();
int flatten(pfad *,pfad *);
FILE *fopen_prolog();
void schraffieren(FILE *fp);


/****** von vectmal.c importierte Objekte **********/
extern char argflag[];
extern char *errfun,*REVISION;
extern short darflag,darflag_line,darflag_dash,darflag_farbe,rueckflag,
	     hochformat;
extern int debug,fptemp_nlines,undo_nline,
	fadenkreuz_flag,fadenkreuz_typ,fadenkreuz_alt,
	schneidmethode,schneidmodus;
extern int
	brush_dx,brush_dy, brush_winkel,
	leim_dx,leim_dy,leim_winkel,
	buchst_dx,buchst_dy, buchst_winkel,
	viereck_dx,viereck_dy, viereck_winkel,
	kreis_radius,kreis_flag, kreis_x,kreis_y, kreis_dx,kreis_dy,
	bru_dx,bru_dy,bru_winkel,bru_x1,bru_y1,
	lupe_dx,lupe_dy,
	rotation_modus,rotation_step,linien_step,
	vergroessern_modus,vergroessern_step,
	rasterpunkt,raster1,raster2,
	bru_winkel_neu,savedflag,
	zentrieren_flag,zentriermitte_flag,
	pfeil_fill,ellipseflag,viereck_knopfnr,kreis_knopfnr,
	fuellmethode;
extern double
	zentriermitte,doppel_a2,
	pfeil_a2,pfeil_a3,pfeil_amplitude,pfeil_periode,ellipsefakt;

extern double ctminit[], xul,yul,xor,yor;
extern double x1fenster,y1fenster,x2fenster,y2fenster,x0fenster;
extern NAMEN UNDONAME,UNDONAME2,BILDNAME,HILFSNAME,ERRNAME,TEMPBRUSHNAME,
	     REFRESHNAME,SICHERNAME,EINSTNAME;
extern FILE *fptemp;
extern struct graphicstate gs;
extern char vectmalfont[],uvectmalfont[],texttext[];

extern int lupe_i;
extern double lupe_faktor[];
extern NAMEN PROLOGNAME;

/********************* Postscript-Interpreter ************************/

/* struct stackeintrag {UWORD attr; long a,b;}; */
struct stackeintrag *opstack;	/* opstack[IOPSTMAX] Operanden-Stack */
static UBYTE *exestack[IEXEMAX],/* Execution-Stack */
	     *parserstr=NULL;

/*static*/ int	iopst=0,	/* Zeiger im Operanden-Stack */
		iexe=0,	/* Zeiger im Execution-Stack */
		bigest_saved_iopst=0,
		dict_startflags=DICT_SYSTEMDICT;
struct Dictstackeintrag	*dictstack=NULL; /* Zeiger auf obersten Eintrag */

double font1dx;         /* Buchstabenbreite samt Abstand (Fortranfont) */
char *font1dat[256];    /* Zeichensatztabelle fuer Fortranfont */
#define FIRSTFONTID 10
static int neuefontid=FIRSTFONTID;
struct font font1; /* Fortranfont */
Dictionary font1dict;

/*** Speicherverwaltung (VM=Virtual Memory) ***/
struct vmeintrag *vmliste=NULL; /* der erste Eintrag nie wieder freigeben */

char *vmalloc(int n)
{
 char *p,*p2; struct vmeintrag *zvm;
 if((p=(char *)malloc(n+VMLENG))==NULL) return NULL;
 p2= &p[VMLENG];
 zvm=(struct vmeintrag *)p;
 zvm->mem=p2; zvm->savemark=0;
 zvm->next=vmliste;
 vmliste=zvm;
 return p2;
}

int newparserstr(UBYTE *s)
{
 if(iexe>=IEXEMAX) return EXESTACKOVER;
 exestack[iexe++]=parserstr;
 parserstr=s;
 return 0;
}

UBYTE *oldparserstr()
{
 if(iexe==0) return NULL;
 return exestack[--iexe];
}

void ctm_multiplikation(double* x,double* y) /* x*y --> y */
{
/*   x    *   y    =   z
  [a b 0]   [P  Q]   [P' Q']
  |c d 0| * |R  S| = |R' S'|
  [e f 1]   [T  U]   [T' U']
*/
 int i;
 double z[6];
 z[0]=x[0]*y[0]+x[1]*y[2]; z[1]=x[0]*y[1]+x[1]*y[3];
 z[2]=x[2]*y[0]+x[3]*y[2]; z[3]=x[2]*y[1]+x[3]*y[3];
 z[4]=x[4]*y[0]+x[5]*y[2]+y[4]; z[5]=x[4]*y[1]+x[5]*y[3]+y[5];
 for(i=0;i<6;i++) y[i]=z[i];
}

int ctm_invert(double* x) /* Inverse Matrix */
{
 double a,b,c,d,e,f,m;
 a=x[0]; b=x[1]; c=x[2]; d=x[3]; e=x[4]; f=x[5];
 m=a*d-b*c; if(m==0.) return 0;
 x[0]= d/m;
 x[1]= -b/m;
 x[2]= -c/m;
 x[3]= a/m;
 x[4]= (c*f-d*e)/m;
 x[5]= (b*e-a*f)/m;
 return 1;
}

/*** Aufbau und Freigabe von Strukturen (pfad, gs) ***/
double *getpfad(struct pfad* z,int maxi)
{
 double *x;
 x=z->anfang=z->ende=(double *)calloc(maxi,sizeof(double));
 z->max= &x[maxi];
 return x;
}

#define freepfad(z) cfree((z)->anfang)

void pfad_kopieren(struct pfad* alt,struct pfad* neu)
{
 double *z1,*z2;
 for(z1=alt->anfang,z2=neu->anfang;z1<alt->ende;)  *z2++ = *z1++;
 neu->ende = z2;
}

#define gsgetmem() getgspfade((struct graphicstate *)\
malloc(sizeof(struct graphicstate)))

struct graphicstate *getgspfade(struct graphicstate *gsneu)
{
 if(gsneu==NULL) return NULL;
 if(getpfad(&gsneu->path,MAXPATH3)==NULL)
	{cfree(gsneu); return NULL;}
 if(getpfad(&gsneu->clippath,MAXPATH3)==NULL)
	{cfree(gsneu->path.anfang); cfree(gsneu); return NULL;}
 return gsneu;
}

void gsfree(struct graphicstate *z)
{
 cfree(z->path.anfang);
 cfree(z->clippath.anfang);
 cfree(z);
}

void gscopy(struct graphicstate* x,struct graphicstate* y) /* x-->y */
{
 WORD *t,*s;
 int i, imax = sizeof(struct graphicstate)/2 - sizeof(struct pfad);
 s=(WORD *)x; t=(WORD *)y;
 for(i=0;i<imax;i++)  *t++ = *s++;
 pfad_kopieren(&x->path,&y->path);
 pfad_kopieren(&x->clippath,&y->clippath);
}

/*** Postscript-Hauptprogramm ***/
#define MAXFONTLISTE 400
static char fontliste[MAXFONTLISTE+20]; /* Liste der Fontnamen die von 
					   DocumentFonts verlangt werden */
static short fontliste_zaehler=0;

/* char *errfun="ERRFUN";   schon definiert */
static char synerr[ZL];
void fatalmemfull() {printf("FEHLER: kein Speicher\n"); exit(0);}
void fatalerror(int n) {printf("FATAL-ERROR %d\n",n);}

void postscript_init()
{
 int i;
 gs.aktflag=0;
 gs.font=NULL;
 if(gs.next!=NULL) restoreall();
 if(gs.clipflag==0)
	{if((gs.clipmask=getclipmask())==0) fatalmemfull();
	 gs.clipflag=1;
	}
 for(i=0;i<6;i++) gs.ctm[i]=ctminit[i];
 DEBUG(2,printf("CTM=[%lf %lf %lf %lf %lf %lf]\n",PP,QQ,RR,SS,TT,UU));
 initgraphics();
 lineattribute_ruecksetzen();
 initclip(); /* Clip-Pfad anlegen */
 darflag=darflag_line=darflag_dash=1;
 if(fptemp!=NULL) fclose(fptemp);
 Delete(BILDNAME);
 fptemp=fopen2(BILDNAME,"w"); fptemp_nlines=0;
}

void postscript(char *fname,int flag,int bboxflag)
/* wenn flag gesetzt, muss File schon jetzt eingefuegt werden */
{
 FILE *fp;
 int token,n,(*proc)();
 if(!(fp=fopen2(fname,"r"))) return;
 if(newparserstr(NULL)!=0) iexe=0;
 if(bboxflag) bbox_start(bboxflag);
 while((token=parser(fp,&proc))!=ERR_EOF)
   switch(token)
    {case BEF_SYSPROC:if(n=(*proc)()) fehlermeldung(n);
     CASE 0:
     CASE NUMBER:
     CASE BEF_EXIT: fehlermeldung(INVALIDEXIT);
     CASE BEF_RET:
     DEFAULT:	if(token<0) fehlermeldung(token);
		else printf("PS-Error: token=%d\n",token);
    }
 fclose(fp);
 if(flag) einfuegen_fptemp(fname,bboxflag);
 else fprintfl(fptemp,"#%s\n",(long)fname); /* da soll File eingefuegt werden */
 if(bboxflag) bbox_ende(bboxflag);
}

void bbox_start(int bboxflag)
{
 double x,y,dex,dey,sx,sy, px1,py1,px2,py2,px3,py3, alfa,sina,cosa;
 save();
 if(fontliste_zaehler>0)
   {char *s1;
    for(s1=fontliste; fontliste_zaehler > 0; fontliste_zaehler--)
	{printf("loading DocumentFont '%s'\n",s1);
	 namepush(s1); findfont(); pspop();
	 while(*s1++) ;
	}
   }
 if(bboxflag==2)
   {fprintfl(fptemp,"%%Objektbox: 0 0 %d %d\n",PSA4B,PSA4H);
    fprintfl(fptemp,"save\n");
    x=PSA4B/(xor-xul);
    y=PSA4H/(yor-yul);
    if(argflag['S']) {if(x<y) y=x; else x=y;}
    zahlpush2(x,y); scale();
    fprintfld(fptemp,"%lg %lg scale %%test1\n",x,y);
    if(xul!=0. || yul!=0.)
     { zahlpush2(x= -xul,y= -yul); translate();
       fprintfld(fptemp,"%lg %lg translate\n",x,y); }
   }
 else if(bboxflag==1)
   {px1=XWERT(bru_x1); py1=YWERT(bru_y1);
    zahlpush2(px1,py1); itransform();
    zahlpop(&py1); zahlpop(&px1);
    alfa=bru_winkel*PI/180.;
    if(hochformat) {dex=x2fenster-x1fenster; dey=y2fenster-y1fenster;}
    else	   {dey=x2fenster-x1fenster; dex=y2fenster-y1fenster;}
    dex=bru_dx/dex*PSA4B; sx=dex/(xor-xul);
    dey=bru_dy/dey*PSA4H; sy=dey/(yor-yul);
    sina=sin(alfa); cosa=cos(alfa);
    switch(bru_winkel/90)
	{case 0: px2=px1-dey*sina; py2=py1;
		 px3=px1+dex*cosa; py3=py1+dex*sina+dey*cosa;
	 CASE 1: px2=px1+dex*cosa-dey*sina; py2=py1+dey*cosa;
		 px3=px1; py3=py1+dex*sina;
	 CASE 2: px2=px1+dex*cosa; py2=py1+dex*sina+dey*cosa;
		 px3=px1-dey*sina; py3=py1;
	 CASE 3: px2=px1; py2=py1+dex*sina;
		 px3=px1+dex*cosa-dey*sina; py3=py1+dey*cosa;
	 DEFAULT:fatalerror(2);
	}
    fprintfld(fptemp,"%%Objektbox: %lg %lg %lg %lg\n",px2,py2,px3,py3);
    fprintfl(fptemp,"save\n");
    if(px1!=0. || py1!=0.)
     { zahlpush2(px1,py1); translate();
       fprintfld(fptemp,"%lg %lg translate\n",px1,py1); }
    if(bru_winkel!=0)
     { intpush(bru_winkel);
       rotate(); fprintfl(fptemp,"%d rotate\n",bru_winkel); }
    zahlpush2(sx,sy); scale(); fprintfld(fptemp,"%lg %lg scale %%test2\n",sx,sy);
    if(xul!=0. || yul!=0.)
     { zahlpush2(-xul,-yul); translate();
       fprintfld(fptemp,"%lg %lg translate\n",-xul,-yul); }
    zahlpush2(xul,yul); moveto(); zahlpush2(xul,yor); lineto();
    fprintfld(fptemp,"%lg %lg moveto %lg %lg lineto\n",xul,yul,xul,yor);
    zahlpush2(xor,yor); lineto(); zahlpush2(xor,yul); lineto();
    fprintfld(fptemp,"%lg %lg lineto %lg %lg lineto\n",xor,yor,xor,yul);
    closepath(); clip(); newpath();
    fprintfl(fptemp,"closepath clip newpath\n");
   }
}

void bbox_ende(int bboxflag)
{
 restore();
 if(bboxflag!=3)
	{fprintfl(fptemp,"restore\n"); fprintfl(fptemp,"%%Objektende\n");}
}

int setze_aktgrafikpunkt()
{
 int n;
 double x,y;
 if(n=zahlpop(&y)) return n;
 if(n=zahlpop(&x)) return n;
 gs.aktx=PP*x+RR*y+TT;  gs.akty=QQ*x+SS*y+UU;
 gs.aktflag=1;
 return 0;
}

/* setze_pathelement(int objekt,double x1=0,double y1=0,
		  double x2=0,double y2=0,double x3=0,double y3=0) */
int setze_pathelement(int objekt,double x1,double y1,
		  double x2,double y2,double x3,double y3)
{
 double *z;
 z=gs.path.ende;
 if(z >= &gs.path.anfang[MAXPATH3-7]) return LIMITCHECK;
 *z++ = objekt;
 switch(objekt)
	{case MOVETO:
	 case LINETO:	 *z++=x1; *z++=y1; break;
	 case CLOSEPATH: break;
	 case CURVETO:	 *z++=x1; *z++=y1; *z++=x2; *z++=y2; *z++=x3; *z++=y3;
			 break;
	}
 gs.path.ende=z;
 return 0;
}

int zahlpop(double *zx)
{
 struct stackeintrag *p;
 REAL h;
 if(iopst==0) return err("zahlpop",STACKUNDER);
 if(--iopst<bigest_saved_iopst) bigest_saved_iopst=iopst;
 p= &opstack[iopst];
 if(ISINT(p)) *zx=(double)p->b;
 else if(ISREAL(p)) {h.n[1]=p->b; h.n[0]=p->a; *zx=h.d;}
 else return err("zahlpop",WRONGTYPE);
 return 0;
}

int zahlpop2(double *zx,double *zy)
{
 int n;
 n=zahlpop(zy);
 if(n==0) n=zahlpop(zx);
 return n;
}

int izahlpop(int *zi,double *zx)	/* Rueckgabewert: 1=int  2=double  <0=Fehler */
{
 struct stackeintrag *p;
 REAL h;
 if(iopst==0) return STACKUNDER;
 if(--iopst<bigest_saved_iopst) bigest_saved_iopst=iopst;
 p= &opstack[iopst];
 if(ISINT(p)) {*zi=p->b; return 1;}
 else if(ISREAL(p)) {h.n[1]=p->b; h.n[0]=p->a; *zx=h.d;}
 else return WRONGTYPE;
 return 2;
}

int intzahlpop(int *zi)
{
 struct stackeintrag *p;
 if(iopst==0) return STACKUNDER;
 if(--iopst<bigest_saved_iopst) bigest_saved_iopst=iopst;
 p= &opstack[iopst];
 if(!ISINT(p)) return TYPECHECK_NOINT;
 *zi=p->b;
 return 0;
}
int intzahlpop2(int *zx,int *zy)
{
 int n;
 if(n=intzahlpop(zy)) return n;
 return intzahlpop(zx);
}

int zahlpush(double x)
{
 REAL z;
 z.d=x;
 return push(TYP_REAL,z.n[0],z.n[1]);
}

int zahlpush2(double x,double y)
{
 REAL z;
 z.d=x; push(TYP_REAL,z.n[0],z.n[1]);
 z.d=y;
 return push(TYP_REAL,z.n[0],z.n[1]);
}

int push(WORD attri,long awert,long bwert)
{
 struct stackeintrag *p;
 p= &opstack[iopst];
 p->attr=attri; p->a=awert; p->b=bwert;
 if(++iopst>=IOPSTMAX) {iopst=IOPSTMAX-1; return STACKOVER;}
 return 0;
}

WORD pop(long *awert,long *bwert)
{
 struct stackeintrag *p;
 if(iopst==0) return 0;
 if(--iopst<bigest_saved_iopst) bigest_saved_iopst=iopst;
 p= &opstack[iopst];
 *awert=p->a; *bwert=p->b;
 return p->attr;
}

int macharray()
{
 long a; char *b=NULL;
 struct stackeintrag *p;
 int i,iopstneu;
 DEBUG(2,printf("macharray()\n"));
 for(i=iopst; --i>=0 && (opstack[i].attr & TYPEMASK)!=TYP_MARK;)  ;
 if(i<0) return err("macharray_1",MISSINGMARK);
 iopstneu=i;
 a=iopst-(++i);
 if(a>0)
  {b=(char *)malloc(a*sizeof(struct stackeintrag)); /* vmalloc */
   if(b==NULL) return MEMFULL;
   p=(struct stackeintrag *)b;
   for(;i<iopst; i++,p++)
	{p->attr=opstack[i].attr; p->a=opstack[i].a; p->b=opstack[i].b;}
  }
 iopst=iopstneu;
 if(iopst<bigest_saved_iopst) bigest_saved_iopst=iopst;
 i=push(TYP_ARRAY+ZUS,a,(long)b);
 if(i) errfun="macharray_2";
 return i;
}

int load(ULONG key,ulong *awert,ulong *bwert)
{
 WORD att;
 struct Dictstackeintrag *dse;
 struct dicteintrag *de;
 int i;
 for(dse=dictstack; dse!=NULL; dse=dse->next)
  for(de=dse->dict->e,i=0; i<dse->dict->i; de++,i++)
    if(de->key==key)
	{*awert=de->wert.a; *bwert=de->wert.b;
	 return de->wert.attr;
	}
 return 0;
}


/******************* Postscript-Funktionen *******************/
static int savemarke=0;
static char *errorstr="ERRORSTR";
static FILE *currfile=NULL,	/* Postscript-Filesystem: NULL=stdinfile */
	    *stdinfile,*stdoutfile;
static int  currfile_count=1;	/* Anzahl Oeffnungen des aktuellen Files */
static int nichtzeichnen_flag=0;

int err(char* s,int errnr) {errfun=s; return errnr;}

int save()		/*  --> saveobj */
{
 struct vmeintrag *zvm;
 int n;
 savemarke=1; gsave(); savemarke=0;
 zvm=vmliste; zvm->savemark++;
 dictstack->dict->savemark++;
 n=push(TYP_SAVE,bigest_saved_iopst=iopst,0);
 if(n) errfun="save";
 return n;
}

int restore()	/* saveobj restore --> - */
{
 int attr; long a,b;
 int warnflag=0;
 struct vmeintrag *zvm,*zvm2;
 struct Dictstackeintrag *dse;
 while((attr=pop(&a,&b)) && (attr & TYPEMASK)!=TYP_SAVE)
			warnflag=1;/* letztes saveobj suchen */
 if(attr) iopst=a; /* und alle Objekte darueber vom Operandenstack entfernen */
 if(warnflag) {printf("WARNUNG: invalid restore\n");}
 if(attr==0) return err("restore",STACKUNDER);
 if(iopst>bigest_saved_iopst) iopst=bigest_saved_iopst;
 else bigest_saved_iopst=iopst;
 for(zvm=vmliste; (zvm2=zvm->next)!=NULL && zvm2->savemark==0;)
		{zvm->next=zvm2->next; cfree(zvm2);}
 if(zvm2!=NULL) zvm2->savemark--;
 savemarke=1; grestore(); savemarke=0;
 while(dictstack->dict->savemark==0)
	{printf("restore: dictstack reinigen (test1)\n");/* test1 */
	 if(dictstack->next==NULL) return err("restore",INVALIDRESTORE);
	 dse=dictstack; dictstack=dse->next;
	 cfree(dse);
	}
 dictstack->dict->savemark--;
 return 0;
}

int gsave()		/* gsave --> - */
{
 struct graphicstate *gsneu,*z;
 gsneu=gsgetmem();
 if(gsneu==NULL) return err("gsave",MEMFULL);
 for(z= &gs; z->next!=NULL; z=z->next)  ;
 gscopy(&gs,gsneu);
 gsneu->next=NULL;
 gsneu->savemark=savemarke;
 gs.clipflag=0; /* clipmask darf nicht zurueckgegeben werden */
 z->next=gsneu;
 return 0;
}

int grestore()	/* grestore --> - */
{
 int oldclipmask,oldclipflag;
 struct graphicstate *z1,*z,*h;
 int i;
 if((z=gs.next)==NULL) return 0;
 for(z1= &gs; z->next!=NULL;)  {z1=z; z=z1->next;}
 oldclipmask=gs.clipmask; oldclipflag=gs.clipflag;
 h=gs.next; gscopy(z,&gs); gs.next=h;
 if(oldclipflag)
	{
	 XSetClipMask(tekplot_dpy,tekplot_gc,gs.clipmask);
	 freeclipmask(oldclipmask);
	}
 if(z->savemark==0 || savemarke)
	{gsfree(z); z1->next=NULL;}
 lineattribute_ruecksetzen();
 return 0;
}

int newpath()	/* newpath --> - */
{
 gs.aktflag=0;
 gs.path.ende=gs.path.anfang;
 return 0;
}

int scale()	/* xs ys scale --> - */
{		/* xs ys matrix scale --> matrix */
 double xs,ys,matrix[6];
 WORD att; long a,b;
 int n,flg;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((n=getmatrixwinkel(att,a,b,matrix,&ys,&flg))==0
	 && (n=zahlpop(&xs))==0)
  {if(flg)
	{
/*	 matrix[0] *= xs; matrix[1] *= xs;	*/
/*	 matrix[2] *= ys; matrix[3] *= ys;	*/
	 matrix[0] = xs; matrix[1] = 0.;
	 matrix[2] = 0.; matrix[3] = ys; matrix[4]=matrix[5]=0.;
	 n=pushmatrix(matrix,(struct stackeintrag *)b);
	}
   else
	{PP *= xs; QQ *= xs;  RR *= ys; SS *= ys;}
  }
 NRETURN("scale");
}

int rotate()	/* winkel rotate --> - */
{		/* winkel matrix rotate --> matrix */
 double p1,p2,p3,p4,cosw,sinw,wi;
 double matrix[6];
 WORD att; long a,b;
 int n,flg;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((n=getmatrixwinkel(att,a,b,matrix,&wi,&flg))==0)
  {cosw=cos(wi*PI/180.); sinw=sin(wi*PI/180.);
   if(flg) /* zu fuellende Matrix vorhanden */
	{
/*	 p1=cosw*matrix[0]+sinw*matrix[2]; p2=cosw*matrix[1]+sinw*matrix[3]; */
/*	 p3=cosw*matrix[2]-sinw*matrix[0]; p4=cosw*matrix[3]-sinw*matrix[1]; */
/*	 matrix[0]=p1; matrix[1]=p2; matrix[2]=p3; matrix[3]=p4;	     */
	 matrix[0]=cosw; matrix[1]=sinw; matrix[2]= -sinw; matrix[3]=cosw;
	 matrix[4]=matrix[5]=0.;
	 n=pushmatrix(matrix,(struct stackeintrag *)b);
	}
   else /* ohne zu fuellende Matrix */
	{p1=cosw*PP+sinw*RR; p2=cosw*QQ+sinw*SS;
	 p3=cosw*RR-sinw*PP; p4=cosw*SS-sinw*QQ;
	 PP=p1; QQ=p2; RR=p3; SS=p4;
  }	}
 NRETURN("rotate");
}
int getmatrixwinkel(WORD att,long a,long b,double matrix[],double *wi,int *flg)
{
 struct stackeintrag *p;
 REAL z;
 int i;
 if(IS_INT(att)) {*wi=b; *flg=0; return 0;}
 if(IS_REAL(att)) {z.n[1]=b; z.n[0]=a; *wi=z.d; *flg=0; return 0;}
 if(!IS_ARRAY(att)) return TYPECHECK_NOARRAY;
 if(a<6) return RANGECHECK;
 *flg=1;
 p=(struct stackeintrag *)b;
 for(i=0;i<6;i++,p++)
	{if(ISINT(p)) z.d=p->b; else {z.n[1]=p->b; z.n[0]=p->a;}
	 matrix[i]= z.d;
	}
 if((att=pop(&a,&b))==0) return STACKUNDER;
 if(IS_INT(att)) {*wi=b; return 0;}
 if(IS_REAL(att)) {z.n[1]=b; z.n[0]=a; *wi=z.d; return 0;}
 return TYPECHECK_NONUM;
}

int translate()	/* x y translate --> - */
{		/* x y matrix translate --> matrix */
 double x,y,matrix[6];
 WORD att; long a,b;
 int n,flg;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((n=getmatrixwinkel(att,a,b,matrix,&y,&flg))==0
	 && (n=zahlpop(&x))==0)
  {if(flg)
	{
/*	 matrix[4] += x*matrix[0]+y*matrix[2];	*/
/*	 matrix[5] += x*matrix[1]+y*matrix[3];	*/
	 matrix[4]=x; matrix[5]=y;
	 matrix[0]=matrix[3]=1.; matrix[1]=matrix[2]=0.;
	 n=pushmatrix(matrix,(struct stackeintrag *)b);
	}
   else
	{TT += x*PP+y*RR;  UU += x*QQ+y*SS;
	}
  }
 NRETURN("translate");
}

int mark() {return push(TYP_MARK,0,0);}	/* mark --> [ */

int moveto()	/* x y moveto --> - */
{
 int n;
 if(n=setze_aktgrafikpunkt()) return err("moveto",n);
 n=setze_pathelement(MOVETO,gs.aktx,gs.akty,0.,0.,0.,0.);
 if(n!=0) errfun="moveto";
 return n;
}

int lineto()	/* x y lineto --> - */
{
 int n;
 if(gs.aktflag==0) {errfun="lineto"; return NOAKTPOINT;}
 if(n=setze_aktgrafikpunkt()) return err("lineto",n);
 n=setze_pathelement(LINETO,gs.aktx,gs.akty,0.,0.,0.,0.);
 if(n!=0) errfun="lineto";
 return n;
}

int rmoveto()	/* x y rmoveto --> - */
{
 int n;
 double dividend,x,y;
 if(gs.aktflag==0)  return err("rmoveto",NOAKTPOINT);
 if((n=zahlpop(&y)) || (n=zahlpop(&x))) return err("rmoveto",n);
 dividend=(SS*PP-RR*QQ);  /* wie in itransform() */
 x += (SS*gs.aktx-RR*gs.akty-SS*TT+RR*UU)/dividend;
 y += (PP*gs.akty-QQ*gs.aktx-PP*UU+QQ*TT)/dividend;
 gs.aktx=PP*x+RR*y+TT;  gs.akty=QQ*x+SS*y+UU; /* wie in setze_aktgrafikpunkt */
 n=setze_pathelement(MOVETO,gs.aktx,gs.akty,0.,0.,0.,0.);
 if(n!=0) errfun="rmoveto";
 return n;
}

int rlineto()	/* x y rlineto --> - */
{
 int n;
 double dividend,x,y;
 if(gs.aktflag==0)  return err("rlineto",NOAKTPOINT);
 if((n=zahlpop(&y)) || (n=zahlpop(&x))) return err("rlineto",n);
 dividend=(SS*PP-RR*QQ);  /* wie in itransform() */
 x += (SS*gs.aktx-RR*gs.akty-SS*TT+RR*UU)/dividend;
 y += (PP*gs.akty-QQ*gs.aktx-PP*UU+QQ*TT)/dividend;
 gs.aktx=PP*x+RR*y+TT;  gs.akty=QQ*x+SS*y+UU; /* wie in setze_aktgrafikpunkt */
 n=setze_pathelement(LINETO,gs.aktx,gs.akty,0.,0.,0.,0.);
 if(n!=0) errfun="rlineto";
 return n;
}

int curveto()	/* x2 y2 x3 y3 x4 y4 curveto --> - */
{
 int n;
 double x,y,x2,y2,x3,y3;
 if(gs.aktflag==0) {errfun="curveto"; return NOAKTPOINT;}
 if(n=setze_aktgrafikpunkt()) return n;
 zahlpop(&y); zahlpop(&x);
 x3=PP*x+RR*y+TT; y3=QQ*x+SS*y+UU;
 zahlpop(&y); n=zahlpop(&x);
 if(n!=0) {errfun="curveto"; return n;}
 x2=PP*x+RR*y+TT; y2=QQ*x+SS*y+UU;
 n=setze_pathelement(CURVETO,x2,y2,x3,y3,gs.aktx,gs.akty);
 if(n!=0) errfun="curveto";
 return n;
}

int rcurveto()	/* x2 y2 x3 y3 x4 y4 rcurveto --> - */
{
 int n;
 double dividend,x,y,x2,y2,x3,y3,x4,y4;
 if(gs.aktflag==0)  return err("rcurveto",NOAKTPOINT);
 if((n=zahlpop(&y)) || (n=zahlpop(&x))) return err("rcurveto",n);
 dividend=(SS*PP-RR*QQ);  /* wie in itransform() */
 x += (SS*gs.aktx-RR*gs.akty-SS*TT+RR*UU)/dividend;
 y += (PP*gs.akty-QQ*gs.aktx-PP*UU+QQ*TT)/dividend;
 x4=PP*x+RR*y+TT;  y4=QQ*x+SS*y+UU; /* wie in setze_aktgrafikpunkt */
 if((n=zahlpop(&y)) || (n=zahlpop(&x))) return err("rcurveto",n);
 x += (SS*gs.aktx-RR*gs.akty-SS*TT+RR*UU)/dividend;
 y += (PP*gs.akty-QQ*gs.aktx-PP*UU+QQ*TT)/dividend;
 x3=PP*x+RR*y+TT; y3=QQ*x+SS*y+UU;
 if((n=zahlpop(&y)) || (n=zahlpop(&x))) return err("rcurveto",n);
 x += (SS*gs.aktx-RR*gs.akty-SS*TT+RR*UU)/dividend;
 y += (PP*gs.akty-QQ*gs.aktx-PP*UU+QQ*TT)/dividend;
 x2=PP*x+RR*y+TT; y2=QQ*x+SS*y+UU;
 n=setze_pathelement(CURVETO,x2,y2,x3,y3,gs.aktx=x4,gs.akty=y4);
 if(n!=0) errfun="rcurveto";
 return n;
}

int setflat()	/* zahl setflat --> - */
{
 int n; double z;
 if(n=zahlpop(&z)) return n; else gs.flatness=z;
 return 0;
}
int currentflat() {return zahlpush(gs.flatness);}

int setgray()	/* zahl setgray --> - */
{
 int n,grau; double z;
 if(n=zahlpop(&z)) return n;
 grau=idfix(z*255.);
 gs.farbnummer=set_color(MAXXFARB-1,RGB,grau,grau,grau,0,NULL,NULL,NULL);
 darflag=darflag_farbe=1;
 return 0;
}
int wie_setgray(double z)
{
 int grau,n;
 grau=idfix(z*255.);
 gs.farbnummer=set_color(MAXXFARB-1,RGB,grau,grau,grau,0,NULL,NULL,NULL);
 darflag=darflag_farbe=1;
 return 0;
}
int currentgray()		/* currentgray --> zahl */
{return zahlpush(GSGETGRAY);}

int setlinewidth()	/* zahl setlinewidth --> - */
{
 int n; double z;
 if(n=zahlpop(&z)) return n; else {gs.linewidth=z; darflag=darflag_line=1;}
 return 0;
}
int currentlinewidth() {return zahlpush(gs.linewidth);}

int setmiterlimit()	/* zahl setmiterlimit --> - */
{
 int n; double z;
 if(n=zahlpop(&z)) return n; else gs.miterlimit=z;
 return 0;
}
int currentmiterlimit() {return zahlpush(gs.miterlimit);}

int setlinecap()	/* zahl setlinecap --> - */
{
 int n; double z;
 WORD att; long a,b;
 att=pop(&a,&b);
 if(att==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_INTEGER) n=TYPECHECK_NOINT;
 else if(b<0 || b>2) n=FALSCHERWERT;
 else	{gs.linecap=b; darflag=darflag_line=1; return 0;}
 errfun="setlinecap";
 return n;
}
int currentlinecap() {return intpush(gs.linecap);}

int setlinejoin()	/* zahl setlinejoin --> - */
{
 int n; double z;
 WORD att; long a,b;
 att=pop(&a,&b);
 if(att==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_INTEGER) n=TYPECHECK_NOINT;
 else if(b<0 || b>2) n=FALSCHERWERT;
 else	{gs.linejoin=b; darflag=darflag_line=1; return 0;}
 errfun="setlinejoin";
 return n;
}
int currentlinejoin() {return intpush(gs.linejoin);}

int closepath()	/* closepath --> - */
{
 int n;
 if(gs.aktflag==0) n=NOAKTPOINT;
 else n=setze_pathelement(CLOSEPATH,0.,0.,0.,0.,0.,0.);
 if(n!=0) errfun="closepath";
 return n;
}

int array()		/* n array --> [NULL NULL ...] */
{
 long a; char *b=NULL;
 WORD att; long awert,bwert;
 struct stackeintrag *p;
 int i;
 att=pop(&awert,&bwert);
 if(att==0) {errfun="array"; return STACKUNDER;}
 if((att & TYPEMASK)!=TYP_INTEGER) return err("array",TYPECHECK_NOINT);
 if((a=bwert)>0)
  {b=(char *)malloc(a*sizeof(struct stackeintrag)); /* vmalloc */
   if(b==NULL) return MEMFULL;
   p=(struct stackeintrag *)b;
   for(i=0; i<a; i++,p++)  {p->attr=TYP_NULL; p->a=0; p->b=0;}
  }
 i=push(TYP_ARRAY+ZUS,a,(long)b);
 if(i) errfun="array";
 return i;
}

int packedarray()	/* x1 x2 ... xn n packedarray --> [x1 x2 ... xn] */
{							/* READONLY */
 WORD att; long awert,bwert;
 long a; char *b=NULL;
 struct stackeintrag *p;
 int i,n,iopstneu;
 att=pop(&awert,&bwert);
 if((att & TYPEMASK)!=TYP_INTEGER) return err("packedarray",TYPECHECK_NOINT);
 if(bwert>iopst) return err("packedarray",STACKUNDER);
 iopstneu=iopst-bwert;
 a=bwert;
 DEBUG(2,printf("packedarray: Anzahl Objekte=%ld\n",a));
 if(a>0)
  {b=(char *)malloc(a*sizeof(struct stackeintrag)); /* vmalloc */
   if(b==NULL) return MEMFULL;
   p=(struct stackeintrag *)b;
   for(i=iopstneu;i<iopst; i++,p++)
	{p->attr=opstack[i].attr; p->a=opstack[i].a; p->b=opstack[i].b;}
  }
 iopst=iopstneu;
 if(iopst<bigest_saved_iopst) bigest_saved_iopst=iopst;
 n=push(TYP_ARRAY+ZUS+READONLY,a,(long)b);
 if(n!=0) errfun="packedarray";
 return n;
}

int dict()		/* zahl dict --> dictionary */
{
 struct dictionary *dicy;
 struct dicteintrag *de;
 WORD att; long awert,bwert;
 int n;
 if((att=pop(&awert,&bwert))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_INTEGER) n=TYPECHECK_NOINT;
 else
  {DEBUG(2,printf("dict() att=%04X awert=%ld bwert=%ld\n",att,awert,bwert));
   dicy=(struct dictionary *)malloc(sizeof(struct dictionary));
   de=(struct dicteintrag *)malloc(bwert*sizeof(struct dicteintrag));
   if(dicy==NULL || de==NULL) n=MEMFULL;
   else	{dicy->e=de;
	 dicy->leng=bwert; dicy->i=0; dicy->flags=dict_startflags;
	 dicy->name="noname";
	 n=push(TYP_DICT,bwert,(long)dicy);
  }	}
 if(n) errfun="dict";
 return n;
}

int currentdict()		/* currentdict --> dictionary */
{
 int n;
 n=push(TYP_DICT,dictstack->dict->leng,(long)dictstack->dict);
 if(n) errfun="currentdict";
 return n;
}

static int keyerror_key=0;
static char *keyerror_s=NULL;

int def()		/* /Name any def --> - */
{
 WORD att,att2; long awert,bwert,awert2,bwert2;
 ULONG key;
 struct Dictstackeintrag *dse;
 struct dicteintrag *de;
 int i,imax;
 static int zugflag=0;/* fuer Schutz von Spezialbefehlen */
 if((att=pop(&awert,&bwert))==0 ||
    (att2=pop(&awert2,&bwert2))==0) {errfun="def"; return STACKUNDER;}
 if((att2 & TYPEMASK)!=TYP_NAME) return err("def",TYPECHECK_NONAM);
/* DEBUG(1,printf("def: '%s' att=%04X awert=%ld bwert=%ld\n",
			(char*)bwert2,att,awert,bwert));/*test*/
// printf("testabbruch\n"); exit(0);//test
 if((strncmp((char *)bwert2,"xlzug",5)==0 ||
	strncmp((char *)bwert2,"lzug",4)==0)
    && !argflag['V'] && liesnummer((char *)bwert2)<=3 && ++zugflag>6)
	{if(zugflag==7) printf("Spezialbefehle: lzug xlzug ... xlzug3\n");
	 return 0;
	}
 if((key=getkey((UBYTE*)bwert2))==0) return err("def",MEMFULL);
 if(key==1) {keyerror_key=key; keyerror_s=(char *)bwert2; return KEYERROR;}
 if((att & TYPEMASK)==TYP_DICT)
	setdictname((struct dictionary*)bwert,(char *)bwert2);
 for(dse=dictstack,de=dse->dict->e,imax=dse->dict->i,i=0; i<imax; i++,de++)
	if(de->key==key)
		{de->wert.attr=att;
		 de->wert.a=awert; de->wert.b=bwert;
		 return 0;
		}
 if(i==dse->dict->leng) return err("def",DICTFULL);
 de->key=key; dse->dict->i++;
 de->wert.attr=att;
 de->wert.a=awert; de->wert.b=bwert;
 return 0;
}

int liesnummer(char *s)
{int c;
 while(c= *s++) if(isdigit(c)) return (c-'0');
 return 0;
}

int store()		/* /Name any store --> - */
{
 WORD att,att2; long awert,bwert,awert2,bwert2;
 ULONG key;
 struct Dictstackeintrag *dse;
 struct dicteintrag *de;
 int i,imax;
 if((att=pop(&awert,&bwert))==0 ||
    (att2=pop(&awert2,&bwert2))==0) {errfun="store"; return STACKUNDER;}
 if((att2 & TYPEMASK)!=TYP_NAME) return err("store",TYPECHECK_NONAM);
 if((key=getkey((UBYTE*)bwert2))==0) return err("store",MEMFULL);
 if(key==1) {keyerror_key=key; keyerror_s=(char *)bwert2; return KEYERROR;}
 for(dse=dictstack;dse!=NULL;dse=dse->next)
 for(de=dse->dict->e,imax=dse->dict->i,i=0; i<imax; i++,de++)
	if(de->key==key)
		{de->wert.attr=att;
		 de->wert.a=awert; de->wert.b=bwert;
		 return 0;
		}
 dse=dictstack;
 if(dse->dict->i==dse->dict->leng) return err("store",DICTFULL);
 de= &dse->dict->e[dse->dict->i++];
 de->key=key;
 de->wert.attr=att;
 de->wert.a=awert; de->wert.b=bwert;
 return 0;
}

int put()	/* Dict /Name any put --> - */
		/* string index int put --> - */
{		/* array index any  put --> - */
 WORD att,att2,att3; long awert,bwert,a2,b2,a3,b3;
 ULONG key;
 struct dictionary *dicy;
 struct dicteintrag *de;
 struct stackeintrag *p;
 int i,imax,n=0;
 char *str;
 if((att=pop(&awert,&bwert))==0 ||
    (att2=pop(&a2,&b2))==0 ||
    (att3=pop(&a3,&b3))==0)		n=STACKUNDER;
 else
  switch(att3 & TYPEMASK)
   {case TYP_DICT:
	dicy=(struct dictionary *)b3;
	if((att2 & TYPEMASK)!=TYP_NAME) n=TYPECHECK_NONAM;
	else if((key=getkey((UBYTE*)b2))==0) n=MEMFULL;
	else if(key==1)
	  {keyerror_key=key; keyerror_s=(char *)b2; return KEYERROR;}
	else
	  {for(de=dicy->e,imax=dicy->i,i=0; i<imax; i++,de++)
		if(de->key==key)
			{de->wert.attr=att;
			 de->wert.a=awert; de->wert.b=bwert;
			 return 0;
			}
	   if(i==dicy->leng) n=DICTFULL;
	   else {de->key=key; dicy->i++;
		 de->wert.attr=att;
		 de->wert.a=awert; de->wert.b=bwert;
		}
	  }
    CASE TYP_STRING:
	if((att2 & TYPEMASK)!=TYP_INTEGER ||
	    (att & TYPEMASK)!=TYP_INTEGER)   n=TYPECHECK_NOINT;
	else if(b2>=a3 || b2<0) n=RANGECHECK;
	else {str=(char *)b3; str[b2]=bwert;}
    CASE TYP_ARRAY:
	if((att2 & TYPEMASK)!=TYP_INTEGER) n=TYPECHECK_NOINT;
	else if(b2>=a3 || b2<0) n=RANGECHECK;
	else	{p=(struct stackeintrag *)b3; p= &p[b2];
		 p->attr=att; p->a=awert; p->b=bwert;
		}
    DEFAULT: if((att2 & TYPEMASK)==TYP_NAME) n=TYPECHECK_NODICT;
	     else n=TYPECHECK_NOARRAY;
   }
 if(n) errfun="put";
 return n;
}

int get()	/* Dict /Name get --> any */
		/* string index get --> int */
{		/* array index  get --> any */
 WORD att,att2; long awert,bwert,a2,b2;
 ULONG key;
 struct dictionary *dicy;
 struct dicteintrag *de;
 struct stackeintrag *p;
 int i,imax,n=0;
 char *str;
 if((att=pop(&awert,&bwert))==0 ||
    (att2=pop(&a2,&b2))==0)		n=STACKUNDER;
 else
  switch(att2 & TYPEMASK)
   {case TYP_DICT:
	dicy=(struct dictionary *)b2;
	if((att & TYPEMASK)!=TYP_NAME && (att & TYPEMASK)!=TYP_STR)
					n=TYPECHECK_NONAM;
	else if((key=getkey((UBYTE*)bwert))==0) n=MEMFULL;
	else if(key==1) {keyerror_key=key; keyerror_s=(char *)bwert; return KEYERROR;}
	else
	  {for(de=dicy->e,imax=dicy->i,i=0; i<imax; i++,de++)
		if(de->key==key)
			{n=push(de->wert.attr,de->wert.a,de->wert.b); break;}
	   if(i>=imax) {errorstr=(char *)bwert; n=UNDEFINED;}
	  }
    CASE TYP_STRING:
	if((att & TYPEMASK)!=TYP_INTEGER) n=TYPECHECK_NOINT;
	else if(bwert>=a2 || bwert<0) { printf("get TYP_STR:bwert=%ld a2=%ld\n",
						bwert,a2);/* Fehlermeldung */
					n=RANGECHECK; }
	else {str=(char *)b2; n=intpush(str[bwert] & 0xFF);}
    CASE TYP_ARRAY:
	if((att & TYPEMASK)!=TYP_INTEGER) n=TYPECHECK_NOINT;
	else if(bwert>=a2 || bwert<0)
				{ printf("get TYP_ARRAY:bwert=%ld a2=%ld\n",
					bwert,a2);/* Fehlermeldung */
				  n=RANGECHECK; }
	else { p=(struct stackeintrag *)b2;
	       p= &p[bwert]; n=push(p->attr,p->a,p->b); }
    DEFAULT: printf("att2=%04X ",att2);
	     if((att & TYPEMASK)==TYP_NAME) n=TYPECHECK_NODICT;
	     else n=TYPECHECK_NOARRAY;
   }
 if(n) errfun="get";
 return n;
}

int known()	/* Dict /Name known --> bool */
{
 WORD att,att2; long awert,bwert,a2,b2;
 ULONG key;
 struct dictionary *dicy;
 struct dicteintrag *de;
 int i,imax,n=0;
 if((att=pop(&awert,&bwert))==0 ||
    (att2=pop(&a2,&b2))==0)		n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_NAME && (att & TYPEMASK)!=TYP_STR)
					n=TYPECHECK_NONAM;
 else if((att2 & TYPEMASK)!=TYP_DICT) n=TYPECHECK_NODICT;
 else  {dicy=(struct dictionary *)b2;
	if((key=getkey((UBYTE*)bwert))==0) n=MEMFULL;
	else if(key==1) {keyerror_key=key; keyerror_s=(char *)bwert; return KEYERROR;}
	else
	  {for(de=dicy->e,imax=dicy->i,i=0; i<imax; i++,de++)
		if(de->key==key)
			return push(TYP_BOOLEAN,0,1);
	   n=push(TYP_BOOLEAN,0,0);
       }  }
 if(n) errfun="known";
 return n;
}

int where()	/* /Name where --> dict true */
{		/*		   false     */
 WORD att; long awert,bwert;
 ULONG key;
 struct Dictstackeintrag *dse;
 struct dicteintrag *de;
 int i,imax,n=0;
 if((att=pop(&awert,&bwert))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_NAME) n=TYPECHECK_NONAM;
 else  {if((key=getkey((UBYTE*)bwert))==0) n=MEMFULL;
	else if(key==1) {keyerror_key=key; keyerror_s=(char *)bwert; return KEYERROR;}
	for(dse=dictstack;dse!=NULL;dse=dse->next)
	for(de=dse->dict->e,imax=dse->dict->i,i=0; i<imax; i++,de++)
		if(de->key==key)
			{push(TYP_DICT,dse->dict->leng,(long)dse->dict);
			 return push(TYP_BOOLEAN,0,1);
			}
	n=push(TYP_BOOLEAN,0,0);
       }
 if(n) errfun="where";
 return n;
}

int psdup()	/* x dup --> x x */
{
 int i,j;
 if((i=iopst)==0) {errfun="dup"; return STACKUNDER;}
 if(++iopst>=IOPSTMAX) {iopst=IOPSTMAX-1; errfun="dup"; return STACKOVER;}
 j=i-1;
 opstack[i].attr=opstack[j].attr;
 opstack[i].a=opstack[j].a;
 opstack[i].b=opstack[j].b;
 return 0;
}

int psreadonly()	/* x readonly --> x */
{int n;
 if(n=set_attr_flags(READONLY,EXECUTEONLY)) errfun="readonly";
 return n;
}

int pspop()		/* x pop --> - */
{
 if(iopst==0) {errfun="pop"; return STACKUNDER;}
 if(--iopst<bigest_saved_iopst) bigest_saved_iopst=iopst;
 return 0;
}

int exch()		/* x y exch --> y x */
{
 struct stackeintrag *p1,*p2;
 WORD att; long awert,bwert;
 if(iopst<=1) {errfun="exch"; return STACKUNDER;}
 p1= &opstack[iopst-1];
 p2= &opstack[iopst-2];
 att=p1->attr; awert=p1->a; bwert=p1->b;
 p1->attr=p2->attr; p1->a=p2->a; p1->b=p2->b;
 p2->attr=att; p2->a=awert; p2->b=bwert;
 return 0;
}

int psload()	/* /Name load --> Objekt */
{
 WORD att; long awert,bwert,bwert2;
 ULONG key;
 int n;
 att=pop(&awert,&bwert); if(att==0) {errfun="psload"; return STACKUNDER;}
 if((att & TYPEMASK)!=TYP_NAME) return err("psload",TYPECHECK_NONAM);
 if((key=awert)<=1)
	{keyerror_key=key; keyerror_s=(char *)bwert; return err("psload",KEYERROR);}
 if((att=load(key,(ulong*)&awert,(ulong*)&bwert2))==0)
	{errorstr=(char *)bwert; return err("psload",UNDEFINED);}
 n=push(att,awert,bwert2);
 if(n) errfun="psload";
 return n;
}

void move(double x,double y) {plot(PP*x+RR*y+TT,QQ*x+SS*y+UU,3);}
void draw(double x,double y) {plot(PP*x+RR*y+TT,QQ*x+SS*y+UU,2);}

int bind() {return 0;}

int showpage()
{
 char antw[8];
 if(argflag['P']==0) return 0;
 Fenstertitel(VECTMAL_READY);
 requester("Pause bei showpage","weiter",NULL);
 raise_window();
 Fenstertitel(VECTMAL_WORKING);
 gsave();
 zahlpush2(xul,yul); moveto(); zahlpush2(xul,yor); lineto();
 zahlpush2(xor,yor); lineto(); zahlpush2(xor,yul); lineto();
 closepath(); intpush(1); setgray(); fill(); /* Seite loeschen */
 grestore();
 return 0;
}

int stroke()	/* stroke --> - */
{
 double *z,x,y,x0,y0,x1,y1,x2,y2,x3,y3;
 int pen,n;
 if(gs.path.ende==gs.path.anfang) return err("stroke",NOPATH);
 if(darflag) lineattribute_setzen();
 if(nichtzeichnen_flag) {newpath(); return 0;}
 for(z=gs.path.anfang;z<gs.path.ende;)
   {switch(n=(int)(*z++))
	{case MOVETO:	 pen=3; x0=x= *z++; y0=y= *z++; break;
	 case LINETO:	 pen=2; x= *z++; y= *z++; break;
	 case CLOSEPATH: pen=2; x=x0; y=y0; break;
	 case CURVETO:	 pen=2;
			 x2= *z++; y2= *z++; x3= *z++; y3= *z++;
			 x= *z++; y= *z++;
			 bezier(x1,y1,x2,y2,x3,y3,x,y);
			 break;
	 default: printf("ERROR in stroke():n=%d gs.path.anfang=%d *z=%lf\n",
			 n,gs.path.anfang,*z);
		  newpath(); errfun="stroke"; return PATH_CORRUPT;
	}
    plot(x,y,pen); x1=x; y1=y;
   }
 qstroke();
 newpath();
 return 0;
}

int stroke_fptemp()
{
 double *z,x,y,x0,y0,x1,y1,x2,y2,x3,y3, tx,ty,tx3,ty3;
 int pen,n;
 if(gs.path.ende==gs.path.anfang) return err("stroke",NOPATH);
 if(darflag) lineattribute_setzen();
 for(z=gs.path.anfang;z<gs.path.ende;)
   {switch(n=(int)(*z++))
     {case MOVETO:  pen=3; x0=x= *z++; y0=y= *z++;
		    invtransformru(&tx,&ty,x,y);
		    fprintf(fptemp,"%lg %lg moveto ",tx,ty);
      CASE LINETO:  pen=2; x= *z++; y= *z++;
		    invtransformru(&tx,&ty,x,y);
		    fprintfld(fptemp,"%lg %lg lineto\n",tx,ty);
      CASE CLOSEPATH: pen=2; x=x0; y=y0; fprintfl(fptemp,"closepath\n");
      CASE CURVETO: pen=2;
		    x2= *z++; y2= *z++; x3= *z++; y3= *z++;
		    x= *z++; y= *z++;
		    invtransformru(&tx,&ty,x2,y2);
		    fprintf(fptemp,"%lg %lg ",tx,ty);
		    invtransformru(&tx3,&ty3,x3,y3); invtransformru(&tx,&ty,x,y);
		    fprintfld(fptemp,"%lg %lg %lg %lg curveto\n",tx3,ty3,tx,ty);
		    bezier(x1,y1,x2,y2,x3,y3,x,y);
      DEFAULT:	printf("ERROR in stroke_f():n=%d gs.path.anfang=%d *z=%lf\n",
			 n,gs.path.anfang,*z);
		newpath(); errfun="stroke"; return PATH_CORRUPT;
     }
    plot(x,y,pen); x1=x; y1=y;
   }
 qstroke();
 newpath();
 fprintfl(fptemp,"stroke\n");
 return 0;
}

#define WINDUNGSZAHL 1
#define EVENODD 2
int fill()						/* fill --> - */
{
 int n;
 if(nichtzeichnen_flag) n=0; else n=fill2(WINDUNGSZAHL,&gs.path);
 newpath(); return n;
}

int eofill()						/* eofill --> - */
{
 int n;
 if(nichtzeichnen_flag) n=0; else n=fill2(EVENODD,&gs.path);
 newpath(); return n;
}

int fill2(int methode,struct pfad *path)
{
 double *z,x,y,x0,y0,x1,y1,x2,y2,x3,y3;
 int pen,n;
 if(path->anfang==path->ende) {errfun="fill"; return NOPATH;}
 if(darflag) lineattribute_setzen();
 for(z=path->anfang;z<path->ende;)
   {switch(n=(int)(*z++))
	{case MOVETO:	 pen=3; x0=x= *z++; y0=y= *z++; break;
	 case LINETO:	 pen=2; x= *z++; y= *z++; break;
	 case CLOSEPATH: pen=2; x=x0; y=y0; break;
	 case CURVETO:	 pen=2;
			 x2= *z++; y2= *z++; x3= *z++; y3= *z++;
			 x= *z++; y= *z++;
			 fillbezier(x1,y1,x2,y2,x3,y3,x,y);
			 break;
	 default: printf("ERROR in fill(): n=%d path->anfang=%d *z=%lf\n",
			 n,path->anfang,*z);
		  errfun="fill"; return PATH_CORRUPT;
	}
    fillplot(x,y,pen); x1=x; y1=y;
   }
 fillpoly(methode);
 return 0;
}

int fill_fptemp(int methode,struct pfad *path,int zeigflag)
{
 double *z,x,y,x0,y0,x1,y1,x2,y2,x3,y3, tx,ty,tx3,ty3;
 int pen,n;
 if(path->anfang==path->ende) {errfun="fill"; return NOPATH;}
 if(zeigflag && darflag) lineattribute_setzen();
 for(z=path->anfang;z<path->ende;)
   {switch(n=(int)(*z++))
	{case MOVETO:	 pen=3; x0=x= *z++; y0=y= *z++;
			 invtransformru(&tx,&ty,x,y);
			 fprintf(fptemp,"%lg %lg moveto ",tx,ty);
	 CASE LINETO:	 pen=2; x= *z++; y= *z++;
			 invtransformru(&tx,&ty,x,y);
			 fprintfld(fptemp,"%lg %lg lineto\n",tx,ty);
	 CASE CLOSEPATH: pen=2; x=x0; y=y0; fprintfl(fptemp,"closepath\n");
	 CASE CURVETO:	 pen=2;
			 x2= *z++; y2= *z++; x3= *z++; y3= *z++;
			 x= *z++; y= *z++;
			 invtransformru(&tx,&ty,x2,y2);
			 fprintf(fptemp,"%lg %lg ",tx,ty);
			 invtransformru(&tx3,&ty3,x3,y3);
			 invtransformru(&tx,&ty,x,y);
			 fprintfld(fptemp,"%lg %lg %lg %lg curveto\n",
					tx3,ty3,tx,ty);
			 if(zeigflag) fillbezier(x1,y1,x2,y2,x3,y3,x,y);
	 DEFAULT: printf("ERROR in fill_f():n=%d path->anfang=%d *z=%lf\n",
			 n,path->anfang,*z);
		  errfun="fill"; return PATH_CORRUPT;
	}
    if(zeigflag) fillplot(x,y,pen); x1=x; y1=y;
   }
 if(zeigflag) fillpoly(methode);
 newpath();
 return 0;
}

int currentfile()		/* currentfile --> file */
{
 int n;
 n=push(TYP_FILE,0,(long)currfile);
 NRETURN("currentfile");
}

int pscopy()	/*  x1...xn n copy --> x1...xn x1...xn	*/
		/*  array1 array2 copy --> array2	*/
		/*  dict1 dict2 copy --> dict2	 	*/
{		/*  str1 str2 copy --> str2	 	*/
 int n,i,imax,j;
 struct stackeintrag *p,*p2;
 WORD att,att2; long a,b,a2,b2;
 char *s1,*s2;
 struct dictionary *dicy,*dicy2;
 struct dicteintrag *de,*de2;
 if((att=pop(&a,&b))==0) {errfun="copy"; return STACKUNDER;}
 p= &opstack[iopst];
 if(ISINT(p))
  {n=p->b; if(n<=0) return 0;
   if(iopst<n) {errfun="copy"; return STACKUNDER;}
   if(iopst+n>=IOPSTMAX) {errfun="copy"; return STACKOVER;}
   for(i=iopst-n,j=iopst;i<iopst;i++,j++)
	{opstack[j].attr=opstack[i].attr;
	 opstack[j].a=opstack[i].a;
	 opstack[j].b=opstack[i].b;
	}
   iopst=j;
   return 0;
  }
 if((att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else switch(att & TYPEMASK)
  {case TYP_ARRAY:
	 if((att2 & TYPEMASK)==TYP_ARRAY)
		{for(p=(struct stackeintrag *)b,
			p2=(struct stackeintrag *)b2,i=0;i<a2;i++,p++,p2++)
			{p->attr=p2->attr; p->a=p2->a; p->b=p2->b;}
		 n=push(att,a,b);
		}
	 else if((att2 & TYPEMASK)==TYP_STR || (att2 & TYPEMASK)==TYP_PROC)
		{if((att2 & TYPEMASK)==TYP_STR)
			{DEBUG(1,printf("String in Array kopieren\n"));}
		 else	{DEBUG(1,printf("Proc in Array kopieren\n"));}
		 for(p=(struct stackeintrag *)b,i=0;i<=a;i++,p++)
			{s1=(char *)b2;
			 push(TYP_STR+ZUS,strlen(s1),(long)s1); token();
			 att2=pop(&a2,&b2); if(b2!=1) break;
			 p->attr=pop(&p->a,&p->b);
			 att2=pop(&a2,&b2);
			}
		 n=push(att,a,b);
		}
	 else n=TYPECHECK_NOARRAY;
   CASE TYP_STRING:
	 if((att2 & TYPEMASK)!=TYP_STRING) n=TYPECHECK_NOSTR;
	 else	{for(i=1,s1=(char *)b,s2=(char *)b2; *s2 && i<a; i++)
				*s1++ = *s2++;
		 *s1=0;
		 n=push(att,a,b);
		}
   CASE TYP_DICT:
	 if((att2 & TYPEMASK)!=TYP_DICT) n=TYPECHECK_NODICT;
	 else	{dicy=(struct dictionary *)b; dicy2=(struct dictionary *)b2;
		 de=dicy->e; de2=dicy2->e;
		 imax=dicy2->i; if(dicy->leng<imax) imax=dicy->leng;
		 for(i=0; i<imax; i++,de++,de2++)
			{de->wert.attr=de2->wert.attr; de->wert.a=de2->wert.a;
			 de->wert.b=de2->wert.b; de->key=de2->key;
			}
		 dicy->i=imax;
		 n=push(att,a,b);
		}
   DEFAULT: n=WRONGTYPE;
  }
 if(n) errfun="copy";
 return n;
}

int transform()	/* x y transform --> x' y' */
{		/* x y matrix transform --> x' y' */
 double x,y,matrix[6];
 WORD att; long a,b;
 int n,flg;
 REAL x2,y2;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((n=getmatrixwinkel(att,a,b,matrix,&y,&flg))==0
	 && (n=zahlpop(&x))==0)
  {if(flg)
	{x2.d = matrix[0]*x+matrix[2]*y+matrix[4];
	 y2.d = matrix[1]*x+matrix[3]*y+matrix[5];
	}
   else
	{x2.d=PP*x+RR*y+TT;
	 y2.d=QQ*x+SS*y+UU;
	}
  }
 push(TYP_REAL,x2.n[0],x2.n[1]);
 n=push(TYP_REAL,y2.n[0],y2.n[1]);
 NRETURN("transform");
}
void normtransform(double *zx,double *zy,double x,double y)
{
 *zx=PP*x+RR*y+TT; *zy=QQ*x+SS*y+UU;
}

int dtransform() /* x y dtransform --> x' y' */
{		 /* x y matrix dtransform --> x' y' */
 double x,y,matrix[6];
 WORD att; long a,b;
 int n,flg;
 REAL x2,y2;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((n=getmatrixwinkel(att,a,b,matrix,&y,&flg))==0
	 && (n=zahlpop(&x))==0)
  {if(flg)
	{x2.d = matrix[0]*x+matrix[2]*y;
	 y2.d = matrix[1]*x+matrix[3]*y;
	}
   else
	deltatransform(&x2.d,&y2.d,x,y);
  }
 push(TYP_REAL,x2.n[0],x2.n[1]);
 n=push(TYP_REAL,y2.n[0],y2.n[1]);
 NRETURN("dtransform");
}
int deltatransform(double *zx,double *zy,double x,double y)
{
 *zx=PP*x+RR*y;  *zy=QQ*x+SS*y;
 return 0;
}

int itransform() /* x' y' itransform --> x y */
{		 /* x' y' matrix itransform --> x y */
 double x,y,dividend,matrix[6];
 WORD att; long a,b;
 int n,flg;
 REAL x2,y2;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((n=getmatrixwinkel(att,a,b,matrix,&y,&flg))==0
	 && (n=zahlpop(&x))==0)
  {if(flg)
    {dividend = matrix[3]*matrix[0]-matrix[2]*matrix[1];
     x2.d = (matrix[3]*x-matrix[2]*y-matrix[3]*matrix[4]+matrix[2]*matrix[5])
		/dividend;
     y2.d = (matrix[0]*y-matrix[1]*x-matrix[0]*matrix[5]+matrix[1]*matrix[4])
		/dividend;
    }
   else
    {dividend=(SS*PP-RR*QQ);
     x2.d=(SS*x-RR*y-SS*TT+RR*UU)/dividend;
     y2.d=(PP*y-QQ*x-PP*UU+QQ*TT)/dividend;
  } }
 push(TYP_REAL,x2.n[0],x2.n[1]); n=push(TYP_REAL,y2.n[0],y2.n[1]);
 NRETURN("itransform");
}
void invtransform(double *zx,double *zy,double x,double y)
{
 double dividend;
 dividend=(SS*PP-RR*QQ);
 if(dividend==0.) return;
 *zx=(SS*x-RR*y-SS*TT+RR*UU)/dividend;
 *zy=(PP*y-QQ*x-PP*UU+QQ*TT)/dividend;
}
void invtransformru(double *zx,double *zy,double x,double y)
{
 double dividend;
 dividend=(SS*PP-RR*QQ);
 if(dividend==0.) return;
 *zx=(SS*x-RR*y-SS*TT+RR*UU)/dividend;
 *zy=(PP*y-QQ*x-PP*UU+QQ*TT)/dividend;
 if(rasterpunkt!=0)
	{*zx=doubrund(*zx,(double)rasterpunkt);
	 *zy=doubrund(*zy,(double)rasterpunkt);
	}
}

int idtransform()	/* x' y' idtransform --> x y */
{			/* x' y' matrix idtransform --> x y */
 double x,y,dividend,matrix[6];
 WORD att; long a,b;
 int n,flg;
 REAL x2,y2;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((n=getmatrixwinkel(att,a,b,matrix,&y,&flg))==0
	 && (n=zahlpop(&x))==0)
  {if(flg)
	{dividend = matrix[3]*matrix[0]-matrix[2]*matrix[1];
	 x2.d = (matrix[3]*x-matrix[2]*y)/dividend;
	 y2.d = (matrix[0]*y-matrix[1]*x)/dividend;
	}
   else
	ideltatransform(&x2.d,&y2.d,x,y);
  }
 push(TYP_REAL,x2.n[0],x2.n[1]); n=push(TYP_REAL,y2.n[0],y2.n[1]);
 NRETURN("idtransform");
}
int ideltatransform(double *zx,double *zy,double x,double y)
{
 double dividend;
 dividend=(SS*PP-RR*QQ);
 *zx=(SS*x-RR*y)/dividend;
 *zy=(PP*y-QQ*x)/dividend;
 return 0;
}

static int execarray_flag=0;/* test0 */

int exec()	/* proc exec --> - */
		/* executable exec --> - */
{		/* any exec --> any */
 WORD att; long a,b;
 int token,n,(*proc)(),i,imax;
 struct stackeintrag *p;
 struct dictionary *dicy;
 struct dicteintrag *de;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if(!(att & EXECUTABLE))  n=push(att,a,b);
 else switch(att & TYPEMASK3)
  {case TYP_SPROC:
     proc=(ZFUNK)b; n=(*proc)();
   CASE TYP_PROC: case TYP_STRING: case TYP_NAME:
     if(newparserstr((UBYTE *)b)!=0) return EXESTACKOVER;
     while((token=parser(NULL,&proc))!=ERR_EOF && token!=BEF_RET)
       switch(token)
	{case BEF_SYSPROC:
		if(n=(*proc)())
			{if(n==BEF_EXIT) {parserstr=oldparserstr(); return n;}
			 else {printf("exec");fehlermeldung(n);}
			}
	 CASE 0:
	 CASE NUMBER:
	 CASE BEF_EXIT: parserstr=oldparserstr(); return BEF_EXIT;
	 DEFAULT:	if(token<0) {printf("exec2");fehlermeldung(token);}
			else printf("exec2 PS-Error: token=%d\n",token);
	}
     return 0;
   case TYP_ARRAY:
     DEBUG(1,printf("exec() TYP_ARRAY: att=%04X a=%ld b=%ld\n",att,a,b));
     for(p=(struct stackeintrag *)b,i=0;i<a;i++,p++)
	{if((n=push(p->attr,p->a,p->b))!=0 || (n=exec())!=0)
		{ if(n==BEF_EXIT) return n;
		  else {printf("exec_array"); fehlermeldung(n);} }
	}
     return 0;
   case TYP_DICT:
     printf("exec() TYP_DICT\n");/* test2 */
     dicy=(struct dictionary *)b;
     for(de=dicy->e,imax=dicy->i,i=0; i<imax; i++,de++)
	{push(de->wert.attr,de->wert.a,de->wert.b);
	 if(n=exec())
		{ if(n==BEF_EXIT) return n;
		  else {printf("exec_dict"); fehlermeldung(n);} }
	}
     return 0;
   case TYP_FILE:
     DEBUG(1,printf("exec() TYP_FILE fp=%ld\n",b));
     if(newparserstr(NULL)!=0) iexe=0;
     while((token=parser((FILE*)b,&proc))!=ERR_EOF)
       switch(token)
	{case BEF_SYSPROC:if(n=(*proc)()) fehlermeldung(n);
	 CASE 0:
	 CASE NUMBER:
	 CASE BEF_EXIT: fehlermeldung(INVALIDEXIT);
	 CASE BEF_RET:
	 DEFAULT:	if(token<0) fehlermeldung(token);
			else printf("PS-ERRor: token=%d\n",token);
	}
     fclose((FILE *)b);
     return 0;
   default: n=push(att,a,b);
  }/* end switch */
 NRETURN("exec");
}

int exec_str(char *str)
{
 int token,n,(*proc)();
 if(newparserstr((UBYTE *)str)!=0) return EXESTACKOVER;
 while((token=parser(NULL,&proc))!=ERR_EOF && token!=BEF_RET) /* wie exec() */
   switch(token)
    {case BEF_SYSPROC:
		if(n=(*proc)())
			{if(n==BEF_EXIT) {parserstr=oldparserstr(); return n;}
			 else printf("exec_str1");fehlermeldung(n);
			}
     CASE 0:
     CASE NUMBER:
     CASE BEF_EXIT: parserstr=oldparserstr(); return BEF_EXIT;
     DEFAULT:	if(token<0) {printf("exec_str2");fehlermeldung(token);}
		else printf("exec_str2 PS-Error: token=%d\n",token);
		if(debug>=2) absturz();
    }
 return 0;
}

void absturz()
{
 int a=1,b=0;
 a=a/b;
 printf("jetzt sollte es eine Systemfehlermeldung gegeben haben %ld\n",a);
}

int stopped()	/* proc stopped --> bool */
{
 WORD att; long a,b;
 int token,n,(*proc)(),psbool=0;
 att=pop(&a,&b); if(att==0) {errfun="stopped"; return STACKUNDER;}
 if(!(att & EXECUTABLE))  return push(att,a,b);
 if(newparserstr((UBYTE *)b)!=0) return EXESTACKOVER;
 while((token=parser(NULL,&proc))!=ERR_EOF && token!=BEF_RET && psbool==0)
   switch(token)
    {case BEF_SYSPROC:
		if(n=(*proc)())
			{if(n==BEF_EXIT) {parserstr=oldparserstr(); psbool=1;}
			 else {printf("stopped.");fehlermeldung(n);}
			}
     CASE 0:
     CASE NUMBER:
     CASE BEF_EXIT: parserstr=oldparserstr(); psbool=1;
     DEFAULT:	if(token<0) {printf("stopped ");fehlermeldung(token);}
		else printf("stopped PS-Error: token=%d\n",token);
    }
 return push(TYP_BOOLEAN,0,psbool);
}

int repeat()	/* n proc repeat --> - */
{
 WORD att,att2; long a,b,a2,b2;
 int n,i;
 att=pop(&a,&b); if(att==0) {errfun="repeat"; return STACKUNDER;}
 if((att & TYPEMASK)!=TYP_PROC) return TYPECHECK_NOPROC;
 att2=pop(&a2,&b2); if(att==0) {errfun="repeat"; return STACKUNDER;}
 if((att2 & TYPEMASK)!=TYP_INTEGER) return TYPECHECK_NOINT;
 for(i=b2;i>0;i--)
	{if(n=push(att,a,b)) return n;
	 if(exec()==BEF_EXIT) return 0;
	}
 return 0;
}

int loop()		/* proc loop --> - */
{
 WORD att; long a,b;
 int n;
 att=pop(&a,&b); if(att==0) {errfun="repeat"; return STACKUNDER;}
 if((att & TYPEMASK)!=TYP_PROC) return TYPECHECK_NOPROC;
 for(;;)
	{if(n=push(att,a,b)) return n;
	 if(exec()==BEF_EXIT) return 0;
	}
 return 0;
}

int psexit() {return BEF_EXIT;}	/* exit --> - */
int psstop() {return BEF_EXIT;}	/* stop --> - */

int psfor()	/* start step end proc for --> - */
{		/*  i proc --> -  */
 WORD att; long a,b;
 REAL z;
 int n,m,i,j,abc[3]; double xabc[3];
 att=pop(&a,&b); if(att==0) return err("for",STACKUNDER);
 if((att & TYPEMASK)!=TYP_PROC) return err("for",TYPECHECK_NOPROC);
 for(i=0;i<3;i++)
	{if((m=izahlpop(&abc[i],&xabc[i]))<0) return err("for",m);
	 if(m==2) {for(j=0;j<i;j++) xabc[j]=abc[j];  i++; break;}
	}
 for(;i<3;i++)
	if((n=zahlpop(&xabc[i]))<0) return err("for",n);
 if(m==2) /* Schlaufe mit Fliesszahlen */
  {if(xabc[1]>=0.)
     for(z.d=xabc[2];z.d<=xabc[0];z.d+=xabc[1])
	{if(n=push(TYP_REAL,z.n[0],z.n[1])) return err("for",n);
	 if(n=push(att,a,b)) return err("for",n);
	 if(exec()==BEF_EXIT) return 0;
	}
   else
     for(z.d=xabc[2];z.d>=xabc[0];z.d+=xabc[1])
	{if(n=push(TYP_REAL,z.n[0],z.n[1])) return err("for",n);
	 if(n=push(att,a,b)) return err("for",n);
	 if(exec()==BEF_EXIT) return 0;
  }	}
 else /* Schlaufe mit Integerzahlen */
  {if(abc[1]>=0)
     for(i=abc[2];i<=abc[0];i+=abc[1])
	{if(n=intpush(i)) return err("for",n);
	 if(n=push(att,a,b)) return err("for",n);
	 if(exec()==BEF_EXIT) return 0;
	}
   else
     for(i=abc[2];i>=abc[0];i+=abc[1])
	{if(n=intpush(i)) return err("for",n);
	 if(n=push(att,a,b)) return err("for",n);
	 if(exec()==BEF_EXIT) return 0;
  }	}
 return 0;
}

int forall()		/* array proc forall --> - */
			/* string proc forall --> - */
{			/* dict proc forall --> - */
 WORD att; long a,b;
 WORD att2; long imax,b2,i;
 struct stackeintrag *p;
 char *str;
 struct dictionary *dicy;
 struct dicteintrag *de;
 int n=0;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_PROC) n=TYPECHECK_NOPROC;
 else if((att2=pop(&imax,&b2))==0) n=STACKUNDER;
 else switch(att2 & TYPEMASK)
  {case TYP_ARRAY:
	 p=(struct stackeintrag *)b2;
	 for(i=0;i<imax;i++,p++)
		{push(p->attr,p->a,p->b);
		 if(n=push(att,a,b)) break;
		 if(exec()==BEF_EXIT) return 0;
		}
   CASE TYP_STRING:
	 for(str=(char *)b2;*str;str++)
		{intpush(*str);
		 if(n=push(att,a,b)) break;
		 if(exec()==BEF_EXIT) return 0;
		}
   CASE TYP_DICT:
	 dicy=(struct dictionary *)b2;
	 for(de=dicy->e,imax=dicy->i,i=0; i<imax; i++,de++)
		{str=getkeyname(de->key,"....");
		 push(TYP_NAME,de->key,(long)str);
		 push(de->wert.attr,de->wert.a,de->wert.b);
		 if(n=push(att,a,b)) break;
		 if(exec()==BEF_EXIT) return 0;
		}
   DEFAULT: n=TYPECHECK_NOARRAY;
  }
 if(n) errfun="forall";
 return n;
}


static double delta_w=5.0;

int setarcdelta()	/* testfunktion: dw setarcdelta --> - */
{
 zahlpop(&delta_w);
 if(delta_w<0.1) delta_w=0.1;
 return 0;
}

int arc()		/* xm ym radius wa we arc --> - */
{
 double xm,ym,radius,wa,we,w,dw=delta_w,altectm[6];
 int n;
 zahlpop(&we); zahlpop(&wa); zahlpop(&radius); zahlpop(&ym); zahlpop(&xm);
/* DEBUG(2,printf("arc: xm=%lf ym=%lf  r=%lf  wa=%lf  we=%lf\n",
		xm,ym,radius,wa,we));/*test*/
 ctmcopy(gs.ctm,altectm);
 zahlpush2(xm,ym); translate();
 zahlpush(wa); rotate();
 zahlpush(radius); zahlpush(0.0);
 if(gs.aktflag==0) moveto();
 else		   lineto();
 w=we-wa; while(w<0.) w+=360.;
 for(;w>dw;w-=dw)
	{sektor(dw,radius); zahlpush(dw); rotate();}
 n=sektor(w,radius);
 ctmcopy(altectm,gs.ctm);
 if(n!=0) errfun="arc";
 return n;
}
void ctmcopy(double* v,double* n) {int i; for(i=0;i<6;i++) n[i]=v[i];}

int arcn()		/* xm ym radius wa we arcn --> - */
{
 double xm,ym,radius,wa,we,w,dw=delta_w,altectm[6];
 int n;
 zahlpop(&we); zahlpop(&wa); zahlpop(&radius); zahlpop(&ym); zahlpop(&xm);
/* DEBUG(2,printf("arcn: xm=%lf ym=%lf  r=%lf  wa=%lf  we=%lf\n",
		xm,ym,radius,wa,we));/*test*/
 ctmcopy(gs.ctm,altectm);
 zahlpush2(xm,ym); translate();
 zahlpush(wa); rotate();
 zahlpush(radius); zahlpush(0.0);
 if(gs.aktflag==0) moveto();
 else		   lineto();
 w=wa-we; while(w<0.) w+=360.;
 for(;w>dw;w-=dw)
	{sektor(-dw,radius); zahlpush(-dw); rotate();}
 n=sektor(-w,radius);
 ctmcopy(altectm,gs.ctm);
 if(n!=0) errfun="arcn";
 return n;
}

int sektor(double w,double r)
{
 double x2,y2,x3,y3,x4,y4,winkel,cosw,sinw,sinw2;
 int n;
/* DEBUG(1,printf("sektor(w=%lg,r=%lf)\n",w,r));/*test*/
 winkel=PI/180.0*w;
 cosw=cos(winkel); sinw=sin(winkel); sinw2=sin(winkel/2.0);
 if(cosw==1.0) return 0;
 x2=r; y2=8./3*r/(cosw-1.0)*(sinw/2.0-sinw2);
 x4=r*cosw; y4=r*sinw;
 x3=x4+y2*sinw; y3=y4-y2*cosw;
 zahlpush2(x2,y2); zahlpush2(x3,y3); n=zahlpush2(x4,y4);
 if(n!=0) return n;
 return curveto();
}

int sub()		/* a b sub --> a-b */
{
 static char *str="sub";
 double x,y; int ix,iy,n; REAL z;
 n=mathpop2(str,&ix,&iy,&x,&y);
 if(n==0)	n=intpush(ix-iy);
 else if(n==1)	{z.d=x-y; n=push(TYP_REAL,z.n[0],z.n[1]);}
 if(n) errfun=str;
 return n;
}

#define mathreturn(n,s) if(n) errfun=s; return n

int mathpop2(char *str,int *ix,int *iy,double *x,double *y)
{				/* Rueckgabe: 0=INTEGER 1=REAL <0=FEHLER */
 int n;
 WORD att,att2; long a,b,a2,b2;
 REAL z;
 att=pop(&a,&b);
 att2=pop(&a2,&b2); if(att2==0) return err(str,STACKUNDER);
 if((att & TYPEMASK)==TYP_INTEGER && (att2 & TYPEMASK)==TYP_INTEGER)
	{*ix=b2; *iy=b; return 0;}
 if((att & TYPEMASK)==TYP_INTEGER) *y=b;
 else if((att & TYPEMASK)==TYP_REAL) {z.n[1]=b; z.n[0]=a; *y=z.d;}
 else return err(str,TYPECHECK_NONUM);
 if((att2 & TYPEMASK)==TYP_INTEGER) *x=b2;
 else if((att2 & TYPEMASK)==TYP_REAL) {z.n[1]=b2; z.n[0]=a2; *x=z.d;}
 else return err(str,TYPECHECK_NONUM);
 return 1;
}

int mathpop1(char* str,int* ix,double* x)
{				/* Rueckgabe: 0=INTEGER 1=REAL <0=FEHLER */
 int n;
 WORD att; long a,b;
 REAL z;
 att=pop(&a,&b); if(att==0) return err(str,STACKUNDER);
 if((att & TYPEMASK)==TYP_INTEGER)  {*ix=b; return 0;}
 if((att & TYPEMASK)==TYP_REAL) {z.n[1]=b; z.n[0]=a; *x=z.d;}
 else return err(str,TYPECHECK_NONUM);
 return 1;
}

int add()		/* a b add --> a+b */
{
 static char *str="add";
 double x,y; int ix,iy,n; REAL z;
 n=mathpop2(str,&ix,&iy,&x,&y);
 if(n==0)	n=intpush(ix+iy);
 else if(n==1)	{z.d=x+y; n=push(TYP_REAL,z.n[0],z.n[1]);}
 if(n) errfun=str;
 return n;
}

int mul()		/* a b mul --> a*b */
{
 static char *str="mul";
 double x,y; int ix,iy,n; REAL z;
 n=mathpop2("mul",&ix,&iy,&x,&y);
 if(n==0)	n=intpush(ix*iy);
 else if(n==1)	{z.d=x*y; n=push(TYP_REAL,z.n[0],z.n[1]);}
 mathreturn(n,str);
}

int psdiv()		/* a b div --> a/b */
{
 static char *str="div";
 double x,y; int ix,iy,n; REAL z;
 n=mathpop2(str,&ix,&iy,&x,&y);
 if(n==0)	{z.d=ix/(double)iy; n=push(TYP_REAL,z.n[0],z.n[1]);}
 else if(n==1)	{z.d=x/y; n=push(TYP_REAL,z.n[0],z.n[1]);}
 mathreturn(n,str);
}

int idiv()		/* a b idiv --> a/b */
{
 static char *str="idiv";
 double x,y; int ix,iy,n;
 n=mathpop2(str,&ix,&iy,&x,&y);
 if(n==0)	n=intpush(ix/iy);
 else if(n==1)	{ix=(int)(x/y); n=intpush(ix);}
 mathreturn(n,str);
}

int mod()		/* a b mod --> Rest(a/b) */
{
 double x,y; int ix,iy,n;
 n=mathpop2("mod",&ix,&iy,&x,&y);
 if(n==0)	n=intpush(ix%iy);
 else if(n==1)	{x=x-((int)(x/y))*y; n=zahlpush(x);}
 mathreturn(n,"mod");
}

int psexp()		/* a b exp --> a^b */
{
 double x,y; int ix,iy,n;
 n=mathpop2("exp",&ix,&iy,&x,&y);
 if(n>=0)	{ if(n==0) {x=ix; y=iy;}
		  n=zahlpush(pow(x,y)); }
 mathreturn(n,"exp");
}

int neg()		/* a neg --> -a */
{
 double x; int ix,n;
 n=mathpop1("neg",&ix,&x);
 if(n==0)	n=intpush(-ix);
 else if(n==1)	n=zahlpush(-x);
 mathreturn(n,"neg");
}

int psabs()		/* a abs --> |a| */
{
 double x; int ix,n;
 n=mathpop1("psabs",&ix,&x);
 if(n==0)	{ if(ix<0) ix= -ix;
		  n=intpush(ix); }
 else if(n==1)	{ if(x<0.0) x= -x;
		  n=zahlpush(x); }
 mathreturn(n,"abs");
}

int pssin()		/* a sin --> sin(a) */
{
 double x; int ix,n;
 n=mathpop1("sin",&ix,&x);
 if(n>=0)	{if(n==0) x=ix;
		 n=zahlpush(sin(x*GRAD));}
 mathreturn(n,"sin");
}

int pscos()		/* a cos --> cos(a) */
{
 double x; int ix,n;
 n=mathpop1("cos",&ix,&x);
 if(n>=0)	{if(n==0) x=ix;
		 n=zahlpush(cos(x*GRAD));}
 mathreturn(n,"cos");
}

int psatan()		/* a atan --> atan(a) */
{
 double x; int ix,n;
 n=mathpop1("atan",&ix,&x);
 if(n>=0)	{if(n==0) x=ix;
		 n=zahlpush(atan(x)/GRAD);}
 mathreturn(n,"atan");
}

int pslog()		/* a log --> log10(a) */
{
 double x; int ix,n;
 n=mathpop1("log",&ix,&x);
 if(n>=0)	{if(n==0) x=ix;
		 n=zahlpush(log10(x));}
 mathreturn(n,"log");
}

int psln()		/* a ln --> ln(a) */
{
 double x; int ix,n;
 n=mathpop1("ln",&ix,&x);
 if(n>=0)	{if(n==0) x=ix;
		 n=zahlpush(log(x));}
 mathreturn(n,"ln");
}

int pssqrt()		/* a sqrt --> sqrt(a) */
{
 double x; int ix,n;
 n=mathpop1("sqrt",&ix,&x);
 if(n>=0)	{if(n==0) x=ix;
		 n=zahlpush(sqrt(x));}
 mathreturn(n,"sqrt");
}

int round()		/* a round --> a' */
{
 double x; int ix,n;
 n=mathpop1("round",&ix,&x);
 if(n>=0)	{if(n==0) x=ix;
		 if(x<0.) ix=(int)(x-0.5);
		 else ix=(int)(x+0.5);
		 n=zahlpush(x=ix);
		}
 mathreturn(n,"round");
}

int truncate()		/* a truncate --> a' */
{
 double x; int ix,n;
 n=mathpop1("truncate",&ix,&x);
 if(n>=0)	{if(n==0) x=ix; else ix=(int)x;
		 n=zahlpush(x=ix);}
 mathreturn(n,"truncate");
}

int ceiling()		/* a ceiling --> a' */
{
 double x; int ix,n;
 n=mathpop1("ceiling",&ix,&x);
 if(n>=0)	{if(n==0) x=ix;
		 n=zahlpush(ceil(x));}
 mathreturn(n,"ceiling");
}

int psfloor()	/* a floor --> a' */
{
 double x; int ix,n;
 n=mathpop1("floor",&ix,&x);
 if(n>=0)	{if(n==0) x=ix;
		 n=zahlpush(floor(x));}
 mathreturn(n,"floor");
}

int setdash()	/* [on off...] offset setdash --> - */
{
 int n,i,z; double offset;
 WORD att; long a,b;
 struct stackeintrag *p;
 REAL x;
 if((n=zahlpop(&offset))==0)
  {att=pop(&a,&b);
   if(att==0) n=STACKUNDER;
   else {if((att & TYPEMASK)!=TYP_ARRAY) {n=TYPECHECK_NOARRAY; a=0;}
	 p=(struct stackeintrag *)b;
	 for(i=0; i<a; i++,p++)
		{if(ISINT(p))  z=(int)(deltatrans((double)(p->b))+0.5);
		 else if(ISREAL(p))
		      {x.n[1]=p->b; x.n[0]=p->a; z=(int)(deltatrans(x.d)+0.5);}
		 else {n=FALSCHERWERT; break;}
		 gs.dashfeld[i]= z<=0 ? 1 :z;
		}
	 gs.dashlen=i;
	 gs.dashoffset=(int)(deltatrans(offset)+0.5);
	 darflag=darflag_dash=1;
  }	}
 if(n) errfun="setdash";
 return n;
}

int currentdash()	/* currentdash --> [on off...] offset */
{
 int i,n; double offset;
 mark();
 for(i=0,n=gs.dashlen;n>0;n--,i++)
	zahlpush(ideltatrans((double)gs.dashfeld[i]));
 n=macharray();
 if(n) return err("currentdash",n);
 if(gs.dashlen==0) {n=intpush(0); if(n)errfun="currentdash"; return n;}
 offset=ideltatrans((double)gs.dashoffset);
 n=zahlpush(offset);
 if(n) errfun="currentdash";
 return n;
}

int currentpoint()	/* currentpoint --> x y */
{
 double dividend;
 REAL x2,y2;
 int n;
 if(gs.aktflag==0) {errfun="currentpoint"; return NOAKTPOINT;}
 dividend=(SS*PP-RR*QQ);  /* wie in itransform() */
 x2.d=(SS*gs.aktx-RR*gs.akty-SS*TT+RR*UU)/dividend;
 y2.d=(PP*gs.akty-QQ*gs.aktx-PP*UU+QQ*TT)/dividend;
 push(TYP_REAL,x2.n[0],x2.n[1]);
 n=push(TYP_REAL,y2.n[0],y2.n[1]); if(n) errfun="currentpoint";
 return n;
}

int pstrue() {return push(TYP_BOOLEAN,0,1);}
int psfalse() {return push(TYP_BOOLEAN,0,0);}

int string()	/* n string --> (leerstring) */
{
 char *s;
 int n,nzeichen;
 double x;
 if((n=izahlpop(&nzeichen,&x))<0) return err("string",n);
 if(n!=1) return err("string",TYPECHECK_NOINT);
 if((s=(char *)malloc(nzeichen+1))==NULL) return err("string",MEMFULL);/*vmalloc*/
 n=push(TYP_STRING+ZUS,nzeichen,(long)s);
 while(nzeichen-- > 0) *s++ =' ';
 *s=0;
 if(n) errfun="string";
 return n;
}

int cvi()		/* zahl cvi --> int */
{
 int ix;
 struct stackeintrag *p;
 REAL h;
 if(iopst==0) return err("cvi",STACKUNDER);
 p= &opstack[iopst-1];
 if(ISINT(p)) return 0;
 if(ISREAL(p)) {h.n[1]=p->b; h.n[0]=p->a; ix=(int)h.d;}
 else if(ISBOOL(p)) {ix=p->b;}
 else if(ISSTRING(p)) {sscanf((char *)p->b,"%d",&ix);}
 else return err("cvi",WRONGTYPE);
 p->attr=TYP_INTEGER; p->a=0; p->b=ix;
 return 0;
}

int cvr()		/* zahl cvr --> real */
{
 struct stackeintrag *p;
 REAL x;
 if(iopst==0) return err("cvr",STACKUNDER);
 p= &opstack[iopst-1];
 if(ISREAL(p)) return 0;
 if(ISINT(p) || ISBOOL(p)) {x.d=p->b;}
 else if(ISSTRING(p)) {sscanf((char *)p->b,"%lf",&x.d);}
 else return err("cvr",WRONGTYPE);
 p->attr=TYP_REAL; p->a=x.n[0]; p->b=x.n[1];
 return 0;
}

int cvs()		/* any string cvs --> (string) */
{
 WORD att; long a,b;
 WORD att2; long a2,b2;
 int n=0;
 att=pop(&a,&b);
 if(att==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STRING) n=TYPECHECK_NOSTR;
 else {att2=pop(&a2,&b2); if(att2==0) n=STACKUNDER;}
 if(n) return err("cvs",n);
/* DEBUG(2,printf("cvs: stringlaenge=%ld string='%s'\n",a,b));/*test*/
 n=make_cvs_string((char*)b,a+1,att2,a2,b2);
 if(!n) n=push(att,strlen((char *)b),b);
 NRETURN("cvs");
}
int make_cvs_string(char* str,int maxstr,WORD att,long a,long b)
{
#define STRICOP if(strlen(stri)>=maxstr) return 1; strcpy(str,stri)
 REAL x;
 struct stackeintrag *p;
 char *str2,*s2,*str0=str,*s,stri[40];
 int i,n=0;
 if(str==NULL) return MEMFULL;
 switch(att & TYPEMASK2)
  {case TYP_NULL:	if(maxstr<5) return 1;
			strcpy(str,"NULL");
   CASE TYP_INTEGER:	sprintf(stri,"%ld",b); STRICOP;
   CASE TYP_REAL:	x.n[1]=b; x.n[0]=a; sprintf(stri,"%lf",x.d); STRICOP;
			if(INDEX(str,".")>=0) /* berflssige Nullen lschen */
				{for(s= &str[strlen(str)];*--s=='0';)  ;
				 *++s=0;
				}
   CASE TYP_BOOLEAN:	if(b) strcpy(stri,"true"); else strcpy(stri,"false");
			STRICOP;
   CASE TYP_ARRAY:	if(maxstr<5) return 1;
			if((str2=(char *)malloc(maxstr))==NULL) return MEMFULL;
			*str++ = '['; maxstr-=3;
			for(p=(struct stackeintrag *)b,i=0;i<a;i++,p++)
			  {n=make_cvs_string(str2,maxstr,p->attr,p->a,p->b);
			   if(n) break;
			   for(s2=str2; (*str = *s2++)!=0; str++) maxstr--;
			   *str++ = ' '; maxstr--;
			  }
			*str++ = ']'; *str=0;
			cfree(str2);
   CASE TYP_STRING:	if(a>=maxstr) return 1;
			strncpy(str,(char *)b,a); str[a]=0;
   CASE TYP_NAME:	if(strlen((char *)b)>=maxstr) return 1;
			strcpy(str,(char *)b);
   CASE TYP_PROC:	if(att & SYSPROC)
			     {sprintf(stri,"--%s-- ",sysprocname(b)); STRICOP;}
			else {if(strlen((char *)b)>=maxstr) return 1;
			      strcpy(str,(char *)b);
			     }
   CASE TYP_DICT:	sprintf(stri,"-%s- ",((struct dictionary *)b)->name);
			STRICOP;
   CASE TYP_FONT:
   case TYP_SAVE:
   case TYP_FILE:
   case TYP_MARK:
   case TYP_FONTID:
   case TYP_OPERATOR:
   default:		strcpy(stri,"-nostringval-"); STRICOP;
  }
 return n;
}

int cvn()		/* string cvn --> /Name */
{
 ULONG key;
 struct stackeintrag *p;
 if(iopst==0) return err("cvn",STACKUNDER);
 p= &opstack[iopst-1];
 if(!ISSTRING(p)) return err("cvn",TYPECHECK_NOSTR);
/* DEBUG(3,printf("cvn: *(p->b)=0x%02lx  p->a=%ld\n",*((char *)(p->b)),p->a));*/
 if((key=getkey((UBYTE*)p->b))==0) return MEMFULL;
 if(key==1)
  {int error;
   key=newgetkey((UBYTE*)p->b,&error);
   if(error) {keyerror_key=error; keyerror_s=(char *)p->b; return err("cvn",KEYERROR);}
  }
 p->attr=TYP_NAME+ZUS; p->a=key;
 return 0;
}

static char *strtype[]=
  {"nulltype","integertype","realtype","booleantype","stringtype","arraytype",
   "PROCEDUREtype","nametype","dicttype","fonttype","savetype","filetype",
   "marktype","FONTIDtype","operatortype","nulltype"};

int type()		/* any type --> /Name */
{
 WORD att; long a,b;
 char *str;
 ULONG key;
 att=pop(&a,&b);
 if(att==0) return err("type",STACKUNDER);
 if(IS_FONT(att)) att++;
 str=strtype[att & 0x0F];
 if((key=getkey((UBYTE*)str))==0) return MEMFULL;
 if(key==1) {keyerror_key=key; keyerror_s=str; return err("type",KEYERROR);}
 return push(TYP_NAME+ZUS+EXECUTABLE,key,(long)str);
}

int set_attr_flags(int setflags,int clrflags)
{
 struct stackeintrag *p;
 if(iopst==0) return STACKUNDER;
 p= &opstack[iopst-1];
 p->attr |= setflags;
 p->attr &= ~clrflags;
 return 0;
}
int cvx()		/* any cvx --> any */
{int n;
 if(n=set_attr_flags(EXECUTABLE,0)) errfun="cvx";
 return n;
}
int cvlit()		/* any cvlit --> any */
{int n;
 if(n=set_attr_flags(0,EXECUTABLE)) errfun="cvlit";
 return n;
}
int executeonly()	/* any executeonly --> any */
{int n;
 if(n=set_attr_flags(EXECUTEONLY,READONLY)) errfun="executeonly";
 return n;
}
int noaccess()	/* any noaccess --> any */
{int n;
 if(n=set_attr_flags(EXECUTEONLY+READONLY,0)) errfun="noaccess";
 return n;
}

int cvrs()		/* zahl basis string cvrs --> string */
{
 WORD att; long a,b;
 double x;
 int n=0,basis,ix,i,ziffer;
 char *s,*s0,c;
 att=pop(&a,&b);
 if(att==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STRING) n=TYPECHECK_NOSTR;
 if(n==0) {n=izahlpop(&basis,&x); if(n==2) basis=(int)x;}
 if(n>=0) {n=izahlpop(&ix,&x); if(n==2) ix=(int)x;}
 if(n<0) return err("cvrs",n);
 for(i=0,s=s0=(char *)b; (ix!=0 || s==(char *)b) && i<a; i++,s++)
	{if(ix<0) {*s='-'; ix= -ix; s0= &s[1];}
	 else	{ziffer=ix%basis; ix/=basis;
		 if(ziffer>9)	*s = ziffer-10+'A';
		 else		*s = ziffer+'0';
	}	}
 *s-- = 0;
 for(;s>s0;s--,s0++) {c= *s; *s= *s0; *s0=c;}
 return push(att,a,b);
}

int tst_attr_flags(int mask,int flags)
{
 struct stackeintrag *p;
 if(iopst==0) return STACKUNDER;
 p= &opstack[iopst-1];
 if((p->attr & mask)==flags)  p->b=1;   else  p->b=0;
 p->attr=TYP_BOOLEAN; p->a=0;
 return 0;
}
int xcheck()		/* any xcheck --> bool */
{int n;
 if(n=tst_attr_flags(EXECUTABLE,EXECUTABLE)) errfun="xcheck";
 return n;
}
int wcheck()		/* any wcheck --> bool */
{int n;
 if(n=tst_attr_flags(PROTECTMASK,0)) errfun="wcheck";
 return n;
}
int rcheck()		/* any rcheck --> bool */
{int n;
 if(n=tst_attr_flags(EXECUTEONLY,0)) errfun="rcheck";
 return n;
}

int psindex()	/* xn..x1 x0 n index --> xn..x1 x0 xn */
{
 int er,n;
 struct stackeintrag *p;
 er=intzahlpop(&n); if(er) return err("index",er);
 if(iopst < ++n) return STACKUNDER;
 p= &opstack[iopst-n];
 return push(p->attr,p->a,p->b);
}

int roll()	/* x1 x2..xn n richtung roll --> xn x1 x2..xn-1 %mit richtg 1*/
{
 int er,n,richtung,i;
 struct stackeintrag *p1,*p2;
 WORD att; long a,b;
 er=intzahlpop(&richtung);
 if(er==0) er=intzahlpop(&n);
 if(er==0) {if(iopst<n) er=STACKUNDER;}
 if(er) return err("roll",er);
 while(richtung>0)
  {p2= &opstack[iopst-1];
   att=p2->attr; a=p2->a; b=p2->b;
   for(i=1,p1= &opstack[iopst-2];i<n;i++,p2--,p1--)
	{p2->attr=p1->attr; p2->a=p1->a; p2->b=p1->b;}
   p2->attr=att; p2->a=a; p2->b=b;
   richtung--;
  }
 while(richtung<0)
  {p2= &opstack[iopst-n];
   att=p2->attr; a=p2->a; b=p2->b;
   for(i=1,p1= &opstack[iopst-n+1];i<n;i++,p2++,p1++)
	{p2->attr=p1->attr; p2->a=p1->a; p2->b=p1->b;}
   p2->attr=att; p2->a=a; p2->b=b;
   richtung++;
  }
 return 0;
}

int psprint()	/* string print --> - */
{
 WORD att; long a,b;
 int n;
 att=pop(&a,&b);
 if(att==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STRING) n=TYPECHECK_NOSTR;
 if(n<0) return err("print",n);
 printf("%s ",b);
 return 0;
}
int flush() {printf("\n"); return 0;}	/* flush --> - */ /* ?? */

int gleich()	/* any = --> - */
{
 int n,max;
 WORD att; long a,b;
 char *str;
 att=pop(&a,&b);
 if(att==0) n=STACKUNDER;
 else	{
	 for(max=256;;max<<=1)
	  {str=(char *)malloc(max); if(str==NULL) return err("=",MEMFULL);
	   n=make_cvs_string(str,max,att,a,b);
	   if(n==0) break;
	   cfree(str); if(n<0) return err("=",MEMFULL);
	  }
	 printf("%s ",str);
	 cfree(str);
	}
 if(n) errfun="=";
 return n;
}

int gleichgleich()	/* any == --> - */
{
 WORD att; long a,b;
 REAL x;
 char *str;
 ULONG key;
 int max,n;
 att=pop(&a,&b);
 if(att==0) return err("==",STACKUNDER);
 switch(att & TYPEMASK2)
  {case TYP_NULL:	printf("NULL ");
   CASE TYP_INTEGER:	printf("%ld ",b);
   CASE TYP_REAL:	x.n[1]=b; x.n[0]=a; printf("%lf ",x.d);
   CASE TYP_BOOLEAN:	if(b) printf("true "); else printf("false ");
   CASE TYP_STRING:	printf("(%s) ",b);
   CASE TYP_ARRAY:	for(max=256;;max<<=1)
			  {str=(char *)malloc(max);
			   if(str==NULL) return err("==",MEMFULL);
			   n=make_cvs_string(str,max,att,a,b);
			   if(n==0) break;
			   cfree(str); if(n<0) return n;
			  }
			printf("%s ",str);
			cfree(str);
   CASE TYP_PROC:	if(att & SYSPROC) printf("--%s-- ",sysprocname(b));
			else printf("{%s} ",b);
   CASE TYP_NAME:	printf("/%s ",b);
   CASE TYP_DICT:	printf("-DICT:%s- ",((struct dictionary *)b)->name);
   CASE TYP_FONT:	printf("-FONT:%s- ",((struct dictionary *)b)->name);
   DEFAULT:		printf("-%s- ",strtype[att & 0x0F]);
  }
 return 0;
}
char *sysprocname(long x)
{	/* provi */
 char *s;
 if(x== (long)moveto) s="moveto";
 else if(x== (long)lineto) s="lineto";
 else if(x== (long)stroke) s="stroke";
 else s="SYSPROC";
 return s;
}

int stack()		/* stack --> */
{
 int i,n;
 for(i=iopst-1;i>=0;i--)
	{if((n=intpush(i))==0) n=psindex();
	 if(n==0) n=gleich();
	 if(n) return err("stack",n);
	}
 flush();
 return 0;
}

int pstack()	/* pstack --> */
{
 int i,n;
 for(i=iopst-1;i>=0;i--)
	{if((n=intpush(i))==0) n=psindex();
	 if(n==0) n=gleichgleich();
	 if(n) return err("pstack",n);
	}
 flush();
 return 0;
}

int version()	/* version --> string */
{
 int n;
 static char str[60];
 sprintf(str,"Vectmal %s",REVISION);
 n=push(TYP_STRING+ZUS,strlen(str),(long)str);
 if(n) errfun="version";
 return n;
}

int psclear()	/* any... clear --> - */
{iopst=bigest_saved_iopst=0; return 0;}

int cleartomark()	/* [ any... cleartomark --> - */
{
 int i;
 for(i=iopst; --i>=0 && (opstack[i].attr & TYPEMASK)!=TYP_MARK;)  ;
 if(i<0) return err("cleartomark",MISSINGMARK);
 iopst=i; if(iopst<bigest_saved_iopst) bigest_saved_iopst=iopst;
 return 0;
}

int getcount()
{
 int i;
 for(i=iopst; --i>=0 && (opstack[i].attr & TYPEMASK)!=TYP_SAVE;)  ;
 return (iopst-i-1);
}
int count()		/* any1...anyN count --> any1...anyN N */
{
 int n;
 n=intpush(getcount());
 if(n) errfun="count";
 return n;
}

int counttomark()	/* [ any1...anyN counttomark --> [ any1...anyN N */
{
 int i,er;
 for(i=iopst; --i>=0 && (opstack[i].attr & TYPEMASK)!=TYP_MARK;)  ;
 if(i<0) er=MISSINGMARK;
 else er=intpush(iopst-1-i);
 if(er) errfun="counttomark";
 return er;
}

int begin()		/* dict begin --> - */
{
 WORD att; long a;
 int n=0;
 Dictionary *dicy;
 struct Dictstackeintrag *dse;
 if((att=pop(&a,(long*)&dicy))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_DICT) n=TYPECHECK_NODICT;
 else if((dse=(struct Dictstackeintrag *)
		malloc(sizeof(struct Dictstackeintrag)))==0) n=MEMFULL;
 else
  {
/* DEBUG(2,printf("begin() dse=%06X alter dictstack=%06X\n",dse,dictstack));*/
/* dicy->flags |= DICT_OPEN; */
   dse->dict=dicy;
   dse->next=dictstack; dictstack=dse;
  }
 NRETURN("begin");
}

int end()		/* end --> - */
{
 struct Dictstackeintrag *dse;
 if(dictstack->next==NULL) return err("end",STACKUNDER);
/* DEBUG(2,printf("end() alter dictstack=%06X  neuer=%06X\n",
		dictstack,dictstack->next)); */
/* dictstack->dict->flags &= ~DICT_OPEN; */
 dse=dictstack;
 dictstack=dictstack->next;
 cfree(dse);
 return 0;
}

int psnot()	/* bool not --> bool */
{		/* int  not --> int  */
 struct stackeintrag *p;
 if(iopst<=0) return err("not",STACKUNDER);
 p= &opstack[iopst-1];
 if(!ISBOOLINT(p)) return err("not",TYPECHECK_NOBOOLINT);
 p->b ^= 1;
 return 0;
}

int psand()	/* bool1 bool2 and --> bool */
{		/* int1  int2  and --> int  */
 struct stackeintrag *p;
 long b;
 int n;
 if(n=and_or_xor(&p,&b)) errfun="and";
 else  p->b &= b;
 return n;
}
int and_or_xor(struct stackeintrag** pp,long* b)
{
 struct stackeintrag *p;
 WORD att,typ; long a;
 int n=0;
 if((att=pop(&a,b))==0) n=STACKUNDER;
 else if(((typ=(att & TYPEMASK))!=TYP_BOOLEAN) && typ!=TYP_INTEGER)
		 n=TYPECHECK_NOBOOLINT;
 else if(iopst<=0) n=STACKUNDER;
 else  {p= &opstack[iopst-1];
	if(!ISBOOLINT(p)) n=TYPECHECK_NOBOOLINT;
	else if((p->attr & TYPEMASK)!=typ) n=MIXEDBOOLINT;
       }
 *pp=p;
 return n;
}

int psor()	/* bool1 bool2 or --> bool */
{		/* int1  int2  or --> int  */
 struct stackeintrag *p;
 int n;
 long b;
 if(n=and_or_xor(&p,&b)) errfun="or";
 else  p->b |= b;
 return n;
}

int psxor()	/* bool1 bool2 xor --> bool */
{		/* int1  int2  xor --> int  */
 struct stackeintrag *p;
 int n;
 long b;
 if(n=and_or_xor(&p,&b)) errfun="xor";
 else  p->b ^= b;
 return n;
}

static int clippingmethode;
int clip() {clippingmethode=WINDUNGSZAHL; clip2();}	/* clip --> - */
int eoclip() {clippingmethode=EVENODD; clip2();}	/* eoclip --> - */

int cliprekursion;/* test0 */

int clip2()
{
 struct pfad ziel;
 int n;
 if(getpfad(&ziel,MAXPATH3)==NULL) return err("clip2",MEMFULL);
 flattenpath();
 cliprekursion=0;
 clipping(&gs.clippath,&gs.path,&ziel);
 pfad_kopieren(&ziel,&gs.clippath);
 freepfad(&ziel);
 n=setclip();
 if(n) errfun="clip";
 return n;
}

int setclip()
{
 DEBUG(2,printf("setclip()\n"));
 if(RUECKFLAG) lineattribute_ruecksetzen();
 if(gs.clipflag) clearclipmask(gs.clipmask);
 else {if((gs.clipmask=getclipmask())==0) return MEMFULL;
       gs.clipflag=1;/* clipmask beim naechsten grestore wieder zurueckgeben */
      }
 draw_in_clip(gs.clipmask);
 fill2(clippingmethode,&gs.clippath);
 draw_in_window(gs.clipmask);
 darflag=darflag_farbe=1; lineattribute_setzen();
 return 0;
}

void restoreall()
{
 while(gs.next!=NULL) restore();
}

int flattenpath()
{
 struct pfad pat1;
 int n;
 if(getpfad(&pat1,MAXPATH3)==NULL) n=MEMFULL;
 else
  {if((n=flatten(&pat1,&gs.path))==0)
	{freepfad(&gs.path);
	 gs.path.anfang=pat1.anfang;
	 gs.path.ende=pat1.ende;
	 gs.path.max=pat1.max;
	}
   else	{freepfad(&pat1);}
  }
 NRETURN("flattenpath");
}

int clippath()	/* clippath --> -  kopiert ClipPfad nach AktuellerPfad */
{
 pfad_kopieren(&gs.clippath,&gs.path);
 return 0;
}

int pathbbox()	/* pathbbox --> xul yul xor yor */
{
 double xul=1e9,yul=1e9,xor= -1e9,yor= -1e9;
 double p1x,p1y,p2x,p2y,p3x,p3y,p4x,p4y;
 double *z,*ze,x,y;
 int n,i;
 z=gs.path.anfang; ze=gs.path.ende;
 if(z==ze) return err("pathbbox",NOPATH);
 while(z<ze)
	{switch((int)(*z++))
		{case MOVETO: case LINETO: i=1;
		 CASE CURVETO:	 i=3;
		 CASE CLOSEPATH: default: i=0;
		}
	 while(i--)
		{x= *z++; y= *z++;
		 if(x<xul) xul=x; if(x>xor) xor=x;
		 if(y<yul) yul=y; if(y>yor) yor=y;
		}
	}
 /* 4 Eckpunkte in Devicekoordinaten: */
 p1x=p2x=xul; p1y=p4y=yul; p3x=p4x=xor; p3y=p2y=yor;
 /* 4 Eckpunkte in Userkoordinaten umrechnen: */
 invtransform(&x,&y,p1x,p1y); p1x=x; p1y=y;
 invtransform(&x,&y,p2x,p2y); p2x=x; p2y=y;
 invtransform(&x,&y,p3x,p3y); p3x=x; p3y=y;
 invtransform(&x,&y,p4x,p4y); p4x=x; p4y=y;
 xul=xor=p1x; yul=yor=p1y;	/* groesste und kleinste suchen */
 if(p2x<xul) xul=p2x; if(p2x>xor) xor=p2x;
 if(p2y<yul) yul=p2y; if(p2y>yor) yor=p2y;
 if(p3x<xul) xul=p3x; if(p3x>xor) xor=p3x;
 if(p3y<yul) yul=p3y; if(p3y>yor) yor=p3y;
 if(p4x<xul) xul=p4x; if(p4x>xor) xor=p4x;
 if(p4y<yul) yul=p4y; if(p4y>yor) yor=p4y;
 zahlpush2(xul,yul); n=zahlpush2(xor,yor);
 if(n) errfun="pathbbox";
 return n;
}

void set_colorf(int n,int s,double r,double g,double b,double k)
{
 int ro,gr,bl;
 gs.farbnummer=set_color(n,s,idfix(255.*(r)),idfix(255.*(g)),idfix(255.*(b)),
			 idfix(255.*(k)), &ro,&gr,&bl);
 darflag=darflag_farbe=1;
}

void get_colorf(int farbnr,double *r,double *g,double *b)
{
 int ro,gr,bl;
 get_color(farbnr,&ro,&gr,&bl);
 *r=ro/255.; *g=gr/255.; *b=bl/255.;
}

int setrgbcolor()	/* r g b setrgbcolor --> - */
{
 double r,g,b;
 int n;
 if((n=zahlpop(&b))==0 && (n=zahlpop(&g))==0 && (n=zahlpop(&r))==0)
	set_colorf(MAXXFARB-1,RGB,r,g,b,0.);
 NRETURN("setrgbcolor");
}
int sethsbcolor()	/* h s b sethsbcolor --> - */
{
 double h,s,b;
 int n;
 if((n=zahlpop(&b))==0 && (n=zahlpop(&s))==0 && (n=zahlpop(&h))==0)
	set_colorf(MAXXFARB-1,HSB,h,s,b,0.);
 NRETURN("sethsbcolor");
}
int setcmykcolor()	/* c m y k setcmykcolor --> - */
{
 double c,m,y,k;
 int n;
 if((n=zahlpop(&k))==0 && (n=zahlpop(&y))==0 && (n=zahlpop(&m))==0
    && (n=zahlpop(&c))==0)
	set_colorf(MAXXFARB-1,CMYK,c,m,y,k);
 NRETURN("setcmykcolor");
}

int currentrgbcolor()	/* currentrgbcolor -->  r g b */
{
 REAL r2,g2,b2;
 int n;
 get_colorf(gs.farbnummer,&r2.d,&g2.d,&b2.d);
 push(TYP_REAL,r2.n[0],r2.n[1]);
 push(TYP_REAL,g2.n[0],g2.n[1]);
 n=push(TYP_REAL,b2.n[0],b2.n[1]);
 NRETURN("currentrgbcolor");
}

int eq() {return eqvergleich("eq",0);}	/* a b eq --> bool */
int ne() {return eqvergleich("ne",1);}	/* a b ne --> bool */
int lt() {return vergleich("lt",1);}	/* a b lt --> bool */
int le() {return vergleich("le",2);}	/* a b le --> bool */
int gt() {return vergleich("gt",3);}	/* a b gt --> bool */
int ge() {return vergleich("ge",4);}	/* a b ge --> bool */

int eqvergleich(char* str,int flag)
{
 int v,n;
 WORD att,att2; long a,b,a2,b2;
 REAL x;
 if((att=pop(&a,&b))==0 || (att2=pop(&a2,&b2))==0) return err(str,STACKUNDER);
 switch(((att&TYPEMASK)<<8) + (att2&TYPEMASK))
  {case ((TYP_INT<<8)+TYP_INT):	v=(b==b2);
   CASE ((TYP_INT<<8)+TYP_REAL):	x.n[1]=b2;x.n[0]=a2; v=(x.d==b);
   CASE ((TYP_REAL<<8)+TYP_INT):	x.n[1]=b; x.n[0]=a;  v=(x.d==b2);
   CASE ((TYP_REAL<<8)+TYP_REAL):	v=(a==a2 && b==b2);
   CASE ((TYP_NAME<<8)+TYP_NAME):
   case ((TYP_NAME<<8)+TYP_STR):
   case ((TYP_STR<<8)+TYP_NAME):
   case ((TYP_STR<<8)+TYP_STR):	v=(strcmp((char *)b,(char *)b2)==0); break;
   default:	v=(att==att2 && a==a2 && b==b2);
  }
 if(v) v=1;
 if(flag) v^=1;
 n=push(TYP_BOOL,0,v);
 if(n) errfun=str;
 return n;
}
#define VERGL(x,y) (x>y?1:(x<y? -1:0))
int vergleich(char* str,int flag)
{
 int v,n=0;
 WORD att,att2; long a,b,a2,b2;
 REAL x,x2;
 if((att=pop(&a,&b))==0 || (att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else switch(((att&TYPEMASK)<<8) + (att2&TYPEMASK))
  {case ((TYP_INT<<8)+TYP_INT):	 v=b2-b;
   CASE ((TYP_INT<<8)+TYP_REAL): x2.n[1]=b2; x2.n[0]=a2; v=VERGL(x2.d,b);
   CASE ((TYP_REAL<<8)+TYP_INT): x.n[1]=b; x.n[0]=a; v=VERGL(b2,x.d);
   CASE ((TYP_REAL<<8)+TYP_REAL):x.n[1]=b;x.n[0]=a; x2.n[1]=b2;x2.n[0]=a2;
				 v=VERGL(x2.d,x.d);
   CASE ((TYP_NAME<<8)+TYP_NAME):
   case ((TYP_NAME<<8)+TYP_STR):
   case ((TYP_STR<<8)+TYP_NAME):
   case ((TYP_STR<<8)+TYP_STR):	v=strcmp((char *)b,(char *)b2); break;
   default:	n=TYPECHECK_NONUM;
  }
 switch(flag)
	{case 1: if(v<0) v=1; else v=0;
	 CASE 2: if(v<=0) v=1; else v=0;
	 CASE 3: if(v>0) v=1; else v=0;
	 CASE 4: if(v>=0) v=1; else v=0;
	}
 if(n==0) n=push(TYP_BOOL,0,v);
 if(n) errfun=str;
 return n;
}

int psif()		/* bool proc if --> - */
{
 WORD att,att2; long a,b,a2,psbool;
 int n=0;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_PROC) n=TYPECHECK_NOPROC;
 else if((att2=pop(&a2,&psbool))==0) n=STACKUNDER;
 else if((att2 & TYPEMASK)!=TYP_BOOL) n=TYPECHECK_NOBOOL;
 else if(psbool)
	{if((n=push(att,a,b))==0) n=exec();}
 NRETURN("if");
}

int psifelse()	/* bool proc1 proc2 ifelse --> - */
{
 WORD atti,atte,att2; long ai,bi,ae,be,a2,psbool;
 int n=0;
 if((atte=pop(&ae,&be))==0) n=STACKUNDER;
 else if((atte & TYPEMASK)!=TYP_PROC) n=TYPECHECK_NOPROC;
 else if((atti=pop(&ai,&bi))==0) n=STACKUNDER;
 else if((atti & TYPEMASK)!=TYP_PROC) n=TYPECHECK_NOPROC;
 else if((att2=pop(&a2,&psbool))==0) n=STACKUNDER;
 else if((att2 & TYPEMASK)!=TYP_BOOL) n=TYPECHECK_NOBOOL;
 else {if(psbool)
	{if((n=push(atti,ai,bi))==0) n=exec();}
       else
	{if((n=push(atte,ae,be))==0) n=exec();}
      }
 NRETURN("ifelse");
}

int bitshift()		/* int shift bitshift --> int */
{
 int n;
 WORD att,att2; long a,b,a2,b2;
 REAL z;
 att=pop(&a,&b);
 att2=pop(&a2,&b2);
 if(att2==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_INTEGER || (att2 & TYPEMASK)!=TYP_INTEGER)
	n=TYPECHECK_NOINT;
 else
  {if(b>0) b2 <<= b;
   else if(b<0) b2 >>= (-b);
   n=intpush(b2);
  }
 if(n) errfun="bitshift";
 return n;
}

int psrand()		/* rand --> int */
{
 int n;
 n=intpush(rand());
 if(n) errfun="rand";
 return n;
}

static int rand_startwert=1;

int pssrand()		/* int srand --> - */
{
 WORD att; long a,b;
 int n=0;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_INTEGER) n=TYPECHECK_NOINT;
 else srand(rand_startwert=b);
 if(n) errfun="srand";
 return n;
}

int psrrand()		/* rrand --> int */
{
 int n;
 n=intpush(rand_startwert);
 if(n) errfun="rand";
 return n;
}

int length()	/* dict length --> int */
{		/* string length --> int */
 int n=0;	/* p_array length --> int */
 WORD att; long a,b,laenge;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else
  {switch (att & TYPEMASK)
	{case TYP_DICT:	laenge=((struct dictionary *)b)->i;
	 CASE TYP_STRING:laenge=a;
	 CASE TYP_ARRAY: laenge=a;
	 DEFAULT: n=TYPECHECK_NOARRAY;
	}
   if(n==0) n=intpush(laenge);
  }
 if(n) errfun="length";
 return n;
}

int maxlength()	/* dict maxlength --> int */
{
 int n=0;
 WORD att; long a,b,laenge;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_DICT) n=TYPECHECK_NODICT;
 else n=intpush(a);
 if(n) errfun="maxlength";
 return n;
}

void setdictname(struct dictionary* dicy,char* name)
{
 char *s;
 s=(char *)malloc(strlen(name)+1);
 strcpy(s,name);
 dicy->name=s;
}

int psdictstack()		/* array dictstack --> array */
{
 WORD att; long a,b;
 struct Dictstackeintrag *dse;
 struct stackeintrag *p;
 int i,n=0;
 char *str;
 ULONG key;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else  {p=(struct stackeintrag *)b;
	for(i=0,dse=dictstack;dse!=NULL;dse=dse->next,i++)  ;
	p= &p[i-1];
	for(dse=dictstack;dse!=NULL;dse=dse->next,p--)
		{p->attr=TYP_NAME; str=dse->dict->name;
		 if((key=getkey((UBYTE*)str))==0) return err("dictstack",MEMFULL);
		 p->a=key; p->b=(long)str;
		}
	n=push(att,a,b);
       }
 if(n) errfun="dictstack";
 return n;
}

int countdictstack()	/* countdictstack --> int */
{
 int i,n;
 struct Dictstackeintrag *dse;
 for(i=0,dse=dictstack;dse!=NULL;dse=dse->next,i++)  ;
 n=intpush(i);
 if(n) errfun="countdictstack";
 return n;
}

int readstring()	/* file string readstring --> string bool */
{
 WORD att,att2; long a,b,a2,b2;
 int n,i,c;
 char *s;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STRING) n=TYPECHECK_NOSTR;
 else if((att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if((att2 & TYPEMASK)!=TYP_FILE) n=TYPECHECK_NOFILE;
 else
  {for(s=(char *)b,i=0; i<a; i++)
	if((c=fileread((FILE*)b2))==EOF) break;
	else *s++ =c;
   if(c==EOF) {*s=0; a=i; c=0;}
   else c=1;
   push(att,a,b);
   n=push(TYP_BOOL,0,c);
  }
 if(n) errfun="readstring";
 return n;
}
int fileread(FILE *fp)
{
 if(fp!=NULL) return getc(fp);
 return getc(stdinfile);
}

int readhexstring()	/* file string readhexstring --> string bool */
{
 WORD att,att2; long a,b,a2,b2;
 int n,i,c;
 char *s;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STRING) n=TYPECHECK_NOSTR;
 else if((att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if((att2 & TYPEMASK)!=TYP_FILE) n=TYPECHECK_NOFILE;
 else
  {for(s=(char *)b,i=c=0; c!=EOF && i<a; i++)
	{while((c=fileread((FILE *)b2))!=EOF && !isxdigit(c))  ;
	 if(c==EOF) break;
	 n=ascitodigit(c);
	 while((c=fileread((FILE *)b2))!=EOF && !isxdigit(c))  ;
	 *s++ =(n<<4)+ascitodigit(c);
	}
   if(c==EOF) {*s=0; a=i; c=0;}
   else c=1;
   push(att,a,b);
   n=push(TYP_BOOL,0,c);
  }
 if(n) errfun="readhexstring";
 return n;
}

int makehexstr(char *str)
{
 int n,c1,c2;
 char *s,*s2;
 for(s2=s=str;*s;) /* nicht Hex-Zeichen herausnehmen */
	{do {c1= *s++;} while (!isxdigit(c1) && c1);
	 if(c1==0) break;
	 *s2++ = c1;
	}
 *s2=0;
 s2=s=str;
 if((n=strlen(s))&1) c1=0;
 else {c1= *s++; n--;}
 c2= *s++; n--;
 *s2++ = (ascitodigit(c1)<<4)+ascitodigit(c2);
 for(;n>0;n-=2)
	{c1= *s++; c2= *s++;
	 *s2++ = (ascitodigit(c1)<<4)+ascitodigit(c2);
	}
 return s2-str;
}

int readline()	/* file string readline --> string bool */
{
 WORD att,att2; long a,b,a2,b2;
 int n,i,c;
 char *s;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STRING) n=TYPECHECK_NOSTR;
 else if((att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if((att2 & TYPEMASK)!=TYP_FILE) n=TYPECHECK_NOFILE;
 else
  {for(s=(char *)b,i=0; i<a; i++)
	if((c=fileread((FILE *)b2))==EOF || c=='\n') break;
	else *s++ =c;
   if(i<a) {*s=0; a=i;}
   push(att,a,b);
   n=push(TYP_BOOL,0,c=='\n'?1:0);
  }
 if(n) errfun="readline";
 return n;
}

static int bitmax;		/* fuer image und setgrau */
static WORD proc_att; long proc_a,proc_b; /* fuer image und bitslesen */
static WORD proc2_att,proc3_att;		/* fr colorimage */
static long proc2_a,proc2_b,proc3_a,proc3_b;	/* fr colorimage */

int image()			/* w h bpp matrix proc image --> - */
{
 WORD att2,att3; long a2,b2,a3,bpp;
 int n,w,h,bit,altbit,flag,i;
 double matrix[6],x,y,xmax;
 struct stackeintrag *p;
 REAL z;
 if((proc_att=pop(&proc_a,&proc_b))==0) n=STACKUNDER;
 else if((proc_att & TYPEMASK)!=TYP_PROC) n=TYPECHECK_NOPROC;
 else if((att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if((att2 & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else if((att3=pop(&a3,&bpp))==0) n=STACKUNDER;
 else if((att3 & TYPEMASK)!=TYP_INT) n=TYPECHECK_NOINT;
 else if((n=intzahlpop2(&w,&h))==0)
  {gsave(); initgraphics();
   p=(struct stackeintrag *)b2;
   for(n=0;n<6;n++,p++)
	{if(ISINT(p)) z.d=p->b; else {z.n[1]=p->b; z.n[0]=p->a;}
	 matrix[n]= z.d;
	}
   ctm_invert(matrix);
   ctm_multiplikation(matrix,gs.ctm);
   zahlpush(1.); setlinewidth();
   xmax=w-0.5;
   bitmax=(1<<bpp)-1;
   for(flag=2,y=0.5;y<h;y+=1.)
    {altbit=bitslesen(bpp,flag);
     if(altbit<0) return err("image",altbit);
     for(movetoxy(0.,y),x=1.;x<xmax;x+=1.)
	{bit=bitslesen(bpp,0);
	 if(bit<0) return err("image",bit);
	 if(bit!=altbit) {setgrau(altbit); linetoxy(x,y); altbit=bit;}
	}
     setgrau(altbit); linetoxy(x,y);
     flag=1;
    }
   stroke();
   n=grestore();
  }
 if(n) errfun="image";
 return n;
}
void setgrau(int bitmuster) /* provi. */
{
 double z;
 if(currentpoint()==0) {stroke(); moveto();}
 z=((double)bitmuster)/bitmax;
 wie_setgray(z);
}

int imagemask()		/* w h invers matrix proc imagemask --> - */
{
 WORD att2,att3; long a2,b2,a3,invers;
 int n,w,h,bit,altbit,flag;
 double matrix[6],x,y,xmax;
 struct stackeintrag *p;
 REAL z;
 if((proc_att=pop(&proc_a,&proc_b))==0) n=STACKUNDER;
 else if((proc_att & TYPEMASK)!=TYP_PROC) n=TYPECHECK_NOPROC;
 else if((att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if((att2 & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else if((att3=pop(&a3,&invers))==0) n=STACKUNDER;
 else if((att3 & TYPEMASK)!=TYP_BOOL) n=TYPECHECK_NOBOOL;
 else if((n=intzahlpop2(&w,&h))==0)
  {gsave(); initgraphics();
   p=(struct stackeintrag *)b2;
   for(n=0;n<6;n++,p++)
	{if(ISINT(p)) z.d=p->b; else {z.n[1]=p->b; z.n[0]=p->a;}
	 matrix[n]= z.d;
	}
   ctm_invert(matrix);
   ctm_multiplikation(matrix,gs.ctm);
   zahlpush(1.); setlinewidth();
   xmax=w-0.5;
   flag=2;
   for(y=0.5;y<h;y+=1.)
    {altbit=bitlesen(flag);
     if(altbit<0) return err("imagemask",altbit);
     altbit ^= invers;
     if(!altbit) movetoxy(0.,y);
     for(x=1.;x<xmax;x+=1.)
	{bit=bitlesen(0);	/* bit=0=Linie zeichnen */
	 if(bit<0) return err("imagemask",bit);
	 bit ^= invers;
	 if(!altbit) {if(bit) linetoxy(x,y);}
	 else if(!bit) movetoxy(x,y);
	 altbit=bit;
	}
     if(!altbit) linetoxy(x,y);
     stroke();
     flag=1;
    }
   n=grestore();
  }
 if(n) errfun="imagemask";
 return n;
}
int bitlesen(int flag)
{
 static WORD att2; static long a2=0;
 static char *str;
 static int i=0,j=0,bits;
 int bit,n;
 if(flag) {j=0; if(flag>1) i=a2=0;}
 if(j==0)
  {if(i>=a2)	{push(proc_att,proc_a,proc_b); if((n=exec())!=0) return n;
		 if((att2=pop(&a2,(long*)&str))==0) return STACKUNDER;
		 if((att2 & TYPEMASK)!=TYP_STRING) return TYPECHECK_NOSTR;
		 i=0;
		}
   bits=str[i++]; j=0x80;
  }
 if(bits & j) bit=1; else bit=0;
 j >>= 1;
 return bit;
}
int bitslesen(int bpp,int flag)	/* provi. */
{
 static WORD att2; static long a2=0;
 static char *str;
 static int i=0,j=0,bits;
 static char maskshift[128]=
/* 0 1 2 3 4 5 6 7 8 9 A B C D E F 10 1 2 3 4 5 6 7 8 9 A B C D E F */
  {0,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1, 5,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1,
   6,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1, 5,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1,
   7,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1, 5,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1,
   6,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1, 5,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1};
 int bit,n;
 if(flag) {j=0; if(flag>1) i=a2=0;}
 if(j==0)
  {if(i>=a2)	{push(proc_att,proc_a,proc_b); if((n=exec())!=0) return n;
		 if((att2=pop(&a2,(long*)&str))==0) return STACKUNDER;
		 if((att2 & TYPEMASK)!=TYP_STRING) return TYPECHECK_NOSTR;
		 i=0;
		}
   bits=str[i++];
   switch(bpp) {case 2:j=0xC0; CASE 4:j=0xF0; CASE 8:j=0xFF; DEFAULT:j=0x80;}
  }
 bit=(bits & j); if((j&1)==0)  bit >>= maskshift[j>>1];
 j >>= bpp;
 return bit;
}
int colorbitslesen(int bpp,int flag)	/* provi. */
{
 static WORD att2; static long a2=0,a22,a23;
 static char *str,*str2,*str3;
 static int i=0,j=0,bits;
 static char maskshift[128]=
/* 0 1 2 3 4 5 6 7 8 9 A B C D E F 10 1 2 3 4 5 6 7 8 9 A B C D E F */
  {0,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1, 5,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1,
   6,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1, 5,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1,
   7,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1, 5,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1,
   6,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1, 5,1,2,1,3,1,2,1,4,1,2,1,3,1,2,1};
 int bit,n;
 if(flag) {j=0; if(flag>1) i=a2=0;}
 if(j==0)
  {if(i>=a2)	{push(proc_att,proc_a,proc_b); if((n=exec())!=0) return n;
		 if((att2=pop(&a2,(long*)&str))==0) return STACKUNDER;
		 if((att2 & TYPEMASK)!=TYP_STRING) return TYPECHECK_NOSTR;
		 i=0;
		 push(proc2_att,proc2_a,proc2_b); if((n=exec())!=0) return n;
		 if((att2=pop(&a22,(long*)&str2))==0) return STACKUNDER;
		 if((att2 & TYPEMASK)!=TYP_STRING) return TYPECHECK_NOSTR;
		 push(proc3_att,proc3_a,proc3_b); if((n=exec())!=0) return n;
		 if((att2=pop(&a23,(long*)&str3))==0) return STACKUNDER;
		 if((att2 & TYPEMASK)!=TYP_STRING) return TYPECHECK_NOSTR;
		}
   bits=str[i++]; /* provi.: nur Rot auswerten */
   switch(bpp) {case 2:j=0xC0; CASE 4:j=0xF0; CASE 8:j=0xFF; DEFAULT:j=0x80;}
  }
 bit=(bits & j); if((j&1)==0)  bit >>= maskshift[j>>1];
 j >>= bpp;
 return bit;
}
int linetoxy(double x,double y)
{
 gs.aktx=PP*x+RR*y+TT;  gs.akty=QQ*x+SS*y+UU; /* wie in setze_aktgrafikpunkt */
/* if(!gs.aktflag) return NOAKTPOINT; */
 return setze_pathelement(LINETO,gs.aktx,gs.akty,0.,0.,0.,0.);
}
int movetoxy(double x,double y)
{
 gs.aktx=PP*x+RR*y+TT;  gs.akty=QQ*x+SS*y+UU; /* wie in setze_aktgrafikpunkt */
 gs.aktflag=1;
 return setze_pathelement(MOVETO,gs.aktx,gs.akty,0.,0.,0.,0.);
}

int colorimage()	/* w h bpp matrix proc proc2 proc3 true 3 colorimage --> - */
{
 WORD att,att2,att3; long a,b,a2,b2,a3,bpp;
 int n,w,h,bit,altbit,flag,i;
 double matrix[6],x,y,xmax;
 struct stackeintrag *p;
 REAL z;
 if((att=pop(&a,&b))==0 || (att=pop(&a,&b))==0) /* provisorisch */
		 n=STACKUNDER;
 else if((proc3_att=pop(&proc3_a,&proc3_b))==0) n=STACKUNDER;
 else if((proc2_att=pop(&proc2_a,&proc2_b))==0) n=STACKUNDER;
 else if((proc_att=pop(&proc_a,&proc_b))==0) n=STACKUNDER;
 else if((proc_att & TYPEMASK)!=TYP_PROC || (proc2_att & TYPEMASK)!=TYP_PROC
	 || (proc3_att & TYPEMASK)!=TYP_PROC) n=TYPECHECK_NOPROC;
 else if((att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if((att2 & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else if((att3=pop(&a3,&bpp))==0) n=STACKUNDER;
 else if((att3 & TYPEMASK)!=TYP_INT) n=TYPECHECK_NOINT;
 else if((n=intzahlpop2(&w,&h))==0)
  {gsave(); initgraphics();
   p=(struct stackeintrag *)b2;
   for(n=0;n<6;n++,p++)
	{if(ISINT(p)) z.d=p->b; else {z.n[1]=p->b; z.n[0]=p->a;}
	 matrix[n]= z.d;
	}
   ctm_invert(matrix);
   ctm_multiplikation(matrix,gs.ctm);
   zahlpush(1.); setlinewidth();
   xmax=w-0.5;
   bitmax=(1<<bpp)-1;
   for(flag=2,y=0.5;y<h;y+=1.)
    {altbit=colorbitslesen(bpp,flag);
     if(altbit<0) return err("image",altbit);
     for(movetoxy(0.,y),x=1.;x<xmax;x+=1.)
	{bit=colorbitslesen(bpp,0);
	 if(bit<0) return err("image",bit);
	 if(bit!=altbit) {setgrau(altbit); linetoxy(x,y); altbit=bit;}
	}
     setgrau(altbit); linetoxy(x,y);
     flag=1;
    }
   stroke();
   n=grestore();
  }
 if(n) errfun="colorimage";
 return n;
}

int invertmatrix()		/* matrix1 matrix2 invertmatrix --> matrix2 */
{
 WORD att,att2; long a,b,a2,b2;
 int n;
 struct stackeintrag *p;
 REAL z;
 double matrix[6];
 if((att=pop(&a,&b))==0 || (att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_ARRAY ||
	 (att2 & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else
  {p=(struct stackeintrag *)b2;
   for(n=0;n<6;n++,p++)
	{if(ISINT(p)) z.d=p->b; else {z.n[1]=p->b; z.n[0]=p->a;}
	 matrix[n]= z.d;
	}
   if(ctm_invert(matrix)==0) n=UNDEFINEDRESULT;
   else	{p=(struct stackeintrag *)b2;
	 for(n=0;n<6;n++,p++)
		{p->attr=TYP_REAL; z.d=matrix[n]; p->a=z.n[0]; p->b=z.n[1];}
	 n=push(att2,a2,b2);
	}
  }
 if(n) errfun="invertmatrix";
 return n;
}

int matrix()		/* matrix --> [1.0 0.0 0.0 1.0 0.0 0.0] */
{
 int n;
 double matrix[6]={1.,0.,0.,1.,0.,0.};
 struct stackeintrag *p;
 if((p=(struct stackeintrag *)calloc(6,sizeof(struct stackeintrag)))==NULL)
	n=MEMFULL;
 else n=pushmatrix(matrix,p);
 NRETURN("matrix");
}
int pushmatrix(double* matrix,struct stackeintrag* p0)
{
 struct stackeintrag *p;
 REAL z;
 int i;
 for(p=p0,i=0;i<6;i++,p++)
	{z.d=matrix[i]; p->attr=TYP_REAL; p->b=z.n[1]; p->a=z.n[0];}
 return push(TYP_ARRAY+ZUS,6,(long)p0);
}

static double einheitsmatrix[6]={1.,0.,0.,1.,0.,0.};

int identmatrix()	/* matrix identmatrix --> [1.0 0.0 0.0 1.0 0.0 0.0] */
{
 WORD att; long a,b;
 int n;
 struct stackeintrag *p;
 REAL z;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else if(a<6) n=RANGECHECK;
 else
  {p=(struct stackeintrag *)b;
   for(n=0;n<6;n++,p++)
	{z.d=einheitsmatrix[n]; p->attr=TYP_REAL; p->b=z.n[1]; p->a=z.n[0];}
   n=push(att,a,b);
  }
 if(n) errfun="identmatrix";
 return n;
}

int currentmatrix()		/* matrix currentmatrix --> CTM */
{
 WORD att; long a,b;
 int n;
 struct stackeintrag *p;
 REAL z;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else if(a<6) n=RANGECHECK;
 else
  {p=(struct stackeintrag *)b;
   for(n=0;n<6;n++,p++)
	{z.d=gs.ctm[n]; p->attr=TYP_REAL; p->b=z.n[1]; p->a=z.n[0];}
   n=push(att,a,b);
  }
 if(n) errfun="currentmatrix";
 return n;
}

int setmatrix()		/* matrix setmatrix --> - */
{
 WORD att; long a,b;
 int n=0,i;
 struct stackeintrag *p;
 REAL z;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else if(a<6) n=RANGECHECK;
 else
  {p=(struct stackeintrag *)b;
   for(i=0;i<6;i++,p++)
	{if(ISREAL(p)) {z.n[1]=p->b; z.n[0]=p->a; gs.ctm[i]=z.d;}
	 else if(ISINT(p)) {gs.ctm[i]=p->b;}
	 else {n=TYPECHECK_NONUM; break;}
	}
  }
 if(n) errfun="setmatrix";
 return n;
}

int psread()	/* file read --> code true */
{		/*	     --> false */
 WORD att; long a,b;
 int n,i,c;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_FILE) n=TYPECHECK_NOFILE;
 else
  {c=fileread((FILE *)b);
   if(c==EOF) n=push(TYP_BOOL,0,0);
   else {intpush(c&0xFF); n=push(TYP_BOOL,0,1);}
  }
 if(n) errfun="read";
 return n;
}

int ashow()		/* ax ay string ashow --> - */
{
 WORD att; long a,b;
 int n;
 double ax,ay;
 char *s,str[2];
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STR) n=TYPECHECK_NOSTR;
 else if((n=zahlpop2(&ax,&ay))==0)
	{str[1]=0;
	 for(s=(char *)b; *str= *s; s++)
	  {push(TYP_STRING+ZUS,1,(long)str); show();
	   zahlpush2(ax,ay); n=rmoveto();
	} }
 if(n) errfun="ashow";
 return n;
}

int aload()		/* array aload --> x0 ... xn array */
{
 WORD att; long a,b;
 int n,i;
 struct stackeintrag *p;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else	{p=(struct stackeintrag *)b;
	 for(i=n=0; i<a && n==0; i++,p++) n=push(p->attr,p->a,p->b);
	 if(n==0) n=push(att,a,b);
	}
 if(n) errfun="aload";
 return n;
}

int settransfer()		/* proc settransfer --> - */
{
 WORD att; long a,b; int n;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_PROC) n=TYPECHECK_NOPROC;
 else
  {gs.transferfunc.attr=att;gs.transferfunc.a=a;gs.transferfunc.b=b; return 0;}
 NRETURN("settransfer");
}

int currenttransfer()	/* currenttransfer --> proc */
{
 static char *leer=" ";
 long b; int n;
 if((b=gs.transferfunc.attr)==0) n=push(TYP_PROC+EXECUTABLE+ZUS,0,(long)leer);
 else n=push(gs.transferfunc.attr,gs.transferfunc.a,gs.transferfunc.b);
 NRETURN ("currenttransfer");
}

long startzeit=0;
int usertime()		/* usertime --> millisec */
{
 int n;
 timeb_t zeit;
 ftime(&zeit);
 n=intpush(zeit.time*1000+zeit.millitm-startzeit);
 NRETURN ("usertime");
}

int getinterval()	/* string1 index zahl getinterval --> string2 */
{			/* array1 index zahl getinterval --> array2 */
 WORD att,att2,att3; long a,zahl,a2,indx,a3,b3;
 long anzahl;
 struct stackeintrag *p1,*p2,*p;
 int i,n=0;
 char *s1,*s2;
 if((att=pop(&a,&zahl))==0 ||
    (att2=pop(&a2,&indx))==0 || (att3=pop(&a3,&b3))==0) n=STACKUNDER;
 else if(!IS_INT(att) || !IS_INT(att2)) n=TYPECHECK_NOINT;
 else
  {if((anzahl=zahl+indx)>a3 || zahl<0 || indx<0) n=RANGECHECK;
   else switch(att3 & TYPEMASK)
	{case TYP_STRING:
		s1=(char *)b3; s1= &s1[indx]; s2=(char *)malloc(anzahl+1);
		if(s2==NULL) n=MEMFULL;
		else { for(i=0;i<zahl;i++) s2[i]= *s1++;
		       s2[i]=0;  n=push(TYP_STRING+ZUS,zahl,(long)s2);   }
	 CASE TYP_ARRAY:
		p1=(struct stackeintrag *)b3; p1= &p1[indx];
		p2=(struct stackeintrag *)
				malloc(anzahl*sizeof(struct stackeintrag));
		if(p2==NULL) n=MEMFULL;
		else {for(p=p2,i=0;i<zahl;i++,p1++,p++)
			{p->attr=p1->attr; p->a=p1->a; p->b=p1->b;}
		      n=push(TYP_ARRAY+ZUS,zahl,(long)p2);
		     }
	 DEFAULT: n=TYPECHECK_NOARRAY;
  }	}
 if(n) errfun="getinterval";
 return n;
}

int putinterval()	/* string1 index string2 putinterval --> - */
{			/* array1 index array2 putinterval --> - */
 WORD att,att2,att3; long a,b,a2,indx,a3,b3;
 struct stackeintrag *p1,*p2;
 int i,n=0;
 char *s1,*s2;
 if((att=pop(&a,&b))==0 ||
    (att2=pop(&a2,&indx))==0 || (att3=pop(&a3,&b3))==0) n=STACKUNDER;
 else if(!IS_INT(att2)) n=TYPECHECK_NOINT;
 else if((att & TYPEMASK)!=(att3 & TYPEMASK)) n=TYPECHECK_NOARRAY;
  {if(indx+a > a3 || indx<0) n=RANGECHECK;
   else switch(att3 & TYPEMASK)
	{case TYP_STRING:
		s1=(char *)b3; s1= &s1[indx]; s2=(char *)b;
		for(i=0;i<a;i++) *s1++ = *s2++;
	 CASE TYP_ARRAY:
		p1=(struct stackeintrag *)b3; p1= &p1[indx];
		p2=(struct stackeintrag *)b;
		for(i=0;i<a;i++,p1++,p2++)
			{p1->attr=p2->attr; p1->a=p2->a; p1->b=p2->b;}
	 DEFAULT: n=TYPECHECK_NOARRAY;
  }	}
 if(n) errfun="putinterval";
 return n;
}

int astore()		/* any1 ... anyN array astore --> array */
{
 WORD att; long a,b;
 struct stackeintrag *p;
 int i,n=0;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if(!IS_ARRAY(att)) n=TYPECHECK_NOARRAY;
 else if(a<(i=getcount())) n=RANGECHECK;
 else	{p=(struct stackeintrag *)b; p= &p[i];
	 while(--i>=0) {p--; p->attr=pop(&p->a,&p->b);}
	 n=push(att,a,b);
	}
 NRETURN("astore");
}

int pathforall()	/* move line curve close pathforall --> - */
{
 double *z,x,y,x2,y2,x3,y3;
 int n=0,k;
 struct pfad path;
 WORD att,att2,att3,att4; long a,b,a2,b2,a3,b3,a4,b4;
 if((att=pop(&a,&b))==0 || (att2=pop(&a2,&b2))==0 ||
    (att3=pop(&a3,&b3))==0 || (att4=pop(&a4,&b4))==0) n=STACKUNDER;
 else if(!IS_PROC(att) || !IS_PROC(att2) || !IS_PROC(att3) || !IS_PROC(att4))
		n=TYPECHECK_NOPROC;
 else if(gs.path.ende==gs.path.anfang) n=NOPATH;
 else if(getpfad(&path,MAXPATH3)==NULL) n=MEMFULL;
 else
  {if(darflag) lineattribute_setzen();
   pfad_kopieren(&gs.path,&path);
   for(z=path.anfang;z<path.ende && n==0;)
    {switch(k=(int)(*z++))
	{case MOVETO:	 x= *z++; y= *z++; zahlpush2(x,y); push(att4,a4,b4);
	 CASE LINETO:	 x= *z++; y= *z++; zahlpush2(x,y); push(att3,a3,b3);
	 CASE CLOSEPATH: push(att,a,b);
	 CASE CURVETO:	 x2= *z++; y2= *z++; x3= *z++; y3= *z++;
			 x= *z++; y= *z++;
			 zahlpush2(x2,y2); zahlpush2(x3,y3); zahlpush2(x,y);
			 push(att2,a2,b2);
	 DEFAULT: n=PATH_CORRUPT;
	}
     if(n==0) n=exec();
  } }
 NRETURN("pathforall");
}

int file()			/* string zugriff file --> file */
{
 WORD att,att2; long a,a2; char *b,*b2;
 int n=0;
 FILE *fp;
 if((att=pop(&a,(long*)&b))==0 || (att2=pop(&a2,(long*)&b2))==0) n=STACKUNDER;
 else if((!IS_STR(att2) && !IS_NAME(att2)) || !IS_STR(att)) n=TYPECHECK_NOSTR;
 else	{DEBUG(1,printf("(%s) (%s) file -->",b2,b));
	 if(strcmp("%stdin",(char *)b2)==0) fp=stdinfile;
	 else if(strcmp("%stdout",(char *)b2)==0) fp=stdoutfile;
	 else if((fp=fopen1(b2,b))==NULL) n=UNDEFINEDFILE;
	 if(n==0) n=push(TYP_FILE,0,(long)fp);
	 DEBUG(1,printf(" fp=%ld\n",fp));
	}
 NRETURN("file");
}

static int eexec_flag=0;
int closefile()			/* file closefile --> - */
{
 WORD att; long a; FILE *b;
 int n=0;
 if((att=pop(&a,(long*)&b))==0) n=STACKUNDER;
 else if(!IS_FILE(att)) n=TYPECHECK_NOFILE;
 else	{DEBUG(1,printf("closefile() fp=%ld\n",b));
	 if(b==currfile && --currfile_count>0)
		{if(eexec_flag) {eexec_flag=0; n=end();}}
	 else fclose(b);
	}
 NRETURN("closefile");
}

int eexec()			/* file eexec --> - */
{			/* string eexec --> - */
 WORD att; long a; FILE *b;
 int n;
 if((att=pop(&a,(long*)&b))==0) n=STACKUNDER;
 else
  {DEBUG(1,printf("eexec() fp=%ld\n",b));
   if(b!=currfile)
	{ printf("ERROR in eexec: geht bisher nur mit currentfile\n");
	  printf("                und nur mit entpackten Fonts\n");   }
   eexec_flag=1; currfile_count++;
   namepush("systemdict"); psload(); n=begin();
  }
 NRETURN("eexec");
}

int run()		/* /Name run --> - */
{
 struct stackeintrag *p;
 int n;
 if(iopst==0) n=STACKUNDER;
 else if(!ISNAME(p= &opstack[iopst-1]) && !ISSTRING(p)) n=TYPECHECK_NOSTR;
 else
  {DEBUG(1,printf("/%s run\n",p->b));
   n=push(TYP_STRING,1,(long)"r");
   if(n==0) if((n=file()) || (n=cvx()) || (n=exec())) return n;
  }
 NRETURN("run");
}

int concat()		/* matrix concat --> - */
{
 WORD att; long a; struct stackeintrag *p;
 int n=0,i;
 double matrix[6];
 REAL z;
 if((att=pop(&a,(long*)&p))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else
  {for(i=0;i<6;i++,p++)
	{if(ISINT(p)) z.d=p->b; else {z.n[1]=p->b; z.n[0]=p->a;}
	 matrix[i]= z.d;
	}
   ctm_multiplikation(matrix,gs.ctm);
  }
 NRETURN("concat");
}

int concatmatrix()	/* matrix1 matrix2 matrix3 concatmatrix  --> matrix3 */
{
 WORD att1,att2,att3; long a1,a2,a3; struct stackeintrag *p1,*p2,*p3;
 int n,i;
 double matrix1[6],matrix2[6];
 REAL z;
 if((att1=pop(&a3,(long*)&p3))==0 ||
    (att2=pop(&a2,(long*)&p2))==0 ||
    (att3=pop(&a1,(long*)&p1))==0) n=STACKUNDER;
 else if((att1 & TYPEMASK)!=TYP_ARRAY ||
	 (att2 & TYPEMASK)!=TYP_ARRAY ||
	 (att3 & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else
  {for(i=0;i<6;i++,p1++,p2++)
	{if(ISINT(p1)) z.d=p1->b; else {z.n[1]=p1->b; z.n[0]=p1->a;}
	 matrix1[i]= z.d;
	 if(ISINT(p2)) z.d=p2->b; else {z.n[1]=p2->b; z.n[0]=p2->a;}
	 matrix2[i]= z.d;
	}
   ctm_multiplikation(matrix1,matrix2);
   n=pushmatrix(matrix2,p3);
  }
 NRETURN("concatmatrix");
}

int search()		/* string suchstring search --> nach match vor true */
{			/* string suchstring search --> string false */
 WORD att,att2; long a,a2; char *b,*b2;
 long anach,amatch,bnach,bmatch;
 int n,i,psbool;
 if((att=pop(&a,(long*)&b))==0 || (att2=pop(&a2,(long*)&b2))==0) n=STACKUNDER;
 else if(!IS_STR(att) || !IS_STR(att2)) n=TYPECHECK_NOSTR;
 else	{if((i=s_index(b2,a2,b,a))== -1) {psbool=0;}
	 else	{psbool=1;
		 anach=a2-i-a; bnach= (long)&b2[i+a]; push(att2,anach,bnach);
		 amatch=a; bmatch= (long)&b2[i];  push(att2,amatch,bmatch);
		 a2=i;
		}
	 push(att2,a2,(long)b2);
	 n=boolpush(psbool);
	}
 NRETURN("search");
}

int anchorsearch()	/* string suchstring anchorsearch --> nach match true */
{			/* string suchstring anchorsearch --> string false */
 WORD att,att2; long a,a2; char *b,*b2;
 long anach,bnach;
 int n,psbool;
 if((att=pop(&a,(long*)&b))==0 || (att2=pop(&a2,(long*)&b2))==0) n=STACKUNDER;
 else if(!IS_STR(att) || !IS_STR(att2)) n=TYPECHECK_NOSTR;
 else	{if(a2<a || s_strcmp(b2,b,a)!=0) {psbool=0;}
	 else	{psbool=1;
		 anach=a2-a; bnach= (long)&b2[a]; push(att2,anach,bnach);
		 a2=a;
		}
	 push(att2,a2,(long)b2);
	 n=boolpush(psbool);
	}
 NRETURN("anchorsearch");
}

#define M128 128
//#define M128 2048 /*test*/

int token()	/* string token --> nachstring any true */
{		/* string token --> false */
 FILE *fp;	/*  file  token --> any true */
 int n;		/*  file  token --> false */
 char *feld;
 WORD att; long a,b;
 char *str,*f;
 int c,c0=0,i;
 feld=(char *)malloc(M128+2); /* Namenslaenge auf 128 begrenzt */
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if(IS_STR(att))
  {str=(char *)b;
   for(f=feld,i=0;i<a;i++)
	{c= *str++;
	 if(c==' ') {if(c0==0) continue; else break;}
	 if((*f++ =c)==0) break;
	 c0=c;
	}
   *f=0; b=(long)str;
   if(c0==0)
	n=boolpush(0);
   else	{n=push(att,a,b);
	 switch(feld[0])
	  {case '/': namepush(&feld[1]);
	   CASE '(': case '{': case '<': case '[': case ']':
	   case ')': case '}':
		printf("token() noch nicht fertig programmiert\n");/* provi. */
	   DEFAULT:
		att=load(getkey((UBYTE*)feld),(ulong*)&a,(ulong*)&b);
		if(att!=0)  n=push(att,a,b);
		else printf("fehler in token() feld='%s'\n",feld);
	  }
	 n=boolpush(1);
	}
  }
 else if(IS_FILE(att))
  {printf("token(FILE) geht noch nicht\n");/* provi. */
  }
 else n=TYPECHECK_NOSTR;
 NRETURN("token");
}

/********** string-Funktionen fuer Postscriptroutinen *********************/
/* Die Funktionen die mit 's_' beginnen erwarten Strings ohne 0-Abschluss */

int s_strcmp(char *s1,char *s2,int n)
{
 int c;
 UBYTE *su1=(UBYTE*)s1, *su2=(UBYTE*)s2;
 while(--n>=0) if((c= *su1++ - *su2++)!=0) return c;
 return c;
}

int s_index(char *s1,int n1,char *s2,int n2)
			/* Sucht den String s2 innerhalb von s1 und  */
{			/* gibt die Position zurueck (nicht gefunden = -1) */
 int i,c,j;
 char *p1,*p2;
 if(n2<=0) return 0;	/* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if(i>=n1) return -1; /* nicht gefunden */
	 c= *s1++;
	 if(c== *s2)
		{for(p1=s1,p2=s2,j=1; j<n2; j++)
			{c= *++p2;
			 if(*p1++!=c) break; /* noch nicht gefunden */
			}
		 if(j==n2) break; /* gefunden */
		}
	}
 return i;
}

/* Die cache-Funktionen werden eigentlich nicht gebraucht, muessen aber */
/* wegen Kompatibilitaet vorhanden sein */
int setcacheparams()	/* mark .. setcacheparams --> - */
{
 int n;
 n=cleartomark();
 NRETURN("setcacheparams");
}

int currentcacheparams()	/* currentcacheparams --> mark limit1 limit2 */
{
 int n;
 if((n=mark())==0) {intpush(1); n=intpush(1);}
 NRETURN("currentcacheparams");
}

static int cachelimit=1;
int setcachelimit()		/* limit setcachelimit --> - */
{
 int n;
 double x;
 if((n=zahlpop(&x))==0) cachelimit=idfix(x);
 NRETURN("setcachelimit");
}

int cachestatus()	/* cachestatus --> b bmax m mmax c cmax limit */
{
 int n,i;
 for(i=0;i<6;i++) intpush(0);
 n=intpush(cachelimit);
 NRETURN("cachestatus");
}

int widthshow()		/* ax ay zeichen string widthshow --> - */
{
 WORD att,att2; long a,b,a2,zeichen;
 int n;
 double ax,ay;
 char *s,str[2];
 if((att=pop(&a,&b))==0 || (att2=pop(&a2,&zeichen))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STR) n=TYPECHECK_NOSTR;
 else if((att2 & TYPEMASK)!=TYP_INT) n=TYPECHECK_NOINT;
 else if((n=zahlpop2(&ax,&ay))==0)
	{str[1]=0;
	 for(s=(char *)b; (*str= *s) && n==0; s++)
	  {push(TYP_STRING+ZUS,1,(long)str); n=show();
	   if(*str==zeichen) {zahlpush2(ax,ay); n=rmoveto();}
	} }
 if(n) errfun="widthshow";
 return n;
}

int awidthshow()	/* cx cy zeichen ax ay string awidthshow --> - */
{
 WORD att,att2; long a,b,a2,zeichen;
 int n;
 double ax,ay,cx,cy;
 char *s,str[2];
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((n=zahlpop2(&ax,&ay))!=0)  ;
 else if((att2=pop(&a2,&zeichen))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STR) n=TYPECHECK_NOSTR;
 else if((att2 & TYPEMASK)!=TYP_INT) n=TYPECHECK_NOINT;
 else if((n=zahlpop2(&cx,&cy))==0)
	{str[1]=0;
	 for(s=(char *)b; (*str= *s) && n==0; s++)
	  {push(TYP_STRING+ZUS,1,(long)str); show();
	   zahlpush2(ax,ay); n=rmoveto();
	   if(*str==zeichen) {zahlpush2(cx,cy); n=rmoveto();}
	} }
 if(n) errfun="awidthshow";
 return n;
}

int kshow()		/* proc string kshow --> - */
{
 WORD att,att2; long a,b,a2,b2;
 int n=0;
 double ax,ay;
 char *s,str[2];
 if((att=pop(&a,&b))==0 || (att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STR) n=TYPECHECK_NOSTR;
 else if((att2 & TYPEMASK)!=TYP_PROC) n=TYPECHECK_NOPROC;
 else	{str[1]=0;
	 for(s=(char *)b; (*str= *s++) && n==0;)
	  {push(TYP_STRING+ZUS,1,(long)str); n=show();
	   if(*s && !n) { intpush(*str); n=intpush(*s);
			  if(!n && (n=push(att2,a2,b2))==0) n=exec(); }
	} }
 NRETURN("kshow");
}

static int packing_status=0;
int setpacking()		/* bool setpacking --> - */
{
 WORD att; long a,b;
 int n=0;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_BOOL) n=TYPECHECK_NOBOOL;
 else packing_status=b;
 NRETURN("setpacking");
}
int currentpacking()	/* currentpacking --> bool */
{
 int n=0;
 n=boolpush(packing_status);
 NRETURN("setpacking");
}

int defaultmatrix()		/* matrix defaultmatrix --> matrix */
{
 WORD att; long a,b;
 int n;
 struct stackeintrag *p;
 REAL z;
 if((att=pop(&a,&b))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_ARRAY) n=TYPECHECK_NOARRAY;
 else if(a<6) n=RANGECHECK;
 else
  {p=(struct stackeintrag *)b;
   for(n=0;n<6;n++,p++)
	{z.d=ctminit[n]; p->attr=TYP_REAL; p->b=z.n[1]; p->a=z.n[0];}
   n=push(att,a,b);
  }
 NRETURN("defaultmatrix");
}

int initmatrix()		/* initmatrix --> -  (fuer EPS verboten) */ 
{
 int i;
 for(i=0;i<6;i++) gs.ctm[i]=ctminit[i];
 return 0;
}

int psnull()		/* null --> NULL */
{
 int n;
 n=push(TYP_NULL,0,0);
 NRETURN("null");
}

double zwischenwinkel(double x1,double y1,double x2,double y2)
{
 double w,dy;
 dy=y2-y1;
 if(x2>x1) w=atan(dy/(x2-x1));
 else if(x2<x1) w=PI-atan(dy/(x1-x2));
 else w=PI/2.;
 return w;
}

int arcto()		/* x1 y1 x2 y2 radius arcto --> xa ya xe ye */
{
 double x0,y0,x1,y1,x2,y2,xa,ya,xe,ye,xm,ym,radius;
 double alfa,alfa1,wa,we;
 int n,arcnflag;
 if((n=zahlpop(&radius))==0
    && (n=zahlpop2(&x2,&y2))==0
    && (n=zahlpop2(&x1,&y1))==0
    && (n=currentpoint())==0)
	{zahlpop2(&x0,&y0);	/* aktueller Punkt */
	 DEBUG(1,printf("arcto: %lf %lf   %lf %lf   %lf %lf  r=%lf\n",
				x0,y0,x1,y1,x2,y2,radius));
	 if(x1>x0) alfa1=atan((y1-y0)/(x1-x0));
	 else if(x1<x0) alfa1=PI-atan((y1-y0)/(x0-x1));
	 else alfa1=PI/2.;
	 drehen(alfa1,&x0,&y0); drehen(alfa1,&x1,&y1); drehen(alfa1,&x2,&y2);
	 if(x2<x1) alfa=atan((y2-y1)/(x1-x2));
	 else if(x2>x1) alfa=PI-atan((y2-y1)/(x2-x1));
	 else alfa=PI/2.;
	 if(alfa>PI) alfa=ZWEIPI-alfa;
	 if(alfa<0.) alfa= -alfa;
	 if(alfa<0.001 || alfa>PI-0.001)
	  {drehen(-alfa1,&x1,&y1); xa=xe=x1; ya=ye=y1;
	   zahlpush2(xe,ye); n=lineto();
	  }
	 else
	  {xm=xa=x1-radius/tan(alfa/2.); ya=y0;
	   if(y2<y0) ym=y0-radius; else ym=y0+radius;
	   xe=xm+radius*sin(alfa);
	   if(y2>y1) {ye=ym+radius*cos(alfa); arcnflag=0;}
	   else if(y2<y1) {ye=ym-radius*cos(alfa); arcnflag=1;}
	   drehen(-alfa1,&xa,&ya); drehen(-alfa1,&xe,&ye);
	   drehen(-alfa1,&xm,&ym);
	   wa=zwischenwinkel(xm,ym,xa,ya)/GRAD;
	   we=zwischenwinkel(xm,ym,xe,ye)/GRAD;
	   zahlpush2(xm,ym); zahlpush(radius); zahlpush2(wa,we);
	   if(arcnflag) n=arcn(); else n=arc();
	  }
	 if(n==0) {zahlpush2(xa,ya); n=zahlpush2(xe,ye);}
	}
 if(n!=0) errfun="arcto";
 return n;
}
void drehen(double w,double *x,double *y)
{
 double x0,y0,sinw,cosw;
 x0= *x; y0= *y;
 sinw=sin(w); cosw=cos(w);
 *x=cosw*x0+sinw*y0;
 *y=cosw*y0-sinw*x0;
}


/************* Postscript-Funktionen die mit Fonts zu tun haben *************/
static double	cachexul,cacheyul,cachexor,cacheyor,
		dicktex,dicktey;
long	len4=4;
int	painttype=0,p_wx,p_wy;
static int defaultfontflag=1;

int istfortranfont(Dictionary *fdic) {return (fdic->font->typ==2);} 

int findfont()		/* /Name findfont --> font */
{
 WORD att; long a,b;
 ULONG key;
 int n=0;
 static int dpflag=5;
 Dictionary *fdic;
 char fstr[ZL];
 if((att=pop(&a,&b))==0) {errfun="findfont"; return STACKUNDER;}
 if((att & TYPEMASK)!=TYP_STRING)
  {if((att & TYPEMASK)!=TYP_NAME) return TYPECHECK_NONAM;
   if((key=a)<=1)
      {errfun="findfont"; keyerror_key=key; keyerror_s=(char *)b; return KEYERROR;}
  }
 DEBUG(1,printf("findfont: '%s'\n",b));
 namepush("FontDirectory"); psload(); push(att,a,b); n=get();
 if(n==UNDEFINED)
    {push(att,a,b); n=run(); /* Font laden */
     if(n) { stradd("PSFONTS:",(char*)b,fstr);
	     push(att,strlen(fstr),(long)fstr); n=run(); }
     if(n==0) {namepush("FontDirectory"); psload(); push(att,a,b); n=get();}
    }
 if(n && defaultfontflag)
  {if(dpflag>0)
	{printf("'%s' not found - DefaultFont='Fortranfont'\n",b); dpflag--;}
   if(font1.typ!=2) /* font1 noch nicht erstellt */
    {font1.typ=2; /* 1=Adobe 2=Fortranfont 3=User */
     font1.ctm[0]=1./45.;	font1.ctm[1]=0.;
     font1.ctm[2]=0.;	font1.ctm[3]=1./40.;
     font1.ctm[4]=0.;	font1.ctm[5]=0.;
     font1dx=25.;	/* font1.next=NULL; */
     font1_erstellen();
     font1dict.e=NULL;  font1dict.leng=0;	font1dict.i=0;
     font1dict.flags=0;	font1dict.savemark=0;
     font1dict.name="DefaultFont";
     font1dict.font= &font1;
    }
   n=push(TYP_FONT+ZUS,font1dict.leng,(long)&font1dict);
  }
 if(n) errfun="findfont";
 return n;
}

int scalefont()	/* font zahl scalefont --> font */
{
 WORD att; long awert,bwert;
 double p1;
 int i,n=0;
 long *s1,*s2;
 struct font *zfont,*zfont2;
 Dictionary *fdic,*fdic2;
 if((n=zahlpop(&p1))==0)
 if((att=pop(&awert,(long*)&fdic))==0) n=STACKUNDER;
 else if(!IS_FONT(att)) n=TYPECHECK_NOFONT;
 else
  {DEBUG(1,printf("%lf scalefont --> %06X\n",p1,fdic));
   zfont=fdic->font;
   zfont2=(struct font *)malloc(sizeof(struct font));
   if(zfont2==NULL) return err("scalefont",MEMFULL);
   zfont2->typ=zfont->typ;
   for(i=0;i<4;i++) zfont2->ctm[i] = zfont->ctm[i] * p1;
   for(;i<6;i++) zfont2->ctm[i] = zfont->ctm[i];
   if((fdic2=(Dictionary *)malloc(sizeof(Dictionary)))==NULL) n=MEMFULL;
   else {dictcopy(fdic,fdic2); fdic2->font=zfont2; zfont2->dict=fdic2;
	 n=push(TYP_FONT+ZUS,fdic2->leng,(long)fdic2);
	}
  }
 NRETURN("scalefont");
}

void dictcopy(Dictionary* dic1,Dictionary* dic2)
{
 dic2->e=dic1->e;
 dic2->leng=dic1->leng;
 dic2->i=dic1->i;
 dic2->flags=dic1->flags;
 dic2->savemark=dic1->savemark;
 dic2->name=dic1->name;
 dic2->font=dic1->font;
}

int setfont()	/* font setfont --> - */
{
 WORD att; long a; Dictionary *fdic;
 int n=0;
 if((att=pop(&a,(long*)&fdic))==0) n=STACKUNDER;
/* else if(!IS_FONT(att)) n=TYPECHECK_NOFONT; */
 else if(!IS_DICT(att)) n=TYPECHECK_NOFONT;
 else
  {/*if(!IS_FONT(att)) printf("setfont_Warnung: TYPECHECK_NOFONT\n");/*test*/
   gs.font=fdic->font;
  }
 NRETURN("setfont");
}

int selectfont()	/* /Name groesse selectfont --> - */
{
 int n;
 if((n=exch())==0 && (n=findfont())==0 && (n=exch())==0 && (n=scalefont())==0)
	n=setfont();
 NRETURN("selectfont");
}

int makefont()	/* font [a b c d e f] makefont --> font */
{
 WORD att; long awert,bwert;
 struct stackeintrag *p,*h;
 int n=0,i,errflag=0;
 long *s1,*s2;
 struct font *zfont,*zfont2;
 REAL abcd;
 double abc[6];
 Dictionary *fdic,*fdic2;
 att=pop(&awert,&bwert);
 if(att!=0)
  {if((att & TYPEMASK)!=TYP_ARRAY) return err("makefont",TYPECHECK_NOARRAY);
   p=(struct stackeintrag *)bwert;
   att=pop(&awert,(long*)&fdic);
  }
 if(att==0) {errfun="makefont"; return STACKUNDER;}
 if(!IS_FONT(att)) return err("makefont",TYPECHECK_NOFONT);
 zfont=fdic->font;
 for(i=0; i<4; i++)
	{h= &p[i];
	 if(ISREAL(h))	   {abcd.n[1]=h->b; abcd.n[0]=h->a;}
	 else if(ISINT(h)) {abcd.d=h->b;}
	 else {errflag=1; abcd.d=0.0;}
	 abc[i]=abcd.d;
	}
 abc[4]=0; abc[5]=0;
 DEBUG(1,printf("[%lf %lf %lf %lf %lf %lf] makefont\n",
		abc[0],abc[1],abc[2],abc[3],abc[4],abc[5]));
 zfont2=(struct font *)malloc(sizeof(struct font));
 if(zfont2==NULL) return err("makefont",MEMFULL);
 zfont2->typ=zfont->typ;
 for(i=0;i<6;i++) zfont2->ctm[i] = zfont->ctm[i];
 ctm_multiplikation(abc,zfont2->ctm);
 if((fdic2=(Dictionary *)malloc(sizeof(Dictionary)))==NULL) n=MEMFULL;
 else	{dictcopy(fdic,fdic2); fdic2->font=zfont2; zfont2->dict=fdic2;
	 n=push(TYP_FONT+ZUS,fdic2->leng,(long)fdic2);
	}
 if(n) errfun="makefont";
 return n;
}

int currentfont()		/* currentfont --> font */
{
 int n;
 Dictionary *fdic;
 if(gs.font==NULL) n=INVALIDFONT;
 else {fdic=gs.font->dict; n=push(TYP_FONT+ZUS,fdic->leng,(long)fdic);}
 NRETURN("currentfont");
}

int definefont()	/* name dict definefont --> font */
{		/*  any dict definefont --> font */
 WORD att,att2,att3; long a,a2,b2,a3,b3;
 Dictionary *fdic;
 int n=0,fonttype,i;
 struct stackeintrag *p;
 REAL z;
 char *str;
 static char definefont_fontname[]="fontname00";
 if((att=pop(&a,(long*)&fdic))==0 || (att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if(!IS_DICT(att)) n=TYPECHECK_NODICT;
 else
  {if(!IS_NAME(att2))
	{DEBUG(1,printf("any dict definefont --> "));
	 definefont_fontname[9]++; namepush(definefont_fontname);
	 DEBUG(1,printf("definefont_fontname='%s'\n",definefont_fontname));
	 att2=pop(&a2,&b2);
	}
   else {DEBUG(1,printf("/%s dict definefont --> ",b2));}
/* dict pruefen auf: FontMatrix FontType FontBBox Encoding */
/*			    bei Typ1: CharStrings  bei Typ3: BuildChar */
   if((fdic->font=(struct font *)malloc(sizeof(struct font)))==NULL) n=MEMFULL;
   else   {push(att,a,(long)fdic); namepush("FontType"); get();
	   att3=pop(&a3,(long*)&fonttype);
	   if(!IS_INT(att3)) n=INVALIDFONT;
	   else if(fonttype!=1 && fonttype!=3)
		 {n=INVALIDFONTTYPE; printf("FontType=%d\n",fonttype);}
	  }
   if(!n) {push(att,a,(long)fdic); namepush("FontMatrix");
	   get(); att3=pop(&a3,(long*)&p);
	   if(!IS_ARRAY(att3)) n=INVALIDFONT;
	   else for(i=0;i<6;i++,p++)
		{if(!ISINT(p) && !ISREAL(p)) {n=INVALIDFONT; break;}
		 if(ISINT(p)) z.d=p->b; else {z.n[1]=p->b; z.n[0]=p->a;}
		 fdic->font->ctm[i]=z.d;
	  }	}
   if(!n) { push(att,a,(long)fdic); namepush("FontID");
	    push(TYP_FONTID,0,++neuefontid); n=put(); }
   if(!n) {push(att,a,(long)fdic);
	   if(fonttype==1) str="CharStrings"; else str="BuildChar";
	   namepush(str); get(); att3=pop(&a3,&b3);
	   if(att3==0) {printf("missing %s ",str); n=INVALIDFONT;}
	  }
   if(!n) {att |= TYP_FONT; fdic->font->typ=fonttype; fdic->font->dict=fdic;}
   if(!n) { namepush("FontDirectory"); psload();
	    push(att2,a2,b2); push(att,a,(long)fdic); n=put(); }
   if(!n) n=push(att,a,(long)fdic); /* font auf Stack legen */
   DEBUG(1,printf("%06X  fonttype=%d Fontid=%d\n",fdic,fonttype,neuefontid));
  }
 NRETURN("definefont");
}

int stringwidth()	/* string stringwidth --> dx dy */
{
 WORD att; long a,b;
 int n=0;
 double x0,neux,neuy,dx,dy;
 att=pop(&a,&b);
 if(att==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STRING) n=TYPECHECK_NOSTR;
 else if(gs.font==NULL) n=INVALIDFONT;
 if(n) return err("stringwidth",n);
 DEBUG(1,printf("stringwidth: str='%s' a=%ld\n",b,a));
 if(istfortranfont(gs.font->dict))
  {DEBUG(1,printf("fortranfont\n"));
   gsave();
   ctm_multiplikation(gs.font->ctm,gs.ctm);
   x0 = strlen((char *)b) * font1dx;
   neux=PP*x0; neuy=QQ*x0;  /* neuer akt.Punkt berechnen */
   grestore();
   ideltatransform(&dx,&dy,neux,neuy);
   n=zahlpush2(dx,dy);
  }
 else
  {gsave();
   nichtzeichnen_flag=1;
   intpush(0); intpush(0); moveto();
   push(att,a,b); show(); currentpoint();
   zahlpop2(&dx,&dy);
   nichtzeichnen_flag=0;
   grestore();
   n=zahlpush2(dx,dy);
  }
 if(n) errfun="stringwidth";
 return n;
}

int show()		/* (String) show --> - */
{
 WORD att; long awert,a; char *bwert;
 int c,pen,n=0,i;
 double x0,br,x,y,neux,neuy;
 BYTE *s;
 Dictionary *fdic;
 if((att=pop(&awert,(long*)&bwert))==0) n=STACKUNDER;
 else if((att & TYPEMASK)!=TYP_STRING) n=TYPECHECK_NOSTR;
 else if(gs.aktflag==0) n=NOAKTPOINT;
 else if(gs.font==NULL) n=INVALIDFONT;
 if(n) return err("show",n);
 DEBUG(2,printf("show: '%s' FontTyp=%d\n",bwert,gs.font->typ));
 gsave();
 TT=gs.aktx; UU=gs.akty;  /* currentpoint translate */
 ctm_multiplikation(gs.font->ctm,gs.ctm);
 if(RUECKFLAG) lineattribute_ruecksetzen();
 if(gs.font->typ==2)
  {br=font1dx;	/* Fortranfont */
   for(x0=0.; --awert>=0; x0+=br)
     if(s=font1dat[(c= *bwert++)&0xFF])
	while(pen= *s++)
	  {x=x0+ *s++;
	   y= *s++;
	   if(pen==2) draw(x,y);
	   else move(x,y);
	  }
   qstroke();
   neux=PP*x0+TT; neuy=QQ*x0+UU;  /* neuer akt.Punkt berechnen */
  }
 else if(gs.font->typ==1)
  {DEBUG(2,printf("show FontType=1\n"));
   namepush("systemdict"); psload(); begin();
   fdic=gs.font->dict; push(TYP_FONT+ZUS,fdic->leng,(long)fdic); begin();
   namepush("PaintType"); n=psload();
   if(n==0) att=pop(&a,(long*)&painttype); else painttype=0;
   namepush("Private"); psload(); namepush("lenIV");
// if(get()==0) att=pop(&a,(long*)&len4); else len4=4;//nur wenn int==long !
   if(get()==0) att=pop(&a,&len4); else len4=4;
   for(i=0;i<awert;i++)
	{c= *bwert++ & 0xFF;
	 gsave(); newpath(); loadname("CharStrings"); loadname("Encoding");
	 intpush(c); get(); get();
	 font1maschine();
	 grestore(); intpush(p_wx); intpush(p_wy); rmoveto();
	 TT=gs.aktx; UU=gs.akty;  /* currentpoint translate */
	}
   end();
   n=end();
   neux=TT;  neuy=UU;
  }
 else if(gs.font->typ==3)
  {fdic=gs.font->dict;
   DEBUG(2,printf("show FontType=3\n"));
   push(TYP_FONT+ZUS,fdic->leng,(long)fdic); begin(); /* fontdict aktiv und */
   namepush("systemdict"); psload(); begin();   /* systemdict als aktuelles */
   if(argflag['C'])
    for(i=0;i<awert;i++)
	{c= *bwert++ & 0xFF;
	 if(cache_check(c,fdic))
	  {cache_print(c,fdic,&dicktex,&dicktey);}
	 else
	  {push(TYP_FONT+ZUS,fdic->leng,(long)fdic); intpush(c);
	   dicktey=dicktex=0.; gsave(); newpath();
	   execname("BuildChar");
	   grestore();
	   cache_put(c,fdic,dicktex,dicktey,
		     cachexul,cacheyul,cachexor,cacheyor);
	  }
	 zahlpush2(dicktex,dicktey); rmoveto();
	 TT=gs.aktx; UU=gs.akty;  /* currentpoint translate */
	}
   else
    for(i=0;i<awert;i++)
	{c= *bwert++ & 0xFF;
	 push(TYP_FONT+ZUS,fdic->leng,(long)fdic); intpush(c);
	 dicktey=dicktex=0.; gsave(); newpath();
	 execname("BuildChar");
	 grestore(); zahlpush2(dicktex,dicktey); rmoveto();
	 TT=gs.aktx; UU=gs.akty;  /* currentpoint translate */
	}
   end();
   n=end();
   neux=TT;  neuy=UU;
  }
 else n=INVALIDFONT;
 grestore();
 gs.aktx=neux;  gs.akty=neuy;  /* neuer akt.Punkt setzen */
 NRETURN("show");
}

void execname(char* str)
	{push(TYP_NAME,getkey((UBYTE*)str),(long)str); psload(); exec();}

void loadname(char* str)
	{push(TYP_NAME,getkey((UBYTE*)str),(long)str); psload();}

int setcachedevice()	/* x y xul yul xor yor setcachedevice --> - */
{
 int n;
 zahlpop2(&cachexor,&cacheyor);
 zahlpop2(&cachexul,&cacheyul);
 n=zahlpop2(&dicktex,&dicktey);
 DEBUG(1,printf("dx=%lf %lf   xul=%lf %lf   xor=%lf %lf setcachedevice\n",
		dicktex,dicktey,cachexul,cacheyul,cachexor,cacheyor));
 NRETURN("setcachedevice");
}

int setcharwidth()		/* x y setcharwidth --> - */
{
 int n;
 n=zahlpop2(&dicktex,&dicktey);
 NRETURN("setcharwidth");
}

int xshow()			/* (Text) [Array] xshow --> - */
{
 WORD att,att2; long a,b,a2,b2;
 int n=0,i,imax;
 struct stackeintrag *p;
 REAL h;
 double x,y,abst;
 char *str;
 if((att=pop(&a,&b))==0 || (att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if(!IS_ARRAY(att)) n=TYPECHECK_NOARRAY;
 else if(!IS_STR(att2)) n=TYPECHECK_NOSTR;
 else	{p=(struct stackeintrag *)b; str=(char *)b2;
	 imax = a<=a2 ? a : a2;
	 for(i=1;i<=imax;i++,p++,str++)
	  {if(ISINT(p)) abst=p->b;
	   else if(ISREAL(p)) {h.n[1]=p->b; h.n[0]=p->a; abst=h.d;}
	   else abst=0.;
	   currentpoint(); zahlpop2(&x,&y);
	   push(att2, (i==imax && a2>a)?(1+a2-a):1, (long)str); show();
	   zahlpush2(x+abst,y);
	   if((n=moveto())!=0) break;
	} }
 NRETURN("xshow");
}

int yshow()			/* (Text) [Array] yshow --> - */
{
 WORD att,att2; long a,b,a2,b2;
 int n=0,i,imax;
 struct stackeintrag *p;
 REAL h;
 double x,y,abst;
 char *str;
 if((att=pop(&a,&b))==0 || (att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if(!IS_ARRAY(att)) n=TYPECHECK_NOARRAY;
 else if(!IS_STR(att2)) n=TYPECHECK_NOSTR;
 else	{p=(struct stackeintrag *)b; str=(char *)b2;
	 imax = a<=a2 ? a : a2;
	 for(i=1;i<=imax;i++,p++,str++)
	  {if(ISINT(p)) abst=p->b;
	   else if(ISREAL(p)) {h.n[1]=p->b; h.n[0]=p->a; abst=h.d;}
	   else abst=0.;
	   currentpoint(); zahlpop2(&x,&y);
	   push(att2, (i==imax && a2>a)?(1+a2-a):1, (long)str); show();
	   zahlpush2(x,y+abst);
	   if((n=moveto())!=0) break;
	} }
 NRETURN("yshow");
}

int xyshow()		/* (Text) [Array] xyshow --> - */
{
 WORD att,att2; long a,b,a2,b2;
 int n=0,i,imax;
 struct stackeintrag *p;
 REAL h;
 double x,y,abstx,absty;
 char *str;
 if((att=pop(&a,&b))==0 || (att2=pop(&a2,&b2))==0) n=STACKUNDER;
 else if(!IS_ARRAY(att)) n=TYPECHECK_NOARRAY;
 else if(!IS_STR(att2)) n=TYPECHECK_NOSTR;
 else	{p=(struct stackeintrag *)b; str=(char *)b2;
	 imax=a/2;
	 if(imax>a2) imax=a2;
	 for(i=1;i<=imax;i++,str++)
	  {if(ISINT(p)) abstx=p->b;
	   else if(ISREAL(p)) {h.n[1]=p->b; h.n[0]=p->a; abstx=h.d;}
	   else abstx=0.;
	   p++;
	   if(ISINT(p)) absty=p->b;
	   else if(ISREAL(p)) {h.n[1]=p->b; h.n[0]=p->a; absty=h.d;}
	   else absty=0.;
	   p++;
	   currentpoint(); zahlpop2(&x,&y);
	   push(att2, (i==imax && a2>imax)?(1+a2-imax):1, (long)str); show();
	   zahlpush2(x+abstx,y+absty);
	   if((n=moveto())!=0) break;
	} }
 NRETURN("xyshow");
}

int rectfill()	/* x1 y1 dx dy rectfill --> - */
{
 int n=0;
 double x1,y1,dx,dy;
 if(zahlpop2(&dx,&dy) || zahlpop2(&x1,&y1)) n=STACKUNDER;
 else	{zahlpush2(x1,y1); moveto();
	 zahlpush2(x1,y1+dy); lineto();
	 zahlpush2(x1+dx,y1+dy); lineto();
	 zahlpush2(x1+dx,y1); lineto();  closepath();
	 n=fill();
	}
 NRETURN("rectfill");
}

int rectstroke()	/* x1 y1 dx dy rectstroke --> - */
{
 int n=0;
 double x1,y1,dx,dy;
 if(zahlpop2(&dx,&dy) || zahlpop2(&x1,&y1)) n=STACKUNDER;
 else	{zahlpush2(x1,y1); moveto();
	 zahlpush2(x1,y1+dy); lineto();
	 zahlpush2(x1+dx,y1+dy); lineto();
	 zahlpush2(x1+dx,y1); lineto();  closepath();
	 n=stroke();
	}
 NRETURN("rectfill");
}

/***************** neue Postscript-Funktionen ******************/
int currentscreen()	/* - --> freq winkel proc */
{
 int n;
 static char *leer="pop pop 0";
 intpush(600); //freq Punkte/Zoll
 intpush(45); //winkel
 n=push(TYP_PROC+EXECUTABLE+ZUS,0,(long)leer); //provisorisch
 NRETURN("currentscreen");
}
int setscreen()		/* freq winkel proc --> - */
{
 int n;
 pspop(); pspop(); n=pspop(); //provisorisch: Daten ignorieren
 NRETURN("setscreen");
}

int errordict()		/* errordict --> dictionary */
{
 int n;
// n=push(TYP_DICT,errdict->leng,(long)errdict);
 intpush(20); n=dict(); //provi.
 NRETURN("errordict");
}

int setjobtimeout()		/* Zahl --> - */
{
 int n;
 n=pspop(); //provisorisch: Daten ignorieren
 NRETURN("setjobtimeout");
}


/*************** spezielle Postscript-Funktionen *******************/
int xlzug()		/* dx xlzug --> - */
{
 int n,iy;
 double dx,x0,y0;
 if((n=zahlpop(&dx))==0)
  {currentpoint(); zahlpop2(&x0,&y0);
   while(entpackread(&iy)) linetoxy(x0+=dx,y0+iy);
   n=stroke();
  }
 if(n) errfun="xlzug";
 return n;
}

int lzug()		/* lzug --> - */
{
 int n,ix,iy;
 double x0,y0;
 currentpoint(); zahlpop2(&x0,&y0);
 while(entpackread(&ix) && entpackread(&iy)) linetoxy(x0+ix,y0+iy);
 n=stroke();
 if(n) errfun="lzug";
 return n;
}

int entpackread(int* wert) /* Aufruf: ok=entpackread(&z) */
{
 int c,n;
 FILE *fp;
 if((fp=currfile)==NULL) fp=stdinfile;
 c=getc(fp); /* = currentfile read */
 while(c<'0') {if(c=='!') return 0; else c=getc(fp);}
 n = (c-='0') & 0x0F;
 if(c&0x10) {n=(n<<6)+getc(fp)-'0';}
 n=(n<<6)+getc(fp)-'0';
 if(c&0x20) *wert= -n;
 else *wert=n;
 return 1;
}

int xlzug2()		/* dx xlzug2 --> - */
{
 int n,c,iy;
 double dx,x0,y0;
 if((n=zahlpop(&dx))==0)
  {currentpoint(); zahlpop2(&x0,&y0);
   while(entpack2read(&iy)) linetoxy(x0+=dx,(double)iy);
   n=stroke();
  }
 if(n) errfun="xlzug2";
 return n;
}

int lzug2()		/* lzug2 --> - */
{
 int n,c,ix,iy;
 while(entpack2read(&ix) && entpack2read(&iy)) linetoxy((double)ix,(double)iy);
 n=stroke();
 if(n) errfun="lzug2";
 return n;
}

int entpack2read(int* wert) /* Aufruf: ok=entpack2read(&z) */
{
 int c,n;
 FILE *fp;
 if((fp=currfile)==NULL) fp=stdinfile;
 c=getc(fp); /* = currentfile read */
 if(c==0xFF) return 0;
 *wert=(c<<8)+getc(fp);
 return 1;
}

int xlzug3()		/* dx xlzug3 --> - */
{
 int n,c,iy;
 double dx,x0,y0;
 if((n=zahlpop(&dx))==0)
  {currentpoint(); zahlpop2(&x0,&y0);
   while(entpack3read(&iy)) linetoxy(x0+=dx,(double)iy);
   n=stroke();
  }
 if(n) errfun="xlzug3";
 return n;
}

int lzug3()		/* lzug3 --> - */
{
 int n,c,ix,iy;
 while(entpack3read(&ix) && entpack3read(&iy)) linetoxy((double)ix,(double)iy);
 n=stroke();
 if(n) errfun="lzug3";
 return n;
}

int entpack3read(int* wert) /* Aufruf: ok=entpack2read(&z) */
{
 int c,n;
 FILE *fp;
 static int k000=('0'<<12)+('0'<<6)+'0';
 if((fp=currfile)==NULL) fp=stdinfile;
 c=getc(fp); /* = currentfile read */
 while(c<'0') {if(c=='!') return 0; else c=getc(fp);}
 *wert=(c<<12)+(getc(fp)<<6);
 *wert += getc(fp)-k000;
 return 1;
}


/************************** clipping ***************************/
static double axb;
/** in dieser Version sind Rundungsfehler moeglich:
#define SEITE(x,y) (x2==x1?(x1>x?1:(x1<x?2:3)) : (y>(axb=a*x+b)?1:(y<axb?2:3)))
**/
static double dd=1e-5;
#define SEITE(x,y) (x2==x1?(x1>x+dd?1:(x1<x-dd?2:3)) : (y>(axb=a*x+b)+dd?1:\
(y<axb-dd?2:3)))
/* SEITE(x,y)   gibt fuer oben oder links 1, fuer unten rechts 2 und
		auf der Linie 3
*/
#define SAMESIDE(x,y) ((x)&(y))
#define OTHERSIDE(x,y) (!((x)&(y)))
#define UNGLEICH(x2,x1) (x2<x1-dd || x2>x1+dd)

int getpointfrompath(double** z,double* x0,double* y0,
		 double* x1,double* y1,double* x2,double* y2)
{
 static double *z1=NULL;
 int n;
 static int stuetzflag=0,warncount=0;
 if(stuetzflag)
  {if(z1== *z)
	{*x1= *x2; *y1= *y2; *x2= *z1++; *y2= *z1++; stuetzflag--;
	 *z=z1;
	 return CURVETO;
	}
   else {stuetzflag=0;}
  }
 z1= *z;
 switch(n=(int)(*z1++))
	{case MOVETO:	*x0= *x2= *z1++; *y0= *y2= *z1++;
	 CASE LINETO:	*x1= *x2; *y1= *y2; *x2= *z1++; *y2= *z1++;
	 CASE CURVETO:	if(warncount<10) {warncount++; printf(
				"WARNING in clipping: unusual CURVETO\n");}
			/* CURVETO sollte hier eigentlich nicht vorkommen */
			/* mglicherweise fehlt ein flattenpath */
			*x1= *x2; *y1= *y2;
			*x2= *z1++; *y2= *z1++; /* erster Sttzpunkt */
			stuetzflag=2;/*zweiter Sttzpunkt und Endpunkt spter*/
	 CASE CLOSEPATH: *x1= *x2; *y1= *y2; *x2= *x0; *y2= *y0;
	 DEFAULT: printf("Fehler in clipping: Path korrupt n=%lf\n",*--z1);
		  z1++; n=0;
	}
 *z=z1;
 return n;
}

void clipping(struct pfad* clip,struct pfad* path,struct pfad* ziel)
{
 struct pfad pat1,pat2;
 double *z1,*z2,*z2alt;		/* Zeiger in clip, in path */
 double a,b;			/* Steigung,Achsenabschnitt */
 double x0,y0,x1,y1,x2,y2;	/* Punkte aus clip */
 double xp0,yp0,xp1,yp1,xp2,yp2;/* Punkte aus path */
 int seite0,seite1,n;
 if(++cliprekursion >=100) /* test0 */
	{printf("unendliche Rekursion !  %d\n",cliprekursion);
	 printpfad("clip:",clip);
	 printpfad("path:",path);
	 printpfad("ziel:",ziel);
	 return;
	}
 pat1.anfang=path->anfang; pat1.ende=path->ende; pat1.max=path->max;
 for(z1=clip->anfang;z1<clip->ende;)
  {while((n=getpointfrompath(&z1,&x0,&y0,&x1,&y1,&x2,&y2))==MOVETO)  ;
   if(n==0) printpfad("Fehler0 in Pfad:",clip);/* test3 */
   if(UNGLEICH(x2,x1)) {a=(y2-y1)/(x2-x1); b=y1-a*x1;}
   else x2=x1;
   z2=path->anfang;
   do	{n=getpointfrompath(&z2,&xp0,&yp0,&xp1,&yp1,&xp2,&yp2);
	 if(n==0) printpfad("Fehler1 in Pfad:",path);/* test3 */
	 seite0=SEITE(xp2,yp2);
	}
   while(seite0==3 && z2<path->ende);
   while(z2<path->ende)
	{z2alt=z2;
	 n=getpointfrompath(&z2,&xp0,&yp0,&xp1,&yp1,&xp2,&yp2);
	 if(n==0) printpfad("Fehler2 in Pfad:",path);/* test3 */
	 seite1=SEITE(xp2,yp2);
	 if(OTHERSIDE(seite1,seite0))
	   {if(n==MOVETO)
		{pat2.anfang=z2alt; pat2.ende=path->ende; pat2.max=path->max;
		 pat1.ende=z2alt;
		 clipping(clip,&pat2,ziel);
		}
	    else
		{aufteilen(path,&pat1,&pat2,a,b,x1,x2);
		 clipping(clip,&pat1,ziel);
		 clipping(clip,&pat2,ziel);
		 freepfad(&pat1); freepfad(&pat2);
		 --cliprekursion;
		 return;
		}
	   }
	}/* next z2 */
  }/* next z1 */
 z2=path->anfang;				 /* Fuer Tst ob innerhalb */
 n=getpointfrompath(&z2,&x0,&y0,&x1,&y1,&x2,&y2);/* ClipFlaeche die ersten */
 n=getpointfrompath(&z2,&x0,&y0,&x1,&y1,&x2,&y2);/* 3 Punkte lesen */
 if(UNGLEICH(x2,x1)) {a=(y2-y1)/(x2-x1); b=y1-a*x1;}
 else x2=x1;
 xp1=x1; xp2=x2; yp1=y1; yp2=y2;
 do	{if(z2>=path->ende) return;/* 1-dimensionaler Pfad nicht verwenden */
	 n=getpointfrompath(&z2,&x0,&y0,&xp1,&yp1,&xp2,&yp2);
	 if(n==0) printpfad("Fehler5 in Pfad:",path);/* test3 */
	 seite0=SEITE(xp2,yp2);	 /* dritter sollte nicht auf Linie liegen */
	}
 while(seite0==3);
 xp0=(x0+xp1+xp2)/3.;
 yp0=(y0+yp1+yp2)/3.;	 /* und Durchschnitt (=Schwerpunkt) verwenden */
 if(istinnerhalb(clip,xp0,yp0)) pfadanfuegen(path,ziel);
 --cliprekursion;
}


#define ZSEITE ((seite0 & seite1) ? &z1 : &z2)

int aufteilen(struct pfad* pat,struct pfad* pat1,struct pfad* pat2,
			double a,double b,double x1,double x2)
{
 double *z,*z1,*z2,x0,y0,xa,ya,xb,yb,xs,ys;
 int n,seite0=3,seite1=3,seite;
 DEBUG(1,printf("aufteilen(pat,pat1,pat2,a=%lf,b=%lf,x1=%lf,x2=%lf)\n",
			a,b,x1,x2));
 if(getpfad(pat1,MAXPATH3)==NULL) return MEMFULL;
 if(getpfad(pat2,MAXPATH3)==NULL) {freepfad(pat1); return MEMFULL;}
 if(debug) printpfad("pat:",pat);
 z1=pat1->anfang; z2=pat2->anfang;
 for(z=pat->anfang;z<pat->ende;)
  {n=getpointfrompath(&z,&x0,&y0,&xa,&ya,&xb,&yb);
   if(n==0) printpfad("Fehler6 in Pfad:",pat);/* test3 */
   seite=SEITE(xb,yb);
   if(seite0==3) seite0=seite1=seite;
   if(SAMESIDE(seite,seite0))
     {uebernemen(ZSEITE,n,xb,yb);}
   else
     {if(n==MOVETO)
	{seite0=3-seite0;/* Seite wechseln */ uebernemen(ZSEITE,n,xb,yb);}
      else
	{schnittpunkt(xa,ya,xb,yb,&xs,&ys, a,b,x1,x2);
	 uebernemen(ZSEITE,LINETO,xs,ys);
	 if(OTHERSIDE(seite0,seite1)) uebernemen(ZSEITE,CLOSEPATH,0.,0.);
	 seite0=3-seite0; /* Seite wechseln */
	 if(SAMESIDE(seite0,seite1)) uebernemen(ZSEITE,LINETO,xs,ys);
	 else uebernemen(ZSEITE,MOVETO,xs,ys);
	 uebernemen(ZSEITE,LINETO,xb,yb);
	}
     }
  }/* next z */
 if(OTHERSIDE(seite0,seite1))
	{uebernemen(ZSEITE,CLOSEPATH,0.,0.);
	 seite0=3-seite0; /* Seite wechseln */
	 uebernemen(ZSEITE,CLOSEPATH,0.,0.);
	}
 pat1->ende=z1;
 pat2->ende=z2;
 return 0;
}

void uebernemen(double** z,int objekt,double x,double y)
{
 *(*z)++ = objekt;
 if(objekt!=CLOSEPATH) {*(*z)++ = x; *(*z)++ = y;}
}

void schnittpunkt(double xa,double ya,double xb,double yb,
	     double* xs,double* ys,double a,double b,double x1,double x2)
{	/* ermittelt Schnittpunkt zwischen  Linie y=a*x+b und Strecke AB */
 double m,c;
 if(x1==x2) /* senkrechte Linie ? */
	{if(xa==xb) printf("Schnittpunkt-Fehler: beide senkrecht\n");
	 *xs=x1; *ys=yb+(ya-yb)*(x1-xb)/(xa-xb);}
 else if(xa==xb) /* Strecke senkrecht ? */
	{*xs=xa; *ys=a*xa+b;}
 else
	{m=(yb-ya)/(xb-xa); c=ya-m*xa;
	 if(m==a) printf("Schnittpunkt-Fehler: beide waagrecht\n");
	 *xs=(b-c)/(m-a);
	 *ys=a*(*xs)+b;
	}
}

int istinnerhalb(struct pfad* clip,double x,double y)
{
 double x0,y0,x1,y1,x2,y2,xs, *z;
 int n, windungen=0, richtung=1;
 for(z=clip->anfang;z<clip->ende;)
	{n=getpointfrompath(&z,&x0,&y0,&x1,&y1,&x2,&y2);
	 if(n==0) printpfad("Fehler7 in Pfad:",clip);/* test3 */
	 if(n==MOVETO || y1==y2 || (y<y1 && y<y2) || (y>=y1 && y>=y2)) continue;
	 xs=(x1-x2)*(y2-y)/(y2-y1)+x2;
	 if(x>xs) /* auf der Linie gilt nicht mehr als innerhalb */
		{if(clippingmethode==WINDUNGSZAHL)
			{if(y2>y1) richtung=1; else richtung= -1;}
		 windungen += richtung;
		}
	}
 if(clippingmethode==WINDUNGSZAHL) return windungen;
 return (windungen & 1);
}

void pfadanfuegen(struct pfad* path,struct pfad* ziel)
{
 double *z1,*z2;
 for(z1=path->anfang,z2=ziel->ende;z1<path->ende && z2<ziel->max;)
				*z2++ = *z1++;
 ziel->ende = z2;
}

/************************** Ausschneiden ***************************/
#define AUSSERHALB	1
#define INNERHALB	2
#define INNENUNDAUSSEN	3
#define ISBOX	1
#define NOBOX	2
static int cut_ug=1,cut_og=10000;

void schere_setzen()
{
 int n,k;
 if(n=fadenkreuz_flag) fadenkreuz_aus();
 lower_window();
 printf("Maximale Anzahl auszuschneidende Objekte:"); scanf("%d",&k);
 if(k<=0) k=10000;
 printf("Anzahl zu ignorierende Objekte:"); scanf("%d",&cut_ug); cut_ug++;
 cut_og=cut_ug+k-1;
 raise_window();
 if(n) fadenkreuz_ein();
}

int ausschneiden(XPoint* feld,int imax)
{
 FILE *fpvon,*fpbru,*fpnull;
 struct pfad schnittpfad;
 double ax1,ay1,ax2,ay2,x1,y1,x2,y2,x1t,y1t,x2t,y2t;
 int schnittflag=0,flag1,zaehl1=0;
 char zeile1[BBUF];
 int n,k;
 DEBUG(1,printf("ausschneiden()\n"));
 save();
 linienzug2(feld,imax); closepath(); /* erzeugt Pfad */
 if(getpfad(&schnittpfad,MAXPATH3)==NULL) return MEMFULL;
 pfad_kopieren(&gs.path,&schnittpfad);
 DEBUG(1,printf("starte clip()\n"));/* test3 */
 clip();
 DEBUG(1,printf("clip() fertig\n"));
 gsave();
 pathbbox(); zahlpop2(&ax2,&ay2); zahlpop2(&ax1,&ay1);
 grestore();
 if(!fptemp) fatalerror(3);
 fclose(fptemp); fptemp=NULL;
 Delete(UNDONAME); rename(BILDNAME,UNDONAME);
 fptemp=fopen1(BILDNAME,"w"); fptemp_nlines=0;
 fpvon=fopen2(UNDONAME,"r");
 Delete(TEMPBRUSHNAME);
 fpbru=fopen2(TEMPBRUSHNAME,"w");
 fprintf(fpbru,"%%!PS-Adobe-2.0 EPSF-1.2\n");
 fprintf(fpbru,"%%%%Creator: VectMal %s Brush\n",REVISION);
 fprintf(fpbru,"%%%%BoundingBox: %lg %lg %lg %lg\n",ax1,ay1,ax2,ay2);
 fpnull = schneidmodus==CUTCOPY ? fptemp : (FILE*)NULL;
 while(n=objektboxlesen(fpvon,zeile1,&x1,&y1,&x2,&y2))
  {if(n==ISBOX)
    {normtransform(&x1t,&y1t,x1,y1); normtransform(&x2t,&y2t,x2,y2);
     if(flag1=(++zaehl1>=cut_ug && zaehl1<=cut_og))
		n=innenoderausserhalb(&schnittpfad,x1t,y1t,x2t,y2t);
     else n=AUSSERHALB;
     if(n==INNERHALB && flag1)
		{ k=objektuebernemen(fpvon,fpbru,fpnull,zeile1);
		  if(fpnull) fptemp_nlines+=k; }
     else if(n==AUSSERHALB || (schneidmethode & CUTNURGANZE))
		fptemp_nlines+=objektuebernemen(fpvon,fptemp,NULL,zeile1);
     else { schnittflag=1;
	    fptemp_nlines+=objektuebernemen(fpvon,fptemp,fpbru,zeile1); }
    }
   else
    {fptemp_nlines+=objektuebernemen(fpvon,fptemp,fpbru,zeile1);}
  }
 if(schnittflag && schneidmodus!=CUTCOPY)
	{fprintfld(fptemp,"%%Objektbox: %lg %lg %lg %lg\n",ax1,ay1,ax2,ay2);
	 fprintfl(fptemp,"gsave 1 setgray\n");
	 intpush(1); setgray();
	 fill_fptemp(WINDUNGSZAHL,&schnittpfad,1);
	 fprintfl(fptemp,"closepath fill grestore\n");
	 fprintfl(fptemp,"%%Objektende\n");
	}
 fclose(fpvon); fclose(fpbru);
 undo_nline=fptemp_nlines+2; /* kennzeichne Undopuffer als gesicherte Datei */
 restore();
 if(schneidmodus!=CUTCOPY) bildrefresh();
/**
 if(argflag['Q'])
	deltatransform(&x2,&y2,ay2-ay1,ax1-ax2);// zu breit zu wenig hoch
	deltatransform(&y2,&x2,ax2-ax1,ay1-ay2);// zu hoch zu wenig breit
	{x2=deltatrans(ax2-ax1); y2=deltatrans(ay2-ay1);} //fast richtig
 else	deltatransform(&x2,&y2,ax2-ax1,ay2-ay1);// erfolgreich ausprobiert
**/
 if(argflag['Q'])
	deltatransform(&y2,&x2,ax2-ax1,ay1-ay2);
 else	deltatransform(&x2,&y2,ax2-ax1,ay2-ay1);
 leim_dx=idfix(x2); leim_dy=idfix(y2);
 leim_winkel=0;
 leim_start(1);
}

int objektboxlesen(FILE* fp,char* str,double* x1,double* y1,double* x2,double* y2)
{
 getlineb(fp,str);
 if(strncmp(str,"%Objektbox:",11)==0)
	{sscanf(&str[11],"%lf %lf %lf %lf",x1,y1,x2,y2); return ISBOX;}
 if(*str) return NOBOX;
 return 0;
}

int objektuebernemen(FILE* fpvon,FILE* fp,FILE* fp2,char* zeile)
{
 int nz=0,n;
 do
  {fprintf(fp,"%s\n",zeile); nz++;
   if(fp2) fprintf(fp2,"%s\n",zeile);
   if(strncmp(zeile,"%Objektende",11)==0) break;
   n=getlineb(fpvon,zeile);
   if(n && strncmp(zeile,"%Objektbox",10)==0) {ungetlineb(fpvon,zeile); break;}
  }
 while(n);
 return nz;
}

int innenoderausserhalb(struct pfad* spat,double x1,double y1,double x2,double y2)
{
 struct pfad vpat,ziel;
 double *z,*z2;
 int n;
 if( (z=getpfad(&vpat,MAXPATH3))==NULL
     || getpfad(&ziel,MAXPATH3)==NULL ) return INNENUNDAUSSEN;
 *z++=MOVETO; *z++=x1; *z++=y1; *z++=LINETO; *z++=x1; *z++=y2;
 *z++=LINETO; *z++=x2; *z++=y2; *z++=LINETO; *z++=x2; *z++=y1;
 *z++=CLOSEPATH;
 vpat.ende=z;
 cliprekursion=0;
 clipping(spat,&vpat,&ziel); /* liegt vpat innerhalb von spat ? */
 if(ziel.ende==ziel.anfang) n=AUSSERHALB;
 else
  {for(z=vpat.anfang,z2=ziel.anfang;
	  z<vpat.ende && z2<ziel.ende && *z == *z2; z++,z2++)	;
   if(z==vpat.ende && z2==ziel.ende) n=INNERHALB;
   else n=INNENUNDAUSSEN;
  }
 freepfad(&ziel); freepfad(&vpat);
 DEBUG(2,printf(" (2=inner- 1=ausserhalb) n=%d\n",n));/* test3 */
/* n=INNENUNDAUSSEN;/* test3 */
 return n;
}


/***************************** parser ***************************/
#define SCRAMAX 8000
//#define SCRAMAX 100000
static char scratch[SCRAMAX+100];
//static char scratch[SCRAMAX+M128]; //test

/*** elegante Version von 'liesbis()'  (aber nicht so schnell) ***/
#define GET(fp) (parserstr ? (*parserstr ? *parserstr++ : EOF) : getc(fp))
#define PUT(c) {*s++=c; if(++n>=SCRAMAX) return NULL;}
#define UNGET(c,fp) {if(parserstr) --parserstr; else ungetc(c,fp);}
#define isodigit(c) ((c)<'8'&&(c)>='0')

char *liesbis(char* str,int von,int bis,FILE* fp)
{
 int c,i=1,n=0;
 char *s;
 s=scratch;
 while((c=GET(fp))!=EOF)
	{if(c==von) i++; /* weitere Verschachtelung zhlen */
	 else if(c=='(') { do {PUT(c); c=GET(fp);} while(c!=')' && c!=EOF);
			   if(c==EOF) break; }
	 else if(c=='%' && von!='(')
			 { do {c=GET(fp);} while(c!='\n' && c!=EOF);
			   if(c==EOF) break; }
	 else if(c=='\\' && von=='(' && bis==')') /* Backslashzeichen */
		{int c2,j;
		 if((c=GET(fp))==EOF) break;
		 if (isodigit(c))
			{for(c-='0',j=0;j<2 && (c2=GET(fp))!=EOF;j++)
				{if(!isodigit(c2)) {UNGET(c2,fp); break;}
				 c=(c<<3)+c2-'0';
			}	}
		 else if(c=='n') c='\n';
		 else {PUT(c); continue;}
		}
	 if(c==bis) {if(--i==0) break;}
	 PUT(c);
	}
 *s=0;
 if((s=(char *)malloc(strlen(scratch)+1))==NULL) return NULL;
 return strcpy(s,scratch);
}

/*** schnelle Version von 'liesbis()'  (aber nicht so elegant) ***/
/*** Ende der schnellen Version von 'liesbis()' ***/

static char *isalnumpu_tab;
void isalnumpu_tab_init()
{
 int c;
 for(c=0;c<256;c++)
	if(isprint(c) && !isspace(c) && c!='{'&&c!='}'&&c!='['&&c!=']'&&c!='('
	   &&c!=')'&&c!='<'&&c!='>'&&c!='/') isalnumpu_tab[c]=1;
	else isalnumpu_tab[c]=0;
}
#define isalnumpu(c) isalnumpu_tab[c]

int parser(FILE* fp,int (**proc)())
{
 char *s;
 char feld[M128+2]; /* Namenslaenge auf 128 begrenzt */
 int i,j,c;
 WORD att; long awert,bwert;
 if(fp) stdinfile=fp;
 if(parserstr)
  {do  c= *parserstr++;  while(isspace(c));
   if(c==0) {parserstr=oldparserstr(); return BEF_RET;}
   feld[0]=c; i=1; /* erstes Zeichen */
   if(isalnumpu(c) || c=='/')
     while(i<M128 && (c= *parserstr)!=0 && isalnumpu(c))
		{parserstr++; feld[i++]=c;}
  }
 else if(fp==NULL)
  {DEBUG(0,printf("Fehler in parser(fp=NULL,proc=%06X) parserstr=%ld\n",
		proc,parserstr));/* test */
   return ERR_EOF;
  }
 else
  {do
    {do  c=getc(fp);  while(isspace(c));
     if(c=='%') while((c=getc(fp))!=EOF && c!='\n') ;/* Kommentar ueberlesen */
     if(c==EOF) return ERR_EOF;
    }
   while(isspace(c));
   feld[0]=c; i=1; /* erstes Zeichen */
   if(isalnumpu(c) || c=='/')
     while(i<M128 && (c=getc(fp))!=EOF && !isspace(c))
		{if(!isalnumpu(c)) {ungetc(c,fp); break;}
		 feld[i++]=c;
		}
  }
 feld[i]=0;
 if(i>=M128) printf("i=%d\n",i);//test
 if(execarray_flag) printf("feld[0..%d]: '%s'\n",i,feld); /* test0 */
 switch(feld[0])
	{case '(': if(!(s=liesbis(&feld[1],'(',')',fp))) return STRZULANG;
		   return push(TYP_STRING+ZUS,strlen(s),(long)s);
	 case '<': if(!(s=liesbis(&feld[1],'<','>',fp))) return STRZULANG;
		   return push(TYP_STRING+ZUS,makehexstr(s),(long)s);
	 case '[': mark(); return 0;
	 case '{': if(!(s=liesbis(&feld[1],'{','}',fp))) return STRZULANG;
		   return push(TYP_PROC+EXECUTABLE+ZUS,0,(long)s);
	 case '/': if(i<2) {strcpy(synerr,feld); return SYNTAXERR;}
		   if((s=(char *)malloc(strlen(&feld[1])+1))==NULL) return MEMFULL;
		   strcpy(s,&feld[1]);
		   return push(TYP_NAME+ZUS,getkey((UBYTE*)s),(long)s);
	 case ']': return macharray();
	 case ')': case '}': strcpy(synerr,feld); return SYNTAXERR;
	 case '#': if(nachladen(&feld[1])) return 0;
		   break;
	}
 if(feld[0]==0) return 0;
 if(isdigit(feld[0]) || ((feld[0]=='-' || feld[0]=='.') && isdigit(feld[1]))
    || (feld[0]=='-' && feld[1]=='.' && isdigit(feld[2])))
	{if(INDEX(feld,"#")>0)
	   {opstack[iopst].b=basiszahl(feld); opstack[iopst].attr=TYP_INTEGER;}
	 else if(istdrin2(feld,'.','e'))
		{sscanf(feld,"%lf",&opstack[iopst].a);/* maschinenabhaengig!*/
		 opstack[iopst].attr=TYP_REAL;
		}
	 else	{sscanf(feld,"%ld",&opstack[iopst].b);
		 opstack[iopst].attr=TYP_INTEGER;
		}
	 if(++iopst>=IOPSTMAX) {iopst=IOPSTMAX-1; return STACKOVER;}
	 return NUMBER;
	}
/* DEBUG(3,printf("load(getkey('%s')...)feld[0]=0x%02x\n",
						feld,feld[0]));/*test*/
 att=load(getkey((UBYTE*)feld),(ulong*)&awert,(ulong*)&bwert);
 if(att & EXECUTABLE)
	{if(att & SYSPROC) {*proc=(ZFUNK)bwert; return BEF_SYSPROC;}
	 switch(att & TYPEMASK)
	  {case TYP_PROC: case TYP_STRING: case TYP_NAME:
		 return exec_str((char*)bwert);
	   CASE TYP_ARRAY: case TYP_FILE:
	   default:
		 push(att,awert,bwert); return exec();
	  }
	}
 if(att!=0)  return push(att,awert,bwert);
 if(c==EOF) return ERR_EOF;
 if(c==0) {parserstr=oldparserstr(); return BEF_RET;}
 errorstr=feld;
 return err("parser",UNDEFINED);
}

int nachladen(char *filename)
{
 FILE *fp;
 printf("nachladen(%s)\n",filename);/* test1 */
 fp=fopen1(filename,"r"); if(fp==NULL) return 0;
 fclose(fp);
 postscript(filename,1,0);
 return 1;
}

int initclip()
{
 double *z,x,y;
 z=gs.clippath.anfang;
 TRANSFORM(0.,0.);	*z++ =MOVETO; *z++=x; *z++=y;
 TRANSFORM(0.,PSA4H);	*z++ =LINETO; *z++=x; *z++=y;
 TRANSFORM(PSA4B,PSA4H); *z++=LINETO; *z++=x; *z++=y;
 TRANSFORM(PSA4B,0.);	*z++ =LINETO; *z++=x; *z++=y;
 *z++ = CLOSEPATH;
 gs.clippath.ende=z;
 clippingmethode=WINDUNGSZAHL;
 setclip();
 return 0;
}

struct befehlstabelle {char *s; int (*func)();}    beftab[]=
{{"moveto",moveto},	{"lineto",lineto},	{"stroke",stroke},
 {"closepath",closepath},{"load",psload},	{"def",def},
 {"bind",bind},		{"pop",pspop},		{"dup",psdup},
 {"exch",exch},		{"copy",pscopy},	{"index",psindex},
 {"roll",roll},		{"rmoveto",rmoveto},	{"rlineto",rlineto},
 {"sub",sub},		{"add",add},		{"mul",mul},
 {"div",psdiv},		{"idiv",idiv},		{"neg",neg},
 {"abs",psabs},		{"not",psnot},		{"and",psand},
 {"or",psor},		{"xor",psxor},		{"sin",pssin},
 {"cos",pscos},		{"atan",psatan},	{"log",pslog},
 {"ln",psln},		{"sqrt",pssqrt},	{"round",round},
 {"truncate",truncate},	{"ceiling",ceiling},	{"floor",psfloor},
 {"exp",psexp},	{"mod",mod},	{"eq",eq},	{"ne",ne},
 {"lt",lt},	{"le",le},	{"gt",gt},	{"ge",ge},
 {"if",psif},	{"ifelse",psifelse},		{"bitshift",bitshift},
 {"put",put},	{"store",store},	{"get",get},
 {"show",show},	{"ashow",ashow},	{"getinterval",getinterval},
 {"newpath",newpath},
 {"putinterval",putinterval},	{"astore",astore},
 {"currentfile",currentfile},	{"readstring",readstring},
 {"read",psread},		{"readhexstring",readhexstring},
 {"readline",readline},
 {"maxlength",maxlength},	{"length",length},
 {"currentpoint",currentpoint},	{"currentfont",currentfont},
 {"currentgray",currentgray},	{"currentlinewidth",currentlinewidth},
 {"currentlinecap",currentlinecap},
 {"currentlinejoin",currentlinejoin},
 {"currentmiterlimit",currentmiterlimit},
 {"currentdash",currentdash},	{"currentflat",currentflat},
 {"dict",dict},		{"currentdict",currentdict},	{"known",known},
 {"where",where},	{"array",array},	{"packedarray",packedarray},
 {"mark",mark},		{"aload",aload},
 {"true",pstrue},	{"false",psfalse},	{"string",string},
 {"cvi",cvi},	{"cvr",cvr},	{"cvs",cvs},	{"cvn",cvn},
 {"cvx",cvx},	{"cvlit",cvlit},{"cvrs",cvrs},	{"type",type},
 {"scale",scale},	{"rotate",rotate},	{"translate",translate},
 {"arc",arc},		{"arcn",arcn},	{"setarcdelta",setarcdelta},
 {"fill",fill},		{"eofill",eofill},	{"arcto",arcto},
 {"curveto",curveto},	{"rcurveto",rcurveto},	{"setflat",setflat},
 {"rand",psrand},	{"srand",pssrand},	{"rrand",psrrand},
 {"findfont",findfont},	{"scalefont",scalefont},{"definefont",definefont},
 {"makefont",makefont},	{"setfont",setfont},	{"selectfont",selectfont},
 {"stringwidth",stringwidth},
 {"save",save},		{"restore",restore},
 {"gsave",gsave},	{"grestore",grestore},
 {"transform",transform},	{"dtransform",dtransform},
 {"itransform",itransform},	{"idtransform",idtransform},
 {"setgray",setgray},		{"setlinewidth",setlinewidth},
 {"setlinecap",setlinecap},	{"setlinejoin",setlinejoin},
 {"setmiterlimit",setmiterlimit},{"setdash",setdash},
 {"repeat",repeat},	{"loop",loop},		{"for",psfor},
 {"forall",forall},	{"exit",psexit},	{"stop",psstop},
 {"exec",exec},		{"stopped",stopped},
 {"readonly",psreadonly},	{"executeonly",executeonly},
 {"xcheck",xcheck},	{"wcheck",wcheck},	{"rcheck",rcheck},
 {"clear",psclear},	{"cleartomark",cleartomark},
 {"count",count},	{"counttomark",counttomark},
 {"search",search},	{"anchorsearch",anchorsearch},
 {"begin",begin},	{"end",end},
 {"rectfill",rectfill},	{"rectstroke",rectstroke},
 {"xshow",xshow},	{"yshow",yshow},	{"xyshow",xyshow},
 {"setcacheparams",setcacheparams}, {"currentcacheparams",currentcacheparams},
 {"setcachelimit",setcachelimit},   {"cachestatus",cachestatus},
 {"widthshow",widthshow},	{"awidthshow",awidthshow},  {"kshow",kshow},
 {"countdictstack",countdictstack},	{"dictstack",psdictstack},
 {"clip",clip},		{"eoclip",eoclip},
 {"clippath",clippath},	{"pathbbox",pathbbox}, {"flattenpath",flattenpath},
 {"image",image},	{"imagemask",imagemask}, {"colorimage",colorimage},
 {"setrgbcolor",setrgbcolor}, {"sethsbcolor",sethsbcolor},
 {"setcmykcolor",setcmykcolor}, {"setcmybcolor",setcmykcolor},
 {"currentrgbcolor",currentrgbcolor},
 {"invertmatrix",invertmatrix},		{"identmatrix",identmatrix},
 {"matrix",matrix},	{"currentmatrix",currentmatrix},
 {"setmatrix",setmatrix}, {"concat",concat}, {"concatmatrix",concatmatrix},
 {"settransfer",settransfer},	{"currenttransfer",currenttransfer},
 {"xlzug",xlzug},	{"lzug",lzug},	 	{"xlzug2",xlzug2},
 {"lzug2",lzug2},	{"xlzug3",xlzug3},	{"lzug3",lzug3},
 {"file",file},		{"closefile",closefile},{"run",run},
 {"print",psprint},	{"flush",flush},
 {"==",gleichgleich},	{"=",gleich},
 {"stack",stack},	{"pstack",pstack},
 {"version",version},	{"noaccess",noaccess},	{"usertime",usertime},
 {"pathforall",pathforall},
 {"showpage",showpage},	{"eexec",eexec},	{"token",token},
 {"setcachedevice",setcachedevice},		{"setcharwidth",setcharwidth},
 {"setpacking",setpacking},	{"currentpacking",currentpacking},
 {"initmatrix",initmatrix},	{"defaultmatrix",defaultmatrix},
 {"null",psnull},
 {"currentscreen",currentscreen}, {"setscreen",setscreen},
 {"errordict",errordict}, {"setjobtimeout",setjobtimeout},
 {NULL,NULL}
}; /* Ende der Befehlstabelle */

#define NDF ".notdef"
static char *standardencodtabelle[]=
{NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,
 NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,
/* 30 */
 "space","exclam","quotedbl","numbersign","dollar","percent","ampersand",
 "quoteright",
 "parenleft","parenright","asterisk","plus","comma","hyphen","period","slash",
 "zero","one","two","three","four","five","six","seven",
 "eight","nine","colon","semicolon","less","equal","greater","question",
/* 40 */
 "at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R",
 "S","T","U","V","W","X","Y","Z",
 "bracketleft","backslash","bracketright","asciicircum","underscore",
/* 60 */
 "quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p",
 "q","r","s","t","u","v","w","x","y","z",
 "braceleft","bar","braceright","asciitilde",NDF,
/* 80 */
 NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,
 NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,
/* A0 */
 NDF,"exclamdown","cent","sterling","fraction","yen","florin","section",
 "currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft",
 "guilsinglright","fi","fl",
 NDF,"endash","dagger","daggerdbl","periodcentered",NDF,
 "paragraph","bullet",
 "quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis",
 "perthousand",NDF,"questiondown",
/* C0 */
 NDF,"grave","acute","circumflex","tilde","macron","breve","dotaccent",
 "dieresis",NDF,"ring","cedilla",NDF,"hungarumlaut","ogonek","caron",
 "emdash",NDF,NDF,NDF,NDF,NDF,NDF,NDF,
 NDF,NDF,NDF,NDF,NDF,NDF,NDF,NDF,
/* E0 */
 NDF,"AE",NDF,"ordfeminine",NDF,NDF,NDF,NDF,
 "Lslash","Oslash","OE","ordmasculine",NDF,NDF,NDF,NDF,
 NDF,"ae",NDF,NDF,NDF,"dotlessi",NDF,NDF,
 "lslash","oslash","oe","germandbls",NDF,NDF,NDF,NDF
}; /* Ende der standardencodtabelle */

void postscript_firstinit()
{
 struct befehlstabelle *bef;
 long timeloc;
 char **str;
 int i;
/* einmalige Speicheranforderungen: */
 if((isalnumpu_tab=(char *)vmalloc(256))==NULL)  fatalmemfull();
 isalnumpu_tab_init();
 opstack=(struct stackeintrag *)malloc(IOPSTMAX*sizeof(struct stackeintrag));
 if(opstack==NULL)  fatalmemfull();
 if(getgspfade(&gs)==NULL) fatalmemfull();
 gs.next=NULL; gs.clipflag=0; gs.transferfunc.attr=0;
/* systemdict aufbauen und auf dictstack legen */
 namepush("systemdict"); intpush(SYSMAX); dict(); psdup(); begin();
/* psreadonly(); */ def();
 dict_startflags=0;
 for(bef=beftab;bef->s!=NULL;bef++)
	{namepush(bef->s); push(TYP_SYSPROC,0,(long)bef->func); def();}
 namepush("StandardEncoding");
 mark(); for(i=0,str=standardencodtabelle;i<256;i++) namepush(*str++);
 macharray(); def();
 DEBUG(1,printf("firstinit() systemdict aufgebaut\n"));
 intpush(STATUSMAX); dict(); namepush("statusdict");
 intpush(1); psindex(); def();
 begin();
 namepush("printername"); stringpush("VectMal"); def();
 namepush("product");
 if(!argflag['Q'] && (argflag['W'] || argflag['P'] || argflag['C'])) 
	stringpush("DisplayVectMal");
 else	stringpush("VectMal");
 def();
 namepush("pagecount"); intpush(1); def();
 namepush("revision"); stringpush(REVISION); def();
 end();
 namepush("FontDirectory"); intpush(FONTDIRMAX); dict(); def();
/* userdict aufbauen und auf dictstack legen */
 namepush("userdict"); intpush(USERMAX); dict(); psdup(); begin();
/* psreadonly(); */ def();
 DEBUG(1,printf("            userdict aufgebaut\n"));
 stdinfile=stdin; stdoutfile=stdout;
 {timeb_t zeit; ftime(&zeit); startzeit=zeit.time*1000+zeit.millitm;}
// strcpy(vectmalfont,"Courier");
 strcpy(vectmalfont,"Helvetica"); //neue Font-Voreinstellung
 sprintf(uvectmalfont,"u%s",vectmalfont);
}

void namepush(char *str)
{
 ULONG key;
 push(TYP_NAME,key=getkey((UBYTE*)str),(long)str);
 if(key<=1) printf("Fehler in 'namepush()' str='%s' key=%ld\n",str,(long)key);
}

void stringpush(char* s) {push(TYP_STRING,strlen(s),(long)s);}

/*************************** getkey ******************************/
struct keyeintrag
 {struct keyeintrag *next; ULONG k,key; UBYTE *name;}
 *keytabelle[256]=
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };

int getkey(UBYTE* name) /* Rueckgabe: key   1=Fehler 0=Fehler */
{
 ULONG key;
 static ULONG keymax=0x80000000;
 UBYTE *str;
 struct keyeintrag *pke,**pkt;
 int i,c;
 str=name;
 if((key= *str++)==0) return 1;
 for(i=0;i<3;i++)
	{if((c= *str++)==0) return key;
	 key=(key<<8)+c;
	}
 if(*str==0 && (key & 0x80000000)==0) return key;
 while((c= *str++)!=0)
	{if(key & 0x80000000) c++;
	 key += key+c;
	}
 pkt= &keytabelle[key & 0xFF];
 for(pke= *pkt; pke!=NULL; pke=pke->next)
   if(key==pke->k && strcmp((char*)pke->name,(char*)name)==0) return pke->key;
 if((keymax & 0x80000000)==0) return 1; /* Fehler: zu viele Namen */
 pke=(struct keyeintrag *)
	malloc(sizeof(struct keyeintrag)+strlen((char*)name)+1);
 if(pke==NULL) return 0; /* Fehler */
 pke->k=key;
 pke->key=(key & 0xFF)+keymax; /* eindeutiger Schlssel machen */
 keymax += 0x100;
 str=(UBYTE *)(&pke[1]);
 pke->name=str;
 strcpy((char*)str,(char*)name);
 pke->next= *pkt; *pkt=pke;
 return pke->key;
}

char *reverse(char* str)
{
 char *s1,*s2;
 int c;
 if((c=strlen(str))>1)
   for(s1=str,s2= &str[c-1];s1<s2;) {c= *s1;  *s1++ = *s2;  *s2-- = c;}
 return str;
}

char *getkeyname(ULONG key,char* str) /* Aufruf: str=getkeyname(key,"...."); */
{
 struct keyeintrag *k;
 char *s;
 int i;
 if(key&0x80000000)
	{for(k=keytabelle[key&0xFF]; k!=NULL && k->key!=key; k=k->next)  ;
	 if(k==NULL) return NULL;
	 s=(char*)k->name;
	}
 else	{for(i=0,s=str;i<=3;i++) {*s++ = key&0xFF; key>>=8;}
	 *s=0;
	 s=reverse(str);
	}
 return s;
}

int newgetkey(UBYTE* name,int* error) /* Rueckgabe: key   Fehler: error!=0 */
{
 ULONG key;
 static ULONG keymax=0x80000000;
 UBYTE *str;
 struct keyeintrag *pke,**pkt;
 int i,c;
 *error=0;
 str=name;
 key= *str++;
 for(i=0;i<3;i++)
	{if((c= *str++)==0) return key;
	 key=(key<<8)+c;
	}
 if(*str==0 && (key & 0x80000000)==0) return key;
 while((c= *str++)!=0)
	{if(key & 0x80000000) c++;
	 key += key+c;
	}
 pkt= &keytabelle[key & 0xFF];
 for(pke= *pkt; pke!=NULL; pke=pke->next)
   if(key==pke->k && strcmp((char*)pke->name,(char*)name)==0) return pke->key;
 if((keymax & 0x80000000)==0) {*error=1; return 0;} /* Fehler: zu viele Namen */
 pke=(struct keyeintrag *)
	malloc(sizeof(struct keyeintrag)+strlen((char*)name)+1);
 if(pke==NULL) {*error=2; return 0;} /* Fehler */
 pke->k=key;
 pke->key=(key & 0xFF)+keymax; /* eindeutiger Schlssel machen */
 keymax += 0x100;
 str=(UBYTE *)(&pke[1]);
 pke->name=str;
 strcpy((char*)str,(char*)name);
 pke->next= *pkt; *pkt=pke;
 return pke->key;
}

/************* Postscript-Fehlermeldungen ********************/
#define MAXFEHLER 50

void fehlermeldung(int nr)
{
 static int nfehler=0;
 static char *typecheck_err[]=
	{"NOINT","NONAM","NOSTR","NOFONT","NOARRAY",
	 "NOPROC","NONUM","NOBOOL","NOBOOLINT","NODICT","NOFILE"};
 printf("PS-ERROR in '%s':",errfun);
 if(nr<=TYPECHECK_MAX && nr>=TYPECHECK_MIN)
	printf("TYPECHECK_%s\n",typecheck_err[TYPECHECK_MAX-nr]);
 else switch(nr)
	{case STACKUNDER: printf("Stackunderflow\n"); break;
	 case STACKOVER:  printf("Stackoverflow\n"); break;
	 case NOAKTPOINT: printf("No actual Point\n"); break;
	 case WRONGTYPE:  printf("wrong type\n"); break;
	 case MEMFULL:    printf("Memory full\n"); break;
	 case UNDEFINED:  printf("undefined '%s'\n",errorstr); break;
	 case KEYERROR:   printf("'%s' key=%ld\n",
				 keyerror_s,(long)keyerror_key); break;
	 case SYNTAXERR:  printf("SYNTAXERR '%s'\n",synerr); synerr[0]=0; break;
	 case STRZULANG:  printf("STRZULANG\n"); break;
	 case LIMITCHECK: printf("LIMITCHECK\n"); break;
	 case NOPATH:	  printf("NOPATH\n"); break;
	 case DICTFULL:   printf("DICTFULL\n"); break;
	 case RANGECHECK: printf("RANGECHECK\n"); break;
	 case INVALIDEXIT: printf("INVALIDEXIT\n"); break;
	 case MISSINGMARK: printf("MISSINGMARK\n"); break;
	 case INVALIDFONT: printf("INVALIDFONT\n"); break;
	 case INVALIDFONTTYPE: printf("INVALIDFONTTYPE\n"); break;
	 case PATH_CORRUPT: printf("PATH_CORRUPT\n"); break;
	 case EXESTACKOVER: printf("EXESTACKOVER\n"); break;
	 case FALSCHERWERT: printf("FALSCHERWERT\n"); break;
	 case MIXEDBOOLINT: printf("MIXEDBOOLINT\n"); break;
	 case UNDEFINEDFILE: printf("UNDEFINEDFILE\n"); break;
	 case INVALIDRESTORE: printf("INVALIDRESTORE\n");
			      printdictstack(dictstack);
			      break;
	 case UNDEFINEDRESULT:printf("undefined result'%s'\n",errorstr); break;
	 default: printf("%d\n moegliches Problem:",nr);
		  switch(nr)
			{case BEF_EXIT:printf("BEF_EXIT\n");
			 CASE BEF_RET: printf("BEF_RET\n");
			 DEFAULT: printf("???\n");
			}
	}
 errorstr="errorstr"; errfun="errfun";
 if(++nfehler >= MAXFEHLER) exit(0);
}

/********** Aufrufe aus 'klick()' welche Postscriptdinge brauchen ***********/
void dings_start()
{
 undo_nline=fptemp_nlines;
 qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
}

void dings_term()
{
 term();
 if(zentrieren_flag) {zentrieren_flag++; letztes_zentrieren();}
}

static double px2,py2,px3,py3;//von schraffieren() auch bentigt

int objektbox_start()
{
// double px2,py2,px3,py3,dick;
 double dick;
 dings_start();
 pathbbox(); zahlpop(&py3); zahlpop(&px3); zahlpop(&py2); zahlpop(&px2);
/* Zuzaehlen der Liniendicke: */
 dick=gs.linewidth/2.; /* = currentlinewidth 2 div */
 px2-=dick; py2-=dick; px3+=dick; py3+=dick;
 fprintfld(fptemp,"%%Objektbox: %lg %lg %lg %lg\n",px2,py2,px3,py3);
 fprintfl(fptemp,"gsave\n");
 setgraphics();
}
void setgraphics()
{
 double flatness,linewidth,miterlimit;
 int i,linecap,linejoin, dashlen,dashoffset, rot,gruen,blau,farbnr;
 char dashfeld[MAXDASH];
 flatness=gs.flatness; linewidth=gs.linewidth;
 get_color(gs.farbnummer,&rot,&gruen,&blau);
 miterlimit=gs.miterlimit; linecap=gs.linecap; linejoin=gs.linejoin;
 dashlen=gs.dashlen; dashoffset=gs.dashoffset;
 for(i=0;i<dashlen;i++) dashfeld[i]=gs.dashfeld[i];
 farbnr=gs.farbnummer;
 initgraphics();
 if(flatness!=1.0) { zahlpush(flatness); setflat();
		     fprintfld(fptemp,"%lg setflat\n",flatness); }
 if(rot+gruen+blau!=0)
		{gs.farbnummer=farbnr;
		 darflag=darflag_farbe=1;
		 fprintfld(fptemp,"%lg %lg %lg setrgbcolor\n",
				 rot/255.,gruen/255.,blau/255.);
		}
 if(linewidth!=1.0) { zahlpush(linewidth); setlinewidth();
		      fprintfld(fptemp,"%lg setlinewidth\n",linewidth); }
 if(miterlimit!=10.) { zahlpush(miterlimit); setmiterlimit();
		       fprintfld(fptemp,"%lg setmiterlimit\n",miterlimit); }
 if(linecap!=0) { intpush(linecap); setlinecap();
		  fprintfl(fptemp,"%d setlinecap\n",linecap); }
 if(linejoin!=0) { intpush(linejoin); setlinejoin();
		   fprintfl(fptemp,"%d setlinejoin\n",linejoin); }
 if(dashlen!=0) {mark(); fprintf(fptemp,"[");
		 for(i=0;i<dashlen;i++)
/* KoordinatenUmrechnung erforderlich ?
			{intpush(dashfeld[i]);
			 fprintf(fptemp,"%d ",dashfeld[i]); 
			}
/* im LupeModus sollte Umrechnung aber wie ohne Lupe erfolgen */
		  {double x=ideltatrans((double)dashfeld[i]);
		   zahlpush(x);
		   fprintf(fptemp,"%lf ",x*lupe_faktor[lupe_i]);
		  }
		 macharray(); intpush(dashoffset); setdash();
		 fprintfl(fptemp,"] %d setdash\n",dashoffset);
		}
 if(darflag) lineattribute_setzen();
}

int objektbox_term()
{
 fprintfl(fptemp,"grestore\n");
 fprintfl(fptemp,"%%Objektende\n");
 dings_term();
}

void linienzug(XPoint* feld,int imax)
{
 int i;
 switch(fadenkreuz_typ)
  {case PFEIL:	for(i=1;i<imax;i++)
			pfeilzug2(feld[i-1].x,feld[i-1].y,feld[i].x,feld[i].y);
   CASE DOPPEL: for(i=1;i<imax;i++)
			doppelzug2(feld[i-1].x,feld[i-1].y,feld[i].x,feld[i].y);
   DEFAULT:	linienzug2(feld,imax);
		objektbox_start(); stroke_fptemp(); objektbox_term();
  }
}
void doppelzug2(int ix1,int iy1,int ix2,int iy2)
{
 double x1,y1,x2,y2,dx,dy,L,vx,vy,a2,fa;
 int ras;
 bkoord2user(ix1,iy1,&x1,&y1); bkoord2user(ix2,iy2,&x2,&y2);
 if(ras=rasterpunkt)	
	{
/** schon in bkoord2user gerundet
	 normtransform(&vx,&vy,x1,y1); invtransformru(&x1,&y1,vx,vy);
	 normtransform(&vx,&vy,x2,y2); invtransformru(&x2,&y2,vx,vy);
**/
	 rasterpunkt=0;
	}
 dx=x2-x1; dy=y2-y1; L=sqrt(dx*dx+dy*dy);
 if(gs.linewidth>0.) fa=gs.linewidth*2.; else fa=2.;
 a2=doppel_a2*fa;
 vx=a2*dy/L; vy= -a2*dx/L;
 zahlpush2(x1+vx,y1+vy); moveto();
 zahlpush2(x2+vx,y2+vy); lineto();
 zahlpush2(x1-vx,y1-vy); moveto();
 zahlpush2(x2-vx,y2-vy); lineto();
 objektbox_start(); stroke_fptemp(); objektbox_term();
 rasterpunkt=ras;
}
void pfeilzug2(int ix1,int iy1,int ix2,int iy2)
{
 double x1,y1,x2,y2,dx,dy,L,vx,vy,x3,y3,a2,a3,fa,lw;
 int ras;
 bkoord2user(ix1,iy1,&x1,&y1); bkoord2user(ix2,iy2,&x2,&y2);
 if(ras=rasterpunkt)
	 rasterpunkt=0;
 dx=x2-x1; dy=y2-y1; L=sqrt(dx*dx+dy*dy);
 if(L==0.) {rasterpunkt=ras; return;}
 if((lw=gs.linewidth)>0.) fa=gs.linewidth*2.; else fa=2.;
 a2=pfeil_a2*fa;
 a3=pfeil_a3*fa;
 vx=a2*dy/L; vy= -a2*dx/L;
 x3=x2+(x1-x2)*a3/L;
 y3=y2+(y1-y2)*a3/L;
 zahlpush2(x1,y1); moveto();
 if(pfeil_amplitude==0.)
	{zahlpush2(x3,y3); lineto();
	 objektbox_start(); stroke_fptemp();
	}
 else	/* Wellenlinie: */
	{double alfa,Lmax,dx2;
	 char str[120];
	 objektbox_start();
	 gsave(); zahlpush2(x1,y1); translate();
	 if(dx>=0.) alfa=asin(dy/L)/GRAD; else alfa=(PI-asin(dy/L))/GRAD;
	 zahlpush(alfa); rotate();
	 fprintfld(fptemp,"gsave %lf %lf translate 0 0 moveto %.2lf rotate\n",
				x1, y1, alfa);
	 Lmax=L-a3; dx2=Lmax/100.; if(a3!=0.0 && dx2>a3/10.) dx2=a3/10.;
	 sprintf(str,"%lf %lf %lf {dup %lf div sin %lf mul lineto}for",
			dx2,dx2,Lmax+dx2/2.,pfeil_periode/360.,pfeil_amplitude);
	 exec_str(str); fprintfl(fptemp,"%s\n",(long)str);
	 stroke(); grestore(); fprintfl(fptemp,"stroke grestore\n");
	}
 if(a2!=0 && a3!=0) //Pfeilspitze nur zeichnen wenn Groesse gesetzt
  {if(pfeil_fill)
	{gs.linewidth=0.; fprintfl(fptemp,"0 setlinewidth\n");}
   zahlpush2(x2,y2); moveto();
   zahlpush2(x3+vx,y3+vy); lineto();
   zahlpush2(x3-vx,y3-vy); lineto(); closepath();
   if(pfeil_fill)
	{fill_fptemp(WINDUNGSZAHL,&gs.path,1); fprintf(fptemp,"fill ");
	 gs.linewidth=lw;
	}
   else stroke_fptemp();
  }
 else newpath();//offenbar ntig, Grund unbekannt
 objektbox_term();
 rasterpunkt=ras;
}

void linienzug2(XPoint* feld,int imax)
{
 int i;
 moveto_bkoord(feld[0].x,feld[0].y);
 for(i=1;i<imax;i++)  lineto_bkoord(feld[i].x,feld[i].y);
}

void linienzug_closepath(XPoint* feld,int imax)
{
 linienzug2(feld,imax); closepath();
 objektbox_start();
 stroke_fptemp();
 objektbox_term();
}

void linienzug_closefill(XPoint* feld,int imax)
{
 linienzug2(feld,imax); closepath();
 objektbox_start();
 fill_fptemp(WINDUNGSZAHL,&gs.path,1);
 if(fuellmethode==FILL) fprintfl(fptemp,"fill\n");
 else schraffieren(fptemp);
 objektbox_term();
}

void linienzug_bezier(XPoint* feld,int jmax)
{
 int i,j;
 moveto_bkoord(feld[0].x,feld[0].y);
 for(i=j=1;i<4;i++) {bkoord2user_push(feld[j].x,feld[j].y); if(j<jmax) j++;}
 curveto();
 objektbox_start();
 stroke_fptemp();
 objektbox_term();
}

int defLaflag=0,defLasymflag=0,defLUmlautflag=0,defSchraffierenflag=0,
	defEllipseflag=0;

void showtext()
{
 double px1,py1,px2,py2,px3,py3,alfa,sina,cosa,dex,dey,scafak;
 double hx,hy,hx2,hy2;
 REAL sx,sy;
 int Laflag=0,ku=0,nfind=0,n;
 char *text=texttext,*fontname;
 invtransformru(&px1,&py1,XWERT(bru_x1),YWERT(bru_y1));
 if(hochformat)	{dex=x2fenster-x1fenster; dey=y2fenster-y1fenster;}
 else		{dey=x2fenster-x1fenster; dex=y2fenster-y1fenster;}
 sx.d=buchst_dx/dex;
 sy.d=buchst_dy/dey;
 dex=buchst_dx/dex*PSA4B*strlen(text);
 dey=buchst_dy/dey*PSA4H;
 alfa=brush_winkel*PI/180.; sina=sin(alfa); cosa=cos(alfa);
 if(buchst_winkel>=360)  buchst_winkel -= 360;
 switch(buchst_winkel/90)
	{case 0: px2=px1-dey*sina; py2=py1;
		 px3=px1+dex*cosa; py3=py1+dex*sina+dey*cosa;
	 CASE 1: px2=px1+dex*cosa-dey*sina; py2=py1+dey*cosa;
		 px3=px1; py3=py1+dex*sina;
	 CASE 2: px2=px1+dex*cosa; py2=py1+dex*sina+dey*cosa;
		 px3=px1-dey*sina; py3=py1;
	 CASE 3: px2=px1; py2=py1+dex*sina;
		 px3=px1+dex*cosa-dey*sina; py3=py1+dey*cosa;
	 DEFAULT:fatalerror(1);
	}
 if(*text=='$' && *++text!='$')
	{if(((ku=Latexfilter(text))&1) && defLasymflag==0)
				 {defLasym(); /* testflag=1;*/}
	 if(ku&2) /* Umlaute vorhanden ? */
		{if(defLUmlautflag==0) defLUmlaut();
		 defaultfontflag=0;
		 namepush(uvectmalfont); nfind=findfont();
		 if(nfind) {FILE *fppro;
			    namepush(uvectmalfont); namepush(vectmalfont);
			    if((n=findfont())==0) exec_str("machufont");
			    else {errfun="showtext"; fehlermeldung(n);}
			    fppro=fopen_prolog();
			    fprintf(fppro,"/%s /%s findfont machufont\n",
					(long)uvectmalfont,(long)vectmalfont);
			    fclose(fppro);
			   }
		 else	pspop();
		 defaultfontflag=1;
		}
	 Laflag=1; if(defLaflag==0) defLashow();
	}
 dings_start();
 save();
/* setgraphics(); offensichtlich falsche Position */
 if(ku&2) fontname=uvectmalfont; else fontname=vectmalfont;
 namepush(fontname);
 findfont();
 sx.d /= sy.d; scafak=sy.d=PSA4H*sy.d;
 push(TYP_REAL,sy.n[0],sy.n[1]); scalefont(); setfont();
 sy.d=1.0;
 if(px1!=0. || py1!=0.)  {zahlpush2(px1,py1); translate();}
 if(buchst_winkel!=0)	 {intpush(buchst_winkel); rotate();}
 push(TYP_REAL,sx.n[0],sx.n[1]); push(TYP_REAL,sy.n[0],sy.n[1]);
 scale();
 intpush(0); intpush(0);
 moveto();
 push(TYP_STRING+ZUS,strlen(text),(long)text);
 if(Laflag)	{zahlpush(scafak); exec_str("Lashow");}
 else		{show();}
/* fuer Box-Berechnung: */
 currentpoint(); zahlpop2(&hx,&hy); newpath();
 zahlpush(hx); intpush(0); moveto();
 zahlpush2(hx,scafak); lineto();
 intpush(0); zahlpush(scafak); lineto();
 intpush(0); intpush(0); lineto(); closepath(); pathbbox();
 transform(); zahlpop2(&hx2,&hy2);
 transform(); zahlpop2(&hx,&hy);
/* Punkt unten links ist jetzt in hx hy , oben rechts in hx2 hy2 */
 restore();
 invtransform(&px2,&py2,hx,hy); invtransform(&px3,&py3,hx2,hy2); /* Box */
 fprintfld(fptemp,"%%Objektbox: %lg %lg %lg %lg\n",px2,py2,px3,py3);
 fprintfl(fptemp,"save\n");
 setgraphics();
 fprintf(fptemp,"/%s findfont ",fontname);
 fprintfld(fptemp,"%lg scalefont setfont\n",scafak);
 if(px1!=0. || py1!=0.) {fprintfld(fptemp,"%lg %lg translate\n",px1,py1);}
 if(buchst_winkel!=0)	{fprintfl(fptemp,"%d rotate\n",buchst_winkel);}
 fprintfld(fptemp,"%lg 1 scale\n",sx.d);
 fprintfl(fptemp,"0 0 moveto\n");
 fprintfl(fptemp,"(%s)\n",(long)text);
 if(Laflag)	fprintfld(fptemp,"%lg Lashow  restore\n",scafak);
 else		fprintfl(fptemp,"show  restore\n");
 fprintfl(fptemp,"%%Objektende\n");
 dings_term();
}

FILE *fopen_prolog() {prolog_flag=1; return fopen2(PROLOGNAME,"a");}
void FPL1(FILE *fp,char *str) {fprintf(fp,str); exec_str(str);}
#define FPL(s) FPL1(fp,s)
#define FPL2 FPL
#define FPL3 FPL
#define FPL4 FPL
#define FPL5 FPL

void defLashow()
{
 FILE *fp=fopen_prolog();
 FPL("/bdef {bind def} bind def\n");
 FPL("/hoch 16#5E def /tief 16#5F def /kauf 16#7B def /kzu 16#7D def\n");
/* FPL("/bslash 16#5C def /buf 1 string def /er false def\n"); */
 FPL("/bslash 16#60 def /buf 1 string def /er false def\n");
 FPL("/ghfont {mul rmoveto hfont setfont /er true def /HH 0.7 def} bdef\n");
 FPL("/ho {gsave 0 H 0.5 ghfont} bdef /ti {gsave 0 H -0.3 ghfont} bdef\n");
 FPL2("/alte {currentpoint grestore currentpoint exch pop exch pop moveto\n\
	/HH 1 def} bdef\n");
 FPL("/csho {buf 0 3 -1 roll put buf show} bdef\n");
 FPL("/cshow {er{dup kauf eq{pop}{csho alte}ifelse /er false def}{csho}ifelse} \
bdef\n");
 FPL4("/xxshow {dup hoch eq{pop ho} {dup tief eq{pop ti}{dup kzu eq{pop alte}\n\
 {dup bslash eq{pop bflg{Symfont /bflg false}{nfont /bflg true}ifelse\n\
		def H HH mul scalefont setfont}\n\
 {cshow}ifelse}ifelse}ifelse}ifelse} bdef\n");
 FPL3("/Lashow {/H exch def /hfont currentfont 0.7 scalefont def\n\
	/nfont currentfont 1 H div scalefont def /bflg true def /HH 1 def\n\
	0 1 2 index length 1 sub{1 index exch get xxshow}for pop}bdef\n");
 defLaflag=1;
 fclose(fp);
}
void defLasym()
{
 FILE *fp=fopen_prolog();
// FPL("/Symfont /Symbol findfont def\n");
 fprintfl(fp,"/Symfont /Symbol findfont def\n");
 namepush("Symfont"); namepush("Symbol"); findfont(); def();
/* Verwendung von FPL() gibt hier einen unerklaerlichen Fehler in exec_str() */
 defLasymflag=1;
 fclose(fp);
}
void defLUmlaut()
{
 FILE *fp=fopen_prolog();
 FPL5("/machufont {/temp 1 index length dict def temp begin\n\
 {1 index dup /FID eq exch /Encoding eq or {pop pop} {def} ifelse} forall\n\
 /Encoding StandardEncoding 256 array copy def\n\
 Encoding 16#81 [/adieresis /odieresis /udieresis /Adieresis /Odieresis\n\
 /Udieresis /Aring] putinterval end temp definefont pop}def\n");
 defLUmlautflag=1;
 fclose(fp);
}
void defEllipse()
{
 FILE *fp=fopen_prolog();
 FPL5("/edef {exch def} bind def\n\
/ellipse\n\
{/eps edef /a2 edef /a1 edef /r edef /ym edef /xm edef\n\
 a1 cos r mul xm add a1 sin r mul eps mul ym add moveto a1 1 add 1 a2\n\
 {dup cos r mul xm add exch sin r mul eps mul ym add lineto} for } def\n");
 defEllipseflag=1;
 fclose(fp);
}

void moveto_bkoord(int x1,int y1)
{
 REAL x2,y2;
 bkoord2user(x1,y1,&x2.d,&y2.d);
 push(TYP_REAL,x2.n[0],x2.n[1]); push(TYP_REAL,y2.n[0],y2.n[1]); moveto();
}
void lineto_bkoord(int x1,int y1)
{
 REAL x2,y2;
 bkoord2user(x1,y1,&x2.d,&y2.d);
 push(TYP_REAL,x2.n[0],x2.n[1]); push(TYP_REAL,y2.n[0],y2.n[1]); lineto();
}

void bkoord2user(int xb,int yb,double* xu,double* yu)
{
 REAL x,y;
 x.d=XWERT(xb); y.d=YWERT(yb);
 push(TYP_REAL,x.n[0],x.n[1]); push(TYP_REAL,y.n[0],y.n[1]); itransform();
 zahlpop(yu); zahlpop(xu);
 if(rasterpunkt!=0)
	{*xu=doubrund(*xu,(double)rasterpunkt);
	 *yu=doubrund(*yu,(double)rasterpunkt);
	}
}

void bkoord2user_push(int xb,int yb)
{
 REAL x,y,xu,yu;
 x.d=XWERT(xb); y.d=YWERT(yb);
 push(TYP_REAL,x.n[0],x.n[1]); push(TYP_REAL,y.n[0],y.n[1]); itransform();
 zahlpop(&yu.d); zahlpop(&xu.d);
 if(rasterpunkt!=0)
	{xu.d=doubrund(xu.d,(double)rasterpunkt);
	 yu.d=doubrund(yu.d,(double)rasterpunkt);
	}
 push(TYP_REAL,xu.n[0],xu.n[1]); push(TYP_REAL,yu.n[0],yu.n[1]);
}

void bkoord2user_push1(int xb)
{
 REAL x;
 x.d=ideltatransru(XWERTD(xb));
 push(TYP_REAL,x.n[0],x.n[1]);
}

void showviereck(int x1,int y1,int x2,int y2,int x3,int y3,int x4,int y4)
{
 moveto_bkoord(x1,y1); lineto_bkoord(x2,y2);
 lineto_bkoord(x3,y3); lineto_bkoord(x4,y4); closepath();
 objektbox_start();
 if(viereck_knopfnr==2)
	{fill_fptemp(WINDUNGSZAHL,&gs.path,1); fprintfl(fptemp,"fill\n");}
 else	stroke_fptemp();
 objektbox_term();
}

void showkreis(int x,int y,int r)
{
 double xd,yd;
 if(ellipseflag) gsave();
 bkoord2user_push(x,y);
 if(ellipseflag)
	{if(defEllipseflag==0) defEllipse();
	 translate(); //intpush(1); zahlpush(ellipsefakt); scale();
	 intpush(0); intpush(0);
	}
 bkoord2user_push1(r);
 intpush(0); intpush(360);
 if(ellipseflag) {zahlpush(ellipsefakt); exec_str("ellipse");}
 else arc();
 objektbox_start();
 if(kreis_knopfnr==2) fill();
 else stroke();
 if(ellipseflag) grestore();
 invtransformru(&xd,&yd,XWERT(x),YWERT(y));
 fprintf(fptemp,"newpath %lg %lg ",xd,yd);
 if(ellipseflag) //fprintfld(fptemp,"translate 1 %lg scale 0 0\n",ellipsefakt);
	fprintfl(fptemp,"translate 0 0\n");
 fprintf(fptemp,"%lg ",ideltatransru(XWERTD(r)));
 if(ellipseflag)
  {if(kreis_knopfnr==2) fprintfld(fptemp,"0 360 %lg ellipse fill\n",ellipsefakt);
   else fprintfld(fptemp,"0 360 %lg ellipse stroke\n",ellipsefakt);
  }
 else
  {if(kreis_knopfnr==2) fprintfl(fptemp,"0 360 arc fill\n");
   else fprintfl(fptemp,"0 360 arc stroke\n");
  }
 objektbox_term();
}

void fprintfl(FILE *fp,char *str,long p1,long p2,long p3,long p4)
{
 fptemp_nlines++;
 fprintf(fp,str,p1,p2,p3,p4);
}

void fprintfld(FILE *fp,char *str,double p1,double p2,double p3,double p4)
{
 fptemp_nlines++;
 fprintf(fp,str,p1,p2,p3,p4);
}

/*********************** Zentrieren ****************************/
void letztes_zentrieren()
{
 FILE *fp,*fp2;
 int c;
 double x1,y1,x2,y2,dx;
 if(undo_nline>=fptemp_nlines) {printf("zuerst Objekt einsetzen\n"); return;}
 undo();
 rename(UNDONAME,HILFSNAME);
 fp=fopen2(HILFSNAME,"r"); fp2=fopen2(UNDONAME,"w");
 if(fp==NULL || fp2==NULL) return;
 while((c=getc(fp))!=EOF && c!=':') putc(c,fp2);
 fscanf(fp,"%lf %lf %lf %lf",&x1,&y1,&x2,&y2);
 dx=zentriermitte-(x2+x1)/2.;
 x1+=dx; x2+=dx;
 fprintf(fp2,": %lg %lg %lg %lg\n",x1,y1,x2,y2);
 fprintf(fp2,"gsave %lg 0 translate ",dx);
 while((c=getc(fp))!=EOF && c!='%') {ungetc(c,fp); zeilekopieren(fp,fp2);}
 fprintf(fp2,"grestore\n"); /* vor %Objektende einsetzen */
 while(c!=EOF) {putc(c,fp2); c=getc(fp);}
 fclose(fp); fclose(fp2);
 Delete(HILFSNAME);
 undo();
}

/***************** von epsprint.c kopiert und abgeaendert ******************/
int zsuchen(FILE *fp,char *str)
{
 int c;
 while((c=getc(fp))!=EOF && c!='\n')
	{if(*str==0) return 1;
	 if(c!= *str++) return 0;
	}
 return 0;
}
int suchen(FILE *fp,char *str)
{
 int c;
 while((c=getc(fp))!=EOF)
	{if(c=='%')
		{if(zsuchen(fp,&str[1])==1) return 1;
		 while((c=getc(fp))!=EOF && c!='\n')  ;
		}
	}
 return 0;
}
int preview_suchen(FILE *fp,char *str)
{
 int c;
 while(suchen(fp,str)==1)
	{while((c=getc(fp))==' ' || c=='\t')  ;
	 if(c!='(') {ungetc(c,fp); return 1;}
	 /* bei '(atend)' muss weitergesucht werden */
	}
 return 0;
}

int bbox_suchen(FILE *fp,char *str,char *retstring,int retmax)
{
 int c,f1,f2,i,i2,retwert=0,boundsuch=1;
 char *s1,*s2, *str2="%%DocumentFonts";
 int f3,docsuch=1,docjustfound,docfortsetzsuch=0; /* fr Fortsetzungszeilen */
 char *s3, *str3="%%+"; /* fr Fortsetzungszeilen */
 while((c=getc(fp))!=EOF)
  {if(c=='%') /* suche Prozentzeichen am Zeilenanfang */
    {for(f2=docsuch,f1=boundsuch,s1= &str[1],s2= &str2[1],s3= &str3[1],
	 f3=docfortsetzsuch;
		 f1 || f2 || f3;)
	{if((c=getc(fp))==EOF) return retwert;
	 if(f1) {if(*s1==c) s1++; else f1=0;}/*bei Ungleichheit Flag lschen*/
	 if(f2) {if(*s2==c) s2++; else f2=0;}
	 if(f3) {if(*s3==c) s3++; else f3=0;}
	}
     if(*s1==0) /* "%%BoundingBox:" gefunden */
	{while((c=getc(fp))==' ' || c=='\t')  ;
	 if(c!='(')
		{for(s1=retstring,i=1; c!='\n' && c!=EOF && i<retmax; i++)
			{*s1++ = c; c=getc(fp);}/* Rest der Zeile speichern */
		 *s1=0;
		 retwert=1;
		 boundsuch=0;
		 docfortsetzsuch=0;
		}
	 /* bei '(atend)' muss weitergesucht werden */
	}
     else if(*s2==0) /* "%%DocumentFonts:" gefunden */
	{while((c=getc(fp))==' ' || c=='\t')  ;
	 if(c=='(') continue;/* bei '(atend)' muss weitergesucht werden */
	 for(fontliste_zaehler=i2=0; c!='\n' && c!=EOF;)
		{fontliste[i2++]=c;
		 c=getc(fp);
		 if(c==' ' || c=='\t')
			{fontliste[i2++]=0; fontliste_zaehler++;
			 while((c=getc(fp))==' ' || c=='\t')  ;
			}
		 if(c=='\n' || c==EOF)
			{fontliste[i2++]=0; fontliste_zaehler++;}
		 if(i2>=MAXFONTLISTE)
			{printf("zu viele Fonts fuer fontliste\n"); break;}
		}
	 docfortsetzsuch=1; docsuch=0;
	}/* endif("%%DocumentFonts:" gefunden) */
     else if(*s3==0) /* "%%+" gefunden */
	{while(c==' ' || c=='\t')  c=getc(fp);
	 for(; c!='\n' && c!=EOF;)
		{fontliste[i2++]=c;
		 c=getc(fp);
		 if(c==' ' || c=='\t')
			{fontliste[i2++]=0; fontliste_zaehler++;
			 while((c=getc(fp))==' ' || c=='\t')  ;
			}
		 if(c=='\n' || c==EOF)
			{fontliste[i2++]=0; fontliste_zaehler++;}
		 if(i2>=MAXFONTLISTE)
			{printf("zu viele Fonts fuer fontliste\n"); break;}
		}
	}
     else
	{docfortsetzsuch=0;
	 if(boundsuch==0 && docsuch==0) return retwert;
	}
    }/* endif(Prozentzeichen am Zeilenanfang) */
   else
    {while(c!='\n' && c!=EOF)  c=getc(fp);
     docfortsetzsuch=0;
    }
  }
 return retwert;
}

/*********************** Flchen fllen: Schraffiermethode **********************/
void FPL6(FILE *fp,char *str)
{
 fprintf(fp,str);
 char *s=new char[strlen(str)+1], *p1,*p2;
 int c;
 for(p1=str,p2=s;(c= *p1++);)
	{if(c=='%') {while((c= *p1++) && c!='\n') ;}//Kommentare berlesen
	 *p2++ = c;
	}
 *p2=c;
 exec_str(s);
 delete s;
}

void defSchraffieren()
{
 FILE *fp=fopen_prolog();
 FPL6(fp,"/schraffieren\t%% x1 y1 x2 y2 dicke abst strich schraffieren --> -\n\
{clip newpath /wurzel2 1.414213562 def\n\
 /me exch def		%%Methode\n\
 /strich exch def	%%Strichelung\n\
 /dx exch wurzel2 mul def %%Linienabstand\n\
 setlinewidth		%%Liniendicke\n\
 /y2 exch def /x2 exch def /y1 exch def /x1 exch def\n\
 /deltax x2 x1 sub def  /deltay y2 y1 sub def\n\
 1 1 2 %%Methode 1 bis 2\n\
 {me and 0 ne %%Methode gewaehlt?\n\
  {0 1  deltax dx div cvi\n\
	{dx mul /i exch def   x1 i add y1 moveto\n\
	 strich i wurzel2 div setdash\n\
	 x2 y1 deltax add i sub\n\
	 dup y2 gt {pop pop x1 i deltay add add y2} if\n\
	 lineto stroke\n\
	} for\n\
   1 1  deltay dx div cvi\n\
	{dx mul /i exch def   x1 y1 i add moveto\n\
	 strich i wurzel2 div setdash\n\
	 y2 x1 deltay add i sub\n\
	 dup x2 gt {pop pop y1 deltax i add add x2} if\n\
	 exch lineto stroke\n\
	} for\n\
  } if\n\
  x1 x2 add 0 translate -1 1 scale\n\
 } for\n\
} def\n");
 defSchraffierenflag=1;
 fclose(fp);
}

void schraffieren(FILE *fp)
{
 if(fuellmethode==FUELL_GRAU)
 {fprintf(fp,"gsave 0.5 setgray fill grestore stroke\n");
 }
 else
 {if(defSchraffierenflag==0) defSchraffieren();
  fprintf(fp,"gsave\n%lg %lg %lg %lg  %%Boundingbox der Figur\n",px2,py2,px3,py3);
  fprintf(fp,"1 10	%%Liniendicke, Linienabstand der Schraffur\n");
  if(fuellmethode & FUELL_PUNKTIERT)
      fprintf(fp,"1 setlinecap [0 10] %%[10 5]=gestrichelt  []=ausgezogen\n");
  else fprintf(fp,"[]	%%[10 5]=gestrichelt  1 setlinecap [0 10]=punktiert\n");
  fprintf(fp,"%d	%%Methode: 1 2 oder 3\n",fuellmethode&FUELL_MASKE);
  fprintf(fp,"schraffieren grestore stroke\n");
 }
}
