/* vmal2.c	2.Teil von VectMal		letzte Aenderung: 8.5.1996

@ link VectMal,vmal1,vmal2,vectmal_hard,vectmal_fonts,SYS$INPUT/OPT
sys$share:decw$dwtlibshr/share
;> blink VectMal,vmal1,vmal2,vectmal_hard,vectmal_fonts
*/

#include "vectmal.h"
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "vtimeb.h"
#include <stdarg.h>

/* Vordeklarationen von C2CPP erzeugt: */
int istdrin2(char* str,int a,int b);
int basiszahl(char* str);
int deltazeit(int flag);
int ausdrucken(char* name);
int printusertime(char* str);
/* Ende der Vordeklarationen von C2CPP */
void printf_system(char *str,char *p1);
void warten();
void file_load(int frageflag);
void file_save(int frageflag);
void clear_bild();
void postscript(char *fname,int flag,int bboxflag);

extern NAMEN BILDNAME,HILFSNAME,UNDONAME,UNDONAME2;
extern FILE *fptemp;
extern double x1fenster,y1fenster,x2fenster,y2fenster,x0fenster;
extern int undo_nline, hochformat;

/********************* file_plot *************************/
extern int savedflag;
extern char filename[];
static NAMEN	TEMPSAVENAME="vectmalplot.tmp",
		DEL_TEMPSAVENAME="DEL vectmalplot.tmp;*";

int plot_ok()
{
 FILE *fp;
 if(!savedflag)
	{strcpy(filename,TEMPSAVENAME); file_save(0); savedflag=0; return 2;}
 if((fp=fopen2(filename,"r"))==NULL) return 0;
 fclose(fp);
 return 1;
}
void file_plot()
{
 int ok;
 Fenstertitel(VECTMAL_WORKING);
 if(ok=plot_ok())
  {printf_system("EPS -S %s",filename); if(ok==2) system(DEL_TEMPSAVENAME);}
 Fenstertitel(VECTMAL_READY);
}
void file_plot2()
{
 int ok;
 if(ok=plot_ok())
  {printf_system("EPS -SF %s",filename); if(ok==2) system(DEL_TEMPSAVENAME);}
}
void printf_system(char *str,char *p1)
{
 static char strsys[120];
 sprintf(strsys,str,p1);
/* if(str[0]!=' ')*/ printf("%s\n",strsys);
 system(strsys);
}

/******************* rgb2hsb **********************/
void rgb2hsb(int r,int g,int b,double *hu,double *sa,double *br)
{
 int y1,min,max,r1,g1,b1,sum1;
 min=(r<g)?r:g; if(b<min) min=b;
 max=(r>g)?r:g; if(b>max) max=b;
 y1=(r+g+b)/3;
 *br=max/255.;
 if(max==0) *sa=0.; else *sa=(max-min)/max;
 r1=r-min; g1=g-min; b1=b-min; sum1=r1+g1+b1;
 if(sum1==0) *hu=0.;
 else if(r1==0) *hu=(g1+b1*2)/3./sum1;
 else if(g1==0) *hu=(b1*2+r1*3)/3./sum1;
 else *hu=g1/3./sum1;
 if(*hu>=1.0) *hu=0.;
 return;
}

/********************** io *************************/
void meldung(char *s)
{
 meldungrequester(s);
/* lower_window(); printf(s); warten(); raise_window(); */
}

void input(char *s1,char *s2,long p)
{
 lower_window();
 printf(s1); scanf(s2,p);
 raise_window();
}
void input2(char *s1,char *str,int lim)
{
 lower_window();
 printf(s1); getline2(stdin,str,lim);
 raise_window();
}

void input3(int npri,int nsca,char *s1,...)
{
 va_list ap;
 char *s2;
 int i;
 long p[5];
 va_start(ap,s1);
 printf(s1,p[0],p[1],p[2],p[3],p[4]);
 for(i=0;i<npri;i++) p[i]=va_arg(ap,long);
 s2=va_arg(ap,char*);
 for(i=0;i<nsca;i++) p[i]=va_arg(ap,long);
 scanf(s2,p[0],p[1],p[2],p[3],p[4]);
 va_end(ap);
}

/******************* kleinkram **********************/
int intrund(int x,int y) /* Wert x auf einen durch y teilbaren Wert runden */
{
 if(x>=0) return ((x+(y>>1))/y)*y;
 return ((x-(y>>1))/y)*y;
}

double doubrund(double x,double y) /* wie intrund() aber mit double-Zahlen */
{
 if(x>=0.) return ((int)((x+y/2.)/y))*y;
 return ((int)((x-y/2.)/y))*y;
}

void stradd(char* s,char* t,char* z) /*  z = s + t  */
{char c;
 while (c = *s++) *z++ = c;
 while (*z++ = *t++)    ;
}

int ascitodigit(int c) /* wandelt ein ASCI-Zeichen in eine 1-stellige Hex-Zahl */
{
 if(!isxdigit(c)) return 0;
 c=toupper(c)-'0';
 if(c>9) c += '0'-'A'+10;
 return c;
}

int istdrin2(char* str,int a,int b)
		/* Sucht die Zeichen a und b im String. Das Zeichen das */
{		/* zuerst gefunden wird, wird zurueckgegeben.           */
 int c;
 while((c= *str++) && c!=a && c!=b)  ;
 return c;
}

int basiszahl(char* str) /* liest Zahlen der Form 'basis#zahl'  Beisp.: 16#12ab */
{
 int c,basis,x=0;
 basis= *str++ - '0';
 while((c= *str++)!='#') basis=10*basis+c-'0';
 while(c= *str++)
	{x *= basis;
	 if(c>='0' && c<='9') x+=c-'0';
	 else if(c>='A' && c<='Z') x+=c-'A'+10;
	 else if(c>='a' && c<='z') x+=c-'a'+10;
	 else break;
	}
 return x;
}

#ifndef __STDC__
index(char *s1,char *s2)  /* Sucht den String s2 innerhalb von s1 und  */
{			  /* gibt die Position zurueck (nicht gefunden = -1) */
 int i,c;
 char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}
#endif

int getline(FILE* fp,char* s,int lim)
			/* liest eine Textzeile oder maximal lim Zeichen */
			/* und ersetzt den Zeilentrenner durch 0         */
{int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

static char ungetline_buffer[BBUF];
static int  ungetline_flag=0;
int getlineb(FILE* fp,char* s) /* getline mit unget-Buffer */
{
 int n;
 if(n=ungetline_flag) {strcpy(s,ungetline_buffer); ungetline_flag=0;}
 else	{n=getline(fp,s,BBUF);}
 return n;
}
void ungetlineb(FILE* fp,char* s)
{
 strcpy(ungetline_buffer,s);
 ungetline_flag=1;
}

int getline2(FILE* fp,char* s,int lim)
			/* liest eine Textzeile oder maximal lim Zeichen */
			/* und ersetzt den Zeilentrenner durch 0         */
{int c,i;
 for(i=0,c=getc(fp); isspace(c) && i<1;) if((c=getc(fp))=='\n') i++;
 ungetc(c,fp);
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void getzeile(FILE* fp,char* s)
		/* liest Zeile samt Zeilentrenner und schliesst mit 0 ab */
{
 while ((*s++ = getc(fp)) != '\n')
	;
 *s=0;
}

int deltazeit(int flag)
{
 static long milli0=0;
 long milli;
 timeb_t zeit;
 ftime(&zeit);
 milli=zeit.time*1000+zeit.millitm;
 if(flag) milli0=milli;
 return milli-milli0;
}

/*
double xhochn(double x,int n)	/* Potenzieren mit Ganzzahligem Exponenten *
{
 double z=1.0;
 if(n>=0)
   while(n>0)
        {if(n&1) {z*=x; n--;}
         else    {x*=x; n=(n>>1);}
        }
 else
        z=1.0/xhochn(x,-n);
 return z;
}
*/

/*** Testfunktionen: ***/
int ausdrucken(char* name)
{
 FILE *fp;
 int c;
 fp=fopen2(name,"r");
 while((c=getc(fp))!=EOF) putc(c,stdout);
 fclose(fp);
 return 0;
}

int printusertime(char* str)
{
 static int milli1=0,milli2=0;
 timeb_t zeit;
 ftime(&zeit);
 milli1=milli2; milli2=zeit.time*1000+zeit.millitm;
 printf("%d %d msec %s\n",milli2,milli2-milli1,str);
 return 0;
}

int printpfad(char* str,struct pfad* pat)
{
 double *z1,x,y;
 int n,flag;
 printf(str);
 for(z1=pat->anfang;z1<pat->ende;)
  {switch(n=(int)(*z1++))
	{case MOVETO:	printf("\tMOVETO"); x= *z1++; y= *z1++; flag=1;
	 CASE LINETO:	printf("\tLINETO"); x= *z1++; y= *z1++; flag=1;
	 CASE CURVETO:  printf("\tCURVETO"); x= *z1++; y= *z1++;
			printf(" %lf %lf",x,y); x= *z1++; y= *z1++;
			printf(" %lf %lf",x,y); x= *z1++; y= *z1++; flag=1;
	 CASE CLOSEPATH: printf("\tCLOSEPATH\n"); flag=0;
	 DEFAULT: printf("\tFehler: n=%d *z=%lf\n",n,*--z1); z1++; flag=0;
	}
   if(flag) printf(" %lf %lf\n",x,y);
  }
 printf("\n");
 return 0;
}

void printdictstack(struct Dictstackeintrag *dictstack)
{
 struct Dictstackeintrag *dse;
 struct dicteintrag *de;
 UBYTE *s,str[20];
 ULONG c;
 int i;
 extern struct {char *next; ULONG k,key; UBYTE *name;} *keytabelle[];
 printf("\nInhalt von dictstack:\n");
 for(dse=dictstack; dse!=NULL; dse=dse->next)
	{printf("dse->next=%08X\n",dse->next);
	 printf("de=dse->dict->e=%08X\n",de=dse->dict->e);
	 printf("dse->dict->leng=%d  dse->dict->i=%d  dse->dict->flags=%08X\n",
		 dse->dict->leng, dse->dict->i, dse->dict->flags);
	 if((c=de->key)&0x80000000) s=keytabelle[c&0xFF]->name;
	 else	{for(i=0;i<=3;i++) {str[i]=c&0xFF; c>>=8;}
		 str[4]=0; s=str;
		}
	 printf("de->key=%08X Name='%s'\n",de->key,s);
	 printf("de->wert.attr=%08X  de->wert.a=%ld de->wert.b=%ld\n",
		 de->wert.attr,de->wert.a,de->wert.b);
	}
}


static int vms_status;
#define CHECK(x) if(((vms_status=(x))&7)!=1) lib$signal(vms_status)

/*
warten1()
{
 long ef2, zeit[2]={-10000000,-1}; /* 1.0 sec *
 sys$clref(ef2);
 CHECK(sys$setimr(ef2,zeit,NULL,0,0));
 sys$waitfr(ef2);
 return;
}
*/

void warten()
{
 timeb_t zeit1,zeit2;
 long endzeit;
 ftime(&zeit1);
 endzeit=zeit1.time*1000+zeit1.millitm + 2500; /* 2.5 Sekunden */
 do ftime(&zeit2);
 while(zeit2.time*1000+zeit2.millitm < endzeit);
}

void millipause(int n)	/* n Millisekunden warten */
{
 timeb_t zeit1,zeit2;
 long endzeit;
 ftime(&zeit1);
 endzeit=zeit1.time*1000+zeit1.millitm + n;
 do ftime(&zeit2);
 while(zeit2.time*1000+zeit2.millitm < endzeit);
}

/* printusertime("postscript_firstinit\n");/* test */

/******************* Brush und Pixelbilder **********************/
#define PLANEMASKE 1L

void brush2pixelbild(char *name)
{
 FILE *fp;
 char erstezeile[ZL],boxstr[80];
 double xul,yul,xor,yor;
 int x1,y1,x2,y2;
 int n;
 screen_save();
 clear_bild();
 Fenstertitel(VECTMAL_WORKING);
 if((fp=fopen1(name,"r"))!=NULL)   /* BoundingBox suchen */
   {getline(fp,erstezeile,ZL);
    if((n=bbox_suchen(fp,"%%BoundingBox:",boxstr,80))>=1)
	 sscanf(boxstr,"%lf %lf %lf %lf",&xul,&yul,&xor,&yor);
    else {xul=yul=0.; xor=PSA4B; yor=PSA4H;}
    fclose(fp);
   }
 dings_start();
 postscript(name,1,0);
 dings_term();
 user2bkoord(xul,yul,&x1,&y1);
 user2bkoord(xor,yor,&x2,&y2);
 DEBUG(1,printf("xul=%lf yul=%lf xor=%lf yor=%lf  x1=%d y1=%d x2=%d y2=%d\n",
		xul,yul,xor,yor,x1,y1,x2,y2));/* test */
 if(x1<0) x1=0;/* provi */
 if(y2<0) y2=0;/* provi */
 if(hochformat)	window2pixelbild(x1,y2,x2-x1,y1-y2);
 else		window2pixelbild(x2,y2,x1-x2,y1-y2);
 screen_restore();
}

void screen_save()
{
 int fe;
 if(fptemp)
	{fclose(fptemp); fe=filecopy(BILDNAME,HILFSNAME);
	 if(fe!=0) printf("Fehler beim kopieren von '%s' nach '%s' fe=%d\n",
						BILDNAME,HILFSNAME,fe);
	 fptemp=fopen1(BILDNAME,"a");
	}
}
void screen_restore()
{
 int n,fe;
 clear_bild();
 rename(UNDONAME,UNDONAME2);
 qinital(1,x0fenster,y1fenster,x2fenster,y2fenster);
 postscript(HILFSNAME,1,0);
 term();
 lineattribute_uebernemen();
 undo_nline= -1;
}

/************************* flattenpath ****************************/
double *flatten_bezier(double *z,double ax,double ay,double bx,double by,
			double cx,double cy,double dx,double dy)
{                                /* Stuetzpunkte A B C D, Pen steht auf A. */
 double abx,aby,bcx,bcy,cdx,cdy,abcx,abcy,bcdx,bcdy,abcdx,abcdy,adx,ady;
 double x2,y2;
 adx=(ax+dx)/2.; ady=(ay+dy)/2.;
 abx=(ax+bx)/2.; aby=(ay+by)/2.;
 bcx=(bx+cx)/2.; bcy=(by+cy)/2.;
 cdx=(cx+dx)/2.; cdy=(cy+dy)/2.;
 abcx=(abx+bcx)/2.; abcy=(aby+bcy)/2.;
 bcdx=(bcx+cdx)/2.; bcdy=(bcy+cdy)/2.;
 abcdx=(abcx+bcdx)/2.; abcdy=(abcy+bcdy)/2.;
 x2=abcdx-adx; y2=abcdy-ady;
 if(x2*x2+y2*y2<=gs.flatness*gs.flatness) return z;/*durch Gerade approxim.*/
 z=flatten_bezier(z,ax,ay,abx,aby,abcx,abcy,abcdx,abcdy);
 *z++ = LINETO; *z++ = abcdx; *z++ = abcdy;
 z=flatten_bezier(z,abcdx,abcdy,bcdx,bcdy,cdx,cdy,dx,dy);
 return z;
}

int flatten(pfad *pat,pfad *gspat)
{
 double *z,*z2, x,y,x0=0.,y0=0.,x1,y1,x2,y2,x3,y3;
 int n,pen;
 if(gspat->ende==gspat->anfang) return NOPATH;
 for(z=gspat->anfang,z2=pat->anfang;z<gspat->ende;)
   {if(z2 >= &pat->anfang[MAXPATH3-7]) return LIMITCHECK;
    switch(n=(int)(*z++))
        {case MOVETO:	 pen=MOVETO; x0=x= *z++; y0=y= *z++; break;
         case LINETO:	 pen=LINETO; x= *z++; y= *z++; break;
         case CLOSEPATH: pen=LINETO; x=x0; y=y0; break;
         case CURVETO:   pen=LINETO; x2= *z++; y2= *z++; x3= *z++; y3= *z++;
                         x= *z++; y= *z++;
			 z2=flatten_bezier(z2,x1,y1,x2,y2,x3,y3,x,y);
                         break;
         default: printf("ERROR in flatten():n=%d *z=%lf\n",n,*z);
		  return PATH_CORRUPT;
        }
    *z2++ =pen; *z2++ =x; *z2++ =y;
    x1=x; y1=y;
   }
 pat->ende=z2;
 return 0;
}
