#ifndef VTIMEB_H
#define VTIMEB_H

#ifdef MACOSX
#define unix
#endif

#ifdef VAXORALPHA
#include <file.h>
#ifndef __STDC__
#include <unixio.h>
#else
#include <timeb.h>
#endif
#include <time.h>
#define TIME_T
#define TM_T
#define TIMEB_T
#define FTIME_T
#endif /*VAXORALPHA*/

#ifdef unix
//--- Unterscheidung verschiedener unix-varianten ---
#ifdef IBM_AIX_UNIX
#include <time.h>
#define TIME_T
#define TM_T
#endif

#ifdef DEC_Alpha_UNIX
#include <sys/time.h>
#define TIME_T
#define TM_T
#define GMTIME_C
#endif

#ifdef linux
#include <sys/time.h>
#define TIME_T
#define TM_T
#define GMTIME_C
#endif

#ifdef MACOSX
#include <sys/time.h>
#define TIME_T
#define TM_T
#define GMTIME_C
//struct timeval {time_t tv_sec; int tv_usec;};
//struct timezone {int tz_minuteswest,tz_dsttime;};
#endif
//--- ende aller unix-varianten ---
#endif /*unix*/

#ifdef AMIGA
#include <sys/time.h>
#define TIME_T
#define TM_T
#define GMTIME_C
#endif /*AMIGA*/

#ifndef TIME_T /* ev. schon in <timeb.h> definiert */
typedef long time_t;
#endif

#ifndef TIMEB_T
struct timeb
        {time_t          time;
         unsigned short  millitm;
         short           timezone;
         short           dstflag;
        };
typedef struct timeb timeb_t;
#endif

#ifndef TM_T /* sollte schon in <time.h> definiert sein */
struct tm
        {int     tm_sec, tm_min, tm_hour;
         int     tm_mday, tm_mon, tm_year;
         int     tm_wday, tm_yday, tm_isdst;
        };
typedef struct tm tm_t;
#endif

#ifndef FTIME_T
int ftime(timeb_t*);
#endif

#endif /*VTIMEB_H*/
