/* vektar.cc			letzte nderung: 4.9.2008 */
#define VERSION "Version 0.7"

/*
 Kurzbeschreibung: Vektor Taschenrechner

History:
13.12.1999	Erstellung (RPf)
16.9.2002       Anpassung an Mac
27.11.2002	Anpassung an neuen Compiler (GCC3.2)
22.3.2004	in wfont neues HY nur setzen wenn h2 im Bereich
                Schrift grsser gemacht (BX...HY2)
2.9.2008	Bessere Anpassung der Schriftgroessen

*/
//#define TEST

#ifndef GCC_VERSION
#define GCC_VERSION (__GNUC__ * 1000 + __GNUC_MINOR__)
#endif

#include <stdio.h>
#if GCC_VERSION>=3000
#include <iostream>
using namespace std;
#else
#include <stream.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <xtekplot1.h>

//(3.9.08) Vermeidung von Konflikten mit anderweitig definiertem abs:
#define abs meinabs

#include "vektorklasse.cc"
#include "vektor3dklasse.cc"

//#ifndef linux
#define FEHLERABFANG
#include <signal.h>
//#endif

static int XMAX=520, BX=10, BX2=8, // XMAX=480, BX=8, BX2=7,
           YMAX=500, HY=18, HY2=16, // YMAX=320, HY=12 oder 14, HY2=10,
           TIEFE=4;
const int SCHWARZ=0,WEISS=1,ROT=2,GRUEN=3,BLAU=4,GOLDGELB=5,
          HELLGRAU=6,GRAU=7,DUNKELGRAU=8,HELLBLAU=9,DUNKELBLAU=10;
//const double GRAD=atan(1.0)*4/180;  schon in vektorklasse definiert

#define FPF fprintf
#define FSF fscanf
#define INDEX(s1,s2) s_index(s1,strlen(s1),s2,1)

/************************* Vordeklarationen ***************************/
void mauspre();

/************************* //test ***************************/
typedef void (*ZF)();
extern ZF set_new_handler(ZF);

void speicher_ueberlauf()
{
 cerr << "Fehler bei new: Speicherueberlauf\n";
}

#ifdef FEHLERABFANG
void fehler(int n)
{
 printf("Warning %d: Floating overflow\n",n);
}
#endif

/**************************** Kleinkram *******************************/
inline bool ist(char*t,char*s) {return strcmp(t,s)==0;}
inline int idfix(double x) {return x<0?int(x-0.5):int(x+0.5);}
inline double abs(double x) {return x<0?-x:x;}

/** dieses Problem sollte durch meinabs weiter oben geloest sein (3.9.08)
#if GCC_VERSION>=3000
//double abs(double) schon in <math.h> definiert
#else
double abs(double x) {return x<0?-x:x;}
#endif
**/

void wfont(int n)
{
 int b,h,h2;
 switch(n)
   {case 1: b=BX; h=HY;
    CASE 2: b=BX2; h=HY2;
   }
// Zum Austesten in main() tek_setdebug(2); setzen
 h2=itextsize(b,h,"*-r-normal*");
 if(h2>1.5*h || h2<0.75*h) h2=itextsize(b,h,"*-r-*");
 if(h2>1.5*h || h2<0.75*h) h2=itextsize(b,h);
 //if(h2<1.5*h && h2>0.75*h) switch(n) //so werden die Buchstaben zu klein
 if(h2<1.5*h && h2>=h) switch(n) //(3.9.08)
   {case 1: HY=h2;
    CASE 2: HY2=h2;
   }
#ifdef TEST
 printf("wfont(%d)\n",n);
 printf("h2=itextsize(b=%d,h=%d) --> h2=%d\n",b,h,h2);
#endif
}

void wprintf3(int f1,int f2,double x,double y,char *cstr,int p1=0,int p2=0)
{
 char str[80];
 sprintf(str,cstr,p1,p2);
 if(f1>=0) {color(f1); fillbox(x,y-1,x+BX*strlen(str),y+HY*1.4);}
 if(f2>=0) color(f2);
 schrift(x,y,str);
}
void wprintf2(double x,double y,char *cstr,int p1=0,int p2=0)
{
 wprintf3(0,1,x,y,cstr,p1,p2);
}
void wprintf1(int f1,double x,double y,char *cstr,int p1=0,int p2=0)
{
 wprintf3(-1,f1,x,y,cstr,p1,p2);
}
void wprintf(double x,double y,char *cstr,int p1=0,int p2=0)
{
 wprintf3(-1,-1,x,y,cstr,p1,p2);
}

void wprintf3(int f1,int f2,double x,double y,char *cstr,double p1)
{
 char str[80];
 sprintf(str,cstr,p1);
 if(f1>=0) {color(f1); fillbox(x,y-1,x+BX*strlen(str),y+HY*1.4);}
 if(f2>=0) color(f2);
 schrift(x,y,str);
}
void wprintf3(int f1,int f2,double x,double y,char *cs1,char *cs2,double p1)
{
 double a=abs(p1);
 if(a!=0.0 && (a<0.1 || a>=1e6)) wprintf3(f1,f2,x,y,cs2,p1);
 else wprintf3(f1,f2,x,y,cs1,p1);
}
void wprintf3(int f1,int f2,double x,double y,char *cs,char *p1,char *p2=NULL)
{
 char str[80];
 sprintf(str,cs,p1,p2);
 if(f1>=0) {color(f1); fillbox(x,y-1,x+BX*strlen(str),y+HY*1.4);}
 if(f2>=0) color(f2);
 schrift(x,y,str);
}

void wprintf3(int f1,int f2,double x,double y,char *cs,
	      int p0,double p1,double p2,double p3)
{
 char str[80];
 sprintf(str,cs,p0,p1,p2,p3);
 if(f1>=0) {color(f1); fillbox(x,y-1,x+BX*strlen(str),y+HY*1.4);}
 if(f2>=0) color(f2);
 schrift(x,y,str);
}

void linie(double x1,double y1,double x2,double y2)
{
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN);
}

void minus_entfernen(char *s)
{
 char *t= &s[1];
 while(*s++ = *t++) ;
}
void minus_einfuegen(char *s)
{
 char c='-',c2;
 while(c)
   {c2= *s; *s++ = c; c=c2;}
 *s=0;
}

int getc_alpha(FILE *fp)
{
 int c;
 while((c=getc(fp))!=EOF && c<'A')  ;
 return c;
}

int s_index(char *s1,int n1,char *s2,int n2)
			/* Sucht den String s2 innerhalb von s1 und  */
{			/* gibt die Position zurueck (nicht gefunden = -1) */
 int i,c,j;
 char *p1,*p2;
 if(n2<=0) return 0;	/* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if(i>=n1) return -1; /* nicht gefunden */
	 c= *s1++;
	 if(c== *s2)
		{for(p1=s1,p2=s2,j=1; j<n2; j++)
			{c= *++p2;
			 if(*p1++!=c) break; /* noch nicht gefunden */
			}
		 if(j==n2) break; /* gefunden */
		}
	}
 return i;
}

/************************* Fehlermeldungen ****************************/
class Fehlermeldung
{
 double x0,y0,x2,y2;
public:
 int errflag;
 Fehlermeldung() {errflag=0; x0=y0=0; x2=XMAX; y2=1.5*HY2;}
 void error(char *s,int p1=0,int p2=0);
 void say(char *s,char *p1=NULL,char *p2=NULL);
 void clear() {color(0); fillbox(x0,y0,x2,y2); wfont(1);}
};

void Fehlermeldung::error(char *s,int p1,int p2)
{
// inital_new();
 clear();
 wprintf3(SCHWARZ,ROT,2*BX,0.25*HY,s,p1,p2);
 if(*s!=' ') errflag=1; else errflag=0;
// term_refresh();
}
void Fehlermeldung::say(char *s,char *p1,char *p2)
{
 clear();
 wprintf3(SCHWARZ,WEISS,2*BX,0.25*HY,s,p1,p2);
 errflag=0;
}

/************************ Globale Variablen ***************************/
const int TYP_SHIFT=1,TYP_GOLD=2,TYP_NORMAL=0;

const int VEKTOR=0,COMPLEX=1,
          RADIAN=0,DEGREE=1;

static int exitflag=0;
static Fehlermeldung meldung;
static Vektor3d regist[10];
//static Statusfeld *statusfeld;

/***************************** Klassen ********************************/
const int STAPELSIZE=4;

class Stapel
{
 Vektor3d *mem;
 int imax,i;
public:
  Stapel(int n=STAPELSIZE);
 ~Stapel() {delete mem;}
 void push(Vektor3d a);
 Vektor3d pop();
 Vektor3d rol(bool);
 Vektor3d get(int j);
 void set(int j,Vektor3d a) {if(j>=imax) j=imax-1; mem[j]=a;}
  //test void set(int j,double* xyz)
  //	{Vektor3d a(xyz[0],xyz[1],xyz[2]); if(j>=imax) j=imax-1; mem[j]=a;}
};

class Settings
{
 FILE *fp;
public:
 char filename[200];
 double winkel,kuerz;
 int winkeleinheit;
 bool autosave;
 Settings() {sprintf(filename,"%s/.vektarsettings",getenv("HOME"));
             winkel=45*GRAD; kuerz=0.7; winkeleinheit=RADIAN;
             autosave=true; fp=NULL;
            }
 void save(Stapel *ps);
 void load(Stapel *ps);
};
void Settings::load(Stapel *ps)
{
 char kw[80];
 int c,i;
 Vektor3d v;
 if(!(fp=fopen(filename,"r"))) return;
 while((c=getc_alpha(fp))!=EOF)
  {ungetc(c,fp);
   FSF(fp,"%s",kw); if((c=INDEX(kw,"="))>=0) kw[c]=0;
#ifdef TEST
   printf("keyword='%s'\n",kw);
#endif
   if(strcmp(kw,"winkeleinheit")==0) FSF(fp,"%d",&winkeleinheit);
   else if(strcmp(kw,"winkel")==0)
	{FSF(fp,"%lf",&winkel); if(winkeleinheit==DEGREE) winkel*=GRAD;}
   else if(strcmp(kw,"kuerz")==0) FSF(fp,"%lf",&kuerz);
   else if(strcmp(kw,"autosave")==0) FSF(fp,"%d",&autosave);
   else if(strncmp(kw,"regist",6)==0 && (i=kw[6]-'0')>=0 && i<=9)
	{while((c=getc(fp))!=EOF && c!='[')  ;// [ berlesen
	 FSF(fp,"%lf %lf %lf",&v.x,&v.y,&v.z); regist[i]=v;
	 while((c=getc(fp))!=EOF && c!=']')  ;// ] berlesen
	}
   else if(strncmp(kw,"stapel",6)==0 && (i=kw[6]-'0')>=0 && i<=9)
	{while((c=getc(fp))!=EOF && c!='[')  ;// [ berlesen
	 FSF(fp,"%lf %lf %lf",&v.x,&v.y,&v.z); ps->set(i,v);
	 while((c=getc(fp))!=EOF && c!=']')  ;// ] berlesen
	}
   else printf("'%s' enthlt unbekanntes Schlsselwort:'%s'\n",filename,kw);
  }
 fclose(fp);
}
void Settings::save(Stapel *ps)
{
 Vektor3d v;
 if(!(fp=fopen(filename,"w")))
   {printf("cant create '%s'\n",filename); return;}
 FPF(fp,"winkeleinheit= %d\n",winkeleinheit);
 if(winkeleinheit==DEGREE)
   FPF(fp,"winkel= %.3lf  kuerz= %lf\n",winkel/GRAD,kuerz);
 else
   FPF(fp,"winkel= %.9lf  kuerz= %lf\n",winkel,kuerz);
 for(int i=0;i<10;i++)
   {if(abs(v=regist[i])!=0)
     FPF(fp,"regist%d= [ %.12lg  %.12lg  %.12lg ]\n",i,v.x,v.y,v.z);
   }
 for(int i=0;i<4;i++)
   {v=ps->get(i);
    FPF(fp,"stapel%d= [ %.12lg  %.12lg  %.12lg ]\n",i,v.x,v.y,v.z);
   }
 FPF(fp,"autosave= %d\n",autosave);
 fclose(fp);
}
static Settings settings;

Stapel::Stapel(int n)
{
 imax=n; mem=new Vektor3d[n];
 for(i=0;i<n;i++) mem[i]=0;
}
Vektor3d Stapel::get(int j)
{
 if(j>=imax) j=imax-1;  return mem[j];
}

void Stapel::push(Vektor3d a)
{
 for(i=imax-1;i>0;i--) mem[i]=mem[i-1];
 mem[0]=a;
}
Vektor3d Stapel::pop()
{
 Vektor3d a=mem[0];
 for(i=1;i<imax;i++) mem[i-1]=mem[i];
 return a;
}
Vektor3d Stapel::rol(bool rev)
{
 Vektor3d a;
 if(rev)
   {for(a=mem[i=imax-1]; i>0; i--)  mem[i]=mem[i-1];
    mem[0]=a;
   }
 else
   {a=mem[0];
    for(i=1;i<imax;i++) mem[i-1]=mem[i];
    mem[imax-1]=a;
   }
 return a;
}

class Eingabefeld
{
 bool aktiv,reop;
 char str[40];
 int cursor,nx;
 double x1,y1,dx;
 Stapel *ps;
public:
 bool help;
 Eingabefeld() {aktiv=reop=help=0; nx=0;}
 void init(double x,double y,double d,Stapel *p) {x1=x; y1=y; dx=d; ps=p;}
 void open(int n) {nx=n; str[cursor=0]=0; aktiv=true; reop=0;}
 void reopen(int n);
 void write(int c);
 double close();
 void draw();
};
void Eingabefeld::reopen(int n)
{
 Vektor3d v;
 if(aktiv) close();
 nx=n;
 v=ps->get(0);
 sprintf(str,"%lg",v[nx]);
 cursor=strlen(str);
 if(ist(str,"0")) str[cursor=0]=0;
 aktiv=reop=true;
}
double Eingabefeld::close()
{
 double x;
 Vektor3d v;
 v=ps->get(0);
 if(reop)
   {x=v[nx]; reop=0;}
 else
   {if(*str==0) x=0; else sscanf(str,"%lf",&x);
    v[nx]=x; ps->set(0,v);
   }
 aktiv=0;
 return x;
}
void Eingabefeld::write(int c)
{
 static int emi=0;
 if(!aktiv) open(nx);
 reop=0;
 if(c=='\b')
   {if(cursor==0) return;//Feld leer
    str[--cursor]=0;
    return;
   }
 if(cursor>=sizeof(str)-1) return;//Feld voll
 if(c=='-')
   {int i;
    for(i=cursor;i>0 && str[--i]!='+';)
      {if(str[i]=='e' && (emi=1-emi)==1) {i++; break;}
      }
    if(str[i]=='+') str[i]='-';
    else if(str[i]=='-') {minus_entfernen(&str[i]); --cursor;}
    else {minus_einfuegen(&str[i]); ++cursor;}
    return;
   }
 if(c=='e' && cursor==0) str[cursor++]='1';
 str[cursor++]=c;
 str[cursor]=0;
}
void Eingabefeld::draw()
{
 if(aktiv)
   {
    wprintf3(HELLGRAU,SCHWARZ,x1+nx*dx,y1,"%13s",str);
   }
}

class Taste
{
 char *text,*textn,*textb,*textg,*textgb;
 int x1,y1,x2,y2,breite,hoehe,farbe,typ,select;
public:
 Taste() {x1=x2=0; farbe=GRAU; typ=TYP_NORMAL; select=0;}
 void set(char*t1,char*t2,char*t3,char*t4,int x,int y,int b,int h,int t)
	{text=textn=t1;textb=t2;textg=t3;textgb=t4; x1=x;y1=y;
	 breite=b;hoehe=h; x2=x+b;y2=y+h; typ=t;
	}
 void setfarbe(int f) {farbe=f;}
 void draw();
 void drawselect(bool help);
 int press(Eingabefeld*,Stapel*);
 bool check(int x,int y) {return x>=x1 && x<=x2 && y>=y1 && y<=y2;}
 void shift(int i) {text = i==0?textn:(i==1?textb:(i==2?textg:textgb));}
};
void Taste::drawselect(bool help)
{
 color(BLAU); drawbox(x1,y1,x2,y2);
 if(typ>TYP_NORMAL && !help) select=1-select;
 color(1);
}
void Taste::draw()
{
 if(x1==x2) {meldung.error("undefinierte Taste"); return;}
 double xm=(x1+x2)/2.0, ym=(y1+y2)/2.0;
 color(farbe); fillbox(x1,y1,x2,y2);
 if(select) color(BLAU); else color(WEISS);
 drawbox(x1,y1,x2,y2);
 int textbreite=strlen(text)*BX;
 wprintf((x1+x2-textbreite)/2,(y1+y2-HY)/2,text);
}

//Die Tasten "Help", "Blue" und "Gold" muessen bei allen Tastenbelegungen
//an der gleichen Position sein, die andern Tasten koennen beliebig
//angeordnet werden.

static char *tastenname[]=
 {"Help","RAD","RCL","STO","+/-","0",".","ENTR",
  "Pi","TAN","SQRT","x<>y","1","2","3","Graph",
  " 1/x","COS","LN","LOG","4","5","6","+",
  "|x|","SIN","y^x","-->|","7","8","9","-",
  "Blue","POP","ROLv","CORR","Gold","EXP","/","*"
 };
static char *tastenname_blue[]=
 {"Help","RAD","RCLx","STOx","+/-","0",".","ENTR",
  " e","ATAN","x^2","x<>y","1","2","3","Graph",
  " 1/x","ACOS","e^x"," 10^x","4","5","6","+",
  "|x|","ASIN","y^1/x","|<--","7","8","9","-",
  "Blue","POP","ROL^","CORR","Gold","EXP","/","x"
 };
static char *tastenname_gold[]=
 {"Help","ALFA","RCL","STO","+/-","0",".","ENTR",
  "EHV","XROT","POLAR","x<>y","1","2","3","Graph",
  "CPLX","YROT","yzROT","LOG","4","5","6","+",
  "|xxx|","ZROT","yROT","-->|","7","8","9","-",
  "Blue","POP","ROL<-","CORR","Gold","EXP","/","*"
 };
static char *tastenname_goldblue[]=
 {"Help","ALFA","RCLx","STOx","+/-","0",".","ENTR",
  "EHV","-XROT","RALOP","x<>y","1","2","3","Graph",
  "CPLX","-YROT","-yzROT"," 10^x","4","5","6","+",
  "|xxx|","-ZROT","-yROT","|<--","7","8","9","-",
  "Blue","POP","ROL->","CORR","Gold","EXP","/","x"
 };
static char *tasten_hilfe[]=
 {"ALFA","berechnet Winkel zwischen x und y",
  "RAD",
    "Umschaltung zwischen GRAD und RAD fuer Winkelberechnungen (180GRAD==Pi)",
  "Pi","Eulersche Kreiszahl 3.14159265...",
  " e","Basis des natuerlichen Logarithmus 2.71828...",
  "SQRT","Wurzel",
  " 1/x","Kehrwert",
  "SIN","sin(x)  Sinus",
  "COS","cos(x)  Cosinus",
  "TAN","tan(x)  Tangens",
  "ASIN","arcsin(x)  Umkehrfunktion zu Sinus",
  "ACOS","arccos(x)  Umkehrfunktion zu Cosinus",
  "ATAN","arctan(x)  Umkehrfunktion zu Tangens",
  "LN","ln(x)  Natuerlicher Logarithmus",
  "LOG","log(x)  ZehnerLogarithmus",
  "-->|","Tabulator",
  "|<--","Rueckwaerts-Tabulator",
  "POP","x wird geloescht, das oberste Stapelelement dubliziert",
  "ROLv","der Stapel wird rotiert",
  "ROL^","der Stapel wird nach oben rotiert",
  "ROL->","x.X --> x.Y --> x.Z  rotieren",
  "ROL<-","x.X <-- x.Y <-- x.Z  rotieren",
  "RCL","Register 0 wird gelesen",
  "STO","x wird in Register 0 gespeichert",
  "RCLx","Register x wird gelesen, x muss zwischen 0 und 9 sein",
  "STOx","y wird in Register x gespeichert, x muss zwischen 0 und 9 sein",
  "+/-","Vorzeichen wechseln",
  ".","Dezimalpunkt",
  "EHV","Einheitsvektor erzeugen, Richtung bleibt gleich, Betrag wird 1",
  "x^2","x quadrieren",
  "x<>y","x und y vertauschen",
  "|x|","Betrag von x",
  "-","y-x --> x",
  "Blue","Umschaltung auf andere Funktionen, meistens inverse Funktionen",
  "CORR","Zahleneingabe korrigieren",
  "Gold","Umschaltung auf weitere Funktionen",
  "EXP","Exponent eingeben",
  "x","Vektormultiplikation: y*x --> x",
  "*","einfache Multiplikation:  y.X*x.X y.Y*x.Y  y.Z*x.Z",
  "CPLX","mit Complexen Zahlen rechnen (geht noch nicht)",
  "|xxx|","Betrag von x auf XYZ kopiert",
  "ZROT","Rotiere y um den Winkel |x| um die Z-Achse (im Uhrzeigersinn)",
  "-ZROT","Rotiere y um den Winkel |x| um die Z-Achse im Gegenuhrzeigersinn",
  "YROT","Rotiere y um den Winkel |x| um die Y-Achse",
  "XROT","Rotiere y um den Winkel |x| um die X-Achse",
  "yROT","rotiert z um die durch y gegebene Achse um den Winkel |x|",
  "yzROT","rotiert t um die durch z-y gegebene Achse um den Winkel |x| (noch fehlerhaft)",
  "-YROT","wie YROT aber im Gegenuhrzeigersinn",
  "-XROT","wie XROT aber im Gegenuhrzeigersinn",
  "-yROT","wie yROT aber im Gegenuhrzeigersinn",
  "-yzROT","wie yzROT aber im Gegenuhrzeigersinn",
  "POLAR","Umrechnung von Polarkoordinaten (alfa,phi,Betrag) in XYZ",
  "RALOP","Umrechnung in Polarkoordinaten, X=alfa Y=phi Z=Betrag",
  NULL,NULL
 };

class Tastenfeld
{
 int x0,y0,nreihen,nspalten,tastenbreite,tastenhoehe,abst;
 Taste *tasten;
 int blue;
public:
 Tastenfeld(int x,int y,int nr,int ns,int br,int ho,int ab=2);
 ~Tastenfeld() {delete tasten;}
 int press(int i,Eingabefeld *ef,Stapel *ps);
 int check(int x,int y);
 void release(int i) {inital_new(); tasten[i].draw(); term_refresh();}
 void press(int x,int y);
 void draw();
 void refresh();
};
void Tastenfeld::refresh()
{
 color(GRAU);
 fillbox(x0,y0,x0+abst+nspalten*(tastenbreite+abst),
	 y0+abst+nreihen*(tastenhoehe+abst));
 color(1);
 draw();
}
void Tastenfeld::draw()
{
 for(int i=0;i<nreihen*nspalten;i++)
   {tasten[i].shift(blue); tasten[i].draw();}
}
int Tastenfeld::press(int i,Eingabefeld *ef,Stapel *ps)
{
 inital_new();
 int n=tasten[i].press(ef,ps);
 if(n!=blue || ef->help)
   {blue=n; draw();}
 term_refresh();
 return blue;
}
int Tastenfeld::check(int x,int y)
{
 int i,imax=nreihen*nspalten;
 for(i=0;i<imax;i++)
   if(tasten[i].check(x,y))
     {return i;}
 return -1;
}
int gettastennummer(char *txt,int j=0)
{
 int i,n=sizeof(tastenname)/sizeof(char*);
 char **name;
 name = j==0?tastenname:
	(j==1?tastenname_blue:(j==2?tastenname_gold:tastenname_goldblue));
 if(strcmp(txt,"*")==0 && j&1) txt="x";
 for(i=0;i<n;i++)
   {if(strcmp(txt,name[i])==0) return i;
   }
 return -1;
}
int gettastennummer(int c,int j=0)
{
 char s[2]; s[0]=c; s[1]=0;
 return gettastennummer(s,j);
}
Tastenfeld::Tastenfeld(int x,int y,int nr,int ns,int br,int ho,int ab)
{
 Taste *ta;
 int i,j,n,typ;
 char *s,*sb,*sg,*sgb;
 blue=0;
 x0=x; y0=y; nreihen=nr; nspalten=ns;
 tastenbreite=br; tastenhoehe=ho; abst=ab;
 color(GRAU); fillbox(x,y,x+ab+ns*(br+ab),y+ab+nr*(ho+ab)); color(1);
 tasten=new Taste[nr*ns];
 for(ta=tasten,j=0;j<nreihen;j++)
   for(i=0;i<nspalten;i++,ta++)
     {s=tastenname[n=i+j*nspalten];
      sb=tastenname_blue[n];
      sg=tastenname_gold[n];
      sgb=tastenname_goldblue[n];
      if(strcmp(s,"Gold")==0) typ=TYP_GOLD;
      else if(strcmp(s,"Blue")==0) typ=TYP_SHIFT;
      else typ=TYP_NORMAL;
      ta->set(s,sb,sg,sgb,x+ab+(br+ab)*i,y+ab+(ho+ab)*j,br,ho,typ);
      if(typ==TYP_GOLD) ta->setfarbe(GOLDGELB);
      else if(typ==TYP_SHIFT) ta->setfarbe(HELLBLAU);
      ta->draw();
     }
}

class Anzeige
{
 double y0,x1[4];
 Vektor3d vekt;
public:
 void init(Vektor3d a,double y,double x,double dx)
	{vekt=a; y0=y; for(int i=0;i<4;i++) x1[i]=x+i*dx;}
 void draw();
 void draw(Vektor3d v) {vekt=v; draw();}
};
void Anzeige::draw()
{
 for(int i=0;i<4;i++)
   wprintf3(1,0,x1[i],y0,"%13lf","%13le",vekt.get(i));
}

class Anzeigefeld
{
 Anzeige xyzt[4];
 double x1,x2,x3,x4,x00;
 double y1,y2,y3,y4,y00,dy;
 int j,iho,ibr;
 Stapel *ps0;
 void hintergrund();
public:
 Eingabefeld eingabefeld;
 Anzeigefeld(int x0,int y0,int br,int ho,Stapel *ps);
 void draw1(Stapel *ps);
 void draw(Stapel *ps) {inital_new(); draw1(ps); term_refresh();}
 void refresh() {hintergrund(); draw1(ps0);}
};
void Anzeigefeld::draw1(Stapel *ps)
{
 ps0=ps;
 wfont(2);
 for(int i=0;i<4;i++) xyzt[i].draw(ps->get(i));
 eingabefeld.draw();
}
void Anzeigefeld::hintergrund()
{
 int ho=iho,br=ibr; double x0=x00,y0=y00;
 color(1); fillbox(x0,y0,x0+br,y0+ho);
 wfont(2);
 wprintf1(0,x1,y4+dy,"   X");
 wprintf1(0,x2,y4+dy,"   Y");
 wprintf1(0,x3,y4+dy,"   Z");
 wprintf1(0,x4,y4+dy," Betrag");
 wprintf1(0,x0,y1," x:");
 wprintf1(0,x0,y2," y:");
 wprintf1(0,x0,y3," z:");
 wprintf1(0,x0,y4," t:");
 color(HELLGRAU);
 linie(x1,y0,x1,y0+ho);
 linie(x1+1,y0,x1+1,y0+ho);
 linie(x2,y0,x2,y0+ho);
 linie(x3,y0,x3,y0+ho);
 linie(x4,y0,x4,y0+ho);
 linie(x0,y1+1.5*HY,x0+br,y1+1.5*HY);
 linie(x0,y2+1.5*HY,x0+br,y2+1.5*HY);
 linie(x0,y3+1.5*HY,x0+br,y3+1.5*HY);
 linie(x0,y4+1.5*HY,x0+br,y4+1.5*HY);
 linie(x0,y4+1.5*HY+1,x0+br,y4+1.5*HY+1);
}
Anzeigefeld::Anzeigefeld(int x0,int y0,int br,int ho,Stapel *ps)
{
 double dx;
 x00=x0; y00=y0; ibr=br; iho=ho;
 y1=y0+0.25*HY; x1=x0+4*BX2; ps0=ps;
 dy=(YMAX-y0)/5.0; dx=(br-x1)/4.0;
 y2=y1+dy; y3=y1+2*dy; y4=y1+3*dy;
 x2=x1+dx; x3=x1+2*dx; x4=x1+3*dx;
 eingabefeld.init(x1+BX2,y1,dx,ps);
 for(int i=0;i<4;i++) xyzt[i].init(0,y1+i*dy,x1+BX2,dx);
 hintergrund();
 draw1(ps);
 color(1);
 wfont(1);
}

class Statusfeld
{
 int stat[2],max[2];
 char text[80];
 char* statext();
 double y0,x0,y1,x1,hoehe,breite;
public:
 Statusfeld(double x,double y,double xm,double ym);
 int get(int i) {return stat[i];}
// void set(int a,int b) {stat[0]=a; stat[1]=b; draw2();}
 void inc(int i) {if(++stat[i]==max[i]) stat[i]=0; draw1();}
 void draw1();
 void draw() {inital_new(); draw1(); term_refresh();}
 void refresh() {draw1();}
 void save() {settings.winkeleinheit=stat[1];}
};
static Statusfeld *statusfeld;

Vektor3d rad(Vektor3d x)
{
 if(statusfeld->get(1)==DEGREE) x*=GRAD;
 return x;
}
Vektor3d grad(Vektor3d x)
{
 if(statusfeld->get(1)==DEGREE) x/=GRAD;
 return x;
}

double rad(double x)
{
 if(statusfeld->get(1)==DEGREE) x*=GRAD;
 return x;
}
double grad(double x)
{
 if(statusfeld->get(1)==DEGREE) x/=GRAD;
 return x;
}

Statusfeld::Statusfeld(double x,double y,double xm,double ym)
{
 y0=y; x0=x; x1=x0+BX2; y1=y0+0.25*HY2; hoehe=ym-y; breite=xm-x;
 stat[0]=VEKTOR; max[0]=2;
 stat[1]=settings.winkeleinheit; max[1]=2;
 draw1();
 breite--; hoehe-=2;//test (funktioniert so)
}
void Statusfeld::draw1()
{
 color(HELLGRAU); fillbox(x0,y0,x0+breite,y0+hoehe);
 wfont(2);
 wprintf1(0,x1,y1,statext());
 wfont(1);
 color(1);
}
char* Statusfeld::statext()
{
 char *s1,*s2;
 switch(stat[0])
   {case VEKTOR: s1="Vector";
    CASE COMPLEX: s1="Complex";
    DEFAULT: s1="error";
   }
 switch(stat[1])
   {case DEGREE: s2="DEG";
    CASE RADIAN: s2="RAD";
    DEFAULT: s2="error";
   }
 sprintf(text,"%12s  %12s",s1,s2);
 return text;
}

class Vektar
{
 Stapel stapel;
 Anzeigefeld *anfeld;
 Tastenfeld *tafeld;
 int blue;
public:
 Vektar() {}
 void init();
 ~Vektar() {delete anfeld; delete statusfeld; delete tafeld;}
 void press(int i);
 void press(int x,int y);
 void press(char *s);
 void refresh() {anfeld->refresh(); tafeld->refresh(); statusfeld->refresh();}
 Stapel* getps() {return &stapel;}
};
void Vektar::init()
{const int nr=5,ns=8,ab=6, xb=(XMAX-ab)/ns-ab, yh=(YMAX*6/10-ab)/nr-ab;
 double y1=nr*(yh+ab)+ab+1.5*HY, y2=y1+2*HY2, x0=(XMAX-(ab+ns*(xb+ab)))/2;
 settings.load(&stapel);
 tafeld=new Tastenfeld(int(x0),int(1.5*HY),nr,ns,xb,yh,ab);
 statusfeld=new Statusfeld(0,y1,XMAX,y2);
 anfeld=new Anzeigefeld(0,int(y2),XMAX,int(YMAX-y2),&stapel);
 blue=0;
}
void Vektar::press(char *s)
{
 int i,j,n,oldblue=blue;
 for(j=blue,i=0;i<4;i++,j=(j==3)?0:j+1)
   if((n=gettastennummer(s,j))>=0)
     {if(i==0) {press(n); return;}
      if(oldblue&1) press("Blue");
      if(i&2) press("Gold");
      if(j&1) press("Blue");
      press(n);
      if(i&2) press("Gold");
      if(oldblue&1) press("Blue");
      return;
     }
}
void Vektar::press(int i)
{
 int oldblue=blue;
 blue=tafeld->press(i,&anfeld->eingabefeld,&stapel);
 // Delay(20);//test
 anfeld->draw(&stapel);
 if(!anfeld->eingabefeld.help)
   {if((oldblue&1)==1 && (blue&1)==1) press("Blue");
    tafeld->release(i);
   }
}
void Vektar::press(int x,int y)
{
 int i=tafeld->check(x,y);
 if(i>=0) press(i);
}
static Vektar vektar;

class Maus
{
public:
 int x,y,flg;
 Maus() {flg=0;}
};
static Maus maus;

class Marvin
{
public:
 void ask(char*);
};
static Marvin marvin;

void Marvin::ask(char *frage)
{
 char **p,*s,*antw=NULL;
 for(p=tasten_hilfe; (s= *p++)!=NULL; p++)
   {if(strcmp(s,frage)==0) {antw = *p; break;}
   }
 if(antw==NULL) meldung.say("sorry no help for '%s'",frage);
 else meldung.say("'%s' %s  ",frage,antw);
}

const int CALC=1,REGIST=2,GRAPH=3;

class Fenster
{
 double xt,yt,yt0;
 double xmin,ymin,xmax,ymax,h;
 void pfeil(double,double,double,double,double w=160*GRAD,double f=0);
public:
 int status;
 Fenster() {status=CALC; xt=XMAX/100; yt=yt0=YMAX*0.95;
	    xmin=ymin= -0.1; ymax=10.0; xmax=1.25*ymax; h=(xmax-xmin)/50;}
 void refresh(bool skalieren=0);
 void change(int);
 void println(char*,int,Vektor3d);
 void draw(Vektor3d,bool scal=0);
};
void Fenster::draw(Vektor3d v,bool scal)
{
 if(abs(v)==0.0) return;
 double w=settings.winkel,f=settings.kuerz,cosw=cos(w),sinw=sin(w);
 double x,y, a=f*v.y*sinw, b=f*v.y*cosw;
 x=v.x+b;
 y=v.z+a;
 if(x<xmin) xmin=x; else if(x>xmax) xmax=x;
 if(v.x<xmin) xmin=v.x; else if(v.x>xmax) xmax=v.x;
 if(y<ymin) ymin=y; else if(y>ymax) ymax=y;
 if(b<xmin) xmin=b; else if(b>xmax) xmax=b;
 if(a<ymin) ymin=a; else if(a>ymax) ymax=a;
 if(!scal)
   {pfeil(0.,0.,x,y);
    color(ROT);   linie(b,a,x,a); //x-Anteil
    color(GRUEN); linie(v.x,0.,x,a); //y-Anteil
    color(HELLBLAU);  linie(x,a,x,y); //z-Anteil
    color(0);
   }
}
void Fenster::pfeil(double x1,double y1,double x2,double y2,double w,double f)
{
 vektor v,v1(x1,y1),v2(x2,y2);
 vektor v3=v2-v1;
 if(f==0) f=h/abs(v3); else f=f/abs(v3);
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN);
 v=v2+f*vektordrehen(v3,-w);
 plot(v.x,v.y,PENDOWN);
 v=v2+f*vektordrehen(v3,w);
 plot(x2,y2,PENUP); plot(v.x,v.y,PENDOWN);
}

void Fenster::change(int n)
{
 status=n; yt=yt0;
 if(status==GRAPH) inital_new(xmin,ymin,xmax,ymax);
 else  inital_new(0,0,XMAX,YMAX);
 screenclear(1); color(0);
 refresh();
}
void Fenster::println(char *cstr,int n,Vektor3d v)
{
 wfont(1);
 wprintf3(-1,-1,xt,yt,cstr,n,v.x,v.y,v.z);
 yt-=1.5*HY;
}
void Fenster::refresh(bool skalieren)
{
 if(status==CALC)
   {vektar.refresh();
    meldung.error(" ");
   }
 else if(status==GRAPH)
   {int i;
    Stapel* ps=vektar.getps();
    if(skalieren)
      {term_refresh();
       for(xmin=ymin=xmax=ymax=0.0,i=0;i<4;i++) draw(ps->get(i),1);
       double dx=(xmax-xmin)/25, dy=(ymax-ymin)/25;
       xmin-=dx; xmax+=dx; ymin-=dy; ymax+=dy;
       if(xmax-xmin > 1.25*(ymax-ymin)) ymax += (xmax-xmin)/1.25-(ymax-ymin);
       else xmax += (ymax-ymin)*1.25-(xmax-xmin);
       h=(xmax-xmin)/50;
       inital_new(xmin,ymin,xmax,ymax); screenclear(1); color(0);
      }
    double x,y,x0,y0,w=170*GRAD,f=2*h;
    pfeil(xmin,0.,xmax,0.,w,f); //x-Achse
    pfeil(0.,ymin,0.,ymax,w,f); //z-Achse
    if(ymax>xmax) x=y=xmax; else x=y=ymax;
    if(ymin<xmin) x0=y0=xmin; else x0=y0=ymin;
    color(DUNKELBLAU); pfeil(x0,y0,x,y,w,f); //y-Achse
    color(0);
    for(int i=0;i<4;i++) draw(ps->get(i));
   }
}
static Fenster window;

/************************* Men Behandlung ****************************/
void menu_exit() {exitflag=1;}
void menu_about()
{
 char str[80];
 sprintf(str,"Vektar %s\nAutor: Rolf Pfister",VERSION);
 janeinrequester(str);
}
void m_dispcalc()
{
 window.change(CALC);
 term_refresh();
}
void m_dispgraf()
{
 window.change(GRAPH);
 window.refresh();
 term_refresh();
}
void m_dispreg()
{
 double x,y;
 window.change(REGIST);
 for(int i=0;i<10;i++)
   {window.println("R%d = [ %lg  %lg  %lg ]",i,regist[i]);
   }
 term_refresh();
}
void m_dispref()
{
 inital_new();
 if(window.status==CALC)//test (4.9.08)
   {window.change(REGIST);
    window.change(CALC);
   }
 window.refresh(1);
 term_refresh();
}
void m_settings()
{
 int ok,c;
 char aut[40];
 double wink=grad(settings.winkel);
 strcpy(aut,settings.autosave?"yes":"no");
 ok=requester_input(4,
		    "     Dateiname     ","%s","%s\n",&settings.filename,
		    "Perspektive-Winkel","%lf","%lf",&wink,
		    "Perspektive-Verkuerzung","%lf","%lf\n",&settings.kuerz,
		    "Autosave","%s","%s",aut);
 if(ok)
   {settings.autosave=(*aut!='n' && *aut!='N');
    settings.winkel=rad(wink);
   }
}

/************************* Hauptprogramm ******************************/
int Taste::press(Eingabefeld *ef,Stapel *stap)
{
 static int blue=0,eing=0,nx=0;
 int c,c2;
 Vektor3d x,y,z;
 drawselect(ef->help);
 c= *text;
 if(ef->help) {marvin.ask(text); ef->help=0; return blue;}
 if(ist(text,"Blue")) return blue ^= 1;
 if(ist(text,"Gold")) return blue ^= 2;
 if(ist(text,"-->|") || ist(text,"|<--"))
   {if(eing==0) {stap->push(0); ef->open(nx); eing=1;}
    else if(c=='-') ef->reopen(nx=(nx==2)?0:nx+1);
    else  ef->reopen(nx=(nx==0)?2:nx-1);
    return blue;
   }
 if(ist(text,"ENTR"))
   {if(eing) {ef->close(); eing=0;}
    else stap->push(stap->get(0));
    return blue;
   }
 if(eing==0)
   {if(isdigit(c) || c=='.' || ist(text,"EXP"))
      {stap->push(0); ef->open(nx); eing=1; //Eingabemodus einschalten
      }
    else if(ist(text,"CORR"))
      {ef->reopen(nx); eing=1; //Eingabemodus einschalten
       return blue;
      }
   }
 if(eing==1)
   {if(isdigit(c)||c=='.'||ist(text,"EXP")||ist(text,"+/-")||ist(text,"CORR"))
      {//Reaktion auf Tasten im Eingabemodus:
       if(ist(text,"+/-")) c='-';
       else if(ist(text,"EXP")) c='e';
       else if(ist(text,"CORR")) c='\b';
       ef->write(c);
       return blue;
      }
    else
      {ef->close(); eing=0;} //Eingabemodus beenden
   }
 if(ist(text,"+/-")) {x=stap->pop(); stap->push(-x);}
 else if(ist(text,"POP")) stap->pop();
 else if(ist(text,"ROLv")) stap->rol(0);
 else if(ist(text,"ROL^")) stap->rol(1);
 else if(ist(text,"ROL<-"))
	{x=stap->pop(); y.x=x.y; y.y=x.z; y.z=x.x; stap->push(y);}
 else if(ist(text,"ROL->"))
	{x=stap->pop(); y.x=x.z; y.y=x.x; y.z=x.y; stap->push(y);}
 else if(ist(text,"+")) {x=stap->pop(); y=stap->pop(); stap->push(y+x);}
 else if(ist(text,"-")) {x=stap->pop(); y=stap->pop(); stap->push(y-x);}
 else if(ist(text,"/")) {x=stap->pop(); y=stap->pop(); stap->push(y/x);}
 else if(ist(text,"*"))	{x=stap->pop(); y=stap->pop();stap->push(y*x);}
 else if(ist(text,"x"))
	{x=stap->pop(); y=stap->pop(); stap->push(vektorkreuzprodukt(y,x));}
 else if(ist(text,"SIN")) {x=stap->pop(); stap->push(sin(rad(x)));}
 else if(ist(text,"COS")) {x=stap->pop(); stap->push(cos(rad(x)));}
 else if(ist(text,"TAN")) {x=stap->pop(); stap->push(tan(rad(x)));}
 else if(ist(text,"ASIN")) {x=stap->pop(); stap->push(grad(asin(x)));}
 else if(ist(text,"ACOS")) {x=stap->pop(); stap->push(grad(acos(x)));}
 else if(ist(text,"ATAN")) {x=stap->pop(); stap->push(grad(atan(x)));}
 else if(ist(text,"SQRT")) {x=stap->pop(); stap->push(sqrt(x));}
 else if(ist(text,"x^2")) {x=stap->pop(); stap->push(x*x);}
 else if(ist(text,"x<>y"))
	{x=stap->pop(); y=stap->pop(); stap->push(x); stap->push(y);}
 else if(ist(text,"|x|"))
	{x=stap->pop(); x.x=abs(x); x.y=0; x.z=0; stap->push(x);}
 else if(ist(text,"|xxx|"))
	{x=stap->pop(); x.x=x.y=x.z=abs(x); stap->push(x);}
 else if(ist(text,"Pi")) {stap->push(PI);}
 else if(ist(text," e")) {stap->push(exp(1.0));}
 else if(ist(text,"LN")) {x=stap->pop(); stap->push(log(x));}
 else if(ist(text,"e^x")) {x=stap->pop(); stap->push(exp(x));}
 else if(ist(text,"LOG")) {x=stap->pop(); stap->push(log10(x));}
 else if(ist(text," 10^x")) {x=stap->pop(); stap->push(pow(10,x));}
 else if(ist(text,"y^x")) {x=stap->pop(); y=stap->pop(); stap->push(pow(y,x));}
 else if(ist(text,"y^1/x"))
     {x=stap->pop(); y=stap->pop(); Vektor3d z(1,1,1); stap->push(pow(y,z/x));}
 else if(ist(text," 1/x")) {x=stap->pop(); Vektor3d y(1,1,1); stap->push(y/x);}
 else if(ist(text,"RAD")) statusfeld->inc(1);
 else if(ist(text,"STO")) regist[0]=stap->get(0);
 else if(ist(text,"RCL")) stap->push(regist[0]);
 else if(ist(text,"STOx"))
	{x=stap->pop(); c=int(abs(x)+0.001); c2=int(abs(x)+0.999);
	 if(c==c2 && c>=1 && c<=9) regist[c]=stap->get(0);
	 else {stap->push(x); meldung.error("only register 1 to 9 available");}
	}
 else if(ist(text,"RCLx"))
	{x=stap->pop(); c=int(abs(x)+0.001); c2=int(abs(x)+0.999);
	 if(c==c2 && c>=1 && c<=9) stap->push(regist[c]);
	 else {stap->push(x); meldung.error("only register 1 to 9 available");}
	}
 else if(ist(text,"Help"))
	{meldung.say("press key to get help for ","it"); ef->help=1;}
 else if(ist(text,"ALFA"))
	{x=stap->pop(); y=stap->pop();
	 z=vektorkreuzprodukt(x,y); z.x=abs(z)/(abs(x)*abs(y)); z.y=z.z=0;
	 stap->push(grad(asin(z)));
	}
 else if(ist(text,"EHV"))
	{x=stap->pop(); double a=1.0/abs(x);
	 x.x*=a; x.y*=a; x.z*=a; stap->push(x);
	}
 else if(ist(text,"ZROT"))
	{x=stap->pop(); double w=rad(abs(x)),cosw=cos(w),sinw=sin(w);
	 y=stap->pop();
	 z.x=cosw*y.x-sinw*y.y; z.y=sinw*y.x+cosw*y.y; z.z=y.z;
	 stap->push(z);
	}
 else if(ist(text,"YROT"))
	{x=stap->pop(); double w=rad(abs(x)),cosw=cos(w),sinw=sin(w);
	 y=stap->pop();
	 z.z=cosw*y.z-sinw*y.x; z.x=sinw*y.z+cosw*y.x; z.y=y.y;
	 stap->push(z);
	}
 else if(ist(text,"XROT"))
	{x=stap->pop(); double w=rad(abs(x)),cosw=cos(w),sinw=sin(w);
	 y=stap->pop();
	 z.y=cosw*y.y-sinw*y.z; z.z=sinw*y.y+cosw*y.z; z.x=y.x;
	 stap->push(z);
	}
 else if(ist(text,"-ZROT"))
	{x=stap->pop(); double w=rad(abs(x)),cosw=cos(w),sinw=sin(w);
	 y=stap->pop();
	 z.y=cosw*y.y-sinw*y.x; z.x=sinw*y.y+cosw*y.x; z.z=y.z;
	 stap->push(z);
	}
 else if(ist(text,"-YROT"))
	{x=stap->pop(); double w=rad(abs(x)),cosw=cos(w),sinw=sin(w);
	 y=stap->pop();
	 z.x=cosw*y.x-sinw*y.z; z.z=sinw*y.x+cosw*y.z; z.y=y.y;
	 stap->push(z);
	}
 else if(ist(text,"-XROT"))
	{x=stap->pop(); double w=rad(abs(x)),cosw=cos(w),sinw=sin(w);
	 y=stap->pop();
	 z.z=cosw*y.z-sinw*y.y; z.y=sinw*y.z+cosw*y.y; z.x=y.x;
	 stap->push(z);
	}
 else if(ist(text,"RALOP"))
	{x=stap->pop(); double c=sqrt(x.x*x.x+x.y*x.y);
	 y.z=abs(x);
	 y.x=grad(asin(x.z/y.z)); //alfa
	 y.y=grad(asin(x.y/c)); //phi
	 stap->push(y);
	}
 else if(ist(text,"POLAR"))
	{x=stap->pop(); double alfa=rad(x.x), phi=rad(x.y);
	 y.z=sin(alfa)*x.z;
	 double c=sqrt(x.z*x.z-y.z*y.z);
	 y.y=sin(phi)*c;
	 y.x=cos(phi)*c;
	 stap->push(y);
	}
 else if(ist(text,"yROT"))
	{double wx,cosw,sinw,c,alfa,phi,cosa,sina,cosp,sinp;
	 x=stap->pop(); wx=rad(abs(x)); //der gewuenschte Drehwinkel
	 y=stap->pop(); //die Drehachse
	 c=sqrt(y.x*y.x+y.y*y.y);
	 alfa=asin(y.z/abs(y)); phi=asin(y.y/c);
	 y=stap->pop(); //der zu drehende Vektor
	 //Drehachse auf x-Achse bringen:
	 cosa=cos(alfa); sina=sin(alfa);
	 z.y=cosa*y.y-sina*y.x; z.x=sina*y.y+cosa*y.x; z.z=y.z; //-ZROT
	 cosp=cos(phi); sinp=sin(phi);
	 y.z=cosp*z.z-sinp*z.x; y.x=sinp*z.z+cosp*z.x; y.y=z.y; //YROT
	 //gewuenschte Drehung durchfuehren:
	 cosw=cos(wx); sinw=sin(wx);
	 z.y=cosw*y.y-sinw*y.z; z.z=sinw*y.y+cosw*y.z; z.x=y.x; //XROT
	 //Hilfsdrehungen wieder rueckwaerts:
	 y.x=cosp*z.x-sinp*z.z; y.z=sinp*z.x+cosp*z.z; y.y=z.y; //-YROT
	 z.x=cosa*y.x-sina*y.y; z.y=sina*y.x+cosa*y.y; z.z=y.z; //ZROT
	 stap->push(z);
	}
 else if(ist(text,"yzROT")) //provi.  geht noch nicht richtig
   //"rotiert t um die durch z-y gegebene Achse um den Winkel |x|"
	{//x=stap->pop(); double w=rad(abs(x)),cosw=cos(w),sinw=sin(w);
	 Vektor3d v,p1,p2,p3;//test
	 p3=stap->pop();
	 p2=stap->pop();
	 p1=stap->pop();
 	 v=stap->pop();
	 z.x=sinwinkel_zwischen_vektor_und_flaeche(v-p1,p2-p1,p3-p1);
	 z.y=grad(winkel_zwischen_vektor_und_flaeche(v,p1,p2,p3));
	 z.z=sin(rad(z.y));
	 stap->push(z);
	}
 else if(ist(text,"Graph"))
	{term_refresh(); m_dispgraf(); inital_new();}
 else meldung.error("Taste noch nicht belegt");
 return blue;
}

main(int argc,char *argv[])
{
 int col=0,maxcol;
 int breite,hoehe,tiefe,visklasse;
 //tek_setdebug(2);//test
 if(argc>1 && *argv[1]=='?')
	{printf("vektar  %s\n",VERSION);
	 exit(0);
	}
#ifdef FEHLERABFANG
 signal(SIGFPE,fehler);
#ifdef TEST
 printf("fehler-Handler gesetzt\n");
#endif
#endif
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 maxcol=(1<<TIEFE);
 setsize(XMAX,YMAX,tiefe);
 setmenu(2,"File","Display");
 setmenu(2,"About ...","Calculator",&menu_about,&m_dispcalc);
 setmenu(2,"Settings ...","Graphic",&m_settings,&m_dispgraf);
 setmenu(2,"Exit","Register", &menu_exit, &m_dispreg);
 setmenu(2, NULL ,"refresh", NULL, &m_dispref);
 set_funktions(mauspre);
 inital(0,0,XMAX,YMAX); /* Grafikfenster oeffnen */
 set_tektitel("Vektor-Taschenrechner");
 wfont(2);
 wfont(1);
 setcolor(GRAU,128,128,128);
 setcolor(HELLGRAU,192,192,192);
 setcolor(DUNKELGRAU,64,64,64);
 setcolor(HELLBLAU,120,180,255);
 setcolor(DUNKELBLAU,0,0,150);
 setcolor(GOLDGELB,200,180,50);
 vektar.init();
 term_refresh();
 meldung.error("Ready");
 int i=0,in,asci; ULONG rawcode;
 double x1=XMAX/2,y1=0.25*HY,x2=XMAX*0.75,y2=0.25*HY;
 while(exitflag==0 && waitmenu(0)==0)
	{waitTOF();
	 if(maus.flg)
	   {vektar.press(maus.x,maus.y); maus.flg=0;}
	 else if(keyget(&in,&asci,&rawcode) != 0)
           {if(in)
	     {if(isdigit(asci)) vektar.press(gettastennummer(asci));
	      else switch(asci)
		{case '.': case '+': case '-': case '*': case '/':
			vektar.press(gettastennummer(asci));
		 CASE ',': vektar.press("+");
		 CASE 0x0D: vektar.press("ENTR");
		 CASE 0x7F: case 0x08: vektar.press("CORR");
		 CASE '\t': vektar.press("-->|");
		 CASE 0x1B: vektar.press("OFF");
		 CASE 'e': vektar.press("EXP");
		 CASE 'x': vektar.press("x<>y");
		 CASE 'n': vektar.press("+/-");
		 CASE 'b': vektar.press("Blue");
		 CASE 'h': case 'H': case '?': vektar.press("Help");
		 DEFAULT: ;//keine Reaktion auf unbekannte Tasten
			meldung.error("unknown key '%c', rawcode=0x%04X ",
				      asci,rawcode);
		}
	     }
	    else
	     {switch(rawcode)
		{case 0xFF91: vektar.press("Gold");
		 CASE 0xFFE1: case 0xFFE2: vektar.press("Blue");
		 CASE 0xFF92: vektar.press("EXP");
		 CASE 0xFF93: vektar.press("/");
		 CASE 0xFF94: vektar.press("*");
		 CASE 0xFF54: vektar.press("ROLv");
		 CASE 0xFF53: vektar.press("-->|");
		 CASE 0xFF52: vektar.press("ROL^");
		 CASE 0xFF51: vektar.press("|<--");
		 CASE 0xFF9E: vektar.press("0");
		 CASE 0xFF9C: vektar.press("1");
		 CASE 0xFF99: vektar.press("2");
		 CASE 0xFF9B: vektar.press("3");
		 CASE 0xFF96: vektar.press("4");
		 CASE 0xFF9D: vektar.press("5");
		 CASE 0xFF98: vektar.press("6");
		 CASE 0xFF95: vektar.press("7");
		 CASE 0xFF97: vektar.press("8");
		 CASE 0xFF9A: vektar.press("9");
		 CASE 0xFF9F: vektar.press(".");
		 CASE 0xFFC9: vektar.press("Gold");
		 DEFAULT: ;//keine Reaktion auf unbekannte Tasten
			meldung.error("unknown key, rawcode=0x%04X ",rawcode);
		}
	     }
           }
	 i++; //Fehlerzeile nach etwa 4 Sek. loeschen
	 if(i>=200)
	   {i=0; if(meldung.errflag) meldung.say(" ");}
	}
 term_exit();
 if(settings.autosave) {statusfeld->save(); settings.save(vektar.getps());}
 return 0;
}/* ende von main */

void mauspre()
{
 double x,y;
 if(maus.flg) return;//Doppelklick ignorieren
 if(window.status!=CALC) {window.change(CALC); term_refresh(); return;}
 int taste=mausposition(&x,&y);
 maus.x=idfix(x); maus.y=idfix(y); maus.flg=1;
}
