/* complexklasse.cc

 Rechnen mit Complexen Zahlen
Anwendung: einfgen in C++ Programmen
*/

#ifndef COMPLEXKLASSE_CC
#define COMPLEXKLASSE_CC
#include <math.h>
#include <atan2.cc>

class Complex
{
public:
 double r,i;
 Complex(double a=0,double b=0) {r=a; i=b;}
 Complex operator=(Complex v) {r=v.r; i=v.i; return *this;}
 Complex operator+=(Complex v) {r+=v.r; i+=v.i; return *this;}
 Complex operator-=(Complex v) {r-=v.r; i-=v.i; return *this;}
 Complex operator*=(double z) {r*=z; i*=z; return *this;}
 Complex operator/=(double z) {r/=z; i/=z; return *this;}
 friend Complex operator+(Complex,Complex);
 friend Complex operator-(Complex,Complex);
 friend Complex operator*(Complex,double);
 friend Complex operator*(double,Complex);
 friend Complex operator*(Complex,Complex);
 friend Complex operator/(Complex,double);
 friend Complex operator/(Complex,Complex);
 friend Complex operator-(Complex);
 char* s();
};
char* Complex::s()
{
 char *plus; double y;
 static char str[80];
 if(i<0) {plus="-"; y= -i;}
 else  {plus="+"; y=i;}
 sprintf(str,"%lg %s %lgi",r,plus,y);
 return str;
}
Complex operator+(Complex v1,Complex v2)
{
 Complex z; z.r=v1.r+v2.r; z.i=v1.i+v2.i;
 return z;
}
Complex operator-(Complex v1,Complex v2)
{
 Complex z; z.r=v1.r-v2.r; z.i=v1.i-v2.i;
 return z;
}
Complex operator*(Complex v1,double c)
{
 Complex z; z.r=v1.r*c; z.i=v1.i*c;
 return z;
}
Complex operator*(double c,Complex v1)
{
 Complex z; z.r=v1.r*c; z.i=v1.i*c;
 return z;
}
Complex operator*(Complex v1,Complex v2)
{
 Complex z; z.r=v1.r*v2.r-v1.i*v2.i; z.i=v1.r*v2.i+v2.r*v1.i;
 return z;
}
Complex operator/(Complex v1,double c)
{
 Complex z; z.r=v1.r/c; z.i=v1.i/c;
 return z;
}
Complex operator/(Complex v1,Complex v2)
{
 Complex z,d,y;
 d.r=v2.r; d.i= -v2.i;
 y=v2*d;
 z=v1*d/y.r;
 return z;
}
Complex operator-(Complex v1)
{
 Complex z; z.r= -v1.r; z.i= -v1.i;
 return z;
}

double abs(Complex v)				//Betrag
{
 return sqrt(v.r*v.r+v.i*v.i);
}

extern "C" {
Complex csqrt(double,double);
}

Complex sqrt(Complex x)
{
 Complex z; double alfa,c,sc;
 alfa=0.5*atan2(x.i,x.r);
 c=abs(x); sc=sqrt(c);
 z.r=sc*cos(alfa);
 z.i=sc*sin(alfa);
 return z;
}

Complex exp(Complex x)
{
 Complex z;
 double ea=exp(x.r);
 z.r=ea*cos(x.i);
 z.i=ea*sin(x.i);
 return z;
}
#endif
