// hanoi.cc	Simuliert die Trme von Hanoi
//
// Dies ist ein Beispiel dafr wie man einfache Klassen in C++ definiert
// und verwendet.

#include <stdio.h>
#include <math.h>
#include <xtekplot1.h>

const int
	MAXSCH=10;	//maximale Anzahl Scheiben
const double
	dicke=0.8,	//Dicke der Scheiben
	stabdicke=0.25;	//Dicke der Stbe

/************* einige Vordeklarationen: *****************/
void linie(double x1,double y1,double x2,double y2);
void grundlinie_zeichnen(double x1=0.,double x2=0.);

class scheibe
{
 double px,py;	//Aktuelle Position (nur von zeichnen und loeschen benutzt)
public:
 double r,	//Radius
	h;	//Hhe der Scheibe (Dicke)
 scheibe(double radius=0.,double b=dicke) {r=radius; h=b;}
 void zeichnen(double x,double y);
 void neuzeichnen(); //an aktueller Position neu zeichnen
 void loeschen();
 void getxy(double *x,double *y) {*x=px; *y=py;}  //Aktuelle Position lesen
};
static scheibe nullscheibe(0.,0.);

class turm
{
public:
 double x,	//Position des Turmes
	hmax,	//Maximale Hhe des Turmes
	h;	//Hhe des Stapels
 int	anzahl;	//Anzahl vorhandene Scheiben
 scheibe s[MAXSCH];
 turm(double position) {x=position; h=0.0; anzahl=0; hmax=(MAXSCH*2+1)*dicke;}
 void zeichnen();
 void put(scheibe a);
 scheibe get();
};

void scheibe::zeichnen(double x,double y)
{
 px=x; py=y;
 drawbox(x-r,y,x+r,y+h);
}
void scheibe::neuzeichnen()
{
 drawbox(px-r,py,px+r,py+h);
}
void scheibe::loeschen()	//Darunter liegende Scheibe und Stab
{				//sollten danach neu gezeichnet werden.
 color(0);
 drawbox(px-r,py,px+r,py+h);
 color(1);
}

void turm::zeichnen()
{
 double d=stabdicke/2.;
 drawbox(x-d,0.,x+d,hmax);
}
void turm::put(scheibe a)
{
 s[anzahl].r=a.r; s[anzahl].h=a.h;
 s[anzahl++].zeichnen(x,h);
 h += a.h; //neue Stapelhhe
}
scheibe turm::get()
{
 if(anzahl==0)
   {printf("Fehler: turm::get() auf leeren Stapel angewendet\n");
    return nullscheibe;//keine Scheibe mehr vorhanden
   }
 s[--anzahl].loeschen();
 h -= s[anzahl].h;
 if(anzahl>0) s[anzahl-1].neuzeichnen();
 else grundlinie_zeichnen();
 zeichnen(); //Stab neu zeichnen
 return s[anzahl];
}

/************************* Testfunktionen ********************************/
/**
void testdelay(int n)
{
 if(n>=5) //bei Wartezeit von mindestens 0.1 Sekunden
	term_refresh();
 Delay(n);
 inital_new();
}
**/

/************* weitere Vordeklarationen: *****************/
void schieben(turm *von,turm *nach); //einzelne Scheibe verschieben
void hanoi(int n,turm *von,turm *nach,turm *ablage); //n Scheiben verschieben
void scheibe_animieren(scheibe*,double,double,double,double,int,int,
		       turm *tu=NULL,int flag=0);

/******************** Hauptprogramm ************************/
double scheibenradius(int i) {return (2*i+1)*dicke+stabdicke/2.;}

main(int argc,char *argv[])
{
 int nscheib,i,breite,hoehe,tiefe,visual;
 double deltax=scheibenradius(MAXSCH), br;
 double xmin= -stabdicke, xmax=6*deltax+stabdicke,
	ymin= -2*dicke, ymax=4*MAXSCH*dicke;
 turm a(deltax),b(3*deltax),c(5*deltax);
 scheibe sch;
 if(argc==2) sscanf(argv[1],"%d",&nscheib);
 else {printf("Anzahl Scheiben:"); scanf("%d",&nscheib);}
 if(nscheib>MAXSCH) printf("auf %d Scheiben beschrnkt!\n",nscheib=MAXSCH);
 getmaxsize(&breite,&hoehe,&tiefe,&visual);
 if(tiefe>8) tiefe=8;
 setsize(breite,hoehe/2,tiefe);
 setmenu(AUTOMENU);
 inital(xmin,ymin,xmax,ymax);
 grundlinie_zeichnen(xmin,xmax);
 a.zeichnen(); b.zeichnen(); c.zeichnen();
 textsize(br=2*stabdicke,4*stabdicke);
 schrift(a.x-5*br,ymin+dicke/2.,"Startstapel");
 schrift(b.x-5*br,ymin+dicke/2.,"Zielstapel");
 schrift(c.x-6*br,ymin+dicke/2.,"Ablagestapel");
 for(i=nscheib;i>0;i--)
    {sch.r=scheibenradius(i);
     a.put(sch);
    }
 Delay(150); //einen Moment warten
 hanoi(nscheib,&a,&b,&c);
 printf("Stapel fertig verschoben\n");
 term_refresh();
 automenu_loop();
 term_exit();
}

void hanoi(int n,turm *von,turm *nach,turm *ablage)
{
 if(n==1)		//wenn wir nur eine Scheibe verschieben mssen
   schieben(von,nach);	//ist die Sache einfach.
 else				//andernfalls:
   {hanoi(n-1,von,ablage,nach); //grsster Teil des Stapels auf Ablage bringen
    schieben(von,nach);		//die andere Scheibe einfach verschieben
    hanoi(n-1,ablage,nach,von); //Stapel von Ablage auf Zielstapel bringen.
   }
}

void schieben(turm *von,turm *nach)
{
 scheibe sch;
 double x,y,ymax=von->hmax+dicke;
 sch=von->get();	//Scheibe abheben
 sch.getxy(&x,&y);
 scheibe_animieren(&sch,x,y,x,ymax,16,6,von,1);	//Abheben in etwa 1/3 Sekunde
 scheibe_animieren(&sch,x,ymax,nach->x,ymax,16,6); //Ueber Zielstapel bringen
 scheibe_animieren(&sch,nach->x,ymax,nach->x,nach->h,16,6,nach); //senken
 nach->put(sch);
 Delay(5);
}

/************ einige Kleinigkeiten *******************/
void linie(double x1,double y1,double x2,double y2)
{
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN);
}
void grundlinie_zeichnen(double x1,double x2)
{
 static double xmin,xmax;
 if(x1!=x2) {xmin=x1; xmax=x2;}
 linie(xmin,0.,xmax,0.);
}

/****************** die Schwierigen Programmteile ************************/
void scheibe_animieren(scheibe *sh,
	double x1,double y1,	//Startposition
	double x2,double y2,	//Zielposition
	int i0,	//Anzahl Ticks (1/50 Sek.) fr ganze Bewegung
	int ia,	//Lnge der Beschleunigungs- und Abbrems-Phasen
	turm *tu,int schongeloescht)
{
 double ax,ay,vx,vy;
 int	i1=i0-ia;	//Beschleunigungsphase gleich lang wie Abbremsphase
 double a=double((i0-ia)*ia);
 vx=ax=(x2-x1)/a;		// v=s/(t_total-t_beschl), a=v/t_beschl
 vy=ay=(y2-y1)/a;
 while(--i0>0)
	{if(!schongeloescht) sh->loeschen(); else schongeloescht=0;
	 sh->zeichnen(x1+=vx,y1+=vy);
	 if(tu!=NULL) tu->zeichnen(); //zerstrter Stab neu zeichnen
	 waitTOF();
	 if(i0>i1)    {vx+=ax; vy+=ay;} //Beschleunigungsphase
	 else if(i0<=ia) {vx-=ax; vy-=ay;} //Abbremsphase
	}
}
