//atan2.cc

#include <math.h>
#ifdef PI
#undef PI
#endif
#ifdef PIHALBE
#undef PIHALBE
#endif
const double PI=4*atan(1.0);
const double PIHALBE=PI/2.0;

double atan2(double y,double x)
{
 if(x==0.0) return (y<0.) ? -PIHALBE : PIHALBE;
 if(x>=0.) return atan(y/x);
 if(y>=0.) return PI-atan(y/(-x));
 return atan(y/x)-PI;
}
