/* checkgrein.cc
  Testprogi um Eingabe mit Fadenkreuz in xtekplot1 zu testen

History:
ca. 1998	Erstellung (RPf)
7.5.2015 	Fehlendes int vor main() gesetzt
                Fehler bei Berechnung von maxcol korrigiert

*/

#define VERSION "Version 0.0"
#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <xtekplot1.h>
#define XMAX 1280
#define YMAX 1024
#define TIEFE 24

/************************* Vordeklarationen ***************************/

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Menu Behandlung ****************************/
static int exitflag=0;
void m_exit() {exitflag=1;}
void m_test()
{
 janeinrequester_utf8("Dies ist ein Text mit UTF8-Umlauten.\n\
Kleine: äöü (sollten aou mit Pünktchen obendrauf sein)\n\
Große: ÄÖÜ (sollten AOU mit P\\\"unktchen sein).");
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 quellname[0]=zielname[0]=0;
 FILE *fp1,*fp2;
 int i,j,c,col=0,maxcol;
 int breite,hoehe,tiefe,visklasse;
 double xmin= -0.125,ymin=0.,xmax=1.125,ymax=1.;
 if(argc<=0)
   ;/* es wurde von WorkBench gestartet */
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("start_grafik  %s\n",VERSION);
	 printf("Anwendung: start_grafik [Quelle] [Ziel]\n");
	 exit(0);
	}
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 maxcol=(1<<tiefe); //nicht TIEFE !
 setsize(breite,hoehe,tiefe);
 setmenu(1,"File");
 setmenu(1,"Test...",m_test);
 setmenu(1,"Exit",m_exit);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 plot(0.,0.,PENUP); plot(1.,1.,PENDOWN); /* eine Linie zeichnen */
 waitTOF();
 term_refresh();
 waitTOF();
/*
 while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten
*/
 inital_new();
 double x1,y1;
 j=0;
 set_tektitel("/home/rolf/test_test2_test3/test4/test5/langer_Pfad_für_Test");
 while(exitflag==0)
	{waitBOF();		//auf Ende des Bildaufbaus warten
	//oder waitTOF();	//auf Beginn des Bildaufbaus warten
	//oder waitmenu(0);	//nicht warten
	 if((col+=128)==maxcol) col=0;
	 color(col);
	 plot(1.,0.,PENUP); plot(0.,1.,PENDOWN);
	 plot(0.,0.,PENUP); plot(1.,1.,PENDOWN);
	 if(++j<=2)
	  {tek_grein(&x1,&y1);
	   printf("x1=%lf y1=%lf\n",x1,y1);
	  }
	}
 term_exit();
 return 0;
}/* ende von main */
