/* imagetestjpeg.cc
  wie imagetest.cc aber Einlesen mit JPEG-Library

History:
30.11.2017	Erstellung (RPf)

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <jpeglib.h>
#include <xtekplot1.h>
#define UNITYBUG 32  //Fehler in Unity umgehen: Hoehe des nicht abschaltbaren Balkens
typedef unsigned char uchar;
const int MAXP=MAX_PFADNAME_LAENGE, MAXD=MAX_DATEINAME_LAENGE;

int exif_orient_auslesen(const char *bildname); //Orientierungs-Nummer auslesen
uchar *rotate(int grad,uchar *pmem,int *breite,int *hoehe); //Bild nach rechts drehen
uchar *mirror(int grad,uchar *pmem,int *breite,int *hoehe); //Spiegeln und drehen

uchar *bild_einlesen(const char *name,int *breite,int *hoehe)
{
 int width, height;
 struct jpeg_decompress_struct cinfo;
 struct jpeg_error_mgr jerr;

 FILE *fp;        /* source file */
 JSAMPARRAY pJpegBuffer;       /* Output row buffer */
 int row_stride;       /* physical row width in output buffer */
 int exif_orient=exif_orient_auslesen(name);
 if((fp=fopen(name,"rb"))==NULL)
   {fprintf(stderr, "can't open %s\n",name); return NULL;}
 cinfo.err = jpeg_std_error(&jerr);
 jpeg_create_decompress(&cinfo);
 jpeg_stdio_src(&cinfo, fp);
 jpeg_read_header(&cinfo, TRUE);
 jpeg_start_decompress(&cinfo);
 *breite = width = cinfo.output_width;
 *hoehe = height = cinfo.output_height;

 uchar *pmem = (uchar*)malloc(width*height*4);
 if(!pmem) {printf("NO MEM FOR JPEG CONVERT!\n"); return NULL;}
 row_stride = width * cinfo.output_components;
 pJpegBuffer = (*cinfo.mem->alloc_sarray)
  ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);

 uchar *p=pmem;
 uchar r, g, b;
 const int alpha=0; // alpha value is not supported on jpg
 while(cinfo.output_scanline < cinfo.output_height)
  {
   jpeg_read_scanlines(&cinfo, pJpegBuffer, 1);
   for(int x=0; x<width; x++)
    {
     r = pJpegBuffer[0][cinfo.output_components * x];
     if(cinfo.output_components > 2)
      {
       g = pJpegBuffer[0][cinfo.output_components * x + 1];
       b = pJpegBuffer[0][cinfo.output_components * x + 2];
      }
     else {g=b=r;}
     *p++ = r;  *p++ = g;  *p++ = b;  *p++ = alpha;
    }
  }
 fclose(fp);
 jpeg_finish_decompress(&cinfo);
 jpeg_destroy_decompress(&cinfo);
 if(exif_orient>1)
  {switch(exif_orient) //Bild entsprechend drehen oder spiegeln
    {
     case 6: pmem=rotate(90,pmem,breite,hoehe); break; //90 Grad nach rechts rotieren
     case 3: pmem=rotate(180,pmem,breite,hoehe); break;
     case 8: pmem=rotate(270,pmem,breite,hoehe); break;
     case 2: pmem=mirror(0,pmem,breite,hoehe); break; //Links-rechts spiegeln
     case 7: pmem=mirror(90,pmem,breite,hoehe); break; //Spiegeln, dann rotieren
     case 4: pmem=mirror(180,pmem,breite,hoehe); break;
     case 5: pmem=mirror(270,pmem,breite,hoehe); break;
    }
  }
 return pmem;
}

uchar *bild_verkleinern(uchar *pmem,int *bildbreite,int *bildhoehe,
			int maxbreite,int maxhoehe)
{
 int xmax= *bildbreite, ymax= *bildhoehe; //urspruengliche Bildgroesse
 double f1=maxbreite/(double)xmax;
 double f2=maxhoehe/(double)ymax;
 //printf("f1=%f f2=%f\n",f1,f2);//test
 if(f2<f1) f1=f2; //kleinerer der beiden Werte verwenden
 int breite, hoehe; //neue Bildgroesse
 *bildbreite = breite = (int)(xmax*f1);
 *bildhoehe  = hoehe = (int)(ymax*f1);
 //printf("alte breite=%d hoehe=%d\n",xmax,ymax);
 //printf("neue breite=%d hoehe=%d\n",breite,hoehe);
 uchar *pneu = (uchar*)malloc(breite*hoehe*4);
 uchar r,g,b,a, *p,*q;
 int ix,iy,x1,y1,x,y;
 const int bytes_pro_pixel=4;
 int bytes_pro_zeile=xmax*bytes_pro_pixel;
 for(p=pneu,iy=0,y1=0; iy<hoehe; iy++,y1+=ymax)
  for(ix=0,x1=0; ix<breite; ix++,x1+=xmax)
   {
    x=x1/breite; y=y1/hoehe; //nur 1 Pixel verwenden
    //TODO: Durchschnitt von mehreren Pixeln fuer bessere Bildqualitaet
    q = &pmem[y*bytes_pro_zeile+x*bytes_pro_pixel];
    r= *q++; g= *q++; b= *q++; a= *q++;
    *p++ = r; *p++ = g; *p++ = b; *p++ = a;
   }
 free(pmem);
 return pneu;
}

static int exitflag=0;
void m_exit() {exitflag=1;}

int main(int argc,char *argv[])
{
 double dxmin=0,dymin=0,dxmax=1.2,dymax=1.0;
 int breite,hoehe,tiefe,visklasse;
 char name[MAXP]="blume.jpg";
 char text[80]="Lade Datei";
 char filt[MAXD]="*.jpg";
 int sprache=SPRACHE_DEUTSCH;
 bool ok;
 if(argc>=2) {strcpy(name,argv[1]); ok=true;}
 else
  {
   ok=nachfilenamefragen(text,name,MAXP,sprache,filt);
   if(!ok) return 0;
  }
 int bildbreite,bildhoehe;
 uchar *pmem=bild_einlesen(name,&bildbreite,&bildhoehe);
 if(pmem==NULL) return 0;
 printf("Bild eingelesen: bildbreite=%d bildhoehe=%d\n",bildbreite,bildhoehe);

 // Grafik-Fenster oeffnen:
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
#ifdef UNITYBUG
 hoehe -= UNITYBUG;
#endif
 if(tiefe>24) tiefe=24;
 setsize(breite,hoehe,tiefe);
 setmenu(1,"File");
 setmenu(1,"Exit",m_exit);
 inital(dxmin,dymin,dxmax,dymax);
 printf("Grafik-Fenster geoeffnet: breite=%d hoehe=%d\n",breite,hoehe);
 int ho=get_menuleistenhoehe();
 if(bildbreite>breite || bildhoehe>hoehe)
  {
   pmem=bild_verkleinern(pmem,&bildbreite,&bildhoehe,breite,hoehe-ho);
   printf("Bild verkleinert auf %d x %d\n",bildbreite,bildhoehe);
  }

 // Bild im Grafik-Fenster anzeigen:
 int xmax=bildbreite, ymax=bildhoehe; //rgb_grau=0x808080;
 uchar r,g,b; int rgb;
 XImage *image=tek_xcreateimage(xmax,ymax);
 uchar *p;
 int iy,ix;
 for(p=pmem,iy=0; iy<ymax; iy++)
  for(ix=0; ix<xmax; ix++)
   {
    r = *p++; g = *p++; b = *p++; p++;
    rgb = (r<<16)+(g<<8)+b;
    XPutPixel(image, ix, iy, rgb);
   }
 int offsetx=0,offsety=0;
 if(bildbreite<breite) offsetx=(breite-bildbreite)/2;
 if(bildhoehe<hoehe-ho) offsety=(hoehe-ho-bildhoehe)/2;
 tek_xputimage(image,0,0, offsetx, ho+offsety, xmax,ymax);
 XDestroyImage(image); //speicher vom image wieder freigeben
 free(pmem); //mit malloc reservierter Speicher freigeben

 while(exitflag==0 && waitmenu(1)==0)
  {
   // auf Benutzereingaben warten
  }
 term_exit();
 return 0;
}

#define STDERR stderr
/***** neue Version von exifdatum() und exif_otient_auslesen() *****/
typedef unsigned char uchar;
static int exif_orient=0;
static int exif_ausleseflags=0;
#define EXIF_ORIENT 1
#define EXIF_USERCOMMENT 2
#define EXIF_BILDBESCHREIBUNG 4
static char exif_kommentar[200];

void zeitstempel_lesen(const uchar *von,char *ziel)
{
 //maximal 20 Byte langer Zeitstempel lesen
 while(*von==' ') von++;
 for(int i=1;i<20 && *von!=0;i++) *ziel++ = *von++;
 *ziel=0;
}

static bool intelformat=false;

int word(int c1,int c2)
{
 c1&=0xFF; c2&=0xFF;
 return (intelformat) ? c1+(c2<<8) : (c1<<8)+c2;
}

int word32(int c1,int c2,int c3,int c4)
{
 c1&=0xFF; c2&=0xFF; c3&=0xFF; c4&=0xFF;
 if(intelformat) return (((((c4<<8)+c3)<<8)+c2)<<8)+c1;
 return (((((c1<<8)+c2)<<8)+c3)<<8)+c4;
}

char* exifdatum(const char *name) //nur leicht geaenderte Kopie von exifdatum.cc
{
 static char szeit[32]; //String fuer Datum der Form "2017:11:14 05:45:39"
 *szeit=0;
 FILE *fp=fopen(name,"rb");
 if(fp==NULL)
   {fprintf(STDERR,"exifdatum() \"%s\" nicht gefunden.\n",name); return NULL;}
#ifdef DEBUGMODUS
 fprintf(STDERR,"exifdatum(\"%s\")\n",name);
#endif
 int c1,c2,nbytes=0;
 bool istexif=false;
 int soiflag=0;
 while((c1=getc(fp))!=EOF)
  {
   c2=getc(fp);
   if(c1!=0xFF)
    {
#ifdef DEBUGMODUS
     fprintf(STDERR,"unerwartete Start-Zeichen: 0x%02X 0x%02X\n",c1,c2);
#endif
     if(soiflag) {fprintf(STDERR,"Fehler in \"%s\": falsches JFIF\n",name); return NULL;}
     fclose(fp); return szeit;
    }
   if(c2==0xD8)
    {
#ifdef DEBUGMODUS
     fprintf(STDERR,"SOI-Segment gefunden\n");
#endif
     soiflag=1;
    }
   else
    {
     uchar c3,c4;
     c3=getc(fp); c4=getc(fp);
     nbytes=(c3<<8)+c4;
     int i0=2; //schon 2 von den nbytes gelesen
     if(c2==0xE1)
      {
#ifdef DEBUGMODUS
       fprintf(STDERR," APP1 gefunden");
#endif
       char str[8]; int i;
       for(i=0;i<6 && i<nbytes-2;i++) {str[i]=getc(fp); i0++;}
       str[i]=0;
       istexif = (strcmp(str,"Exif")==0);
       if(istexif) break;
      }
     else if(c2==0xDA)
      {
       fclose(fp);
#ifdef DEBUGMODUS
       fprintf(STDERR,"SOS gefunden, Exif fehlt.\n");
#endif
       return szeit;//Spezialfall SOS, so weit hinten darf kein Exif sein
      }
     else
      {
       for(int i=i0;i<nbytes && getc(fp)!=EOF;i++) {}
      }
    }
  }
 if(!istexif) {fclose(fp); return szeit;}
 // bis hier wurde alles bis und mit "Exif\0\0" von fp gelesen
#ifdef DEBUGMODUS
 fprintf(STDERR,"Exif %d Bytes\n",nbytes);
#endif
 uchar buf[nbytes-8]; //Puffer fuer alle Exif-Daten
 uchar c3,c4;
 for(int i=8,k=0;i<nbytes && (c1=getc(fp))!=EOF;i++)
  {buf[k++]=c1;}
 intelformat=(buf[0]=='I');
 bool tiffok=false;
 if(buf[0]==0x49 && buf[1]==0x49 && buf[2]==0x2A && buf[3]==0 &&
    buf[4]==0x08 && buf[5]==0 && buf[6]==0 && buf[7]==0) tiffok=true;
 else
  if(buf[0]==0x4D && buf[1]==0x4D && buf[2]==0 && buf[3]==0x2A &&
     buf[4]==0 && buf[5]==0 && buf[6]==0 && buf[7]==0x08) tiffok=true;
 if(!tiffok) fprintf(STDERR,"Error in \"%s\": Exif starts with wrong TIFF header\n",name);
#ifdef DEBUGMODUS
 else fprintf(STDERR,"TIFF-Header im %s-Format\n",intelformat?"Intel":"Motorola");
#endif
 char datum1[22],datum2[22],datum3[22]; //drei Zeitstempel
 datum1[0]=datum2[0]=datum3[0]=0;       //bisher leer
 //exif_orient=0; // Orientierung: 0=noch nicht gesetzt, 1=normal, 6=90 Grad,
                // 3=180 Grad, 8=270 Grad
 int offset=8,IFD=0;
 int j=8; //erstes Byte nach dem TIFF-Header
 int jreturn=0, anzreturn=0; //fuer Rueckkehr von Sub-IFD
 while(j!=0 && IFD<=1) //alle IFDs lesen (es gibt nur IFD0 und IFD1?)
  {
   //if(argflag['V']) printf("IFD%d\n",IFD);
   c1=buf[j++]; c2=buf[j++];
   int anzahl_ifd_eintraege = word(c1,c2);
   //if(argflag['V']) printf(" Anzahl IFD-Eintraege = %d\n",anzahl_ifd_eintraege);
   int tag,typ,anzahl;
   while(anzahl_ifd_eintraege>0)
    {
     c1=buf[j++]; c2=buf[j++]; tag=word(c1,c2);
     c1=buf[j++]; c2=buf[j++]; typ=word(c1,c2);
     c1=buf[j++]; c2=buf[j++]; c3=buf[j++]; c4=buf[j++]; anzahl=word32(c1,c2,c3,c4);
     c1=buf[j++]; c2=buf[j++]; c3=buf[j++]; c4=buf[j++]; offset=word32(c1,c2,c3,c4);
     //printf("Testpunkt2: offset=%d\n",offset);//test
     if(IFD==0)
      {if(tag==0x132) //Zeitstempel letzte Veraenderung des Bildes
	{
	 //if(argflag['V']) printf("Zuletzt-Geaendert-Zeitstempel gefunden\n");
	 zeitstempel_lesen(&buf[offset],datum1);
	}
       else if(tag==0x112) //Orientierung
	{
	 //if(argflag['V']) printf("Orientierung (Rotation) gefunden\n");
	 if(exif_ausleseflags & EXIF_ORIENT)
	   exif_orient=word(c1,c2);
	}
       else if(tag==0x010E) //Beschreibung zum Bild
	{
	 if(exif_ausleseflags & EXIF_BILDBESCHREIBUNG)
	  {
	   if(typ==2) //ASCII
	     {strncpy(exif_kommentar,(char*)&buf[offset],200); exif_kommentar[200-1]=0;}
	   else sprintf(exif_kommentar,"Bild-Beschreibung: unbekannter Typ=%d\n",typ);
	  }
	}
       else if(tag==0x8769) //Offset zum Sub-IFD
	{
#ifdef DEBUGMODUS
	 fprintf(STDERR,"Sub-IFD offset=%d\n",offset);//test
#endif
	 jreturn=j; j=offset;
	 anzreturn=anzahl_ifd_eintraege;
	 c1=buf[j++]; c2=buf[j++];
	 anzahl_ifd_eintraege = word(c1,c2); //Anzahl Eintraege im Sub-IFD
	 continue;
	}
       // Datum-Eintraege im Sub-IFD von IFD0 suchen:
       else if(tag==0x9003) //Aufnahme-Zeitstempel
	{
#ifdef DEBUGMODUS
	 fprintf(STDERR,"Aufnahme-Zeitstempel gefunden\n");
#endif
	 zeitstempel_lesen(&buf[offset],datum3);
	}
       else if(tag==0x9004) //Digitalisierungs-Zeitstempel
	{
	 //if(argflag['V']) printf("Digitalisierungs-Zeitstempel gefunden\n");
	 zeitstempel_lesen(&buf[offset],datum2);
	}
       else if(tag==0x9286) //User-Comment
	{
	 //if(argflag['V'] || argflag['T']) printf("User-Comment gefunden\n");
	 if(exif_ausleseflags & EXIF_USERCOMMENT)
	  {
	   //char text[80];
	   if(typ==7) //UNICODE
	    {
	     if(strcmp((char*)&buf[offset],"ASCII")==0)
	      {
	       strncpy(exif_kommentar,(char*)&buf[offset+8],200); exif_kommentar[200-1]=0;
	      }
	     else if(strcmp((char*)&buf[offset],"UNICODE")==0)
	      {
	       //TODO: auslesen von UNICODE String
	       uchar *s= &buf[offset+8];
	       char *p=exif_kommentar;
	       int imax=(anzahl-8)/2;
	       if(imax>=200) imax=200-1;
	       for(int i=0;i<imax;i++,s++)
		{
		 if(*s==0) {*p++ = *(++s);} //TODO: ev. von isolatin-1 in UTF8 umwandeln
		            //zum Anschreiben unter xwindows ist aber isolatin-1 richtig
		 else {*p++='?'; ++s;}//TODO andere als isolatin-1 interpretieren
		}
	       *p=0;
	      }
	     else
	      {
	       strcpy(exif_kommentar,"Unbekannte Codierung: ");
	       int n=strlen("Unbekannte Codierung: ");
	       strncpy(&exif_kommentar[n],(char*)&buf[offset],200-n);
	      }
	     //printf("\"%s\"\n",exif_kommentar);
	    }
	   else //fuer User-Comment sollte immer typ==7 sein?
	    {
	     //fprintf(STDERR,"User-Comment: typ=%d ist falsch (sollte 7 sein)\n",typ);//test
	    }
	  }
	}
       else if(tag==0x9000) //Exif-Version
	{
#ifdef DEBUGMODUS
	 //if(argflag['V'])
	  {
	   char str[6];
	   printf(STDERR,"Test: Exif-Version auswerten: typ=%d anzahl=%d\n",typ,anzahl);//test
	   str[0] = (c1=='0')?' ':c1;
	   str[1]=c2; str[2]='.'; str[3]=c3; str[4]=c4; str[5]=0;//Version genau 4 Zeichen
	   fprintf(STDERR,"Exif-Version %s\n",str);
	  }
#endif
	}
      }
     else if(IFD==1)
      {
       //Eintraege im IFD1 suchen (zum Datum, Orientierung und Kommentare auslesen nicht noetig)
      }
     if(--anzahl_ifd_eintraege == 0)
      {
       j=jreturn; jreturn=0;
       anzahl_ifd_eintraege=anzreturn; anzreturn=0;
      }
    }
   c1=buf[j++]; c2=buf[j++]; c3=buf[j++]; c4=buf[j++]; //Offset fuer naechstes IFD
   offset=word32(c1,c2,c3,c4); IFD++;
#ifdef DEBUGMODUS
   fprintf(STDERR,"test: offset=%d fuer IFD%d\n",offset,IFD);//test
#endif
   j=0;//hier abbrechen (alles ab IFD1 ignorieren)
  }
 
 //if(orient!=0 && argflag['R']) printf("Orientierung = %d\n",orient);
 if(datum3[0]!=0) strcpy(szeit,datum3);
 else if(datum2[0]!=0) strcpy(szeit,datum2);
 else if(datum1[0]!=0) strcpy(szeit,datum1);
 fclose(fp);
 if(*szeit==0) return szeit;
 if(strlen(szeit)!=19 || szeit[4]!=':' || szeit[7]!=':' || szeit[10]!=' ' || szeit[13]!=':' || szeit[16]!=':')
  {
   //fprintf(STDERR,"in \"%s\" falscher Zeitstempel: \"%s\"\n",name,szeit);//test
  }
 return szeit;
}

int exif_orient_auslesen(const char *bildname)
{
 exif_ausleseflags=EXIF_ORIENT;
 exif_orient=0;
 exifdatum(bildname);
 if(exif_orient==0)
  {fprintf(STDERR,"exif_orient_auslesen() erfolglos, auf 1 gesetzt.\n"); return 1;}
 return exif_orient;
}

/**************************** Bild drehen und spiegeln ****************************/
uchar *rotate(int grad,uchar *pmem,int *breite,int *hoehe) //Bild nach rechts drehen
{
 int br= *breite, ho= *hoehe;
 uchar *pmemneu=(uchar*)malloc(br*ho*4);
 uchar *p=pmem, *z=pmemneu;
 int x,y;
 uchar r,g,b,a;
 if(grad==90)
  {
   int brneu=ho, honeu=br, bytesprozeile=brneu*4, ho1=ho-1;
   for(y=0;y<ho;y++)
    for(x=0;x<br;x++)
     {
      r= *p++; g= *p++; b= *p++; a= *p++;
      z = &pmemneu[x*bytesprozeile+(ho1-y)*4];
      *z++ = r; *z++ = g; *z++ = b; *z++ = a;
     }
   *breite=brneu; *hoehe=honeu;
  }
 else if(grad==180)
  {
   int bytesprozeile=br*4, ho1=ho-1, br1=br-1;
   for(y=0;y<ho;y++)
    for(x=0;x<br;x++)
     {
      r= *p++; g= *p++; b= *p++; a= *p++;
      z = &pmemneu[(ho1-y)*bytesprozeile+(br1-x)*4];
      *z++ = r; *z++ = g; *z++ = b; *z++ = a;
     }
  }
 else if(grad==270)
  {
   int brneu=ho, honeu=br, bytesprozeile=brneu*4, br1=br-1;
   for(y=0;y<ho;y++)
    for(x=0;x<br;x++)
     {
      r= *p++; g= *p++; b= *p++; a= *p++;
      z = &pmemneu[(br1-x)*bytesprozeile+y*4];
      *z++ = r; *z++ = g; *z++ = b; *z++ = a;
     }
   *breite=brneu; *hoehe=honeu;
  }
 else
  {
   fprintf(stderr,"Fehler: falscher Rotationswinkel %d\n",grad);
   free(pmemneu);
   return pmem;
  }
 free(pmem);
 return pmemneu;
}

uchar *mirror(int grad,uchar *pmem,int *breite,int *hoehe) //Spiegeln und drehen
{
 int br= *breite, ho= *hoehe, y;
 uchar r,g,b,a;
 int bytesprozeile=br*4;
 uchar *p0=pmem, *q0= &pmem[bytesprozeile-4], *p,*q;
 for(y=0; y<ho; y++,p0= &p0[bytesprozeile],q0= &q0[bytesprozeile])
  for(p=p0,q=q0; p<q; p+=4,q-=4)
   {
    r=p[0]; g=p[1]; b=p[2]; a=p[3];
    p[0]=q[0]; p[1]=q[1]; p[2]=q[2]; p[3]=q[3];
    q[0]=r; q[1]=g; q[2]=b; q[3]=a;
   }
 if(grad==0) return pmem;
 //TODO: fuer schnellere Version koennte man alles in einem Schritt machen
 return rotate(grad,pmem,breite,hoehe);
}
