/* makulong.c				letzte Aenderung: 8.5.1996 */
/* erzeugt die Datei "ulong.h"
linken an VAX:
  @LINK makulong,SYS$INPUT/OPT
SYS$SHARE:DECW$XLIBSHR/SHARE

History:
8.5.1996	Erstellung (RPf)
7.5.2015	Fehlendes int vor main() gesetzt, und "return 0;" am Schluss

*/

#include <stdio.h>
#include <stdlib.h>

int main(int argc,char *argv[])
{
 FILE *fp;
 char antw[20];
 if((fp=fopen("ulong.h","r"))!=NULL)
	{fclose(fp);
	 printf("'ulong.h' schon vorhanden.  Ueberschreiben ?");
	 scanf("%s",antw);
	 if(antw[0]!='j' && antw[0]!='J') exit(0);
	}
 fp=fopen("ulong.h","w");
 if(fp==NULL) {printf("Fehler beim Oeffnen von 'ulong.h'\n"); exit(0);}
 fprintf(fp,"#ifndef H_ULONG_H\n#define H_ULONG_H\n");
 if(argc==2) fprintf(fp,"#define %s 1\n",argv[1]);
 fprintf(fp,"#define BYTE char\n");
 fprintf(fp,"#define UBYTE unsigned char\n");
 if(sizeof(short)==2)
	{fprintf(fp,"#define WORD short\n");
	 fprintf(fp,"#define UWORD unsigned short\n");
	}
 else if(sizeof(int)==2)
	{fprintf(fp,"#define WORD int\n");
	 fprintf(fp,"#define UWORD unsigned int\n");
	}
 if(sizeof(long)==4)
	{fprintf(fp,"#define LONG long\n");
	 fprintf(fp,"#define ULONG unsigned long\n");
	}
 else if(sizeof(int)==4)
	{fprintf(fp,"#define LONG int\n");
	 fprintf(fp,"#define ULONG unsigned int\n");
	}
 if(sizeof(long)==8)
	{fprintf(fp,"#define INT64 long\n");
	 fprintf(fp,"#define UINT64 unsigned long\n");
	}
 else if(sizeof(long long)==8)
	{fprintf(fp,"#define INT64 long long\n");
	 fprintf(fp,"#define UINT64 unsigned long long\n");
	}
 fprintf(fp,"#define uint unsigned int\n");
 fprintf(fp,"#define ulong unsigned long\n");
 fprintf(fp,"#define BOOL int\n");
 fprintf(fp,"#ifndef bool\n#define bool int\n#endif\n");
 fprintf(fp,"typedef char *APTR;\ntypedef char *CPTR;\n\n");
 fprintf(fp,"#define CASE break;case\n#define DEFAULT break;default\n");
 fprintf(fp,"#endif\n");
 fclose(fp);
 return 0;
} /* end of main */

/** Beispiel einer erzeugten Datei:
#ifndef H_ULONG_H
#define H_ULONG_H
#define AMIGA 1
#define BYTE char
#define UBYTE char
#define WORD short
#define LONG long
#define UBYTE unsigned char
#define UWORD unsigned short
#define ULONG unsigned long
#define uint unsigned int
#define ulong unsigned long
#define BOOL int
typedef char *APTR;
typedef char *CPTR;

#define CASE break;case
#define DEFAULT break;default
#endif
**/
