/* da.cc			letzte Aenderung: 2.2.2015 */
#define VERSION "Version 0.1"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Arm Disassembler
 Dies ist Opensource Freeware

History:
17.1.2015	Erstellung (RP)
19.1.           Erweiterung zum auch Sprungdistanzen kontrollieren
26.1.      0.1  Bei LDR/STR Fehler korrigiert und Syntax angepasst,
                und bflag ausgewertet (auch bei LDM/STM)
2.2.            Bei unbekannte Befehlsgruppe ".word %d" anzeigen
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include "zeilenklasse.cc"
#include "labelklasse.cc"

/************************* Vordeklarationen ***************************/
void disassembler(FILE *fp1);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while((c= *s++))
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*********************** Textzeilen und Labels ************************/
static Label *labelliste=NULL;
static Textzeile *textzeilenliste=NULL;

Textzeile *neue_zeile()
{
 Textzeile *neu;
 neu=new Textzeile[1];
 if(textzeilenliste==NULL) textzeilenliste=neu;
 else textzeilenliste->append(neu);
 return neu;
}

void zeile_einfuegen(int i,Textzeile *neu)
{
 if(i==0)
  {
   neu->next=textzeilenliste;
   textzeilenliste=neu;
  }
 else textzeilenliste->insert(i-1,neu);
}

void label_in_liste_aufnehmen(int n)
{
 if(labelliste==NULL)
  {
   labelliste=new Label[1];
   labelliste->nr=n;
  }
 else labelliste->insertn(n);
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[200];
 FILE *fp1;
 int i,j=0,c;
 quellname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{
	 printf("Einfacher Arm-Disassembler %s\n",VERSION);
	 printf("Anwendung: da Quelle [>Ziel.s]\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Quellname:"); c=scanf("%s",quellname);}
 if((fp1=fopen(quellname,"rb"))==NULL)
   printf("Datei '%s' nicht gefunden\n",quellname);
 else
  {
   disassembler(fp1);
   fclose(fp1);
  }
 return 0;
}/* ende von main */

static char warnungtext[80],errortext[80];
static bool warnungflag=false, errorflag=false;

void warnung(int flag,const char *text)
{
 if(flag==0)
  {warnungflag=true; strcpy(warnungtext,text);}
 else
  {errorflag=true; strcpy(errortext,text);}
}

const char *bedingung(int c)
{
 const char *cond="??";
 switch(c)
      {case 0: cond="eq"; break;
       case 1: cond="ne"; break;
       case 2: cond="cs"; break;
       case 3: cond="cc"; break;
       case 4: cond="mi"; break;
       case 5: cond="pl"; break;
       case 6: cond="vs"; break;
       case 7: cond="vc"; break;
       case 8: cond="hi"; break;
       case 9: cond="ls"; break;
       case 10: cond="ge"; break;
       case 11: cond="lt"; break;
       case 12: cond="gt"; break;
       case 13: cond="le"; break;
       case 14: cond=""; break; //immer ausfuehren
       //case 15: cond="??"; break; //ungueltige Bedingung
      }
 return cond;
}

int shiftfeldauswerten(unsigned char *b,unsigned char *t)
{
 int feld,xx;
 char tt;
 feld = ((b[3]>>4)&0x0F) + ((b[2]&0x0F)<<4);
 tt = (feld>>1)&0x03; //0=links schieben, 1=rechts, 2=arithmetisch rechts, 3=rotieren rechts
 xx = (feld>>3)&0x1F;
 *t = tt;
 if(feld&1)
  {
   if(tt==3) warnung(0,"ror funktioniert hier eventuell nicht korrekt?");
   return -xx/2-1; //Wenn unterstes Bit gesetzt: Register in dem der Schiebewert steht.
                   //Als negativer Wert zurueckgeben zur Unterscheidung (fuer r0 -1, r1 -2, ...)
  }
 return xx; //sonst der Schiebewert selbst zurueckgeben.
}

void disassembler(FILE *fp)
{
 unsigned char b[4]; // 4 Byte Code
 int i,c,c1,c2;
 int zielregister,operand1,operand2;
 unsigned char z12flags; //Flags ob Zielregister, Operand1, Operand2 relevant
 int shift; //Schiebewert in Shiftfeld z.B. bei lsl, wenn negativ, dann ist es ein Register dessen Inhalt der Shiftwert ist
 unsigned char tt; //Shift-Methode in Shiftfeld
 const char *bef,*cond;
 bool lslspezflag;
 unsigned char sflag,immflag;
 int aktuellezeile=1;
 Textzeile *zeile;
 int zahl;
 while((c=getc(fp))!=EOF)
  {
   zeile=neue_zeile();
   b[3]=c;
   for(i=2;i>=0;--i)
    {
     b[i]=getc(fp);
    }
   zeile->print("0x");
   for(zahl=0,i=0;i<4;i++)
    {
     zeile->print("%02X",b[i]);
     zahl = (zahl<<8) + b[i];
    }

   zeile->print("    "); //Leerstellen zwischen Code und Befehl
   if((b[0]&0x0C)==0x00) //ist es ein Befehl der mov-Gruppe?
    {
     c1 = ((b[0]&1)<<3) + ((b[1]>>5)&0x07); //ja: genauer Befehl ermitteln
     z12flags=0x07; //Default: Zielregister und beide Operanden relevant
     switch(c1)
      {case 0: bef="and"; break;
       case 1: bef="eor"; break;
       case 2: bef="sub"; break;
       case 3: bef="rsb"; break;
       case 4: bef="add"; break;
       case 5: bef="adc"; break;
       case 6: bef="sbc"; break;
       case 7: bef="rsc"; break;
       case 8: bef="tst"; z12flags=0x06; break; //nur Operand1 und Operand2 relevant
       case 9: bef="teq"; z12flags=0x06; break;
       case 10: bef="cmp"; z12flags=0x06; break;
       case 11: bef="cmn"; z12flags=0x06; break;
       case 12: bef="orr"; break;
       case 13: bef="mov"; z12flags=0x05; break; //nur Zielregister und Operand2 relevant
       case 14: bef="bic"; break;
       case 15: default: bef="mvn"; z12flags=0x05;
      }
     c2 = (b[0]>>4)&0x0F; //Bedingung testen
     cond=bedingung(c2);
     sflag = (b[1]&0x10);
     immflag=(b[0]&0x02);
     if(c1==13 && immflag==0 && (b[2]>>4)==(b[3]&0x0F)) //Spezialfall lsl-Gruppe
      {
       shift=shiftfeldauswerten(b,&tt);
       if(tt==0) bef="lsl";
       else if(tt==1) bef="lsr";
       else if(tt==2) bef="asr";
       else if(tt==3) bef="ror";
       lslspezflag=true;
      }
     else lslspezflag=false;
     zeile->print("%s%s",bef,cond); //Beginn des Befehls
     if(sflag!=0)   //S-Flag gesetzt?
       zeile->print("s"); //ja: s an den Befehl anhaengen
     operand1 = b[1]&0x0F;
     zielregister = (b[2]>>4)&0x0F;
     if((z12flags&0x03)==0x03) //Zielregister und Operand1 relevant?
      {
       if(operand1==zielregister)
         zeile->print(" r%d",zielregister);
       else
	 zeile->print(" r%d, r%d",zielregister,operand1);
      }
     else if(z12flags&0x01) //Zielregister relevant?
        {
	 if(zielregister==13) zeile->print(" sp");
	 else if(zielregister==14) zeile->print(" lr");
	 else if(zielregister==15) zeile->print(" pc");
         else zeile->print(" r%d",zielregister);
	}
     else if(z12flags&0x02) //Operand1 relevant?
         zeile->print(" r%d",operand1);
     if(z12flags&0x04) //Operand2 relevant?
      {
       if((b[0]&0x02)!=0) //Immidiate-Flag gesetzt?
	{
	 operand2 = b[3] << (32-2*(b[2]&0x0F)); //ja: immediate-Zahl
	 if(operand2<16) zeile->print(", #%d", operand2);
	 else zeile->print(", #0x%X", operand2);
	}
       else
	{
	 operand2 = b[3]&0x0F; //nein: Register
	 if(lslspezflag) //Spezialfall lsl-Gruppe?
	  {
	   if(shift<0) zeile->print(", r%d", -shift-1);
	   else zeile->print(", #%d", shift);
	  }
	 else
	  {
	   shift=shiftfeldauswerten(b,&tt);
	   if(shift==0)
	     zeile->print(", r%d", operand2);
	   else if(tt==0)
	     zeile->print(", r%d<<%d", operand2, shift);
	   else if(tt==1)
	     zeile->print(", r%d>>%d", operand2, shift);
	   else if(tt==2)
	     zeile->print(", r%d>>%d (arithmetisch)", operand2, shift);
	   else //if(tt==3)
	     zeile->print(", r%d>>%d (rotieren)", operand2, shift);
	  }
	}
      }
     if(b[0]==0x00) //wahrscheinlich Daten
      {
       zeile->print("  @ .word %d",zahl); //.word als Kommentar anhaengen
      }
    } //Ende mov-Gruppe
   else if((b[0]&0x0E)==0x0A) //ist es ein Befehl der Branch-Gruppe
    {
     int sprungdistanz;
     c2 = (b[0]>>4)&0x0F; //Bedingung testen
     cond=bedingung(c2);
     if(b[0]&0x01) bef="bl"; else bef="b";
     sprungdistanz = (b[1]<<16)+(b[2]<<8)+b[3];
     if(b[1]&0x80) sprungdistanz -= 0x1000000;
     int labelnummer = aktuellezeile+2+sprungdistanz;
     if(labelnummer<1)
      {
       warnung(1,"Falsche Sprungdistanz");
       zeile->print("%s%s %d  @ Fehler",bef,cond,sprungdistanz);
      }
     else
      {
       label_in_liste_aufnehmen(labelnummer);
       zeile->print("%s%s L%d",bef,cond,labelnummer);
      }
    }
   else if((b[0]&0x0C)==0x04) //ist es ein Befehl der ldr/str-Gruppe?
    {
     int basisregister,offset;
     unsigned char uflag,bflag,wflag,offsetpreflag;
     char vorzeichen,by=' ';
     c2 = (b[0]>>4)&0x0F; //Bedingung testen
     cond=bedingung(c2);
     immflag=0x02-(b[0]&0x02); //invertiertes Immediate-Bit lesen
     offsetpreflag = b[0]&0x01;
     uflag = b[1]&0x80;
     bflag = b[1]&0x40;
     if(bflag) by='b';
     wflag = b[1]&0x20;
     if(b[1]&0x10) bef="ldr"; else bef="str";
     basisregister = b[1]&0x0F;
     zielregister  = (b[2]>>4);
     if(immflag)
      {
       offset = ((b[2]&0x0F)<<8)+b[3]; //der Offset selber
       if(uflag==0) offset = -offset;
       /** falsch verstandene Details
       if(wflag==0)
	{
	 zeile->print("%s%s r%d, [r%d,#%d]",bef,cond,zielregister,basisregister,offset);
	 if(basisregister==15)
	  {
	   int labelnummer = aktuellezeile+2+offset/4;
	   zeile->print("  @ L%d",labelnummer);
	   if(labelnummer<1)
	    {
	     warnung(1,"Falsche Sprungdistanz");
	     zeile->print("  @ Fehler");
	    }
	   else
	     label_in_liste_aufnehmen(labelnummer);
	  }
	}
       else if(offsetpreflag)
	{
	 if(uflag) zeile->print("%s%s ++r%d, [r%d,#%d]",bef,cond,zielregister,basisregister,offset);
	 else      zeile->print("%s%s --r%d, [r%d,#%d]",bef,cond,zielregister,basisregister,offset);
	}
       else
	{
	 if(uflag) zeile->print("%s%s r%d++, [r%d,#%d]",bef,cond,zielregister,basisregister,offset);
	 else      zeile->print("%s%s r%d--, [r%d,#%d]",bef,cond,zielregister,basisregister,offset);
	}
       **/
       if(offsetpreflag)
	{
	 if(wflag==0) //wflag ist nur relevant wenn offsetpreflag gesetzt
	  zeile->print("%s%s%c r%d, [r%d,#%d]",bef,cond,by,zielregister,basisregister,offset);
	 else
	  zeile->print("%s%s%c r%d, [r%d,#%d]!",bef,cond,by,zielregister,basisregister,offset);
	  //Das Ausrufezeichen markiert dass Wert ins basisregister zurueckgeschrieben wird
	 if(basisregister==15) //ist basisregister der PC?
	  {
	   int labelnummer = aktuellezeile+2+offset/4;
	   zeile->print("  @ L%d",labelnummer);
	   if(labelnummer<1)
	    {
	     warnung(1,"Falsche Sprungdistanz");
	     zeile->print("  @ Fehler");
	    }
	   else
	     label_in_liste_aufnehmen(labelnummer);
	  }
	}
       else //offsetpreflag nicht gesetzt, also Post-Increment (bzw Decrement wenn offset negativ)
	{
	 zeile->print("%s%s%c r%d, [r%d],#%d",bef,cond,by,zielregister,basisregister,offset);
	}
      }
     else
      {
       offset = b[3]&0x0F; //das Register, das den Offset enthaelt
       vorzeichen = uflag==0 ? '-' : '+';
       shift=shiftfeldauswerten(b,&tt);
       /** inoffizielle Syntax, fehlendes Post-Index
       if(shift==0)
	 zeile->print("%s%s r%d, [r%d%cr%d]",bef,cond,zielregister,basisregister,vorzeichen,offset);
       else if(tt==0)
	 zeile->print("%s%s r%d, [r%d%cr%d<<%d]",bef,cond,zielregister,basisregister,vorzeichen,offset,shift);
       else if(tt==1)
	 zeile->print("%s%s r%d, [r%d%cr%d>>%d]",bef,cond,zielregister,basisregister,vorzeichen,offset,shift);
       else if(tt==2)
	 zeile->print("%s%s r%d, [r%d%cr%d>>%d(arithmetisch)]",bef,cond,zielregister,basisregister,vorzeichen,offset,shift);
       else //if(tt==3)
	 zeile->print("%s%s r%d, [r%d%cr%d>>%d(rotieren)]",bef,cond,zielregister,basisregister,vorzeichen,offset,shift);
       **/
       if(offsetpreflag)
	{
	 char au=0;
	 if(wflag) au='!'; //wflag ist nur relevant wenn offsetpreflag gesetzt
	 if(shift==0)
	  zeile->print("%s%s%c r%d, [r%d,%cr%d]%c",
		       bef,cond,by,zielregister,basisregister,vorzeichen,offset,au);
	 else if(tt==0)
	  zeile->print("%s%s%c r%d, [r%d,%cr%d,lsl#%d]%c",
		       bef,cond,by,zielregister,basisregister,vorzeichen,offset,shift,au);
	 else if(tt==1)
	  zeile->print("%s%s%c r%d, [r%d,%cr%d,lsr#%d]%c",
		       bef,cond,by,zielregister,basisregister,vorzeichen,offset,shift,au);
	 else if(tt==2)
	  zeile->print("%s%s%c r%d, [r%d,%cr%d,asr#%d]%c",
		       bef,cond,by,zielregister,basisregister,vorzeichen,offset,shift,au);
	 else //if(tt==3)
	  zeile->print("%s%s%c r%d, [r%d,%cr%d,ror#%d]%c",
		       bef,cond,by,zielregister,basisregister,vorzeichen,offset,shift,au);
	}
       else //offsetpreflag nicht gesetzt, also Post-Indexing
	{
	 if(shift==0)
	  zeile->print("%s%s%c r%d, [r%d],%cr%d",bef,cond,by,zielregister,basisregister,vorzeichen,offset);
	 else if(tt==0)
	  zeile->print("%s%s%c r%d, [r%d],%cr%d,lsl#%d",bef,cond,by,zielregister,basisregister,vorzeichen,offset,shift);
	 else if(tt==1)
	  zeile->print("%s%s%c r%d, [r%d],%cr%d,lsr#%d",bef,cond,by,zielregister,basisregister,vorzeichen,offset,shift);
	 else if(tt==2)
	  zeile->print("%s%s%c r%d, [r%d],%cr%d,asr#%d",bef,cond,by,zielregister,basisregister,vorzeichen,offset,shift);
	 else //if(tt==3)
	  zeile->print("%s%s%c r%d, [r%d],%cr%d,ror#%d",bef,cond,by,zielregister,basisregister,vorzeichen,offset,shift);
	}
      }
    } //ende ldr/str-Gruppe
   else if((b[0]&0x0E)==0x08) //ist es ein Befehl der ldm/stm-Gruppe?
    {
     int i,basisregister,maske,regmaske;
     unsigned char uflag,bflag,wflag,offsetpreflag;
     char reglist[80]; //z.B. "r0,r2-r4,lr"
     char *s;
     c2 = (b[0]>>4)&0x0F; //Bedingung testen
     cond=bedingung(c2);
     offsetpreflag = b[0]&0x01;
     uflag = b[1]&0x80;
     bflag = b[1]&0x40;
     wflag = b[1]&0x20;
     basisregister = b[1]&0x0F;
     if(basisregister==13 && uflag==0 && offsetpreflag!=0 && wflag!=0) bef="push";
     else if(basisregister==13 && uflag!=0 && offsetpreflag==0 && wflag!=0) bef="pop";
     else {if(b[1]&0x10) bef="ldm"; else bef="stm";}
     if(bflag) zeile->print("%s%sb ",bef,cond);
     else      zeile->print("%s%s ",bef,cond);
     if(bef[0]!='p') zeile->print("r%d, ",basisregister);
     regmaske=(b[2]<<8)+b[3];
     for(s=reglist,maske=0x01,i=0;i<16;maske<<=1,i++)
      {
       if(regmaske&maske)
	{
	 if(i==15) {*s++ = 'p'; *s++ = 'c';}
	 else if(i==14) {*s++ = 'l'; *s++ = 'r';}
	 else if(i==13) {*s++ = 's'; *s++ = 'p';}
	 else
	  {
	   *s++ = 'r';
	   if(i>=10) *s++ = '1';
	   *s++ = '0'+i%10;
	  }
	 *s++ = ',';
	}
      }
     if(s!=reglist) *--s=0;
     else *s=0;
     zeile->print("{%s}",reglist);
    } //ende ldm/stm-Gruppe
   else
    {
     zeile->print(".word %d  @ unbekannte Befehlsgruppe",zahl);
    }
   if(warnungflag)
    {
     printf("Warnung: %s\n",warnungtext);
     warnungflag=false;
    }
   if(errorflag)
    {
     printf("Error: %s\n",errortext);
     errorflag=false;
    }
   aktuellezeile++;
  }
 if(labelliste!=NULL)
  {
   Label *p1;
   for(p1=labelliste;p1!=NULL;p1=p1->next)
    {
     zeile=new Textzeile[1];
     sprintf(zeile->s,"            L%d:",p1->nr);
     zeile_einfuegen(p1->nr-1,zeile);
    }
  }
 for(zeile=textzeilenliste;zeile!=NULL;zeile=zeile->next)
  {
   printf("%s\n",&(*zeile)[0]);
  }
}
