/* undump.c			letzte Aenderung: 11.1.2013 */
static char *VERSION="2.0";
/*

History:
11.1.2013       Version 2.0  Neue Version aus undump1.c+umcop.c (Rolf Pfister)

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define MAXARG 2

/************************ Vordeklarationen *******************************/
void undump(FILE *fp,FILE *fp2);
char *machgross(char *);

/*************************** kleinkram ***********************************/
#define CR 0x0D
#define LF 0x0A
#define getline mygetline
#define index myindex

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

int index(const char *s1,const char *s2)
{	             /* Sucht den String s2 innerhalb von s1           */
 int i,c;	     /* und gibt Position zurueck (nicht gefunden: -1) */
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

/******************* Hauptprogramm ***************************************/
void usage()
{
 printf("undump Version %s\n",VERSION);
 printf("Anwendung: undump Name.dump Name.img\n");
 // printf("Anwendung: undump Name.dump [Name.img] [-Flags]\n");
 // printf("  Flags:\n");
 // printf("      A = \n");
 exit(0);
}

static char argflag['Z'+1];
setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

int main(int argc,char *argv[])
{
 FILE *fp,*fp2;
 int i,j;
 char name1[80],name2[80];
 for(name1[0]=name2[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setflags(argv[i]);
   else switch(j++)
        {case 1:strcpy(name1,argv[i]); break;
         case 2:strcpy(name2,argv[i]); break;
        }
 if(j>MAXARG+1 || name1[0]=='?' || argflag['?']) usage();
 if(name1[0]==0) {printf("Quelldatei:"); scanf("%s",name1);}
 if(name1[0]=='?') usage();
 if(name2[0]==0) {printf("Zieldatei:"); scanf("%s",name2);}
 if(!(fp=fopen(name1,"r")))
	{printf("'%s' nicht gefunden\n",name1); exit(0);}
 if(!(fp2=fopen(name2,"wb")))
	{printf("kann '%s' nicht ffnen\n",name2); fclose(fp); exit(0);}
 else undump(fp,fp2);
 fclose(fp); fclose(fp2);
 return 0;
}

void undump(FILE *fp,FILE *fp2)
{
 int c,i,j;
 long zahl,adresse=0,neueadresse;
 char zeile[120];
 while(getline(fp,zeile,120))
  {
   if(strncmp(zeile,"0x",2)==0)
    {
     sscanf(&zeile[2],"%lx",&zahl);
     fputc(zahl&0xFF,fp2);
     fputc((zahl>>8)&0xFF,fp2);
     fputc((zahl>>16)&0xFF,fp2);
     fputc((zahl>>24)&0xFF,fp2);
    }
   else if(isxdigit(zeile[0]) && (i=index(zeile,": "))>0 && i<10)
    {
     sscanf(zeile,"%lx",&neueadresse);
     if(neueadresse>adresse)
      {
       fprintf(stderr,"Luecke wird mit Nullen gefuellt.\n");
       while(neueadresse>adresse) {fputc(0,fp2); adresse++;}
      }
     if(neueadresse!=adresse)
      fprintf(stderr,"Fehler mit Adresse: 0x%lX != 0x%lX\n",neueadresse,adresse);
     while(zeile[++i]==' ') ;
     for(j=0; j<8 && isxdigit(zeile[i]) && isxdigit(zeile[i+1]); i+=5,j++)
      {
       sscanf(&zeile[i],"%lx",&zahl);
       if(isxdigit(zeile[i+2])) {fputc((zahl>>8)&0xFF,fp2); adresse++;}
       fputc(zahl&0xFF,fp2); adresse++;
       if(zeile[i+4]!=' ') break;
      }
    }
   else if(zeile[0]!=' ')
    {
     fprintf(stderr,"ignorierte Zeile: \"%s\"\n",zeile);
    }
  }
}
