/* nachfilenamefragen.h   aus xtekplot1.cc kopierte Version, stark angepasst

Fast am Ende von otekplot1.h einfuegen:
#include "nachfilenamefragen.h"

*/

#pragma once
#include <sys/types.h>
#include <sys/stat.h>

#ifdef _WIN32
#define NO_DIRENT_H
#else
#include <dirent.h>
#endif

#define CASE break;case
#define DEFAULT break;default

/********************** tekplot1xtras.cc eingefuegt **********************/
/* kopiert von  tekplot1xtras.cc Version vom 12.12.2008

 Enthlt Routinen die Systemunabhngig sind, und somit von allen
 Tekplotvarianten benutzt werden knnen.
*/

const char *strcheck(const char *s,const char *t)
{
 int c;
 while((c= *t++)!=0) if(*s++ != c) return NULL;
 return s;
}

int enthaelt(const char *s,const char *t)
{ // Testet ob String t in s enthalten ist
 int c;
 const char *s2,*t2;
 while((c= *s++)!=0)
  {if(c== *t)
    {for(s2=s,t2= &t[1]; (c= *t2++)!=0 && c== *s2++;) {}
     if(c==0) return 1;
    }
  }
 return 0;
}

/* in otekplot1.h gibts noch kein ifillcircle() und idrawcircle()
void fillcircle(double x,double y,double r1,double r2)
{
 int ix,iy,ir1,ir2;
 haupt.koorduser2pix(x,y,&ix,&iy);
 haupt.deltakoorduser2pix(r1,r2,&ir1,&ir2);
 ifillcircle(ix,iy,ir1,ir2);
}

void drawcircle(double x,double y,double r1,double r2)
{
 int ix,iy,ir1,ir2;
 haupt.koorduser2pix(x,y,&ix,&iy);
 haupt.deltakoorduser2pix(r1,r2,&ir1,&ir2);
 idrawcircle(ix,iy,ir1,ir2);
}
*/

long idfix(double x) {return long((x>=0.)?x+0.5:x-0.5);}

/* in otekplot1.h gibts noch kein changemenu()
int menu_switch(long id,long *ids,int k,int max,char **text,int k1,int k2)
{
 int i,c; char *p;
 if(!(*ids)) {getmenuids(id,ids,max); if(!(*ids)) return -1;}
 if(k2==0) k2=max;
 for(i=0;i<k2;i++)
   {p = *text++;
    if(i>=k1 && *p=='%')
      {c=p[1];
       p[1]=(i==k)?toupper(c):tolower(c);
       changemenu(ids[i],p);
      }
   }
 return k;
}
*/
/****************** Ende eingefuegtes tekplot1xtras.cc *******************/

void iplot(int ix,int iy,int pen)
{ /* provisorisch */
 double x,y;
 koordpix2user(ix,iy,&x,&y);
 q2plot(x,y,pen);
}
void moveto(int x,int y) {iplot(x,y,PENUP);}
void lineto(int x,int y) {iplot(x,y,PENDOWN);}

/************************ Eingabefunktionen ******************************/
const int MAXP=MAX_PFADNAME_LAENGE; //maximale Laenge eines Pfades
const int MAXD=MAX_DATEINAME_LAENGE; //maximale Laenge eines Dateinamens
#define MAXS 80

#define PIXPROZEILE (PIXPROBUCHST_Y*5/4)
#define PIXYRAND (PIXPROBUCHST_Y/3)
#define PIXXRAND (PIXPROBUCHST_X/4)

int ngx_posx=100, ngx_posy=120; //Position eines Requester-Subfensters
// X-Versionen wurden in eigenem Fenster gezeichnet,
// jetzt als Sub-Fenster muessen obige Werte bei allen Zeichnen-Operationen
// beruecksichtigt werden.

static uint32 req_hintergrundfarbe=0xFFB4B4; //z.B. hellblau  (0xBBGGRR)
static uint32 req_vordergrundfarbe=0xC80000; //z.B. dunkelblau

/*
void ifillbox_ngx(int x1,int y1,int x2,int y2)
{ifillbox(x1+ngx_posx, y1+ngx_posy, x2+ngx_posx, y2+ngx_posy);}
*/
void idrawbox_ngx(int x1,int y1,int x2,int y2)
{idrawbox(x1+ngx_posx, y1+ngx_posy, x2+ngx_posx, y2+ngx_posy);}

void ischrift_ngx(int x,int y,const char *text)
{requfont->ischrift(x+ngx_posx, y+ngx_posy, text);}

void idrawline(int x1,int y1,int x2,int y2)
{moveto(x1, y1); lineto(x2, y2);}

void idrawline_ngx(int x1,int y1,int x2,int y2)
{moveto(x1+ngx_posx, y1+ngx_posy); lineto(x2+ngx_posx, y2+ngx_posy);}

void myXDrawRectangle(int x, int y, int breite, int hoehe)
{
 int x1=x+ngx_posx, y1=y+ngx_posy;
 int x2=x1+breite, y2=y1+hoehe;
 idrawbox(x1,y1,x2,y2);
}

void myXFillRectangle(int x, int y, int breite, int hoehe)
{
 int x1=x+ngx_posx, y1=y+ngx_posy;
 int x2=x1+breite, y2=y1+hoehe;
 ifillbox(x1,y1,x2,y2);
}

struct XPoint {
 int x,y;
 XPoint() {x=y=0;}
};

#define CoordModeOrigin   1 //absolute Werte
#define CoordModePrevious 2 //relative Werte

void myXDrawLines(XPoint *points, int num, int mode)
{
 XPoint p1,p2;
 p1=p2=points[0];
 for(int i=1;i<num;i++)
  {
   if(mode==CoordModeOrigin) p2=points[i];
   else {p2.x += points[i].x; p2.y += points[i].y;}
   idrawline_ngx(p1.x, p1.y, p2.x, p2.y);
   p1=p2;
  }
}

void myXDrawImageString(int x0, int y0, const char *txt, int txtsize)
{
 char *text = new char[txtsize+1];
 mystrncpy(text,txt,txtsize+1);
 requfont->ischrift(x0+ngx_posx, y0+ngx_posy, text);
 delete[] text;
}

class gadgetstring
{
public:
 char s[MAXP],*s0; //MAXP um ganze Pfade zu speichern
                   //MAXS wuerde sonst meistens reichen
 int offset,max;
 gadgetstring() {offset=0; s0=s; max=MAXP;}
 int inc(int);
 void set(char *t);
};

int gadgetstring::inc(int n)
{
 if((offset+=n)<0) offset=0;
 s0 = &s[offset];
 return offset;
}

void gadgetstring::set(char *t)
{
 int c;
 offset=0; s0=s;
 for(int i=0;++i<max && (c= *t++)!=0;) *s0++ = c;
 *s0=0;
 s0=s;
}

typedef const char *CONSTAPTR;
typedef const char *CONSTCPTR;

typedef char *APTR; //muss unbedingt (char *) sein und nicht (const char *)!
struct Gadget2;
struct NewGadget {
int32   LeftEdge,TopEdge,Width,Height;
CONSTCPTR GadgetText;
struct TextAttr *TextAttr;
uint32  GadgetID;
uint32  Flags;	//PLACETEXT_
APTR    VisualInfo,UserData;
Gadget2 *Gadget;
 void putUserData(const char *data) {
  //int n=strlen(data)+1; UserData=new char[n]; strncpy(UserData,data,n);//falsch!!!!
  UserData = const_cast<char*>(data);
 }
};

class Requester { //provi.
public:
 int typ,nrpath,nrfile;
 NewGadget *nglist;
 Gadget2 *gglist;
 Requester() {typ=0;}
};
static Requester aktiver_requester;
static Gadget2 *tek_gadgetliste=NULL;

#define PLACETEXT_LEFT	1
#define PLACETEXT_RIGHT 2
#define PLACETEXT_ABOVE 4
#define PLACETEXT_BELOW 8
#define PLACETEXT_IN	16
#define PLACETEXT_NONE	15
#define PLACETEXT_AUSWAHL 17

#define GADTYP_STRING  1
#define GADTYP_IN      2
#define GADTYP_AUSWAHL 17
int get_ngtyp(int ngflags)
{
 switch(ngflags)
   {case PLACETEXT_AUSWAHL: return GADTYP_AUSWAHL;
    case PLACETEXT_IN: return GADTYP_IN;
   }
 return GADTYP_STRING;
}

#define REQTYP_INPUTREQUESTER 1
#define REQTYP_AUSWAHL_MASK 0x11
#define REQTYP_AUSWAHL_NO_FILTER 0x10
#define REQTYP_AUSWAHL_FILTER 0x11
inline bool IS_REQTYP_AUSWAHL(int typ)
{
 return ((typ&REQTYP_AUSWAHL_MASK) >= REQTYP_AUSWAHL_NO_FILTER);
}

//static int DELL=0x7F, DELR=0x08;
static int DELL=0x08, DELR=0x7F;
#define MAXGADS 20
static struct NewGadget newgadgets[MAXGADS+2];
static gadgetstring gadgetstr[MAXGADS];
//static int reqhigrund,reqfogrund;

char *getfileliste(const char *pfad,const char *filter,int maxz=40);
static char *sortieren(char *liste);

struct Gadget2 { //provi.
Gadget2 *NextGadget;
int32	LeftEdge,TopEdge,Width,Height,Flags,GadgetType;
//APTR	GadgetText;
CONSTAPTR	GadgetText;
int32	GadgetID;
char**	texte;
int32	ntexte,itexte,maxzeil,dy;
//gadgetstring *gast;//um gadgetstr[] zu wegoptimieren
};

/********************* globale Variablen **************************/
static char *g_filter=NULL;

/*** Vordeklarationen (fuer Zeichensatz) ***/
void zeicheninsert(int c,int einpos,char *str,int max=MAXS);
int xrequester_start(int n,NewGadget *,int gadhoehe,int gadabst,int br,int ho,
		     const char *titel="Input-Requester",
		     int reqtyp=REQTYP_INPUTREQUESTER);
int key_from_scancode(long scancode);
/*** Ende Vordeklarationen ***/

/************************* neuer Kleinkram *******************************/
inline bool istinnerhalb(int x,int x1,int x2)
{
 return (x2>x1)?(x>=x1 && x<=x2):(x>=x2 && x<=x1);
}

inline bool istinnerhalb(int x,int y,int x1,int y1,int x2,int y2)
{
 return istinnerhalb(x,x1,x2) && istinnerhalb(y,y1,y2);
}

void stradd(const char *s,const char *t,char *z)	/*  s + t --> z */
{
 char c;
 while((c = *s++)!=0) {*z++ = c;}
 while((*z++ = *t++)!=0)  {}
}

void strjoin(const char *s1,int c2,const char *s3,char *ziel,int max)
{
 char c0=0,c;
 while(--max>0 && (c = *s1++)) *ziel++ = c0 = c;
 if(c0!=c2 && --max>0) *ziel++ = c2;
 while(--max>0 && (*ziel++ = *s3++))  ;
 if(max<=0) *ziel=0;
}

int strncmpgross(const char *s,const char *g,int n)
{
 int c,cg;
 while(*s==' ') s++;
 while(--n>=0 && (cg= *g++) && (c= *s++))
   {if((c=toupper(c))!=cg) return c-cg;
   }
 return 0;
}

int anzahlzeilen(const char *s)
{
 int i,c;
 if(s==NULL || *s==0) return 0;
 for(i=1;(c= *s++)!=0;)
   if(c=='\n') i++;
 --s; if(*--s=='\n') --i;
 return i;
}

char *strf(const char *cstr,long p1)
{
 char *str=new char[80];
 sprintf(str,cstr,p1);
 return str;
}

int index(const char *s1,const char *s2) /* Sucht den String s2 innerhalb von s1 und  */
{			 /* gibt die Position zurueck (nicht gefunden = -1)*/
 int i,c;
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
	  {for(p1=s1,p2=s2; (c= *++p2)!=0;)
	     if(*p1++!=c) break; /* noch nicht gefunden */
	   if(c==0) break; /* gefunden */
	  }
	}
 return i;
}

int index2(const char *s1,const char *s2) /* wie index(), sucht aber nur bis '\n' in s1 */
{
 int i,c;
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0 || c=='\n') return -1; /* nicht gefunden */
	 if(c== *s2)
	  {for(p1=s1,p2=s2; (c= *++p2)!=0;)
	     if(*p1++!=c) break; /* noch nicht gefunden */
	   if(c==0) break; /* gefunden */
	  }
	}
 return i;
}

void strcpybisx(char *ziel,const char *von,int max)
{
 char *t=ziel; int c,j=0;
 while((c= *von++) && --max>0) {*t++ = c; j++;}
 --t;
 while(j>0 && isdigit(*t)) {--t; --j;} //hintere Zahl weglassen
 while(j>0 && *t==' ') {--t; --j;} //hinterste Leerstellen weglassen
 if(j>5 && strncmp(t-4,"(dir)",5)==0) {t-=5; j-=5;} //(dir) weglassen
 else if(j>5 && strncmp(t-4,"(lnk)",5)==0) {t-=5; j-=5;} //(lnk) weglassen
 while(j>0 && *t==' ') {--t; --j;} //hinterste Leerstellen weglassen
 t++;
 *t=0;
}

inline bool ISTPUNKTPUNKT(const char *s)
{
 return (*s=='.' && s[1]=='.' && s[2]==0); //schneller als strcmp(s,"..")==0
}

int maxwert(int a,int b) {return (a>b) ? a : b;}

int minwert(int a,int b) {return (a<b) ? a : b;}

int minmax(int x,int ug,int og)
{
 if(x<ug) return ug;
 if(x>og) return og;
 return x;
}

char *strf(char *cstr,long p1)
{
 char *str=new char[80];
 sprintf(str,cstr,p1);
 return str;
}
/************************* :neuer Kleinkram ******************************/

static int cursor_onoff=0; //zusatzliches Flag fuer eingabekursor()
#define CURSOR_ON 1
#define CURSOR_OFF 2

/************************ Vordeklarationen: *****************************/
void ngxdrawauswahlbox(Tekplot* tek,NewGadget *ng);
int ngnextmark(Tekplot* tek,NewGadget *ng,int inc);
int ngnextdir(Tekplot* tek,NewGadget *ng,int eingabepos,int undo=0);
int ngnewdir(Tekplot* tek,NewGadget *ng,int j,char c1=0);
void ngnewpath(NewGadget *ng);
int neuerdateitext(Tekplot* tek,int gadhoehe,
		   NewGadget *ng,int eingabepos,int n,int x= -1,int y= -1);
void fileliste_aktualisieren(Gadget2 *gg,char *pfad);
void gadgets_anschreiben(Tekplot* tek,int n,int gadhoehe,int n0=0,int fokus= -1);
/*** Ende Vordeklarationen ***/

#define REQHIGRUND 1
#define REQFOGRUND 2
//void color_reqhigrund() {rgbcolor(200,200,255);} //hellblauer Hintergrund
void color_reqhigrund() {rgbcolor(200,200,200);} //hellgrauer Hintergrund
//void color_reqhigrund() {rgbcolor(255,200,200);} //test: hellrot
void color_reqfogrund() {rgbcolor( 0, 0, 200);} //dunkelblaue Rahmen
void color_reqschrift() {rgbcolor( 0, 0, 0);} //Schriftfarbe schwarz
void color_req(int n)
{
 if(n==REQHIGRUND)      color_reqhigrund();
 else if(n==REQFOGRUND) color_reqfogrund();
 else color_reqschrift();
}

void doppelbox(bool flg,int fogrund,int higrund,int x1,int y1,int br,int ho)
{
 //printf("doppelbox()\n");//test
 //rgbcolor(255,0,0);//test rot
 idrawbox_ngx(x1,y1,x1+br,y1+ho);
 if(!flg) color_req(higrund);
 //int da3=haupt.da1;//test
 int da3=3;
 idrawbox_ngx(x1+da3, y1+da3, x1+br-da3, y1+ho-da3);
 if(!flg) color_req(fogrund);
}

void ngxdrawstr(Tekplot* tek,NewGadget *ng,const char *text,int dy,
		int flag,int fokusflg=0)
{
 char *txt,*s;
 int c,max;
 txt=new char[max=strlen(text)+3];
 for(s=txt;(c= *text++)!=0;)
	*s++ = (c==0x09) ? ' ' : c; //Tabulator als Leerzeichen darstellen
 if(flag!=2) {*s++ =' '; *s++ =' ';}
 *s=0;
#ifdef MITUMLAUTEN
 utf8_to_isolatin1(txt,txt,max);
#endif
 c=strlen(txt);
 if(c>(max=gadgetstr[ng->GadgetID].max+1)) c=max;
 tek->zwert_decrement();
 color_reqhigrund();
 myXFillRectangle(ng->LeftEdge+1,ng->TopEdge+1, ng->Width-1,ng->Height-1);
 tek->zwert_decrement();
 color_reqfogrund();
 //printf("Testpunkt in ngxdrawstr() txt='%s' c=%d\n",txt,c);//test
 if(flag==2) //PLACETEXT_LEFT
  {int x=ng->LeftEdge-PIXPROBUCHST_X*c;
   if(x<0) x=0;
   myXDrawImageString(x, ng->TopEdge+PIXPROZEILE+dy, txt, c);
  }
 else
  {
   myXDrawImageString(ng->LeftEdge+PIXPROBUCHST_X/2, ng->TopEdge+PIXPROZEILE+dy, txt, c);
   if(flag || fokusflg)
    doppelbox(fokusflg,REQFOGRUND,REQHIGRUND, ng->LeftEdge, ng->TopEdge, ng->Width, ng->Height);
  }
 delete[] txt;
}

void fileliste_ins_gadget_kopieren(const char *liste,Gadget2 *gg)
{
 int i,n;
 char *s, *str;
 if((n=strlen(liste)+1) < 8) n=8; //genug Platz fuer ".." reservieren
 str=new char[n];
 if((n=anzahlzeilen(liste)) < 1)
   {n=1; *str=str[1]='.'; str[2]=0;} //schneller als strcpy(str,"..")
 else strcpy(str,liste);
 if(gg->ntexte > 1) {delete[] gg->texte[0]; delete[] gg->texte;}
 gg->texte=new char*[n];
 for(s=str,i=0;i<n;i++)
   {gg->texte[i]=s;
    while(*s && *s!='\n') s++;
    *s++ = 0;
   }
 gg->ntexte=n; gg->itexte=0;
 //for(i=0;i<n;i++) printf("gg->texte[%d]='%s'\n",i,gg->texte[i]);//test
}

void machgadget(NewGadget *ng,int maxzeilen)
{
// erzeuge und vervollstaendige Gadget-Struktur
 Gadget2 *gg;
 ng->Gadget=gg=new Gadget2[1];
 gg->NextGadget=tek_gadgetliste;//als erstes in bisherige Kette einfuegen
 tek_gadgetliste=gg;
 gg->LeftEdge=ng->LeftEdge;
 gg->TopEdge=ng->TopEdge;
 gg->Width=ng->Width;
 gg->Height=ng->Height;
 gg->Flags=0;//provi.
 gg->GadgetType=(ng->Flags & 0xFFFF);//provi.
 gg->GadgetText=ng->GadgetText;
 gg->GadgetID=ng->GadgetID;
 gg->ntexte=gg->itexte=0;//Zaehler fuer aktuelles texte[i]
 if(gg->GadgetType==GADTYP_AUSWAHL)
   {fileliste_ins_gadget_kopieren(ng->GadgetText,gg);
    ng->Width += PIXPROBUCHST_X*3/2;//etwas breiter fuer Schieber
   }
 else
   {gg->texte=new char*[1];
    gg->texte[0]=ng->UserData;
    gg->ntexte=1;
   }
 gg->maxzeil=maxzeilen;
 gg->dy=PIXPROZEILE;
}

int ngnextdir(Tekplot *tek,NewGadget *ng,int eingabepos,int undo)
{
// Wenn ein Directory markiert ist dann in dieses wechseln.
 static char olddirname[MAXP]; static int olddirflag=0;
 char dirname[MAXP],str[MAXP];
 const char *s,*z;
 Gadget2 *gg=ng->Gadget;
 int i=gg->itexte+eingabepos,j,diskflag=0;
 if(undo)
  {if(olddirflag==0) return 0;//kein undo-Pfad eingetragen
   strcpy(dirname,olddirname); olddirflag=0;
   z="\000";
  }
 else
  {if(eingabepos<0 || i>=gg->ntexte) return 0;//kein gueltiger Eintrag markiert
   s=gg->texte[i];
   if(ISTPUNKTPUNKT(s)) {return ngnewdir(tek,ng,0,'P');}
   diskflag=(index(s,"(disk)") >= 0);
   if(index(s," (dir) ") < 0 && index(s," (lnk) ") < 0 && !diskflag)
		return 0;//Eintrag ist kein Directory und keine Disk
   strcpybisx(dirname,gg->texte[i],MAXP);
   z=gadgetstr[aktiver_requester.nrpath].s;
   strcpy(olddirname,z); olddirflag=1;
  }
 if(diskflag)
   {if((s=getenv(dirname))==NULL || *s==0)
      {if(strcmp(dirname,"ROOT")==0) s="/";
       else if(strcmp(dirname,"CDROM")==0) s="/cdrom";
       else s=dirname;
      }
    strcpy(str,s);
   }
 else if(*z==0) strcpy(str,dirname);
 else strjoin(z,'/',dirname,str,MAXP);
 gadgetstr[aktiver_requester.nrpath].set(str);
 //printf("ngnextdir() --> neuer Pfad: '%s'\n", gadgetstr[aktiver_requester.nrpath].s);//test
 fileliste_aktualisieren(gg,str);
 return 1;//erfolgreich in neues Dir. gewechselt
}

int ngnewdir(Tekplot *tek,NewGadget *ng,int j,char c1)
{
 int erfolg=0,c;
 const char *s;
 char c0=c1, str[MAXP],*t,*t0;
 if(c0==0)
   {s=ng[j].GadgetText;
    while(*s && *s==' ') s++; //suche ersten Buchstabe
    c1 = *s;
    ng= &ng[aktiver_requester.nrpath-1];
   }
 if(c1=='P') //wurde "Parent" angeklickt ?
  {s=gadgetstr[aktiver_requester.nrpath].s; //bisheriges Verzeichnis
   if((*s==0 || (*s=='.' && s[1]==0)) && c0==0)
     {//auf uebergeordneten Pfad mit unbekanntem Namen wechseln
      system("pwd >pwd.tmp");//provi.
      FILE *fp=fopen("pwd.tmp","r");
      if(fp==NULL) strcpy(str,"../x");
      else
        {int i;
	 for(i=0; i<MAXP-1 && (c=getc(fp))!=EOF && c>=' ';)  str[i++]=c;
	 str[i]=0;
	 fclose(fp);
	}
      system("rm pwd.tmp");
      s=str;
     }
   for(t0=t=str; (c = *t = *s++)!=0; t++) if(c=='/') t0=t;
   if(*t0=='/')
      {*t0=0; //Pfad kuerzen
       if(t0==str) {*t0++ ='/'; *t0=0;}//Wurzelverzeichnis aber immer behalten
      }
   else
       *t0=0; //Pfad kuerzen (leerer Pfad bedeutet aktuelles Verzeichnis)
   //printf("ngnewdir() neues Verzeichnis: '%s'\n",str);//test
   gadgetstr[aktiver_requester.nrpath].set(str); //neues Verzeichnis setzen
   fileliste_aktualisieren(ng->Gadget,str);
   erfolg=1;
  }
 else if(c1=='D') //wurde "Disks" angeklickt ?
  {const char *diskliste="ROOT        (disk)\n\
HOME        (disk)\nPWD         (disk)\nCDROM       (disk)";//provi.
   strcpy(str,"$DISKS");
   gadgetstr[aktiver_requester.nrpath].set(str); //neues Verzeichnis setzen
   fileliste_ins_gadget_kopieren(diskliste,ng->Gadget);
   erfolg=1;
  }
 else
  printf("Error in ngnewdir(): c1=0x%02X='%c' GadgetText='%s'\n",
	 c1, (c1>=' ' && c1<='z')?c1:' ', ng->GadgetText);
 return erfolg;
}

void ngnewpath(NewGadget *ng)
{
 char *str=gadgetstr[aktiver_requester.nrpath].s; //neues Verzeichnis
 fileliste_aktualisieren(ng[aktiver_requester.nrpath-1].Gadget,str);
}

//neue Klasse fuer Anpassung an OpenGL:
class Xrequester {
 Tekplot* tek;
 int nn;
 NewGadget *newgadgets;
 int gadhoehe, gadabst;
 int breite, hoehe;
 const char *titel;
 int reqtyp;
 NewGadget *cur_ng=NULL;
 int cur_x= -1, cur_y= -1, cur_einpos= -1;
public:
 int zeichnen(Tekplot* tek,int nn,NewGadget *newgadgets,int gadhoehe,int gadabst,
		     int breite,int hoehe,const char *titel,int reqtyp) {
  this->tek = tek;
  this->nn = nn;
  this->newgadgets = newgadgets;
  this->gadhoehe = gadhoehe;
  this->gadabst = gadabst;
  this->breite = breite;
  this->hoehe = hoehe;
  this->titel = titel;
  this->reqtyp = reqtyp;
  cur_x = cur_y = cur_einpos= -1; cur_ng=NULL;
  return zeichnen();
 }
 int zeichnen();
 void eingabekursor_set(NewGadget *ng, int x= -1, int y= -1, int einpos= -1);
 int eingabekursor(NewGadget *ng, int x, int y, int einpos);
};
static Xrequester xrequ;

int ngnextmark(Tekplot *tek,NewGadget *ng,int inc)
{
 int i=ng->Gadget->itexte+inc, delta;
 if(i<0) i=0;
 else if(i > ng->Gadget->ntexte - ng->Gadget->maxzeil)
	 i = ng->Gadget->ntexte - ng->Gadget->maxzeil;
 delta = i - ng->Gadget->itexte;
 if(delta!=0)
   {ng->Gadget->itexte=i;
    //ngxdrawauswahlbox(tek,ng); //TODO
    xrequ.zeichnen();
   }
 return delta;
}

int neuerdateitext(Tekplot *tek,int gadhoehe, NewGadget *ng,int eingabepos,int n,int x,int y)
{
 Gadget2 *gg=ng->Gadget;
 int i=gg->itexte+eingabepos; if(i>=gg->ntexte) i=gg->ntexte-1;
 //printf("neuerdateitext() '%s' --> ",gg->texte[i]);//test
 strcpybisx(gadgetstr[aktiver_requester.nrfile].s,gg->texte[i],MAXS);
 //printf("'%s'\n",gadgetstr[aktiver_requester.nrfile].s);//test
 xrequ.eingabekursor_set(ng,x,y);
 int einpos = xrequ.zeichnen();
 return einpos;
}

#define NEEDS_MAUSBEWEGUNG (-5)

class Schiebebalken {
 Gadget2 *gg;
 int maxy,maxy2,hoehe,y0,yoffset;
 double proz,dy;
public:
 int rr,a4,a5;
 Schiebebalken() {proz=1.00; maxy=hoehe=1; maxy2=0; rr=0;
		  a4=a5=0; dy=0.0; yoffset=0;}
 int ineu(int dy);
 void reset() {rr=0;}
 void calc(Gadget2* g,int *phoehe,int *py0);
};
static Schiebebalken schiebebalken;

void Schiebebalken::calc(Gadget2* g,int *phoehe,int *py0)
{
 gg=g;
 int i=gg->ntexte, minimale_hoehe=gg->dy/2;
 maxy=gg->Height-2*gg->dy; maxy2=maxy/2;
 dy=maxy/(double)i;
 if(gg->maxzeil >= i) proz=1.00; //1.00=100%
 else proz=gg->maxzeil/(double)i;
 if((hoehe=idfix(maxy*proz)) < minimale_hoehe) hoehe=minimale_hoehe;
 *phoehe=hoehe;
 *py0=int(gg->itexte*dy+0.5);
 a5=gg->TopEdge+(*py0);
 a4=a5+hoehe;
}

int Schiebebalken::ineu(int y) //berechne neue Schiebeposition
{
 if(rr==0) {y0=y; yoffset=y-int(gg->itexte*dy+0.5); rr=NEEDS_MAUSBEWEGUNG;
	    return gg->itexte;
	   }
 int imax=gg->ntexte-gg->maxzeil;
 int ineu = (y>=y0) ? gg->itexte + (gg->ntexte*(y-y0)+maxy2)/maxy
 		    : gg->itexte - (gg->ntexte*(y0-y)+maxy2)/maxy;
 if(ineu>imax) ineu=imax;
 if(ineu<0) ineu=0;
 y0=yoffset+int(ineu*dy+0.5);
 return ineu;
}

static int darstellungsbreite=40;

void textkuerzen(char *quelle,char *ziel,int a,int max)
{
 //von z.B. "%-80.80s %5s %9d" umformattieren auf "%-a.as%5s %9d"
 //also a Zeichen am Anfang und 15 Zeichen am Ende behalten.
 if(max<a+16) a=max-16;
 char cstr[32];
 sprintf(cstr,"%%-%d.%ds",a,a);
 sprintf(ziel,cstr,quelle);
 int n=strlen(quelle);
 if(n>a && n>15) strcpy(&ziel[a],&quelle[n-15]);
}

void ngxdrawauswahlbox(Tekplot* tek,NewGadget *ng)
{
 //printf("ngxdrawauswahlbox(Tekplot* tek,NewGadget *ng)\n");//test
 char **pz,*text,kurz[120];
 int c,i,j,y0,dx=PIXPROBUCHST_X*3/2,xmit,ymit;
 Gadget2* gg=ng->Gadget;
 const int dy2=PIXYRAND, dx2=PIXXRAND, dy=gg->dy;
 if(dx&1) dx++;//mache dx durch 2 teilbar
 //for(pz=gg->texte,i=0;i<gg->ntexte;i++) printf("'%s'\n",*pz++);//test
 //Gadget-Bereich loeschen:
 y0 = gg->TopEdge + dy2 + PIXPROBUCHST_Y - dy;
 tek->zwert_decrement();
 
 //rgbcolor(150,255,150); //hellgruener Gadget-Hintergrund
 //rgbcolor(0,255,0); //test gruen
 //printf("gruener test: fillbox(%d, %d, %d, %d)\n",ng->LeftEdge+1,ng->TopEdge+1,ng->Width-1,ng->Height-1);//test
 //test fillbox(ng->LeftEdge+1,ng->TopEdge+1,ng->Width-1,ng->Height-1);
 
 //Gadget-Texte anschreiben:
 tek->zwert_decrement();
 rgbcolor(0,0,0); //schwarze Schrift
 for(pz= &gg->texte[j=gg->itexte],i=0;i<gg->maxzeil && j<gg->ntexte;i++,j++)
   {
    text= *pz++;
#ifdef MITUMLAUTEN
    textkuerzen(umlaut(text),kurz,darstellungsbreite,120);
#else
    textkuerzen(text,kurz,darstellungsbreite,120);
#endif
    //XDrawImageString(mydpy,win,gc,gg->LeftEdge+dx2,y0+=dy,kurz,strlen(kurz));
    ischrift_ngx(gg->LeftEdge+dx2, y0+=dy, kurz);
   }
 myXDrawRectangle(gg->LeftEdge,gg->TopEdge,gg->Width,gg->Height);
 myXDrawRectangle(gg->LeftEdge+gg->Width,gg->TopEdge,dx,gg->Height);
 myXDrawRectangle(xmit=gg->LeftEdge+gg->Width, ymit=gg->TopEdge+gg->Height-dy,dx,dy); //Runter-Knopf
 myXDrawRectangle(xmit, ymit-dy,dx,dy); //Rauf-Knopf
 //Pfeile in Rauf-Runter-Knpfe zeichnen:
 XPoint po[4],pu[4],*pp;
 int mode=CoordModeOrigin, dx3=dx/4,dy3=dy/4, br=(dx-2*dx3+1)/2;
 xmit+=dx/2;
 po[0].x = pu[0].x = xmit-br;  po[0].y = po[1].y = ymit-dy3;
 po[1].x = pu[1].x = xmit+br;
 po[2].x = pu[2].x = xmit;  po[2].y = ymit-dy+dy3;
 for(j=0;j<3;j++)  pu[j].y = 2*ymit - po[j].y; //unterer Pfeil an ymit spiegeln
 po[3]=po[0]; pu[3]=pu[0];
 //for(int i=0;i<4;i++) printf("i=%d: po[i]={%d %d} pu[i]={%d %d}\n",
 //			     i, po[i].x, po[i].y, pu[i].x, pu[i].y);//test
 myXDrawLines(po,4,mode); myXDrawLines(pu,4,mode);
//Schieber zeichnen:
 int shib_hoehe,shib_y;
 schiebebalken.calc(gg,&shib_hoehe,&shib_y);
 if(gg->TopEdge+shib_y+shib_hoehe > ymit-dy)
  {
   shib_hoehe = ymit - dy - gg->TopEdge - shib_y;//Spezialfall
  }
 //rgbcolor(255,0,0);//test
 myXFillRectangle(gg->LeftEdge+gg->Width+1, gg->TopEdge+shib_y, dx-3, shib_hoehe);
}

int requester_datei(char *pfad,char *file,int max1,int max2,int maxzeilen,int flgs,
		    const char *titeltext,char *filter,
		    const char *oktext,const char *canceltext,
		    const char *parenttext,const char *diskstext,int nfilt)
{
 //max1 definiert Platz in pfad, max2 Platz in file, nfilt Platz in filter
 int i,j,h,nzeich,ok,xbr,deltay,n4;
 int xrand=2,xmax=50,ymax=40;
 int dy1=PIXPROBUCHST_Y*3/2,	//Gadgethoehe
     dy2=2*PIXPROBUCHST_Y,	//Gadgetabstand
     dx=PIXPROBUCHST_X;		//Buchstabenbreite
 int yspace=(PIXPROBUCHST_Y>4)?PIXPROBUCHST_Y/2:2,
     yspace2=3*yspace;
 if((dy1-PIXPROBUCHST_Y)&1)
	dy1++; //gradzahlige Anzahl Pixel mehr als Buchstabenhhe
 int minxbr=5*PIXPROBUCHST_X;
 int xx=xrand,yy=yspace,dy=dy1+dy2;
 struct NewGadget *ng;
 const int n=4;
 //char *s;
 
 //char *cstr2[n]={filter,"Files ",pfad,file};
 //char *cstr2[n]={filter,strKopie("Files "),pfad,file};
 char *cstr2[n]={filter,const_cast<char*>("Files "),pfad,file};
 
 char *dateiliste=getfileliste(pfad,filter);
 char *cstr1[n]={const_cast<char*>(" Filt:"), dateiliste, const_cast<char*>(" Path:"), const_cast<char*>(" File:")};
 if(flgs&SPRACHE_DEUTSCH)
   //{cstr1[0]=" Filt:"; cstr1[2]=" Pfad:"; cstr1[3]="Datei:";}
   {cstr1[2]=const_cast<char*>(" Pfad:"); cstr1[3]=const_cast<char*>("Datei:");}
 xrand=dx*strlen(cstr1[n-1]);
 for(ng=newgadgets,j=i=0;i<n;i++)
        {if(cstr2[i]==NULL) continue;
	 ng->GadgetText = cstr1[i];
	 if(i==1) nzeich=strlen(cstr2[i]);
	 else nzeich=strlen(ng->GadgetText);
	 if(xx<xrand) xx=xrand;
         ng->LeftEdge=xx; ng->TopEdge=yy;
         ng->GadgetID=j; ng->Flags=(i==1)?PLACETEXT_AUSWAHL:PLACETEXT_LEFT;
	 
         ng->UserData=cstr2[i];
         //ng->putUserData(cstr2[i]);
	 
	 strcpy(gadgetstr[j].s,cstr2[i]);
	 if((h=strlen(gadgetstr[j].s))>nzeich) nzeich=h;
	 if(nzeich<40) nzeich=40; //40 entspricht der Fensterbreite
	 //gadgetstr[j].max=nzeich; //war falsch! Im Gadget soll ganzer Text
         //  bleiben, nur beim Anzeigen soll er auf 40 beschraenkt sein.
	 if(j==2) gadgetstr[j].max = max1;//max. Laenge pfad
	 else if(j==3) gadgetstr[j].max = max2;//max. Laenge file
	 else gadgetstr[j].max = MAXP;//gesamte Groesse von s in gadgetstring
         xbr=(nzeich+1)*dx; if(xbr<minxbr) xbr=minxbr;
	 if(i==1) deltay=maxzeilen*PIXPROZEILE+2*PIXYRAND;
	 else	{deltay=dy1;
		 xbr+=PIXPROBUCHST_X*3/2;//etwas breiter um schoen zu passen
		}
         ng->Width=xbr; ng->Height=deltay;
         if(xmax<xx+xbr) xmax=xx+xbr;
         if(i==1) yy+=deltay+yspace2;
	 else yy+=deltay+yspace;
	 ng++; j++;
        }
 yy+=yspace2;
 xmax+=xrand;
 xbr=9*dx;
 int xspace=(xmax-4*xbr)/5;
 if(xspace<2) {xspace=2; xmax=4*xbr+5*xspace;}
 int ok_left=xspace, cancel_left=xmax-xspace-xbr,
     parent_left=2*xspace+xbr, disks_left=3*xspace+2*xbr;
 for(;i<n+4;i++,ng++,j++)
        {switch(i)
	  {case n:   ng->LeftEdge=parent_left; ng->GadgetText=parenttext;
	   CASE n+1: ng->LeftEdge=disks_left;  ng->GadgetText=diskstext;
	   CASE n+2: ng->LeftEdge=ok_left; ng->GadgetText=oktext;
	   CASE n+3: ng->LeftEdge=cancel_left; ng->GadgetText=canceltext;
	  }
         ng->TopEdge=yy; ng->Width=xbr; ng->Height=dy1;
         ng->GadgetID=j; ng->Flags=PLACETEXT_IN;
         ng->UserData=NULL;
        }
 yy+=dy;
 if(yy>ymax) ymax=yy;
 for(ng=newgadgets,i=(filter==NULL)?1:0; i<n; i++,ng++)
    machgadget(ng,(i==1)?maxzeilen:1);
 if(filter==NULL)
	{n4=n+3; aktiver_requester.typ=REQTYP_AUSWAHL_NO_FILTER;}
 else	{n4=n+4; aktiver_requester.typ=REQTYP_AUSWAHL_FILTER;
         g_filter=gadgetstr[0].s;
        }
 // aktiver_requester.nglist=ng;//provi.
 aktiver_requester.nrpath=n4-6;
 aktiver_requester.nrfile=n4-5;
 // aktiver_requester.gglist=tek_gadgetliste;//provi.
 ok=xrequester_start(n4,newgadgets,dy1,dy2,xmax,ymax,titeltext,
		     aktiver_requester.typ);
 if(filter!=NULL && nfilt>0) //filter zum Anwenderprogi zurueckkopieren
  {
   mystrncpy2(filter,gadgetstr[0].s,nfilt);
   filter[nfilt-1]=0;
  }
 if(ok)
  for(ng= &newgadgets[i=n4-6];i<n4-4;i++,ng++)
   {
    strcpy(ng->UserData, gadgetstr[i].s);
   }
 delete[] dateiliste;
 g_filter=NULL;
 return ok;
}

char *strcpymax(char *zu,const char *von,int max)
{
 while(--max>0) if((*zu++ = *von++)==0) return zu;
 *zu++ = 0;
 return zu;
}

void splitpfad(const char *name,char *pfad,char *file,int max,int max2)
{
// name in pfad und file aufteilen
// in pfad und file muessen je max Bytes platz haben
 char *s1;
 int pfadleer;
 if(max2==0) max2=max;
 s1=strcpymax(pfad,name,max);
 while(s1!=pfad && *--s1!='/') ;
 if(s1==pfad) {if(*s1=='/') {pfadleer=2; s1++;} else pfadleer=1;}
 else {*s1++ = 0; max -= s1-pfad; pfadleer=0;}
 if(max<max2)  //sicher stellen dass nicht mehr als max Bytes
     max2=max; //aus name gelesen werden und dass
 strcpymax(file,s1,max2);//hoechstens max2 Bytes in file geschrieben werden.
 switch(pfadleer)
   {case 2: *pfad='/'; pfad[1]=0; break;
    case 1: *pfad=0;
   }
}

char *joinpfad(const char *pfad,const char *file,char *name,int max)
{
 // pfad und file in einem String zusammenfuegen
 const char *s1;
 char *t;
 int c,c2,i;
 if(max==0) max=strlen(pfad)+strlen(file)+2;
 if(name==NULL) name=new char[max];
 for(t=name,s1=pfad,i=2; (c2= *s1++) && i<max;i++) *t++ = c = c2;
 if(c!='/' && t!=name) *t++ = '/';
 strcpymax(t,file,max-i);
 return name;
}

#ifdef NO_DIRENT_H
int nachfilenamefragen(const char *str,char *name,int max,int flgs,
		       char *filter, //hier darf kein const sein!
		       const char *oktext,const char *canceltext,
		       const char *parenttext,const char *diskstext,
		       int nfilt //Maximale Laenge von filter
		       )
{
 //provisorische Version
 char titel[200];
 char file[MAXD];
 int ok;
 mystrncpy2(file,name,MAXD);
 if(strlen(str)<24)  sprintf(titel,"%-24.24s",str);
 else mystrncpy(titel,str,200);
 printf("NO_DIRENT_H  max=%d\n",max);//test
 ok=requester_input(1, titel,"%s","%s",file);
 if(ok) mystrncpy2(name,file,max);
 return ok;
}
#else

int nachfilenamefragen(const char *str,char *name,int max,int flgs,
		       char *filter, //hier darf kein const sein!
		       const char *oktext,const char *canceltext,
		       const char *parenttext,const char *diskstext,
		       int nfilt //Maximale Laenge von filter
		       )
{
 const int NZEILEN=10;
 char pfad[MAXP],file[MAXD];
 int ok;
 splitpfad(name,pfad,file,MAXP,MAXD);
 if(oktext==NULL)
   {if(strncmpgross(str,"LOAD",4)==0 ||
       strncmpgross(str,"LADE",4)==0) oktext="  LOAD";
    else if(strncmpgross(str,"SAVE",4)==0 ||
	    strncmpgross(str,"SPEI",4)==0) oktext="  SAVE";
    else oktext="   OK";
   }
 ok=requester_datei(pfad,file,MAXP,MAXD,NZEILEN,flgs,str,
		    filter,oktext,canceltext,parenttext,diskstext,nfilt);
 if(ok)
  {
   joinpfad(pfad,file,name,max);
   //printf(" requester_datei() mit Ok beendet --> name=\"%s\"\n",name);//test
  }
 //else printf(" requester_datei() mit Cancel beendet\n");//test
 return ok;
}

#endif //NO_DIRENT_H

bool filtervergleich1(const char *name,const char *filter)
{
 int c1,c2=0,star=0,frag=0;
 for(;(c1= *name)!=0 && (c2= *filter)!=0;)
   {while(c2=='*' || c2=='?')
     {if(c2=='?') frag++;
      else if(c2=='*') star=1;
      c2= *++filter;
     }
    if(c2==0) break;
    if(star>0)
      {for(;frag>0;--frag) {if((c1= *name++)==0) return 0;}
       while((c1= *name++)!=c2) {if(c1==0) return 0;}
       ++filter; star=0;
      }
    else
      {for(;frag>0;--frag) {if((c1= *name++)==0) return 0;}
       if((c1= *name++)!=c2) return 0;
       ++filter;
      }
   }
 if(c2==0)
   {for(;frag>0;--frag) {if((c1= *name++)==0) return 0;}
    return (star>0 || *name==0);
   }
 return (*filter==0 || (*filter=='*' && filter[1]==0));
}
void stringumkehren(const char *s1,char *s2)
{
 int n=strlen(s1);
 while(n>0) *s2++ = s1[--n];
 *s2=0;
}
bool filtervergleich(const char *name,const char *filter)
{
 if(*name=='.' &&
    (strncmp(filter,"*?.",3)==0
     || strncmp(filter,"?*.",3)==0)) return 0;//Spezialdatei nicht zeigen
 if(filtervergleich1(name,filter)) return true;
 int n=strlen(name),n2=strlen(filter);
#ifdef _WIN32
 char *name2=new char[n+1], *filter2=new char[n2+1];
#else
 char name2[n+1],filter2[n2+1];
#endif
 stringumkehren(name,name2); stringumkehren(filter,filter2);
 bool result=filtervergleich1(name2,filter2);
#ifdef _WIN32
 delete[] name2; delete[] filter2;
#endif
 return result;
}

char *getfileliste(const char *pfad,const char *filter,int maxz)
{
 int nc=512,j,typ;
 char fullpath[MAXP+40],buf[MAXD+40],*s;
 const char *styp;
 char *liste=new char[nc];
#ifdef NO_DIRENT_H
 strcpy(liste,"no_dirent.h");
#else
 char sctrl[40]; //40 reicht fuer Platz als Control-String
 DIR *dp;
 struct dirent *dirp;
 struct stat statbuf;
 const int NORM=1,VERZ=2,SPEZ=3,LINK=4;
 if(pfad==NULL || *pfad==0) pfad=".";//aktueller Pfad
 if((dp=opendir(pfad))==NULL) {*liste=0; return liste;}
 for(j=0;(dirp=readdir(dp))!=NULL;)
   {if(strcmp(dirp->d_name,".")==0 || strcmp(dirp->d_name,"..")==0) continue;
    sprintf(fullpath,"%s/%s",pfad,dirp->d_name);
    typ=NORM;
    if(lstat(fullpath,&statbuf) < 0) typ=SPEZ;
    else
      switch(statbuf.st_mode & S_IFMT)
	{case S_IFREG: typ=NORM; break;
	 case S_IFDIR: typ=VERZ; break;
	 case S_IFLNK: typ=LINK; break;
	 case S_IFBLK: case S_IFCHR: case S_IFIFO: case S_IFSOCK:
	 default: typ=SPEZ;
	}
    if(typ!=VERZ && typ!=LINK && filter!=NULL
       && filtervergleich(dirp->d_name,filter)==0) continue;
    switch(typ)
      {case NORM: styp="     "; break;
       case VERZ: styp="(dir)"; break;
       case LINK: styp="(lnk)"; break;
       default: styp=strf("(%03lX)",typ);
      }
    int a=maxz-16; if(a<4) a=4;
    sprintf(sctrl,"%%-%d.%ds %%s %%9d",MAXD,MAXD); darstellungsbreite=a; //MAXS war hier falsch
    //z.B. %-80.80s fuer Beschraenkung auf 80 Zeichen
    sprintf(buf,sctrl,dirp->d_name,styp,statbuf.st_size);
    //printf("sctrl='%s' buf='%s'\n",sctrl,buf);//test TODO ev.ausfuehrlicher testen
    if(nc-j < (int)(strlen(buf)+2)) //wenn Buffer zu klein:
      {s=new char[nc+=nc];  //groesserer Buffer anfordern
       liste[j]=0; strcpy(s,liste); delete[] liste; liste=s;
      }
    if(j!=0) liste[j++]='\n';
    for(s=buf;*s;) liste[j++] = *s++;
   }
 liste[j]=0;
 closedir(dp);
#endif
 return sortieren(liste);
}

void fileliste_aktualisieren(Gadget2 *gg,char *pfad)
{
 char *dateiliste=getfileliste(pfad,g_filter);
 fileliste_ins_gadget_kopieren(dateiliste,gg);
 delete[] dateiliste;
}

static char *nextzeile(char *s)
{
 int c;
 while((c= *s++) && c!='\n') ;
 if(c==0) --s;
 return s;
}
static char *zeilekopieren(char *s,const char *v)
{
 int c;
 while((c= *v++) && c!='\n') *s++ = c;
 *s++ = '\n';
 return s;
}

/** Sortieren-Variante mit Beruecksichtugung aller Zeichen der Dateinamen **/
static int namenvergleich(const char *s1,const char *s2)
{
 //Rueckgabewerte: 0 = beide gleich, <0 = s1 soll vor s2 kommen, >0 s2 vor s1
 int c1=2,c2=2;
 const int SOND=0x80;
 if(index2(s1,"(dir)")>=0 || index2(s1,"(lnk)")>=0) c1=1;//Dirs weit vorne
 if(index2(s2,"(dir)")>=0 || index2(s2,"(lnk)")>=0) c2=1;
 if(c1!=c2) return c1-c2;
 c1= *s1++; if(c1=='.') c1+=SOND; //mit Sonderzeichen beginnend weit hinten
 c2= *s2++; if(c2=='.') c2+=SOND;
 if(c1==0 || c1=='\n' || c2==0 || c2=='\n') return c1-c2;
 for(;c1==c2;)
   {c1= *s1++; c2= *s2++;
    if(c1==0 || c1=='\n' || c2==0 || c2=='\n') break;
   }
 return c1-c2;
}

static char *sortieren(char *liste)
{
 int i,j,max=anzahlzeilen(liste);
 if(max<2) return liste;//kein sortieren noetig
 char **tab,*s,*neu=new char[strlen(liste)+1];
 tab=new char*[max];
 //printf("sortieren()\nliste='%s'\n",liste);//test
 for(i= -1,s=liste;++i<max && *s!=0;)
   {tab[i]=s; s=nextzeile(s);}
 for(j=0;j<max-1;j++) //bubble-sort
   for(i=max;--i>j;)
     if(namenvergleich(tab[i-1],tab[i])>0)
       {s=tab[i-1]; tab[i-1]=tab[i]; tab[i]=s;} //Strings vertauschen
 for(i=0,s=neu;i<max;i++)
   s=zeilekopieren(s,tab[i]);
 if(s!=neu) --s;
 *s=0;
 delete[] liste; delete[] tab;
 return neu;
}

/**************** xrequester_start() Anpassung fuer OpenGL2  ****************/

void Xrequester::eingabekursor_set(NewGadget *ng, int x, int y, int einpos)
{
 cur_ng = ng;
 cur_x = x;
 cur_y = y;
 cur_einpos = einpos;
}

int Xrequester::eingabekursor(NewGadget *ng, int x, int y, int einpos)
{
 static int x0=0,y0=0, xdopp=0,ydopp=0;
 int x1=0,max,max1,max2,j=ng->GadgetID;
 int maxy,dy=0,ytop=ng->TopEdge,doppelklick=0;
 const int dy2=PIXYRAND;
 int width=(ng->Flags==PLACETEXT_AUSWAHL)?ng->Gadget->Width:ng->Width;
 max1=ng->LeftEdge+PIXPROBUCHST_X/2+strlen(gadgetstr[j].s0)*PIXPROBUCHST_X;
 max2=ng->LeftEdge+width-PIXPROBUCHST_X/2-1;
 max=(max1<max2)?max1:max2;
 if(ng->Flags==PLACETEXT_AUSWAHL)
   {Gadget2* gg=ng->Gadget;
    dy=gg->dy;
    maxy = minmax(gg->ntexte - gg->itexte - 1, 1, gg->maxzeil-1);
    maxy = maxy*dy + dy2 + ytop;
    if(y>0)
      {if(x >= max2) xdopp=ydopp=0;
       if(x >= gg->LeftEdge+gg->Width)
	 {int a1=gg->TopEdge+gg->Height, a2=a1-dy, a3=a2-dy;
	  int a4=schiebebalken.a4, a5=schiebebalken.a5;
	  int imax=maxwert(gg->ntexte-gg->maxzeil,0);
	  if(schiebebalken.rr || istinnerhalb(y,a4,a5)) //auf Schieber geklickt
		gg->itexte=schiebebalken.ineu(y);
	  else if(istinnerhalb(y,a3,a4)) //unterhalb des Schiebers geklickt
		gg->itexte=minwert(gg->itexte+gg->maxzeil,imax);
	  else if(istinnerhalb(y,a5,ytop)) //oberhalb des Schiebers
		gg->itexte=maxwert(gg->itexte-gg->maxzeil,0);
	  else if(istinnerhalb(y,a2,a3)) //rauf-Box angeklickt
	       {if(gg->itexte > 0) gg->itexte--;}
	  else //if(istinnerhalb(y,a1,a2)) //runter-Box angeklickt
	       {if(gg->itexte < imax) gg->itexte++;}
	  y0=minmax(y0,ytop+dy2,maxy);
	 }
       else
	 {doppelklick=(xdopp>0 && ydopp>0 &&
		       istinnerhalb(x,y,xdopp-2,ydopp-2,xdopp+2,ydopp+2));
	  xdopp=x; ydopp=y;
	  y0=minwert(y-(y-ytop-dy2)%dy, maxy);
	 }
      }
    else if(einpos>=0)
      y0=minwert(ytop+dy2+einpos*dy, maxy);
   }
 else
   {if(x>0)
     x0=x1=minwert(x-(x-ng->LeftEdge-PIXPROBUCHST_X/2)%PIXPROBUCHST_X-1, max);
    else if(einpos>=0)
	{int newoffset=0;
	 einpos -= gadgetstr[j].offset;
	 while(einpos<0) {gadgetstr[j].inc(-1); einpos++; newoffset=1;}
	 x1=ng->LeftEdge + PIXPROBUCHST_X/2 - 1 + einpos*PIXPROBUCHST_X;
	 if(x1>max)
		{if(max1>max2) {gadgetstr[j].inc(1); newoffset=1;}
		 x1=max;
		}
	 if(newoffset) ngxdrawstr(tek,ng,gadgetstr[j].s0,0,1);
	 x0=x1;
	}
    else x1=x0;
   }

 //in Zeichenmodus GXxor wechseln:
 // TODO: Problem dass es GXxor in OpenGL nicht gibt
 //...XSetFunction(mydpy,gc,GXxor);
 // Umgehung des Problems mit cursor_onoff, das vor Aufruf von eingabekursor() gesetzt wurde
 //if(cursor_onoff==CURSOR_OFF) color_reqhigrund();

 if(cursor_onoff==CURSOR_ON)
  {
   if(ng->Flags==PLACETEXT_AUSWAHL)
    {
     //myXFillRectangle(ng->LeftEdge+1,y0,width-2,dy); //geht nur mit GXxor
     myXDrawRectangle(ng->LeftEdge+1,y0-1,width-2,dy-1); //nicht ausgefuellte Markierung
     einpos=(y0+1-ytop-dy2)/dy;
     if(einpos<0) einpos= -1;//provi
    }
   else
    {
     //myXFillRectangle(x1,ytop+1,PIXPROBUCHST_X+1,ng->Height-1); //geht nur mit GXxor
     myXDrawRectangle(x1,ytop+1,PIXPROBUCHST_X+1,ng->Height-2); //nicht ausgefuellter Cursor
     einpos=(x1+1-ng->LeftEdge-PIXPROBUCHST_X/2)/PIXPROBUCHST_X + gadgetstr[j].offset;
    }
  } //nur gemacht wenn CURSOR_ON
 
 //wieder normaler Zeichenmodus:
 //XSetFunction(mydpy,gc,GXcopy); ...
 //if(cursor_onoff==CURSOR_OFF) color_reqfogrund();
 
 if(doppelklick) {ngnextdir(tek,ng,einpos); xdopp=ydopp=0;}
 return einpos;
}

void eingabekursor_off(int *fokus)
{
 cursor_onoff=CURSOR_OFF;
 gadgetstr[*fokus].inc(-MAXS);
 *fokus = -1;
}

void gadgets_anschreiben(Tekplot* tek,int n,int gadhoehe,int n0,int fokus)
{
 int i;
 NewGadget *ng;
 //printf("gadgets_anschreiben()\n");//test
 //rgbcolor(255,0,0);//test rot
 for(ng=newgadgets,i=n0;i<n;i++,ng++) //jedes Gadget anschreiben
   switch(ng->Flags)
	{case PLACETEXT_NONE:
	        ngxdrawstr(tek, ng, gadgetstr[i].s0,0,1);
	 CASE PLACETEXT_LEFT:
		ngxdrawstr(tek, ng, ng->GadgetText,0,2);
		ngxdrawstr(tek, ng, gadgetstr[i].s0,0,1);
	 CASE PLACETEXT_ABOVE:
		ngxdrawstr(tek, ng, ng->GadgetText,-gadhoehe-1,0);
		ngxdrawstr(tek, ng, gadgetstr[i].s0,0,1);
	 CASE PLACETEXT_AUSWAHL:
		ngxdrawauswahlbox(tek, ng);
	 CASE PLACETEXT_IN: default:
	        //rgbcolor(255,0,255);//test pink
	        //printf("i=%d fokus=%d\n",i,fokus);//test
		ngxdrawstr(tek, ng, ng->GadgetText,0,1,fokus==i);
	 }
 //rgbcolor(0,0,0);//test schwarz
}

int Xrequester::zeichnen()
{
 float32 zwert_vorher=tek->zwert;
 int zflag_vorher = tek->zflag;
 tek->set_requesterVertices();
 tek->zwert = REQUESTER_ZWERT_START; //Requester auf fast vorderster Ebene
 //printf("zwert = REQUESTER_ZWERT_START = %f\n",tek->zwert);//test
 tek->zflag = ZFLAG_NEVER;
 //TODO: Position des Sub-Fensters ev. variabel machen
 int ix0=ngx_posx, iy0=ngx_posy-20; //20 Pixel fuer Titelbereich reserviert
 rgbcolor(180,180,255); //hellblauer Hintergrund
 ifillbox(ix0, iy0, ix0+breite, iy0+hoehe);
 tek->zwert_decrement();
 rgbcolor(80,80,200); //blaue Schrift fuer Titel
 int xa,xb,ya,yb;
 //int da=haupt.da2;//TODO: da abhaengig von Bildschirmaufloesung
 int buy=requfont->get_buy(), bux=requfont->get_bux(); //Font Hoehe und Breite
 int xrand = (breite-strlen(titel)*bux)/2;
 req_vordergrundfarbe = 80 +( 80<<8)+(200<<16); //blaue Schrift
 req_hintergrundfarbe = 180+(180<<8)+(255<<16); //hellblauer Hintergrund
 //requfont->itextsize(bux,buy,NULL,0); //ist schon so gesetzt
 requfont->ischrift(ix0+xrand, iy0+buy+1, titel,0,0);
 req_vordergrundfarbe = 0x010101; //fast schwarz fuer weitere Schrift
 //Buttons und Gadgets zeichnen:
 //requfont->setFarben(req_vordergrundfarbe,req_hintergrundfarbe);
 gadgets_anschreiben(tek, nn, gadhoehe);
 int einpos= -1;
 if(cur_ng!=NULL) einpos = cur_einpos = eingabekursor(cur_ng, cur_x, cur_y, cur_einpos);
 tek->unset_requesterVertices();
 tek->zflag=zflag_vorher;
 tek->zwert=zwert_vorher;
 rgbcolor(255,255,255); //defaultfarbe: weiss bei schwarzem Hintergrund
 return einpos;
}

int xrequester_start(int nn,NewGadget *newgadgets,int gadhoehe,int gadabst,
		     int breite,int hoehe,const char *titel,int reqtyp)
{
 Tekplot* tek = &haupt;
 int erfolg=0; //Rueckgabewert: 1=ok, 0=Cancel oder Fehler, andere Werte=ok
 int i,x,y,eingabepos=0;
 int fokus= -1, neuerfokus= -2, shift=0, caps_lock=0;
 int xklick=0; //,yklick=0;
 //KeySym key;
 uchar txt[10];
 NewGadget *ng,*ngklick=NULL;

 // printf("xrequester_start(nn=%d, newgadgets, gadhoehe=%d, gadabst=%d,\n", nn,gadhoehe,gadabst);//test
 //printf("  breite=%d, hoehe=%d, titel=\"%s\", reqtyp=%d)\n",breite,hoehe,titel,reqtyp);//test
 
 xrequ.zeichnen(&haupt, nn,newgadgets,gadhoehe,gadabst,breite,hoehe,titel,reqtyp);

 int menubalkenhoehe = tek->get_menubalkenhoehe();
 bool buttonEnter=false;
 int done=0;
 tek->requester_aktiv=true;
 while(tek->exitflag==0 && done==0) //Events-Schlaufe
  {
   int flag=waitmenu(0);
   if(flag==0) continue;
   if(flag!=2) printf("Unerwarteter flag-Wert: flag=%d\n",flag);//test
   if(flag==2) //dann Events abfragen
    {
     SDL_Event event=tek->requester_event;
     if(event.type==SDL_MOUSEMOTION)
      {
       //Mausbewegung
       //neue Mausposition schon in tek_mausx tek_mausy gespeichert
       y = tek_mausy - menubalkenhoehe - ngx_posy;
       if(schiebebalken.rr==NEEDS_MAUSBEWEGUNG)
	{
	 eingabepos=neuerdateitext(&haupt,gadhoehe,ngklick,eingabepos,nn,xklick,y);
	}
      }
     else if(event.type==SDL_MOUSEBUTTONDOWN) //Mausknopf gedrueckt
      {
       if(maustasten_zustand & LIMAUS)
	{
	 x = tek_mausx - ngx_posx;  y = tek_mausy - menubalkenhoehe - ngx_posy;
	 //printf("Mausklick: x=%d y=%d\n",x,y);//test
	 //usleep(200000); //test 0.2sec warten
	 if(fokus>=0)
	  {
	   eingabekursor_off(&fokus);
	   xrequ.zeichnen();
	  }
	 for(ng=newgadgets,i=0;i<nn;i++,ng++)
		if(x>ng->LeftEdge && x<ng->LeftEdge+ng->Width
		   && y>ng->TopEdge && y<ng->TopEdge+ng->Height) break;
	 if(i<nn) //Klick aufs Gadget i erkannt
	  {
	   if(i>=nn-2) {erfolg=(i==nn-2); done=1;}
	   else if(IS_REQTYP_AUSWAHL(reqtyp) && i>=nn-4)
	    {
	     if(ngnewdir(tek,newgadgets,i))
	       xrequ.zeichnen();
	    }
	   else
	    {
	     cursor_onoff=CURSOR_ON;
	     xrequ.eingabekursor_set(&newgadgets[fokus=i],x,y);
	     eingabepos = xrequ.zeichnen();
	    }
	   if(schiebebalken.rr==NEEDS_MAUSBEWEGUNG)
	    {xklick=x; /*yklick=y;*/ ngklick= &newgadgets[fokus];}
	  }
	 if(fokus>=0 && newgadgets[fokus].Flags==PLACETEXT_AUSWAHL && eingabepos>=0)
	  {
	   neuerdateitext(tek,gadhoehe,&newgadgets[fokus],eingabepos,nn);
	  }
	}
      }
     else if(event.type==SDL_MOUSEBUTTONUP) //Mausknopf losgelassen
      {
       schiebebalken.reset();
       if(fokus>=0 && newgadgets[fokus].Flags==PLACETEXT_AUSWAHL && eingabepos>=0)
	  neuerdateitext(tek,gadhoehe,&newgadgets[fokus],eingabepos,nn);
      }
     else if(event.type==SDL_KEYDOWN) // Tastatureingabe verarbeiten
      {
       static int umlaut_flag=0;
       int key = event.key.keysym.sym;
       if(key==SDLK_KP_ENTER) key=0x0D;
       if(key<=0x7F)
	{i=1; //einfache Taste
	 if(key>='a' && key<='z')
	  {
	   if((shift|caps_lock)!=0) key -= 'a'-'A';
	  }
	 else if(shift!=0)
	  {
	   //Taste wenn Shift gedrueckt.. (von Tastaturbelegung abhaengig)
	   //printf("scancode: 0x%lX\n", event.key.keysym.scancode);//test
	   //long skey=SDL_GetKeyFromScancode(event.key.keysym.scancode);//test
	   //int c = (skey>=' ' && skey<0x7F) ? skey : 0;//test
	   //printf("skey: '%c' 0x%lX\n", c, skey);//test
	   int newkey = key_from_scancode(event.key.keysym.scancode);
	   if(newkey!=0) key=newkey;
	  }
	 if(umlaut_flag==1)
	  {
	   if(key==' ') key = '"';
	   else if(key=='a') key=''; //test
	   else if(key=='o') key=''; //test
	   else if(key=='u') key=''; //test
	   else if(key=='A') key=''; //test
	   else if(key=='O') key=''; //test
	   else if(key=='U') key=''; //test
	   umlaut_flag=0;
	  }
	 txt[0]=key; txt[1]=0;
        }
       else
	{i=2; txt[0]=0; //Spezialtaste gedrueckt
	 if(key==SDLK_LSHIFT || key==SDLK_RSHIFT) shift=1;
	 else if(key==SDLK_CAPSLOCK) caps_lock ^= 1;
	 else if(shift==1)
	  {
	   //printf("Spezialtaste mit Shift: key = 0x%X\n",key);//test
	   if(key==0x40000000) umlaut_flag=1;
	  }
	}
       if(fokus>=0)
	 {ng= &newgadgets[fokus];
	  int ngtyp=get_ngtyp(ng->Flags);
	  cursor_onoff=CURSOR_OFF;
	  if(i==1) //gewoehnliche Taste gedrueckt
	   {if(*txt<' ' && *txt!=DELL && *txt!=DELR) //Spezialzeichen abfangen
		{if(*txt==0x09) //Tabulator soll nur den Fokus verschieben
		   {neuerfokus=(shift==0)?fokus+1:fokus-1;}
		 else if(ngtyp==GADTYP_AUSWAHL)
		   {if(*txt==0x0D //Return-Taste
		       && ngnextdir(tek,ng,eingabepos)==0)
			{eingabekursor_off(&fokus);
			 //gadgets_anschreiben(win,gc2,nn,gadhoehe);
			 xrequ.zeichnen();
			}
		   }
		 else if(ngtyp==GADTYP_IN)
		   {if(*txt==0x0D) //Return-Taste
		     {i=fokus; //wie "Klick aufs Gadget i"
		      eingabekursor_off(&fokus);
		      if(i>=nn-2) {erfolg=(i==nn-2); done=1;}
		      else if(IS_REQTYP_AUSWAHL(reqtyp) && i>=nn-4)
		        {if(ngnewdir(tek,newgadgets,i))
			  //gadgets_anschreiben(win,gc2,nn,gadhoehe);
			  xrequ.zeichnen();
			}
		     }
		   }
		 else //if(ngtyp==GADTYP_STRING)
		   {eingabekursor_off(&fokus);
		    if(IS_REQTYP_AUSWAHL(reqtyp))
			{ngnewpath(newgadgets);
			 //gadgets_anschreiben(win,gc2,nn,gadhoehe);
			 xrequ.zeichnen();
			}
		   }
		}
	    else if(ngtyp==GADTYP_STRING)
		{zeicheninsert(*txt,eingabepos,gadgetstr[fokus].s);
		 if(*txt==DELR) {}//Zeichen unter Kursor geloescht		 
		 else if(*txt==DELL) //Zeichen vor Kursor geloescht
			{if(eingabepos>0) eingabepos--;}
		 else  eingabepos++;
		}
	    if(fokus>=0)
	     {
	      //gadgets_anschreiben(win,gc2,nn,gadhoehe);
	      cursor_onoff=CURSOR_ON;
	      xrequ.zeichnen();
	     }
	   }
	  else //spezielle Taste gedrueckt
	   {int flg=(ngtyp==GADTYP_AUSWAHL);
	    //switch(key&0xFF)
	    switch(key)
		{case SDLK_LEFT: //Kursor nach links
			   if(!flg)
			        {if(eingabepos>0) eingabepos--;}
			   else {if(ngnewdir(tek,ng,0,'P'))
			           xrequ.zeichnen();
				}
		 CASE SDLK_RIGHT: //Kursor nach rechts
		           if(!flg) eingabepos++;
			   else {if(ngnextdir(tek,ng,eingabepos))
			           xrequ.zeichnen();
				}
		 CASE SDLK_UP: //Pfeil rauf
			   if(flg)
				{if(eingabepos>0) eingabepos--;
				 else ngnextmark(tek,ng,-1);
				}
		 CASE SDLK_DOWN: //Pfeil runter
			   if(flg)
				{if(eingabepos == ng->Gadget->maxzeil-1)
				   ngnextmark(tek,ng,1);
				 else eingabepos++;
				}
		 CASE SDLK_LSHIFT: case SDLK_RSHIFT: shift=1;
		//keine Reaktion auf folgende Tasten:
		 CASE SDLK_CAPSLOCK: case SDLK_RCTRL: case SDLK_LCTRL: //CapsLock, ctrl
		 DEFAULT: printf("unbekannter TastenCode key=0x%X\n",key);
		}
	   }
	  if(fokus>=0)
	   {
	    if(ngtyp==GADTYP_AUSWAHL && eingabepos>=0)
	      neuerdateitext(tek,gadhoehe,ng,eingabepos,nn);
	    else if(ngtyp!=GADTYP_IN)
	      {
	       //eingabepos=eingabekursor(win,gc2,ng,-1,-1,eingabepos);
	       cursor_onoff=CURSOR_ON;
	       xrequ.eingabekursor_set(ng,-1,-1,eingabepos);
	       eingabepos=xrequ.zeichnen();
	      }
	   }
	 }
	else //fokus== -1  also Tastendruck wenn noch nichts selektiert
	 {
	  if(key==TABTASTE) neuerfokus=(shift==1)?nn-1:0;
	  //keine Reaktion auf alle andern Tasten
	 }
	if(neuerfokus != -2)
	 {if(neuerfokus<0) neuerfokus+=nn;
	  else if(neuerfokus>=nn) neuerfokus-=nn;
	  fokus=neuerfokus;
	  neuerfokus= -2;
	  ng= &newgadgets[fokus];
	  cursor_onoff=CURSOR_ON;
	  xrequ.eingabekursor_set(ng,-1,-1,0);
	  eingabepos=xrequ.zeichnen();
	  if(ng->Flags==PLACETEXT_AUSWAHL)
	    {neuerdateitext(tek,gadhoehe,ng,eingabepos,nn);}
	  else if(ng->Flags==PLACETEXT_IN)
	    {}
	  else
	    {cursor_onoff=CURSOR_OFF;}
	 }
      }
     else if(event.type==SDL_KEYUP)
      {
       // printf("SDL_KEYUP 0x%02X\n",event.key.keysym.sym);//test
       switch(event.key.keysym.sym)
	{
	 case SDLK_LSHIFT: case SDLK_RSHIFT: shift=0; break;
	}
      }
     else printf("unknown requester_event.type=0x%X\n",event.type);//test
    }//Ende Events abfragen
  }
 tek->requester_aktiv=false;
 tek->requesterMesh.clear();
 return erfolg;
} // Ende xrequester_start()

void zeicheninsert(int c,int einpos,char *str,int max)
{
 char *s,*t;
 int c2;
// printf("zeicheninsert(c=%02X,einpos=%d...)\n",c,einpos);//test
 if(c==DELL || c==DELR) /* Zeichen lschen */
	{if(c==DELL) einpos--;
	 if(einpos>=0 && str[einpos]!=0)
	   for(s= &str[einpos],t= &str[einpos+1]; (*s++ = *t++)!=0;) {}
	}
 else /* Zeichen einfuegen */
 	{for(s= &str[einpos];c!=0 && einpos<max;einpos++)
		{c2= *s; *s++ = c; c=c2;}
	 *s=0;
	}
}

int key_from_scancode(long scancode)
{
 //TODO: provisorisch: von Tastaturbelegung abhaengig
 static char tabelle1[]={'!','@','#','$','%','^','&','*','(',')'}; //US-Belegung Tasten 1 bis 0
 if(scancode>=0x1E && scancode<=0x27) return tabelle1[scancode-0x1E];
 //if(scancode==0x40000000) return '"';
 static char tabelle2[]={'_','+','{','}','|',0,':'}; //US-Belegung
 if(scancode>=0x2D && scancode<=0x33) return tabelle2[scancode-0x2D];
 static char tabelle3[]={'<','>','?'}; //US-Belegung
 if(scancode>=0x36 && scancode<=0x38) return tabelle3[scancode-0x36];
 return 0;
}

int requester_input(int n,...)
{
 int i,h,nzeich,erfolg,xbr;
 int xrand=12,xmax=200-12,ymax=100;
 int dy1=PIXPROBUCHST_Y*3/2,	//Gadgethoehe
     dy2=2*PIXPROBUCHST_Y,	//Gadgetabstand
     dx=PIXPROBUCHST_X;		//Buchstabenbreite
 if((dy1-PIXPROBUCHST_Y)&1)
	dy1++; //gradzahlige Anzahl Pixel mehr als Buchstabenhhe
 int minxbr=5*PIXPROBUCHST_X;
 int x=xrand,y=dy2,dy=dy1+dy2;
// printf("requester_input(%d,...)\n",n);//test
 va_list ap;
 struct NewGadget *ng;
 const char *cstr1,*cstr2[MAXGADS];
 if(n>MAXGADS) n=MAXGADS;
 va_start(ap,n);
 for(ng=newgadgets,i=0;i<n;i++,ng++)
        {ng->LeftEdge=x; ng->TopEdge=y;
         ng->GadgetText=va_arg(ap,char *);
         ng->GadgetID=i; ng->Flags=PLACETEXT_ABOVE;
         cstr1=va_arg(ap,char *);
         cstr2[i]=va_arg(ap,char *);
         ng->UserData=va_arg(ap,APTR);
         if(enthaelt(cstr1,"s"))
                sprintf(gadgetstr[i].s,cstr1,(int32 *)ng->UserData);
	 else if(enthaelt(cstr1,"d"))
		sprintf(gadgetstr[i].s,cstr1,*((int32 *)ng->UserData));
         else	sprintf(gadgetstr[i].s,cstr1,*((double*)ng->UserData));
	 nzeich=strlen(ng->GadgetText);
	 if((h=strlen(gadgetstr[i].s))>nzeich) nzeich=h;
	 gadgetstr[i].max=nzeich;
         xbr=(nzeich+1)*dx; if(xbr<minxbr) xbr=minxbr;
         ng->Width=xbr; ng->Height=dy1;
         if(xmax<x+xbr) xmax=x+xbr;
         if(cstr2[i][strlen(cstr2[i])-1]=='\n')
                {y+=dy; x=xrand;}
         else   {x+=xbr+xrand;}
        }
 y+=dy;
 xbr=9*dx;
 int ok_left=(xmax+xrand-2*xbr)/3,
     cancel_left=2*ok_left+xbr;
 for(;i<n+2;i++,ng++)
        {if(i==n) {ng->LeftEdge=ok_left; ng->GadgetText="   OK";}
         else     {ng->LeftEdge=cancel_left; ng->GadgetText=" CANCEL";}
         ng->TopEdge=y; ng->Width=xbr; ng->Height=dy1;
         ng->GadgetID=i; ng->Flags=PLACETEXT_IN;
         ng->UserData=NULL;
        }
 y+=dy; xmax+=xrand;
 va_end(ap);
 if(y>ymax) ymax=y;
 erfolg=xrequester_start(n+2,newgadgets,dy1,dy2,xmax,ymax);
 if(erfolg) for(ng=newgadgets,i=0;i<n;i++,ng++)
		{if(strncmp(cstr2[i],"%s",2)==0)
			strcpy(ng->UserData,gadgetstr[i].s);
		 else	sscanf(gadgetstr[i].s,cstr2[i],ng->UserData);
		}
 return erfolg;
}
