/* Showitlight.cc		letzte Aenderung: 11.12.2021
*/
const char *VERSION="0.04";
#define OPENGL
/*
  HISTORY:
12.11.2021      Erstellung aus showit.cc version 2.91 vom 27.4.09
30.11.2021      Fadenkreuz angepasst an otekplot1.h
6.12.2021       Test mit mybildopen() -> funktioniert.
10.12.2021 0.03 Fadenkreuz-Anpassung verbessert (geht jetzt einigermassen)
11.12.21   0.04 Fadenkreuz-Probleme provisorisch geloest (k_show_zoom)

  ANWENDUNG:
	float xmin,ymin,xmax,ymax,feld[]; int npoints,modus;
	showit(&xmin,&ymin,&xmax,&ymax,&npoints,&modus,feld,hilfsfeld);
	// diese Stelle wird nie erreicht
	file_exit() {exit(0);}
	file_load() {}
	file_save() {}

	void user_prog(int *fun,POINTER p1,POINTER p2,POINTER p3,POINTER p4)
	{
	 switch(*fun)
	  {case 1: int_save1(...); break;
	   case 2: int_save2(...); break;
	   case 3: get_punkt1(...); break;
	   case 4: get_punkt2(...); break;
	   case 5: texte_laden(...); break;
	   case 6: get_delta(...); break;
	  }
	}

    benutzbare Unterprogramme:
	new_hfeld(hilfsfeld,&modus);
	lower_window();
	raise_window();
	refresh();
	yskalierung(&faktor);
 weitere Erleuterungen in GRAFIK.TXT
*/

//#define MIT_SUBMENUS
#define MIT_MYBILDOPEN

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include "ulong.h"
#include "showitlight.h"
#ifdef OPENGL
#define TEKPLOT1_IMPLEMENTATION
#include "otekplot1.h"
#else
#define USE_INTERNAS
#include "xtekplot1.h"
#define fpbild tekplot_fpbild
#endif

#define GRAD 0.01745329252

typedef unsigned char uchar;

inline void cfree(void *x) {free(x);}

#define qterm term_refresh

static int postaktiv=0,lzugflag=0,lzugi=0,packmethode=1,entpackerflag=0,
	   hpglaktiv=0,hpglflag=0,
	   lepsflag=0,pscolorflag=0,
	   istinwarteschlaufe=0;
static double
	alfa_3d=40.*GRAD,	//Winkel bei 3D-Darstellung
	verkuerzung_3d=1.;	//Verkuerzungsfaktor in Zeit-Achse
static int
	flag_3d=0,	//gesetzt wenn Werte fuer 3D-Darstellung vorhanden
	spektcolors=0;	//Anzahl veraenderte Farben
static double   linewidth=0.5;  /* Liniendicke in Postscript */

static double xtab[4],ytab[4];

#ifndef OPENGL
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
extern double psxcal,psycal,psxmin,psymin;
double psxkor(double x);
double psykor(double y);
#endif

#define FP fprintf
#define PM packmethode
#define EOJ 24
#define AUTO 0
#define HALBAUTO 0
#define UP 3
#define DOWN 2
#define WURZEL10  3.16227766016838
#define MAXSPECT 100
static char *spename[MAXSPECT]=
//	{"Name",NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	{  NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	   NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	   NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	   NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	   NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	   NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	   NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	   NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	   NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	   NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL
	};
static short labeltext_flag=0,anzahl_spenamen=1;
static int xytextflag=0,ohnestrichelung=0;
static int nspektren=1;	/* Anzahl vorhandene Spektren */
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define ESC 27

#define MODUSZUSATZ_MASK 0xFF00
#define AUTOPLOTEXIT	 0x0100
#define AUTOSAVEEXIT	 0x0200
static int moduszusatz=0;

/********************** Vordeklarationen ***************************/

/* Vordeklarationen von C2CPP erzeugt: */
void pramen(double xmin,double ymin,double xmax,double ymax,double y0);
static void xaxis(double x1,double x2,double y0,double dy,int nx);
long idfix(double x);
void ffwrite(char* adr,int size,int n,FILE* fp);
int lzugstart(double* xnull,double* ynull,int it,double dxo,double dxu);
void postpack1(int dx);
void entpacker(int n);
void entpacker1(int n);
void entpackvorbereitung(FILE* fp);
void postpack2(int z);
void entpacker2(int n);
void entpack2vorbereitung(FILE* fp);
void entpacker3(int n);
void entpack3vorbereitung(FILE* fp);
void fragebeschrift(int x,int* strichlang,int* teilung,int* einteilung,int* ter);
void smooth(int n,int wicht);
//void printf_system(const char* str,const char* p1=NULL);
int getline(FILE* fp,char* s,int lim);
/* Ende der Vordeklarationen von C2CPP */

static void set_new_shmodus();
void subtra_undo();
void spektnr_setzen(const char *name,int *nummer);
void spektrum_skalieren(int nr,double f),spektren_skalieren(double f);
float *zeigauf(int spektrumnummer);
static void blowup(double x1,double x2);
static void aufblasen(double x1,double x2,double fak,double add,double sub);
void ymimaxsuchen(float *,float *);
char *inputstr1(const char *frage,long alt);
char *inputstr1(const char *frage,const char *alt);
char *inputstr3(const char *frage,long a1,long a2,long a3,long a4=0);
char *inputstr1lf(const char *frage,double alt);
int intinputstr1(const char *frage,int alt);
double doubinputstr1(const char *frage,double alt);
void lzugstop();
void pe_aus();
void show_previous();
void show_goback();
void flg_schalten(short *);
void number_zoom();
void getintoff();
void peak_getpoint();
void peak_intsave();
void edit_last_saved();
void edit_save_points();
void edit_undo();
void subtra_error();
void subtra_position();
void subtra_stretch();
void subtra_subtract();
void subtra_divid();
void subtra_beer();
//void subtra_calc();
void subtra_swap(int flag);
void subtra_exchange();
void settextpos();
void setsmooth(int n);
int setsmoothpara();
void smooth_help();
void subramp(double x1,double y1,double x2,double y2);
void plotter(int format);
void rohxy_speichern();
void modus_togg(int k);
void modus_1();
void modus_2();
void modus_4();
void modus_5();
void voreinstellungen_lesen(FILE *fp);
void integ_methode();
void load_voreinstellungen();
void save_voreinstellungen();
void setcolors(int autoflag=0);
void fft_start(int inversflag);
void fft_methode();
void show(double x1,double y1,double x2,double y2,int flag);
void fensterposition();
void bewegung(int x,int y);
void bewegung1(), klick1(),klick0();
void fadenkreuz_ein();
void fadenkreuz_aus();
void neuesfadenkreuz(int x,int y);
void fadenkreuz(int x,int y);
void fadenkreuz_setzen(int modus,int x,int y);
void klick(int knopf,int x,int y,int knopfnr);
int integral(double x1,double y1,double x2,double y2);
int differenz(double x1,double y1,double x2,double y2);
void spename_laden();
int hatlashowzeichen(char **spename,int anzahl);
void lashow_definitionen(FILE *fp);
void minmaxsearch(double &x1,double &y1,double &x2,double &y2);
void eingabe_3d(int autoflag=0);
int tfeld_laden(double x1,double y1,double x2,double y2,
		 double *tfeld,double *dx,double *dy);
void plot3d_init(double x1,double y1,double x2,double y2,int max);
void plot3d(double x,double y,int pen);

const char *showit_voreinst="showit.voreinstellungen";

class Voreinst_global
{
public:
 char s[120];
 Voreinst_global() {sprintf(s,"%s/showit.voreinstellungen",getenv("HOME"));}
};
static Voreinst_global voreinst_global;
#define showit_voreinst_global voreinst_global.s

#define X0 3
#define Y0 0
static short int_sflag=0,get_sflag=0;
/* fun-Werte in user_prog: */
static int	fun_intsave=1;
static int	fun_integrals=2;
static int	fun_getpoint=3;
static int	fun_getpoints=4;
static int	fun_textladen=5;
static int	fun_getdeltas=6;
static int	ramen_flag=1;		/* Rahmen zeichnen */
    /* ramen_flag: 0=aus  1=normal  2=Achse immer durch 0  3=3D-Darstellung */
static int	textflag=1,		/* Wenn moeglich beschriften */
		textposflag=0;		/* Text noch nicht positioniert */
static double	yachsenposition,
		xtext,ytext;		/* Position des Textes */

//bool postflag=false;

#ifdef OPENGL
static int dpy=0;
const int gc=0;
static int hintergrundfarbe=0, vordergrundfarbe=0xFFFFFF;//TODO
#define initalflag haupt.initalflag
#define XSync(a,b) //TODO

#else

// mit xtekplot1:
#define dpy tekplot_dpy
#ifdef win1
#undef win1
#endif
#define win1 tekplot_win
#define gc tekplot_gc
#define rambild tekplot_rambild
#define initalflag tekplot_initalflag
#define rambildflag tekplot_rambildflag
#define refreshflag tekplot_refreshflag
#define winbreite tekplot_breite
#define winhoehe  tekplot_hoehe
#define vordergrundfarbe tekplot_vordergrundfarbe
#define hintergrundfarbe tekplot_hintergrundfarbe
#endif //OPENGL

//#define fenstername tekplot_fenstername
char fenstername[160];
static int fenstername1_len=0;

//#define bildname tekplot_bildname
//#define bildname_default tekplot_bildname_default
char bildname[80]="tmpbild.ps";
char bildname_default[80]="tmpbild.ps";
char xyname_default[80]="tmp.xy";

/********************** neue Achsenbeschriftung ***************************/
#define SCALEFAKTOR 0.08514
#define MINDESTBUCH 123

/*
char *d2s(double x)
{
 char *str,*s;
 str=(char *)calloc(40,1); if(str==NULL) return "ERROR:NO_MEM";
 sprintf(str,"%lf",x);
 for(s=str; *s!=0; s++)  ;
 for(--s; *s=='0'; s--)  ;
 if(*s!='.') ++s;
 *s=0;
 return str;
}
*/

#define TBUCHDEFAULT 184
#define TITABSTDEFAULT 196

static int
	xteilung=20,xter=5,xstrichlang=AUTO,xeinteilung=AUTO,rrand=0,hprand=0,
	yteilung=8,yter=2,ystrichlang=2,yeinteilung=HALBAUTO,
	axrand=0,yaxrand=0, /* zusaetzlicher Rand fuer Achsenbeschriftung */
	xbuch=123,ybuch=123,tbuch=TBUCHDEFAULT,titelabst=TITABSTDEFAULT;
static double
	ramenlinewidth=1.0;
static char xlabeldefault[200]="x-Werte", ylabeldefault[200]="y-Werte";
static char *xlabeltext=xlabeldefault, *ylabeltext=ylabeldefault;

/*********************** bildopen bildclose ******************************/
#define ipsxkor (int)psxkor
#define ipsykor (int)psykor

#define MAXCOLOR 16
#define MAXCOLMASK 15
static int
 Rot[MAXCOLOR] = {0,255,255, 0, 0,255,  0,255,255,100,100,255,  0,  0,255,100},
 Gruen[MAXCOLOR]={0,255, 0,255,128, 0,  0,255,100,255,100,  0,255,100,100,  0},
 Blau[MAXCOLOR]= {0,255, 0, 0,255,255,255,  0,100,100,255,100,100,255,  0,255};

#ifdef OPENGL
void colornr(int j) {rgbcolor(Rot[j],Gruen[j],Blau[j]);}
#define color(j) colornr(j)
void setcolor(int farbnr,int r,int g,int b)
{
 if(farbnr>=MAXCOLOR)
  {printf("Fehler: nur %d Farbnummern setzbar\n",MAXCOLOR); farbnr=MAXCOLOR-1;}
 Rot[farbnr] = r; Gruen[farbnr] = g; Blau[farbnr] = b;
}
#endif

/*** mybildopen() mybildplot() mybildclose() ***/
#ifdef MIT_MYBILDOPEN
#define mybildopen bildopen
#define mybildclose bildclose
#define mybildplot bildplot

#define BBXMAX 6804
#define BBYMAX 9225
#define BBU 122
#define BBL 430
#define BBR 240
#define BBO 73
#define BBDY 36
#define BBUCHSTABENBREITE 40
#define SCALEFAKTOR 0.08514

void mybildopen(const char* name)
{
 FILE *fp,*fp1;
 double x1,y1,x2,y2,dx,dy,laenge,hoehe;
 double ymini,ymaxi,xmini,xmaxi,xstep,ystep,xoffset,yoffset;
 char str[80];
 int n,i;
#ifdef OPENGL
 get_xyminmax(&x1,&y1,&x2,&y2);
#else
 x1=tekplot_xmin; y1=tekplot_ymin; x2=tekplot_xmax; y2=tekplot_ymax;
#endif
 fp=fpbild=fopen(name,"w");
 if(fp==NULL) {printf("Fehler beim Oeffnen von '%s'\n",name); return;}
 if(labeltext_flag==0)  spename_laden();
 if(postflag)
   {
    psxcal=BBYMAX/(x2-x1); psxmin=x1;
    psycal=BBXMAX/(y2-y1); psymin=y1;
    axrand=int((xbuch-MINDESTBUCH)*SCALEFAKTOR+0.5);  if(axrand<0) axrand=0;
    yaxrand=int((ybuch-MINDESTBUCH)*SCALEFAKTOR+0.5); if(yaxrand<0) yaxrand=0;
    if(xytextflag)
	 {axrand += int(xbuch*SCALEFAKTOR);
	  yaxrand += int(3*ybuch*SCALEFAKTOR);
	 }
    if(lepsflag) // A4-Seite auf druckbaren Bereich skalieren
	{FP(fp,"save clippath pathbbox");
	 if(rrand||axrand||yaxrand)
	   {FP(fp," %d sub 4 1 roll %d sub 4 1 roll\n",
					rrand+yaxrand*2,rrand+yaxrand/2);
	    FP(fp," %d add 4 1 roll %d add 4 1 roll\n",rrand,rrand+axrand);
	   }
	 FP(fp," 3 index 3 index translate\n");
//	 FP(fp,"exch 4 1 roll exch  sub 0 sub 843 div 3 1 roll\n");
//	 FP(fp,"sub 0. sub 596 div exch scale 0. 0 translate newpath\n");
//	 FP(fp,"/showpage{}def\n");
	 FP(fp,"exch 4 1 roll exch sub 843 div 3 1 roll\n");
	 FP(fp,"sub 596 div exch scale newpath /showpage{}def\n");
	}
    else // eine EPS-Datei erzeugen
	{FP(fp,"%%!PS-Adobe-2.0 EPSF-1.2\n");
	 if(PM==0) FP(fp,"%%%%Creator: Showit-%s\n",VERSION);
	 else FP(fp,"%%%%Creator: Showit-%s (Packer%d)\n",VERSION,PM);
	 if(rrand||axrand||yaxrand)
		FP(fp,"%%%%BoundingBox: %d %d %d %d\n",
			-rrand-axrand,-rrand,596+rrand,843+rrand+yaxrand);
	 else	FP(fp,"%%%%BoundingBox: 0 0 596 843\n");
	 FP(fp,"save\n");
	}
    FP(fp,"/m /moveto load def\n");
    FP(fp,"/d /lineto load def\n");
    FP(fp,"/s /stroke load def\n");
    if(packmethode==0)
	FP(fp,"/dsm {2 copy lineto stroke moveto} bind def\n");
    FP(fp,"/zshow {m dup stringwidth pop 2 div neg 0 rmoveto show} def\n");
    FP(fp,"/yzshow {m dup stringwidth pop neg 0 rmoveto show} def\n");
    FP(fp,"/xmi %lg def /xs %lg def\n",psxmin,psxcal);
    FP(fp,"/ymi %lg def /ys %lg def\n",psymin,psycal);
    FP(fp,"0 843 translate -90 rotate\n");
    FP(fp,"%lf %lf scale %d %d translate\n",SCALEFAKTOR,SCALEFAKTOR,BBL,BBU);
    FP(fp,"%.2lf %lf div setlinewidth\n",linewidth,SCALEFAKTOR);
    if(textflag || xytextflag)
     {if(hatlashowzeichen(spename,anzahl_spenamen)) lashow_definitionen(fp);}
    if(textflag)
     {int fa;
      FP(fp,"/Helvetica findfont %d scalefont setfont\n",tbuch);
      for(i=0,fa=1;i<anzahl_spenamen;i++)
	if(*spename[i]>=' ')
	 {if(pscolorflag && fa<=nspektren)
		{
		 color(fa);
		 fa=(fa+1)&MAXCOLMASK;
		}
	  if(textposflag) //dieses if-else nach color() gemacht 17.6.99
		FP(fp,"%d %d m\n",ipsxkor(xtext),ipsykor(ytext)-titelabst*i);
	  else	FP(fp,"%d %d m\n",BBYMAX/4,BBXMAX*94/100-titelabst*i);
	  if(*spename[i]=='$') FP(fp,"(%s) %d Lashow\n",&spename[i][1],tbuch);
	  else FP(fp,"(%s) show\n",spename[i]);
     }	 }
    if(pscolorflag) color(1);
//  fprintf(fp," %d %d m %d %d d %d %d d %d %d d closepath s\n", -BBL,-BBU,
//	    -BBL,BBXMAX+BBO, BBYMAX+BBR,BBXMAX+BBO, BBYMAX+BBR,-BBU);// test
    if(ramen_flag)
	{ ymini=yachsenposition;}
    else
	{ dy=y2-y1;
	  ystep=rundezahl(dy/4., dy/10.);
	  ymini=rundezahl(y1,y1+ystep);   }
    if(!ramen_flag)
       {FP(fp,"%d %d m %d %d d %d %d d\n", ipsxkor(x1),ipsykor(ymini),
			 ipsxkor(x1),ipsykor(y2), ipsxkor(x2),ipsykor(y2));
	FP(fp,"%d %d d closepath s\n", ipsxkor(x2),ipsykor(ymini));
       }
    postaktiv=1;
    return;
   }
 return;
}

void mybildplot(double x,double y,int pen)
{
 static UBYTE farbe=1, npu=0;
 static int ncount=0, npu2=0;
 static UWORD ux,uy,ufeld[512];
 static int dxflag;
 static double xalt,yalt,dxaltu,dxalto,ynull,xnull;
 double dx;
 int h,i,ix,iy;
 const char *str;
#define psxkornull(x) idfix((x-xnull)*psxcal)
#define psykornull(y) idfix((y-ynull)*psycal)
 if(postflag)
 {if(packmethode!=0)
   {if(pen==2) // Linie zeichnen
     {if(lzugflag)
	{dx=(x-xalt)*psxcal;
	 if(!dxflag) ix=psxkornull(x);
	 iy=psykornull(y);
	 ++lzugi;
	 if((dxflag && (dx<dxaltu||dx>dxalto)) ||
	    (lzugi>200&&(lzugi>1000||abs(iy)>1023||(!dxflag&&abs(ix)>1023)))
	   )	{lzugstop(); lzugi=2;
		 xtab[0]=xalt; ytab[0]=yalt; xtab[1]=x; ytab[1]=y;
		 return;
		}
	 if(dxflag) {if(PM==1) postpack1(psykornull(y));
		     else postpack2(ipsykor(y));
		    }
	 else	{if(PM==1) {postpack1(ix); postpack1(iy);}
		 else {postpack2(ipsxkor(x)); postpack2(ipsykor(y));}
		}
	}
      else
	{xtab[lzugi]=x; ytab[lzugi++]=y;
	 if(lzugi==4)	{dx=(x-xalt)*psxcal;
			 if(dx>=0.){dxalto=dx*1.00000001; dxaltu=dx/1.00000001;}
			 else	   {dxaltu=dx*1.00000001; dxalto=dx/1.00000001;}
			 dxflag=lzugstart(&xnull,&ynull,lzugi,dxalto,dxaltu);
			 lzugflag=1;
	}		}
      xalt=x; yalt=y;
     }
     else // pen!=2  Stift bewegen
     {if(lzugi>1) lzugstop();
      xtab[0]=x; ytab[0]=y; lzugi=1;
     }
    return;
   }
  else // packmethode==0
   {if(pen==2) // Linie zeichnen
	{if(lzugi>=500) {str="dsm\n"; lzugi=0;}
	 else if(lzugi%5==0) str="d\n";
	 else str="d ";
	 FP(fpbild,"%d %d %s",ipsxkor(x),ipsykor(y),str); lzugi++;
	}
    else // pen!=2  Stift bewegen
	{if(lzugi!=0) FP(fpbild,"s\n");
	 FP(fpbild,"%d %d m ",ipsxkor(x),ipsykor(y)); lzugi=lzugflag=1;
	}
    return;
 } }
// sonst Tellagraf:
 printf("TELLAGRAF nicht mehr unterstuetzt.\n");//test
 return;
}

void mybildclose()
{
 if(postflag)
	{if(lzugi>1) lzugstop();
	 if(lepsflag) fprintf(fpbild,"\nrestore showpage\n");
	 else	fprintf(fpbild,"\nshowpage\nrestore\n");
	 postaktiv=0; entpackerflag=0;
	}
 else printf("TELLAGRAF nicht mehr aktuell.\n");//test
 fclose(fpbild); fpbild=NULL;
 return;
}
#endif //MIT_MYBILDOPEN
/*** mybildopen() mybildplot() mybildclose() ***/

/*************************************************************************/
static void yaxis(double y1,double y2,double x0,double dx,int ny)
{
 int iy,iymax;
 double y,ydiff,xlang;
 double y0,dx4;
 if(y2<y1) {y=y1; y1=y2; y2=y;}
/* if(ny<5 && yeinteilung==AUTO) ny=5; else */
 if(ny<1) ny=1;
 else if(ny>10000) ny=10000;
 if(yeinteilung==AUTO)	 {y=(y2-y1)/ny/WURZEL10; ydiff=rundezahl(10.0*y,y);}
 else if(yeinteilung==1) {y=(y2-y1)/ny/1.1; ydiff=rundezahl(1.2*y,y);}
 else ydiff=(y2-y1)/ny;
 if(y1+ydiff>y2)
   {printf(" YAXIS-Error:\ny1=%lf  y2=%lf  x0=%lf  dx=%lf  ny=%d\n",
			   y1,y2,x0,dx,ny);
    ydiff=(y2-y1)/5;
   }
 if(lzugi>1) lzugstop();
 if(postaktiv)
	FP(fpbild,"%.2lf %lf div setlinewidth\n",ramenlinewidth,SCALEFAKTOR);
 else if(hpglaktiv) ;/* provi.*/
 plot(x0,y1,UP);
 if(yeinteilung<=1) y0=y=rundezahl(y1+ydiff,y1);
 else y0=y=y1;
 iymax=int(y2/ydiff);
 for(iy=idfix(y/ydiff); iy<=iymax; iy++)
  {if(ystrichlang==AUTO)
	{if(iy%5==0)	{xlang=dx+dx; if(iy%10==0) xlang+=dx;}
	 else		xlang=dx;
	}
   else if(ystrichlang==1 || (iy%ystrichlang)!=0) xlang=dx*1.5;
   else xlang=dx*3.;
   plot(x0,y,DOWN); plot(x0-xlang,y,DOWN); plot(x0,y,DOWN);
   y+=ydiff;
  }
 plot(x0,y2,DOWN);
 if(postaktiv)
  {if(ystrichlang==1) dx4=dx*2.; else dx4=dx*4.;
   if(lzugi>1) lzugstop();
   FP(fpbild,"/Helvetica findfont %d scalefont setfont\n",ybuch);
   if(ydiff>=1.0)
   {FP(fpbild,"/yd %ld def ",idfix(ydiff));
    FP(fpbild,"%ld 1 %d {dup %d mod 0 eq {yd mul\n",idfix(y0/ydiff),iymax,yter);
   }
   else
   {FP(fpbild,"/yd %ld def ",idfix(1./ydiff));
    FP(fpbild,"%ld 1 %d {dup %d mod 0 eq {yd div\n",idfix(y0/ydiff),iymax,yter);
   }
    FP(fpbild,
        "/yw 1 index def 20 string cvs %lg yw ymi sub ys mul %d sub yzshow}\n",
        (x0-dx4-psxmin)*psxcal, ybuch/4);
   FP(fpbild,"{pop}ifelse}for\n");
   if(xytextflag && ylabeltext!=NULL)
     {if(*ylabeltext=='$')
	{FP(fpbild,"gsave (%s)\n",&ylabeltext[1]);
	 FP(fpbild,"%lg %lg m 90 rotate %d Lashow grestore\n",
	    (x0-dx4-psxmin)*psxcal-3.*ybuch,((y1+y2)/2.-psymin)*psycal,ybuch);
	}
      else
	{FP(fpbild,"gsave (%s)\n",ylabeltext);
	 FP(fpbild,"%lg %lg m 90 rotate show grestore\n",
		(x0-dx4-psxmin)*psxcal-3.*ybuch,((y1+y2)/2.-psymin)*psycal);
     }	}
  }
}

/**************************** ppramen *********************************/
/* #include "ppramen.c" */

void pramen(double xmin,double ymin,double xmax,double ymax,double y0)
{
 double dy,dy2;
 if(lzugi>1) lzugstop();
 if(postaktiv)
	FP(fpbild,"%.2lf %lf div setlinewidth\n",ramenlinewidth,SCALEFAKTOR);
 plot(xmin,ymin,UP);   plot(xmin,ymax,DOWN);
 plot(xmax,ymax,DOWN); plot(xmax,ymin,DOWN); /* oberer Teil des Rahmens */
 dy=(ymax-ymin)/100.;
 dy2=(y0-ymin)/4.;
 if(ymax>ymin)  {if(dy>dy2) dy=dy2;}
 else		{if(dy<dy2) dy=dy2;}
 xaxis(xmin,xmax,y0,dy,xteilung);
/* if(postaktiv) yaxis(y0,ymax,xmin,(xmax-xmin)/150.,yteilung); */
 if(postaktiv||hpglaktiv) yaxis(ymin,ymax,xmin,(xmax-xmin)/150.,yteilung);
}

static void xaxis(double x1,double x2,double y0,double dy,int nx)
{
 int ix,ixmax;
 double x,xdiff,ylang;
 double x0,dy4;
 if(x2<x1) {x=x1; x1=x2; x2=x;}
/* if(nx<10 && xeinteilung==AUTO) nx=10; else */
 if(nx<1) nx=1;
 else if(nx>10000) nx=10000;
 if(xeinteilung==AUTO)	 {x=(x2-x1)/nx/WURZEL10; xdiff=rundezahl(10.0*x,x);}
 else if(xeinteilung==1) {x=(x2-x1)/nx/1.1; xdiff=rundezahl(1.2*x,x);}
 else xdiff=(x2-x1)/nx;
 if(x1+xdiff>x2)
   {printf(" XAXIS-Error:\nx1=%lf  x2=%lf  y0=%lf  dy=%lf  nx=%d\n",
			   x1,x2,y0,dy,nx);
    xdiff=(x2-x1)/5;
   }
 if(lzugi>1) lzugstop();
 if(postaktiv)
	FP(fpbild,"%.2lf %lf div setlinewidth\n",ramenlinewidth,SCALEFAKTOR);
 plot(x1,y0,UP);
 if(xeinteilung<=1) x0=x=rundezahl(x1+xdiff,x1);
 else x0=x=x1;
 ixmax=int(x2/xdiff);
 for(ix=idfix(x/xdiff); ix<=ixmax; ix++)
  {if(xstrichlang==AUTO)
	{if(ix%5==0)	{ylang=dy+dy; if(ix%10==0) ylang+=ylang;}
	 else		ylang=dy;
	}
   else if(xstrichlang==1 || (ix%xstrichlang)!=0) ylang=dy*1.5;
   else ylang=dy*4.;
   plot(x,y0,DOWN); plot(x,y0-ylang,DOWN); plot(x,y0,DOWN);
   x+=xdiff;
  }
 plot(x2,y0,DOWN);
 if(postaktiv)
  {if(xstrichlang==1) dy4=dy*3.; else dy4=dy*4.;
   if(lzugi>1) lzugstop();
   FP(fpbild,"/Helvetica findfont %d scalefont setfont\n",xbuch);
   if(xdiff>=1.0)
   {FP(fpbild,"/xd %ld def ",idfix(xdiff));
    FP(fpbild,"%ld 1 %d {dup %d mod 0 eq {xd mul\n",idfix(x0/xdiff),ixmax,xter);
   }
   else
   {FP(fpbild,"/xd %ld def ",idfix(1./xdiff));
    FP(fpbild,"%ld 1 %d {dup %d mod 0 eq {xd div\n",idfix(x0/xdiff),ixmax,xter);
   }
    FP(fpbild,
        "/xw 1 index def 20 string cvs xw xmi sub xs mul %lg zshow}\n",
        (y0-dy4-psymin)*psycal-xbuch);
   FP(fpbild,"{pop}ifelse}for\n");
   if(xytextflag && xlabeltext!=NULL)
     {if(*xlabeltext=='$')
	{FP(fpbild,"(%s)\n",&xlabeltext[1]);
	 FP(fpbild,"%lg %lg %d zLashow\n",
	    ((x1+x2)/2.-psxmin)*psxcal,(y0-dy4-psymin)*psycal-2.2*xbuch,xbuch);
	}
      else
	{FP(fpbild,"(%s)\n",xlabeltext);
	 FP(fpbild,"%lg %lg zshow\n",
		((x1+x2)/2.-psxmin)*psxcal,(y0-dy4-psymin)*psycal-2.2*xbuch);
     }	}
  }
}
/*************************ende ppramen*********************************/

void spename_laden()
{
 char *p;
 int c,i;
 user_prog(&fun_textladen,&spename[0],&xlabeltext,&ylabeltext,NULL);
 for(i=0,p=spename[0]; (c= *p) && i<MAXSPECT-1; p++)
        if(c=='\n') {*p=0; spename[++i]=p+1;}
 anzahl_spenamen=i+1;
 labeltext_flag=1;
// printf("Test in spename_laden() :\n");//test
// for(i=0;i<anzahl_spenamen;i++) //test
//      printf("spename[%d]='%s'\n",i,spename[i]);//test
 return;
}

void bildgestrichelt(int farbe)
{
 //printf("bildgestrichelt(farbe=%d)\n",farbe);//test
 if(farbe>1) color(farbe);
 if(pscolorflag)
  {if(lzugi>1) lzugstop();
  }
 else //if(postflag)
  {if(lzugi>1) lzugstop();
   if(ohnestrichelung==0 && fpbild) fprintf(fpbild,"[35] 0 setdash\n");
  }
 return;
}

void bildnichtgestrichelt()
{
 //printf("bildnichtgestrichelt()\n");//test
 color(1);
 if(pscolorflag)
  {if(lzugi>1) lzugstop();
  }
 else //if(postflag)
  {if(lzugi>1) lzugstop();
   if(ohnestrichelung==0 && fpbild) fprintf(fpbild,"[] 0 setdash\n");
  }
 return;
}

/*************** Behandlung der Linienzuege in Postscript ****************/
static int packzaehler=0,endzeichen='!';
static const char *lzugname="lzug",*lzug1name="lzug",*lzug2name="lzug2",
                  *lzug0name="lzug0",*lzug3name="lzug3";

void printfpackmethode(int flg)
{
 switch(packmethode)
	{case 1: if(flg) printf("Es werden 6 Bits in ein ASCI-Byte gepackt\n");
		 lzugname=lzug1name; endzeichen='!'; break;
	 case 2: if(flg) printf("Binaeres speichern\n");
		 lzugname=lzug2name; endzeichen=0xFF; break;
	 case 3: if(flg) printf("Immer 18 Bits in 3 Bytes packen\n");
		 lzugname=lzug3name; endzeichen='!'; break;
	 default: if(flg) printf("0 = nicht packen\n");
		  endzeichen='s';
	}
}

int lzugstart(double* xnull,double* ynull,int it,double dxo,double dxu)
{
 int i,flag;
 double dx=0;
 packzaehler=0;
 for(flag=1,i=1;i<it-1;i++)
	{dx=(xtab[i]-xtab[i-1])*psxcal; if(dx<dxu || dx>dxo) {flag=0; break;}}
 *xnull=xtab[0]; *ynull=ytab[0];
 if(flag)
	{if((entpackerflag&1)==0) entpacker(1);
	 fprintf(fpbild,"%d %d m %.10lg x%s\n",
		 ipsxkor(xtab[0]),ipsykor(ytab[0]),dx,lzugname);
	 for(i=1;i<it;i++)
		{if(PM==1) postpack1(idfix((ytab[i]- *ynull)*psycal));
		 else postpack2(ipsykor(ytab[i]));
		}
	}
 else	{if((entpackerflag&2)==0) entpacker(2);
	 fprintf(fpbild,"%d %d m %s\n",
			ipsxkor(xtab[0]),ipsykor(ytab[0]),lzugname);
	 for(i=1;i<it;i++)
	    if(PM==1)	{postpack1(idfix((xtab[i]- *xnull)*psxcal));
			 postpack1(idfix((ytab[i]- *ynull)*psycal));
			}
	    else  {postpack2(ipsxkor(xtab[i])); postpack2(ipsykor(ytab[i]));}
	}
 return flag;
}

void lzugstop()
{
 int i;
 if(lzugflag)  {fprintf(fpbild,"%c\n",endzeichen); lzugflag=0;}
 else	{fprintf(fpbild,"%d %d m ",ipsxkor(xtab[0]),ipsykor(ytab[0]));
	 for(i=1;i<lzugi;i++)
		fprintf(fpbild,"%d %d d ",ipsxkor(xtab[i]),ipsykor(ytab[i]));
	 fprintf(fpbild,"s\n");
	}
 lzugi=0;
}

void postpack1(int dx) /* dx oder dy in 2 oder 3 Bytes packen */
{
 int vorz,n1,n2,n3;
 if(dx<0) {vorz=0x20; dx= -dx;} else vorz=0;
// if(dx>9901) printf("dx=%d vorz=%d\n",dx,vorz);//test
 n3=dx&0x3F; n2=(dx>>6)&0x3F; /* in jedes Byte koennen 6 Bits gepackt werden */
 if(dx>0x3FF) /* mehr als 10 Bits ? */
	{n1=(dx>>12)+vorz+0x10; /* Markierung fuer 3 Bytes */
	 fprintf(fpbild,"%c%c%c",n1+'0',n2+'0',n3+'0'); packzaehler+=3;
	}
 else	{fprintf(fpbild,"%c%c",n2+vorz+'0',n3+'0'); packzaehler+=2;
	}
 if(packzaehler>=78) {fprintf(fpbild,"\n"); packzaehler=0;}
}

void entpacker(int n)
{
 switch(packmethode)
  {case 1:entpacker1(n); break;
   case 2:entpacker2(n); break;
   case 3:entpacker3(n); break;
  }
}

void entpacker1(int n)
{
 FILE *fp=fpbild;
 if(entpackerflag==0) entpackvorbereitung(fpbild);
 entpackerflag |= n;
 if(n==1)
  {FP(fp,"/xlzug{curr x0 {1 index add dup rx{y0 add d}{exit}ifelse} loop\n");
   FP(fp," pop pop pop s} bind def\n");
  }
 else
  {FP(fp,"/lzug{curr");
   FP(fp," {rx{x0 add rx pop y0 add d}{exit}ifelse}loop s} bind def\n");
  }
}

void entpackvorbereitung(FILE* fp)
{
 FP(fp,"/curr {currentpoint /y0 exch def /x0 exch def} bind def\n");
 FP(fp,"/rd {currentfile read pop 48 sub} bind def\n");
 FP(fp,"/rd3 {dup 31 and dup 16 ge{15 and 6 bitshift rd add}if\n");
 FP(fp," 6 bitshift rd add exch 32 ge{neg}if} bind def\n");
 FP(fp,"/rx {{rd dup 0 lt{-15 eq{false exit}if}{rd3 true exit}ifelse}");
 FP(fp," loop} bind def\n");
}

void postpack2(int z)
{
 if(PM==2) FP(fpbild,"%c%c",z>>8,z&0xFF);
 else
  {static int zaehl=0;
   FP(fpbild,"%c%c%c",(z>>12)+'0',((z>>6)&0x3F)+'0',(z&0x3F)+'0');
   if(++zaehl>25) {FP(fpbild,"\n"); zaehl=0;}
  }
}

void entpacker2(int n)
{
 FILE *fp=fpbild;
 if(entpackerflag==0) entpack2vorbereitung(fpbild);
 entpackerflag |= n;
 if(n==1)
  {FP(fp,"/curr {currentpoint /y0 exch def /x0 exch def} bind def\n");
   FP(fp,"/xlzug2 {curr x0 {1 index add dup cr dup 255 eq{exit}if\n");
   FP(fp," bs8 cr add d} loop s 4{pop}repeat} bind def\n");
  }
 else
  {FP(fp,"/lzug2 {{cr dup 255 eq{exit}if bs8 cr add\n");
   FP(fp," cr bs8 cr add d} loop s pop} bind def\n");
  }
}

void entpack2vorbereitung(FILE* fp)
{
 FP(fp,"/bs8 {8 bitshift} bind def\n");
 FP(fp,"/cr {currentfile read pop} bind def\n");
}

void entpacker3(int n)
{
 FILE *fp=fpbild;
 if(entpackerflag==0) entpack3vorbereitung(fpbild);
 entpackerflag |= n;
 if(n==1)
  {FP(fp,"/curr {/x0 currentpoint pop def} bind def\n");
   FP(fp,"/xlzug3 {curr x0 {1 index add dup rx{d}{exit}ifelse}loop\n");
   FP(fp," s pop pop pop} bind def\n");
  }
 else
  {FP(fp,"/lzug3 {{rx{rd bs d}{exit}ifelse} loop s} bind def\n");
  }
}

void entpack3vorbereitung(FILE* fp)
{
 FP(fp,"/rd {currentfile read pop 48 sub} bind def\n");
 FP(fp,"/bs {6 bitshift rd add 6 bitshift rd add} bind def\n");
 FP(fp,"/rx {{rd dup 0 lt{-15 eq{false exit}if}{bs true exit}ifelse}");
 FP(fp," loop} bind def\n");
}

/*************************** HAUPTPROGRAMM ******************************/
#define CASE break;case
#define DEFAULT break;default
#define DECLASER	1
#define IBMLASER	2
#define PSPLOTTER	3
#define HPGLPLOTTER	4
#define HPGLDATEI	5
#define IFFDATEI	6
#define TELLDATEI	7
#define PSDATEI		8
#define PSDATEIFARBIG	9
#define ROHXYDATEI	10

static int	npkt,		/* Anzahl Punkte des ganzen Spektrums */
		faden_x = -1,
		faden_y = -1,	/* aktuelle Position des Fadenkreuzes */
		integral_x1,
		integral_y1,	/* aktueller 1.Punkt der Integrierlinie */
		on_x = -1,	/* Wert um Edit-Fadenkreuz festzuhalten */
		shmodus,
//		nspektren=1,	/* Anzahl vorhandene Spektren */
		smoothNr=5,	/* Anzahl Punkte ueber die geglaettet wird */
		gewichtung=1,	/* Gewichtung, 0=ausgeschaltet */
		gewichtmethod=3,/* Gewichtungsmethode */
#define WICHT_SIMPLE 1	/* Mittlerer Punkt doppelt gewichtet */
#define WICHT_TRIANG 2
#define WICHT_CUBIC  3
#define WICHT_QUINTIC 4
		spektruma=0,
		spektrumb=1;
static int	last_point_i;	/* Index des Letzten veraenderten Punktes */
static double	last_point_y,	/* Alter Wert des letzten veraend. Punktes */
		strepos_faktor,	/* hfeld um soviel gestreckt oder verschoben */
		yskalfakt=1.,	/* y-Skalierungsfaktor */
		blowupfaktor=10.,/* Aufblasefaktor */
		blowupshift=0.,	/* Verschiebung des Aufblasebereichs */
		blowup_x1,blowup_x2; /* Grenzen des Aufblasebereichs */
static int	blowup_all=0,		/* gesetzt: alle Spektren aufblasen */
		txtbr,txtho;	/* Breite und Hoehe des Platzes des Textes */
static float	*zfeld,		/* Zeiger auf Feld der y-Werte */
		*savefeld=NULL,	/* gesichertes Feld */
		*sfeld=NULL,	/* vor Glaettung gesichertes Feld */
		*zhfeld=NULL;	/* Zeiger auf Hilfsfeld */
static short	*penfeld;	/* UP DOWN Feld (noch im Test) */
static float	integralwert=0.,    /* letztes Ergebnis der Integration */
		integralgrenzen[4], /* Grenzwerte x1,y1,x2,y2 */
		xspitze,yspitze,    /* Maximum des integrierten Bereichs */
		xgetpunkt=0.,
		ygetpunkt=0.;	    /* Werte des letzten Get-Punktes */
static double	xmi1,ymi1,xma1,yma1,deltax,  /* Grenzen des Gesamtbildes */
		xmi2,ymi2,xma2,yma2,dx2,dy2, /* Grenzen des aktuellen Bildes */
		last_x1,last_y1,last_x2,last_y2; /* vorherige Werte */
static short	zoom_flg=0,		/* gesetzt: Zoom eingeschaltet */
		xzoom_flg=0,		/* Zoom nur in x-Richtung */
		yzoom_flg=0,		/* Zoom nur in y-Richtung */
		integral_flg=0,		/* Integrieren (>=2 1.Punkt gesetzt) */
		on_flg=0,		/* Edit auf ON geschaltet */
		getdeltas_flg=0,	/* Delta messen (>=2 1.Punkt ges.) */
		getpoint_flg=0,		/* Punkt an USER_PROG senden */
		stretch_flg=0,		/* Streckung in y-Richtung */
		positio_flg=0,		/* Position in y-Richtung aendern */
		subramp_flg=0,		/* Rampe subtrahieren */
		puundin_flg=0,		/* Punkte u Integrals (Knopfnr 2u3) */
		settext_flg=0,		/* Textkasten positionieren */
		blowup_flg=0,		/* Bereich Aufblasen (x-Richt.marki.)*/
		/* :es kann immer nur eines dieser 13 Flags gesetzt sein */
		flag_flg=0,		/* eines der obigen Flags gesetzt */
		change_flag=0,		/* Spektrum geaendert */
		smoot_flag=0,		/* Spektrum geglaettet */
		blowup_flag=0,		/* einen Bereich Aufgeblasen */
		subtr_flag=0,		/* Subtraktion durchgefuert */
		strepos_flag=0,		/* hfeld gestreckt oder verschoben */
		knopf_flag=0,		/* Mausknopf ist gedrueckt */
		fadenkreuzflag=0,	/* Fadenkreuz eingeschaltet */
		subtra_flag=0,		/* Subtra-Funktionen erlaubt */
		swap_flag=0,		/* swap durchgefuehrt */
		showit_gestartet=0;
static int	search_methode=1,	/* Suchmethode fuer Punkte-Ausmessung */
		search_radius=6,	/* Suchradius */
		dsearch_methode=0,	/* Suchmethode fuer Delta-Ausmessung */
		integral_methode=0;	/* */
#define SIX search_radius
#define SEARCHRADI search_radius
#define SHMODMIN 1
#define SHMODMAX 5

#ifdef OPENGL
void reset_flags()
{
 zoom_flg=0;		/* gesetzt: Zoom eingeschaltet */
 xzoom_flg=0;		/* Zoom nur in x-Richtung */
 yzoom_flg=0;		/* Zoom nur in y-Richtung */
 integral_flg=0;	/* Integrieren (>=2 1.Punkt gesetzt) */
 on_flg=0;		/* Edit auf ON geschaltet */
 getdeltas_flg=0;	/* Delta messen (>=2 1.Punkt ges.) */
 getpoint_flg=0;	/* Punkt an USER_PROG senden */
 stretch_flg=0;		/* Streckung in y-Richtung */
 positio_flg=0;		/* Position in y-Richtung aendern */
 subramp_flg=0;		/* Rampe subtrahieren */
 puundin_flg=0;		/* Punkte u Integrals (Knopfnr 2u3) */
 settext_flg=0;		/* Textkasten positionieren */
 blowup_flg=0;		/* Bereich Aufblasen (x-Richt.marki.)*/
 /* :es kann immer nur eines dieser 13 Flags gesetzt sein */
 flag_flg=0;		/* eines der obigen Flags gesetzt */
 tek_faden_clearpoints();
}
#endif

/*********************** neue Menue-Erzeugung **************************/
static long menu_ids[150]; /* Anzahl Menus * Maximale Anzahl Eintraege */
static long modus_ids[4],smooth_ids[5],frame_ids[4],text_ids[3],atext_ids[4],
	    search_ids[4],dsearch_ids[4];
	/* jeweils Anzahl Untermenupunkte (nicht nur Anzahl Umschaltpunkte) */
static char	text_modus_1[]="%q 1 = only one",
		text_modus_2[]="%q 2 = Intmarks",
		text_modus_4[]="%q 4 = two Spektra",
		text_modus_5[]="%q 5 = many Spektra",
		text_smoot_3[]= "%o 3",
		text_smoot_3w[]="%o 3 weighted",
		text_smoot_5[]= "%o 5",
		text_smoot_5w[]="%O 5 weighted",
		text_smoot_n[80]="%o 25 cubic  weighted ",
		text_smoot_help[]="help ...",
		text_frame_off[]="%q Off",
		text_frame_below[]="%Q Axis below",
		text_frame_zero[]="%q Axis always zero",
		text_frame_3d[]="%q 3D View",
		text_text_on[]="%Q ON",
		text_text_off[]="%q OFF",
		text_atext_on[]="%q ON",
		text_atext_off[]="%Q OFF",
		text_search_norm[]="%Q OFF",
		text_search_max[]= "%q Maxima",
		text_search_min[]= "%q Minima",
		text_dsearch_norm[]="%Q OFF",
		text_dsearch_max[]= "%q Maxima",
		text_dsearch_min[]= "%q Minima";
static char
  *txt_smoot[]={text_smoot_3,text_smoot_3w,text_smoot_5,text_smoot_5w,text_smoot_n},
  *txt_frame[]={text_frame_off,text_frame_below,text_frame_zero,text_frame_3d},
  *txt_text[]={text_text_on,text_text_off},
  *txt_atext[]={text_atext_on,text_atext_off},
  *txt_search[]={text_search_norm,text_search_max,text_search_min},
  *txt_dsearch[]={text_dsearch_norm,text_dsearch_max,text_dsearch_min};
static long modus_1_idnr=14;

void dings_umschalten(long id,long *idfeld,int n,int j,char **txt,int o,int O)
{
 printf("dings_umschalten(id=%ld, ...)\n",id);//test
#ifdef OPENGL
 //TODO
#else
 int i;
 for(i=0;i<n;i++)  txt[i][1]=(i==j)?O:o;
 if(*idfeld==0) {if(id) getmenuids(id,idfeld); else return;}
 for(i=0;i<n;i++)  changemenu(idfeld[i],txt[i]);
#endif
}
/* alle folgenden *_umschalten() Funktionen sollten durch dings_umschalten()
   ersetztbar sein. (ausser modus_umschalten)
*/

void modus_umschalten(int nr)
{
 //printf("modus_umschalten(nr=%d)\n",nr);//test
 text_modus_1[1]=text_modus_2[1]=text_modus_4[1]=text_modus_5[1]='q';
 switch(nr)
  {case 1: text_modus_1[1]='Q';
   CASE 2: text_modus_2[1]='Q';
   CASE 4: text_modus_4[1]='Q';
   DEFAULT:text_modus_5[1]='Q';
  }
 if(modus_ids[0]==0)
	{int i,j=modus_1_idnr;
	 if(menu_ids[j]==0)
		{getmenuids(0,menu_ids); if(menu_ids[j]==0) return;}
	 for(i=0;i<4;i++,j+=9) modus_ids[i]=menu_ids[j];
	}
 changemenu(modus_ids[0],text_modus_1);
 changemenu(modus_ids[1],text_modus_2);
 changemenu(modus_ids[2],text_modus_4);
 changemenu(modus_ids[3],text_modus_5);
}

void smooth_umschalten(int nr,long id)
{
 dings_umschalten(id,smooth_ids,5,nr,txt_smoot,'o','O');
}

void setramen_umschalten(int nr,long id)
{
 bool flag;
 if((flag=(nr==3 && istinwarteschlaufe))) eingabe_3d();
 dings_umschalten(id,frame_ids,4,ramen_flag=nr,txt_frame,'q','Q');
 if(flag) refresh();
}

void textflag_umschalten(int flag,long id)
{
 textflag=flag;
 if(text_ids[0]==0 && id!=0) getmenuids(id,text_ids);
 dings_umschalten(id,&text_ids[1],2,1-flag,txt_text,'q','Q');
}

void xytextflag_umschalten(int flag,long id)
{
 xytextflag=flag;
 dings_umschalten(id,atext_ids,2,1-flag,txt_atext,'q','Q');
}

void search_umsch(long id,int nr)
{
 dings_umschalten(id,search_ids,3,search_methode=nr,txt_search,'q','Q');
}
void dsearch_umsch(long id,int nr)
{
 dings_umschalten(id,dsearch_ids,3,dsearch_methode=nr,txt_dsearch,'q','Q');
}

//static int klick_igno=0;
static int zoom_erster_klick=0;

void k_zoom_korr() //Fadenkreuz-Probleme bei k_show_zoom() provisorisch geloest
{
#ifdef OPENGL
 zoom_erster_klick=1;
#endif
}

void k_load(long n) {file_load();}
void k_save()	{file_save();}
void k_show_total()	{show_total();}
void k_show_previ()	{show_previous();}
void k_show_zoom()	{k_zoom_korr(); flg_schalten(&zoom_flg);}
void k_show_xzoom()	{k_zoom_korr(); flg_schalten(&xzoom_flg);}
void k_show_yzoom()	{k_zoom_korr(); flg_schalten(&yzoom_flg);}
void k_show_numzoom() {number_zoom();}
void k_show_goback()	{show_goback();}
#ifndef MIT_SUBMENUS
void k_show_frame();
void k_show_text();
void k_show_atext();
#endif
void k_show_frame_off(long id) 	{setramen_umschalten(0,id);}
void k_show_frame_yaxisu(long id) {setramen_umschalten(1,id);}
void k_show_frame_yaxis0(long id) {setramen_umschalten(2,id);}
void k_show_frame_3d(long id) {setramen_umschalten(3,id);}
void k_show_text_pos()	{settextpos();}
void k_show_text_on(long id)	{textflag_umschalten(1,id);}
void k_show_text_off(long id)	{textflag_umschalten(0,id);}
void k_show_atext_xyon(long id)  {xytextflag_umschalten(1,id);}
void k_show_atext_xyoff(long id) {xytextflag_umschalten(0,id);}
void k_show_atext_x()
		{char *str;
		 if(labeltext_flag==0)  spename_laden();
		 lower_window();
		 str=inputstr1("(%s) x-AxisText:",xlabeltext);
		 if(*str!=0) strncpy(xlabeltext,str,80);
		 raise_window();
		}
void k_show_atext_y()
		{char *str;
		 if(labeltext_flag==0)  spename_laden();
		 lower_window();
		 str=inputstr1("(%s) y-AxisText:",ylabeltext);
		 if(*str!=0) strncpy(ylabeltext,str,80);
		 raise_window();
		}
void k_edit_undo()	{edit_undo();}
void k_edit_setpoint()	{flg_schalten(&on_flg);}
void k_edit_savep()	{edit_save_points();}
void k_edit_lasts()	{edit_last_saved();}
void k_smooth()	{if(setsmoothpara()) smooth(smoothNr,gewichtung);}
void k_smooth3(long id) {setsmooth(0); smooth_umschalten(0,id);}
void k_smooth3w(long id) {setsmooth(1);smooth_umschalten(1,id);}
void k_smooth5(long id) {setsmooth(2); smooth_umschalten(2,id);}
void k_smooth5w(long id) {setsmooth(3);smooth_umschalten(3,id);}
void k_smoothn(long id) {setsmooth(4); smooth_umschalten(4,id);}
void k_smoothhelp(long id) {smooth_help();}
void k_blowupfakt()
		{lower_window();
		 blowupfaktor=doubinputstr1(
			"(%.3lf) BlowUpFaktor:",blowupfaktor);
		 raise_window();
		}
void k_blowupshift()
		{char *str;
		 lower_window();
		 blowupshift=doubinputstr1("(%.3lf) BlowUpShift:",blowupshift);
		 str=inputstr1("(%ld) Strichelungen ausschalten ?",
					ohnestrichelung);
		 if(*str!=0)
			{if((isdigit(*str) && *str!='0') ||
			    toupper(*str)=='J')  ohnestrichelung=1;
			 else ohnestrichelung=0;
			}
		 cfree(str);
		 str=inputstr1("(%ld) Alle Spektren aufblasen ?",
					blowup_all);
		 if(*str!=0)
			{if((isdigit(*str) && *str!='0') ||
			    toupper(*str)=='J')  blowup_all=1;
			 else blowup_all=0;
			}
		 cfree(str);
		 raise_window();
		}
void k_blowup()		{flg_schalten(&blowup_flg);}
void k_peak_off()	{getintoff();}
void k_peak_integral()	{int_sflag=0; flg_schalten(&integral_flg);}
void k_peak_intsave()	{peak_intsave();}
void k_peak_integrals()	{int_sflag=1; flg_schalten(&integral_flg);}
void k_peak_getpoint()	{get_sflag=0; flg_schalten(&getpoint_flg);}
void k_peak_getpoints()	{get_sflag=1; flg_schalten(&getpoint_flg);}
void k_peak_getdeltas()	{flg_schalten(&getdeltas_flg);}
#ifndef MIT_SUBMENUS
void k_peak_pointsearch();
void k_peak_deltasearch();
#endif
void k_peak_pointsearch_norm(long id) {search_umsch(id,0);}
void k_peak_pointsearch_max(long id) {search_umsch(id,1);}
void k_peak_pointsearch_min(long id) {search_umsch(id,2);}
void k_peak_pointsearch_radius()
	{lower_window();
	 search_radius=intinputstr1("(%d) Suchradius:",search_radius);
	 raise_window();
	}
void k_peak_dpointsearch_norm(long id) {dsearch_umsch(id,0);}
void k_peak_dpointsearch_max(long id) {dsearch_umsch(id,1);}
void k_peak_dpointsearch_min(long id) {dsearch_umsch(id,2);}
void k_peak_puundin()	{int_sflag=get_sflag=1; flg_schalten(&puundin_flg);}
void k_peak_puunddelta(){int_sflag=0; get_sflag=1; flg_schalten(&puundin_flg);}
void k_subtra_undo()	{subtra_undo();}
void k_subtra_position(){subtra_position();}
void k_subtra_stretch()	{subtra_stretch();}
void k_subtra_subtract(){subtra_subtract();}
void k_subtra_divid()	{subtra_divid();}
void k_subtra_beer()	{subtra_beer();}
void k_subtra_swap()	{subtra_swap(1);}
void k_subtra_exchange(){subtra_exchange();}
void k_subtra_subramp()	{flg_schalten(&subramp_flg);}
void k_subtra_spektruma(){spektnr_setzen("A",&spektruma);}
void k_subtra_spektrumb(){spektnr_setzen("B",&spektrumb);}
void k_modus1(long id)	{//modus_1_idnr = (id<0) ? -id-1 : id;//test
			 //printf("modus_1_idnr=%ld\n",modus_1_idnr);//test
			 modus_togg(1);
			}
void k_modus2(long id)	{modus_togg(2);}
void k_modus4(long id)	{modus_togg(4);}
void k_modus5(long id)	{modus_togg(5);}
//void k_laser()	{plotter(DECLASER); /* DEC Laser  */}
//void k_lasereps()	{plotter(IBMLASER); /* IBM Laser  */}
//void k_hpdj()		{plotter(PSPLOTTER); /* HP DeskJet, Tektronix Phaser*/}
//void k_hp()		{plotter(HPGLPLOTTER);/*HP PaintJet, PS-FarbDrucker */}
//void k_hpgl()		{plotter(HPGLDATEI);}
//void k_iff()		{plotter(IFFDATEI);}
//void k_tellagr()	{plotter(TELLDATEI); /* Tellagraf  */}
void k_postscr()	{plotter(PSDATEI);   /* Postscript */}
void k_postscr2()	{plotter(PSDATEIFARBIG);}
void k_rohxy()		{plotter(ROHXYDATEI); /* XY-Datei */}
void k_setlinewidth()	{lower_window();
			 linewidth=doubinputstr1(
				"(%.2lf) Linewidth:",linewidth);
			 raise_window();
			}
void k_setcolors()	{lower_window(); setcolors(); raise_window();}
void k_strichelung()	{char *str;
			 lower_window();
			 str=inputstr1("(%ld) Strichelungen ausschalten ?",
						ohnestrichelung);
			 if(*str!=0)
				{if((isdigit(*str) && *str!='0') ||
				    toupper(*str)=='J')  ohnestrichelung=1;
				 else ohnestrichelung=0;
				}
			 cfree(str);
			 raise_window();
			}
void k_divers_packmethode()
			{lower_window();
			 PM=intinputstr1("(%ld) Packmethode:",PM);
			 printfpackmethode(1);
			 raise_window();
			}
void k_divers2()
	{fragebeschrift('x',&xstrichlang,&xteilung,&xeinteilung,&xter);}
void k_divers3()
	{fragebeschrift('y',&ystrichlang,&yteilung,&yeinteilung,&yter);}
void k_divers4()
	{lower_window();
	 xbuch=intinputstr1("(%d) Buchstabengroesse x-Achse:",xbuch);
	 ybuch=intinputstr1("(%d) Buchstabengroesse y-Achse:",ybuch);
	 tbuch=intinputstr1("(%d) Buchstabengroesse Titel:",tbuch);
	 titelabst=intinputstr1("(%d) Zeilenabstand in Titel:",titelabst);
	 ramenlinewidth=doubinputstr1(
		"(%.1lf) Achsen-Strichstaerke:",ramenlinewidth);
	 raise_window();
	}
void k_divers5()	{lower_window();
			 rrand=intinputstr1("(%d) Groesse des Randes:",rrand);
			 raise_window();
			}
void k_divers_yskal()	{yskalierung(NULL);}
void k_divers_integmethode(){integ_methode();}
void k_divers_loadvoreinst(){load_voreinstellungen();}
void k_divers_voreinst(){save_voreinstellungen();}
void k_fft()		{fft_start(0);}
void k_fftinvers()	{fft_start(1);}
void k_fftmethode()	{fft_methode();}

void k_refresh()
{
#ifdef OPENGL
 fadenkreuz_aus();
 reset_flags();
#endif
 refresh();
}

char *deutsches_menu[200]={NULL};
const char *const_deutsches_menu[200]=
#ifdef MIT_SUBMENUS
{"File",      "Show",    "Edit",    "Peak",      "Subtra",       "Modus",      "Diverses",           "Fourier",    "Refresh",
 "Load",     "Total",    "undo",    "Off",       "undo",         text_modus_1, "Packmethode",        "FFT",        "Refresh",
 "Save",  "Previous", "Set Point",  "Integral",  "position (B)", text_modus_2,"x-Achsenbeschriftung","FFT Invers",   NULL,
 "Plot EPS",  "Zoom", "Save Points", "Int-Save", "stretch (B)", text_modus_4,"y-Achsenbeschriftung","FFT Methode ", NULL,
 "save XY", "x-Zoom", "Last Saved", "Integrals", "Subtract (A-B -> A)",text_modus_5,"Buchstabengroessen",   NULL,   NULL,
 "Exit",      "y-Zoom",	    "SmoothNr   ->","Get Point", "Divid (A/B -> A)",   NULL,	  "Randbreite",     NULL,   NULL,
 /** SmoothNr Submenus **/
 text_smoot_3, text_smoot_3w, text_smoot_5, text_smoot_5w,
 text_smoot_n, text_smoot_help, "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
 NULL,      "Number-Zoom",  "Smooth ...",  "Get Points",   "BeerLambert  -log(A/B) -> A",
	NULL,	  "y-Skalierung",	 NULL,		NULL,
 NULL,      "go bak",	    "blowupFaktor", "Get Deltas",   "exchange (A<->B)",
	NULL,	  "Integral_Methode",	   NULL,	NULL,
 NULL,      "Frame        ->","blowupShift", "Points & Intgs", "swap (B)",
	NULL,	  "Load_Voreinstellungen", NULL,	NULL,
/** Frame Submenus **/
 text_frame_off, text_frame_below, text_frame_zero, text_frame_3d,
 "reserve", "reserve", "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
 NULL,      "Text         ->","blow up",   "Points & Deltas","subramp (A)",
	NULL,	  "Save_Voreinstellungen", NULL,	NULL,
/** Text  Submenus **/
 "Set Position", text_text_on, text_text_off,
 "reserve", "reserve", "reserve", "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
 NULL,      "Axis Text    ->", NULL,	"Points Search   ->", "Spektrum A",
	NULL,		NULL,		 NULL,		NULL,
/** Axis_Text  Submenus **/
 text_atext_on, text_atext_off, "x-Text", "y-Text",
/** Points Search  Submenus **/
 text_search_norm, text_search_max, text_search_min, "SuchRadius",
 "reserve",
/** wieder Hauptmenus **/
 NULL,      NULL,	 NULL,		"Delta Search    ->", "Spektrum B",
	NULL,		NULL,		 NULL,		NULL,
/** Delta Search  Submenus **/
 text_dsearch_norm, text_dsearch_max, text_dsearch_min, "SuchRadius"
 ,"reserve", "reserve", "reserve", "reserve", "reserve"
};
#else  //Variante ohne Submenus:
{"File",      "Show",    "Edit",    "Peak",      "Subtra",       "Modus",      "Diverses",           "Fourier",    "Refresh",
 "Load",     "Total",    "undo",    "Off",       "undo",         text_modus_1, "Packmethode",        "FFT",        "Refresh",
 "Save",  "Previous", "Set Point",  "Integral",  "position (B)", text_modus_2,"x-Achsenbeschriftung","FFT Invers",   NULL,
 "Plot EPS",  "Zoom", "Save Points", "Int-Save", "stretch (B)", text_modus_4,"y-Achsenbeschriftung","FFT Methode ", NULL,
 "save XY", "x-Zoom", "Last Saved", "Integrals", "Subtract (A-B -> A)",text_modus_5,"Buchstabengroessen",   NULL,   NULL,
 "Exit",      "y-Zoom",	    "Smooth Help ...","Get Point", "Divid (A/B -> A)",   NULL,	  "Randbreite",     NULL,   NULL,
 /** SmoothNr Submenus **/
 text_smoot_3, text_smoot_3w, text_smoot_5, text_smoot_5w,
 text_smoot_n, text_smoot_help, "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
 NULL,      "Number-Zoom",  "Smooth ...",  "Get Points",   "BeerLambert  -log(A/B) -> A",
	NULL,	  "y-Skalierung",	 NULL,		NULL,
 NULL,      "go bak",	    "blowupFaktor", "Get Deltas",   "exchange (A<->B)",
	NULL,	  "Integral_Methode",	   NULL,	NULL,
 NULL,      "Frame  ...",   "blowupShift", "Points & Intgs", "swap (B)",
	NULL,	  "Load_Voreinstellungen", NULL,	NULL,
/** Frame Submenus **/
 text_frame_off, text_frame_below, text_frame_zero, text_frame_3d,
 "reserve", "reserve", "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
 NULL,      "Text  ...","blow up",   "Points & Deltas","subramp (A)",
	NULL,	  "Save_Voreinstellungen", NULL,	NULL,
/** Text  Submenus **/
 "Set Position", text_text_on, text_text_off,
 "reserve", "reserve", "reserve", "reserve", "reserve", "reserve",
/** wieder Hauptmenus **/
 NULL,      "Axis Text ...", NULL,	"Points Search ...", "Spektrum A",
	NULL,		NULL,		 NULL,		NULL,
/** Axis_Text  Submenus **/
 text_atext_on, text_atext_off, "x-Text", "y-Text",
/** Points Search  Submenus **/
 text_search_norm, text_search_max, text_search_min, "SuchRadius",
 "reserve",
/** wieder Hauptmenus **/
 NULL,      NULL,	 NULL,		"Delta Search ...", "Spektrum B",
	NULL,		NULL,		 NULL,		NULL,
/** Delta Search  Submenus **/
 text_dsearch_norm, text_dsearch_max, text_dsearch_min, "SuchRadius"
 ,"reserve", "reserve", "reserve", "reserve", "reserve"
};
#endif

#define ITX(n) text[i+n]
#define SETMENU i+=9;setmenu

//extern int menu_debug;//test

void constmenu_kopieren(char *ziel[],const char *quelle[])
{
 if(ziel[0]==NULL)
  {
   for(int i=0; i<200; i++)
    {
     //ziel[i] = quelle[i];
     if(quelle[i]!=NULL)
      {
       ziel[i] = new char[strlen(quelle[i])+1];
       strcpy(ziel[i],quelle[i]);
      }
    }
  }
}

void menu_start(const char *version)
{
 char **text;
 int i=0;
// menu_debug=1;//test
 //static char fenstname[80];
 //sprintf(fenstername=fenstname," Showit %s ",version);
 sprintf(fenstername," Showit %s ",version);
 fenstername1_len=strlen((char*)fenstername);
 //if(sprache==DEUTSCH)
 constmenu_kopieren(deutsches_menu,const_deutsches_menu);
 //else constmenu_kopieren(deutsches_menu,const_english_menu);
 text=deutsches_menu;
 setmenu(9,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),ITX(7),ITX(8));
 SETMENU(9,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),ITX(7),ITX(8),
	k_load,k_show_total,k_edit_undo,k_peak_off,k_subtra_undo,
	k_modus1,k_divers_packmethode,k_fft,k_refresh);
 SETMENU(8,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),ITX(7),
	k_save,k_show_previ,k_edit_setpoint,k_peak_integral,k_subtra_position,
	k_modus2,k_divers2,k_fftinvers);
 SETMENU(8,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),ITX(7),
	k_postscr2, k_show_zoom,k_edit_savep,k_peak_intsave,k_subtra_stretch,
	k_modus4,k_divers3,k_fftmethode);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	k_rohxy, k_show_xzoom,k_edit_lasts,k_peak_integrals,k_subtra_subtract,
	k_modus5,k_divers4);
#ifdef MIT_SUBMENUS
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	file_exit,k_show_yzoom,NULL,k_peak_getpoint,k_subtra_divid, NULL,k_divers5);
 i+=9;
 setsubmenu(3,NULL,NULL,ITX(0),NULL,NULL,k_smooth3); //Smootnr Submenu
 setsubmenu(3,NULL,NULL,ITX(1),NULL,NULL,k_smooth3w);
 setsubmenu(3,NULL,NULL,ITX(2),NULL,NULL,k_smooth5);
 setsubmenu(3,NULL,NULL,ITX(3),NULL,NULL,k_smooth5w);
 setsubmenu(3,NULL,NULL,ITX(4),NULL,NULL,k_smoothn);
 setsubmenu(3,NULL,NULL,ITX(5),NULL,NULL,k_smoothhelp);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,k_show_numzoom,k_smooth,k_peak_getpoints,k_subtra_beer,
	NULL,k_divers_yskal);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,k_show_goback,k_blowupfakt,k_peak_getdeltas,k_subtra_exchange,
	NULL,k_divers_integmethode);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,NULL,k_blowupshift,k_peak_puundin,k_subtra_swap,
	NULL,k_divers_loadvoreinst);
 i+=9;
 setsubmenu(2,NULL,ITX(0),NULL,k_show_frame_off);	//Frame Untermenus
 setsubmenu(2,NULL,ITX(1),NULL,k_show_frame_yaxisu);
 setsubmenu(2,NULL,ITX(2),NULL,k_show_frame_yaxis0);
 setsubmenu(2,NULL,ITX(3),NULL,k_show_frame_3d);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,NULL,k_blowup,k_peak_puunddelta,k_subtra_subramp,
	NULL,k_divers_voreinst);
 i+=9;
 setsubmenu(2,NULL,ITX(0),NULL,k_show_text_pos);	//Text Untermenus
 setsubmenu(2,NULL,ITX(1),NULL,k_show_text_on);
 setsubmenu(2,NULL,ITX(2),NULL,k_show_text_off);
 SETMENU(5,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),
	NULL,NULL,NULL,NULL,k_subtra_spektruma);
 i+=9;
//AxisText Untermenus und PointSearch Untermenus
 setsubmenu(4,NULL,ITX(0),NULL,ITX(4),
		NULL,k_show_atext_xyon,NULL,k_peak_pointsearch_norm);
 setsubmenu(4,NULL,ITX(1),NULL,ITX(5),
		NULL,k_show_atext_xyoff,NULL,k_peak_pointsearch_max);
 setsubmenu(4,NULL,ITX(2),NULL,ITX(6),
		NULL,k_show_atext_x,NULL,k_peak_pointsearch_min);
 setsubmenu(4,NULL,ITX(3),NULL,ITX(7),
		NULL,k_show_atext_y,NULL,k_peak_pointsearch_radius);
 SETMENU(5,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),
	 NULL,NULL,NULL,NULL,k_subtra_spektrumb);
 i+=9;
//DeltaPointSearch Untermenus
 setsubmenu(4,NULL,NULL,NULL,ITX(0), NULL,NULL,NULL,k_peak_dpointsearch_norm);
 setsubmenu(4,NULL,NULL,NULL,ITX(1), NULL,NULL,NULL,k_peak_dpointsearch_max);
 setsubmenu(4,NULL,NULL,NULL,ITX(2), NULL,NULL,NULL,k_peak_dpointsearch_min);
 setsubmenu(4,NULL,NULL,NULL,ITX(3), NULL,NULL,NULL,k_peak_pointsearch_radius);
 
#else  //Variante ohne Submenus:
 
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	file_exit,k_show_yzoom, k_smoothhelp, k_peak_getpoint,k_subtra_divid, NULL,k_divers5);
 i+=9;
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,k_show_numzoom,k_smooth,k_peak_getpoints,k_subtra_beer,
	NULL,k_divers_yskal);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,k_show_goback,k_blowupfakt,k_peak_getdeltas,k_subtra_exchange,
	NULL,k_divers_integmethode);
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	NULL,k_show_frame,k_blowupshift,k_peak_puundin,k_subtra_swap,NULL,k_divers_loadvoreinst);
 i+=9;  //Frame Untermenus ueberspringen
 SETMENU(7,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),ITX(5),ITX(6),
	 NULL,k_show_text,k_blowup,k_peak_puunddelta,k_subtra_subramp,NULL,k_divers_voreinst);
 i+=9;	//Text Untermenus ueberspringen
 SETMENU(5,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),
	NULL,k_show_atext,NULL,k_peak_pointsearch,k_subtra_spektruma);
 i+=9;  //AxisText Untermenus und PointSearch Untermenus ueberspringen
 SETMENU(5,ITX(0),ITX(1),ITX(2),ITX(3),ITX(4),
	 NULL,NULL,NULL,k_peak_deltasearch,k_subtra_spektrumb);
 i+=9;  //DeltaPointSearch Untermenus ueberspringen
#endif  //Ende Variante ohne Submenus
 SETMENU(1,NULL,NULL);
 //printf("Test: ITX(3) entspricht text[i+3] entspricht text[%d]\n",i+3);//test
}
/*************************** Ende Menu ***********************************/

void
fragebeschrift(int x,int* strichlang,int* teilung,int* einteilung,int* ter)
{
 lower_window();
 printf("\n  %c-Achse-Beschriftung\n",x);
 printf("  ********************\n");
 printf("(%d) Strichelung-Einteilung:\n",*einteilung);
 printf("   0 = automatisch\n");
 printf("   1 = bei runder Zahl beginnen\n");
 printf("   2 = nichts runden                         Auswahl:");
 scanf("%d",einteilung);
 printf("(%d) Anzahl Markierungen auf %c-Achse:",*teilung,x);
 scanf("%d",teilung);
 printf("(%d) Strichelung-Laengen:\n",*strichlang);
 printf("   0 = automatisch\n");
 printf("   1 = alle Striche gleich lang\n");
 printf("   x = jeder x-te Strich laenger             Auswahl:");
 scanf("%d",strichlang);
 printf("(%d) Jede N-te Markierung beschriften N=",*ter); scanf("%d",ter);
 raise_window();
}

char *inputstr1(const char *frage,long alt)
{
 char *str;
 str=(char *)calloc(80,1); if(str==NULL) return NULL;
 printf(frage,alt); getline(stdin,str,80);
 if(str[0]==0) getline(stdin,str,80);
 return str;
}

char *inputstr1(const char *frage,const char *alt)
{
 char *str;
 str=(char *)calloc(80,1); if(str==NULL) return NULL;
 printf(frage,alt); getline(stdin,str,80);
 if(str[0]==0) getline(stdin,str,80);
 return str;
}

char *inputstr3(const char *frage,long a1,long a2,long a3,long a4)
{
 char *str;
 str=(char *)calloc(80,1); if(str==NULL) return NULL;
 printf(frage,a1,a2,a3,a4); getline(stdin,str,80);
 if(str[0]==0) getline(stdin,str,80);
 return str;
}

char *inputstr1lf(const char *frage,double alt)
{
 char *str;
 str=(char *)calloc(80,1); if(str==NULL) return NULL;
 printf(frage,alt); getline(stdin,str,80);
 if(str[0]==0) getline(stdin,str,80);
 return str;
}

int intinputstr1(const char *frage,int alt)
{
 int neu;
 char *s; s=inputstr1(frage,alt);
 if(*s==0) neu=alt; else sscanf(s,"%d",&neu);
 cfree(s);
 return neu;
}

double doubinputstr1(const char *frage,double alt)
{
 double neu;
 char *s; s=inputstr1lf(frage,alt);
 if(*s==0) neu=alt; else sscanf(s,"%lf",&neu);
 cfree(s);
 return neu;
}

float *feldcalloc()
{
 float *p;
 p=(float *)calloc(npkt,sizeof(float));
 if(p==NULL) {printf("zu wenig RAM\n"); exit(2);}
 return p;
}

void showit(float* xmin,float* ymin,float* xmax,float* ymax,
		int* npoints,int* modus,float* feld,float* hfeld)
{
// extern double xmi1,ymi1,xma1,yma1,deltax;
// extern double xmi2,ymi2,xma2,yma2;
// extern int npkt,shmodus;
 int i;
 FILE *fp;
 set_funktions(klick1,klick0,fensterposition,bewegung1);
 if( (fp=fopen(showit_voreinst,"r"))!=NULL
     || (fp=fopen(showit_voreinst_global,"r"))!=NULL )
	{voreinstellungen_lesen(fp); fclose(fp);}
 menu_start(VERSION);
// shmodus = *modus;
 shmodus = *modus & ~MODUSZUSATZ_MASK;
 moduszusatz = *modus & MODUSZUSATZ_MASK;
 if(shmodus>=5) {nspektren=shmodus-4; shmodus=5;}
 else if(shmodus==4) nspektren=2;
 else nspektren=1;
 if(shmodus<SHMODMIN || shmodus>SHMODMAX)
	{printf("Fehler: SHOWIT(...MODUS=%d...)\n",shmodus); exit(1);}
 xmi2=xmi1= *xmin; ymi2=ymi1= *ymin; xma2=xma1= *xmax; yma2=yma1= *ymax;
 npkt= *npoints; zfeld=feld; zhfeld=hfeld;
 if(ymi1==yma1) ymimaxsuchen(zfeld,NULL);
 penfeld=(short *)calloc(npkt+1,sizeof(short));
 if(penfeld==NULL) {printf("zu wenig RAM\n"); exit(3);}
 for(i=0;i<=npkt;i++) penfeld[i]=DOWN;
 if(yskalfakt!=1.) {double f=yskalfakt; yskalfakt=1.; spektren_skalieren(f);}
 set_new_shmodus();
 deltax=(xma1-xmi1)/(npkt-1);
 
 //setsize(1000,700,4);
 int maxbreite,maxhoehe,tiefe,visclass;
 getmaxsize(&maxbreite,&maxhoehe,&tiefe,&visclass);
 maxbreite = maxbreite*3/4;
 maxhoehe = maxhoehe*7/8;
 setsize(maxbreite,maxhoehe,tiefe);
 
 show_total();
 showit_gestartet=1;
 if(moduszusatz & AUTOPLOTEXIT) {plotter(PSDATEI); file_exit();}
 if(moduszusatz & AUTOSAVEEXIT) {file_save(); file_exit();}
 istinwarteschlaufe=1;
 for(;;) {Delay(1); if(waitmenu(0)!=0) file_exit();}
/* dieses UnterProgramm wird nie verlassen */
}
void ymimaxsuchen(float *pf,float *pf2)
{
 int i;
 ymi1=yma1=0.;
 for(i=0;i<npkt;i++,pf++)
	{if(*pf<ymi1) ymi1= *pf;
	 else if(*pf>yma1) yma1= *pf;
	}
 if(pf2)
  for(i=0;i<npkt;i++,pf2++)
	{if(*pf2<ymi1) ymi1= *pf2;
	 else if(*pf2>yma1) yma1= *pf2;
	}
 ymi2=ymi1; yma2=yma1;
}

void new_hfeld(float *hfeld,int *modus)
{
 int i,nspektren_alt=nspektren;
 float *zh,*zhmax;
 shmodus = *modus;
 if(shmodus>=5) {nspektren=shmodus-4; shmodus=5;}
 else if(shmodus==4) nspektren=2;
 else nspektren=1;
 if(shmodus<SHMODMIN || shmodus>SHMODMAX)
	{printf("Fehler: NEW_HFELD(...MODUS=%d)\n",shmodus);
	 printf("Korrektur: MODUS=%d\n",shmodus=4);
	}
 if(zhfeld!=hfeld)
	zh=zhfeld=hfeld;
 else if(nspektren>nspektren_alt && zhfeld!=NULL)
	zh= &zhfeld[(nspektren_alt-1)*npkt];
 else zh=NULL;
 if(zh && yskalfakt!=1.)
	{zhmax= &zhfeld[(nspektren-1)*npkt];
	 while(zh<zhmax) *zh++ /= yskalfakt;
	}
 set_new_shmodus();
}

static void set_new_shmodus()
{
 int i,j;
 if(shmodus==2 || shmodus==3)
	{if(zhfeld==NULL) {zhfeld=feldcalloc(); shmodus=3;}
	 if(shmodus==3)
		{for(i=0;i<npkt;i++) zhfeld[i]=zfeld[i];
		 shmodus=2;
		}
	}
 subtra_flag=(zhfeld!=NULL && shmodus>=4);
 labeltext_flag=0;
 if(nspektren>1)
  {int neuesb=nspektren-1;
   if(spektrumb!=neuesb)
	{spektrumb=neuesb; swap_flag=subtr_flag=strepos_flag=0;}
  }
 modus_umschalten(shmodus);
}

void modus_togg(int k)
{
 switch(k)
	{case 1:modus_1(); break;
	 case 2:modus_2(); break;
	 case 4:modus_4(); break;
	 case 5:modus_5(); break;
	}
}

void modus_1()
{
 shmodus=1;
 set_new_shmodus(); refresh();
}

void modus_2()
{
/* if(shmodus!=2 && zhfeld!=NULL)  {fragekasten(2); return;} */
 if(shmodus!=2 && zhfeld!=NULL)
	{if(janeinrequester("2. Spektrum entfernen ?","ja","nein")==0) return;}
 shmodus=3;
 set_new_shmodus(); refresh();
}

void modus_4()
{
 if(shmodus!=4 && zhfeld==NULL)
	{nspektren=2; shmodus=3; set_new_shmodus();}
 shmodus=4;
 set_new_shmodus(); refresh();
}

void modus_5()
{
 if(shmodus!=5 && zhfeld==NULL)
	{nspektren=2; shmodus=3; set_new_shmodus();}
 if(nspektren<2) nspektren=2;
 shmodus=5;
 set_new_shmodus(); refresh();
}

void voreinstellungen_reset()
{
 xeinteilung=AUTO; xteilung=20; xstrichlang=AUTO; xter=5;
 yeinteilung=HALBAUTO; yteilung=8; ystrichlang=2; yter=2;
 rrand=0;
 packmethode=1;
 xbuch=ybuch=123; ramenlinewidth=1.0;
 tbuch=TBUCHDEFAULT; titelabst=TITABSTDEFAULT;
 linewidth=0.5;
 if(textflag!=1) textflag_umschalten(textflag=1,0L);
 if(xytextflag!=0) xytextflag_umschalten(xytextflag=0,0L);
 if(ramen_flag!=1) setramen_umschalten(ramen_flag=1,0L);
 if(search_methode) search_umsch(0L,search_methode=0);
 search_radius=6;
 if(dsearch_methode) dsearch_umsch(0L,dsearch_methode=0);
 integral_methode=0;
}

void voreinstellungen_lesen(FILE *fp)
{
 char key[80];
 int c;
 spektcolors=0;
 while((c=getc(fp))!=EOF)
  {ungetc(c,fp);
   fscanf(fp,"%s",key);
   if(strcmp(key,"xachse")==0)
	 fscanf(fp,"%d %d %d %d",&xeinteilung,&xteilung,&xstrichlang,&xter);
   else if(strcmp(key,"yachse")==0)
	 fscanf(fp,"%d %d %d %d",&yeinteilung,&yteilung,&ystrichlang,&yter);
   else if(strcmp(key,"randbreite")==0) fscanf(fp,"%d",&rrand);
   else if(strcmp(key,"packmethode")==0)
		{fscanf(fp,"%d",&packmethode); printfpackmethode(0);}
   else if(strcmp(key,"buchstabengroessen")==0)
	  fscanf(fp,"%d %d %lf",&xbuch,&ybuch,&ramenlinewidth);
   else if(strcmp(key,"titelgroessen")==0)
	  fscanf(fp,"%d %d",&tbuch,&titelabst);
   else if(strcmp(key,"setlinewidth")==0) fscanf(fp,"%lf",&linewidth);
   else if(strcmp(key,"textflag")==0)
	  {fscanf(fp,"%d",&textflag); textflag_umschalten(textflag,0L);}
   else if(strcmp(key,"xytextflag")==0)
	  {fscanf(fp,"%d",&xytextflag); xytextflag_umschalten(xytextflag,0L);}
   else if(strcmp(key,"ramenflag")==0)
	  {fscanf(fp,"%d",&ramen_flag); setramen_umschalten(ramen_flag,0L);}
   else if(strcmp(key,"searchmethode")==0)
	  {fscanf(fp,"%d",&search_methode); search_umsch(0L,search_methode);}
   else if(strcmp(key,"searchradius")==0)
	  {fscanf(fp,"%d",&search_radius);}
   else if(strcmp(key,"dsearchmethode")==0)
	  {fscanf(fp,"%d",&dsearch_methode); dsearch_umsch(0L,dsearch_methode);}
   else if(strcmp(key,"integralmethode")==0) fscanf(fp,"%d",&integral_methode);
   else if(strcmp(key,"alfa_3d")==0)
		{int alfa=int(alfa_3d/GRAD+0.5);
		 fscanf(fp,"%d %lf",&alfa,&verkuerzung_3d);
		 alfa_3d=alfa*GRAD;
		 eingabe_3d(1);
		}
   else if(strcmp(key,"spektcolors")==0)
		{int i,n;
		 fscanf(fp,"%d",&n);//Anzahl Farben
		 for(i=1;i<=n;i++) //fuer jede Farbe RGB-Wert einlesen
			fscanf(fp,"%d %d %d",&Rot[i],&Gruen[i],&Blau[i]);
		 spektcolors=n;
		}
   else {printf("unknown keyword in datafile: '%s'\n",key); break;}
  }
}

void save_voreinstellungen()
{
 FILE *fp;
 if((fp=fopen(showit_voreinst,"w"))==NULL)
	{printf("kann '%s' nicht oeffnen\n",showit_voreinst); return;}
 fprintf(fp,"xachse %d %d %d %d\n",xeinteilung,xteilung,xstrichlang,xter);
 fprintf(fp,"yachse %d %d %d %d\n",yeinteilung,yteilung,ystrichlang,yter);
 fprintf(fp,"randbreite %d\n",rrand);
 fprintf(fp,"packmethode %d\n",packmethode);
 fprintf(fp,"buchstabengroessen %d %d %lf\n",xbuch,ybuch,ramenlinewidth);
 fprintf(fp,"titelgroessen %d %d\n",tbuch,titelabst);
 fprintf(fp,"setlinewidth %lf\n",linewidth);
 if(textflag!=1) fprintf(fp,"textflag %d\n",textflag);
 if(xytextflag!=0) fprintf(fp,"xytextflag %d\n",xytextflag);
 if(ramen_flag!=1) fprintf(fp,"ramenflag %d\n",ramen_flag);
 if(ramen_flag==3) fprintf(fp,"alfa_3d %d %lf\n",
				int(alfa_3d/GRAD+0.5),verkuerzung_3d);
 if(search_methode!=0) fprintf(fp,"searchmethode %d\n",search_methode);
 if(search_radius!=6) fprintf(fp,"searchradius %d\n",search_radius);
 if(dsearch_methode!=0) fprintf(fp,"dsearchmethode %d\n",dsearch_methode);
 if(integral_methode!=0) fprintf(fp,"integralmethode %d\n",integral_methode);
 if(spektcolors!=0)
		{int i,n=spektcolors;
		 fprintf(fp,"spektcolors %d",n);//Anzahl Farben
		 for(i=1;i<=n;i++) //fuer jede Farbe RGB-Wert schreiben
			{fprintf(fp,"  %d %d %d",Rot[i],Gruen[i],Blau[i]);
			 if((i%4)==0) putc('\n',fp);
			}
		 if((n%4)!=0) putc('\n',fp);
		}
 fclose(fp);
}
void load_voreinstellungen()
{
 FILE *fp;
 char str[80];
 lower_window();
 printf("Load_Voreinst. File:"); scanf("%s",str);
 if((fp=fopen(str,"r"))!=NULL)
	{voreinstellungen_reset(); voreinstellungen_lesen(fp);
	 if(spektcolors) setcolors(1);
	 fclose(fp);
        }
 else	printf("kann '%s' nicht finden\n",str);
 raise_window();
}

void setcolors(int autoflag)
{
 int i,n;
 if(!autoflag)
  {lower_window();
   printf("Farben aendern (255,255,255 = weiss auf Schirm, schwarz auf Papier)\n");
   printf(" Farbe 0 = Beschriftung,  Farbe1 = 1.Spektrum ...\n");
   if((n=nspektren+1)>MAXCOLOR) n=MAXCOLOR;//auf 16 Farben beschraenkt
   if(n-1>spektcolors) spektcolors=n-1;
  }
 else n=MAXCOLOR;
// if(n<3 && shmodus>=3) n=3;//test
 for(i=1;i<n;i++)
  {//printf("Farbe %d:  R,G,B=? (%d,%d,%d)?",i,Rot[i],Gruen[i],Blau[i]);
   //scanf("%d%*c%d%*c%d",&Rot[i],&Gruen[i],&Blau[i]);
   if(!autoflag)
    {char *s=inputstr3("Farbe %ld:  R,G,B=? (%ld,%ld,%ld)?",
		       i,Rot[i],Gruen[i],Blau[i]);
     sscanf(s,"%d%*c%d%*c%d",&Rot[i],&Gruen[i],&Blau[i]); cfree(s);
    }
   //if(tekplot_tiefe>1) setcolor(i,Rot[i],Gruen[i],Blau[i]);
   setcolor(i,Rot[i],Gruen[i],Blau[i]);
  }
 if(!autoflag) raise_window();
}

/*************************** Bewegung ************************************/
#ifdef OPENGL
#define menubalkenhoehe get_menubalkenhoehe()
#else
extern uint menubalkenhoehe;
#endif
#define XWERT(x) (xmi2+dx2*(x))
#define YWERT(y) (yma2-dy2*((y)-menubalkenhoehe))
#define INVXWERT(x) (((x)-xmi2)/dx2)
#define INVYWERT(y) ((yma2-(y))/dy2+menubalkenhoehe)
#define XWERTD(x) (dx2*(x))
#define INVXWERTD(x) ((x)/dx2)

void klick(int knopf,int x,int y,int knopfnr)
{
 //if(klick_igno!=0) {--klick_igno; return;} //Mausklicks ignorieren
 printf("klick(knopf=%d, x=%d, y=%d, knopfnr=%d)\n",knopf,x,y,knopfnr);//test
#ifdef OPENGL
 int neue_nr=knopfnr;
 if(knopfnr==LIMAUS) neue_nr=1;
 else if(knopfnr==MIMAUS) neue_nr=2;
 else if(knopfnr==REMAUS) neue_nr=3;
 else if(knopfnr!=0) printf("Unbekannte Mausknopfnummer=%d\n",knopfnr);//test
 if(neue_nr != knopfnr)
  {
   knopfnr=neue_nr;
   //printf(" neue knopfnr = %d\n",knopfnr);//test
  }
#endif
 static double x1,y1,x2,y2,h;
 static int igno=1; /* Ignoriere 'Knopf losgelassen' */
 static int fun,erfolg,puuflag=0;
 int i;
 float *pzh;
 if(puundin_flg)
	{puuflag=1;
	 switch(knopfnr)
	   {case 1:flg_schalten(&zoom_flg); break;
	    case 2:flg_schalten(&getpoint_flg); break;
	    case 3:if(int_sflag) flg_schalten(&integral_flg);
		   else flg_schalten(&getdeltas_flg);
		   break;
	    default:printf("Error: knopfnr=%d\n",knopfnr);
	   }
	}
 knopf_flag=knopf;
 if(knopf) /* Knopf gedrueckt */
   {
    printf("Mausknopf %d gedrueckt\n",knopfnr);//test
    igno=0;
    if(zoom_flg || xzoom_flg || yzoom_flg || blowup_flg)
	{
	 fadenkreuz(x,y);
	 if(yzoom_flg) x1=xmi2; else x1=XWERT(x);
	 if(xzoom_flg || blowup_flg) y1=ymi2; else y1=YWERT(y);
	}
    else if(on_flg)
	{last_point_i=int((XWERT(x)-xmi1+deltax/2.)/deltax);
	 x1=last_point_i*deltax+xmi1;
	 last_point_y=y1=zfeld[last_point_i];
	 x=int((x1-xmi2+dx2/2.)/dx2);
	 if(x<0)	{x=0; igno=1;}
	 else if(x>tekplot_breite-1) {x=tekplot_breite-1; igno=1;}
	 y=int((yma2-y1+dy2/2.)/dy2+menubalkenhoehe);
	 if(y<0)	{y=0; igno=1;}
	 else if(y>tekplot_hoehe-1) {y=tekplot_hoehe-1; igno=1;}
	 if(igno==0)
	  {
#ifdef OPENGL
	   on_x=x;
	   //tek_fadenkreuz(2); //Fadenkreuzmodus auf doppeltes Kreuz setzen
	   fadenkreuz_setzen(2,x,y);
	   faden_x=x; faden_y=y;
#else
	   on_x=x; //Fadenkreuz auf x-Wert festhalten
	   neuesfadenkreuz(x,y); fadenkreuz(x,y); XSync(dpy,0);
#endif
	  }
	}
    else if(integral_flg || subramp_flg)
	{x1=XWERT(x); y1=YWERT(y); integral_x1=x; integral_y1=y;
	 if(integral_flg)	integral_flg=2;
	 else if(subramp_flg)	subramp_flg=2;
	}
    else if(getdeltas_flg)
	{if(dsearch_methode==0)
		{x1=XWERT(x); y1=YWERT(y); integral_x1=x; integral_y1=y;}
	 else
		{x1=XWERT(x-SEARCHRADI); y1=YWERT(y-SEARCHRADI);
		 x2=XWERT(x+SEARCHRADI); y2=YWERT(y+SEARCHRADI);
		 minmaxsearch(x1,y1,x2,y2);
		 if(dsearch_methode==1) {x1=x2; y1=y2;}//Maximum
		 integral_x1=(int)INVXWERT(x1);
		 integral_y1=(int)INVYWERT(y1);
		}
	 getdeltas_flg=2;
	}
    else if(getpoint_flg)
	{
	 fadenkreuz(x,y);
	 //printf("Peak mit Viereck markiert?\n");//test
	 if(search_methode==0)
		{xgetpunkt=XWERT(x); ygetpunkt=YWERT(y);}
	 else	{/* Maximum zwischen x-dx und x+dx suchen */
		 /* wobei dx = (xma2-xmi2)/npkt*(Cursorbreite/2) */
		 x1=XWERT(x-SEARCHRADI); y1=YWERT(y-SEARCHRADI);
		 x2=XWERT(x+SEARCHRADI); y2=YWERT(y+SEARCHRADI);
		 minmaxsearch(x1,y1,x2,y2);
		 if(search_methode==1)	{xgetpunkt=x2; ygetpunkt=y2;}//Maximum
		 else	{xgetpunkt=x1; ygetpunkt=y1;} //Minimum
		}
	 if(get_sflag)	fun=fun_getpoints;
	 else		fun=fun_getpoint;
	 if(get_sflag==0) lower_window();
	 user_prog(&fun,&xgetpunkt,&ygetpunkt,NULL,NULL);
	 if(get_sflag==0) raise_window();
	 if(get_sflag==0)
	  {
	   printf("get_sflag==0 --> fadenkreuz_aus()\n");//test
	   fadenkreuz_aus(); getpoint_flg=flag_flg=0;
	  }
	}
    else if(stretch_flg || positio_flg)
	{x1=XWERT(x); y1=YWERT(y);}
    else if(settext_flg)
	{
	 fadenkreuz(x,y);
	 printf("Textkasten gesetzt?\n");//test
	 xtext=XWERT(x); ytext=YWERT(y);
	 fadenkreuz_aus(); settext_flg=flag_flg=0;
	}
    else
	igno=1;
   }
 else /* Knopf losgelassen */
   {
    printf("Mausknopf %d losgelassen\n",knopfnr);//test
    if(igno==0)
	{if(zoom_flg || xzoom_flg || yzoom_flg || blowup_flg)
		{
		 fadenkreuz_aus();
		 if(xzoom_flg || blowup_flg) y2=yma2; else y2=YWERT(faden_y);
		 if(yzoom_flg) x2=xma2; else x2=XWERT(faden_x);
		 zoom_flg=xzoom_flg=yzoom_flg=flag_flg=0;
		 if(xma1>xmi1)
			{if(x2<x1) {h=x1; x1=x2; x2=h;}
			 if(x1<xmi1) x1=xmi1;
			 if(x2>xma1) x2=xma1;
			}
		 else	{if(x2>x1) {h=x1; x1=x2; x2=h;}
			 if(x1>xmi1) x1=xmi1;
			 if(x2<xma1) x2=xma1;
			}
		 if((y2<y1 && yma1>ymi1) || (y2>y1 && yma1<ymi1))
			{h=y1; y1=y2; y2=h;}
		 if(x1!=x2 && y1!=y2)
			{if(blowup_flg) blowup(x1,x2);
			 else show(x1,y1,x2,y2,1);
			}
		}
	 else if(on_flg)
		{fadenkreuz_aus();
		 y2=YWERT(faden_y);
		 zfeld[last_point_i]=y2; change_flag=1;
		 if(shmodus==2) zhfeld[last_point_i]=y2;
		 show(xmi2,ymi2,xma2,yma2,0);
		 on_x = -1;/* Fadenkreuz frei beweglich */
		 fadenkreuz_ein();
		}
	 else if(integral_flg)
		{x2=XWERT(faden_x); y2=YWERT(faden_y);
		 if(integral_methode==1) y2=y1;//auf Wunsch von Klaus
		 fadenkreuz_aus();
		 erfolg=integral(x1,y1,x2,y2);
		 if(erfolg && int_sflag==0)
		      integral_flg=flag_flg=0;
		 else {if(erfolg) user_prog(&fun_integrals/*&fun_intsave*/,
					    &integralwert,
					    &xspitze,&yspitze,integralgrenzen);
		       integral_flg=flag_flg=1; fadenkreuz_ein();
		      }
		}
	 else if(getdeltas_flg)
		{x2=XWERT(faden_x); y2=YWERT(faden_y);
		 fadenkreuz_aus();
		 erfolg=differenz(x1,y1,x2,y2);
		 if(erfolg) user_prog(&fun_getdeltas,
				      &integralwert,integralgrenzen,NULL,NULL);
		 getdeltas_flg=flag_flg=1; fadenkreuz_ein();
		}
	 else if(stretch_flg)
		{y2=YWERT(faden_y);
		 if((h=y1-ymi2)==0.) strepos_faktor=1.;
		 else strepos_faktor=(y2-ymi2)/h;
		 if(strepos_faktor==0.) strepos_faktor=1.;
		 pzh=zeigauf(spektrumb);
		 for(i=0;i<npkt;i++)
			*pzh++ *= strepos_faktor;
		 strepos_flag=2;
		 show(xmi2,ymi2,xma2,yma2,0);
		}
	 else if(positio_flg)
		{strepos_faktor = YWERT(faden_y) - y1;
		 pzh=zeigauf(spektrumb);
		 for(i=0;i<npkt;i++)
			*pzh++ += strepos_faktor;
		 strepos_flag=1;
		 show(xmi2,ymi2,xma2,yma2,0);
		}
	 else if(subramp_flg)
		{x2=XWERT(faden_x); y2=YWERT(faden_y);
		 fadenkreuz_aus();
		 subramp_flg=flag_flg=0;
		 subramp(x1,y1,x2,y2);
		}
	 igno=1;
	 if(puuflag) {puuflag=0; flg_schalten(&puundin_flg);}
	}
   }
 return;
}

void fensterposition()
{
 printf("Testpunkt: fensterposition()\n");//test
#ifndef OPENGL
 int flag;
 if(rambildflag && !initalflag)
	{if(!(flag=refreshflag)) fadenkreuz_aus();
	 XCopyArea(dpy,rambild,win1,gc,0,0,winbreite+1,winhoehe+1,0,0);
	 if(!flag) fadenkreuz_ein();
	}
 XSync(dpy,0);
 /* Hier koennte man auch noch die Positionen von	*/
 /* Menufenster und Grafikfenster aneinander anpassen.	*/
#endif
}

#ifdef OPENGL
void bewegung(int x,int y)
{
 //printf("Testpunkt: bewegung(x=%d,y=%d)\n",x,y);//test
 double xwert,ywert;
 xwert=XWERT(x); ywert=YWERT(y);
 sprintf((char*)&fenstername[fenstername1_len]," x=%lg  y=%lg",xwert,ywert);
 //printf("fenstername[] = \"%s\"\n",fenstername);//test
 //TODO
 if(flag_flg)
  {
   //if(on_flg && on_x != -1) fadenkreuz_setzen(2,x,y); //Fadenkreuzmodus auf doppeltes Kreuz setzen
   //else
   fadenkreuz(x,y);
  }
 faden_x=x; faden_y=y;
}

#else

void bewegung(int x,int y)  //Original von showit.cc
{
 double xwert,ywert;
 xwert=XWERT(x); ywert=YWERT(y);
 sprintf((char*)&fenstername[fenstername1_len]," x=%lg  y=%lg",xwert,ywert);
 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8, PropModeReplace,
		 (uchar*)fenstername, strlen((char*)fenstername));
 if(flag_flg)
  {
   if(on_flg && on_x != -1) neuesfadenkreuz(on_x,y);
   else	neuesfadenkreuz(x,y);
   XSync(dpy,0);
  }
 else {faden_x=x; faden_y=y;}
}
#endif

#ifdef OPENGL
void fadenkreuz_ein()
{
 fadenkreuzflag=1;
 tek_faden_setflags(xzoom_flg,yzoom_flg);
 fadenkreuz(faden_x,faden_y);
}

void fadenkreuz_aus()
{
 fadenkreuz_setzen(0,0,0);
 fadenkreuzflag=0;
}

#else

void fadenkreuz_ein()
{
 fadenkreuzflag=1;
 refreshflag=0; 
 if(hintergrundfarbe==1) //sind wir direkt am Henri ?
   {XSetForeground(dpy,gc,1);
    XSetFunction(dpy,gc,GXxor);
   }
 else XSetFunction(dpy,gc,(vordergrundfarbe==0)?GXequiv:GXxor);
 fadenkreuz(faden_x,faden_y);
}

void fadenkreuz_aus()
{
 fadenkreuz(faden_x,faden_y);
 XSetFunction(dpy,gc,GXcopy);
 refreshflag=1; 
 fadenkreuzflag=0;
}
#endif

void neuesfadenkreuz(int x,int y)
{
 printf("Testpunkt: neuesfadenkreuz(x=%d,y=%d)\n",x,y);//test
#ifdef OPENGL
 faden_x=x; faden_y=y;
#else
 fadenkreuz(faden_x,faden_y); //altes Fadenkreuz loeschen?
 fadenkreuz(x,y); //neues Fadenkreuz zeichnen
#endif
}

#ifndef OPENGL
void myXDrawLine(Display* dpy,Drawable win,GC gc,int x1,int y1,int x2,int y2)
{
 XDrawLine(dpy,win,gc,x1,y1,x2,y2);
 //inital_new();//test
 //moveto(x1,y1); lineto(x2,y2);//test
 //term_refresh();//test
}
#endif

#ifdef OPENGL
void fadenkreuz_setzen(int modus,int x,int y)
{
 static int fmodus=0;
 if(fmodus!=modus)
  {
   printf("fadenkreuz_setzen(modus=%d, x=%d, y=%d)\n",modus,x,y);//test
   printf(" integral_flg=%d\n",integral_flg);//test
   printf(" settext_flg=%d\n",settext_flg);//test
   if(modus==2)
    {
     if(fmodus!=1) modus=1;//test
    }
   else if(modus==4)
    {
     //tek_fadenkreuz(1); //ev. alter Linienzug loeschen
     tek_faden_clearpoints(); //ev. alter Linienzug loeschen
     if(settext_flg)
      {
       const int x0= -6, y0 = -16; //heisser Punkt liegt 16 Bildpunkte unter der Ecke
       tek_faden_setxy2(x0, y0,  x0+txtbr, y0);
       tek_faden_setxy2(x0+txtbr, y0+txtho,  x0, y0+txtho);
       tek_faden_setxy(x0, y0);
      }
     else
      {
       int r=search_radius;
       tek_faden_setxy2(-r, -r,  r, -r);
       tek_faden_setxy2(r, r,  -r, r);
       tek_faden_setxy(-r, -r);
      }
    }
   else if(modus==5) //Sechseck+Kreuz
    {
     int xp[7],yp[7],h=search_radius,b=(search_radius+1)/2;
     xp[0]=xp[5]=xp[6]= -h; yp[0]=yp[2]=yp[6]=b;
     xp[1]=xp[4]=0; yp[1]=h;
     xp[2]=xp[3]=h; yp[3]=yp[5]= -b;
     yp[4]= -h;
     tek_faden_setpoint1(xp[0],yp[0]);
     tek_faden_setxy2(xp[1],yp[1], xp[2],yp[2]);
     tek_faden_setxy2(xp[3],yp[3], xp[4],yp[4]);
     tek_faden_setxy2(xp[5],yp[5], xp[6],yp[6]);
    }
   tek_fadenkreuz(fmodus=modus);
  }
}

void fadenkreuz(int x,int y)
{
 if(zoom_flg || xzoom_flg || yzoom_flg || blowup_flg)
  {
   if(zoom_erster_klick) fadenkreuz_setzen(1,x,y); //Problem bei k_show_zoom geloest
   else fadenkreuz_setzen(2,x,y);
  }
 else if(on_flg) {fadenkreuz_setzen(1,x,y);} //Kreuz
 else if(integral_flg)
  {
   if(integral_flg==3) {tek_faden_setpoint1(integral_x1,integral_y1);}
   else {integral_flg++; fadenkreuz_setzen(3,x,y);}
  }
 else if(getpoint_flg) {fadenkreuz_setzen(4,x,y);} //Viereck
 else if(getdeltas_flg) {fadenkreuz_setzen(1,x,y);} //TODO: ?
 else if(stretch_flg) {fadenkreuz_setzen(1,x,y);} //TODO: ?
 else if(positio_flg) {fadenkreuz_setzen(1,x,y);} //TODO: ?
 else if(subramp_flg) {fadenkreuz_setzen(3,x,y);} //TODO: ?
 else if(puundin_flg) {fadenkreuz_setzen(5,x,y);} //Sechseck + Fadenkreuz
 else if(settext_flg) {fadenkreuz_setzen(4,x,y);} //Textkasten
}

#else

void fadenkreuz(int x,int y)
{
 if(x<0 || y<0) return;
 faden_x=x; faden_y=y;
 if(zoom_flg || xzoom_flg || yzoom_flg || blowup_flg)
	{if(!yzoom_flg) myXDrawLine(dpy,win1,gc,x,menubalkenhoehe,
					x,tekplot_hoehe+menubalkenhoehe);
	 if((!xzoom_flg) && (!blowup_flg))
			myXDrawLine(dpy,win1,gc,0,y,tekplot_breite,y);
	}
 else if(on_flg)
	{myXDrawLine(dpy,win1,gc,x,y+6,x,y-6); /* Kreuz */
	 myXDrawLine(dpy,win1,gc,x-6,y,x+6,y);
	}
 else if(integral_flg)
	{if(integral_flg==3)
		myXDrawLine(dpy,win1,gc,integral_x1,integral_y1,x,y);
	 else
		{if(integral_flg==2) integral_flg++;
		 myXDrawLine(dpy,win1,gc,x,y+4,x,y-4); /* schraeges Kreuz */
		 myXDrawLine(dpy,win1,gc,x-4,y,x+4,y);
		}
	}
 else if(getpoint_flg) /* Viereck */
	{myXDrawLine(dpy,win1,gc,x-SIX,y+SIX,x+SIX,y+SIX);
	 myXDrawLine(dpy,win1,gc,x+SIX,y+SIX,x+SIX,y-SIX);
	 myXDrawLine(dpy,win1,gc,x+SIX,y-SIX,x-SIX,y-SIX);
	 myXDrawLine(dpy,win1,gc,x-SIX,y-SIX,x-SIX,y+SIX);
	}
 else if(getdeltas_flg)
	{if(getdeltas_flg==3)
		myXDrawLine(dpy,win1,gc,integral_x1,integral_y1,x,y);
	 else
		{if(getdeltas_flg==2) getdeltas_flg++;
		 myXDrawLine(dpy,win1,gc,x,y+4,x,y-4); /* schraeges Kreuz */
		 myXDrawLine(dpy,win1,gc,x-4,y,x+4,y);
		}
	}
 else if(stretch_flg)
	{myXDrawLine(dpy,win1,gc,x,y-12,x,y+12);}
 else if(positio_flg)
	{myXDrawLine(dpy,win1,gc,x-12,y,x+12,y);}
 else if(subramp_flg)
	{if(subramp_flg==3)
		myXDrawLine(dpy,win1,gc,integral_x1,integral_y1,x,y);
	 else
		{if(subramp_flg==2) subramp_flg++;
		 myXDrawLine(dpy,win1,gc,x-8,y+6,x+8,y+6);
		 myXDrawLine(dpy,win1,gc,x+8,y+6,x+8,y-4);
		 myXDrawLine(dpy,win1,gc,x+8,y-4,x-8,y-8);
		 myXDrawLine(dpy,win1,gc,x-8,y-8,x-8,y+6);
		}
	}
 else if(puundin_flg) /* Sechseck */
	{int i,xp[7],yp[7],h=SIX-1,b=SIX/2;
	 xp[0]=xp[5]=xp[6]=x-h; yp[0]=yp[2]=yp[6]=y+b;
	 xp[1]=xp[4]=x; yp[1]=y+h;
	 xp[2]=xp[3]=x+h; yp[3]=yp[5]=y-b;
	 yp[4]=y-h;
	 for(i=0;i<6;i++)
		myXDrawLine(dpy,win1,gc,xp[i],yp[i],xp[i+1],yp[i+1]);
	}
 else if(settext_flg) /* Textkasten */
	{y -= 16; /* heisser Punkt liegt 16 Bildpunkte unter der Ecke */
	 myXDrawLine(dpy,win1,gc,x-6,y,x+txtbr,y);
	 myXDrawLine(dpy,win1,gc,x+txtbr,y,x+txtbr,y+txtho);
	 myXDrawLine(dpy,win1,gc,x+txtbr,y+txtho,x,y+txtho);
	 myXDrawLine(dpy,win1,gc,x,y+txtho,x,y-6);
	}
}
#endif

/*********** Programmteile die durch Menuauswahl erreicht werden ***********/
/*
  file_load(), file_save(), file_exit()  und  user_prog(fun,p1,p2,p3,p4)
  muessen vom Anwender im Hauptprogramm definiert werden.
*/

void show_total()
{
// extern double xmi1,ymi1,xma1,yma1;
 show(xmi1,ymi1,xma1,yma1,1);
}

void show_previous()
{
 show(last_x1,last_y1,last_x2,last_y2,1);
}

static void flags_aus()
{
 if(flag_flg)
	{fadenkreuz_aus(); on_x= -1;
	 integral_flg=on_flg=zoom_flg=xzoom_flg=yzoom_flg=getpoint_flg=
	 flag_flg=stretch_flg=positio_flg=subramp_flg=puundin_flg=
	 getdeltas_flg=blowup_flg=0;
	}
}

void flg_schalten(short *flg)
{
 if(*flg)	{fadenkreuz_aus(); *flg=flag_flg=0;}
 else	{flags_aus(); *flg=flag_flg=1; fadenkreuz_ein();}
}

void show_goback()
{
 double delta,xmi,xma,ymi,yma;
 delta=(yma2-ymi2)/2.; yma=yma2+delta; ymi=ymi2-delta;
 delta=(xma2-xmi2)/2.; xma=xma2+delta; xmi=xmi2-delta;
 if(xma1>xmi1)
	{if(xmi<xmi1) xmi=xmi1;
	 if(xma>xma1) xma=xma1;
	}
 else	{if(xmi>xmi1) xmi=xmi1;
	 if(xma<xma1) xma=xma1;
	}
 show(xmi,ymi,xma,yma,1);
}

void edit_undo()
{
 int i;
 if(change_flag)
  {zfeld[last_point_i]=last_point_y;
   if(shmodus==2) zhfeld[last_point_i]=last_point_y;
   change_flag=0;
  }
 else if(smoot_flag)
  {for(i=0;i<npkt;i++)
	zfeld[i]=sfeld[i];
   if(shmodus==2)  for(i=0;i<npkt;i++) zhfeld[i]=zfeld[i];
   smoot_flag=0;
  }
 else if(blowup_flag)
  {if(blowupfaktor==0.) printf("sorry, can't undo with blowupfaktor==0.\n");
   else aufblasen(blowup_x1,blowup_x2,1./blowupfaktor,0.,blowupshift);
   blowup_flag=0;
  }
 else
   return;
 show(xmi2,ymi2,xma2,yma2,0);
}

void edit_save_points()
{
 int i;
 if(savefeld==NULL) savefeld=feldcalloc();
 for(i=0;i<npkt;i++)
	savefeld[i]=zfeld[i];
}

void edit_last_saved()
{
 int i;
 if(savefeld==NULL) return;
 for(i=0;i<npkt;i++)
	{zfeld[i]=savefeld[i];
	 if(shmodus==2) zhfeld[i]=savefeld[i];
	}
 show(xmi2,ymi2,xma2,yma2,0);
}

void peak_intsave()
{
 lower_window();
 user_prog(&fun_intsave,&integralwert,&xspitze,&yspitze,integralgrenzen);
 raise_window();
}

void peak_getpoint()
{
 flg_schalten(&getpoint_flg);
}

void getintoff()
{
 get_sflag=0; int_sflag=0;
 flags_aus();
}

void subtra_undo()
{
 int i;
 float *za,*zb,*zs;
 if(strepos_flag)
   {zb=zeigauf(spektrumb);
    if(strepos_flag==2)
	for(i=0;i<npkt;i++)  *zb++ /= strepos_faktor;
    else
	for(i=0;i<npkt;i++)  *zb++ -= strepos_faktor;
    strepos_flag=0;
    refresh();
   }
 else if(subtr_flag)
   {za=zeigauf(spektruma); zs=sfeld;
    if(shmodus==2 && zhfeld!=NULL)
	for(zb=zeigauf(spektrumb),i=0;i<npkt;i++)  *zb++ = *za++ = *zs++;
    else
	for(i=0;i<npkt;i++)  *za++ = *zs++;
    subtr_flag=0;
    refresh();
   }
 else if(swap_flag)
   {subtra_swap(0);}
}

void subtra_error()
{
 janeinrequester("subtra_error: missing spectrum B");//provi.
}

void subtra_position()
{
 if(!subtra_flag) {subtra_error(); return;}
 if(positio_flg) {fadenkreuz_aus(); positio_flg=flag_flg=0;}
 else	{flags_aus(); positio_flg=flag_flg=1; fadenkreuz_ein();}
}

void subtra_stretch()
{
 if(!subtra_flag) {subtra_error(); return;}
 if(stretch_flg) {fadenkreuz_aus(); stretch_flg=flag_flg=0;}
 else	{flags_aus(); stretch_flg=flag_flg=1; fadenkreuz_ein();}
}

void subtra_subtract()
{
 int i;
 float *sf,*zf,*zh;
 if(!subtra_flag) {subtra_error(); return;}
 if(sfeld==NULL) sfeld=feldcalloc();
 for(i=0,sf=sfeld,zf=zeigauf(spektruma),zh=zeigauf(spektrumb);i<npkt;i++)
	{*sf++ = *zf;
	 *zf++ -= *zh++;
	}
 subtr_flag=1; swap_flag=strepos_flag=0;
 refresh();
}

void subtra_divid()
{
 int i;
 float *sf,*zf,*zh,z;
 if(!subtra_flag) {subtra_error(); return;}
 if(sfeld==NULL) sfeld=feldcalloc();
 for(i=0,sf=sfeld,zf=zeigauf(spektruma),zh=zeigauf(spektrumb);i<npkt;i++)
	{*sf++ = *zf;
	 z= *zh++; if(z==0) z=1;
	 *zf++ /= z;
	}
 subtr_flag=1; swap_flag=strepos_flag=0;
 refresh();
}

void subtra_beer()
{
 int i;
 float *sf,*zf,*zh;
 double i0,i1,od;
 const double MAXOD=4.0;
 if(!subtra_flag) {subtra_error(); return;}
 if(sfeld==NULL) sfeld=feldcalloc();
 for(i=0,sf=sfeld,zf=zeigauf(spektruma),zh=zeigauf(spektrumb);i<npkt;i++)
	{i1 = *sf++ = *zf;
	 i0 = *zh++;
	 if(i1==0.0 || (od=i0/i1)<=0.0) od=MAXOD; else od=log10(od);
	 *zf++ = (float)od;
	}
 subtr_flag=1; swap_flag=strepos_flag=0;
 refresh();
}

void subtra_swap(int flag)
{
 int i;
 static double yswap=0.;
 float *zb;
 if(!subtra_flag) {subtra_error(); return;}
 if(flag) yswap=ymi2+yma2;
 for(zb=zeigauf(spektrumb),i=0;i<npkt;i++,zb++)
			*zb = yswap - *zb;
 swap_flag=flag;
 subtr_flag=strepos_flag=0;
 refresh();
}

void subtra_exchange()
{
 double h;
 int i;
 float *za,*zb;
 if(!subtra_flag) {subtra_error(); return;}
 za=zeigauf(spektruma); zb=zeigauf(spektrumb); 
 for(i=0;i<npkt;i++)
	{h = *za;  *za++ = *zb;  *zb++ = h;}
 swap_flag=subtr_flag=strepos_flag=0;
}

void settextpos()
{
 int br,i,c;
 char *s;
 if(labeltext_flag==0)  spename_laden();
 br=0;
 for(i=0;i<anzahl_spenamen;i++)
	if((c=strlen(spename[i]))>br) br=c;
/* txtbr=br*10; txtho=anzahl_spenamen*21; vor Version 2.4.03 */
 txtbr=br*10*tbuch/TBUCHDEFAULT;
 txtho=anzahl_spenamen*21*titelabst/TITABSTDEFAULT;
 flg_schalten(&settext_flg);
 printf("textposflag wird gesetzt\n");//test
 textposflag=1;
}

#ifndef MIT_SUBMENUS
void k_show_frame()
{
 int ok,flag=ramen_flag;
    /* ramen_flag: 0=aus  1=normal  2=Achse immer durch 0  3=3D-Darstellung */
 ok=requester_input(1,"Umrahmung-Modus (0=aus, 1=normal, 2=Achse bei 0, 3=3D)","%d","%d",&flag);
 if(ok)
  {
   ramen_flag=flag;
   refresh();
  }
 /* Ersatz von:
void k_show_frame_off(long id) 	{setramen_umschalten(0,id);}
void k_show_frame_yaxisu(long id) {setramen_umschalten(1,id);}
void k_show_frame_yaxis0(long id) {setramen_umschalten(2,id);}
void k_show_frame_3d(long id) {setramen_umschalten(3,id);}
 */
}

void k_show_text()
{
 int ok;
 char antw[80]="on";
 if(textflag==0) strcpy(antw,"off");
 ok=requester_input(1,"Beschriftungs-Text on/off","%s","%s",antw);
 if(ok)
  {
   if(antw[1]=='n' || antw[1]=='N') //Antwort "on" oder "ON" (oder "an" oder "AN")
    {textflag=1; settextpos();}
   else textflag=0;
   refresh();
  }
 /* Ersatz von:
void k_show_text_pos()	{settextpos();}
void k_show_text_on(long id)	{textflag_umschalten(1,id);}
void k_show_text_off(long id)	{textflag_umschalten(0,id);}
 */
}

void k_show_atext()
{
 int ok;
 char antw[80]="on";
 if(xytextflag==0) strcpy(antw,"off");
 ok=requester_input(3,"Axis-Text on/off","%s","%s\n",antw,
		    "x-AxisText","%s","%s\n",xlabeltext,
		    "y-AxisText","%s","%s\n",ylabeltext);
 if(ok)
  {
   if(antw[1]=='n' || antw[1]=='N') //Antwort "on" oder "ON" (oder "an" oder "AN")
        {xytextflag=1;}
   else {xytextflag=0;}
   refresh();
  }
 /* Ersatz von:
void k_show_atext_xyon(long id)  {xytextflag_umschalten(1,id);}
void k_show_atext_xyoff(long id) {xytextflag_umschalten(0,id);}
void k_show_atext_x() {...}
void k_show_atext_y() {...}
 */
}

void k_peak_pointsearch()
{
 int ok;
 ok=requester_input(2,"Points Search (0=off, 1=Maxima, 2=Minima)","%d","%d\n",&search_methode,
		    " SuchRadius ","%d","%d",&search_radius);
 if(ok) {refresh();}
}

void k_peak_deltasearch()
{
 int ok;
 ok=requester_input(2,"Delta Search (0=off, 1=Maxima, 2=Minima)","%d","%d\n",&dsearch_methode,
		    " SuchRadius ","%d","%d",&search_radius);
 if(ok) {refresh();}
}
#endif

/************************ show, integral, smooth  usw. ********************/

void show(double x1,double y1,double x2,double y2,int flag)
{			/* flag: wenn gesetzt: letzte Werte speichern */
// extern double xmi1,ymi1,xma1,yma1,deltax, xmi2,ymi2,xma2,yma2,dx2,dy2;
 float *zf,*zhf;
 int i,imin,imax,rflag;
 int flag3d=(ramen_flag==3);
 static int ersteraufruf=1;
 short *pf;
 double x,y,y0,y11;
 if((rflag=fadenkreuzflag)==1) fadenkreuz_aus();
 if(flag) {last_x1=xmi2; last_y1=ymi2; last_x2=xma2; last_y2=yma2;}
 xmi2=x1; ymi2=y1; xma2=x2; yma2=y2;
#ifdef OPENGL
 //dpy=1;//test
 if(ersteraufruf) inital(x1,y1,x2,y2);
 else {screenclear(); inital_new(x1,y1,x2,y2);}
#else
 if(dpy) screenclear();
 qinital(1,x1,y1,x2,y2);
#endif
 if(ersteraufruf) {setcolors(1); ersteraufruf=0;}//test
 //if(tekplot_tiefe>1) color(1);// fuer farbige Darstellung am Bildschirm
 color(1); // fuer farbige Darstellung am Bildschirm? TODO
 dx2=(x2-x1)/tekplot_breite; dy2=(y2-y1)/tekplot_hoehe;
 imin=int((x1-xmi1)/deltax+0.999); imax=int((x2-xmi1)/deltax+0.001);
 if(flag3d)	//3D-Darstellung ?
	{plot3d_init(x1,y1,x2,y2,imax-imin+1);
	 plot3d(xmi1+deltax*imin,zfeld[imin],UP);
	}
 else	q2plot(xmi1+deltax*imin,zfeld[imin],UP);
 for(pf= &penfeld[imin+1],zf= &zfeld[imin+1],i=imin+1;i<=imax;i++)
	{x=xmi1+deltax*i;
	 if(flag3d) plot3d(x,*zf++,*pf++);
	 else q2plot(x,*zf++,*pf++);
	}
 if(shmodus==2)
   {for(zf= &zfeld[imin],zhf= &zhfeld[imin],i=imin;i<=imax;i++,zf++,zhf++)
     if(*zf != *zhf)
	{x=xmi1+deltax*i; q2plot(x,*zf,3); q2plot(x,*zhf,2);}
   }
 else if(shmodus>=4 && zhfeld!=NULL)
   {int offset,j,n;
    if(shmodus==4) n=2; else n=nspektren;
    if(flag3d)  /* 3D-Darstellung ? */
     {double dx,dy,x3d,y3d,tfeld[MAXCOLOR];
      int farbig=tfeld_laden(x1,y1,x2,y2,tfeld,&dx,&dy);
      for(offset=0,j=2; j<=n; j++,offset+=npkt)
	{if(farbig) bildgestrichelt(j);
	 x3d=dx*tfeld[j-1]; y3d=dy*tfeld[j-1];
	 plot3d(xmi1+deltax*imin+x3d,zhfeld[imin+offset]+y3d,UP);
	 for(zhf= &zhfeld[imin+1+offset],i=imin+1;i<=imax;i++)
	  {x=xmi1+deltax*i + x3d; y= *zhf++ + y3d;
	   plot3d(x,y,DOWN);
	  }
	}
     }
    else /* ohne 3D-Darstellung */
     for(offset=0,j=2; j<=n; j++,offset+=npkt)
	{bildgestrichelt(j);
	 q2plot(xmi1+deltax*imin,zhfeld[imin+offset],UP);
	 for(zhf= &zhfeld[imin+1+offset],i=imin+1;i<=imax;i++)
		{x=xmi1+deltax*i;
		 q2plot(x,*zhf++,DOWN);
		}
	}
    bildnichtgestrichelt();
   }
 if(ramen_flag)
  {if(ramen_flag==2) y0=rundezahl(y1,y2);
   else  y0=rundezahl(y1+(y2-y1)/60.,y1+(y2-y1)/20.);
   yachsenposition=y0;
   y11=y0-(y2-y1)/40.;
   if(y2>y1) {if(y11<y1) y11=y1;}
   else      {if(y11>y1) y11=y1;}
   pramen(x1,y11,x2,y2,y0);
  }
 qterm();
 if(rflag==1) fadenkreuz_ein();
}

void refresh()
{
 show(xmi2,ymi2,xma2,yma2,0);
}

int integral(double x1,double y1,double x2,double y2)
{
 double sum,dy=0,x;
 int i,imin,imax;
 imin=int((x1-xmi1)/deltax+0.5); imax=int((x2-xmi1)/deltax+0.5);
 if(imax==imin) return 0;
 x1=deltax*imin+xmi1; x2=deltax*imax+xmi1;
 integralgrenzen[0]=x1; integralgrenzen[1]=y1;
 integralgrenzen[2]=x2; integralgrenzen[3]=y2;
 if(shmodus==2)
	{dy=(y2-y1)/(imax-imin);
#ifdef OPENGL
	 inital_new(xmi2,ymi2,xma2,yma2);
#else
	 qinital(1,xmi2,ymi2,xma2,yma2);
#endif
	}
 if(imin>imax)
	{i=imax; imax=imin; imin=i;  x=y2; y2=y1; y1=x;}
 yspitze=zfeld[imin]; xspitze=0.;
 sum=(zfeld[imin]+zfeld[imax])/2.;
 for(i=imin+1;i<imax;i++)
	{sum+=zfeld[i];
	 if(zfeld[i]>yspitze) {yspitze=zfeld[i]; xspitze=xmi1+deltax*i;}
	 if(shmodus==2)
		{if(zhfeld[i]==zfeld[i]) zhfeld[i]=(i-imin)*dy+y1;
		 else zhfeld[i]=zfeld[i];/* schon mal markierter Punkt */
		 x=xmi1+deltax*i;
		 q2plot(x,zhfeld[i],3); q2plot(x,zfeld[i],2);
		}
	}
 if(shmodus==2) qterm();
 integralwert = sum = sum*fabs(deltax) - (y1+y2)/2.*fabs(x2-x1);
 sprintf((char*)fenstername," I=%lg  ",sum);
 fenstername1_len=strlen((char*)fenstername);
#ifdef OPENGL
 //TODO
#else
 //Fenstertitel neu anschreiben:
 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (uchar*)fenstername, fenstername1_len);
#endif
 return 1;
}

#ifdef OPENGL
void XSetForeground(int dpy,int gc,int farbe)
{
 //TODO
}
#endif

int differenz(double x1,double y1,double x2,double y2)
{
 double delta,x;
 int imin,imax;
 if(x1==x2 && y1==y2) return 0;
 imin=int((x1-xmi1)/deltax+0.5); imax=int((x2-xmi1)/deltax+0.5);
 x1=deltax*imin+xmi1; x2=deltax*imax+xmi1;
 integralgrenzen[0]=x1; integralgrenzen[1]=y1;
 integralgrenzen[2]=x2; integralgrenzen[3]=y2;
 if(shmodus==2)
	{
#ifdef OPENGL
	 //screenclear();
	 inital_new(xmi2,ymi2,xma2,yma2);
#else
	 qinital(1,xmi2,ymi2,xma2,yma2);
#endif
	}
 if(shmodus==2)
  {
   if(zhfeld[imin]!=zfeld[imin]) /* Wenn schon markiert, */
	{
	 XSetForeground(dpy,gc,hintergrundfarbe);/* Loeschfarbe */
	 zhfeld[imin]=y2; x=xmi1+deltax*imin;
	 q2plot(x,zhfeld[imin],3); q2plot(x,zfeld[imin],2);
	 q2plot(x,zfeld[imin],3);
	 XSetForeground(dpy,gc,vordergrundfarbe);/* wieder Vordergrundfarbe */
	 zhfeld[imin]=zfeld[imin]; /* dann Markierung aufheben. */
	}
   else	{zhfeld[imin]=y2; x=xmi1+deltax*imin;
	 q2plot(x,zhfeld[imin],3); q2plot(x,zfeld[imin],2);
	}
  }
 if(shmodus==2) qterm();
 integralwert = delta = y1-y2;
 sprintf((char*)fenstername," D=%lg  ",delta);
 fenstername1_len=strlen((char*)fenstername);
#ifdef OPENGL
 //TODO
#else
 //Fenstertitel neu anschreiben:
 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (uchar*)fenstername, fenstername1_len);
#endif
 return 1;
}

void minmaxsearch(double &x1,double &y1,double &x2,double &y2)
{
 double xmin=0.,xmax=0.,ymin,ymax,z;
 int i,imin,imax,maximax=int((xma1-xmi1)/deltax+0.5);
 imin=int((x1-xmi1)/deltax+0.5); imax=int((x2-xmi1)/deltax+0.5);
 if(imin>imax)
	{i=imax; imax=imin; imin=i;  z=x2; x2=x1; x1=z;}
 if(y1>y2) {z=y2; y2=y1; y1=z;}
 if(imin<0) imin=0;
 else if(imin>maximax) imin=maximax;
 if(imax>maximax) imax=maximax;
 ymax=y1; ymin=y2;
 //printf("Test: minmaxsearch() i=%d...%d\n",imin,imax);//test
 for(i=imin;i<=imax;i++)
      if((z=zfeld[i])>=y1 && z<=y2)
	{//printf("zfeld[%d]=%lf x=%lf\n",i,zfeld[i],xmi1+deltax*i);//test
	 //printf("deltax=%lf xmi1=%lf xma1=%lf\n",deltax,xmi1,xma1);//test
	 if(z>ymax) {ymax=z; xmax=xmi1+deltax*i;}
	 if(z<ymin) {ymin=z; xmin=xmi1+deltax*i;}
	}
 x1=xmin; y1=ymin; x2=xmax; y2=ymax; //Rueckgabewerte
}

//Die folgenden Tabellen stammen aus
// Analytical Chemistry, 36,8 (1964) 1627-38

static int quadcub_feld[]={ //fuer quadratisches und kubisches Polynom
  -3, 12, 17, //5
  -2,  3,  6,  7, //7
 -21, 14, 39, 54, 59, //9
 -36,  9, 44, 69, 84, 89, //11
 -11,  0,  9, 16, 21, 24, 25,
 -78,-13, 42, 87,122,147,162,167,
 -21, -6,  7, 18, 27, 34, 39, 42, 43,
-136,-51, 24, 89,144,189,224,249,264,269,
-171,-76,  9, 84,149,204,249,284,309,324,329,
 -42,-21, -2, 15, 30, 43, 54, 63, 70, 75, 78, 79,
-253,-138,-33,62,147,222,287,322,387,422,447,462,467 //25
};
static int quadquint_feld[]={ //fuer Polynome 4. und 5. Ordnung
  5,  -30,   75,  131, //7
   15,  -55,   30,  135, 179,
   18,  -45,  -10,   60, 120, 143,
  110, -198, -160,  110,  390, 600,  677,
 2145,-2860, -2937, -165, 3755,7500,10125,11063, //15
  195, -195,  -260, -117,  135, 415,  660,  825,  883,
  340, -255,  -420, -290,   18,  405,  790, 1110, 1320, 1393,
11628,-6460,-13005,-11220,-3940,6378,17655,28190,36660,42120,44003,
  285, -114,  -285,  -285, -165,  30,  261,  495,  705,  870,  975,1011, //23
 1265, -345, -1122, -1255, -915,-255,  590, 1503, 2385, 3155, 3750,4125,4253
};

class Quadcub
{
 int nmin,nmax,drei; //Bereich der Koeffizienten in Tabelle
 int *feld;
 void intcheck()
  {if(sizeof(int)<4) printf("Fehler: int ist weniger als 4 Bytes lang\n");
   //Compiler-Voreinstellungen auf int=4Bytes umstellen !
  }
public:
 Quadcub(int min,int *f)
	{nmin=min; nmax=25; feld=f; drei=(nmin+1)/2; intcheck();}
 int get(int,int);
};

int Quadcub::get(int zeile,int spalte)
{
 int j,k,i,mitte=(zeile+1)/2;
 if(zeile<nmin || zeile>nmax || (zeile&1)!=1)
  {printf("Fehler in Quadcub::get(%d,%d)\n\
    nur ungerade Werte von %d bis %d erlaubt\n",zeile,spalte,nmin,nmax);
   return 1;
  }
 i=(spalte>mitte)?zeile-spalte:spalte-1;
 j=(zeile-nmin)/2;
 if(j>0) {k=j-1; j=drei*j+(k*(k+1))/2;}
 return feld[j+i];
}

static Quadcub quadcub(5,quadcub_feld), qquint(7,quadquint_feld);
long quadcubic(int zeile,int spalte) {return quadcub.get(zeile,spalte);}
long quadquint(int zeile,int spalte) {return qquint.get(zeile,spalte);}

void smooth(int k,int wicht) // Glaettung ueber n Punkte
			     // wicht=1: Mit Gewichtung nach gewichtmethod
{
 int i,j,m,khalbe,k1halbe,k1,methode;
 double sum;
 long n,wfakt;
 if(sfeld==NULL) sfeld=feldcalloc();
 for(i=0;i<npkt;i++) sfeld[i]=zfeld[i];
 khalbe=k/2; k1halbe=(k-1)/2; k1=k&1;
 methode=(wicht==0)?0:gewichtmethod;
 for(i=0;i<npkt;i++)
   {for(sum=0,n=0,m=1,j=i-k1halbe;j<=i+khalbe;j++,m++)
     if(j>=0 && j<npkt)
       {switch(methode)
	 {case WICHT_SIMPLE: wfakt=(j==i)?2:1; //Mittlerer Punkt gewichtet
	  CASE WICHT_TRIANG: wfakt=(j>i)?(khalbe+1+i-j):(khalbe+k1+j-i);
	  CASE WICHT_CUBIC:  wfakt=quadcubic(k,m); //Polynomanpassung 3.Ord.
	  CASE WICHT_QUINTIC: wfakt=quadquint(k,m);//Polynomanpassung 5.Ord.
	  DEFAULT: wfakt=1; //ohne Gewichtung
	 }
        //if(i==npkt/2) printf("%ld ",wfakt);//test
	sum+=wfakt*double(sfeld[j]); n+=wfakt;
       }
    //if(i==npkt/2 || n==0) printf("\nsum=%lg n=%ld\n",sum,n);//test
    zfeld[i]=sum/n;
   }
 if(shmodus==2)  for(i=0;i<npkt;i++) zhfeld[i]=zfeld[i];
 smoot_flag=1;
 show(xmi2,ymi2,xma2,yma2,0);
}

const char *wicht_str(int method)
{
 switch(method)
   {case WICHT_SIMPLE: return "simple";
    case WICHT_TRIANG: return "triang";
    case WICHT_CUBIC:  return "cubic";
    case WICHT_QUINTIC: return "quintic";
   }
 return "unknown";
}

static int altsmoot_n=25,altsmoot_m=WICHT_CUBIC;

void setsmooth(int n)	/* Anzahl Punkte fuer Glaettung einstellen */
{
 if(n==4)
   {smoothNr=altsmoot_n; gewichtung=(altsmoot_m==0)?0:1;
    gewichtmethod=altsmoot_m;
    setsmoothpara();
   }
 else
   {gewichtung=n&1;
    switch(n)
	{case 0: case 1:smoothNr=3; break;
	 case 2: case 3:smoothNr=5; break;
   }	}
}
int setsmoothpara()
{
 int ok,nmin,nmax;
 char gwicht[40];
 if(gewichtung==0)
   strcpy(gwicht,"no");
 else strcpy(gwicht,wicht_str(gewichtmethod));
 ok=requester_input(2,"Anzahl Punkte","%d","%d\n",&smoothNr,
		    "Gewichtung (no simp triang cubic quintic)",
		    "%s","%s",&gwicht);
 if(ok)
   {gewichtung=1; nmin=3; nmax=1000;
    switch(tolower(gwicht[0]))
     {case 's': gewichtmethod=WICHT_SIMPLE;
      CASE 't': gewichtmethod=WICHT_TRIANG;
      CASE 'c': gewichtmethod=WICHT_CUBIC; nmin=5; nmax=25; smoothNr|=1;
      CASE 'q': gewichtmethod=WICHT_QUINTIC; nmin=7; nmax=25; smoothNr|=1;
      CASE 'n': gewichtung=0;
     }
    if(gewichtung && (smoothNr<nmin || smoothNr>nmax))
      {int n=(smoothNr<nmin)?nmin:nmax;
       char str[80];
       sprintf(str,
	       "Anzahl Punkte auf %d gesetzt\n(nur Bereich %d bis %d erlaubt)",
	       n, nmin, nmax);
       ok=janeinrequester(str," ok ","cancel");
       if(ok) smoothNr=n;
      }
   }
 if(ok)
   {sprintf(text_smoot_n,"%%O %d %s weighted",altsmoot_n=smoothNr,
	   (gewichtung!=0)?wicht_str(gewichtmethod):"not");
    altsmoot_m=(gewichtung==0)?0:gewichtmethod;
    if(smooth_ids[4])
      {int n;
       if(smoothNr==3 || smoothNr==5)
	 {n=smoothNr-3; if(gewichtung) n++;}
       else n=4;
       smooth_umschalten(n,smooth_ids[n]);
      }
   }
 return ok;
}
void smooth_help()
{
 /*
 janeinrequester("Smooth-Gewichtungs-Methoden:\n\
 no      Es wird jeweils der Durchschnitt aus N Punkten genommen\n\
 simple  Der mittlere Punkt wird doppelt gewichtet\n\
 triang  Die Punkte werden Dreieckfoermig gewichtet\n\
 cubic   Es wird eine Anpassung an ein Polynom 3. Grades gemacht\n\
 quintic Es wird eine Anpassung an ein Polynom 5. Grades gemacht");
 */
 printf("Smooth-Gewichtungs-Methoden:\n\
 no      Es wird jeweils der Durchschnitt aus N Punkten genommen\n\
 simple  Der mittlere Punkt wird doppelt gewichtet\n\
 triang  Die Punkte werden Dreieckfoermig gewichtet\n\
 cubic   Es wird eine Anpassung an ein Polynom 3. Grades gemacht\n\
 quintic Es wird eine Anpassung an ein Polynom 5. Grades gemacht\n");
 janeinrequester("Smooth-Hilfe: siehe Textfenster");
}

void subramp(double x1,double y1,double x2,double y2)
{
 double steigung,x;
 int i,flag;
 float *za,*zb,*zs;
 if((x=x2-x1)==0.) return;
 steigung=(y2-y1)/x;
 if(sfeld==NULL) sfeld=feldcalloc();
 zs=sfeld; za=zeigauf(spektruma);
 if(shmodus==2 && zhfeld!=NULL)
   for(zb=zhfeld,i=0;i<npkt;i++)
	{*zs++ = *za;  x=i*deltax+xmi1;
	 *zb++ = *za++ -= y1+steigung*(x-x1);
	}
 else
   for(i=0;i<npkt;i++)
	{*zs++ = *za;  x=i*deltax+xmi1;
	 *za++ -= y1+steigung*(x-x1);
	}
 subtr_flag=1; swap_flag=strepos_flag=0;
 refresh();
}

/*
warte() //test
{
 sys$clref(ef2);
 CHECK(sys$setimr(ef2,zeit05,NULL,0,0));
 sys$waitfr(ef2);
}
*/

/**** Behandlung des PLOT-Menupunktes *******/
void qplot_refresh_save(const char *s)
{
 plotsave(s);
 refresh();
 plotsave("OFF");
}

void plotter(int format)
{
 lepsflag=pscolorflag=0;
 const char *bn;
 if(format==ROHXYDATEI)
  {if((bn=getenv("PLOTSAVEXY"))==NULL) bn=xyname_default;}
 else
  {if((bn=getenv("PLOTSAVE"))==NULL) bn=bildname_default;}
 strcpy(bildname,bn);
 switch(format)
  {
   /*
   case DECLASER: //jetzt neue Printer definiert: Standarddrucker ist Lexmark
	 lepsflag=1;
	 qplot_refresh_save("POST");
	 printf_system("lpr %s",bildname);
   CASE IBMLASER: //auch auf Standarddrucker, aber mit EPS-Unterstuetzung
	 //lepsflag=1; //ueberfluessig (17.6.99)
	 qplot_refresh_save("POST");
	 printf_system("eps -s %s",bildname);
   CASE PSPLOTTER: //auf Farbdrucker
	 lepsflag=1; pscolorflag=1;
	 qplot_refresh_save("POST");
	 printf_system("lpr -l -Ptektronix %s",bildname);
	 break;
   */
   case PSDATEIFARBIG: case PSDATEI:
	 pscolorflag=1;
	 qplot_refresh_save("POST");
	 printf("farbiges PS Bild als '%s' gespeichert\n",bildname);
   CASE ROHXYDATEI:
	 rohxy_speichern(); return;
   DEFAULT: printf("Fehlerin plotter(): unbekanntes Format %d\n",format);
  }
}

/*
void printf_system(const char* str,const char* p1)
{
 static char strsys[160];
 sprintf(strsys,str,p1);
 if(str[0]!=' ') printf("%s\n",strsys);
 system(strsys);
}
*/

void rohxy_speichern()
{
// extern double xmi1,ymi1,xma1,yma1,deltax, xmi2,ymi2,xma2,yma2,dx2,dy2;
 //int rflag;
 int i,imin,imax;
 double x,y0,y11;
 double x1,y1,x2,y2;
 FILE *fp;
/* char *cstr="  %15.8lg  %15.8lg\n"; */
 const char *cstr=" %.9lg\t%.9lg\n";
 fp=fopen(bildname,"w");
 if(fp==NULL) {printf("kann '%s' nicht oeffnen\n",bildname); return;}
 x1=xmi2; y1=ymi2; x2=xma2; y2=yma2;
 dx2=(x2-x1)/tekplot_breite; dy2=(y2-y1)/tekplot_hoehe;
 imin=int((x1-xmi1)/deltax+0.999); imax=int((x2-xmi1)/deltax+0.001);
 for(i=imin;i<=imax;i++)
	{x=xmi1+deltax*i;
	 fprintf(fp,cstr,x,zfeld[i]);
	}
 if(shmodus>=4 && zhfeld!=NULL)
   {int offset,j,n;
    if(shmodus==4) n=2; else n=nspektren;
    for(offset=0,j=2; j<=n; j++,offset+=npkt)
	{for(i=imin;i<=imax;i++)
		{x=xmi1+deltax*i;
		 fprintf(fp,cstr,x,zhfeld[i+offset]);
		}
	}
   }
 fclose(fp);
 printf("XY-Werte in '%s' gespeichert\n",bildname);
 refresh();
}

/*********************** Pascal Strings ***************************/
struct pascalstring {UWORD n; char s[80];};
#ifdef __cplusplus
extern "C" {
#endif
void pas2cstring(char **ziel,struct pascalstring *pstr)
{
 char *s;
 if(!(s=(char *)calloc(pstr->n+1,1))) return;
 strncpy(s,pstr->s,pstr->n); s[pstr->n]=0;
 *ziel=s;
}

void pascopy(int *n,char *von,char *nach)
{
 int m= *n;
 while(m--) *nach++ = *von++;
}
#ifdef __cplusplus
}
#endif
/************************* kleinkram ******************************/
int getline(FILE* fp,char* s,int lim)
			/* liest eine Textzeile oder maximal lim Zeichen */
{			/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);       /* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

#ifdef OPENGL
double rundezahl(double x,double y)
{
 static double rund[]={5.,8.,6.,4.,2.,9.,7.,3.,1.,-1.};
 double z1,z2,z3;
 int i;
 if(x<0.) return -rundezahl(-x,-y);
 if(y<0.) return 0.;
 if(x<y) {z1=x; x=y; y=z1;}
 if(x>=1.) /* 1 10 100 1000 ... */
  {for(z1=1.;z1<=x; z1*=10.)  if(z1>=y) return z1;
   z1/=10.;
  }
 else      /* 0.1 0.01 0.001 .... */
  {for(z1=0.1;z1>=y; z1*=0.1)  if(z1<=x) return z1;
  }
 for(i=0;(z2=rund[i])>1.;i++) /* Test auf Gleichheit der ersten Ziffer */
	if((z2*=z1)<=x && z2>=y) return z2;
 for(z2=z1+z1;z2<x;z2+=z1)
	;
 z2-=z1; /* z2 = erste Ziffer */
 while(z1>0.)
  {z1/=10.;
   for(i=0;(z3=rund[i])>0.;i++)
	if((z3=z3*z1+z2)<=x && z3>=y) return z3;
   for(z3=z1;z2+z3<x;z3+=z1) ;
   z2+=z3-z1;//Erweiterung wie in showit.c
  }
 return y; /* Fehler: x==y */
}
#endif

/********************** neu ab Version 2.0 *************************/
void spektnr_setzen(const char *name,int *nummer)
{
 lower_window();
 printf("(%d) Nummer von Spektrum %s:",*nummer,name); scanf("%d",nummer);
 raise_window();
}

void yskalierung(float *pfaktor)
{
 double faktor;
 if(pfaktor==NULL || *pfaktor==0.)
	{
	 lower_window();
	 printf("(%lf) y-Skalierung. Faktor:",yskalfakt);
	 scanf("%lf",&faktor);
	 while(faktor==0.)
	   {printf("Null nicht erlaubt! Faktor:"); scanf("%lf",&faktor);}
	 raise_window();
	 spektren_skalieren(faktor);
	 refresh();
	}
 else if(showit_gestartet)
	{spektren_skalieren(*pfaktor);}
 else	yskalfakt= *pfaktor;
}

void spektren_skalieren(double faktor)
{
 int i,imax;
 double f=faktor/yskalfakt;
 if(nspektren<2 && zhfeld!=NULL) imax=2;
 else imax=nspektren;
 for(i=0;i<imax;i++) spektrum_skalieren(i,f);
 ymi2 /= f; ymi1 /= f; yma2 /= f; yma1 /= f;
 yskalfakt=faktor;
}

void spektrum_skalieren(int nr,double fakt)
{
 float *z;
 int i;
 if(nr==0)
	z=zfeld;
 else
	{if(zhfeld==NULL) return;
	 z= &zhfeld[(nr-1)*npkt];
	}
 for(i=0;i<npkt;i++)  *z++ /= fakt;
}

float *zeigauf(int spektrumnummer)
{
 if(spektrumnummer==0 || zhfeld==NULL) return zfeld;
 return &zhfeld[(spektrumnummer-1)*npkt];
}

/********************* Aufblasen ***************************/
static void blowup(double x1,double x2)
{
 blowup_flg=0; blowup_flag=1;
 aufblasen(blowup_x1=x1,blowup_x2=x2,blowupfaktor,blowupshift,0.);
 refresh();
}

static void aufblasen(double x1,double x2,double faktor,
			double shift,double subshift)
{
 float *zf,*zhf;
 double x;
 int i,imin,imax;
 imin=int((x1-xmi1)/deltax+0.5); imax=int((x2-xmi1)/deltax+0.5);
 if(imax==imin) return;
 if(imin>imax) {i=imax; imax=imin; imin=i;}
 if(shift!=0. || subshift!=0.)
  {if(shmodus==2)
      for(zf= &zfeld[imin],zhf= &zhfeld[imin],i=imin;i<imax;i++,zf++,zhf++)
	{*zf = (*zf-subshift)*faktor+shift;
	 *zhf = (*zhf-subshift)*faktor+shift;
	}
   else
     {for(zf= &zfeld[imin],i=imin;i<imax;i++,zf++)
		*zf = (*zf-subshift)*faktor+shift;
      if(blowup_all)
	{int j;
	 for(j=0;j<nspektren-1;j++)
	  for(zf= &zhfeld[j*npkt+imin],i=imin;i<imax;i++,zf++)
		*zf = (*zf-subshift)*faktor+shift;
     }  }
  }
 else
  {if(shmodus==2)
      for(zf= &zfeld[imin],zhf= &zhfeld[imin],i=imin;i<imax;i++)
	{*zf++ *= faktor;
	 *zhf++ *= faktor;
	}
   else
     {for(zf= &zfeld[imin],i=imin;i<imax;i++)
		*zf++ *= faktor;
      if(blowup_all)
	{int j;
	 for(j=0;j<nspektren-1;j++)
	  for(zf= &zhfeld[j*npkt+imin],i=imin;i<imax;i++,zf++)
		*zf++ *= faktor;
     }  }
  }
 if(subshift!=0.) penfeld[imax] = penfeld[imin] = DOWN;
 else if(shift!=0.) penfeld[imax] = penfeld[imin] = UP;
}

/********************* Fouriertransformation ***************************/
#ifndef PI
#define PI 3.141592653589793238
#endif
void bitschuettler(double *rfeld,double *ifeld,int n);
void fft(double *rfeld,double *ifeld,int *pn,int *pinv);
double sq(double x) {return x*x;}
void pft(int nn,double *y,double *a,double *b);
void pft_invers(int nn,double *y,double *a,double *b);
void dft(int nn,int inv,double *a,double *b,double *ya,double *yb);
void feldf2d(int n,float *f,double *d,float *f2=NULL,double *d2=NULL)
{
 if(d2) {if(f2) while(n--) {*d++ = *f++; *d2++ = *f2++;}
	 else	while(n--) {*d++ = *f++; *d2++ = 0.;}
	}
 else while(n--) *d++ = *f++;
}
void feldd2f(int n,double *d,float *f,double *d2=NULL,float *f2=NULL)
{
 if(d2) while(n--) {*f++ = *d++; *f2++ = *d2++;}
 else while(n--) *f++ = *d++;
}
/*void flipfeld(int n,double *f)
{
 double h,*p;
 for(p= &f[n];--p > f;f++) {h= *f; *f= *p; *p=h;}
}*/

int fftmethode=2;

void fft_start(int inversflag)
{
 int n,inv=inversflag,np,i,imin,imax,j;
 static double *rfeld=NULL,*ifeld=NULL;
 imin=int((xmi2-xmi1)/deltax+0.5); imax=int((xma2-xmi1)/deltax+0.5);
 if(imin>imax) {i=imin; imin=imax; imax=i;}
 np=imax-imin;
 if(np==0) return;
 if(shmodus<2 && fftmethode!=2) modus_4();
 if(fftmethode>=5) n=np+2; /*PFT oder DFT*/
 else for(n=4;n<np;n+=n)  ;/*FFT*/
 if(inversflag) printf("Ruecktransformation  %d Punkte\n",n);
 else
  {printf("FFT mit %d Punkten von %lf bis %lf  Schrittweite %lf\n",
	n,xmi1+deltax*imin,xmi1+deltax*imax,deltax);
   printf("Umrechnung in Distanzen: Distanz=%lf/(x-%lf)\n",
		n*deltax*deltax, xmi1+deltax*imin);
  }
 if(rfeld==NULL)
  {rfeld=(double*)calloc(n,sizeof(double));
   ifeld=(double*)calloc(n,sizeof(double));
   if(rfeld==NULL || ifeld==NULL)
	{printf("zu wenig Speicher fuer FFT\n");
	 if(rfeld) {cfree(rfeld); rfeld=NULL;}
	 return;
  }	}
 if(fftmethode==6) /*test:DFT (Diskrete FourierTransformation)*/
  {double *afeld=(double*)calloc(n,sizeof(double));
   double *bfeld=(double*)calloc(n,sizeof(double));
   if(n&1) n--;
   feldf2d(n,&zfeld[imin],rfeld,inv?&zhfeld[imin]:(float*)NULL,ifeld);
   dft(n,inv,rfeld,ifeld,afeld,bfeld);
   feldd2f(n,afeld,&zfeld[imin],bfeld,&zhfeld[imin]);
   cfree(afeld); cfree(bfeld);
  }
 else if(fftmethode==5) /*test:PFT (Periodische FourierTransformation)*/
  {double *afeld=(double*)calloc(n,sizeof(double));
   if(n&1) n--;
   feldf2d(n,&zfeld[imin],afeld);
   if(inversflag)
	{feldf2d(n,&zhfeld[imin],ifeld);
	 pft_invers(n,rfeld,afeld,ifeld);
	}
   else	{pft(n,afeld,rfeld,ifeld);
	 feldd2f(n,ifeld,&zhfeld[imin]);
	}
   feldd2f(n,rfeld,&zfeld[imin]);
   cfree(afeld);
  }
 else
 {if(inv)
   {if(fftmethode==2)
	{for(j=0,i=imin;i<imax;i++,j++)
		 if(zfeld[i]==0.) ifeld[j]=rfeld[j]=0.;
	}
    else
	{feldf2d(j=imax-imin,&zfeld[imin],rfeld,&zhfeld[imin],ifeld);
	 for(;j<n;j++) rfeld[j]=ifeld[j]=0.;
	}
    if(fftmethode==2 || fftmethode==4)
	{for(j=n-1,i=1;i<j;i++,j--) /* spiegelkorrektur */
		{rfeld[j]= rfeld[i]; ifeld[j]= -ifeld[i];}
	}
   }
  else
   {feldf2d(j=imax-imin,&zfeld[imin],rfeld,
	    (fftmethode==1) ? &zhfeld[imin] : (float*)NULL, ifeld);
    for(;j<n;j++) rfeld[j]=ifeld[j]=0.;
   }
  fft(rfeld,ifeld,&n,&inv);
  if(fftmethode==2)
	{if(inv) feldd2f(imax-imin,rfeld,&zfeld[imin]);
	 else for(j=0,i=imin;i<imax;i++,j++)
		zfeld[i]=sqrt(sq(rfeld[j])+sq(ifeld[j]));
	}
  else	feldd2f(imax-imin,rfeld,&zfeld[imin],ifeld,&zhfeld[imin]);
 }
 if(fftmethode!=2 || inv) {cfree(rfeld); cfree(ifeld); rfeld=NULL;}
 ymimaxsuchen(zfeld,(fftmethode==2)?(float*)NULL:zhfeld);
 if(shmodus==2) {if(fftmethode==2) modus_1(); else modus_4();}
 else refresh();
}

void fft(double *rfeld,double *ifeld,int *pn,int *pinv)
{
 int n= *pn, inv= *pinv, k,zweik,m;
 register int i,j;
 double a,treal,timag,wreal,wimag;
// if(n>=4) j=n; else j=3;
// while (j%2==0) j/= 2;	// n auf die Form 2^k testen
// if(j!=1)  { printf("Error: ungueltiges n:%d",n); exit();}
 bitschuettler(rfeld,ifeld,n);
 for(k=1; k<n; k=zweik)
  {zweik=k+k;
   for (m=0; m<k; m++)
       {wreal= cos(a=m*PI/k);
	wimag= (inv==1) ? sin(a) : -sin(a);
	for (i=m; i<n; i+= zweik)
	  {j=i+k;
	   treal= wreal*rfeld[j] - wimag*ifeld[j];
	   timag= wreal*ifeld[j] + wimag*rfeld[j];
	   rfeld[j]= rfeld[i]-treal; ifeld[j]= ifeld[i]-timag;
	   rfeld[i] += treal; ifeld[i] += timag;
  }    }  }
 if(inv==1)
	for(i=0;i<n;i++) {rfeld[i] /= n; ifeld[i] /= n;}
}

void bitschuettler(double *rfeld,double *ifeld,int n)
{
 register int m,k,j; double hr,hi;
 for(j=1;j<n-1;j++)
    {k=0; m=j+n;
     do	{k += k + (m&1);	/* unterstes Bit von m links ins k schieben */
	 m >>= 1;		/* m 1 Bit nach rechts schieben */
	}
     while (m>1);	/* k= Bitreverse(j) */
      if (k<j)	{hr= rfeld[j]; hi= ifeld[j];
		 rfeld[j]= rfeld[k]; ifeld[j]= ifeld[k];
		 rfeld[k]= hr; ifeld[k]= hi;
    }		}
}

void fft_hilfetext()
{
 printf("Fuer Distanzmessungen: 2 waehlen, korrespondierende Distanzen\n");
 printf("mit bei Transformation angegebener Formel berechnen.\n");
 printf("Fuer FFT-Glaettung: 2 oder 4 waehlen, nach Transformation hochfrequente\n");
 printf("Teile auf 0 setzen (Menu Edit/BlowUp), dann Ruecktransformieren.\n");
 printf("fuer Ruecktransformation muss der gleiche Bereich eingestellt sein.\n");
}
void fft_methode()
{
 char *s; int flag;
 lower_window();
 printf("FFT_Methode:\n");
 printf(" 1  Real und Imag-Teil verwenden (Spektrum 0 u. 1)\n");
 printf(" 2  Eingabe:nur Real  Rueckgabe: Betrag  (imag u. real unsichtbar)\n");
 printf(" 3  FFT-Eingabe:nur Real  Rueckgabe:imag und real\n");
 printf(" 4  wie 3 aber mit Spiegelkorrektur bei Ruecktransformation\n");
 printf(" 5  PFT verwenden (langsame periodische DFT)\n");
 printf(" 6  DFT verwenden (langsam, nicht periodisch)\n");
 printf(" H  Hilfe\n");
 do
  {flag=0; s=inputstr1("(%ld) FFT_Methode:",fftmethode);
   if(*s!=0)
	{if(!isdigit(*s)) {flag=1; fft_hilfetext();}
	 else sscanf(s,"%d",&fftmethode);
	}
   cfree(s);
  }
 while(flag);
 raise_window();
 if(shmodus<2 && fftmethode!=2) modus_2();
}

/**** PFT = Periodische FourierTransformation ****/
void pft(int nn,double *y,double *a,double *b)
{
 double n2pi,z,*yj,*yi;
 int n,i,Nhalbe=nn/2;
 for(n=0;n<nn;n++)
  {*a=(*(yi=y)+y[nn])/2. + y[Nhalbe]*cos(n2pi=n*PI);
   n2pi/=Nhalbe;
   *b=0.;
   for(yj= &y[nn],i=0;++i<Nhalbe;)
	{*a += (*++yi + *--yj)*cos(z=n2pi*i);
	 *b += (*yi - *yj)*sin(z);
	}
   *a++ /= Nhalbe;
   *b++ /= Nhalbe;
  }
}
void pft_invers(int nn,double *y,double *a,double *b)
{
 double n2pi,z,a0halbe= *a/2.;
 int n,k,Nhalbe=nn/2;
 for(*y=a0halbe,k=0;++k<=nn;) *y += a[k];
 for(n=1;n<nn;n++)
  {n2pi=n*PI/Nhalbe;
   *++y=a0halbe;
   for(k=0;++k<=Nhalbe;)
	{z=k*n2pi;
	 *y += a[k]*cos(z)+b[k]*sin(z);
	}
  }
}

void dft(int nn,int inv,double *a,double *b,double *ya,double *yb)
{
 double m2pi,z,sinz,cosz,*pa,*pb;
 int m,n,Nhalbe=nn/2;
 for(m=0;m<nn;m++)
  {if(inv) m2pi= m*PI/Nhalbe;
   else m2pi= -m*PI/Nhalbe;
   *ya = *a;
   *yb = *b;
   for(pa=a,pb=b,n=0;++n<nn;)
	{z=n*m2pi;
	 *ya += *++pa*(cosz=cos(z)) - *++pb*(sinz=sin(z));
	 *yb += *pa*sinz + *pb*cosz;
	}
   if(inv) {*ya++ /= nn;  *yb++ /= nn;}
   else    {ya++; yb++;}
  }
}

/**********************************************/
void number_zoom()
{
 lower_window();
 xmi2=doubinputstr1("(%lf) xmin:",xmi2);
 xma2=doubinputstr1("(%lf) xmax:",xma2);
 ymi2=doubinputstr1("(%lf) ymin:",ymi2);
 yma2=doubinputstr1("(%lf) ymax:",yma2);
 raise_window();
 refresh();
}

#ifdef OPENGL
void lower_window() {}
void raise_window() {}
#else
void lower_window() {if(dpy!=NULL) {XLowerWindow(dpy,win1); XSync(dpy,0);}}
void raise_window() {if(dpy!=NULL) {XRaiseWindow(dpy,win1); XSync(dpy,0);}}
#endif

/*************************** Requester ***********************************/
#ifdef OPENGL
int requester(char *text,char *jatext,char *neintext)
{
 return haupt.janeinrequester(text,jatext,neintext);
}
#else
#define mydpy1 dpy

#ifndef PIXPROBUCHST_X
#define PIXPROBUCHST_X 6
#define PIXPROBUCHST_Y 8
#endif

int requester(char *text,char *jatext,char *neintext)
{
 int hoehe,breite,ho,br,n1,n2,n3,x,y,x1,y1,x2,y2,x3,y3;
 int x2ul,x2or,y2ul,y2or,x3ul,x3or,y3ul,y3or;/* Grenzen der ja/nein-Boxen */
 int x0=200,y0=20,randbreite=5,fogrund,higrund;
 int i,done,antwort;
 char *name="Requester";
 Window win;
 XEvent event;
 KeySym key;
 GC gc2;
 char txt[10];
 n1=strlen(text); n2=strlen(jatext);
 if(neintext) n3=strlen(neintext); else n3=0;
 br=(n2>n3)?n2:n3;
 i=br+br+6;/* je 2 Buchstaben fuer Rand in Box plus 2 fuer Abstand */
 if(n1>i) i=n1;
 breite=(i+2)*PIXPROBUCHST_X+randbreite+randbreite;
 hoehe=breite*3/4;
 br=(br+2)*PIXPROBUCHST_X;
 ho=2*PIXPROBUCHST_Y;
 x1=(breite-n1*PIXPROBUCHST_X)/2; y1=hoehe/3;
 x2ul=breite/4-br/2; x2or=x2ul+br;
 x3ul=breite*3/4-br/2; x3or=x3ul+br;
 y2ul=y3ul=hoehe*2/3-ho/2; y2or=y3or=hoehe*2/3+ho/2;
 if(!neintext) /* bei nur einer Antwort Box in Mitte */
	{x2ul += breite/4; x2or += breite/4;}
 x2=x2ul+PIXPROBUCHST_X; y2=y3=y2or-PIXPROBUCHST_Y/2;
 x3=x3ul+PIXPROBUCHST_X;
 higrund=WhitePixel(mydpy1,DefaultScreen(mydpy1));
 fogrund=BlackPixel(mydpy1,DefaultScreen(mydpy1));
 win=XCreateSimpleWindow(mydpy1,DefaultRootWindow(mydpy1),
		x0, y0, breite, hoehe, randbreite, fogrund, higrund);
 gc2=XCreateGC(mydpy1,win,0,NULL);
 XSetBackground(mydpy1,gc2,higrund);
 XSetForeground(mydpy1,gc2,fogrund);
 XSelectInput(mydpy1,win, ButtonPressMask|KeyPressMask|ExposureMask);
 XChangeProperty(mydpy1, win, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (UBYTE*)name, strlen((char *)name));
 XMapRaised(mydpy1,win);
 for(done=0;done==0;)
  {XNextEvent(mydpy1,&event);
   if(event.xexpose.window==win) switch(event.type)
   //XWindowEvent(mydpy1,win,ButtonPressMask|KeyPressMask|ExposureMask,&event);
   //switch(event.type)
    {case Expose:
	if(event.xexpose.count==0)
	 {XDrawImageString(mydpy1, win, gc2,x1,y1,text,strlen(text));
	  XDrawImageString(mydpy1, win, gc2,x2,y2,jatext,strlen(jatext));
	  XDrawRectangle(mydpy1,win,gc2,x2ul,y2ul,br,ho);
	  if(neintext)
	    {XDrawImageString(mydpy1,win,gc2,x3,y3,neintext,strlen(neintext));
	     XDrawRectangle(mydpy1,win,gc2,x3ul,y3ul,br,ho);
	 }  }
     CASE ButtonPress:
	x=event.xbutton.x; y=event.xbutton.y;
	if(x>x2ul && x<x2or && y>y2ul && y<y2or) {antwort=1; done=1;}
	else if(x>x3ul && x<x3or && y>y3ul && y<y3or) {antwort=0; done=1;}
     CASE MappingNotify: XRefreshKeyboardMapping(&event.xmapping);
     CASE KeyPress:
	i=XLookupString(&event.xkey,txt,10,&key,0);
	if(i==1 && *txt== *jatext) {antwort=1; done=1;}
	else if(neintext && i==1 && *txt== *neintext) {antwort=0; done=1;}
    }/* end switch */
  }/* Ende der Eventschlaufe */
 XFreeGC(mydpy1,gc2);
 XDestroyWindow(mydpy1,win);
 return antwort;
}
#endif //OPENGL

/*********************** Lashow-Erweiterung ******************************/
int hatlashowzeichen(char **spename,int anzahl)
{
 if(textflag)
   for(int i=0;i<anzahl;i++) if(**spename++ == '$') return 1;
 if(xytextflag)
	{if((ylabeltext!=NULL && *ylabeltext=='$')
	    ||(xlabeltext!=NULL && *xlabeltext=='$')) return 1;
	}
 return 0;
}

void lashow_definitionen(FILE *fp)
{
 FP(fp,"/bdef {bind def} bind def\n");
 FP(fp,"/hoch 16#5E def /tief 16#5F def /kauf 16#7B def /kzu 16#7D def\n");
 FP(fp,"/bslash 16#60 def /buf 1 string def /er false def\n");
 FP(fp,"/ghfont {mul rmoveto hfont setfont /er true def /HH 0.7 def} bdef\n");
 FP(fp,"/ho {gsave 0 H 0.5 ghfont} bdef /ti {gsave 0 H -0.3 ghfont} bdef\n");
 FP(fp,"/alte {currentpoint grestore currentpoint exch pop exch pop moveto\n");
 FP(fp,"	/HH 1 def} bdef\n");
 FP(fp,"/csho {buf 0 3 -1 roll put buf show} bdef\n");
 FP(fp,"/cshow {er{dup kauf eq{pop}{csho alte}ifelse /er false def}{csho}ifelse} bdef\n");
 FP(fp,"/xxshow {dup hoch eq{pop ho} {dup tief eq{pop ti}{dup kzu eq{pop alte}\n");
 FP(fp," {dup bslash eq{pop bflg{Symfont /bflg false}{nfont /bflg true}ifelse\n");
 FP(fp,"		def H HH mul scalefont setfont}\n");
 FP(fp," {cshow}ifelse}ifelse}ifelse}ifelse} bdef\n");
 FP(fp,"/Lashow {/H exch def /hfont currentfont 0.7 scalefont def\n");
 FP(fp,"\t/nfont currentfont 1 H div scalefont def /bflg true def /HH 1 def\n");
 FP(fp,"\t0 1 2 index length 1 sub{1 index exch get xxshow}for pop}bdef\n");
 FP(fp,"/zLashow {/H exch def m dup stringwidth pop 2 div neg 0 rmoveto H Lashow} def\n");
}

/******************* Vermittlerfunktionen zu Fortran *********************/
extern "C" {
void SHOW_TOTAL();
}
void SHOW_TOTAL() {show_total();}

/************************** Integral-Methode *****************************/
void integ_methode()
{
 lower_window();
 printf("Integralmethoden:\n");
 printf(" 0 = normal  (2 Grenzpunkte, Flaeche darunter wird ausgemessen)\n");
 printf(" 1 = fuer y-Werte wird nur erster Grenzpunkt verwendet\n");
 integral_methode=intinputstr1("(%d) Auswahl:",integral_methode);
 raise_window();
}

/********************** neu ab Version 2.5 *************************/
/** Dinge fuer Dreidimensionale Darstellung **/
static double
//	alfa_3d=40.*GRAD,	//Winkel bei 3D-Darstellung
//	verkuerzung_3d=1.,	//Verkuerzungsfaktor in Zeit-Achse
	tfeld_3d[MAXCOLOR];	//Position der Spektren auf Zeitachse
static int
//	flag_3d=0,	//ist gesetzt wenn Werte eingegeben wurden
	farbig_3d=0;	//3D auch farbig darstellen

void eingabe_3d(int autoflag)
{
 int alfa,i;
 if(!autoflag)
  {lower_window();
   alfa=intinputstr1("(%d) Winkel in Grad:",int(alfa_3d/GRAD+0.5));
   alfa_3d=alfa*GRAD;
   verkuerzung_3d=doubinputstr1("(%lf) Perspektivische Verkuerzung:",
				verkuerzung_3d);
  }
 if(flag_3d==0) for(i=0;i<MAXCOLOR;i++) tfeld_3d[i]=i;
 if(!autoflag)
  {i=intinputstr1("(%d) Spektren auf Zeitachse neu positionieren ?",0);
   if(i!=0)
    for(i=0;i<nspektren;i++)
	tfeld_3d[i]=doubinputstr1("(%lf) tfeld[i]:",tfeld_3d[i]);
   farbig_3d=intinputstr1("(%d) Farbig darstellen ?",farbig_3d);
   raise_window();
  }
 flag_3d=1;
}

int tfeld_laden(double x1,double y1,double x2,double y2,
		 double *tfeld,double *dx,double *dy)
{
 double fx=(x2-x1)/25., fy=(y2-y1)/20.; //provi.
 double f=verkuerzung_3d;
 int i;
 if(!flag_3d) eingabe_3d();
 for(i=0;i<MAXCOLOR;i++)
	tfeld[i]=tfeld_3d[i];
 *dx=f*fx*cos(alfa_3d); *dy=f*fy*sin(alfa_3d);
 return farbig_3d;
}

class Plot3d
{
public:
 double x0,x,y,dx;
 double *f;
 int max;
 Plot3d() {f=NULL; max=0;}
};
static Plot3d p3d;

void plot3d_init(double x1,double y1,double x2,double y2,int max)
{
 if(max<4000) max=4000;
 if(p3d.max!=0) {delete p3d.f; p3d.max=0;}
 p3d.f=new double[max];
 p3d.max=max;
 p3d.x=p3d.x0=x1; p3d.y=y1;
 for(int i=0;i<max;i++) p3d.f[i]=y1;
 p3d.dx=(x2-x1)/max;
}

void plot3d(double x1,double y1,int pen)
{
 double x0,y0,dx,dy,x,y;
 int i,imax,j;
 if(pen==UP)
  {q2plot(x1,y1,pen);
  }
 else
  {x0=p3d.x; y0=p3d.y; dx=p3d.dx;
   imax=int((x1-x0)/dx+0.5);
   dy=(y1-y0)/imax;
   j=int((x0-p3d.x0)/dx+0.5);
   if(j<0) {printf("Fehler: j=%d imax=%d\n",j,imax);//test
	j=0;}
   for(i=0;i<=imax;i++,j++)
	{if(i==imax) {x=x1; y=y1;}
	 else {x=x0+i*dx; y=y0+i*dy;}
	 if(j>=p3d.max || y<p3d.f[j]) pen=UP;
	 else {p3d.f[j]=y; pen=DOWN;}
	 q2plot(x,y,pen);
	}
  }
 p3d.x=x1; p3d.y=y1;
}

void bewegung1() {bewegung(tek_mausx,tek_mausy);}
//void klick(int knopf,int x,int y,int knopfnr);
#ifdef OPENGL
void klick1() {klick(1,tek_mausx,tek_mausy,maustasten_zustand); zoom_erster_klick=0;}
void klick0() {klick(0,tek_mausx,tek_mausy,maustasten_zustand);}
#else
void klick1() {klick(1,tek_mausx,tek_mausy,tekplot_event.xbutton.button);}
void klick0() {klick(0,tek_mausx,tek_mausy,tekplot_event.xbutton.button);}
#endif
