/* sinus.cc	Einfaches Beispielprogramm zur Verwendung von showit */
/*
 Uebersetzen und Linken:
;ALPHA> cxnew sinus
;ALPHA> blink sinus,showit,[pfister.obj]xmenu
;ALPHA> pur sinus.exe
;VAX> GX2 sinus
;VAX> BLINK sinus,[PFISTER.obj]SHOWIT,xmenu
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "showitlight.h"
extern const char *showit_voreinst;
#define MAXFELD 1024
#define ZWEIPI 6.28318530717959

void daten_einlesen(float *,float *);
static int testflag=0;
float feld[MAXFELD],hilfsfeld[MAXFELD];
int npoints=MAXFELD;

int main(int argc,char *argv[])
{
 float xmin= 100.,ymin= -1.1,xmax=150.,ymax=1.1,y0,faktor=1.;
 int modus=2,i;
 char antwort[20];
 printf("mit Testausdrucken ?"); scanf("%s",antwort);
 testflag=(toupper(*antwort)!='N');
 printf("Anzahl Punkte (max.%d) :",MAXFELD); scanf("%d",&npoints);
 if(npoints>MAXFELD || npoints<1) npoints=MAXFELD;
 showit_voreinst="sinus.voreinst";
 daten_einlesen(feld,hilfsfeld);
 yskalierung(&faktor); /* alle y-Werte werden durch faktor geteilt */
 for(i=0;i<npoints;i++)
	{if(feld[i]<ymin) ymin=feld[i];
	 if(hilfsfeld[i]<ymin) ymin=hilfsfeld[i];
	 if(feld[i]>ymax) ymax=feld[i];
	 if(hilfsfeld[i]>ymax) ymax=hilfsfeld[i];
	}
 y0=ymax/30.; if(-y0<ymin) ymin= -y0;
 ymax+=y0;
 showit(&xmin,&ymin,&xmax,&ymax,&npoints,&modus,feld,hilfsfeld);
 return 0;
}/* ende von main */

void file_exit() {exit(0);}
void file_load()
{
 int i,modus=4;
 double z=(ZWEIPI*4.)/(npoints-1);
 lower_window();
 printf("file_load() erstellt hier cosinuskurve\n");
 for(i=0;i<npoints;i++) {hilfsfeld[i]=cos(i*z);}
 new_hfeld(hilfsfeld,&modus);
 raise_window();
 refresh();
}
void file_save()
{
 printf("file_save() noch vervollstaendigen!\n");
}

/************************ Vordeklarationen *******************************/
void int_save1(float *z,float *xspitz,float *yspitz,float *grenz);
void int_save2(float *z,float *xspitz,float *yspitz,float *grenz);
void get_punkt1(float *x,float *y);
void get_punkt2(float *x,float *y);
void texte_laden(char **titel,const char **xachse,const char **yachse);
void get_delta(float *z,float *grenz);

/*************************************************************************/

void user_prog(int *fun,POINTER p1,POINTER p2,POINTER p3,POINTER p4)
{
 if(testflag) printf("user_prog() Funktionsnummer=%d\n",*fun);
 switch(*fun)
  {case 1: /*int_save1((float*)p1,(float*)p2,(float*)p3,(float*)p4); break;*/
   case 2: int_save2((float*)p1,(float*)p2,(float*)p3,(float*)p4); break;
   case 3: /*get_punkt1((float*)p1,(float*)p2); break;*/
   case 4: get_punkt2((float*)p1,(float*)p2); break;
   case 5: texte_laden((char**)p1,(const char**)p2,(const char**)p3); break;
   case 6: get_delta((float*)p1,(float*)p2); break;
   default: printf("user_prog(fun=%d...) not yet defined\n",*fun);
  }
}
/* Die Unterprogramme von user_prog muessen nicht alle definiert sein,	*/
/* sondern koennen bei Nichtgebrauch auskommentiert werden		*/

void int_save2(float *z,float *xspitz,float *yspitz,float *grenz)
{
 printf("int_save2()  z=%lf  xspitz=%lf  yspitz=%lf\n",*z,*xspitz,*yspitz);
 printf("  grenz[4]={%lf %lf %lf %lf}\n",grenz[0],grenz[1],grenz[2],grenz[3]);
}
void get_punkt2(float *x,float *y)
{
 printf("get_punkt2()  x=%lf  y=%lf\n",*x,*y);
}
void texte_laden(char **titel,const char **xachse,const char **yachse)
{
 static char meintitel[80];
 if(testflag) printf("texte_laden()\n");
 strcpy(meintitel,"Titel oder Substanzname\nkann auch mehrere Zeilen haben");
 *titel=meintitel;
 *xachse="x-Achse";
 *yachse="y-Achse";
}
void get_delta(float *z,float *grenz)
{
 printf("get_delta()  z=%lf  x1=%lf y1=%lf x2=%lf y2=%lf}\n",
	*z,grenz[0],grenz[1],grenz[2],grenz[3]);
}

/********************** Benutzerfunktionen *******************************/

void daten_einlesen(float *feld,float *hilfsfeld)
{
 int i;
 double z=(ZWEIPI*5.)/(npoints-1),
	z2=(ZWEIPI*20)/(npoints-1),
	z3=(ZWEIPI*7)/(npoints-1);//test
 for(i=0;i<npoints;i++) {feld[i]=hilfsfeld[i]=sin(i*z)+0.5*sin(i*z2)+cos(i*z3);}
}
