/* myfonts.h			letzte Aenderung: 19.2.2021 */
#ifndef MYFONTS_H
#define MYFONTS_H

#include <fstream>
#include <iostream>
#include <string.h>
#include<cstdint>
#define uchar uint8_t
void tek_punkt(double,double);
void fillbox(double x1,double y1,double x2,double y2);
void koordpix2user(int i,int j,double* x,double* y);
void rgbcolor(int r,int g,int b);
void zwert_decrement();

class Font
{
 void zeichne_zeichen(double x0,double y0,uchar zeichen,bool punktflag);
 bool bitgesetzt(uchar *pf,int i,int j);
 int bx,hy; //bx=Breite hy=Hoehe eines Zeichens in Pixel (Fontpixel)
public:
 bool missingInit();
 uchar *pfont; //Zeiger auf die Font-Daten
 int typ; //Fonttypen siehe myfonts.cc
 int bytesprozeichen; //Anzahl Bytes pro Zeichen in pfont
 int scalx, scaly; //fuer Vergroesserung des Fonts
 double user_dx, user_dy; //Pixelgroesse in Userkoordinaten
 double schrift_hoehe,schrift_breite; //Hoehe und Breite eines Zeichens in Benutzerkoordinaten
 int get_ischrift_breite() {return bx*scalx;}
 int get_ischrift_hoehe()  {return hy*scaly;}
 int get_bux() {return bx*scalx;}
 int get_buy() {return hy*scaly;}
 
 Font(uchar *p,int b,int h,int t,int bpz) {
  pfont=p; bx=b; hy=h; typ=t; bytesprozeichen=bpz;
  scalx=scaly=1; //fuer Vergroesserung des Fonts
  schrift_hoehe=schrift_breite=0; //muss mit init() noch richtig gesetzt werden
  user_dx=user_dy=0; //muss mit init() noch richtig gesetzt werden
 }
 void init(double dx,double dy) {
  user_dx=dx; user_dy=dy; //Pixelgroesse in Userkoordinaten
  schrift_breite = user_dx*bx*scalx;
  schrift_hoehe = user_dy*hy*scaly;
 }
 void iscale(int ix,int iy) {
  scalx=ix; scaly=iy; //fuer Vergroesserung des Fonts
 }
 void neuerFont(uchar *p,int b,int h,int t,int bpz) {
  pfont=p; bx=b; hy=h; typ=t; bytesprozeichen=bpz;
 }
 int font_aendern(const char *fontname); //Rueckgabewert ist Fonthoehe in Pixel, oder 0 bei Fehler

 //TODO: winkel muss bisher immer 0 sein, utf8flag noch nicht unterstuetzt
 void ischrift(int x0,int y0,const char *text,double winkel=0,bool utf8flag=false);
 void schrift(double x0,double y0,const char *text,double winkel=0,bool utf8flag=false);
 
 //TODO: style wird noch nicht benutzt
 //wenn font gesetzt ist, dann wird zuerst font_aendern() aufgerufen
 //b,h ist gewuenschte Fontgroesse, Rueckgabewert ist tatsaechlich gesetzte Fonthoehe
 int itextsize(int b,int h,const char *font=NULL,int style=0);
 double textsize(double b,double h,const char *font=NULL,int style=0);
 
 //Farben: 0xBBGGRR, 0=reserviert fuer Default-Farbe (0x010101 ist auch fast schwarz)
 uint32_t hintergrundfarbe=0; //0 = Schrift ohne Hintergrund zeichnen
 uint32_t vordergrundfarbe=0; //0 = default-Farbe
 void setFarben(uint32_t vor,uint32_t hin) {vordergrundfarbe=vor; hintergrundfarbe=hin;}
 void color(uint32_t farbe);
};

extern uchar myfont6x8[];
extern uchar myfont9x12[];
extern uchar myfont12x16[];
extern uchar myfont14x18[];
extern uchar myfont14x20[];
extern Font *aktfont; //Zeiger auf aktuellen Font

#endif
