/* main.cpp  letzte Aenderung: 17.2.2021

Beispielprogramm um OpenGLTekplot zu verwenden
die folgenden zwei Pakete muessen installiert sein:
 libsdl2-dev
 libglew-dev
*/

/****** Sachen zum Debuggen: ******/
// Test wenn es mit Version 3.3 sonst nicht geht:
// MESA_GL_VERSION_OVERRIDE=3.3 MESA_GLSL_VERSION_OVERRIDE=330 ./main
// oder die folgenden 2 Zeilen definieren:
//#define MESA_GL_VERSION_OVERRIDE   "3.3"
//#define MESA_GLSL_VERSION_OVERRIDE "330"

//#define _DEBUG  //bei Bedarf im makefile definiert
//#define PERF_TEST //Performance-Test: zeigt Zeit zum Zeichnen des Bildes an

/****** Ende Debuggen ******/

#define TEKPLOT1_IMPLEMENTATION
#include "otekplot1.h"

static int exitflag=0;
void m_exit(int id) {exitflag=1; printf("m_exit(id=%d)\n",id);}
void m_load(int id)
{
 printf("m_load() aufgerufen id=%d\n",id);//test
 char name[200]="test.txt";
 int ok=nachfilenamefragen("Load File",name,200);
 printf("nachfilenamefragen() --> ok=%d name=\"%s\"\n",ok,name);//test
 if(ok)
  {
   FILE *fp=fopen(name,"rb");
   if(fp==NULL) printf("Datei %s nicht gefunden\n",name);
   else
    {
     printf("Datei %s erfolgreich gelesen\n",name);//test
     fclose(fp);
    }
  }
}
void m_about()
{
 janeinrequester("Testprogramm Version 0.0\n");
 //int ok=janeinrequester("Testprogramm Version 0.0\n","ja","nein");//test
 //printf("ok=%d\n",ok);//test
}
void m_test1(int id) {printf("m_test1(id=%d)\n",id);}
void m_test2(int id) {printf("m_test2(id=%d)\n",id);}
void m_test3(int id) {printf("m_test3(id=%d)\n",id);}
void m_test4(int id) {printf("m_test4(id=%d)\n",id);}

static int breite,hoehe,tiefe=24,visclass=0;
void alles_zeichnen(void);
void maus_press(void);
void maus_rel(void), fenster_exp(void), maus_mot(void); //Vordeklarationen

/**************** Routinen zur Parameterauswertung ********************/
static char argflag[128];
void setargflags(const char *s)
{
 int c;
 while((c= *s++)!=0)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

int main(int argc, char** argv)
{
 double xmin= -0.2, xmax=1.2, ymin=0, ymax=1.0;
 //float32 xmin= -0.1, xmax=1.1, ymin=0, ymax=1.0; //sollte auch gehen
 int maxbreite=900,maxhoehe=600;
 for(int i=1,c=0;i<argc;i++)
  {
   if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
   //else	if(++j==1) strcpy(quellname,argv[i]);
   //else if(j==2) strcpy(zielname,argv[i]);
  }
 if(argflag['?'] || argflag['H'])
  {
   printf("usage: %s [-options]\n",argv[0]);
   printf(" Options:\n");
   printf("  ?, h = help\n");
   printf("  f = fullscreen\n");
   printf("  b = borderless screen\n");
   printf("  m = Menufonts aendern\n");
   printf("  q = Requesterfonts aendern\n");
   return 0;
  }
 getmaxsize(&maxbreite,&maxhoehe,&tiefe,&visclass);
 printf("Maximale Fenstergroesse: breite=%d hoehe=%d tiefe=%d\n",
	maxbreite,maxhoehe,tiefe);
 breite = maxbreite*95/100;
 hoehe = (int)(breite/(xmax-xmin) * (ymax-ymin) + 0.5);
 if(hoehe>maxhoehe*95/100)
  {
   hoehe = maxhoehe*95/100;
   breite = (int)(hoehe/(ymax-ymin) * (xmax-xmin) + 0.5);
  }
 //printf("setze Fenstergroesse: breite=%d hoehe=%d\n",breite,hoehe);//test
 setsize(breite, hoehe, tiefe);
 if(argflag['F']) fullscreen_modus();
 else if(argflag['B']) borderless_modus();

 // set_menu_font() ausprobieren:
 if(argflag['M']) {
 double user_dy = (ymax-ymin)/hoehe;
 char fontname[200]="10x14"; int bf=10,hf=14,scal=1;
 printf("diese Fonts verwendbar: 6x8, 9x12, 12x16, 14x18, 14x20\n");
 printf("Font: "); scanf("%s",fontname); 
 printf("Skalierungsfaktor: "); scanf("%d",&scal);
 if(scal<1 || scal>8) scal=1;
 int hneu=0;
 int nf=sscanf(fontname,"%dx%d",&bf,&hf);
 if(nf==2) hneu=set_menu_font(user_dy,bf*scal,hf*scal,fontname);
 if(hneu==0) printf("falscher Font - default 12x16 verwendet\n");
 printf("set_menu_font() --> hneu=%d\n",hneu);//test
 }

 // set_requ_font() ausprobieren:
 char qfontname[200]="10x14"; int qscal=1;
 if(argflag['Q']) {
 printf("diese Fonts verwendbar: 6x8, 9x12, 12x16, 14x18, 14x20\n");
 printf("Requester-Font: "); scanf("%s",qfontname); 
 printf("Skalierungsfaktor: "); scanf("%d",&qscal);
 if(qscal<1 || qscal>8) qscal=1;
 }
 
 //setmenu(-2);//menu debug
 setmenu(2,"File","Help");
 setmenu(2,"Load..","About..",&m_load,&m_about);
 setmenu(2,"Test 1","Test3",&m_test1,&m_test3);
 setmenu(1,"Test 2",&m_test2);
 setmenu(1,"Exit",&m_exit);
 //set_funktions(maus_press,maus_rel,fenster_exp,maus_mot);
 //set_redraw_all_function(alles_zeichnen);//test
 inital(xmin,ymin,xmax,ymax); //Grafikfenster oeffnen
 
 // set_requ_font() ausprobieren:
 if(argflag['Q'])
 {
 int bf=10,hf=14;
 int hneu=0;
 int nf=sscanf(qfontname,"%dx%d",&bf,&hf);
 if(nf==2) hneu=set_requ_font(bf*qscal,hf*qscal,qfontname);
 if(hneu==0) printf("falscher Requester-Font - default 12x16 verwendet\n");
 printf("set_requ_font() --> hneu=%d\n",hneu);//test
 }
 
 screenclear(0x7F7F7F); //grauer Hintergrund
 plot(0.0, 0.01, PENUP); plot(1.0, 0.01, PENDOWN); //eine Linie zeichnen
 plot(1.0, 0.99, PENDOWN); //weitere Linie zu diesem Punkt
 plot(0.0, 0.99, PENDOWN); //weitere Linie zu diesem Punkt
 plot(0.0, 0.01, PENDOWN); //weitere Linie zu diesem Punkt
 //rgbcolor(255,255,0); //Farbe Gelb
 //fillbox(0.25, 0.25, 0.75, 0.75); //gelbes Quadrat zeichnen
 
 rgbcolor(255,0,255); //pink
 fillbox(0.15, 0.15, 0.35, 0.35); //pinkes Quadrat hinter dem grossen Quadrat
 
 rgbcolor(255,0,0); //Farbe Rot
 drawbox(0.26, 0.26, 0.74, 0.74); //rote Umrandung des Quadrats
 //muesste eigentlich vom folgenden Quadrat verdeckt werden
 
 rgbcolor(80,80,80); //dunkelgrau
 fillbox(0.25, 0.25, 0.75, 0.75); //graues Quadrat zeichnen
 
 rgbcolor(255,0,0); //Farbe Rot
 drawbox(0.25, 0.25, 0.75, 0.75); //rote Umrandung des Quadrats

 //float zvorher=haupt.get_zwert();//test
 //haupt.set_zwert(1.0f+1.0f/1025);//test: so sollte es hinter allem andern liegen
 rgbcolor(255,255,0); //gelb
 fillbox(0.65, 0.65, 0.85, 1.05); //gelbes Quadrat vor dem grossen Quadrat
 //haupt.set_zwert(zvorher);//test
 
 rgbcolor(255,0,0); //Farbe Rot
 tek_punkt((xmin+xmax)/2, (ymin+ymax)/2); //roter Punkt in Bildmitte
 
 //bei ipunkt() geht y-Koordinate von oben nach unten
 //int ymitte = hoehe/2 - get_menuleistenhoehe();
 int ymitte = hoehe/2;
 //rgbcolor(0,0,255); //Farbe Blau
 rgbcolor(0,255,255); //Farbe Hell-Blau
 ipunkt(breite/2+5, ymitte-5); //blauer Punkt 5 Pixel von Bildmitte entfernt
 ipunkt(breite/2+10, ymitte-10); //und 10 Pixel rechts oben von Bildmitte
 rgbcolor(255,0,255); //Farbe Pink
 ipunkt(breite/2-5, ymitte+5); //das selbe in pink fuer links unten
 ipunkt(breite/2-10, ymitte+10); //das selbe in pink fuer links unten

 //Test von Schrift:
 rgbcolor(255,0,0); //Farbe Rot
 double x=xmin+(xmax-xmin)/100;
 double y=ymin+(xmax-xmin)/100;
 //double bx=(xmax-xmin)/50, hy=bx*16.0/12;
 double bx=(xmax-xmin)/50, hy=bx*1.5;
 //printf("im Hauptprogramm: bx=%f hy=%f\n",bx,hy);//test
 hy = textsize(bx,hy);
 /*
 bx = hy*12.0/16;//ungefaehr
 printf("hy=textsize(bx,hy) --> hy=%f bx=%f\n",hy,bx);//test
 drawbox(x,y,x+bx,y+hy);//test
 drawbox(x+bx,y,x+2*bx,y+hy);//test
 drawbox(x+2*bx,y,x+3*bx,y+hy);//test
 schrift(x,y,"Abc"); //test
 */
 schrift(x,y,"Links unten");

 rgbcolor(0,0,255); //Farbe Blau
 itextsize(20,32);
 ischrift(breite-300, 50,"Rechts oben");

 rgbcolor(0,0,0); //schwarz
 itextsize(24,32,"12x16");
 //itextsize(12,16);
 ischrift(10, 32,"Links oben");

 term_refresh();
 int zeit=0;
 while(exitflag==0 && waitmenu(0)==0)
  {
   for(int i=1;i<60;i++) waitTOF(); //etwa 1 Sekunde warten
   zeit++;
   //printf("%2d Sec\n",zeit);//test
  }
 term_exit();
 //printf("Fenster sollte jetzt geschlossen sein. Weiter mit RETURN "); getc(stdin);//test
 return 0;
}

void alles_zeichnen()
{
 double xmin= -0.2, xmax=1.2, ymin=0, ymax=1.0;
 inital_new(); //Grafikfenster oeffnen
 screenclear(0x7F7F7F); //grauer Hintergrund
 plot(0.0, 0.01, PENUP); plot(1.0, 0.01, PENDOWN); //eine Linie zeichnen
 plot(1.0, 0.99, PENDOWN); //weitere Linie zu diesem Punkt
 plot(0.0, 0.99, PENDOWN); //weitere Linie zu diesem Punkt
 plot(0.0, 0.01, PENDOWN); //weitere Linie zu diesem Punkt
 //rgbcolor(255,255,0); //Farbe Gelb
 //fillbox(0.25, 0.25, 0.75, 0.75); //gelbes Quadrat zeichnen
 
 rgbcolor(255,0,255); //pink
 fillbox(0.15, 0.15, 0.35, 0.35); //pinkes Quadrat hinter dem grossen Quadrat
 
 rgbcolor(255,0,0); //Farbe Rot
 drawbox(0.26, 0.26, 0.74, 0.74); //rote Umrandung des Quadrats
 //muesste eigentlich vom folgenden Quadrat verdeckt werden
 
 rgbcolor(80,80,80); //dunkelgrau
 fillbox(0.25, 0.25, 0.75, 0.75); //graues Quadrat zeichnen
 
 rgbcolor(255,0,0); //Farbe Rot
 drawbox(0.25, 0.25, 0.75, 0.75); //rote Umrandung des Quadrats

 //float zvorher=haupt.get_zwert();//test
 //haupt.set_zwert(1.0f+1.0f/1025);//test: so sollte es hinter allem andern liegen
 rgbcolor(255,255,0); //gelb
 fillbox(0.65, 0.65, 0.85, 1.05); //gelbes Quadrat vor dem grossen Quadrat
 //haupt.set_zwert(zvorher);//test
 
 rgbcolor(255,0,0); //Farbe Rot
 tek_punkt((xmin+xmax)/2, (ymin+ymax)/2); //roter Punkt in Bildmitte
 
 //bei ipunkt() geht y-Koordinate von oben nach unten
 //int ymitte = hoehe/2 - get_menuleistenhoehe();
 int ymitte = hoehe/2;
 //rgbcolor(0,0,255); //Farbe Blau
 rgbcolor(0,255,255); //Farbe Hell-Blau
 ipunkt(breite/2+5, ymitte-5); //blauer Punkt 5 Pixel von Bildmitte entfernt
 ipunkt(breite/2+10, ymitte-10); //und 10 Pixel rechts oben von Bildmitte
 rgbcolor(255,0,255); //Farbe Pink
 ipunkt(breite/2-5, ymitte+5); //das selbe in pink fuer links unten
 ipunkt(breite/2-10, ymitte+10); //das selbe in pink fuer links unten

 //Test von Schrift:
 rgbcolor(255,0,0); //Farbe Rot
 double x=xmin+(xmax-xmin)/100;
 double y=ymin+(xmax-xmin)/100;
 //double bx=(xmax-xmin)/50, hy=bx*16.0/12;
 double bx=(xmax-xmin)/50, hy=bx*1.5;
 //printf("im Hauptprogramm: bx=%f hy=%f\n",bx,hy);//test
 hy = textsize(bx,hy);
 /*
 bx = hy*12.0/16;//ungefaehr
 printf("hy=textsize(bx,hy) --> hy=%f bx=%f\n",hy,bx);//test
 drawbox(x,y,x+bx,y+hy);//test
 drawbox(x+bx,y,x+2*bx,y+hy);//test
 drawbox(x+2*bx,y,x+3*bx,y+hy);//test
 schrift(x,y,"Abc"); //test
 */
 schrift(x,y,"Links unten");

 rgbcolor(0,0,255); //Farbe Blau
 itextsize(20,32);
 ischrift(breite-300, 50,"Rechts oben");

 rgbcolor(0,0,0); //schwarz
 //itextsize(24,32,"12x16");
 itextsize(12,16);
 ischrift(10, 20,"Links oben");

 term_refresh();
}

void maus_press()
{
 printf("maus_press() aufgerufen\n");//test
}

void maus_rel()
{
 printf("maus_rel() aufgerufen\n");//test
}

void fenster_exp()
{
 printf("fenster_exp() aufgerufen\n");//test
}

void maus_mot()
{
 printf("maus_mot() aufgerufen\n");//test
}
