// Klasse Mesh aehnlich wie im OpenGL-Tutorial, aber abgeaendert fuer 2D-Grafik

class Mesh {
private:
 VertexBuffer* vertexBuffer; //Puffer fuer alle Punkte
 IndexBuffer *indexBuffer; //Puffer zum Dreiecke zeichnen, jeweils 3 Indices pro Dreieck
 IndexBuffer *indexBufferLines; //zum Linien zeichnen, jeweils 2 Indices pro Linie
 IndexBuffer *indexBufferPoints; //zum einzelne Punkte zeichnen, 1 Index pro Punkt
public:
 uint32 numVertices; //Anzahl aller Punkte
 uint32 numTriangIndices, numLineIndices, numPointIndices;
 //TODO: MAXVERTICES wegoptimieren. eventuell mit std::vector<Vertex> und std::vector<uint32>?
 Vertex vertices[MAXVERTICES]; //alle Punkte
 uint32 triangIndices[MAXVERTICES]; //Indexe auf vertices fuer Dreiecke
 uint32 lineIndices[MAXVERTICES]; //jeweils 2 Punkte pro Linie
 uint32 pointIndices[MAXVERTICES]; //Indexe auf vertices fuer einzelne Punkte

 Mesh() {
  vertexBuffer = NULL;
  indexBuffer = indexBufferLines = indexBufferPoints = NULL;
  numVertices = 0;
  numTriangIndices = numLineIndices = numPointIndices = 0;
 }
 
 ~Mesh() {delBuffers();}
 
 void delBuffers() {
  if(vertexBuffer!=NULL) delete vertexBuffer;
  if(indexBuffer!=NULL)  delete indexBuffer;
  if(indexBufferLines!=NULL) delete indexBufferLines;
  if(indexBufferPoints!=NULL) delete indexBufferPoints;
  vertexBuffer = NULL;
  indexBuffer = indexBufferLines = indexBufferPoints = NULL;
 }

 void clear() {numVertices=0;  numTriangIndices = numLineIndices = numPointIndices = 0; delBuffers();}
 void genbuffers();
 void render();
};

#ifdef TEKPLOT1_IMPLEMENTATION
void Mesh::genbuffers()
{
 delBuffers();
 if(numVertices!=0)
  {
   if(numTriangIndices==0) indexBuffer=NULL;
   else indexBuffer = new IndexBuffer(triangIndices, numTriangIndices, sizeof(uint32));
   if(numLineIndices==0) indexBufferLines=NULL;
   else indexBufferLines = new IndexBuffer(lineIndices, numLineIndices, sizeof(uint32));
   if(numPointIndices==0) indexBufferPoints=NULL;
   else indexBufferPoints= new IndexBuffer(pointIndices, numPointIndices, sizeof(uint32));
   vertexBuffer = new VertexBuffer(vertices, numVertices);
   vertexBuffer->unbind();
  }
}

void Mesh::render()
{
 if(numVertices>0)
  {
   vertexBuffer->bind();
   if(numTriangIndices>0)
    {
     indexBuffer->bind();
     glDrawElements(GL_TRIANGLES, numTriangIndices, GL_UNSIGNED_INT, 0);
     indexBuffer->unbind();
    }
   if(numLineIndices>0)
    {
     indexBufferLines->bind();
     glDrawElements(GL_LINES, numLineIndices, GL_UNSIGNED_INT, 0);
     indexBufferLines->unbind();
    }
   if(numPointIndices>0)
    {
     indexBufferPoints->bind();
     glDrawElements(GL_POINTS, numPointIndices, GL_UNSIGNED_INT, 0);
     indexBufferPoints->unbind();
    }
  }
}
#endif
