/* Tabellen um UTF8-Zeichen in Code fuer myfont12x16.h umzurechnen:
0x20 .... 0x7E  ASCII-Zeichen
0x7F Delete

Sonderzeichen in myfont12x16.h:
          UTF8
0x80 \"a  0xC3A4  Umlaut kleines a
0x81 \"A  0xC384
0x82 \"o  0xC3B6
0x83 \"O  0xC396
0x84 \"u  0xC3BC
0x85 \"U  0xC39C
0xC5      0xC385  Aring, Angstrom
0xDF      0xC39F  Scharfes S
0xE5      0xC3A5  aring
0xE7	  OxC3B7  : mit - kombiniert (Geteiltdurch-Zeichen)
0xF1	  OxC3B1  n-tilde
0xF3	  OxC397  Mal-Zeichen als Kreuz

0xA1      0xC2A1  Umgekehrtes Ausrufezeichen
0xB7      0xC2A2  cent sign (C mit senkrechtem Strich)
0xB5      0xC2B5  mu
0xB0      0xC2B0  hochgestelltes 0
0xB9      0xC2B9  hochgestelltes 1
0xB2      0xC2B2  hochgestelltes 2
0xB3      0xC2B3  hochgestelltes 3
0xAB      0xC2AB  << als 1 Zeichen
0xBB      0xC2BB  >> als 1 Zeichen
0xA4      0xC2A4  Viereck mit zusaetzlichen Eckpunkten (currency sign)
0xA5      0xC2A5  Y mit 2 Querstrichen (Yen sign)
0xA6      0xC2A6  unterbrochenes | (senkrechter Strich)
0xA8      0xC2A8  kleines Anfuehrungszeichen (diaresis)
0xB4      0xC2B4  kleiner hochgestellter Querstrich / (acute accent)
0xAC      0xC2AC  langes Minuszeichen mit Haken rechts (not sign)
0xA9      0xC2A9  eingekreistes C
0xAE      0xC2AE  eingekreistes R
0xB1      0xC2B1  +- als 1 Zeichen
0xBC      0xC2BC  1/4
0xBD      0xC2BD  1/2
0xBE      0xC2BE  3/4
0xBF      0xC2BF  Umgekehrtes Fragezeichen
0xAA      0xC2AA  a mit Unterstrich, ordinal-a
0xBA      0xC2BA  o mit Unterstrich, ordinal-o

0xF0	  OxC4A7      h-quer
0x89      0xCEB1      Alfa
0x8A      0xCEB2      Beta
0xE0	  OxCEB4      kleines delta, Griechischer Buchstabe
0xF4	  OxCEA0      grosses Pi
0xF5	  OxE2A88D    seltsames f, Integral mit Endlichem Teil
0xAD      0xE28892    langes Minuszeichen
0x9F      0xE281BA    hochgestelltes Plus
0xAF      0xE281BB    hochgestelltes Minus
0x88      0xF09D9C8B  Pi

0xA7      0xE282AC    Eurozeichen
....      0xF09D8494  Violinschluessel //TODO: mit Fonteditor zeichnen, in sonder4byte anfuegen

Neues Zeichen definieren:
> fonteditor fonts/myfont12x16.h
nach zeichnen von neuem Zeichnen mit "Save as ..." speichern.
> fontcopy -ck neu.i neu.h
> mv neu.h myfont12x16.h
UTF8-Code nachschauen und eintragen in sonder2byte[] oder sonder3byte[] oder sonder4byte[]
wobei die erste Zahl die Position vom neu gezeichneten Zeichen ist.
Dann Programm neu compilieren.
*/

unsigned char c2tabelle[256] = {
//..0, ..1,  ..2,  ..3,  ..4,  ..5,  ..6,  ..7,  ..8,  ..9,  ..A,  ..B,  ..C,  ..D,  ..E,  ..F 
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //0..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //1..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //2..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //3..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //4..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //5..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //6..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //7..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //8..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //9..
 0x00, 0xA1, 0xB7, 0x00, 0xA4, 0xA5, 0xA6, 0x00, 0x00, 0xA9, 0xAA, 0x00, 0x00, 0x00, 0xAE, 0x00, //A..
 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0x00, 0xB7, 0x00, 0xB9, 0xBA, 0x00, 0xBC, 0xBD, 0xBE, 0xBF, //B..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //C..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //D..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //E..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  //F..
//..0, ..1,  ..2,  ..3,  ..4,  ..5,  ..6,  ..7,  ..8,  ..9,  ..A,  ..B,  ..C,  ..D,  ..E,  ..F 
};

unsigned char c3tabelle[256] = {
//..0, ..1,  ..2,  ..3,  ..4,  ..5,  ..6,  ..7,  ..8,  ..9,  ..A,  ..B,  ..C,  ..D,  ..E,  ..F 
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //0..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //1..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //2..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //3..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //4..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //5..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //6..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //7..
 0x00, 0x00, 0x00, 0x00, 0x81, 0xC5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //8..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x85, 0x00, 0x00, 0xDF, //9..
 0xC0, 0xD0, 0x00, 0x00, 0x80, 0xE5, 0x00, 0x00, 0xC1, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //A..
 0x00, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x82, 0xE7, 0x00, 0x00, 0x00, 0x00, 0x84, 0x00, 0x00, 0x00, //B..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //C..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //D..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //E..
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  //F..
//..0, ..1,  ..2,  ..3,  ..4,  ..5,  ..6,  ..7,  ..8,  ..9,  ..A,  ..B,  ..C,  ..D,  ..E,  ..F 
};

unsigned char sonder2byte[] = {
 0xF0, 0xC4, 0xA7, //h-quer
 0x89, 0xCE, 0xB1, //Alfa
 0x8A, 0xCE, 0xB2, //Beta
 0xE0, 0xCE, 0xB4, //delta
 0xF4, 0xCE, 0xA0, //grosses Pi
 0x00 //Ende der Tabelle
};

unsigned char sonder3byte[] = {
 0xF5, 0xE2, 0xA8, 0x8D, //seltsames f, Integral mit Endlichem Teil
 0xAD, 0xE2, 0x88, 0x92, //langes Minuszeichen
 0x9F, 0xE2, 0x81, 0xBA, //hochgestelltes Plus
 0xAF, 0xE2, 0x81, 0xBB, //hochgestelltes Minus
 0xA7, 0xE2, 0x82, 0xAC, //Eurozeichen //TODO: mit Fonteditor zeichnen
 0x00 //Ende der Tabelle
};

unsigned char sonder4byte[] = {
 0x88, 0xF0, 0x9D, 0x9C, 0x8B, //Pi
 0x00 //Ende der Tabelle
};

int zeichenlaenge(const unsigned char *str)
{
 if((str[0]&0x80)==0) return 1;
 if((str[0]&0xE0)==0xC0 && (str[1]&0xC0)==0x80) return 2;
 if((str[0]&0xF0)==0xE0 && (str[1]&0xC0)==0x80 && (str[2]&0xC0)==0x80) return 3;
 if((str[0]&0xF8)==0xF0 && (str[1]&0xC0)==0x80
 			&& (str[2]&0xC0)==0x80 && (str[3]&0xC0)==0x80) return 4;
 return 0; //Fehlerhafter Code
}

unsigned char umrechnung_auf_einzelzeichen(const unsigned char *str)
{
 unsigned char *s;
 int n=zeichenlaenge(str);
 if(n==1) return str[0];
 if(n==2)
  {
   if(str[0]==0xC2) return c2tabelle[str[1]];
   if(str[0]==0xC3) return c3tabelle[str[1]];
   for(s=sonder2byte; *s!=0; s+=3)
    {if(strncmp((const char*)&s[1],(const char*)str,2)==0) return s[0];}
   return 0;//Fehler
  }
 if(n==3)
  {
   for(s=sonder3byte; *s!=0; s+=4)
    {if(strncmp((const char*)&s[1],(const char*)str,3)==0) return s[0];}
   return 0;//Fehler
  }
 if(n==4)
  {
   for(s=sonder4byte; *s!=0; s+=5)
    {if(strncmp((const char*)&s[1],(const char*)str,4)==0) return s[0];}
   return 0;//Fehler
  }
 printf("Error: ungueltiges UTF8-Zeichen\n");//test
 return 0;//Fehler
}
