/* irlesen_abs.cc				letzte Aenderung: 6.9.2007 */
/*
Lesen vom ABS-Format von WinFirst vom Mattson 5000 FTIR Spektrometer
*/

#include "otekplot1.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "ulong.h"
#include "irlesen.h"

extern char argflag[];

static double resol2amode(double resol)
{
 double x;
 int k;
 for(k=11,x=8;x>resol && x>=0.25;x/=2.0,k++) ;
 if(x<0.25) k=0;
 return (double)k;
}

static void kopfkopieren(kopf_3 *k3,kopf_1 *k1) //kopf3 nach kopf1 kopieren
{
 int i; char *s,*t;
 k1->start=k3->start;
 k1->ende=k3->ende;
 k1->delta=k3->delta;
 k1->amode=k3->amode;
 k1->npkt=k3->npkt;
 k1->nmulti=k3->nmulti;
 int imax=N40,kla=0,c;
 for(s=k3->snam,t=k1->snam,i=0;++i<imax;)
	{if((c= *s++)=='(') {kla++; imax--;}
	 else if(c==')' && kla>0) {kla--; imax++;}
	 *t++ = c;
	}
 while(kla>0) {--kla; *t++ = ')';} //fehlende Klammern einsetzen
 *t=0;
}

void wertekopieren(FILE *fp,long n,WORD *feld)
{
 float y;
 long i;
 const double minusln10= -log(10.0);
 if(feld==NULL)
   {for(i=0;i<n;i++)
       fread(&y,4,1,fp);
   }
 else
   {for(i=0;i<n;i++)
    //for(i=n;--i>=0;)
        {fread(&y,4,1,fp);
	 feld[i] = (WORD)(exp(minusln10*y)*20000.0+0.5);
	}
   }
}

void abs_lesen(char *acht,FILE *fp,WORD *feld,kopf_1 *kopf1)
{
 kopf_3 kopf;
 int i=6; //Zaehler fuer gelesene Bytes
 int c;
 double xmin,xmax,dx,dx2;
 char *s;
 ungetc(acht[7],fp);
 ungetc(acht[6],fp); //Rueckstellen von 2 Bytes ist nicht garantiert ...
 fread(&xmin,8,1,fp); i+=8;
 fread(&xmax,8,1,fp); i+=8;
 if(argflag['D'])  //... deshalb bei Systemwechsel unbedingt testen ob ...
   printf("Bereich: xmin = %lf xmax = %lf\n", //... die Zahlen korrekt sind!
	  xmin,xmax);
 kopf.start=xmin; kopf.ende=xmax;
 for(;i<0x00CA;i++) getc(fp);
 for(s=kopf.snam; ++i<0x00124 && (c=getc(fp))!=0 && c!=EOF;)  *s++ = c;
 *s=0;           
 for(;i<0x0124;i++) getc(fp);
 fread(&dx2,8,1,fp); i+=8;
 if(argflag['D']) printf("Schrittweite = %lf\n",dx2);
 for(;i<0x012C;i++) getc(fp);
 kopf.npkt=getc(fp); i++;
 kopf.npkt += 256*getc(fp); i++;
 if(argflag['D']) printf("Anzahl Messpunkte: %ld\n",(long)kopf.npkt);
 for(;i<0x0200;i++) getc(fp);
 dx=(xmax-xmin)/(kopf.npkt-1);
 if(argflag['D'] && dx!=dx2) printf("Unterschiedliche dx: %lf %lf\n",dx,dx2);
 kopf.delta=dx;
 kopf.amode=resol2amode(2.1*dx);
 wertekopieren(fp,kopf.npkt,feld);
 kopf.nmulti=1;
 kopfkopieren(&kopf,kopf1);
}
