/* kartendownload.h */

#ifndef KARTENPFAD
#define KARTENPFAD ""
#endif

#ifndef USE_SYSTEM_TO_CONVERT
#define USE_SYSTEM_TO_CONVERT //geht vorlaeufig nicht anders
#endif

#ifdef _WIN32
#define CONVERT_COMMAND "magick convert" //um von .tif nach .jpg zu konvertieren
#define MONTAGE_COMMAND "magick montage" //um von .tif nach .jpg zu konvertieren
#else
#define CONVERT_COMMAND "convert" //um von .tif nach .jpg zu konvertieren
#define MONTAGE_COMMAND "montage" //um von .tif nach .jpg zu konvertieren
#endif

/** von https_get.c aus dem Buch "Hands-On Network Programming with C" uebernommen: **/
// include von chap09.h und Routinen von https_get.c uebernommen
/*
 * MIT License
 *
 * Copyright (c) 2018 Lewis Van Winkle
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if defined(_WIN32)

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0600
#endif
#include <winsock2.h>
#include <ws2tcpip.h>
#pragma comment(lib, "ws2_32.lib")

#else

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>

#endif //_WIN32

#if defined(_WIN32)
#define ISVALIDSOCKET(s) ((s) != INVALID_SOCKET)
#define CLOSESOCKET(s) closesocket(s)
#define GETSOCKETERRNO() (WSAGetLastError())
#else
#define ISVALIDSOCKET(s) ((s) >= 0)
#define CLOSESOCKET(s) close(s)
#define SOCKET int
#define GETSOCKETERRNO() (errno)
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

#define TIMEOUT 300.0

char* unconst(const char *str)
{
 char *t=new char[strlen(str)+1];
 strcpy(t,str);
 return t;
}

void parse_url(char *url, char **hostname, char **port, char** path) {
#ifdef _DEBUG
 printf("URL: %s\n", url);
#endif
    char *p = strstr(url, "://");
    char *protocol = 0;
    if(p) {
        protocol = url;
        *p = 0;
        p += 3;
    } else {
        p = url;
    }

    if (protocol) {
        if (strcmp(protocol, "https")) {
            fprintf(stderr,
                    "Unknown protocol '%s'. Only 'https' is supported.\n",
                    protocol);
            exit(1);
        }
    }

    *hostname = p;
    while (*p && *p != ':' && *p != '/' && *p != '#') ++p;

    *port = unconst("443");
    
    if (*p == ':') {
        *p++ = 0;
        *port = p;
    }
    while (*p && *p != '/' && *p != '#') ++p;

    *path = p;
    if (*p == '/') {
        *path = p + 1;
    }
    *p = 0;

    while (*p && *p != '#') ++p;
    if (*p == '#') *p = 0;

#ifdef _DEBUG
    printf("hostname: %s\n", *hostname);
    printf("port: %s\n", *port);
    printf("path: %s\n", *path);
#endif
}

void send_request(SSL *s, char *hostname, char *port, char *path) {
    char buffer[2048];

    sprintf(buffer, "GET /%s HTTP/1.1\r\n", path);
    sprintf(buffer + strlen(buffer), "Host: %s:%s\r\n", hostname, port);
    sprintf(buffer + strlen(buffer), "Connection: close\r\n");
    sprintf(buffer + strlen(buffer), "User-Agent: honpwc https_get 1.0\r\n");
    sprintf(buffer + strlen(buffer), "\r\n");

    SSL_write(s, buffer, strlen(buffer));
#ifdef _DEBUG
    printf("Sent Headers:\n%s", buffer);
#endif
}

SOCKET connect_to_host(char *hostname, char *port) {
#ifdef _DEBUG
    printf("Configuring remote address...\n");
#endif
    struct addrinfo hints;
    memset(&hints, 0, sizeof(hints));
    hints.ai_socktype = SOCK_STREAM;
    struct addrinfo *peer_address;
    if (getaddrinfo(hostname, port, &hints, &peer_address)) {
        fprintf(stderr, "getaddrinfo() failed. (%d)\n", GETSOCKETERRNO());
        //exit(1);
	return 0;//test
    }

#ifdef _DEBUG
    printf("Remote address is: ");
#endif
    char address_buffer[100];
    char service_buffer[100];
    getnameinfo(peer_address->ai_addr, peer_address->ai_addrlen,
            address_buffer, sizeof(address_buffer),
            service_buffer, sizeof(service_buffer),
            NI_NUMERICHOST);
#ifdef _DEBUG
    printf("%s %s\n", address_buffer, service_buffer);

    printf("Creating socket...\n");
#endif
    SOCKET server;
    server = socket(peer_address->ai_family,
            peer_address->ai_socktype, peer_address->ai_protocol);
    if (!ISVALIDSOCKET(server)) {
        fprintf(stderr, "socket() failed. (%d)\n", GETSOCKETERRNO());
        exit(1);
    }

#ifdef _DEBUG
    printf("Connecting...\n");
#endif
    if (connect(server,
                peer_address->ai_addr, peer_address->ai_addrlen)) {
        fprintf(stderr, "connect() failed. (%d)\n", GETSOCKETERRNO());
        exit(1);
    }
    freeaddrinfo(peer_address);
#ifdef _DEBUG
    printf("Connected.\n\n");
#endif
    return server;
}

int https_get(const char *consturl,const char *ziel)
{ //Rueckgabewet: 0=ok
#ifdef _DEBUG
 printf("https_get(\"%s\", \"%s\")\n",consturl,ziel);//test
#endif
 char url[400]; mystrncpy(url,consturl,400); url[400-1]=0;
 FILE *bildfp = fopen(ziel,"wb");
 if(bildfp==NULL)
  {fprintf(stderr,"konnte Datei \"%s\" nicht erstellen.\n",ziel); return 1;}
 
#if defined(_WIN32)
 WSADATA d;
 if(WSAStartup(MAKEWORD(2, 2), &d)) {
  fprintf(stderr, "Failed to initialize.\n");
  return 1;
 }
#endif
 SSL_library_init();
 OpenSSL_add_all_algorithms();
 SSL_load_error_strings();
#ifdef ALTES_SSL
 SSL_CTX *ctx = SSL_CTX_new(SSLv23_client_method());
#else
 SSL_CTX *ctx = SSL_CTX_new(TLS_client_method());
#endif
 if(!ctx) {
  fprintf(stderr, "SSL_CTX_new() failed.\n");
  return 1;
 }
 
 char *hostname, *port, *path;
 parse_url(url, &hostname, &port, &path);
 SOCKET server = connect_to_host(hostname, port);
 if(server==0) return 2;//test
 
 SSL *ssl = SSL_new(ctx);
 if(!ssl) {
  fprintf(stderr, "SSL_new() failed.\n");
  return 1;
 }

 if(!SSL_set_tlsext_host_name(ssl, hostname)) {
        fprintf(stderr, "SSL_set_tlsext_host_name() failed.\n");
        ERR_print_errors_fp(stderr);
        return 1;
    }

 SSL_set_fd(ssl, server);
 if(SSL_connect(ssl) == -1) {
        fprintf(stderr, "SSL_connect() failed.\n");
        ERR_print_errors_fp(stderr);
        return 1;
    }

#ifdef _DEBUG
 printf ("SSL/TLS using %s\n", SSL_get_cipher(ssl));
#endif
 
 X509 *cert = SSL_get_peer_certificate(ssl);
 if(!cert) {
        fprintf(stderr, "SSL_get_peer_certificate() failed.\n");
        return 1;
    }

#ifdef _DEBUG
 char *tmp;
 if((tmp = X509_NAME_oneline(X509_get_subject_name(cert), 0, 0))) {
        printf("subject: %s\n", tmp);
        OPENSSL_free(tmp);
    }

 if((tmp = X509_NAME_oneline(X509_get_issuer_name(cert), 0, 0))) {
        printf("issuer: %s\n", tmp);
        OPENSSL_free(tmp);
    }
#endif
 
 X509_free(cert);

 send_request(ssl, hostname, port, path);

 const clock_t start_time = clock();

#define RESPONSE_SIZE 500000000 //maximal 500MB grosse Karten downloaden
 //char *response = (char*)malloc(RESPONSE_SIZE+1);
 char *response = new char[RESPONSE_SIZE+1]; //test 
 char *p = response, *q;
 char *end = response + RESPONSE_SIZE;
 char *body = 0;

 enum {length, chunked, connection};
 int encoding = 0;
 int remaining = 0;

 while(1)
  {
   if((clock() - start_time) / CLOCKS_PER_SEC > TIMEOUT)
    {
     fprintf(stderr, "timeout after %.2f seconds\n", TIMEOUT);
     return 1;
    }
   if(p==end)
    {
     fprintf(stderr, "out of buffer space\n");
     return 1;
    }
   fd_set reads;
   FD_ZERO(&reads);
   FD_SET(server, &reads);
   struct timeval timeout;
   timeout.tv_sec = 0;
   timeout.tv_usec = 200;
   if(select(server+1, &reads, 0, 0, &timeout) < 0)
    {
     fprintf(stderr, "select() failed. (%d)\n", GETSOCKETERRNO());
     return 1;
    }
   if(FD_ISSET(server, &reads))
    {
     int bytes_received = SSL_read(ssl, p, end - p);
     if(bytes_received < 1)
      {
       if(encoding==connection && body)
	{
	 printf("%.*s", (int)(end - body), body);
	}
       printf("\nConnection closed by peer.\n");
       break;
      }

     p += bytes_received;
     *p = 0;

     if(!body && (body = strstr(response, "\r\n\r\n")))
      {
       *body = 0;
       body += 4;
#ifdef _DEBUG
       printf("Received Headers:\n%s\n", response);
#endif
       q = strstr(response, "\nContent-Length: ");
       if(q)
	{
	 encoding = length;
	 q = strchr(q, ' ');
	 q += 1;
	 remaining = strtol(q, 0, 10);
	}
       else
	{
	 q = strstr(response, "\nTransfer-Encoding: chunked");
	 if(q) {encoding = chunked; remaining = 0;}
	 else  {encoding = connection;}
	}
#ifdef _DEBUG
       printf("\nReceiving Body ...\n");//test
#endif
      }
     if(body)
      {
       if(encoding == length)
	{
	 if(p-body >= remaining) {
	  for(int i=0;i<remaining;i++) putc(body[i],bildfp);
	  break;
	 }
	} else if(encoding == chunked) {
	         do {
		  if(remaining == 0)
		   {
		    if((q=strstr(body, "\r\n")))
		     {
		      remaining = strtol(body, 0, 16);
		      if (!remaining) goto finish;
		      body = q + 2;
		     }
		    else break;
		   }
		  if(remaining &&  p-body >= remaining)
		   {
		    for(int i=0;i<remaining;i++) putc(body[i],bildfp);
		    body += remaining + 2;
		    remaining = 0;
		   }
		 } while (!remaining);
       }
      } //if (body)
    } //if FDSET
  } //end while(1)
finish:
#ifdef _DEBUG
 printf("\nClosing socket...\n");
#endif
 SSL_shutdown(ssl);
 CLOSESOCKET(server);
 SSL_free(ssl);
 SSL_CTX_free(ctx);

#if defined(_WIN32)
 WSACleanup();
#endif

#ifdef _DEBUG
 printf("Finished.\n");
#endif
 fclose(bildfp);
 //free(response);
 delete[] response;//test
 return 0;
}

/************************** kleinkram **************************/	
bool vorhanden(const char *filename)
{
 FILE *fp=fopen(filename,"rb");
 if(fp==NULL) return false;
 int c=getc(fp);
 fclose(fp);
 return c!=EOF;
}

void filecopy(const char *quelle,const char *ziel)
{
 FILE *fp1=fopen(quelle,"rb");
 if(fp1==NULL) {fprintf(stderr,"Error1 filecopy(%s,%s)\n",quelle,ziel); return;}
 FILE *fp2=fopen(ziel,"wb");
 if(fp2==NULL) {fprintf(stderr,"Error2 filecopy(%s,%s)\n",quelle,ziel); fclose(fp1); return;}
 int c;
 while((c=getc(fp1))!=EOF) {putc(c,fp2);}
 fclose(fp1); fclose(fp2);
}

/*
int getline(FILE *fp,char *s,int lim)
{ // liest eine Textzeile oder maximal lim Zeichen und ersetzt den Zeilentrenner durch 0
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
  {*s++ = c;}
 *s='\0';
 return (c!=EOF); // TRUE wenn erfolgreich, FALSE wenn Fileende
}
*/

bool convert_tif_to_jpg(const char *name,bool aufloesungBeschraenken)
{
 int err= -1;
 char zielname[400], *z;
 mystrncpy(zielname,name,400);
 z=strstr(zielname,".tif");
 if(z==NULL) return false;
 sprintf(z,".jpg");
#ifdef USE_SYSTEM_TO_CONVERT
 char zielname0[400];
 mystrncpy(zielname0,name,400);
 z=strstr(zielname0,".tif");
 if(z==NULL) return false;
 sprintf(z,"-0.jpg");
 char command[840];
 if(aufloesungBeschraenken)
   //sprintf(command,"%s -geometry 14000x9600 %s %s", CONVERT_COMMAND, name, zielname);//dauert lange
   sprintf(command,"%s -geometry 75%% %s %s", CONVERT_COMMAND, name, zielname); //auf 75% verkleinern (schneller)
 else
   sprintf(command,"%s %s %s", CONVERT_COMMAND, name, zielname);
 err=system(command);
 if(err) printf("err=system(%s) --> err=%d\n",command,err);//test
 if(vorhanden(zielname0))
  {rename(zielname0,zielname);}
 else if(!vorhanden(zielname))
  {
   err= -2;
   printf("Datei \"%s\" nicht gefunden\n",zielname0);//test
   //char antw[80]; printf("weiter mit 1: "); scanf("%s",antw);//test
  }
 z=strstr(zielname0,"0.jpg");
 for(int i=1;i<=7;i++)
  {//TODO: eventuell zuerst pruefen ob vorhanden
   *z = '0'+i;
   unlink(zielname0);
  }
#else //USE_SYSTEM_TO_CONVERT
 //TODO: keine Ahnung wie es ohne system() geht
 // stbi_load() geht schon mal nicht, unterstuetzt kein tif
 printf("//TODO\n");
 err = -1;
#endif
#ifdef _DEBUG
 printf(" err=%d\n",err);//test
#endif
 return (err>=0);
}

/************************** Koordinaten-Umrechnungen **************************/	
#ifndef PI
#define PI 3.14159265358979323846
#endif
#define ZWEIPI (2.*PI)
#define PIHALBE (0.5*PI)
#ifndef GRAD
#define GRAD (PI/180.)
#endif
#define WINKELSEK (GRAD/3600.0)

void wgs2swiss(double x0,double y0,double& x1,double& y1) //x=Westlich y=Noerdlich
{
 // Umrechnungs-Formeln aus ch1903wgs84_d.pdf
 double phi = y0*3600.0;
 double lamda = x0*3600.0;
 double phistrich = (phi-169028.66)/1e4;
 double lamdastrich = (lamda-26782.5)/1e4;
 //printf("phistrich=%f\n",phistrich);//test
 //printf("lamdastrich=%f\n",lamdastrich);//test
 double phis2=phistrich*phistrich;
 double phis3=phis2*phistrich;
 double lamdas2=lamdastrich*lamdastrich;
 double lamdas3=lamdas2*lamdastrich;
 x1 = 2600072.37
     + 211455.93*lamdastrich
     - 10938.51 *lamdastrich*phistrich
     - 0.36*lamdastrich*phis2
     - 44.54*lamdas3;
 y1 = 1200147.07
     + 308807.95 * phistrich
     +   3745.25 * lamdas2
     +     76.63 * phis2
     -    194.56 * lamdas2*phistrich
     +    119.79 * phis3;
 //Umrechnung zwischen Ellisodischer Hoehe und Hoehe ueber Meer:
 //hch = hwgs - 49.55 + 2.73*lamdastrich - 6.94*phistrich;
}

void swiss2wgs(double x0,double y0,double& x1,double& y1) //x=Westlich y=Noerdlich
{
 double ys = (x0-2.6e6)/1e6; //x und y im PDF-Dokument vertauscht
 double xs = (y0-1.2e6)/1e6;
 //printf("ys=%f\n",ys);//test
 //printf("xs=%f\n",xs);//test
 double xs2=xs*xs, xs3=xs2*xs;
 double ys2=ys*ys, ys3=ys2*ys;
 double ls,ps; //lamdastrich, phistrich
 ls =  2.6779094
     + 4.728982 * ys
     + 0.791484 * ys*xs
     + 0.1306   * ys*xs2
     - 0.0436   * ys3;
 ps = 16.9023892
     + 3.238272 * xs
     - 0.270978 * ys2
     - 0.002528 * xs2
     - 0.0447   * ys2*xs
     - 0.0140   * xs3;
 double f=100.0/36.0;
 x1 = ls*f;
 y1 = ps*f;
 //Umrechnung zwischen Ellisodischer Hoehe und Hoehe ueber Meer:
 //hwgs = hch + 49.55 - 12.60*ys - 22.64*xs;
}

void wgs2swiss(double& x,double& y)
{
 double x1,y1;
 wgs2swiss(x,y,x1,y1);
 x = x1-2.6e6;
 y = y1-1.2e6;
}

void wgs2swiss(float& x,float& y)
{
 double x0=(double)x, y0=(double)y, x1,y1;
 wgs2swiss(x0,y0,x1,y1);
 x = x1-2.6e6;
 y = y1-1.2e6;
}

void swiss2wgs(float& x,float& y)
{
 double x0=(double)x+2.6e6, y0=(double)y+1.2e6, x1,y1;
 swiss2wgs(x0,y0,x1,y1);
 x = x1;
 y = y1;
}

/************************** Hauptteil **************************/	
bool csvok(const char *name)
{
 FILE *fp=fopen(name,"r");
 if(fp==NULL) return false;
 char zeile[400];
 bool status = (getline(fp,zeile,400) && strncmp(zeile,"http",4)==0);
 fclose(fp);
 return status;
}

int get_kartennummer(float Gxmin,float Gxmax,float Gymin,float Gymax);

int karte_download(float Gxmin,float Gxmax,float Gymin,float Gymax,char *kartenname,int max)
{ //Rueckgabewert: Kartennummer
#ifdef _DEBUG
 printf("karte_download(%f,%f,%f,%f,kartenname,%d)\n",Gxmin,Gxmax,Gymin,Gymax,max);//test
#endif
 int kartennummer = (Gxmin==0) ? (int)(Gxmax) : get_kartennummer(Gxmin,Gxmax,Gymin,Gymax);
 if(kartennummer==0) {fprintf(stderr,"Fehler: keine Karte gefunden\n"); return 0;}//test
 const char *csvname10="kartenliste10.csv";
 const char *csvname25="kartenliste.csv";
 const char *csvname50="kartenliste50.csv";
 const char *csvname100="kartenliste100.csv";
 const char *csvname200="kartenliste200.csv";
 const char *csvname=csvname25;
 if   (kartennummer > 200000) {printf("Fehler: kartennummer=%d\n",kartennummer);}//test
 else if(kartennummer>100000) csvname=csvname100;
 else if(kartennummer>50000) csvname=csvname50;
 else if(kartennummer>10000) csvname=csvname10;
 else if(kartennummer<100) csvname=csvname200;
 if(!csvok(csvname))
  {
   char listenname[400];
   fprintf(stderr,"Fehler: konnte %s nicht automatisch downloaden,\n",csvname);
   fprintf(stderr,"bitte im Browser von Hand aktuelle Kartenliste herunterladen:\n");
   fprintf(stderr,"Auswahlmodus \"Ganzer Datensatz\", dann \"Alle Links exportieren\"\n");
   if(kartennummer>100000) system("firefox https://www.swisstopo.admin.ch/de/geodata/maps/smr/smr100.html");//test
   else if(kartennummer>50000) system("firefox https://www.swisstopo.admin.ch/de/geodata/maps/smr/smr50.html");//test
   else if(kartennummer>10000) system("firefox https://www.swisstopo.admin.ch/de/geodata/maps/smr/smr10.html");//test
   else if(kartennummer<100) system("firefox https://www.swisstopo.admin.ch/de/geodata/maps/smr/smr200.html");//test
   else                 system("firefox https://www.swisstopo.admin.ch/de/geodata/maps/smr/smr25.html");//test
   printf("heruntergeladene Kartenliste samt Pfad: "); scanf("%s",listenname);
   filecopy(listenname,csvname);
  }
 if(!csvok(csvname))
  {printf("Fehler: konnte %s nicht downloaden.\n",csvname); return 0;}
 FILE *fp=fopen(csvname,"r");
 char zeile[400],nummerstring[16];
 if(kartennummer<100) //1:200'000 Karte
  sprintf(nummerstring,"_%02d_",kartennummer);
 else if(kartennummer>100000) //1:100'000 Karte
  sprintf(nummerstring,"_%02d_", kartennummer%100);
 else if(kartennummer>50000) //1:50'000 Karte
  sprintf(nummerstring,"_%03d_", kartennummer%1000);
 else if(kartennummer>10000) //1:10'000 Karte
  sprintf(nummerstring,"_%04d-%d_", kartennummer%10000, kartennummer/10000);
 else sprintf(nummerstring,"_%04d_",kartennummer); //1:25'000 Karte bei 4-stelliger Nummer
 while(getline(fp,zeile,400))
  {
   if(strstr(zeile,nummerstring)!=NULL)
    {
     mystrncpy(kartenname,zeile,400);
     break;
    }
  }
 fclose(fp);
#ifdef _DEBUG
 printf("Downloadname = \"%s\"\n",kartenname);
#endif
 char tifname[80],jpgname[80];
 sprintf(tifname,"%skarte%d.tif",KARTENPFAD,kartennummer);
 sprintf(jpgname,"%skarte%d.jpg",KARTENPFAD,kartennummer);
 if(vorhanden(jpgname))
  {
   static int test=12;//test
   if(test!=0) {printf("%s schon vorhanden\n",jpgname); --test;}//test
  }
 else
  {
   if(vorhanden(tifname)) printf("%s schon vorhanden\n",tifname);//test
   else
    {
     printf("kartenname=%s tifname=%s\n",kartenname,tifname);//test
     printf("starte Download von Karte ...\n"); //test
     int err=https_get(kartenname,tifname);
     if(err) {printf("Fehler: https_get() --> err=%d\n",err); return 0;}//test
    }
   printf("converting %s to %s ...\n",tifname,jpgname);//test
   // 1:10'000 Karten haben 17500x12000 Pixel, 1:25'000 und meiste andern 14000x9600
   // auf Laptop ist 17500x12000 offenbar zu gross, Verkleinern auf 14000x9600 oder um 50% //TODO
   bool ok=convert_tif_to_jpg(tifname, kartennummer>10000 && kartennummer<50000);
   if(ok) unlink(tifname);
  }
 strcpy(kartenname,jpgname);
 return kartennummer;
}

int karte_download(int nr,char *kartenname,int max)
{
 float nummer=nr;
 return karte_download(0,nummer,0,0,kartenname,max);
}

struct Karteneckpunkte
{
 int nummer;
 double x1,y1; //Links unten
 double x2,y2; //Rechts oben
};

Karteneckpunkte eckpunktliste[] = {
 {1011, 2672500, 1290000, 2690000, 1302000},
 {1012, 2690000, 1290000, 2707500, 1302000},

 {1031, 2672500, 1278000, 2690000, 1290000},
 {1032, 0, 0, 0, 0},
 {1033, 0, 0, 0, 0},
 {1034, 0, 0, 0, 0},
 {1047, 2602500, 1266000, 2620000, 1278000},
 {1048, 0, 0, 0, 0},
 {1049, 0, 0, 0, 0},
 {1050, 0, 0, 0, 0},
 {1051, 0, 0, 0, 0},
 {1052, 0, 0, 0, 0},
 {1053, 0, 0, 0, 0},
 {1054, 0, 0, 0, 0},
 {1055, 0, 0, 0, 0},
 {1064, 2550000, 1254000, 2567500, 1266000},
 {1065, 0, 0, 0, 0}, {1066, 0, 0, 0, 0}, {1067, 0, 0, 0, 0}, {1068, 0, 0, 0, 0}, {1069, 0, 0, 0, 0},
 {1070, 0, 0, 0, 0}, {1071, 0, 0, 0, 0}, {1072, 0, 0, 0, 0}, {1073, 0, 0, 0, 0}, {1074, 0, 0, 0, 0},
 {1075, 0, 0, 0, 0}, {1076, 0, 0, 0, 0},
 {1084, 2550000, 1242000, 2567500, 1254000},
 {1085, 0, 0, 0, 0}, {1086, 0, 0, 0, 0}, {1087, 0, 0, 0, 0}, {1088, 0, 0, 0, 0}, {1089, 0, 0, 0, 0},
 {1090, 0, 0, 0, 0}, {1091, 0, 0, 0, 0}, {1092, 0, 0, 0, 0}, {1093, 0, 0, 0, 0}, {1094, 0, 0, 0, 0},
 {1095, 0, 0, 0, 0}, {1096, 0, 0, 0, 0},
 {1104, 2550000, 1230000, 2567500, 1242000},
 {1105, 0, 0, 0, 0}, {1106, 0, 0, 0, 0}, {1107, 0, 0, 0, 0}, {1108, 0, 0, 0, 0}, {1109, 0, 0, 0, 0},
 {1110, 0, 0, 0, 0}, {1111, 0, 0, 0, 0}, {1112, 0, 0, 0, 0}, {1113, 0, 0, 0, 0}, {1114, 0, 0, 0, 0},
 {1115, 0, 0, 0, 0}, {1116, 0, 0, 0, 0},
 {1123, 2532500, 1218000, 2550000, 1230000},
 {1124, 0, 0, 0, 0}, {1125, 0, 0, 0, 0}, {1126, 0, 0, 0, 0}, {1127, 0, 0, 0, 0}, {1128, 0, 0, 0, 0},
 {1129, 0, 0, 0, 0}, {1130, 0, 0, 0, 0}, {1131, 0, 0, 0, 0}, {1132, 0, 0, 0, 0}, {1133, 0, 0, 0, 0},
 {1134, 0, 0, 0, 0}, {1135, 0, 0, 0, 0}, {1136, 0, 0, 0, 0},
 {1143, 2532500, 1206000, 2550000, 1218000},
 {1144, 0, 0, 0, 0}, {1145, 0, 0, 0, 0}, {1146, 0, 0, 0, 0}, {1147, 0, 0, 0, 0}, {1148, 0, 0, 0, 0},
 {1149, 0, 0, 0, 0}, {1150, 0, 0, 0, 0}, {1151, 0, 0, 0, 0}, {1152, 0, 0, 0, 0}, {1153, 0, 0, 0, 0},
 {1154, 0, 0, 0, 0}, {1155, 0, 0, 0, 0}, {1156, 0, 0, 0, 0}, {1157, 0, 0, 0, 0},
 {1159, 2812500, 1206000, 2830000, 1218000},
 {1162, 2515000, 1194000, 2532500, 1206000},
 {1163, 0, 0, 0, 0}, {1164, 0, 0, 0, 0}, {1165, 0, 0, 0, 0}, {1166, 0, 0, 0, 0}, {1167, 0, 0, 0, 0},
 {1168, 0, 0, 0, 0}, {1169, 0, 0, 0, 0}, {1170, 0, 0, 0, 0}, {1171, 0, 0, 0, 0}, {1172, 0, 0, 0, 0},
 {1173, 0, 0, 0, 0}, {1174, 0, 0, 0, 0}, {1175, 0, 0, 0, 0}, {1176, 0, 0, 0, 0}, {1177, 0, 0, 0, 0},
 {1178, 0, 0, 0, 0}, {1179, 0, 0, 0, 0},
 {1182, 2515000, 1182000, 2532500, 1194000},
 {1183, 0, 0, 0, 0}, {1184, 0, 0, 0, 0}, {1185, 0, 0, 0, 0}, {1186, 0, 0, 0, 0}, {1187, 0, 0, 0, 0},
 {1188, 0, 0, 0, 0}, {1189, 0, 0, 0, 0}, {1190, 0, 0, 0, 0}, {1191, 0, 0, 0, 0}, {1192, 0, 0, 0, 0},
 {1193, 0, 0, 0, 0}, {1194, 0, 0, 0, 0}, {1195, 0, 0, 0, 0}, {1196, 0, 0, 0, 0}, {1197, 0, 0, 0, 0},
 {1198, 0, 0, 0, 0},
 {1199, 2812500, 1182500, 2830000, 1194000}, //Ausnahme ? x2 ueberprueft: ok
 //{1199bis?, 2830000, 1182500, 2847500, 1194000},
 {1201, 2497500, 1170000, 2515000, 1182000},
 {1202, 0, 0, 0, 0}, {1203, 0, 0, 0, 0}, {1204, 0, 0, 0, 0}, {1205, 0, 0, 0, 0}, {1206, 0, 0, 0, 0},
 {1207, 0, 0, 0, 0}, {1208, 0, 0, 0, 0}, {1209, 0, 0, 0, 0}, {1210, 0, 0, 0, 0}, {1211, 0, 0, 0, 0},
 {1212, 0, 0, 0, 0}, {1213, 0, 0, 0, 0}, {1214, 0, 0, 0, 0}, {1215, 0, 0, 0, 0}, {1216, 0, 0, 0, 0},
 {1217, 0, 0, 0, 0}, {1218, 0, 0, 0, 0}, {1219, 0, 0, 0, 0},
 //{1219bis?, 0, 0, 0, 0},
 {1221, 2497500, 1158000, 2515000, 1170000},
 {1222, 0, 0, 0, 0}, {1223, 0, 0, 0, 0}, {1224, 0, 0, 0, 0}, {1225, 0, 0, 0, 0}, {1226, 0, 0, 0, 0},
 {1227, 0, 0, 0, 0}, {1228, 0, 0, 0, 0}, {1229, 0, 0, 0, 0}, {1230, 0, 0, 0, 0}, {1231, 0, 0, 0, 0},
 {1232, 0, 0, 0, 0}, {1233, 0, 0, 0, 0}, {1234, 0, 0, 0, 0}, {1235, 0, 0, 0, 0}, {1236, 0, 0, 0, 0},
 {1237, 0, 0, 0, 0}, {1238, 0, 0, 0, 0}, {1239, 0, 0, 0, 0},
 //{1239bis?, 0, 0, 0, 0},
 {1240, 2480000, 1146000, 2497500, 1158000},
 {1241, 0, 0, 0, 0}, {1242, 0, 0, 0, 0}, {1243, 0, 0, 0, 0}, {1244, 0, 0, 0, 0}, {1245, 0, 0, 0, 0},
 {1246, 0, 0, 0, 0}, {1247, 0, 0, 0, 0}, {1248, 0, 0, 0, 0}, {1249, 0, 0, 0, 0}, {1250, 0, 0, 0, 0},
 {1251, 0, 0, 0, 0}, {1252, 0, 0, 0, 0}, {1253, 0, 0, 0, 0}, {1254, 0, 0, 0, 0}, {1255, 0, 0, 0, 0},
 {1256, 0, 0, 0, 0}, {1257, 0, 0, 0, 0}, {1258, 0, 0, 0, 0},
 {1260, 2480000, 1134000, 2497500, 1146000},
 {1261, 0, 0, 0, 0}, {1262, 0, 0, 0, 0}, {1263, 0, 0, 0, 0}, {1264, 0, 0, 0, 0}, {1265, 0, 0, 0, 0},
 {1266, 0, 0, 0, 0}, {1267, 0, 0, 0, 0}, {1268, 0, 0, 0, 0}, {1269, 0, 0, 0, 0}, {1270, 0, 0, 0, 0},
 {1271, 0, 0, 0, 0}, {1272, 0, 0, 0, 0}, {1273, 0, 0, 0, 0}, {1274, 0, 0, 0, 0}, {1275, 0, 0, 0, 0},
 {1276, 0, 0, 0, 0}, {1277, 0, 0, 0, 0}, {1278, 0, 0, 0, 0},
 {1280, 2480000, 1122000, 2497500, 1134000},
 {1281, 0, 0, 0, 0},
 {1284, 2550000, 1122000, 2567500, 1134000}, //TODO: Ausnahme ?: x1 ist vielleicht kleiner?
 {1285, 2567500, 1122000, 2585000, 1134000},
 {1286, 0, 0, 0, 0}, {1287, 0, 0, 0, 0}, {1288, 0, 0, 0, 0}, {1289, 0, 0, 0, 0}, {1290, 0, 0, 0, 0},
 {1291, 0, 0, 0, 0}, {1292, 0, 0, 0, 0}, {1293, 0, 0, 0, 0}, {1294, 0, 0, 0, 0},
 {1296, 2760000, 1122000, 2777500, 1134000},
 {1298, 2795000, 1122000, 2812500, 1134000},
 {1300, 2480000, 1110000, 2497500, 1122000},
 {1301, 0, 0, 0, 0},
 {1304, 2550000, 1110000, 2567500, 1122000},
 {1305, 0, 0, 0, 0}, {1306, 0, 0, 0, 0}, {1307, 0, 0, 0, 0}, {1308, 0, 0, 0, 0},
 {1309, 2637500, 1110000, 2655000, 1122000}, //TODO: Ausnahme: x2 ist vielleicht groesser?
 {1311, 2672500, 1110000, 2690000, 1122000},
 {1312, 0, 0, 0, 0}, {1313, 0, 0, 0, 0}, {1314, 0, 0, 0, 0},
 {1324, 2550000, 1098000, 2567500, 1110000},
 {1325, 0, 0, 0, 0}, {1326, 0, 0, 0, 0}, {1327, 0, 0, 0, 0}, {1328, 0, 0, 0, 0}, {1329, 0, 0, 0, 0},
 {1332, 2690000, 1098000, 2707500, 1110000},
 {1333, 0, 0, 0, 0}, {1334, 0, 0, 0, 0},
 {1344, 2550000, 1086000, 2567500, 1098000},
 {1345, 0, 0, 0, 0}, {1346, 0, 0, 0, 0}, {1347, 0, 0, 0, 0}, {1348, 0, 0, 0, 0}, {1349, 0, 0, 0, 0},
 {1352, 2690000, 1086000, 2707500, 1098000},
 {1353, 0, 0, 0, 0},
 {1365, 2567500, 1074000, 2585000, 1086000},
 {1366, 0, 0, 0, 0},
 {1373, 2707500, 1074000, 2725000, 1086000},
 {1374, 0, 0, 0, 0}
};

void eckpunktliste_init()
{
 const double dx=17500, dy=12000;
 int np=sizeof(eckpunktliste)/sizeof(Karteneckpunkte);
#ifdef _DEBUG
 printf("Anzahl Kartennummern: np=%d\n",np);//test
#endif
 for(int i=1;i<np;i++)
  {
   if(eckpunktliste[i].x1==0)
    {
     int j=i-1;
     eckpunktliste[i].x1 = eckpunktliste[j].x1 + dx;
     eckpunktliste[i].x2 = eckpunktliste[j].x2 + dx;
     eckpunktliste[i].y1 = eckpunktliste[j].y1;
     eckpunktliste[i].y2 = eckpunktliste[j].y2;
     if(eckpunktliste[i].y2 - eckpunktliste[i].y1 != dy)
      {printf("Fehler: in Karte %d stimmt dy nicht: %lf statt %lf\n",
	      eckpunktliste[i].nummer, eckpunktliste[i].y2 - eckpunktliste[i].y1, dy);
      }
    }
  }
}

Karteneckpunkte eckpunktliste10[4*sizeof(eckpunktliste)/sizeof(Karteneckpunkte)];

void eckpunktliste10_init()
{
 const double dx=17500/2, dy=12000/2;
 int np=sizeof(eckpunktliste)/sizeof(Karteneckpunkte);
 for(int i=0,j=0;i<np;i++)
  {
   Karteneckpunkte eckpunkt=eckpunktliste[i];
   //Beispiel: eckpunktliste[0] = {1011, 2672500, 1290000, 2690000, 1302000}
   eckpunkt.nummer += 10000;
   eckpunkt.x2=eckpunkt.x1+dx;
   eckpunkt.y2=eckpunkt.y1+dy;
   eckpunkt.y1 += dy; eckpunkt.y2 += dy;
   eckpunktliste10[j++] = eckpunkt;
   eckpunkt.nummer += 10000;
   eckpunkt.x1 += dx; eckpunkt.x2 += dx;
   eckpunktliste10[j++] = eckpunkt;
   eckpunkt.nummer += 10000;
   eckpunkt.x1 -= dx; eckpunkt.x2 -= dx;
   eckpunkt.y1 -= dy; eckpunkt.y2 -= dy;
   eckpunktliste10[j++] = eckpunkt;
   eckpunkt.nummer += 10000;
   eckpunkt.x1 += dx; eckpunkt.x2 += dx;
   eckpunktliste10[j++] = eckpunkt;
  }
}

Karteneckpunkte eckpunktliste50[] = {
 // dx=35000  dy=24000
 // Anordnung:         205 206 207
 //        212 213 214 215 216 217 218
 //        222 223 224 225 226 227 228
 //    231 232 ....................... 239
 //    241 242 ....................... 249 350
 //250 251 252 ....................... 259 360
 //260 261 262 ....................... 269 370
 //270 271 272 ....................... 279
 //280     282 ............... 287
 //        292 293 294     296 297
 {50205, 2655000, 1278000, 2690000, 1302000}, {50206, 2690000, 1278000, 2725000, 1302000},
 {50207, 2725000, 1278000, 2760000, 1302000},
 
 {50212, 2550000, 1254000, 2585000, 1278000}, {50213, 2585000, 1254000, 2620000, 1278000},
 {50214, 2620000, 1254000, 2655000, 1278000}, {50215, 2655000, 1254000, 2690000, 1278000},
 {50216, 2690000, 1254000, 2725000, 1278000}, {50217, 2725000, 1254000, 2760000, 1278000},
 {50218, 2760000, 1254000, 2795000, 1278000},
 
 {50222, 2550000, 1230000, 2585000, 1254000}, {50223, 2585000, 1230000, 2620000, 1254000},
 {50224, 2620000, 1230000, 2655000, 1254000}, {50225, 2655000, 1230000, 2690000, 1254000},
 {50226, 2690000, 1230000, 2725000, 1254000}, {50227, 2725000, 1230000, 2760000, 1254000},
 {50228, 2760000, 1230000, 2795000, 1254000},
 
 {50231, 2515000, 1206000, 2550000, 1230000}, {50232, 2550000, 1206000, 2585000, 1230000},
 {50233, 2585000, 1206000, 2620000, 1230000}, {50234, 2620000, 1206000, 2655000, 1230000},
 {50235, 2655000, 1206000, 2690000, 1230000}, {50236, 2690000, 1206000, 2725000, 1230000},
 {50237, 2725000, 1206000, 2760000, 1230000}, {50238, 2760000, 1206000, 2795000, 1230000},
 {50239, 2795000, 1206000, 2830000, 1230000},
 
 {50241, 2515000, 1182000, 2550000, 1206000}, {50242, 2550000, 1182000, 2585000, 1206000},
 {50243, 2585000, 1182000, 2620000, 1206000}, {50244, 2620000, 1182000, 2655000, 1206000},
 {50245, 2655000, 1182000, 2690000, 1206000}, {50246, 2690000, 1182000, 2725000, 1206000},
 {50247, 2725000, 1182000, 2760000, 1206000}, {50248, 2760000, 1182000, 2795000, 1206000},
 {50249, 2795000, 1182000, 2830000, 1206000}, {50350, 2830000, 1182000, 2865000, 1206000},

 {50250, 2480000, 1158000, 2515000, 1182000},
 {50251, 2515000, 1158000, 2550000, 1182000}, {50252, 2555000, 1158000, 2585000, 1182000},
 {50253, 2585000, 1158000, 2620000, 1182000}, {50254, 2620000, 1158000, 2655000, 1182000},
 {50255, 2655000, 1158000, 2690000, 1182000}, {50256, 2690000, 1158000, 2725000, 1182000},
 {50257, 2725000, 1158000, 2760000, 1182000}, {50258, 2760000, 1158000, 2795000, 1182000},
 {50259, 2795000, 1158000, 2830000, 1182000}, {50360, 2830000, 1158000, 2865000, 1182000},
 
 {50260, 2480000, 1134000, 2515000, 1158000},
 {50261, 2515000, 1134000, 2550000, 1158000}, {50262, 2555000, 1134000, 2585000, 1158000},
 {50263, 2585000, 1134000, 2620000, 1158000}, {50264, 2620000, 1134000, 2655000, 1158000},
 {50265, 2655000, 1134000, 2690000, 1158000}, {50266, 2690000, 1134000, 2725000, 1158000},
 {50267, 2725000, 1134000, 2760000, 1158000}, {50268, 2760000, 1134000, 2795000, 1158000},
 {50269, 2795000, 1134000, 2830000, 1158000}, {50370, 2830000, 1134000, 2865000, 1158000},
 
 {50270, 2480000, 1110000, 2515000, 1134000},
 {50271, 2515000, 1110000, 2550000, 1134000}, {50272, 2555000, 1110000, 2585000, 1134000},
 {50273, 2585000, 1110000, 2620000, 1134000}, {50274, 2620000, 1110000, 2655000, 1134000},
 {50275, 2655000, 1110000, 2690000, 1134000}, {50276, 2690000, 1110000, 2725000, 1134000},
 {50277, 2725000, 1110000, 2760000, 1134000}, {50278, 2760000, 1110000, 2795000, 1134000},
 {50279, 2795000, 1110000, 2830000, 1134000},

 {50280, 2480000, 1086000, 2515000, 1110000}, {50282, 2550000, 1086000, 2585000, 1110000},
 {50283, 2585000, 1086000, 2620000, 1110000}, {50284, 2620000, 1086000, 2655000, 1110000},
 {50285, 2655000, 1086000, 2690000, 1110000}, {50286, 2690000, 1086000, 2725000, 1110000},
 {50287, 2725000, 1086000, 2760000, 1110000},
 
 {50292, 2550000, 1062000, 2585000, 1086000},
 {50293, 2585000, 1062000, 2620000, 1086000},
 {50294, 2620000, 1062000, 2655000, 1086000},
 {50296, 2690000, 1062000, 2725000, 1086000},
 {50297, 2725000, 1062000, 2760000, 1086000}
};

Karteneckpunkte eckpunktliste100[] = {
 // dx=70000  dy=48000
 // Anordnung: -- 26 27 28 29
 //            30 31 32 33 34
 //            35 36 37 38 39 80
 //            40 41 42 43 44 85
 //            45 46 47 48
 {100026, 2550000, 1254000, 2620000, 1302000},
 {100027, 2620000, 1254000, 2690000, 1302000},
 {100028, 2690000, 1254000, 2760000, 1302000},
 {100029, 2760000, 1254000, 2830000, 1302000},
 {100030, 2480000, 1206000, 2550000, 1254000},
 {100031, 2550000, 1206000, 2620000, 1254000},
 {100032, 2620000, 1206000, 2690000, 1254000},
 {100033, 2690000, 1206000, 2760000, 1254000},
 {100034, 2760000, 1206000, 2830000, 1254000},
 {100035, 2480000, 1158000, 2550000, 1206000},
 {100036, 2550000, 1158000, 2620000, 1206000},
 {100037, 2620000, 1158000, 2690000, 1206000},
 {100038, 2690000, 1158000, 2760000, 1206000},
 {100039, 2760000, 1158000, 2830000, 1206000},
 {100080, 2830000, 1158000, 2900000, 1206000},
 {100040, 2480000, 1110000, 2550000, 1158000},
 {100041, 2550000, 1110000, 2620000, 1158000},
 {100042, 2620000, 1110000, 2690000, 1158000},
 {100043, 2690000, 1110000, 2760000, 1158000},
 {100044, 2760000, 1110000, 2830000, 1158000},
 {100085, 2830000, 1110000, 2900000, 1158000},
 {100045, 2480000, 1062000, 2550000, 1110000},
 {100046, 2550000, 1062000, 2620000, 1110000},
 {100047, 2620000, 1062000, 2690000, 1110000},
 {100048, 2690000, 1062000, 2760000, 1110000}
};

Karteneckpunkte eckpunktliste200[] = {
 // dx=113000  dy=79000
 // Anordnung: 11 12 21 22
 //            13 14 24 24
 //            31 32 41 42
 //            33 34 43 44
 {11, 2443000, 1261000, 2556000, 1340000},
 {12, 2556000, 1261000, 2669000, 1340000},
 {21, 2669000, 1261000, 2782000, 1340000},
 {22, 2782000, 1261000, 2895000, 1340000},
 {13, 2443000, 1182000, 2556000, 1261000},
 {14, 2556000, 1182000, 2669000, 1261000},
 {23, 2669000, 1182000, 2782000, 1261000},
 {24, 2782000, 1182000, 2895000, 1261000},
 {31, 2443000, 1103000, 2556000, 1182000},
 {32, 2556000, 1103000, 2669000, 1182000},
 {41, 2669000, 1103000, 2782000, 1182000},
 {42, 2782000, 1103000, 2895000, 1182000},
 {33, 2443000, 1024000, 2556000, 1103000},
 {34, 2556000, 1024000, 2669000, 1103000},
 {43, 2669000, 1024000, 2782000, 1103000},
 {44, 2782000, 1024000, 2895000, 1103000}
};

static int eckpunktlisten_initflag=1;
void eckpunktlisten_init()
{
 eckpunktliste_init(); eckpunktliste10_init();
 eckpunktlisten_initflag=0;
}

int get_kartennummer(float Gxmin,float Gxmax,float Gymin,float Gymax)
{
 double x1,y1,x2,y2;
 wgs2swiss(Gxmin, Gymin, x1, y1);
 wgs2swiss(Gxmax, Gymax, x2, y2);
#ifdef _DEBUG
 printf("get_kartennummer() -> x1=%lf y1=%lf  x2=%lf y2=%lf\n",x1,y1,x2,y2);//test
#endif
 /* test rueckrechnung * /
 {
  printf("Startwerte: Gxmin=%lf Gymin=%lf  Gxmax=%lf Gymax=%lf\n",Gxmin,Gymin,Gxmax,Gymax);
  double rgxmin,rgxmax,rgymin,rgymax;
  swiss2wgs(x1, y1, rgxmin, rgymin);
  swiss2wgs(x2, y2, rgxmax, rgymax);
  printf("Rueckrechnung: xmin=%lf ymin=%lf  xmax=%lf ymax=%lf\n",rgxmin,rgymin,rgxmax,rgymax);
 }
 / * test */
 if(eckpunktlisten_initflag) eckpunktlisten_init();
 int np;
 Karteneckpunkte *ep;
 if(qflag<25)
  {
   np=sizeof(eckpunktliste10)/sizeof(Karteneckpunkte); ep=eckpunktliste10;
   for(int i=0;i<np;i++)
    {
     if(x1 >= ep[i].x1 && x1 <= ep[i].x2 && x2 >= ep[i].x1 && x2 <= ep[i].x2 &&
	y1 >= ep[i].y1 && y1 <= ep[i].y2 && y2 >= ep[i].y1 && y2 <= ep[i].y2)
      {
       //printf("kartennummer in eckpunktliste10 gefunden: %d\n",ep[i].nummer);//test
       return ep[i].nummer;//gefunden
      }
    }
  }
 if(qflag<50)
  {
   np=sizeof(eckpunktliste)/sizeof(Karteneckpunkte); ep=eckpunktliste;
   for(int i=0;i<np;i++)
    {
     if(x1 >= ep[i].x1 && x1 <= ep[i].x2 && x2 >= ep[i].x1 && x2 <= ep[i].x2 &&
	y1 >= ep[i].y1 && y1 <= ep[i].y2 && y2 >= ep[i].y1 && y2 <= ep[i].y2)
      return ep[i].nummer;//gefunden
    }
  }
 if(qflag<100)
  {
   np=sizeof(eckpunktliste50)/sizeof(Karteneckpunkte); ep=eckpunktliste50;
   for(int i=0;i<np;i++)
    {
     if(x1 >= ep[i].x1 && x1 <= ep[i].x2 && x2 >= ep[i].x1 && x2 <= ep[i].x2 &&
	y1 >= ep[i].y1 && y1 <= ep[i].y2 && y2 >= ep[i].y1 && y2 <= ep[i].y2)
      return ep[i].nummer;//gefunden
    }
  }
 if(qflag<200)
  {
   np=sizeof(eckpunktliste100)/sizeof(Karteneckpunkte); ep=eckpunktliste100;
   for(int i=0;i<np;i++)
    {
     if(x1 >= ep[i].x1 && x1 <= ep[i].x2 && x2 >= ep[i].x1 && x2 <= ep[i].x2 &&
	y1 >= ep[i].y1 && y1 <= ep[i].y2 && y2 >= ep[i].y1 && y2 <= ep[i].y2)
      return ep[i].nummer;//gefunden
    }
  }
 np=sizeof(eckpunktliste200)/sizeof(Karteneckpunkte); ep=eckpunktliste200;
 for(int i=0;i<np;i++)
  {
   if(x1 >= ep[i].x1 && x1 <= ep[i].x2 && x2 >= ep[i].x1 && x2 <= ep[i].x2 &&
      y1 >= ep[i].y1 && y1 <= ep[i].y2 && y2 >= ep[i].y1 && y2 <= ep[i].y2)
    return ep[i].nummer;//gefunden
  }
 return 0;//nicht gefunden
}

int eckpunktliste_get(int kartennummer,float& Kxmin,float& Kxmax,float& Kymin,float& Kymax)
{
 int ok=0, np=0;
 Karteneckpunkte* liste;
 if(eckpunktlisten_initflag) eckpunktlisten_init();
 if(kartennummer<100)
  {
   np=sizeof(eckpunktliste200)/sizeof(Karteneckpunkte);
   liste=eckpunktliste200;
  }
 else if(kartennummer>=100000)
  {
   np=sizeof(eckpunktliste100)/sizeof(Karteneckpunkte);
   liste=eckpunktliste100;
  }
 else if(kartennummer>=50000)
  {
   np=sizeof(eckpunktliste50)/sizeof(Karteneckpunkte);
   liste=eckpunktliste50;
  }
 else if(kartennummer>=10000)
  {
   np=sizeof(eckpunktliste10)/sizeof(Karteneckpunkte);
   liste=eckpunktliste10;
  }
 else
  {
   np=sizeof(eckpunktliste)/sizeof(Karteneckpunkte);
   liste=eckpunktliste;
  }
 for(int i=0;i<np;i++)
  {
   if(liste[i].nummer==kartennummer)
    {
     double rgxmin,rgxmax,rgymin,rgymax;
     swiss2wgs(liste[i].x1, liste[i].y1, rgxmin, rgymin);
     swiss2wgs(liste[i].x2, liste[i].y2, rgxmax, rgymax);
     Kxmin=(float)rgxmin;
     Kymin=(float)rgymin;
     Kxmax=(float)rgxmax;
     Kymax=(float)rgymax;
     return ok=1;
    }
  }
 return ok;
}

int eckpunktliste_get2(int kartennummer,int nummer2,float& Kxmin,float& Kxmax,float& Kymin,float& Kymax)
{
 int ok1=0,ok2=0,ok=0, np=0;
 Karteneckpunkte* liste;
 if(eckpunktlisten_initflag) eckpunktlisten_init();
 if(kartennummer<100)
  {
   np=sizeof(eckpunktliste200)/sizeof(Karteneckpunkte);
   liste=eckpunktliste200;
  }
 else if(kartennummer>=100000)
  {
   np=sizeof(eckpunktliste100)/sizeof(Karteneckpunkte);
   liste=eckpunktliste100;
  }
 else if(kartennummer>=50000)
  {
   np=sizeof(eckpunktliste50)/sizeof(Karteneckpunkte);
   liste=eckpunktliste50;
  }
 else if(kartennummer>=10000)
  {
   np=sizeof(eckpunktliste10)/sizeof(Karteneckpunkte);
   liste=eckpunktliste10;
  }
 else
  {
   np=sizeof(eckpunktliste)/sizeof(Karteneckpunkte);
   liste=eckpunktliste;
  }
 double xa1=0,xa2=0,ya1=0,ya2=0;
 double xb1=0,xb2=0,yb1=0,yb2=0;
 for(int i=0;i<np;i++)
  {
   if(liste[i].nummer==kartennummer)
    {
     xa1=liste[i].x1; ya1=liste[i].y1;
     xa2=liste[i].x2; ya2=liste[i].y2;
     ok1=1;
    }
   if(liste[i].nummer==nummer2)
    {
     xb1=liste[i].x1; yb1=liste[i].y1;
     xb2=liste[i].x2; yb2=liste[i].y2;
     ok2=1;
    }
  }
 if(ok1!=0 && ok2!=0)
  {
   double rgxmin,rgxmax,rgymin,rgymax;
   if(xb1<xa1) xa1=xb1;
   if(xb2>xa2) xa2=xb2;
   if(yb1<ya1) ya1=yb1;
   if(yb2>ya2) yb2=ya2;
   swiss2wgs(xa1, ya1, rgxmin, rgymin);
   swiss2wgs(xa2, ya2, rgxmax, rgymax);
   Kxmin=(float)rgxmin;
   Kymin=(float)rgymin;
   Kxmax=(float)rgxmax;
   Kymax=(float)rgymax;
   ok=1;
  }
 return ok;
}
