//leuchtturmlicht.h

#pragma once

//Pointlight:
glm::vec3 leuchtturmLightColor = glm::vec3(1.0f, 0.8f, 0.6f); //Farbe vom Punktlicht
int diffuseLocLeuchtturm;
int specularLocLeuchtturm;
int ambientLocLeuchtturm;

//Spotlight:
glm::vec3 leuchtturmSpotColor = glm::vec3(1.0f, 0.8f, 0.6f); //Farbe vom Spotlicht
//glm::vec3 leuchtturmSpotColor = glm::vec3(0.0f, 0.0f, 1.0f); //test: Blaues Spotlicht
glm::vec3 leuchtturmSpotPosition = glm::vec3(-94.0f, 10.0f, 94.0f); //Position Spotlicht
glm::vec4 leuchtturmSpotDirection = glm::vec4(-1.0f, 0.18f, 0.0f, 1.0f); //Richtungsvektor muss Normalisiert sein!
int positionLocLeuchtturm;
int directionLocLeuchtturm;
int diffuseSpotLeuchtturm;
int specularSpotLeuchtturm;
int ambientSpotLeuchtturm;

void normalizeVec4(glm::vec4 &v)
{
 v.w = 0.0f;
 v = glm::normalize(v);
 v.w = 1.0f;
}

void leuchtturm_init(GLuint shid)
{
 diffuseLocLeuchtturm = glGetUniformLocation(shid, "u_point_light.diffuse");
 specularLocLeuchtturm = glGetUniformLocation(shid, "u_point_light.specular");
 ambientLocLeuchtturm = glGetUniformLocation(shid, "u_point_light.ambient");
 GLCALL(glUniform1f(glGetUniformLocation(shid, "u_point_light.linear"), 0.027f));
 GLCALL(glUniform1f(glGetUniformLocation(shid, "u_point_light.quadratic"), 0.0028f));

 diffuseSpotLeuchtturm = glGetUniformLocation(shid, "u_spot_light2.diffuse");
 specularSpotLeuchtturm = glGetUniformLocation(shid, "u_spot_light2.specular");
 ambientSpotLeuchtturm = glGetUniformLocation(shid, "u_spot_light2.ambient");
 glm::vec3 spotLightColor = leuchtturmSpotColor * 0.25f; //TODO: Helligkeit vom Spotlicht
 GLCALL(glUniform3fv(diffuseSpotLeuchtturm, 1, (float*)&spotLightColor));
 GLCALL(glUniform3fv(specularSpotLeuchtturm, 1, (float*)&spotLightColor));
 spotLightColor *= 0.3f; //Helligkeit vom ambient-Anteil des Spotlichts
 GLCALL(glUniform3fv(ambientSpotLeuchtturm, 1, (float*)&spotLightColor));
 positionLocLeuchtturm = glGetUniformLocation(shid, "u_spot_light2.position");
 GLCALL(glUniform3fv(positionLocLeuchtturm, 1, (float*)&leuchtturmSpotPosition));
 directionLocLeuchtturm = glGetUniformLocation(shid, "u_spot_light2.direction");
 normalizeVec4(leuchtturmSpotDirection);
 GLCALL(glUniform3fv(directionLocLeuchtturm, 1, (float*)&leuchtturmSpotDirection));
 GLCALL(glUniform1f(glGetUniformLocation(shid, "u_spot_light2.innerCone"), 0.998f));
 GLCALL(glUniform1f(glGetUniformLocation(shid, "u_spot_light2.outerCone"), 0.985f));
}

void leuchtturm_helligkeit(float helligkeit,float spothelligkeit)
{
 glm::vec3 pointLightColor = leuchtturmLightColor * helligkeit;
 GLCALL(glUniform3fv(diffuseLocLeuchtturm, 1, (float*)&pointLightColor));
 GLCALL(glUniform3fv(specularLocLeuchtturm, 1, (float*)&pointLightColor));
 pointLightColor *= 0.2f;
 GLCALL(glUniform3fv(ambientLocLeuchtturm, 1, (float*)&pointLightColor));
 
 glm::vec3 spotLightColor = leuchtturmSpotColor * spothelligkeit;
 GLCALL(glUniform3fv(diffuseSpotLeuchtturm, 1, (float*)&spotLightColor));
 GLCALL(glUniform3fv(specularSpotLeuchtturm, 1, (float*)&spotLightColor));
 spotLightColor *= 0.3f;
 GLCALL(glUniform3fv(ambientSpotLeuchtturm, 1, (float*)&spotLightColor));
}
