#version 330 core

layout(location = 0) out vec4 f_color;

in vec3 v_normal;
in vec3 v_position;
in vec2 v_tex_coord;

struct Material {
 vec3 ambient; //Farbe bei Umgebungslicht
 vec3 diffuse; //Farbe von diffusen Oberflaechen
 vec3 specular; //Farbe von Reflexionen
 vec3 emissive; //selbst leuchtendes
 float shininess; //Staerke der Reflexion
 int texturflag;
};

struct DirectionalLight { //Richtungslicht, z.B. Sonne
 vec3 direction; //Richtung in die das Licht scheint
 vec3 diffuse;
 vec3 specular;
 vec3 ambient;
};

uniform Material u_material;
uniform float u_alpha=1.0f; //Durchsichtigkeit: 1.0=undurchsichtig, 0.0=voellig durchsichtig
uniform DirectionalLight u_directional_light;
uniform sampler2D u_diffuse_map;

void main()
{
 vec3 view = normalize(-v_position);
 vec3 normal = normalize(v_normal);

 //Textur:
 vec3 diffuseColor;
 vec3 ambientColor;
 if(u_material.texturflag != 0)
  {
   vec4 texColor4 = texture(u_diffuse_map, v_tex_coord);
   if(texColor4.w < 0.9) {discard;} //durchsichtige Pixel nicht zeichnen
   diffuseColor = u_material.diffuse * texColor4.xyz;
   ambientColor = u_material.ambient * diffuseColor;
   //diffuseColor = texColor4.xyz;//test
   //ambientColor = texColor4.xyz;//test
  }
 else if(u_material.ambient.x > u_material.diffuse.x ||
         u_material.ambient.y > u_material.diffuse.y ||
         u_material.ambient.z > u_material.diffuse.z) //test
  {
   diffuseColor = u_material.diffuse;
   ambientColor = u_material.ambient * u_material.diffuse;
  }
 else
  {
   diffuseColor = u_material.diffuse;
   ambientColor = u_material.ambient;
  }
 
 //Richtungslicht:
 vec3 light = normalize(-u_directional_light.direction); //Richtung aus der das Licht kommt
 vec3 reflection = reflect(u_directional_light.direction, normal);
 
 vec3 ambient = u_directional_light.ambient * ambientColor;
 vec3 diffuse = u_directional_light.diffuse * max(dot(normal, light), 0.0) * diffuseColor;
 
 vec3 specular = u_directional_light.specular * pow(max(dot(reflection, view), 0.0001), u_material.shininess) * u_material.specular;
 f_color = vec4(ambient + diffuse + specular + u_material.emissive, u_alpha);
}
