//texturen.h

//#include libs/stb_image.h //schon in main.cpp gemacht

class Textur {
public:
 GLuint id;
 uint32 num;
 char name[120];
};

std::vector<Textur> texturen;
uint32 numTexturen=0;

uint32 texturen_laden(const char *bildname)
{
 GLuint textureId=0;
 const char *neuname;
 if((neuname=myindex(bildname,'/'))!=NULL) bildname= &neuname[1];
 for(uint32 i=0;i<numTexturen;i++)
  {
   if(strcmp(bildname,texturen[i].name)==0)
    {
     textureId=texturen[i].id; texturen[i].num++;
#ifdef _DEBUG
     printf("Textur %s bisher %d mal verwendet\n",texturen[i].name,texturen[i].num);//test
#endif
     return textureId;
    }
  }
 int32 textureWidth = 0;
 int32 textureHeight = 0;
 int32 bitsPerPixel = 0;
 char namemitpfad[200];
 sprintf(namemitpfad,"karten/%s",bildname);
 stbi_set_flip_vertically_on_load(true);
 //auto textureBuffer = stbi_load(bildname, &textureWidth, &textureHeight, &bitsPerPixel, 4);
 unsigned char *textureBuffer = stbi_load(namemitpfad, &textureWidth, &textureHeight, &bitsPerPixel, 4);
 if(textureBuffer==NULL)
  {
   sprintf(namemitpfad,"texturen/%s",bildname);
   textureBuffer = stbi_load(namemitpfad, &textureWidth, &textureHeight, &bitsPerPixel, 4);
   if(textureBuffer==NULL)
    {
     printf("Error: stbi_load(%s, ...) cant load\n",bildname);
     return 0;
    }
  }
//#ifdef _DEBUG
 if(vflag!=0 && strncmp(bildname,"karte",5)==0) {//test
  printf("Textur %s eingelesen\n",bildname);//test
  for(int i=0;i<10;i++) printf(" %d",textureBuffer[i]);//test
  printf(" ...\n");//test
  printf(" textureWidth=%d textureHeight=%d bitsPerPixel=%d\n",textureWidth,textureHeight,bitsPerPixel);//test
 }//test
//#endif

 GLCALL(glGenTextures(1, &textureId));
 GLCALL(glBindTexture(GL_TEXTURE_2D, textureId));
 GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR));
 //GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)); //Pixeleffekt
 GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)); //Grosse Pixel interpoliert
 
 if(strncmp(bildname,"karte",5)==0)
  {
   GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE)); //am Rand der Textur abschneiden
   GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE));
  }
 else
  {
   GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_MIRRORED_REPEAT));
   GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_MIRRORED_REPEAT));
   //GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_R, GL_REPEAT)); //offenbar nicht gebraucht
  }
 GLCALL(glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, textureWidth, textureHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, textureBuffer));
 GLCALL(glBindTexture(GL_TEXTURE_2D, 0)); //unbind

 if(textureBuffer) {stbi_image_free(textureBuffer);}
 Textur te;
 te.id=textureId;
 te.num=1;
 mystrncpy(te.name,bildname,120);
 texturen.push_back(te);
 numTexturen++;
#ifdef _DEBUG
 printf("texturen_laden(%s)  textureId=%d\n",bildname,textureId);//test
#endif
 return textureId;
}

void texturen_freigeben()
{
 //GLCALL(glDeleteTextures(1, &textureId)); //TODO: mehrere Texturen freigeben
 for(uint32 i=0; i<texturen.size(); i++)
  {
   GLCALL(glDeleteTextures(1, &texturen[i].id));
  }
 texturen.clear();
}

class Kartentabelle
{
public:
 char name[120];
 float lonmin,latmin; //GPS-Koordinaten links unten (suedwesten)
 float lonmax,latmax; //GPS-Koordinaten rechts oben (nordosten)
 //lon entspricht x-Koordinate, lat entspricht -z-Koordinate)
};

#define ANZDEFAULTKARTEN 8
Kartentabelle defaultkartentabelle[ANZDEFAULTKARTEN]={
 "karte1.jpg",         8.59756, 47.35782, 8.62483, 47.37585,
 "karteadlisberg.jpg", 8.57338, 47.34042, 8.62836, 47.37670,
 "karteeinsiedeln25.jpg", 8.73017, 47.12265, 8.79877, 47.16788,
 "karteforch25.jpg",      8.60270, 47.32302, 8.67143, 47.36834,
 "kartealbishorn25.jpg",  8.50832, 47.23277, 8.57692, 47.27824,
 "karteuetliberg25.jpg",  8.46408, 47.32787, 8.53255, 47.37311,
 "karteraster10_1091-3.jpg", 8.39770, 47.32488, 8.51452, 47.377822, 
 "karteraster25_1091.jpg", 8.39770, 47.32488, 8.63158, 47.43064,
};
std::vector<Kartentabelle> kartentabelle;
int numKarten=0; //Anzahl Eintraege in kartentabelle
int kartenj=0;
float Kxmin=0, Kxmax=0, Kymin=0, Kymax=0;

//Vordeklaration von Funktionen in kartendownload.h:
int eckpunktliste_get(int kartennummer,float& Kxmin,float& Kxmax,float& Kymin,float& Kymax);
int eckpunktliste_get2(int kartennummer,int nummer2,float& Kxmin,float& Kxmax,float& Kymin,float& Kymax);

int vergleichen(const char *str1,const char *str2)
{ //wie strcmp() aber Ziffern alle als gleich ansehen.
  //Beispiel "karte1091.jpg" und "karte0000.jpg" ist gleich
 for(;;)
  {
   if(*str1==0 && *str2==0) return 0; //ok, gleich
   if(*str1==0 || *str2==0) return -1; //ungleich
   if(*str1 == *str2 || (isdigit(*str1) && isdigit(*str2)))
    {str1++; str2++;}
   else return -2; //ungleich
  }
 return 1;//wird nie erreicht
}

void swiss2wgs(double x0,double y0,double& x1,double& y1); //Vordeklaration zu kartendownload.h

uint32 karte_laden(const char *bildname,int knr=0)
{
 bildname = ohnepfad(bildname);
 if(numKarten==0 || knr>1)
  {
   char tabellenname[80];
   if(knr<2) strcpy(tabellenname,"kartentabelle.txt");
   else     sprintf(tabellenname,"kartentabelle%d.txt",knr);
   FILE *fp=fopen(tabellenname,"r");
   if(fp==NULL && knr<2)
    {
     printf("fehlende Datei kartentabelle.txt - Defaultwerte verwendet\n");
     for(int i=0;i<ANZDEFAULTKARTEN;i++)
      {
       kartentabelle.push_back(defaultkartentabelle[i]);
       numKarten++;
      }
    }
   else if(fp==NULL) {printf("Fehler: %s nicht gefunden\n",tabellenname);}//test
   else
    {
     char zeile[400];
     int n;
     while(getline(fp,zeile,400))
      {
       Kartentabelle neu;
       if(!isalpha(*zeile)) continue; //Kommentar ignorieren
       n=sscanf(zeile,"%s %f%*c%f%*c%f%*c%f",
	        neu.name, &neu.lonmin, &neu.latmin, &neu.lonmax, &neu.latmax);
       if(n!=5) {printf("Fehler: %s\n",zeile); continue;} //TODO: falsche Zeile
       if(neu.lonmin>2000)
	{
	 //Umrechnung von swiss nach GPX-Koordinaten:
	 double x0=neu.lonmin,y0=neu.latmin,x1,y1;
	 x0 *= 1000.0; y0 *= 1000.0;
	 swiss2wgs(x0,y0,x1,y1);
	 neu.lonmin=x1; neu.latmin=y1;
	 x0=neu.lonmax; y0=neu.latmax;
	 x0 *= 1000.0; y0 *= 1000.0;
	 swiss2wgs(x0,y0,x1,y1);
	 neu.lonmax=x1; neu.latmax=y1;
	}
       kartentabelle.push_back(neu);
       numKarten++;
      }
     fclose(fp);
    }
  }
 if(strcmp(bildname,"init")==0) return 0;
 for(kartenj=0;kartenj<numKarten;kartenj++)
  {if(strcmp(bildname,kartentabelle[kartenj].name)==0) break;}
 if(kartenj==numKarten)
  {
   if(vergleichen(bildname,"karte00000.jpg")==0 || //5-stellige Nummer fuer 1:10'000 Karten (und 1:50)
      vergleichen(bildname,"karte0000.jpg")==0 || //4-stellige Nummer fuer 1:25'000 Karten
      vergleichen(bildname,"karte000000.jpg")==0 || //6-stellige Nummer fuer 1:100'000 Karten
      vergleichen(bildname,"karte00.jpg")==0) //2-stellige Nummer fuer 1:200'000 Karten
    {
     int kartennummer=0;
     sscanf(&bildname[5],"%d",&kartennummer);
     if(kartennummer==0)
      {fprintf(stderr,"Fehler: sscanf(...,&kartennummer) misslungen\n"); return 0;}
     if(eckpunktliste_get(kartennummer,Kxmin,Kxmax,Kymin,Kymax)==0)
      {fprintf(stderr,"Fehler: eckpunktliste_get(%d, ...) misslungen\n",kartennummer); return 0;}
     return texturen_laden(bildname);
    }
   if(vergleichen(bildname,"karte00000000.jpg")==0) //8-stellige Nummer fuer zusammengesetzte 1:25'000 Karten
    {
     int kartennummer=0, nr2=0;
     sscanf(&bildname[5],"%d",&kartennummer);
     nr2 = kartennummer%10000;
     kartennummer /= 10000;
     if(kartennummer==0 || nr2==0)
      {fprintf(stderr,"Fehler2: sscanf(...,&kartennummer) misslungen\n"); return 0;}
     if(eckpunktliste_get2(kartennummer,nr2,Kxmin,Kxmax,Kymin,Kymax)==0)
      {fprintf(stderr,"Fehler2: eckpunktliste_get2(%d, ...) misslungen\n",nr2); return 0;}
     return texturen_laden(bildname);
    }
   printf("Fehler: fehlende Koordinaten fuer \"%s\" in kartentabelle.txt\n",bildname);
   return 0;
  }
#ifdef _DEBUG
 printf("karte_laden(%s) kartenj=%d\n",bildname,kartenj);//test
#endif
 Kxmin = kartentabelle[kartenj].lonmin;
 Kxmax = kartentabelle[kartenj].lonmax;
 Kymin = kartentabelle[kartenj].latmin;
 Kymax = kartentabelle[kartenj].latmax;
 return texturen_laden(bildname);
}
