//basic120.fs  zum alte Grafikkarten-Versionen unterstuetzen
#version 120

varying vec3 v_position;
varying vec3 v_normal;
//varying vec2 v_tex_coord;
//varying mat3 v_tb;

struct Material {
vec3 ambient; //Farbe bei Umgebungslicht
vec3 diffuse; //Farbe von diffusen Oberflaechen
vec3 specular; //Farbe von Reflexionen
vec3 emissive; //selbst leuchtendes
float shininess; //Staerke der Reflexion
};

struct DirectionalLight { //Richtungslicht, z.B. Sonne
 vec3 direction; //Richtung in die das Licht scheint
 vec3 diffuse;
 vec3 specular;
 vec3 ambient;
};

uniform  Material u_material;
uniform float u_alpha=1.0f; //Durchsichtigkeit: 1.0=undurchsichtig, 0.0=voellig durchsichtig
uniform DirectionalLight u_directional_light;

void main()
{
 vec3 view = normalize(-v_position);
 vec3 normal = normalize(v_normal);

 //Richtungslicht:
 vec3 light = normalize(-u_directional_light.direction); //Richtung aus der das Licht kommt
 vec3 reflection = reflect(u_directional_light.direction, normal);
 vec3 ambient = u_directional_light.ambient * u_material.ambient;
 vec3 diffuse = u_directional_light.diffuse * max(dot(normal, light), 0.0) * u_material.diffuse;
 vec3 specular = u_directional_light.specular * pow(max(dot(reflection, view), 0.0001), u_material.shininess) * u_material.specular;

 gl_FragColor = vec4(ambient + diffuse + specular + u_material.emissive, u_alpha);
}
