/** httpclient.cc **/
#define VERSION "1.02"
//#define DEBUG
#define APSERVER  //muss gleich gesetzt werden wie im Server (wifisens.ino)
                  //Wenn auskommentiert geht es uebers WLAN das zum Internet verbunden ist,
                  //sonst wird vom Controller ein eigenes WLAN aufgebaut (AP=AccessPoint)

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <string.h>
#include <netinet/in.h>
#include <netdb.h>

#ifdef APSERVER
const char *defaultaddress="192.168.4.1/Data";
#else
const char *defaultaddress="192.168.0.109/Data";
#endif
static char url[200], path[800];
static int portNumber=80;
static char portNumberString[40];

class SensorData {
public:
 float ax,ay,az; //Beschleunigung
 float gx,gy,gz; //Gyroskop
 float rx,ry,rz; //Rotation
 unsigned long zeit; //Zeit auf dem Controller in Millisekunden seit Start
 SensorData() {ax=ay=az=0; gx=gy=gz=0; rx=ry=rz=0; zeit=0;}
};

int httpclient_start();
int httpclient_read_data(SensorData &data);
void httpclient_stop();

int main(int argc, char**argv)
{
 int err=0;
 SensorData data;
 
 if(argc==3) //eventuell Argumente auswerten
  {
   if(strlen(argv[1])>=800) {printf("Error: string too long\n"); exit(1);}
   defaultaddress = argv[1];
   //allfaelliges http:// oder https:// weglassen:
   if(strstr(defaultaddress, "http://") != NULL) {defaultaddress = defaultaddress + 7;}
   else if (strstr(defaultaddress, "https://") != NULL) {defaultaddress = defaultaddress + 8;}
   portNumber = atoi(argv[2]);
   if(portNumber > 65536 || portNumber < 0) {printf("Invalid Port Number!"); exit(1);}
  }
 else if(argc>1)
  {
   printf("usage example: %s %s 80\n", argv[0], defaultaddress);
   return 0;
  }
 //Aufspalten der Adresse in url und path, z.B. "192.168.4.1" und "/Data"
 const char *s=defaultaddress;
 char *t=url;
 while(*s!=0 && *s!='/') {*t++ = *s++;}
 *t=0; //abschliessendes 0-Byte von url
 strcpy(path,s);
 sprintf(portNumberString,"%d",portNumber);
#ifdef DEBUG
 printf("url: %s\n",url);
 printf("path: %s\n",path);
 printf("portnr: %s\n",portNumberString);
#endif

 //test ob WLAN eingeschaltet ist und nano-rp2040 erreichbar:
 char pingstring[80]; sprintf(pingstring,"ping %s -W 5 -c1",url);
 printf("pingstring=\"%s\"\n",pingstring);//test
 int ret=system(pingstring);
 if(ret!=0)
  {
   printf("ping() --> ret=%d\n",ret);//test
   printf("zuerst WLAN einschalten und mit nano-rp2040 verbinden\n");
   exit(1);
  }
 usleep(500000); //test
 
 unsigned long zeitvorher=0, zeitdiff=0, maxdiff=0, mindiff=10000;
 int maxi=500; //Anzahl Lesezyklen, TODO: ev. beim Aufruf definieren
 unsigned long zeitdiff_summe=0; //fuer Statistik
 for(int i=0; err==0 && i<=maxi;)
  {
   err=httpclient_start();
   if(err) {printf("httpclient_start() err=%d\n",err); break;}
   err=httpclient_read_data(data);
   httpclient_stop();
   if(err) //bei Fehler: err ausdrucken, 10 Sek warten, weiter versuchen
    {printf("i=%d err=%d\n",i,err); sleep(10); err=0; continue;}
   zeitdiff = data.zeit - zeitvorher;
   printf("i=%d  Zeit: %ld ms  (Diff: %ld)\n", i, data.zeit, zeitdiff);
   if(i!=0)
    {
     zeitdiff_summe += zeitdiff; //fuer Statistik
     if(zeitdiff>maxdiff) maxdiff=zeitdiff;
     if(zeitdiff<mindiff) mindiff=zeitdiff;
    }
   zeitvorher=data.zeit;
   printf("Beschleunigung (x,y,z): %f %f %f\n", data.ax, data.ay, data.az);
   printf("Gyroskop (in Grad/Sec): %f %f %f\n", data.gx, data.gy, data.gz);
   printf("Rotations-Werte (Grad): %f %f %f\n", data.rx, data.ry, data.rz);
   i++;
  }
 printf("httpclient.cc beendet. err=%d\n",err);//test
 printf("mindiff=%ld maxdiff=%ld Durchschnitt=%ld\n",
	mindiff, maxdiff, zeitdiff_summe/maxi);
 return 0;
}

//#include <arpa/inet.h>

unsigned int myinet_addr(const char *url)
{
 //auf Zahlen beschraenkt, Vermeidung von <arpa/inet.h>
 unsigned int c1,c2,c3,c4;
 sscanf(url,"%d.%d.%d.%d",&c1,&c2,&c3,&c4);
 return (c4<<24)|(c3<<16)|(c2<<8)|c1;
}

#define BUF_SIZE 1024
static int sockfd;
static char buffer[BUF_SIZE]; 

int get_request(char *url, const char *port);

int mehrfach_read(int fd,char *buf,int n)
{
 int ret;
 for(int j=0; j < BUF_SIZE-1 && (ret=read(fd, &buf[j], n)) > 0;)
  {
   j += ret;
   if(j>2 && buf[j-1]=='\n' && (buf[j-2]=='\n' || buf[j-3]=='\n'))
    {return j;}//fertig wenn Leerzeile gelesen
   n=1; //beim naechsten Durchlauf 1 weiteres Byte lesen
  }
 return -1;//Fehler wenn keine Leerzeile gefunden
}

int httpclient_start() //bei Erfolg rueckgabe von 0, sonst Fehlernummer
{
 int ret; 
 const char http_ok[] = "HTTP/1.0 200 OK";
 
 sockfd = get_request(url, portNumberString);
 memset(&buffer, 0, BUF_SIZE);
 ret = mehrfach_read(sockfd, buffer, sizeof(http_ok)+2);
 if(ret<0) {printf("Error receiving HTTP status!\n"); return 2;}
#ifdef DEBUG
 printf("Header %d Bytes gelesen, buffer=\"%s\"\n", ret, buffer);//test
#endif
 if(strstr(buffer, http_ok) == NULL)
  {close(sockfd); printf("Error HTTP status!\n"); return 3;}
 //send(sockfd, "OK", 2, 0); //fuer Variante mit Bestaetigung nach Header
 return 0;
}

int pars_data(char *buffer, SensorData &data);

int httpclient_read_data(SensorData &data)
{
 int err=0;
 memset(&buffer, 0, BUF_SIZE);
 int size=BUF_SIZE;
 for(int ret,j=0; (ret = read(sockfd, &buffer[j], size)) > 0;)
  {
   if(strstr(buffer,"\n\r\n")!=NULL || strstr(buffer,"\n\n")!=NULL)
      {break;}//fertig wenn Leerzeile erkannt
   j += ret;
   size -= ret; if(size <= 1) {break;}
  }
 err=pars_data(buffer, data);
 if(err) printf("Fehler in pars_data() buffer=\n\"%s\"\n",buffer);
 send(sockfd, "OK", 2, 0); //? etwas anderes oder nichts senden falls err!=0 ?
 return err;
}

void httpclient_stop()
{
 close(sockfd);
}

int get_request(char *url, const char *port)
{
 int sockfd;
 char getrequest[1024];
 struct sockaddr_in addr;
 
 sprintf(getrequest, "GET %s HTTP/1.0\nHOST: %s\n\n", path, url);
#ifdef DEBUG
 printf("getrequest=\"%s\"\n",getrequest);//test
#endif

 // creates a socket to the host
 sockfd = socket(AF_INET, SOCK_STREAM, 0);
 if(sockfd < 0) {printf("Error creating socket!\n"); exit(1);}
#ifdef DEBUG
 printf("Socket created...\n");
#endif
 
 memset(&addr, 0, sizeof(addr));  
 addr.sin_family = AF_INET;
 //addr.sin_addr.s_addr = inet_addr(url);
 addr.sin_addr.s_addr = myinet_addr(url);
 addr.sin_port = htons(atoi(port));

#ifdef DEBUG
 printf("starte connect(sockfd ...)\n");//test
#endif
 if(connect(sockfd, (struct sockaddr *) &addr, sizeof(addr)) < 0 ) {
  printf("Connection Error!\n");
  exit(1);
 }
#ifdef DEBUG
 printf("Connection successful...\n\n");
#endif
 // writes the HTTP GET Request to the sockfd
#ifdef DEBUG
 printf("starte write(sockfd, getrequest ...)\n");//test
#endif
 write(sockfd, getrequest, strlen(getrequest));
 return sockfd;
}

int pars_data(char *buffer, SensorData &data)
{
 const char *st;
 st = strstr(buffer,"Tim:");
 if(st!=NULL)
  {//wenn die Zeit uebermittelt wurde
   sscanf(&st[4],"%ld",&data.zeit);
  }
 st = strstr(buffer,"Acc:");
 if(st==NULL) {printf("Fehler: buffer=\"%s\"\n",buffer); return 1;}
 sscanf(&st[4],"%f %f %f\n", &data.ax, &data.ay, &data.az);
 st = strstr(st,"Gyr:"); if(st==NULL) return 2;
 sscanf(&st[4],"%f %f %f\n", &data.gx, &data.gy, &data.gz);
 st = strstr(st,"Rot:"); if(st==NULL) return 3;
 int n=sscanf(&st[4],"%f %f %f\n", &data.rx, &data.ry, &data.rz);
 if(n!=3) {printf("Fehler: fehlende Daten.\n"); return 4;}
 return 0;
}
