//texturen.h

//#include libs/stb_image.h //schon in main.cpp gemacht

class Textur {
public:
 GLuint id;
 uint32 num;
 char name[120];
};

std::vector<Textur> texturen;
uint32 numTexturen=0;

uint32 texturen_laden(const char *bildname)
{
 GLuint textureId=0;
 const char *neuname;
 if((neuname=myindex(bildname,'/'))!=NULL) bildname= &neuname[1];
 for(uint32 i=0;i<numTexturen;i++)
  {
   if(strcmp(bildname,texturen[i].name)==0)
    {
     textureId=texturen[i].id; texturen[i].num++;
#ifdef _DEBUG
     printf("Textur %s bisher %d mal verwendet\n",texturen[i].name,texturen[i].num);//test
#endif
     return textureId;
    }
  }
 int32 textureWidth = 0;
 int32 textureHeight = 0;
 int32 bitsPerPixel = 0;
 char namemitpfad[200];
 sprintf(namemitpfad,"texturen/%s",bildname);
 stbi_set_flip_vertically_on_load(true);
 //auto textureBuffer = stbi_load(bildname, &textureWidth, &textureHeight, &bitsPerPixel, 4);
 unsigned char *textureBuffer = stbi_load(namemitpfad, &textureWidth, &textureHeight, &bitsPerPixel, 4);
 if(textureBuffer==NULL)
  {
   sprintf(namemitpfad,"karten/%s",bildname);
   textureBuffer = stbi_load(namemitpfad, &textureWidth, &textureHeight, &bitsPerPixel, 4);
   if(textureBuffer==NULL)
    {
     printf("Error: stbi_load(%s, ...) cant load\n",bildname);
     return 0;
    }
  }
#ifdef _DEBUG
 printf("Textur %s eingelesen\n",bildname);//test
 //for(int i=0;i<10;i++) printf(" %d",textureBuffer[i]);//test
 //printf(" ...\n");//test
#endif

 GLCALL(glGenTextures(1, &textureId));
 GLCALL(glBindTexture(GL_TEXTURE_2D, textureId));
 GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR));
 //GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)); //Pixeleffekt
 GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)); //Grosse Pixel interpoliert
 
 if(strncmp(bildname,"karte",5)==0)
  {
   GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE)); //am Rand der Textur abschneiden
   GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE));
  }
 else
  {
   GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_MIRRORED_REPEAT));
   GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_MIRRORED_REPEAT));
   //GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_R, GL_REPEAT)); //offenbar nicht gebraucht
  }
 GLCALL(glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, textureWidth, textureHeight, 0, GL_RGBA, GL_UNSIGNED_BYTE, textureBuffer));
 GLCALL(glBindTexture(GL_TEXTURE_2D, 0)); //unbind

 if(textureBuffer) {stbi_image_free(textureBuffer);}
 Textur te;
 te.id=textureId;
 te.num=1;
 strncpy(te.name,bildname,120);
 texturen.push_back(te);
 numTexturen++;
#ifdef _DEBUG
 printf("texturen_laden(%s)  textureId=%d\n",bildname,textureId);//test
#endif
 return textureId;
}

void texturen_freigeben()
{
 //GLCALL(glDeleteTextures(1, &textureId)); //TODO: mehrere Texturen freigeben
 for(uint32 i=0; i<texturen.size(); i++)
  {
   GLCALL(glDeleteTextures(1, &texturen[i].id));
  }
 texturen.clear();
}

class Kartentabelle
{
public:
 char name[120];
 float lonmin,latmin; //GPS-Koordinaten links unten (suedwesten)
 float lonmax,latmax; //GPS-Koordinaten rechts oben (nordosten)
 //lon entspricht x-Koordinate, lat entspricht -z-Koordinate)
};

//TODO: einlesen von Datei kartentabelle.txt
#define ANZDEFAULTKARTEN 8
Kartentabelle defaultkartentabelle[ANZDEFAULTKARTEN]={
 "karte1.jpg",         8.59756, 47.35782, 8.62483, 47.37585,
 "karteadlisberg.jpg", 8.57338, 47.34042, 8.62836, 47.37670,
 "karteeinsiedeln25.jpg", 8.73017, 47.12265, 8.79877, 47.16788,
 "karteforch25.jpg",      8.60270, 47.32302, 8.67143, 47.36834,
 "kartealbishorn25.jpg",  8.50832, 47.23277, 8.57692, 47.27824,
 "karteuetliberg25.jpg",  8.46408, 47.32787, 8.53255, 47.37311,
 "karteraster10_1091-3.jpg", 8.39770, 47.32488, 8.51452, 47.377822, 
 "karteraster25_1091.jpg", 8.39770, 47.32488, 8.63158, 47.43064,
};
std::vector<Kartentabelle> kartentabelle;
int numKarten=0;
int kartenj=0;
float Kxmin=0, Kxmax=0, Kymin=0, Kymax=0;

uint32 karte_laden(const char *bildname)
{
 bildname = ohnepfad(bildname);
 if(numKarten==0)
  {
   FILE *fp=fopen("kartentabelle.txt","r");
   if(fp==NULL)
    {
     printf("fehlende Datei kartentabelle.txt - Defaultwerte verwendet\n");
     for(int i=0;i<ANZDEFAULTKARTEN;i++)
      {
       kartentabelle.push_back(defaultkartentabelle[i]);
       numKarten++;
      }
    }
   else
    {
     char zeile[400];
     int n;
     while(getline(fp,zeile,400))
      {
       Kartentabelle neu;
       if(!isalpha(*zeile)) continue; //Kommentar ignorieren
       n=sscanf(zeile,"%s %f%*c%f%*c%f%*c%f",
	        neu.name, &neu.lonmin, &neu.latmin, &neu.lonmax, &neu.latmax);
       if(n!=5) {printf("Fehler: %s\n",zeile); continue;} //TODO: falsche Zeile
       kartentabelle.push_back(neu);
       numKarten++;
      }
     fclose(fp);
    }
  }
 for(kartenj=0;kartenj<numKarten;kartenj++)
  {if(strcmp(bildname,kartentabelle[kartenj].name)==0) break;}
 if(kartenj==numKarten)
  {printf("Fehler: fehlende Koordinaten fuer \"%s\" in kartentabelle.txt\n",bildname);
   return 0;
  }
#ifdef _DEBUG
 printf("karte_laden(%s) kartenj=%d\n",bildname,kartenj);//test
#endif
 Kxmin = kartentabelle[kartenj].lonmin;
 Kxmax = kartentabelle[kartenj].lonmax;
 Kymin = kartentabelle[kartenj].latmin;
 Kymax = kartentabelle[kartenj].latmax;
 return texturen_laden(bildname);
}
