#pragma once
#include <GL/glew.h>
#include "defines.h"

struct VertexBuffer {
 VertexBuffer(void* data, uint32 numVertices) {init(data,numVertices);}
 void init(void* data, uint32 numVertices) {
  glGenVertexArrays(1, &vao);
  glBindVertexArray(vao);
  glGenBuffers(1, &bufferId);
  glBindBuffer(GL_ARRAY_BUFFER, bufferId);
  glBufferData(GL_ARRAY_BUFFER, numVertices * sizeof(Vertex), data, GL_STATIC_DRAW);

  glEnableVertexAttribArray(0);
  glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), (void*)offsetof(struct Vertex, position));
  glEnableVertexAttribArray(1);
  glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), (void*)offsetof(struct Vertex, normal));

  glEnableVertexAttribArray(2); //fuer Texturekoordinaten
  glVertexAttribPointer(2, 2, GL_FLOAT, GL_FALSE, sizeof(Vertex), (void*)offsetof(struct Vertex, uv));

  glBindVertexArray(0);
 }

 virtual ~VertexBuffer() {
  glDeleteBuffers(1, &bufferId);
  glDeleteVertexArrays(1, &vao);
 }

 void animate(void* data, uint32 numVertices) {
  //TODO: einfacher machbar?
  glDeleteBuffers(1, &bufferId);
  init(data,numVertices);
 }

 void bind() {
  glBindVertexArray(vao);
 }

 void unbind() {
  glBindVertexArray(0);
 }
private:
 GLuint bufferId;
 GLuint vao;
};
