// defines.h  Grundlegende Definitionen
#pragma once
#include <cstdint>
#include <string>
#include "libs/glm/glm.hpp"

#ifdef _WIN32
// Warnungen fuer sscanf() ignorieren:
#pragma warning(disable : 4996)
#pragma warning(disable : 4267)
#pragma warning(disable : 4305)
#pragma warning(disable : 4244)

#else
// Standard-Include-Dateien die es in Windows nicht gibt:
#include <unistd.h>
#include <strings.h>
#endif

typedef int8_t int8;
typedef int16_t int16;
typedef int32_t int32;
typedef int64_t int64;
typedef uint8_t uint8;
typedef uint16_t uint16;
typedef uint32_t uint32;
typedef uint64_t uint64;
typedef float float32;
typedef double float64;
#define Vec3 glm::vec3
#define ROTATEY glm::rotateY

struct Uvs {
 float x,y;
};

struct Vertex {
 glm::vec3 position;
 glm::vec3 normal;
 Uvs uv; //uv.x und uv.y  textur-Koordinaten
 void setPosition(float32 x,float32 y,float32 z) {position={x,y,z};}
 void setNormal(glm::vec3 v) {normal=v;}
 void setoffset(float32 x,float32 y,float32 z) {
  position.x += x;
  position.y += y;
  position.z += z;
 }
 void rotateXgrad(float32 winkel_in_grad);
 void rotateYgrad(float32 winkel_in_grad);
 void rotateZgrad(float32 winkel_in_grad);
 void scale(float32 scalefact) {
  position.x *= scalefact;
  position.y *= scalefact;
  position.z *= scalefact;
 }
};

extern const char* myindex(const char* s, int c);
extern void mystrncpy(char* dest, const char* src, int max);
extern FILE *myfopen(const char *filename, const char *rw);

const float MICRO=0.000001f;
const float ERDBESCHLEUNIGUNG=9.80665f; //in m/s^2
