/* main.cpp  nach OpenGLTutorial nachprogrammiert
die folgenden zwei Pakete muessen installiert sein:
 libsdl2-dev
 libglew-dev

Dem Tutorial bisher bis Ende #033 gefolgt
(ohne GLCALL verwenden, in #031 Modelexporter uebersprungen (bis 26:40))
Statt dem modelexporter einen eigenen geschrieben "tools/stlmodelexporter.cc"
um Modelle von freecad einzulesen (.stl-Dateien).
*/

/****** Sachen zum Debuggen: ******/
//#define SHADERS_OLD //fuer aeltere Grafikkarten: Version 1.20 (sonst 3.30)
// geht mit Version 3.3 mit Linux auf dem Laptop wenn so gestartet:
// MESA_GL_VERSION_OVERRIDE=3.3 MESA_GLSL_VERSION_OVERRIDE=330 ./main
// oder die folgenden 2 Zeilen definieren:
#define MESA_GL_VERSION_OVERRIDE   "3.3"
#define MESA_GLSL_VERSION_OVERRIDE "330"

//#define _DEBUG  //bei Bedarf im makefile definiert

/* Debuggen auf Linux:
gdb ./main
(gdb) run
*/

/****** Fenstergroesse einstellen: ******/
//#define MONITOR4K  //fuer doppelte Aufloesung zu FullHD

#ifdef MONITOR4K
#define FENSTERBREITE 2400
#define FENSTERHOEHE 1800
#else
#define FENSTERBREITE 1200
#define FENSTERHOEHE 900
#endif

//#define AFFE //BMF-Datei von Monkey verwenden, sonst eigenes Modell
#define TREE //Baum

#include <iostream>
#include <vector>
#include <fstream>
#define GLEW_STATIC
#include <GL/glew.h>
#define SDL_MAIN_HANDLED

#define STB_IMAGE_IMPLEMENTATION
#include "libs/stb_image.h"

#ifdef _WIN32
#include <SDL.h>
#pragma comment(lib, "SDL2.lib")
#pragma comment(lib, "glew32s.lib")
#pragma comment(lib, "opengl32.lib")
#else
#include <SDL2/SDL.h>
#endif
#include <math.h> //schon von SDL.h gemacht?

#include "defines.h"
#include "vertex_buffer.h"
#include "index_buffer.h"
#include "shader.h"
#include "floating_camera.h"
#include "mesh.h"

#ifdef _DEBUG
void openGLDebugCallback(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar* message, const void* userParam)
{
 if(severity==GL_DEBUG_SEVERITY_HIGH)
  {
   std::cout << "[OpenGL Error] " << message << std::endl;
  }
 else if(severity==GL_DEBUG_SEVERITY_MEDIUM)
  {
   std::cout << "[OpenGL Warning] " << message << std::endl;
  }
 else
  {
   std::cout << "[OpenGL Message] " << message << std::endl;
  }
}
#endif

int main(int arg, char** argv)
{
#ifdef   MESA_GL_VERSION_OVERRIDE
 setenv("MESA_GL_VERSION_OVERRIDE",MESA_GL_VERSION_OVERRIDE,1);
#endif
#ifdef   MESA_GLSL_VERSION_OVERRIDE
 setenv("MESA_GLSL_VERSION_OVERRIDE",MESA_GLSL_VERSION_OVERRIDE,1);
#endif

	SDL_Window* window;
	SDL_Init(SDL_INIT_EVERYTHING);
	SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 8);
	SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 8);
	SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 8);
	SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
	SDL_GL_SetSwapInterval(1);
	
	uint32 flags = SDL_WINDOW_OPENGL;
	//uint32 flags = SDL_WINDOW_OPENGL | SDL_WINDOW_BORDERLESS; //mit Alt F4 stoppen!
	//uint32 flags = SDL_WINDOW_OPENGL | SDL_WINDOW_FULLSCREEN_DESKTOP; //mit Alt F4 stoppen!
	
	window = SDL_CreateWindow("C++ OpenGL Tutorial", SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED,
				  FENSTERBREITE, FENSTERHOEHE, flags);
	SDL_GLContext glContext = SDL_GL_CreateContext(window);
	GLenum err = glewInit();
	if(err != GLEW_OK)
	 {
	  std::cout << "glewInit Error: " << glewGetErrorString(err) << std::endl;
	  //std::cin.get();
	  return -1;
	 }
	std::cout << "OpenGL version: " << glGetString(GL_VERSION) << std::endl;
	
#ifdef _DEBUG
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_FLAGS, SDL_GL_CONTEXT_DEBUG_FLAG);
	glEnable(GL_DEBUG_OUTPUT);
	glEnable(GL_DEBUG_OUTPUT_SYNCHRONOUS);
	glDebugMessageCallback(openGLDebugCallback, 0);
#endif

	Shader shader("shaders/basic.vs", "shaders/basic.fs");
	shader.bind();
	
	//Richtungslicht:
	int directionLocation = glGetUniformLocation(shader.getShaderId(), "u_directional_light.direction");
	int diffuseLocation = glGetUniformLocation(shader.getShaderId(), "u_directional_light.diffuse");
	int specularLocation = glGetUniformLocation(shader.getShaderId(), "u_directional_light.specular");
	int ambientLocation = glGetUniformLocation(shader.getShaderId(), "u_directional_light.ambient");
	//glm::vec3 sunColor = glm::vec3(0.8f);
	glm::vec3 sunColor = glm::vec3(0.0f); //test
	glm::vec3 sunDirection = glm::vec3(-1.0f);
	glUniform3fv(diffuseLocation, 1, (float*)&sunColor);
	glUniform3fv(specularLocation, 1, (float*)&sunColor);
	glm::vec3 sunAmbient = sunColor * 0.4f;
	glUniform3fv(ambientLocation, 1, (float*)&sunAmbient);
	
	//Punktlicht:
	//glm::vec3 pointLightColor = glm::vec3(0.0f, 0.0f, 1.0f); //blaues Punktlicht
	glm::vec3 pointLightColor = glm::vec3(0.0f, 0.0f, 0.0f); //test
	int id=shader.getShaderId(); 
	glUniform3fv(glGetUniformLocation(id, "u_point_light.diffuse"), 1, (float*)&pointLightColor);
	glUniform3fv(glGetUniformLocation(id, "u_point_light.specular"), 1, (float*)&pointLightColor);
	glm::vec3 pointAmbient = pointLightColor * 0.2f;
	glUniform3fv(glGetUniformLocation(id, "u_point_light.ambient"), 1, (float*)&pointAmbient);
	glUniform1f(glGetUniformLocation(id, "u_point_light.linear"), 0.027f);
	glUniform1f(glGetUniformLocation(id, "u_point_light.quadratic"), 0.0028f);
	glm::vec4 pointLightPosition = glm::vec4(0.0f, 0.0f, 10.0f, 1.0f);
	int posLocation = glGetUniformLocation(id, "u_point_light.position");
	
	//Spotlicht:
	glm::vec3 spotLightColor = glm::vec3(1.0f);
	glUniform3fv(glGetUniformLocation(id, "u_spot_light.diffuse"), 1, (float*)&spotLightColor);
	glUniform3fv(glGetUniformLocation(id, "u_spot_light.specular"), 1, (float*)&spotLightColor);
	glm::vec3 spotAmbient = spotLightColor * 0.2f;
	glUniform3fv(glGetUniformLocation(id, "u_spot_light.ambient"), 1, (float*)&spotAmbient);
	glm::vec3 spotPosition = glm::vec3(0.0f);
	int spotPosLocation = glGetUniformLocation(id, "u_spot_light.position");
	glUniform3fv(spotPosLocation, 1, (float*)&spotPosition);
	glm::vec3 spotDirection = glm::vec3(0.0f, 0.0f, 1.0f);
	int spotDirLocation = glGetUniformLocation(id, "u_spot_light.direction");
	glUniform3fv(spotDirLocation, 1, (float*)&spotDirection);
	glUniform1f(glGetUniformLocation(id, "u_spot_light.innerCone"), 0.95f); //grosser Wert = kleiner Winkel (cos)
	glUniform1f(glGetUniformLocation(id, "u_spot_light.outerCone"), 0.85f);
	
	Model monkey;
#ifdef AFFE
	monkey.init("models/monkey.bmf", &shader); //von Pilzschaf aus Blender
#else
 #ifdef TREE
	monkey.init("models/tree.bmf", &shader); //Baum aus einer offenen Bibliothek
 #else
	monkey.init("models/figur.bmf", &shader); //eigene Figur
 #endif	
#endif	

	SDL_GL_SetSwapInterval(1); //warte jeweils auf VSYNC (funktioniert nicht immer korrekt)
	//glPolygonMode(GL_FRONT_AND_BACK, GL_LINE); //nur Drahtgitter zeichnen

	uint64 perfCounterFrequency = SDL_GetPerformanceFrequency();
	uint64 lastCounter = SDL_GetPerformanceCounter();
	float32 delta = 0;

	glm::mat4 model = glm::mat4(1.0f);
#ifdef TREE
	model = glm::scale(model, glm::vec3(0.1f));
	printf("model mit 0.1 skaliert\n");//test
#endif
	
	//FloatingCamera camera(90.0f, 1000.0f, 800.0f);
	float hoehezuBreite = FENSTERHOEHE/float(FENSTERBREITE);
	FloatingCamera camera(90.0f, 1000.0f, 1000.0f*hoehezuBreite);
	camera.translate(glm::vec3(0.0f, 0.0f, 5.0f));
	camera.update();
	glm::mat4 modelViewProj = camera.getViewProj() * model;

	int modelViewProjMatrixLocation = glGetUniformLocation(shader.getShaderId(), "u_modelViewProj");
	int modelViewLocation = glGetUniformLocation(shader.getShaderId(), "u_modelView");
	int invModelViewLocation = glGetUniformLocation(shader.getShaderId(), "u_invModelView");

	float cameraSpeed = 6.0f;
	float32 time=0;
	bool close = false;
	bool buttonw=false,buttona=false,buttons=false,buttond=false;
	bool buttonSpace=false,buttonShift=false;
	static int escapeflag=0;
	SDL_SetRelativeMouseMode(SDL_TRUE);
	glEnable(GL_CULL_FACE);
	//glFrontFace(GL_CW); //test CW oder CCW (CCW=default)
	glEnable(GL_DEPTH_TEST);
	while(!close)
	{
	 SDL_Event event;
	 while(SDL_PollEvent(&event))
	  {
	   if(event.type == SDL_QUIT) {close = true;}
	   else if(event.type==SDL_KEYDOWN)
	    {
	     if(event.key.keysym.mod & (KMOD_LALT|KMOD_RALT|KMOD_ALT))
	      {
	       int taste=event.key.keysym.sym;
	       if(taste=='q') {printf("ALT q gedrueckt\n"); close=true;}
	       //if(taste>' ' && taste<='z') printf("Taste %c mit Linker Alt-Taste gedrueckt\n",taste);//test
	       //else printf("Taste 0x%02X mit Linker Alt-Taste gedrueckt\n",taste);//test
	      }
	     else
	      {
	       switch(event.key.keysym.sym)
		{
		 case SDLK_w: buttonw=true; break;
		 case SDLK_a: buttona=true; break;
		 case SDLK_s: buttons=true; break;
		 case SDLK_d: buttond=true; break;
		 case SDLK_SPACE: buttonSpace=true; break;
		 case SDLK_LSHIFT: buttonShift=true; break;
		 case SDLK_ESCAPE:
		  escapeflag ^= 1;
		  SDL_SetRelativeMouseMode((escapeflag==0)?SDL_TRUE:SDL_FALSE);
		  break;
		}
	      }
	    }
	   else if(event.type==SDL_KEYUP)
	    {
	     switch(event.key.keysym.sym)
	      {
	       case SDLK_w: buttonw=false; break;
	       case SDLK_a: buttona=false; break;
	       case SDLK_s: buttons=false; break;
	       case SDLK_d: buttond=false; break;
	       case SDLK_SPACE: buttonSpace=false; break;
	       case SDLK_LSHIFT: buttonShift=false; break;		 
	      }
	    }
	   else if(event.type==SDL_MOUSEMOTION)
	    {
	     if(SDL_GetRelativeMouseMode())
	      camera.onMouseMoved(event.motion.xrel, event.motion.yrel);
	    }
	   else if(event.type==SDL_MOUSEBUTTONDOWN)
	    {
	     if(event.button.button==SDL_BUTTON_LEFT)
	      {escapeflag=0; SDL_SetRelativeMouseMode(SDL_TRUE);}
	    }
	   //else printf("event.type=%d\n",event.type);//test
	  }
	 
	 glClearColor(0, 0, 0, 1.0); //schwarzer Hintergrund
	 glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	 time += delta;
	 if(buttonw) {camera.moveFront(delta * cameraSpeed);}
	 if(buttons) {camera.moveFront(-delta * cameraSpeed);}
	 if(buttona) {camera.moveSideways(-delta * cameraSpeed);}
	 if(buttond) {camera.moveSideways(delta * cameraSpeed);}
	 if(buttonSpace) {camera.moveUp(delta * cameraSpeed);}
	 if(buttonShift) {camera.moveUp(-delta * cameraSpeed);}
	 
	 camera.update();
	 model = glm::rotate(model, 1.0f*delta, glm::vec3(0, 1, 0)); //Rotation um y-Achse
	 //model = glm::rotate(model, 1.0f*delta, glm::vec3(0, 0, 1)); //um z-Achse
	 modelViewProj = camera.getViewProj() * model;
	 glm::mat4 modelView = camera.getView() * model;
	 glm::mat4 invModelView = glm::transpose(glm::inverse(modelView));
	 
	 //Richtungslicht:
	 glm::vec4 transormedSunDirection = glm::transpose(glm::inverse(camera.getView())) * glm::vec4(sunDirection, 1.0f);
	 glUniform3fv(directionLocation, 1, (float*)&transormedSunDirection);
	 
	 //Punktlicht:
	 glm::mat4 pointLightMatrix = glm::rotate(glm::mat4(1.0f), -delta, {0.0f, 1.0f, 0.0f});
	 pointLightPosition = pointLightMatrix * pointLightPosition;
	 glm::vec3 transformedPointLightPosition = (glm::vec3)(camera.getView() * pointLightPosition);
	 glUniform3fv(posLocation, 1, (float*)&transformedPointLightPosition);

	 glUniformMatrix4fv(modelViewProjMatrixLocation, 1, GL_FALSE, &modelViewProj[0][0]); //zum Rotieren lassen
	 glUniformMatrix4fv(modelViewLocation, 1, GL_FALSE, &modelView[0][0]);
	 glUniformMatrix4fv(invModelViewLocation, 1, GL_FALSE, &invModelView[0][0]);
	 //glDrawElements(GL_TRIANGLES, numIndices, GL_INT, 0); //teste Fehlermeldung
	 //in mesh.h genommen: glDrawElements(GL_TRIANGLES, numIndices, GL_UNSIGNED_INT, 0);
	 
	 //Spotlicht:
	 //prov. mit Kamera mitbewegt

	 monkey.render();
	 
	 SDL_GL_SwapWindow(window);

	 uint64 endCounter = SDL_GetPerformanceCounter();
	 uint64 counterElapsed = endCounter - lastCounter;
	 delta = (float32)counterElapsed / (float32)perfCounterFrequency;
	 //uint32 fps = (uint32)(1.0 / delta); //Frames Pro Sekunde
	 //std::cout << " FPS: " << fps << "  \r";
	 lastCounter = endCounter;
	 //close=true;//test
	}
	std::cout << std::endl;
	return 0;
}
