/* wgs84convert.cc			letzte Aenderung: 24.3.2022 */
#define VERSION "Version 0.0"
/*
Umrechnung von WGS84-Koordinaten in Schweizer Projektionskoordinaten
und umgekehrt.

History:
24.3.2022       Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#ifndef PI
#define PI 3.14159265358979323846
#endif
#define ZWEIPI (2.*PI)
#define PIHALBE (0.5*PI)
#ifndef GRAD
#define GRAD (PI/180.)
#endif
#define WINKELSEK (GRAD/3600.0)

/************************* Vordeklarationen ***************************/
void swiss2wgs(double x0,double y0,double& x1,double& y1);
void wgs2swiss(double x0,double y0,double& x1,double& y1);

/************************* Globale Variablen **************************/
double ybeispiel=2.7e6, xbeispiel=1.1e6;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(const char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='B' &&*s!='2')
    {
     xbeispiel = 8.0+43.0/60+49.79/3600;
     ybeispiel = 46.0+2.0/60+38.87/3600;
    }
  }
}

/*************************** Kleinkram ********************************/
bool istja(const char *s)
{
 int c= *s;
 return (c=='j' || c=='J' || c=='y' || c=='Y');
}

void vertauschen(double& x,double& y)
{
 double h=x;
 x=y; y=h;
}

/************** Klassen und Hauptteil des Programms *******************/

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[400],zielname[400];
 //FILE *fp1,*fp2;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   j=0;
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG)
  {printf("wgs84convert  %s\n",VERSION);
   printf("Anwendung: wgs84convert [-Flags] xKoordinate yKoordinate\n");
   printf(" Beispiel: wgs84convert -v 8.59756 47.35782\n");
   printf("  Flags: v=verbose (gespraechig)\n");
   printf("         b=Beispiel von PDF-Dokument (46 02' 38.87''  8 43' 49.79'')\n");
   printf("         b2=Beispiel Rueckrechnung (2 699 999.76  1 099 999.97)\n");
   exit(0);
  }
 double xkoord=0,ykoord=0, xziel=0,yziel=0;
 if(argflag['B'])
  {
   xkoord=xbeispiel; ykoord=ybeispiel;
  }
 else
  {
   if(*quellname==0)
    {
     printf("x-Koordinate:"); scanf("%lf",&xkoord);
     printf("y-Koordinate:"); scanf("%lf",&ykoord);
    }
   else
    {
     if(!isdigit(quellname[0])) {printf("xKoordinate muss eine Zahl sein.\n"); exit(1);}//TODO
     sscanf(quellname,"%lf",&xkoord);
     if(!isdigit(zielname[0])) {printf("yKoordinate muss eine Zahl sein.\n"); exit(1);}//TODO
     sscanf(zielname,"%lf",&ykoord);
    }
  }
 if(ykoord<45.0 && xkoord>45.0) {vertauschen(xkoord,ykoord);}
 else if(ykoord>1e6 && ykoord<2e6 && xkoord>2e6) {vertauschen(xkoord,ykoord);}
 if(xkoord>90.0 && ykoord>90.0) swiss2wgs(xkoord,ykoord,xziel,yziel);
 else                           wgs2swiss(xkoord,ykoord,xziel,yziel);
 printf("Eingabe:  %f %f\n",xkoord,ykoord);
 printf("Resultat: %f %f\n",xziel,yziel);
 if(xziel<90 && yziel<90)
  {
   int grad=(int)xziel, min; double sec;
   min = (int)((xziel-grad)*60);
   sec = (((xziel-grad)*60)-min)*60;
   printf("%d %02d' %02.2f''  ",grad,min,sec);
   grad=(int)yziel;
   min = (int)((yziel-grad)*60);
   sec = (((yziel-grad)*60)-min)*60;
   printf("%d %02d' %02.2f''\n",grad,min,sec);
  }
 return 0;
}/* ende von main */

void wgs2swiss(double x0,double y0,double& x1,double& y1)
{
 double phi = y0*3600;
 double lamda = x0*3600;
 double phistrich = (phi-169028.66)/1e4;
 double lamdastrich = (lamda-26782.5)/1e4;
 if(argflag['V']) printf("phistrich=%f\n",phistrich);//test
 if(argflag['V']) printf("lamdastrich=%f\n",lamdastrich);//test
 double phis2=phistrich*phistrich;
 double phis3=phis2*phistrich;
 double lamdas2=lamdastrich*lamdastrich;
 double lamdas3=lamdas2*lamdastrich;
 y1 = 2600072.37
     + 211455.93*lamdastrich
     - 10938.51 *lamdastrich*phistrich
     - 0.36*lamdastrich*phis2
     - 44.54*lamdas3;
 //ym=y1-2e6;
 x1 = 1200147.07
     + 308807.95 * phistrich
     +   3745.25 * lamdas2
     +     76.63 * phis2
     -    194.56 * lamdas2*phistrich
     +    119.79 * phis3;
 //xm=x1-1e6;
}

void swiss2wgs(double x0,double y0,double& x1,double& y1)
{
 double ys = (y0-2.6e6)/1e6;
 double xs = (x0-1.2e6)/1e6;
 if(argflag['V']) printf("ys=%f\n",ys);//test
 if(argflag['V']) printf("xs=%f\n",xs);//test
 double xs2=xs*xs, xs3=xs2*xs;
 double ys2=ys*ys, ys3=ys2*ys;
 double ls,ps; //lamdastrich, phistrich
 ls =  2.6779094
     + 4.728982 * ys
     + 0.791484 * ys*xs
     + 0.1306   * ys*xs2
     - 0.0436   * ys3;
 ps = 16.9023892
     + 3.238272 * xs
     - 0.270978 * ys2
     - 0.002528 * xs2
     - 0.0447   * ys2*xs
     - 0.0140   * xs3;
 y1 = ls*100/36;
 x1 = ps*100/36;
}
