/* erstes Beispielprogramm fuer Parallelrechnung mit OpenCL und CUDA */

#include <stdio.h>
#include "beispiel1.h"

// Serielle Variante:
void quadrieren1(int *feld,int *ziel,int n)
{
 for(int i=0;i<n;i++)
  {
   ziel[i] = feld[i]*feld[i];
  }
}

// Varainte mit CPU-Threads:
#include <thread>

void quadr(int *feld,int *ziel,int i)
{
 ziel[i] = feld[i]*feld[i];
}

void quadrieren2(int *feld,int *ziel,int n)
{
 std::thread tr[n];
 for(int i=0;i<n-1;i++)
   tr[i]=std::thread(quadr,feld,ziel,i);
 quadr(feld,ziel,n-1);
 for(int i=0;i<n-1;i++)
   tr[i].join();
}

int main(int argc,char **argv)
{
 int i;
 int feld[32],zielfeld[32];
 int variante=0;
 if(argc>=2) sscanf(argv[1],"%d",&variante);
 for(i=0;i<32;i++)
  {             // Zu quadrierende Zahlen
   feld[i]=i+1; // ins Feld einfuellen.
  }
 if(variante<=1)
  {printf("Seriell auf CPU gerechnet:\n");
   quadrieren1(feld,zielfeld,32); //alle 32 Zahlen quadrieren
  }
 else if(variante==2)
  {printf("Mit CPU-Threads gerechnet:\n");
   quadrieren2(feld,zielfeld,32); //alle 32 Zahlen quadrieren
  }
 else if(variante==3)
  {printf("Auf Grafikkarte mit OpenCL gerechnet:\n");
   copy_to_device(feld,32);
   bool ok=opencl_kernel_compilieren("beispiel1_kernel.cc");
   if(!ok) {printf("Fehler3: opencl_kernel_compilieren() misslungen.\n"); exit(1);}
   quadrieren_opencl(feld,zielfeld,32);
   device_speicher_freigeben();
  }
 else //if(variante==4)
  {printf("Auf Grafikkarte mit CUDA gerechnet:\n");
   copy_to_device_cuda(feld,32);
   quadrieren_cuda(feld,zielfeld,32);
   device_speicher_freigeben_cuda();
  }
 for(i=0;i<32;i++) //Ergebnisse anzeigen
  {
   printf(" %d",zielfeld[i]);
  }
 printf("\n");
 //Ergebnisse ueberpruefen:
 bool ok=true;
 for(i=0;i<32;i++)
  if(zielfeld[i] != feld[i]*feld[i]) {ok=false; break;}
 if(ok) printf("Ergebnisse erfolgreich ueberprueft.\n");
 else printf("Fehlerhafte Ergebnisse!\n");
 return 0;
}
