/* CUDA Teil vom ersten Beispielprogramm
*/

#include <stdio.h>
#include "beispiel1.h"

__global__
void cuda_quadr(int *feld,int *ziel)
{
 int i = threadIdx.x;
 ziel[i] = feld[i]*feld[i];
}

int *d_feld=NULL, *d_ziel=NULL;

bool copy_to_device_cuda(const int *feld,int n)
{
 int size=n*sizeof(int);
 cudaMalloc((void**)&d_feld, size);
 cudaMalloc((void**)&d_ziel, size); if(d_ziel==NULL) return false;
 cudaMemcpy(d_feld,feld,size,cudaMemcpyHostToDevice);
 return true;
}

bool copy_from_device_cuda(int *ziel,int n)
{
 cudaMemcpy(ziel,d_ziel,n*sizeof(int),cudaMemcpyDeviceToHost);
 return true;
}

extern void quadrieren_cuda(const int *feld,int *ziel,int n)
{
 if(d_ziel==NULL)
  {
   if(!copy_to_device_cuda(feld,n))
     {printf("Fehler: copy_to_device_cuda() misslungen\n"); return;}
  }
 int nBlocks=1, threadsPerBlock=32;
 cuda_quadr<<<nBlocks,threadsPerBlock>>>(d_feld,d_ziel);
 cudaDeviceSynchronize(); //auf Beenden aller Threads warten
 copy_from_device_cuda(ziel,n);
}

extern void device_speicher_freigeben_cuda()
{
 cudaFree(d_ziel); d_ziel=NULL;
 cudaFree(d_feld); d_feld=NULL;
}
